/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.api.resourcenames.UntypedResourceName;
import com.google.common.base.Preconditions;
import com.google.logging.v2.BillingName;
import com.google.logging.v2.FolderName;
import com.google.logging.v2.OrganizationName;
import com.google.logging.v2.ProjectName;

public class ParentNameOneof
implements ResourceName {
    private final ResourceName resourceName;

    public ProjectName getProjectName() {
        if (this.resourceName instanceof ProjectName) {
            return (ProjectName)this.resourceName;
        }
        return null;
    }

    public OrganizationName getOrganizationName() {
        if (this.resourceName instanceof OrganizationName) {
            return (OrganizationName)this.resourceName;
        }
        return null;
    }

    public FolderName getFolderName() {
        if (this.resourceName instanceof FolderName) {
            return (FolderName)this.resourceName;
        }
        return null;
    }

    public BillingName getBillingName() {
        if (this.resourceName instanceof BillingName) {
            return (BillingName)this.resourceName;
        }
        return null;
    }

    public UntypedResourceName getUntypedResourceName() {
        if (this.resourceName instanceof UntypedResourceName) {
            return (UntypedResourceName)this.resourceName;
        }
        return null;
    }

    public ResourceName getResourceName() {
        return this.resourceName;
    }

    public ResourceNameType getType() {
        return this.getResourceName().getType();
    }

    private ParentNameOneof(ResourceName resourceName) {
        this.resourceName = (ResourceName)Preconditions.checkNotNull((Object)resourceName);
    }

    public static ParentNameOneof parse(String resourceNameString) {
        if (ProjectName.isParsableFrom(resourceNameString)) {
            return new ParentNameOneof(ProjectName.parse(resourceNameString));
        }
        if (OrganizationName.isParsableFrom(resourceNameString)) {
            return new ParentNameOneof(OrganizationName.parse(resourceNameString));
        }
        if (FolderName.isParsableFrom(resourceNameString)) {
            return new ParentNameOneof(FolderName.parse(resourceNameString));
        }
        if (BillingName.isParsableFrom(resourceNameString)) {
            return new ParentNameOneof(BillingName.parse(resourceNameString));
        }
        return new ParentNameOneof((ResourceName)UntypedResourceName.parse((String)resourceNameString));
    }

    public static ParentNameOneof from(ProjectName projectName) {
        return new ParentNameOneof(projectName);
    }

    public static ParentNameOneof from(OrganizationName organizationName) {
        return new ParentNameOneof(organizationName);
    }

    public static ParentNameOneof from(FolderName folderName) {
        return new ParentNameOneof(folderName);
    }

    public static ParentNameOneof from(BillingName billingName) {
        return new ParentNameOneof(billingName);
    }

    public static ParentNameOneof fromUntyped(UntypedResourceName untypedResourceName) {
        return new ParentNameOneof((ResourceName)untypedResourceName);
    }

    public String toString() {
        return this.getResourceName().toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ParentNameOneof) {
            ParentNameOneof that = (ParentNameOneof)o;
            return this.resourceName.equals(that.resourceName);
        }
        return false;
    }

    public int hashCode() {
        return this.resourceName.hashCode();
    }
}

