/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LogMetricName
implements ResourceName {
    private static final PathTemplate PROJECT_METRIC = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/metrics/{metric}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String metric;

    @Deprecated
    protected LogMetricName() {
        this.project = null;
        this.metric = null;
    }

    private LogMetricName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.metric = (String)Preconditions.checkNotNull((Object)builder.getMetric());
    }

    public String getProject() {
        return this.project;
    }

    public String getMetric() {
        return this.metric;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LogMetricName of(String project, String metric) {
        return LogMetricName.newBuilder().setProject(project).setMetric(metric).build();
    }

    public static String format(String project, String metric) {
        return LogMetricName.newBuilder().setProject(project).setMetric(metric).build().toString();
    }

    public static LogMetricName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_METRIC.validatedMatch(formattedString, "LogMetricName.parse: formattedString not in valid format");
        return LogMetricName.of((String)matchMap.get("project"), (String)matchMap.get("metric"));
    }

    public static List<LogMetricName> parseList(List<String> formattedStrings) {
        ArrayList<LogMetricName> list = new ArrayList<LogMetricName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LogMetricName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LogMetricName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LogMetricName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_METRIC.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LogMetricName logMetricName = this;
            synchronized (logMetricName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.metric != null) {
                        fieldMapBuilder.put((Object)"metric", (Object)this.metric);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_METRIC.instantiate(new String[]{"project", this.project, "metric", this.metric});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            LogMetricName that = (LogMetricName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.metric, that.metric);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.metric);
    }

    public static class Builder {
        private String project;
        private String metric;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getMetric() {
            return this.metric;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setMetric(String metric) {
            this.metric = metric;
            return this;
        }

        private Builder(LogMetricName logMetricName) {
            this.project = logMetricName.project;
            this.metric = logMetricName.metric;
        }

        public LogMetricName build() {
            return new LogMetricName(this);
        }
    }
}

