/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/logging/v2/logging_metrics.proto

package com.google.logging.v2;

/**
 *
 *
 * <pre>
 * Describes a logs-based metric. The value of the metric is the number of log
 * entries that match a logs filter in a given time interval.
 *
 * Logs-based metrics can also be used to extract values from logs and create a
 * distribution of the values. The distribution records the statistics of the
 * extracted values along with an optional histogram of the values as specified
 * by the bucket options.
 * </pre>
 *
 * Protobuf type {@code google.logging.v2.LogMetric}
 */
public final class LogMetric extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.logging.v2.LogMetric)
    LogMetricOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LogMetric.newBuilder() to construct.
  private LogMetric(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LogMetric() {
    name_ = "";
    description_ = "";
    filter_ = "";
    bucketName_ = "";
    valueExtractor_ = "";
    version_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LogMetric();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.logging.v2.LoggingMetricsProto
        .internal_static_google_logging_v2_LogMetric_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 7:
        return internalGetLabelExtractors();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.logging.v2.LoggingMetricsProto
        .internal_static_google_logging_v2_LogMetric_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.logging.v2.LogMetric.class, com.google.logging.v2.LogMetric.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Logging API version.
   * </pre>
   *
   * Protobuf enum {@code google.logging.v2.LogMetric.ApiVersion}
   */
  public enum ApiVersion implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Logging API v2.
     * </pre>
     *
     * <code>V2 = 0;</code>
     */
    V2(0),
    /**
     *
     *
     * <pre>
     * Logging API v1.
     * </pre>
     *
     * <code>V1 = 1;</code>
     */
    V1(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Logging API v2.
     * </pre>
     *
     * <code>V2 = 0;</code>
     */
    public static final int V2_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Logging API v1.
     * </pre>
     *
     * <code>V1 = 1;</code>
     */
    public static final int V1_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ApiVersion valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ApiVersion forNumber(int value) {
      switch (value) {
        case 0:
          return V2;
        case 1:
          return V1;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ApiVersion> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ApiVersion> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ApiVersion>() {
          public ApiVersion findValueByNumber(int number) {
            return ApiVersion.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.logging.v2.LogMetric.getDescriptor().getEnumTypes().get(0);
    }

    private static final ApiVersion[] VALUES = values();

    public static ApiVersion valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ApiVersion(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.logging.v2.LogMetric.ApiVersion)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The client-assigned metric identifier.
   * Examples: `"error_count"`, `"nginx/requests"`.
   *
   * Metric identifiers are limited to 100 characters and can include only the
   * following characters: `A-Z`, `a-z`, `0-9`, and the special characters
   * `_-.,+!*',()%/`. The forward-slash character (`/`) denotes a hierarchy of
   * name pieces, and it cannot be the first character of the name.
   *
   * This field is the `[METRIC_ID]` part of a metric resource name in the
   * format "projects/[PROJECT_ID]/metrics/[METRIC_ID]". Example: If the
   * resource name of a metric is
   * `"projects/my-project/metrics/nginx%2Frequests"`, this field's value is
   * `"nginx/requests"`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The client-assigned metric identifier.
   * Examples: `"error_count"`, `"nginx/requests"`.
   *
   * Metric identifiers are limited to 100 characters and can include only the
   * following characters: `A-Z`, `a-z`, `0-9`, and the special characters
   * `_-.,+!*',()%/`. The forward-slash character (`/`) denotes a hierarchy of
   * name pieces, and it cannot be the first character of the name.
   *
   * This field is the `[METRIC_ID]` part of a metric resource name in the
   * format "projects/[PROJECT_ID]/metrics/[METRIC_ID]". Example: If the
   * resource name of a metric is
   * `"projects/my-project/metrics/nginx%2Frequests"`, this field's value is
   * `"nginx/requests"`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A description of this metric, which is used in documentation.
   * The maximum length of the description is 8000 characters.
   * </pre>
   *
   * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A description of this metric, which is used in documentation.
   * The maximum length of the description is 8000 characters.
   * </pre>
   *
   * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * Required. An [advanced logs
   * filter](https://cloud.google.com/logging/docs/view/advanced_filters) which
   * is used to match log entries. Example:
   *
   *     "resource.type=gae_app AND severity&gt;=ERROR"
   *
   * The maximum length of the filter is 20000 characters.
   * </pre>
   *
   * <code>string filter = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. An [advanced logs
   * filter](https://cloud.google.com/logging/docs/view/advanced_filters) which
   * is used to match log entries. Example:
   *
   *     "resource.type=gae_app AND severity&gt;=ERROR"
   *
   * The maximum length of the filter is 20000 characters.
   * </pre>
   *
   * <code>string filter = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BUCKET_NAME_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bucketName_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The resource name of the Log Bucket that owns the Log Metric.
   * Only Log Buckets in projects are supported. The bucket has to be in the
   * same project as the metric.
   *
   * For example:
   *
   *   `projects/my-project/locations/global/buckets/my-bucket`
   *
   * If empty, then the Log Metric is considered a non-Bucket Log Metric.
   * </pre>
   *
   * <code>string bucket_name = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bucketName.
   */
  @java.lang.Override
  public java.lang.String getBucketName() {
    java.lang.Object ref = bucketName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bucketName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The resource name of the Log Bucket that owns the Log Metric.
   * Only Log Buckets in projects are supported. The bucket has to be in the
   * same project as the metric.
   *
   * For example:
   *
   *   `projects/my-project/locations/global/buckets/my-bucket`
   *
   * If empty, then the Log Metric is considered a non-Bucket Log Metric.
   * </pre>
   *
   * <code>string bucket_name = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for bucketName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBucketNameBytes() {
    java.lang.Object ref = bucketName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bucketName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISABLED_FIELD_NUMBER = 12;
  private boolean disabled_ = false;
  /**
   *
   *
   * <pre>
   * Optional. If set to True, then this metric is disabled and it does not
   * generate any points.
   * </pre>
   *
   * <code>bool disabled = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public boolean getDisabled() {
    return disabled_;
  }

  public static final int METRIC_DESCRIPTOR_FIELD_NUMBER = 5;
  private com.google.api.MetricDescriptor metricDescriptor_;
  /**
   *
   *
   * <pre>
   * Optional. The metric descriptor associated with the logs-based metric.
   * If unspecified, it uses a default metric descriptor with a DELTA metric
   * kind, INT64 value type, with no labels and a unit of "1". Such a metric
   * counts the number of log entries matching the `filter` expression.
   *
   * The `name`, `type`, and `description` fields in the `metric_descriptor`
   * are output only, and is constructed using the `name` and `description`
   * field in the LogMetric.
   *
   * To create a logs-based metric that records a distribution of log values, a
   * DELTA metric kind with a DISTRIBUTION value type must be used along with
   * a `value_extractor` expression in the LogMetric.
   *
   * Each label in the metric descriptor must have a matching label
   * name as the key and an extractor expression as the value in the
   * `label_extractors` map.
   *
   * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
   * be updated once initially configured. New labels can be added in the
   * `metric_descriptor`, but existing labels cannot be modified except for
   * their description.
   * </pre>
   *
   * <code>
   * .google.api.MetricDescriptor metric_descriptor = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the metricDescriptor field is set.
   */
  @java.lang.Override
  public boolean hasMetricDescriptor() {
    return metricDescriptor_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The metric descriptor associated with the logs-based metric.
   * If unspecified, it uses a default metric descriptor with a DELTA metric
   * kind, INT64 value type, with no labels and a unit of "1". Such a metric
   * counts the number of log entries matching the `filter` expression.
   *
   * The `name`, `type`, and `description` fields in the `metric_descriptor`
   * are output only, and is constructed using the `name` and `description`
   * field in the LogMetric.
   *
   * To create a logs-based metric that records a distribution of log values, a
   * DELTA metric kind with a DISTRIBUTION value type must be used along with
   * a `value_extractor` expression in the LogMetric.
   *
   * Each label in the metric descriptor must have a matching label
   * name as the key and an extractor expression as the value in the
   * `label_extractors` map.
   *
   * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
   * be updated once initially configured. New labels can be added in the
   * `metric_descriptor`, but existing labels cannot be modified except for
   * their description.
   * </pre>
   *
   * <code>
   * .google.api.MetricDescriptor metric_descriptor = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The metricDescriptor.
   */
  @java.lang.Override
  public com.google.api.MetricDescriptor getMetricDescriptor() {
    return metricDescriptor_ == null
        ? com.google.api.MetricDescriptor.getDefaultInstance()
        : metricDescriptor_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The metric descriptor associated with the logs-based metric.
   * If unspecified, it uses a default metric descriptor with a DELTA metric
   * kind, INT64 value type, with no labels and a unit of "1". Such a metric
   * counts the number of log entries matching the `filter` expression.
   *
   * The `name`, `type`, and `description` fields in the `metric_descriptor`
   * are output only, and is constructed using the `name` and `description`
   * field in the LogMetric.
   *
   * To create a logs-based metric that records a distribution of log values, a
   * DELTA metric kind with a DISTRIBUTION value type must be used along with
   * a `value_extractor` expression in the LogMetric.
   *
   * Each label in the metric descriptor must have a matching label
   * name as the key and an extractor expression as the value in the
   * `label_extractors` map.
   *
   * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
   * be updated once initially configured. New labels can be added in the
   * `metric_descriptor`, but existing labels cannot be modified except for
   * their description.
   * </pre>
   *
   * <code>
   * .google.api.MetricDescriptor metric_descriptor = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.api.MetricDescriptorOrBuilder getMetricDescriptorOrBuilder() {
    return metricDescriptor_ == null
        ? com.google.api.MetricDescriptor.getDefaultInstance()
        : metricDescriptor_;
  }

  public static final int VALUE_EXTRACTOR_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object valueExtractor_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A `value_extractor` is required when using a distribution
   * logs-based metric to extract the values to record from a log entry.
   * Two functions are supported for value extraction: `EXTRACT(field)` or
   * `REGEXP_EXTRACT(field, regex)`. The arguments are:
   *
   *   1. field: The name of the log entry field from which the value is to be
   *      extracted.
   *   2. regex: A regular expression using the Google RE2 syntax
   *      (https://github.com/google/re2/wiki/Syntax) with a single capture
   *      group to extract data from the specified log entry field. The value
   *      of the field is converted to a string before applying the regex.
   *      It is an error to specify a regex that does not include exactly one
   *      capture group.
   *
   * The result of the extraction must be convertible to a double type, as the
   * distribution always records double values. If either the extraction or
   * the conversion to double fails, then those values are not recorded in the
   * distribution.
   *
   * Example: `REGEXP_EXTRACT(jsonPayload.request, ".*quantity=(&#92;d+).*")`
   * </pre>
   *
   * <code>string value_extractor = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The valueExtractor.
   */
  @java.lang.Override
  public java.lang.String getValueExtractor() {
    java.lang.Object ref = valueExtractor_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      valueExtractor_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A `value_extractor` is required when using a distribution
   * logs-based metric to extract the values to record from a log entry.
   * Two functions are supported for value extraction: `EXTRACT(field)` or
   * `REGEXP_EXTRACT(field, regex)`. The arguments are:
   *
   *   1. field: The name of the log entry field from which the value is to be
   *      extracted.
   *   2. regex: A regular expression using the Google RE2 syntax
   *      (https://github.com/google/re2/wiki/Syntax) with a single capture
   *      group to extract data from the specified log entry field. The value
   *      of the field is converted to a string before applying the regex.
   *      It is an error to specify a regex that does not include exactly one
   *      capture group.
   *
   * The result of the extraction must be convertible to a double type, as the
   * distribution always records double values. If either the extraction or
   * the conversion to double fails, then those values are not recorded in the
   * distribution.
   *
   * Example: `REGEXP_EXTRACT(jsonPayload.request, ".*quantity=(&#92;d+).*")`
   * </pre>
   *
   * <code>string value_extractor = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for valueExtractor.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getValueExtractorBytes() {
    java.lang.Object ref = valueExtractor_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      valueExtractor_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABEL_EXTRACTORS_FIELD_NUMBER = 7;

  private static final class LabelExtractorsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.logging.v2.LoggingMetricsProto
                .internal_static_google_logging_v2_LogMetric_LabelExtractorsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labelExtractors_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetLabelExtractors() {
    if (labelExtractors_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          LabelExtractorsDefaultEntryHolder.defaultEntry);
    }
    return labelExtractors_;
  }

  public int getLabelExtractorsCount() {
    return internalGetLabelExtractors().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A map from a label key string to an extractor expression which is
   * used to extract data from a log entry field and assign as the label value.
   * Each label key specified in the LabelDescriptor must have an associated
   * extractor expression in this map. The syntax of the extractor expression
   * is the same as for the `value_extractor` field.
   *
   * The extracted value is converted to the type defined in the label
   * descriptor. If either the extraction or the type conversion fails,
   * the label will have a default value. The default value for a string
   * label is an empty string, for an integer label its 0, and for a boolean
   * label its `false`.
   *
   * Note that there are upper bounds on the maximum number of labels and the
   * number of active time series that are allowed in a project.
   * </pre>
   *
   * <code>map&lt;string, string&gt; label_extractors = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsLabelExtractors(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabelExtractors().getMap().containsKey(key);
  }
  /** Use {@link #getLabelExtractorsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabelExtractors() {
    return getLabelExtractorsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. A map from a label key string to an extractor expression which is
   * used to extract data from a log entry field and assign as the label value.
   * Each label key specified in the LabelDescriptor must have an associated
   * extractor expression in this map. The syntax of the extractor expression
   * is the same as for the `value_extractor` field.
   *
   * The extracted value is converted to the type defined in the label
   * descriptor. If either the extraction or the type conversion fails,
   * the label will have a default value. The default value for a string
   * label is an empty string, for an integer label its 0, and for a boolean
   * label its `false`.
   *
   * Note that there are upper bounds on the maximum number of labels and the
   * number of active time series that are allowed in a project.
   * </pre>
   *
   * <code>map&lt;string, string&gt; label_extractors = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelExtractorsMap() {
    return internalGetLabelExtractors().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. A map from a label key string to an extractor expression which is
   * used to extract data from a log entry field and assign as the label value.
   * Each label key specified in the LabelDescriptor must have an associated
   * extractor expression in this map. The syntax of the extractor expression
   * is the same as for the `value_extractor` field.
   *
   * The extracted value is converted to the type defined in the label
   * descriptor. If either the extraction or the type conversion fails,
   * the label will have a default value. The default value for a string
   * label is an empty string, for an integer label its 0, and for a boolean
   * label its `false`.
   *
   * Note that there are upper bounds on the maximum number of labels and the
   * number of active time series that are allowed in a project.
   * </pre>
   *
   * <code>map&lt;string, string&gt; label_extractors = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelExtractorsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabelExtractors().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. A map from a label key string to an extractor expression which is
   * used to extract data from a log entry field and assign as the label value.
   * Each label key specified in the LabelDescriptor must have an associated
   * extractor expression in this map. The syntax of the extractor expression
   * is the same as for the `value_extractor` field.
   *
   * The extracted value is converted to the type defined in the label
   * descriptor. If either the extraction or the type conversion fails,
   * the label will have a default value. The default value for a string
   * label is an empty string, for an integer label its 0, and for a boolean
   * label its `false`.
   *
   * Note that there are upper bounds on the maximum number of labels and the
   * number of active time series that are allowed in a project.
   * </pre>
   *
   * <code>map&lt;string, string&gt; label_extractors = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getLabelExtractorsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabelExtractors().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int BUCKET_OPTIONS_FIELD_NUMBER = 8;
  private com.google.api.Distribution.BucketOptions bucketOptions_;
  /**
   *
   *
   * <pre>
   * Optional. The `bucket_options` are required when the logs-based metric is
   * using a DISTRIBUTION value type and it describes the bucket boundaries
   * used to create a histogram of the extracted values.
   * </pre>
   *
   * <code>
   * .google.api.Distribution.BucketOptions bucket_options = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the bucketOptions field is set.
   */
  @java.lang.Override
  public boolean hasBucketOptions() {
    return bucketOptions_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The `bucket_options` are required when the logs-based metric is
   * using a DISTRIBUTION value type and it describes the bucket boundaries
   * used to create a histogram of the extracted values.
   * </pre>
   *
   * <code>
   * .google.api.Distribution.BucketOptions bucket_options = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The bucketOptions.
   */
  @java.lang.Override
  public com.google.api.Distribution.BucketOptions getBucketOptions() {
    return bucketOptions_ == null
        ? com.google.api.Distribution.BucketOptions.getDefaultInstance()
        : bucketOptions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The `bucket_options` are required when the logs-based metric is
   * using a DISTRIBUTION value type and it describes the bucket boundaries
   * used to create a histogram of the extracted values.
   * </pre>
   *
   * <code>
   * .google.api.Distribution.BucketOptions bucket_options = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.api.Distribution.BucketOptionsOrBuilder getBucketOptionsOrBuilder() {
    return bucketOptions_ == null
        ? com.google.api.Distribution.BucketOptions.getDefaultInstance()
        : bucketOptions_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of the metric.
   *
   * This field may not be present for older metrics.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of the metric.
   *
   * This field may not be present for older metrics.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of the metric.
   *
   * This field may not be present for older metrics.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of the metric.
   *
   * This field may not be present for older metrics.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of the metric.
   *
   * This field may not be present for older metrics.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of the metric.
   *
   * This field may not be present for older metrics.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int VERSION_FIELD_NUMBER = 4;
  private int version_ = 0;
  /**
   *
   *
   * <pre>
   * Deprecated. The API version that created or updated this metric.
   * The v2 format is used by default and cannot be changed.
   * </pre>
   *
   * <code>.google.logging.v2.LogMetric.ApiVersion version = 4 [deprecated = true];</code>
   *
   * @deprecated google.logging.v2.LogMetric.version is deprecated. See
   *     google/logging/v2/logging_metrics.proto;l=237
   * @return The enum numeric value on the wire for version.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getVersionValue() {
    return version_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated. The API version that created or updated this metric.
   * The v2 format is used by default and cannot be changed.
   * </pre>
   *
   * <code>.google.logging.v2.LogMetric.ApiVersion version = 4 [deprecated = true];</code>
   *
   * @deprecated google.logging.v2.LogMetric.version is deprecated. See
   *     google/logging/v2/logging_metrics.proto;l=237
   * @return The version.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.logging.v2.LogMetric.ApiVersion getVersion() {
    com.google.logging.v2.LogMetric.ApiVersion result =
        com.google.logging.v2.LogMetric.ApiVersion.forNumber(version_);
    return result == null ? com.google.logging.v2.LogMetric.ApiVersion.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, filter_);
    }
    if (version_ != com.google.logging.v2.LogMetric.ApiVersion.V2.getNumber()) {
      output.writeEnum(4, version_);
    }
    if (metricDescriptor_ != null) {
      output.writeMessage(5, getMetricDescriptor());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(valueExtractor_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, valueExtractor_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabelExtractors(), LabelExtractorsDefaultEntryHolder.defaultEntry, 7);
    if (bucketOptions_ != null) {
      output.writeMessage(8, getBucketOptions());
    }
    if (createTime_ != null) {
      output.writeMessage(9, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(10, getUpdateTime());
    }
    if (disabled_ != false) {
      output.writeBool(12, disabled_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucketName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, bucketName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, filter_);
    }
    if (version_ != com.google.logging.v2.LogMetric.ApiVersion.V2.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, version_);
    }
    if (metricDescriptor_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getMetricDescriptor());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(valueExtractor_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, valueExtractor_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabelExtractors().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labelExtractors__ =
          LabelExtractorsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, labelExtractors__);
    }
    if (bucketOptions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getBucketOptions());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getUpdateTime());
    }
    if (disabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(12, disabled_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucketName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, bucketName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.logging.v2.LogMetric)) {
      return super.equals(obj);
    }
    com.google.logging.v2.LogMetric other = (com.google.logging.v2.LogMetric) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getBucketName().equals(other.getBucketName())) return false;
    if (getDisabled() != other.getDisabled()) return false;
    if (hasMetricDescriptor() != other.hasMetricDescriptor()) return false;
    if (hasMetricDescriptor()) {
      if (!getMetricDescriptor().equals(other.getMetricDescriptor())) return false;
    }
    if (!getValueExtractor().equals(other.getValueExtractor())) return false;
    if (!internalGetLabelExtractors().equals(other.internalGetLabelExtractors())) return false;
    if (hasBucketOptions() != other.hasBucketOptions()) return false;
    if (hasBucketOptions()) {
      if (!getBucketOptions().equals(other.getBucketOptions())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (version_ != other.version_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + BUCKET_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getBucketName().hashCode();
    hash = (37 * hash) + DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    if (hasMetricDescriptor()) {
      hash = (37 * hash) + METRIC_DESCRIPTOR_FIELD_NUMBER;
      hash = (53 * hash) + getMetricDescriptor().hashCode();
    }
    hash = (37 * hash) + VALUE_EXTRACTOR_FIELD_NUMBER;
    hash = (53 * hash) + getValueExtractor().hashCode();
    if (!internalGetLabelExtractors().getMap().isEmpty()) {
      hash = (37 * hash) + LABEL_EXTRACTORS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabelExtractors().hashCode();
    }
    if (hasBucketOptions()) {
      hash = (37 * hash) + BUCKET_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getBucketOptions().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + version_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.logging.v2.LogMetric parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.LogMetric parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.LogMetric parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.LogMetric parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.LogMetric parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.LogMetric parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.LogMetric parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.LogMetric parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.LogMetric parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.LogMetric parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.LogMetric parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.LogMetric parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.logging.v2.LogMetric prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes a logs-based metric. The value of the metric is the number of log
   * entries that match a logs filter in a given time interval.
   *
   * Logs-based metrics can also be used to extract values from logs and create a
   * distribution of the values. The distribution records the statistics of the
   * extracted values along with an optional histogram of the values as specified
   * by the bucket options.
   * </pre>
   *
   * Protobuf type {@code google.logging.v2.LogMetric}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.logging.v2.LogMetric)
      com.google.logging.v2.LogMetricOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.logging.v2.LoggingMetricsProto
          .internal_static_google_logging_v2_LogMetric_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 7:
          return internalGetLabelExtractors();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 7:
          return internalGetMutableLabelExtractors();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.logging.v2.LoggingMetricsProto
          .internal_static_google_logging_v2_LogMetric_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.logging.v2.LogMetric.class, com.google.logging.v2.LogMetric.Builder.class);
    }

    // Construct using com.google.logging.v2.LogMetric.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      filter_ = "";
      bucketName_ = "";
      disabled_ = false;
      metricDescriptor_ = null;
      if (metricDescriptorBuilder_ != null) {
        metricDescriptorBuilder_.dispose();
        metricDescriptorBuilder_ = null;
      }
      valueExtractor_ = "";
      internalGetMutableLabelExtractors().clear();
      bucketOptions_ = null;
      if (bucketOptionsBuilder_ != null) {
        bucketOptionsBuilder_.dispose();
        bucketOptionsBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      version_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.logging.v2.LoggingMetricsProto
          .internal_static_google_logging_v2_LogMetric_descriptor;
    }

    @java.lang.Override
    public com.google.logging.v2.LogMetric getDefaultInstanceForType() {
      return com.google.logging.v2.LogMetric.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.logging.v2.LogMetric build() {
      com.google.logging.v2.LogMetric result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.logging.v2.LogMetric buildPartial() {
      com.google.logging.v2.LogMetric result = new com.google.logging.v2.LogMetric(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.logging.v2.LogMetric result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.bucketName_ = bucketName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.disabled_ = disabled_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.metricDescriptor_ =
            metricDescriptorBuilder_ == null ? metricDescriptor_ : metricDescriptorBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.valueExtractor_ = valueExtractor_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.labelExtractors_ = internalGetLabelExtractors();
        result.labelExtractors_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.bucketOptions_ =
            bucketOptionsBuilder_ == null ? bucketOptions_ : bucketOptionsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.version_ = version_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.logging.v2.LogMetric) {
        return mergeFrom((com.google.logging.v2.LogMetric) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.logging.v2.LogMetric other) {
      if (other == com.google.logging.v2.LogMetric.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getBucketName().isEmpty()) {
        bucketName_ = other.bucketName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getDisabled() != false) {
        setDisabled(other.getDisabled());
      }
      if (other.hasMetricDescriptor()) {
        mergeMetricDescriptor(other.getMetricDescriptor());
      }
      if (!other.getValueExtractor().isEmpty()) {
        valueExtractor_ = other.valueExtractor_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      internalGetMutableLabelExtractors().mergeFrom(other.internalGetLabelExtractors());
      bitField0_ |= 0x00000080;
      if (other.hasBucketOptions()) {
        mergeBucketOptions(other.getBucketOptions());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.version_ != 0) {
        setVersionValue(other.getVersionValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                version_ = input.readEnum();
                bitField0_ |= 0x00000800;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(
                    getMetricDescriptorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                valueExtractor_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labelExtractors__ =
                    input.readMessage(
                        LabelExtractorsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabelExtractors()
                    .getMutableMap()
                    .put(labelExtractors__.getKey(), labelExtractors__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getBucketOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 82
            case 96:
              {
                disabled_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 96
            case 106:
              {
                bucketName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The client-assigned metric identifier.
     * Examples: `"error_count"`, `"nginx/requests"`.
     *
     * Metric identifiers are limited to 100 characters and can include only the
     * following characters: `A-Z`, `a-z`, `0-9`, and the special characters
     * `_-.,+!*',()%/`. The forward-slash character (`/`) denotes a hierarchy of
     * name pieces, and it cannot be the first character of the name.
     *
     * This field is the `[METRIC_ID]` part of a metric resource name in the
     * format "projects/[PROJECT_ID]/metrics/[METRIC_ID]". Example: If the
     * resource name of a metric is
     * `"projects/my-project/metrics/nginx%2Frequests"`, this field's value is
     * `"nginx/requests"`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The client-assigned metric identifier.
     * Examples: `"error_count"`, `"nginx/requests"`.
     *
     * Metric identifiers are limited to 100 characters and can include only the
     * following characters: `A-Z`, `a-z`, `0-9`, and the special characters
     * `_-.,+!*',()%/`. The forward-slash character (`/`) denotes a hierarchy of
     * name pieces, and it cannot be the first character of the name.
     *
     * This field is the `[METRIC_ID]` part of a metric resource name in the
     * format "projects/[PROJECT_ID]/metrics/[METRIC_ID]". Example: If the
     * resource name of a metric is
     * `"projects/my-project/metrics/nginx%2Frequests"`, this field's value is
     * `"nginx/requests"`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The client-assigned metric identifier.
     * Examples: `"error_count"`, `"nginx/requests"`.
     *
     * Metric identifiers are limited to 100 characters and can include only the
     * following characters: `A-Z`, `a-z`, `0-9`, and the special characters
     * `_-.,+!*',()%/`. The forward-slash character (`/`) denotes a hierarchy of
     * name pieces, and it cannot be the first character of the name.
     *
     * This field is the `[METRIC_ID]` part of a metric resource name in the
     * format "projects/[PROJECT_ID]/metrics/[METRIC_ID]". Example: If the
     * resource name of a metric is
     * `"projects/my-project/metrics/nginx%2Frequests"`, this field's value is
     * `"nginx/requests"`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The client-assigned metric identifier.
     * Examples: `"error_count"`, `"nginx/requests"`.
     *
     * Metric identifiers are limited to 100 characters and can include only the
     * following characters: `A-Z`, `a-z`, `0-9`, and the special characters
     * `_-.,+!*',()%/`. The forward-slash character (`/`) denotes a hierarchy of
     * name pieces, and it cannot be the first character of the name.
     *
     * This field is the `[METRIC_ID]` part of a metric resource name in the
     * format "projects/[PROJECT_ID]/metrics/[METRIC_ID]". Example: If the
     * resource name of a metric is
     * `"projects/my-project/metrics/nginx%2Frequests"`, this field's value is
     * `"nginx/requests"`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The client-assigned metric identifier.
     * Examples: `"error_count"`, `"nginx/requests"`.
     *
     * Metric identifiers are limited to 100 characters and can include only the
     * following characters: `A-Z`, `a-z`, `0-9`, and the special characters
     * `_-.,+!*',()%/`. The forward-slash character (`/`) denotes a hierarchy of
     * name pieces, and it cannot be the first character of the name.
     *
     * This field is the `[METRIC_ID]` part of a metric resource name in the
     * format "projects/[PROJECT_ID]/metrics/[METRIC_ID]". Example: If the
     * resource name of a metric is
     * `"projects/my-project/metrics/nginx%2Frequests"`, this field's value is
     * `"nginx/requests"`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A description of this metric, which is used in documentation.
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of this metric, which is used in documentation.
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of this metric, which is used in documentation.
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of this metric, which is used in documentation.
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A description of this metric, which is used in documentation.
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Required. An [advanced logs
     * filter](https://cloud.google.com/logging/docs/view/advanced_filters) which
     * is used to match log entries. Example:
     *
     *     "resource.type=gae_app AND severity&gt;=ERROR"
     *
     * The maximum length of the filter is 20000 characters.
     * </pre>
     *
     * <code>string filter = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. An [advanced logs
     * filter](https://cloud.google.com/logging/docs/view/advanced_filters) which
     * is used to match log entries. Example:
     *
     *     "resource.type=gae_app AND severity&gt;=ERROR"
     *
     * The maximum length of the filter is 20000 characters.
     * </pre>
     *
     * <code>string filter = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. An [advanced logs
     * filter](https://cloud.google.com/logging/docs/view/advanced_filters) which
     * is used to match log entries. Example:
     *
     *     "resource.type=gae_app AND severity&gt;=ERROR"
     *
     * The maximum length of the filter is 20000 characters.
     * </pre>
     *
     * <code>string filter = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. An [advanced logs
     * filter](https://cloud.google.com/logging/docs/view/advanced_filters) which
     * is used to match log entries. Example:
     *
     *     "resource.type=gae_app AND severity&gt;=ERROR"
     *
     * The maximum length of the filter is 20000 characters.
     * </pre>
     *
     * <code>string filter = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. An [advanced logs
     * filter](https://cloud.google.com/logging/docs/view/advanced_filters) which
     * is used to match log entries. Example:
     *
     *     "resource.type=gae_app AND severity&gt;=ERROR"
     *
     * The maximum length of the filter is 20000 characters.
     * </pre>
     *
     * <code>string filter = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object bucketName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the Log Bucket that owns the Log Metric.
     * Only Log Buckets in projects are supported. The bucket has to be in the
     * same project as the metric.
     *
     * For example:
     *
     *   `projects/my-project/locations/global/buckets/my-bucket`
     *
     * If empty, then the Log Metric is considered a non-Bucket Log Metric.
     * </pre>
     *
     * <code>string bucket_name = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bucketName.
     */
    public java.lang.String getBucketName() {
      java.lang.Object ref = bucketName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucketName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the Log Bucket that owns the Log Metric.
     * Only Log Buckets in projects are supported. The bucket has to be in the
     * same project as the metric.
     *
     * For example:
     *
     *   `projects/my-project/locations/global/buckets/my-bucket`
     *
     * If empty, then the Log Metric is considered a non-Bucket Log Metric.
     * </pre>
     *
     * <code>string bucket_name = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for bucketName.
     */
    public com.google.protobuf.ByteString getBucketNameBytes() {
      java.lang.Object ref = bucketName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucketName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the Log Bucket that owns the Log Metric.
     * Only Log Buckets in projects are supported. The bucket has to be in the
     * same project as the metric.
     *
     * For example:
     *
     *   `projects/my-project/locations/global/buckets/my-bucket`
     *
     * If empty, then the Log Metric is considered a non-Bucket Log Metric.
     * </pre>
     *
     * <code>string bucket_name = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bucketName to set.
     * @return This builder for chaining.
     */
    public Builder setBucketName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bucketName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the Log Bucket that owns the Log Metric.
     * Only Log Buckets in projects are supported. The bucket has to be in the
     * same project as the metric.
     *
     * For example:
     *
     *   `projects/my-project/locations/global/buckets/my-bucket`
     *
     * If empty, then the Log Metric is considered a non-Bucket Log Metric.
     * </pre>
     *
     * <code>string bucket_name = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBucketName() {
      bucketName_ = getDefaultInstance().getBucketName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name of the Log Bucket that owns the Log Metric.
     * Only Log Buckets in projects are supported. The bucket has to be in the
     * same project as the metric.
     *
     * For example:
     *
     *   `projects/my-project/locations/global/buckets/my-bucket`
     *
     * If empty, then the Log Metric is considered a non-Bucket Log Metric.
     * </pre>
     *
     * <code>string bucket_name = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for bucketName to set.
     * @return This builder for chaining.
     */
    public Builder setBucketNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bucketName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean disabled_;
    /**
     *
     *
     * <pre>
     * Optional. If set to True, then this metric is disabled and it does not
     * generate any points.
     * </pre>
     *
     * <code>bool disabled = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set to True, then this metric is disabled and it does not
     * generate any points.
     * </pre>
     *
     * <code>bool disabled = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The disabled to set.
     * @return This builder for chaining.
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set to True, then this metric is disabled and it does not
     * generate any points.
     * </pre>
     *
     * <code>bool disabled = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabled() {
      bitField0_ = (bitField0_ & ~0x00000010);
      disabled_ = false;
      onChanged();
      return this;
    }

    private com.google.api.MetricDescriptor metricDescriptor_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.MetricDescriptor,
            com.google.api.MetricDescriptor.Builder,
            com.google.api.MetricDescriptorOrBuilder>
        metricDescriptorBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The metric descriptor associated with the logs-based metric.
     * If unspecified, it uses a default metric descriptor with a DELTA metric
     * kind, INT64 value type, with no labels and a unit of "1". Such a metric
     * counts the number of log entries matching the `filter` expression.
     *
     * The `name`, `type`, and `description` fields in the `metric_descriptor`
     * are output only, and is constructed using the `name` and `description`
     * field in the LogMetric.
     *
     * To create a logs-based metric that records a distribution of log values, a
     * DELTA metric kind with a DISTRIBUTION value type must be used along with
     * a `value_extractor` expression in the LogMetric.
     *
     * Each label in the metric descriptor must have a matching label
     * name as the key and an extractor expression as the value in the
     * `label_extractors` map.
     *
     * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
     * be updated once initially configured. New labels can be added in the
     * `metric_descriptor`, but existing labels cannot be modified except for
     * their description.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor metric_descriptor = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the metricDescriptor field is set.
     */
    public boolean hasMetricDescriptor() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric descriptor associated with the logs-based metric.
     * If unspecified, it uses a default metric descriptor with a DELTA metric
     * kind, INT64 value type, with no labels and a unit of "1". Such a metric
     * counts the number of log entries matching the `filter` expression.
     *
     * The `name`, `type`, and `description` fields in the `metric_descriptor`
     * are output only, and is constructed using the `name` and `description`
     * field in the LogMetric.
     *
     * To create a logs-based metric that records a distribution of log values, a
     * DELTA metric kind with a DISTRIBUTION value type must be used along with
     * a `value_extractor` expression in the LogMetric.
     *
     * Each label in the metric descriptor must have a matching label
     * name as the key and an extractor expression as the value in the
     * `label_extractors` map.
     *
     * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
     * be updated once initially configured. New labels can be added in the
     * `metric_descriptor`, but existing labels cannot be modified except for
     * their description.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor metric_descriptor = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The metricDescriptor.
     */
    public com.google.api.MetricDescriptor getMetricDescriptor() {
      if (metricDescriptorBuilder_ == null) {
        return metricDescriptor_ == null
            ? com.google.api.MetricDescriptor.getDefaultInstance()
            : metricDescriptor_;
      } else {
        return metricDescriptorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric descriptor associated with the logs-based metric.
     * If unspecified, it uses a default metric descriptor with a DELTA metric
     * kind, INT64 value type, with no labels and a unit of "1". Such a metric
     * counts the number of log entries matching the `filter` expression.
     *
     * The `name`, `type`, and `description` fields in the `metric_descriptor`
     * are output only, and is constructed using the `name` and `description`
     * field in the LogMetric.
     *
     * To create a logs-based metric that records a distribution of log values, a
     * DELTA metric kind with a DISTRIBUTION value type must be used along with
     * a `value_extractor` expression in the LogMetric.
     *
     * Each label in the metric descriptor must have a matching label
     * name as the key and an extractor expression as the value in the
     * `label_extractors` map.
     *
     * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
     * be updated once initially configured. New labels can be added in the
     * `metric_descriptor`, but existing labels cannot be modified except for
     * their description.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor metric_descriptor = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMetricDescriptor(com.google.api.MetricDescriptor value) {
      if (metricDescriptorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricDescriptor_ = value;
      } else {
        metricDescriptorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric descriptor associated with the logs-based metric.
     * If unspecified, it uses a default metric descriptor with a DELTA metric
     * kind, INT64 value type, with no labels and a unit of "1". Such a metric
     * counts the number of log entries matching the `filter` expression.
     *
     * The `name`, `type`, and `description` fields in the `metric_descriptor`
     * are output only, and is constructed using the `name` and `description`
     * field in the LogMetric.
     *
     * To create a logs-based metric that records a distribution of log values, a
     * DELTA metric kind with a DISTRIBUTION value type must be used along with
     * a `value_extractor` expression in the LogMetric.
     *
     * Each label in the metric descriptor must have a matching label
     * name as the key and an extractor expression as the value in the
     * `label_extractors` map.
     *
     * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
     * be updated once initially configured. New labels can be added in the
     * `metric_descriptor`, but existing labels cannot be modified except for
     * their description.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor metric_descriptor = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMetricDescriptor(com.google.api.MetricDescriptor.Builder builderForValue) {
      if (metricDescriptorBuilder_ == null) {
        metricDescriptor_ = builderForValue.build();
      } else {
        metricDescriptorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric descriptor associated with the logs-based metric.
     * If unspecified, it uses a default metric descriptor with a DELTA metric
     * kind, INT64 value type, with no labels and a unit of "1". Such a metric
     * counts the number of log entries matching the `filter` expression.
     *
     * The `name`, `type`, and `description` fields in the `metric_descriptor`
     * are output only, and is constructed using the `name` and `description`
     * field in the LogMetric.
     *
     * To create a logs-based metric that records a distribution of log values, a
     * DELTA metric kind with a DISTRIBUTION value type must be used along with
     * a `value_extractor` expression in the LogMetric.
     *
     * Each label in the metric descriptor must have a matching label
     * name as the key and an extractor expression as the value in the
     * `label_extractors` map.
     *
     * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
     * be updated once initially configured. New labels can be added in the
     * `metric_descriptor`, but existing labels cannot be modified except for
     * their description.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor metric_descriptor = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeMetricDescriptor(com.google.api.MetricDescriptor value) {
      if (metricDescriptorBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && metricDescriptor_ != null
            && metricDescriptor_ != com.google.api.MetricDescriptor.getDefaultInstance()) {
          getMetricDescriptorBuilder().mergeFrom(value);
        } else {
          metricDescriptor_ = value;
        }
      } else {
        metricDescriptorBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric descriptor associated with the logs-based metric.
     * If unspecified, it uses a default metric descriptor with a DELTA metric
     * kind, INT64 value type, with no labels and a unit of "1". Such a metric
     * counts the number of log entries matching the `filter` expression.
     *
     * The `name`, `type`, and `description` fields in the `metric_descriptor`
     * are output only, and is constructed using the `name` and `description`
     * field in the LogMetric.
     *
     * To create a logs-based metric that records a distribution of log values, a
     * DELTA metric kind with a DISTRIBUTION value type must be used along with
     * a `value_extractor` expression in the LogMetric.
     *
     * Each label in the metric descriptor must have a matching label
     * name as the key and an extractor expression as the value in the
     * `label_extractors` map.
     *
     * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
     * be updated once initially configured. New labels can be added in the
     * `metric_descriptor`, but existing labels cannot be modified except for
     * their description.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor metric_descriptor = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMetricDescriptor() {
      bitField0_ = (bitField0_ & ~0x00000020);
      metricDescriptor_ = null;
      if (metricDescriptorBuilder_ != null) {
        metricDescriptorBuilder_.dispose();
        metricDescriptorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric descriptor associated with the logs-based metric.
     * If unspecified, it uses a default metric descriptor with a DELTA metric
     * kind, INT64 value type, with no labels and a unit of "1". Such a metric
     * counts the number of log entries matching the `filter` expression.
     *
     * The `name`, `type`, and `description` fields in the `metric_descriptor`
     * are output only, and is constructed using the `name` and `description`
     * field in the LogMetric.
     *
     * To create a logs-based metric that records a distribution of log values, a
     * DELTA metric kind with a DISTRIBUTION value type must be used along with
     * a `value_extractor` expression in the LogMetric.
     *
     * Each label in the metric descriptor must have a matching label
     * name as the key and an extractor expression as the value in the
     * `label_extractors` map.
     *
     * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
     * be updated once initially configured. New labels can be added in the
     * `metric_descriptor`, but existing labels cannot be modified except for
     * their description.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor metric_descriptor = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.api.MetricDescriptor.Builder getMetricDescriptorBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getMetricDescriptorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric descriptor associated with the logs-based metric.
     * If unspecified, it uses a default metric descriptor with a DELTA metric
     * kind, INT64 value type, with no labels and a unit of "1". Such a metric
     * counts the number of log entries matching the `filter` expression.
     *
     * The `name`, `type`, and `description` fields in the `metric_descriptor`
     * are output only, and is constructed using the `name` and `description`
     * field in the LogMetric.
     *
     * To create a logs-based metric that records a distribution of log values, a
     * DELTA metric kind with a DISTRIBUTION value type must be used along with
     * a `value_extractor` expression in the LogMetric.
     *
     * Each label in the metric descriptor must have a matching label
     * name as the key and an extractor expression as the value in the
     * `label_extractors` map.
     *
     * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
     * be updated once initially configured. New labels can be added in the
     * `metric_descriptor`, but existing labels cannot be modified except for
     * their description.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor metric_descriptor = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.api.MetricDescriptorOrBuilder getMetricDescriptorOrBuilder() {
      if (metricDescriptorBuilder_ != null) {
        return metricDescriptorBuilder_.getMessageOrBuilder();
      } else {
        return metricDescriptor_ == null
            ? com.google.api.MetricDescriptor.getDefaultInstance()
            : metricDescriptor_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The metric descriptor associated with the logs-based metric.
     * If unspecified, it uses a default metric descriptor with a DELTA metric
     * kind, INT64 value type, with no labels and a unit of "1". Such a metric
     * counts the number of log entries matching the `filter` expression.
     *
     * The `name`, `type`, and `description` fields in the `metric_descriptor`
     * are output only, and is constructed using the `name` and `description`
     * field in the LogMetric.
     *
     * To create a logs-based metric that records a distribution of log values, a
     * DELTA metric kind with a DISTRIBUTION value type must be used along with
     * a `value_extractor` expression in the LogMetric.
     *
     * Each label in the metric descriptor must have a matching label
     * name as the key and an extractor expression as the value in the
     * `label_extractors` map.
     *
     * The `metric_kind` and `value_type` fields in the `metric_descriptor` cannot
     * be updated once initially configured. New labels can be added in the
     * `metric_descriptor`, but existing labels cannot be modified except for
     * their description.
     * </pre>
     *
     * <code>
     * .google.api.MetricDescriptor metric_descriptor = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.MetricDescriptor,
            com.google.api.MetricDescriptor.Builder,
            com.google.api.MetricDescriptorOrBuilder>
        getMetricDescriptorFieldBuilder() {
      if (metricDescriptorBuilder_ == null) {
        metricDescriptorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.MetricDescriptor,
                com.google.api.MetricDescriptor.Builder,
                com.google.api.MetricDescriptorOrBuilder>(
                getMetricDescriptor(), getParentForChildren(), isClean());
        metricDescriptor_ = null;
      }
      return metricDescriptorBuilder_;
    }

    private java.lang.Object valueExtractor_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A `value_extractor` is required when using a distribution
     * logs-based metric to extract the values to record from a log entry.
     * Two functions are supported for value extraction: `EXTRACT(field)` or
     * `REGEXP_EXTRACT(field, regex)`. The arguments are:
     *
     *   1. field: The name of the log entry field from which the value is to be
     *      extracted.
     *   2. regex: A regular expression using the Google RE2 syntax
     *      (https://github.com/google/re2/wiki/Syntax) with a single capture
     *      group to extract data from the specified log entry field. The value
     *      of the field is converted to a string before applying the regex.
     *      It is an error to specify a regex that does not include exactly one
     *      capture group.
     *
     * The result of the extraction must be convertible to a double type, as the
     * distribution always records double values. If either the extraction or
     * the conversion to double fails, then those values are not recorded in the
     * distribution.
     *
     * Example: `REGEXP_EXTRACT(jsonPayload.request, ".*quantity=(&#92;d+).*")`
     * </pre>
     *
     * <code>string value_extractor = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The valueExtractor.
     */
    public java.lang.String getValueExtractor() {
      java.lang.Object ref = valueExtractor_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        valueExtractor_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A `value_extractor` is required when using a distribution
     * logs-based metric to extract the values to record from a log entry.
     * Two functions are supported for value extraction: `EXTRACT(field)` or
     * `REGEXP_EXTRACT(field, regex)`. The arguments are:
     *
     *   1. field: The name of the log entry field from which the value is to be
     *      extracted.
     *   2. regex: A regular expression using the Google RE2 syntax
     *      (https://github.com/google/re2/wiki/Syntax) with a single capture
     *      group to extract data from the specified log entry field. The value
     *      of the field is converted to a string before applying the regex.
     *      It is an error to specify a regex that does not include exactly one
     *      capture group.
     *
     * The result of the extraction must be convertible to a double type, as the
     * distribution always records double values. If either the extraction or
     * the conversion to double fails, then those values are not recorded in the
     * distribution.
     *
     * Example: `REGEXP_EXTRACT(jsonPayload.request, ".*quantity=(&#92;d+).*")`
     * </pre>
     *
     * <code>string value_extractor = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for valueExtractor.
     */
    public com.google.protobuf.ByteString getValueExtractorBytes() {
      java.lang.Object ref = valueExtractor_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        valueExtractor_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A `value_extractor` is required when using a distribution
     * logs-based metric to extract the values to record from a log entry.
     * Two functions are supported for value extraction: `EXTRACT(field)` or
     * `REGEXP_EXTRACT(field, regex)`. The arguments are:
     *
     *   1. field: The name of the log entry field from which the value is to be
     *      extracted.
     *   2. regex: A regular expression using the Google RE2 syntax
     *      (https://github.com/google/re2/wiki/Syntax) with a single capture
     *      group to extract data from the specified log entry field. The value
     *      of the field is converted to a string before applying the regex.
     *      It is an error to specify a regex that does not include exactly one
     *      capture group.
     *
     * The result of the extraction must be convertible to a double type, as the
     * distribution always records double values. If either the extraction or
     * the conversion to double fails, then those values are not recorded in the
     * distribution.
     *
     * Example: `REGEXP_EXTRACT(jsonPayload.request, ".*quantity=(&#92;d+).*")`
     * </pre>
     *
     * <code>string value_extractor = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The valueExtractor to set.
     * @return This builder for chaining.
     */
    public Builder setValueExtractor(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      valueExtractor_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A `value_extractor` is required when using a distribution
     * logs-based metric to extract the values to record from a log entry.
     * Two functions are supported for value extraction: `EXTRACT(field)` or
     * `REGEXP_EXTRACT(field, regex)`. The arguments are:
     *
     *   1. field: The name of the log entry field from which the value is to be
     *      extracted.
     *   2. regex: A regular expression using the Google RE2 syntax
     *      (https://github.com/google/re2/wiki/Syntax) with a single capture
     *      group to extract data from the specified log entry field. The value
     *      of the field is converted to a string before applying the regex.
     *      It is an error to specify a regex that does not include exactly one
     *      capture group.
     *
     * The result of the extraction must be convertible to a double type, as the
     * distribution always records double values. If either the extraction or
     * the conversion to double fails, then those values are not recorded in the
     * distribution.
     *
     * Example: `REGEXP_EXTRACT(jsonPayload.request, ".*quantity=(&#92;d+).*")`
     * </pre>
     *
     * <code>string value_extractor = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValueExtractor() {
      valueExtractor_ = getDefaultInstance().getValueExtractor();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A `value_extractor` is required when using a distribution
     * logs-based metric to extract the values to record from a log entry.
     * Two functions are supported for value extraction: `EXTRACT(field)` or
     * `REGEXP_EXTRACT(field, regex)`. The arguments are:
     *
     *   1. field: The name of the log entry field from which the value is to be
     *      extracted.
     *   2. regex: A regular expression using the Google RE2 syntax
     *      (https://github.com/google/re2/wiki/Syntax) with a single capture
     *      group to extract data from the specified log entry field. The value
     *      of the field is converted to a string before applying the regex.
     *      It is an error to specify a regex that does not include exactly one
     *      capture group.
     *
     * The result of the extraction must be convertible to a double type, as the
     * distribution always records double values. If either the extraction or
     * the conversion to double fails, then those values are not recorded in the
     * distribution.
     *
     * Example: `REGEXP_EXTRACT(jsonPayload.request, ".*quantity=(&#92;d+).*")`
     * </pre>
     *
     * <code>string value_extractor = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for valueExtractor to set.
     * @return This builder for chaining.
     */
    public Builder setValueExtractorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      valueExtractor_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labelExtractors_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetLabelExtractors() {
      if (labelExtractors_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            LabelExtractorsDefaultEntryHolder.defaultEntry);
      }
      return labelExtractors_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabelExtractors() {
      if (labelExtractors_ == null) {
        labelExtractors_ =
            com.google.protobuf.MapField.newMapField(
                LabelExtractorsDefaultEntryHolder.defaultEntry);
      }
      if (!labelExtractors_.isMutable()) {
        labelExtractors_ = labelExtractors_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return labelExtractors_;
    }

    public int getLabelExtractorsCount() {
      return internalGetLabelExtractors().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A map from a label key string to an extractor expression which is
     * used to extract data from a log entry field and assign as the label value.
     * Each label key specified in the LabelDescriptor must have an associated
     * extractor expression in this map. The syntax of the extractor expression
     * is the same as for the `value_extractor` field.
     *
     * The extracted value is converted to the type defined in the label
     * descriptor. If either the extraction or the type conversion fails,
     * the label will have a default value. The default value for a string
     * label is an empty string, for an integer label its 0, and for a boolean
     * label its `false`.
     *
     * Note that there are upper bounds on the maximum number of labels and the
     * number of active time series that are allowed in a project.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; label_extractors = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsLabelExtractors(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabelExtractors().getMap().containsKey(key);
    }
    /** Use {@link #getLabelExtractorsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabelExtractors() {
      return getLabelExtractorsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A map from a label key string to an extractor expression which is
     * used to extract data from a log entry field and assign as the label value.
     * Each label key specified in the LabelDescriptor must have an associated
     * extractor expression in this map. The syntax of the extractor expression
     * is the same as for the `value_extractor` field.
     *
     * The extracted value is converted to the type defined in the label
     * descriptor. If either the extraction or the type conversion fails,
     * the label will have a default value. The default value for a string
     * label is an empty string, for an integer label its 0, and for a boolean
     * label its `false`.
     *
     * Note that there are upper bounds on the maximum number of labels and the
     * number of active time series that are allowed in a project.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; label_extractors = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelExtractorsMap() {
      return internalGetLabelExtractors().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A map from a label key string to an extractor expression which is
     * used to extract data from a log entry field and assign as the label value.
     * Each label key specified in the LabelDescriptor must have an associated
     * extractor expression in this map. The syntax of the extractor expression
     * is the same as for the `value_extractor` field.
     *
     * The extracted value is converted to the type defined in the label
     * descriptor. If either the extraction or the type conversion fails,
     * the label will have a default value. The default value for a string
     * label is an empty string, for an integer label its 0, and for a boolean
     * label its `false`.
     *
     * Note that there are upper bounds on the maximum number of labels and the
     * number of active time series that are allowed in a project.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; label_extractors = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelExtractorsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabelExtractors().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. A map from a label key string to an extractor expression which is
     * used to extract data from a log entry field and assign as the label value.
     * Each label key specified in the LabelDescriptor must have an associated
     * extractor expression in this map. The syntax of the extractor expression
     * is the same as for the `value_extractor` field.
     *
     * The extracted value is converted to the type defined in the label
     * descriptor. If either the extraction or the type conversion fails,
     * the label will have a default value. The default value for a string
     * label is an empty string, for an integer label its 0, and for a boolean
     * label its `false`.
     *
     * Note that there are upper bounds on the maximum number of labels and the
     * number of active time series that are allowed in a project.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; label_extractors = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getLabelExtractorsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabelExtractors().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabelExtractors() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableLabelExtractors().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A map from a label key string to an extractor expression which is
     * used to extract data from a log entry field and assign as the label value.
     * Each label key specified in the LabelDescriptor must have an associated
     * extractor expression in this map. The syntax of the extractor expression
     * is the same as for the `value_extractor` field.
     *
     * The extracted value is converted to the type defined in the label
     * descriptor. If either the extraction or the type conversion fails,
     * the label will have a default value. The default value for a string
     * label is an empty string, for an integer label its 0, and for a boolean
     * label its `false`.
     *
     * Note that there are upper bounds on the maximum number of labels and the
     * number of active time series that are allowed in a project.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; label_extractors = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeLabelExtractors(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabelExtractors().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabelExtractors() {
      bitField0_ |= 0x00000080;
      return internalGetMutableLabelExtractors().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A map from a label key string to an extractor expression which is
     * used to extract data from a log entry field and assign as the label value.
     * Each label key specified in the LabelDescriptor must have an associated
     * extractor expression in this map. The syntax of the extractor expression
     * is the same as for the `value_extractor` field.
     *
     * The extracted value is converted to the type defined in the label
     * descriptor. If either the extraction or the type conversion fails,
     * the label will have a default value. The default value for a string
     * label is an empty string, for an integer label its 0, and for a boolean
     * label its `false`.
     *
     * Note that there are upper bounds on the maximum number of labels and the
     * number of active time series that are allowed in a project.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; label_extractors = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putLabelExtractors(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabelExtractors().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A map from a label key string to an extractor expression which is
     * used to extract data from a log entry field and assign as the label value.
     * Each label key specified in the LabelDescriptor must have an associated
     * extractor expression in this map. The syntax of the extractor expression
     * is the same as for the `value_extractor` field.
     *
     * The extracted value is converted to the type defined in the label
     * descriptor. If either the extraction or the type conversion fails,
     * the label will have a default value. The default value for a string
     * label is an empty string, for an integer label its 0, and for a boolean
     * label its `false`.
     *
     * Note that there are upper bounds on the maximum number of labels and the
     * number of active time series that are allowed in a project.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; label_extractors = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllLabelExtractors(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabelExtractors().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    private com.google.api.Distribution.BucketOptions bucketOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Distribution.BucketOptions,
            com.google.api.Distribution.BucketOptions.Builder,
            com.google.api.Distribution.BucketOptionsOrBuilder>
        bucketOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The `bucket_options` are required when the logs-based metric is
     * using a DISTRIBUTION value type and it describes the bucket boundaries
     * used to create a histogram of the extracted values.
     * </pre>
     *
     * <code>
     * .google.api.Distribution.BucketOptions bucket_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the bucketOptions field is set.
     */
    public boolean hasBucketOptions() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The `bucket_options` are required when the logs-based metric is
     * using a DISTRIBUTION value type and it describes the bucket boundaries
     * used to create a histogram of the extracted values.
     * </pre>
     *
     * <code>
     * .google.api.Distribution.BucketOptions bucket_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bucketOptions.
     */
    public com.google.api.Distribution.BucketOptions getBucketOptions() {
      if (bucketOptionsBuilder_ == null) {
        return bucketOptions_ == null
            ? com.google.api.Distribution.BucketOptions.getDefaultInstance()
            : bucketOptions_;
      } else {
        return bucketOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The `bucket_options` are required when the logs-based metric is
     * using a DISTRIBUTION value type and it describes the bucket boundaries
     * used to create a histogram of the extracted values.
     * </pre>
     *
     * <code>
     * .google.api.Distribution.BucketOptions bucket_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBucketOptions(com.google.api.Distribution.BucketOptions value) {
      if (bucketOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bucketOptions_ = value;
      } else {
        bucketOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `bucket_options` are required when the logs-based metric is
     * using a DISTRIBUTION value type and it describes the bucket boundaries
     * used to create a histogram of the extracted values.
     * </pre>
     *
     * <code>
     * .google.api.Distribution.BucketOptions bucket_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setBucketOptions(
        com.google.api.Distribution.BucketOptions.Builder builderForValue) {
      if (bucketOptionsBuilder_ == null) {
        bucketOptions_ = builderForValue.build();
      } else {
        bucketOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `bucket_options` are required when the logs-based metric is
     * using a DISTRIBUTION value type and it describes the bucket boundaries
     * used to create a histogram of the extracted values.
     * </pre>
     *
     * <code>
     * .google.api.Distribution.BucketOptions bucket_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeBucketOptions(com.google.api.Distribution.BucketOptions value) {
      if (bucketOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && bucketOptions_ != null
            && bucketOptions_ != com.google.api.Distribution.BucketOptions.getDefaultInstance()) {
          getBucketOptionsBuilder().mergeFrom(value);
        } else {
          bucketOptions_ = value;
        }
      } else {
        bucketOptionsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `bucket_options` are required when the logs-based metric is
     * using a DISTRIBUTION value type and it describes the bucket boundaries
     * used to create a histogram of the extracted values.
     * </pre>
     *
     * <code>
     * .google.api.Distribution.BucketOptions bucket_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearBucketOptions() {
      bitField0_ = (bitField0_ & ~0x00000100);
      bucketOptions_ = null;
      if (bucketOptionsBuilder_ != null) {
        bucketOptionsBuilder_.dispose();
        bucketOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The `bucket_options` are required when the logs-based metric is
     * using a DISTRIBUTION value type and it describes the bucket boundaries
     * used to create a histogram of the extracted values.
     * </pre>
     *
     * <code>
     * .google.api.Distribution.BucketOptions bucket_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.api.Distribution.BucketOptions.Builder getBucketOptionsBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getBucketOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The `bucket_options` are required when the logs-based metric is
     * using a DISTRIBUTION value type and it describes the bucket boundaries
     * used to create a histogram of the extracted values.
     * </pre>
     *
     * <code>
     * .google.api.Distribution.BucketOptions bucket_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.api.Distribution.BucketOptionsOrBuilder getBucketOptionsOrBuilder() {
      if (bucketOptionsBuilder_ != null) {
        return bucketOptionsBuilder_.getMessageOrBuilder();
      } else {
        return bucketOptions_ == null
            ? com.google.api.Distribution.BucketOptions.getDefaultInstance()
            : bucketOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The `bucket_options` are required when the logs-based metric is
     * using a DISTRIBUTION value type and it describes the bucket boundaries
     * used to create a histogram of the extracted values.
     * </pre>
     *
     * <code>
     * .google.api.Distribution.BucketOptions bucket_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.Distribution.BucketOptions,
            com.google.api.Distribution.BucketOptions.Builder,
            com.google.api.Distribution.BucketOptionsOrBuilder>
        getBucketOptionsFieldBuilder() {
      if (bucketOptionsBuilder_ == null) {
        bucketOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.Distribution.BucketOptions,
                com.google.api.Distribution.BucketOptions.Builder,
                com.google.api.Distribution.BucketOptionsOrBuilder>(
                getBucketOptions(), getParentForChildren(), isClean());
        bucketOptions_ = null;
      }
      return bucketOptionsBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the metric.
     *
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the metric.
     *
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the metric.
     *
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the metric.
     *
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the metric.
     *
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the metric.
     *
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the metric.
     *
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the metric.
     *
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the metric.
     *
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the metric.
     *
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the metric.
     *
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the metric.
     *
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the metric.
     *
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the metric.
     *
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the metric.
     *
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the metric.
     *
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the metric.
     *
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the metric.
     *
     * This field may not be present for older metrics.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private int version_ = 0;
    /**
     *
     *
     * <pre>
     * Deprecated. The API version that created or updated this metric.
     * The v2 format is used by default and cannot be changed.
     * </pre>
     *
     * <code>.google.logging.v2.LogMetric.ApiVersion version = 4 [deprecated = true];</code>
     *
     * @deprecated google.logging.v2.LogMetric.version is deprecated. See
     *     google/logging/v2/logging_metrics.proto;l=237
     * @return The enum numeric value on the wire for version.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getVersionValue() {
      return version_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The API version that created or updated this metric.
     * The v2 format is used by default and cannot be changed.
     * </pre>
     *
     * <code>.google.logging.v2.LogMetric.ApiVersion version = 4 [deprecated = true];</code>
     *
     * @deprecated google.logging.v2.LogMetric.version is deprecated. See
     *     google/logging/v2/logging_metrics.proto;l=237
     * @param value The enum numeric value on the wire for version to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setVersionValue(int value) {
      version_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The API version that created or updated this metric.
     * The v2 format is used by default and cannot be changed.
     * </pre>
     *
     * <code>.google.logging.v2.LogMetric.ApiVersion version = 4 [deprecated = true];</code>
     *
     * @deprecated google.logging.v2.LogMetric.version is deprecated. See
     *     google/logging/v2/logging_metrics.proto;l=237
     * @return The version.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.logging.v2.LogMetric.ApiVersion getVersion() {
      com.google.logging.v2.LogMetric.ApiVersion result =
          com.google.logging.v2.LogMetric.ApiVersion.forNumber(version_);
      return result == null ? com.google.logging.v2.LogMetric.ApiVersion.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The API version that created or updated this metric.
     * The v2 format is used by default and cannot be changed.
     * </pre>
     *
     * <code>.google.logging.v2.LogMetric.ApiVersion version = 4 [deprecated = true];</code>
     *
     * @deprecated google.logging.v2.LogMetric.version is deprecated. See
     *     google/logging/v2/logging_metrics.proto;l=237
     * @param value The version to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setVersion(com.google.logging.v2.LogMetric.ApiVersion value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      version_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The API version that created or updated this metric.
     * The v2 format is used by default and cannot be changed.
     * </pre>
     *
     * <code>.google.logging.v2.LogMetric.ApiVersion version = 4 [deprecated = true];</code>
     *
     * @deprecated google.logging.v2.LogMetric.version is deprecated. See
     *     google/logging/v2/logging_metrics.proto;l=237
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearVersion() {
      bitField0_ = (bitField0_ & ~0x00000800);
      version_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.logging.v2.LogMetric)
  }

  // @@protoc_insertion_point(class_scope:google.logging.v2.LogMetric)
  private static final com.google.logging.v2.LogMetric DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.logging.v2.LogMetric();
  }

  public static com.google.logging.v2.LogMetric getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LogMetric> PARSER =
      new com.google.protobuf.AbstractParser<LogMetric>() {
        @java.lang.Override
        public LogMetric parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LogMetric> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LogMetric> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.logging.v2.LogMetric getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
