/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/logging/v2/logging_config.proto

package com.google.logging.v2;

/**
 *
 *
 * <pre>
 * Describes a link connected to an analytics enabled bucket.
 * </pre>
 *
 * Protobuf type {@code google.logging.v2.Link}
 */
public final class Link extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.logging.v2.Link)
    LinkOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Link.newBuilder() to construct.
  private Link(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Link() {
    name_ = "";
    description_ = "";
    lifecycleState_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Link();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.logging.v2.LoggingConfigProto
        .internal_static_google_logging_v2_Link_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.logging.v2.LoggingConfigProto
        .internal_static_google_logging_v2_Link_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.logging.v2.Link.class, com.google.logging.v2.Link.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the link. The name can have up to 100 characters.
   * A valid link id (at the end of the link name) must only have alphanumeric
   * characters and underscores within it.
   *
   *     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
   *     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
   *     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
   *     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
   *
   * For example:
   *
   *   `projects/my-project/locations/global/buckets/my-bucket/links/my_link
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the link. The name can have up to 100 characters.
   * A valid link id (at the end of the link name) must only have alphanumeric
   * characters and underscores within it.
   *
   *     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
   *     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
   *     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
   *     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
   *
   * For example:
   *
   *   `projects/my-project/locations/global/buckets/my-bucket/links/my_link
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Describes this link.
   *
   * The maximum length of the description is 8000 characters.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Describes this link.
   *
   * The maximum length of the description is 8000 characters.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of the link.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of the link.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of the link.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int LIFECYCLE_STATE_FIELD_NUMBER = 4;
  private int lifecycleState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The resource lifecycle state.
   * </pre>
   *
   * <code>
   * .google.logging.v2.LifecycleState lifecycle_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for lifecycleState.
   */
  @java.lang.Override
  public int getLifecycleStateValue() {
    return lifecycleState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource lifecycle state.
   * </pre>
   *
   * <code>
   * .google.logging.v2.LifecycleState lifecycle_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lifecycleState.
   */
  @java.lang.Override
  public com.google.logging.v2.LifecycleState getLifecycleState() {
    com.google.logging.v2.LifecycleState result =
        com.google.logging.v2.LifecycleState.forNumber(lifecycleState_);
    return result == null ? com.google.logging.v2.LifecycleState.UNRECOGNIZED : result;
  }

  public static final int BIGQUERY_DATASET_FIELD_NUMBER = 5;
  private com.google.logging.v2.BigQueryDataset bigqueryDataset_;
  /**
   *
   *
   * <pre>
   * The information of a BigQuery Dataset. When a link is created, a BigQuery
   * dataset is created along with it, in the same project as the LogBucket it's
   * linked to. This dataset will also have BigQuery Views corresponding to the
   * LogViews in the bucket.
   * </pre>
   *
   * <code>.google.logging.v2.BigQueryDataset bigquery_dataset = 5;</code>
   *
   * @return Whether the bigqueryDataset field is set.
   */
  @java.lang.Override
  public boolean hasBigqueryDataset() {
    return bigqueryDataset_ != null;
  }
  /**
   *
   *
   * <pre>
   * The information of a BigQuery Dataset. When a link is created, a BigQuery
   * dataset is created along with it, in the same project as the LogBucket it's
   * linked to. This dataset will also have BigQuery Views corresponding to the
   * LogViews in the bucket.
   * </pre>
   *
   * <code>.google.logging.v2.BigQueryDataset bigquery_dataset = 5;</code>
   *
   * @return The bigqueryDataset.
   */
  @java.lang.Override
  public com.google.logging.v2.BigQueryDataset getBigqueryDataset() {
    return bigqueryDataset_ == null
        ? com.google.logging.v2.BigQueryDataset.getDefaultInstance()
        : bigqueryDataset_;
  }
  /**
   *
   *
   * <pre>
   * The information of a BigQuery Dataset. When a link is created, a BigQuery
   * dataset is created along with it, in the same project as the LogBucket it's
   * linked to. This dataset will also have BigQuery Views corresponding to the
   * LogViews in the bucket.
   * </pre>
   *
   * <code>.google.logging.v2.BigQueryDataset bigquery_dataset = 5;</code>
   */
  @java.lang.Override
  public com.google.logging.v2.BigQueryDatasetOrBuilder getBigqueryDatasetOrBuilder() {
    return bigqueryDataset_ == null
        ? com.google.logging.v2.BigQueryDataset.getDefaultInstance()
        : bigqueryDataset_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (lifecycleState_
        != com.google.logging.v2.LifecycleState.LIFECYCLE_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, lifecycleState_);
    }
    if (bigqueryDataset_ != null) {
      output.writeMessage(5, getBigqueryDataset());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (lifecycleState_
        != com.google.logging.v2.LifecycleState.LIFECYCLE_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, lifecycleState_);
    }
    if (bigqueryDataset_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getBigqueryDataset());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.logging.v2.Link)) {
      return super.equals(obj);
    }
    com.google.logging.v2.Link other = (com.google.logging.v2.Link) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (lifecycleState_ != other.lifecycleState_) return false;
    if (hasBigqueryDataset() != other.hasBigqueryDataset()) return false;
    if (hasBigqueryDataset()) {
      if (!getBigqueryDataset().equals(other.getBigqueryDataset())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + LIFECYCLE_STATE_FIELD_NUMBER;
    hash = (53 * hash) + lifecycleState_;
    if (hasBigqueryDataset()) {
      hash = (37 * hash) + BIGQUERY_DATASET_FIELD_NUMBER;
      hash = (53 * hash) + getBigqueryDataset().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.logging.v2.Link parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.Link parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.Link parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.Link parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.Link parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.Link parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.Link parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.Link parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.Link parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.Link parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.Link parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.Link parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.logging.v2.Link prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes a link connected to an analytics enabled bucket.
   * </pre>
   *
   * Protobuf type {@code google.logging.v2.Link}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.logging.v2.Link)
      com.google.logging.v2.LinkOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.logging.v2.LoggingConfigProto
          .internal_static_google_logging_v2_Link_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.logging.v2.LoggingConfigProto
          .internal_static_google_logging_v2_Link_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.logging.v2.Link.class, com.google.logging.v2.Link.Builder.class);
    }

    // Construct using com.google.logging.v2.Link.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      lifecycleState_ = 0;
      bigqueryDataset_ = null;
      if (bigqueryDatasetBuilder_ != null) {
        bigqueryDatasetBuilder_.dispose();
        bigqueryDatasetBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.logging.v2.LoggingConfigProto
          .internal_static_google_logging_v2_Link_descriptor;
    }

    @java.lang.Override
    public com.google.logging.v2.Link getDefaultInstanceForType() {
      return com.google.logging.v2.Link.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.logging.v2.Link build() {
      com.google.logging.v2.Link result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.logging.v2.Link buildPartial() {
      com.google.logging.v2.Link result = new com.google.logging.v2.Link(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.logging.v2.Link result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.lifecycleState_ = lifecycleState_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.bigqueryDataset_ =
            bigqueryDatasetBuilder_ == null ? bigqueryDataset_ : bigqueryDatasetBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.logging.v2.Link) {
        return mergeFrom((com.google.logging.v2.Link) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.logging.v2.Link other) {
      if (other == com.google.logging.v2.Link.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.lifecycleState_ != 0) {
        setLifecycleStateValue(other.getLifecycleStateValue());
      }
      if (other.hasBigqueryDataset()) {
        mergeBigqueryDataset(other.getBigqueryDataset());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                lifecycleState_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getBigqueryDatasetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the link. The name can have up to 100 characters.
     * A valid link id (at the end of the link name) must only have alphanumeric
     * characters and underscores within it.
     *
     *     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *
     * For example:
     *
     *   `projects/my-project/locations/global/buckets/my-bucket/links/my_link
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the link. The name can have up to 100 characters.
     * A valid link id (at the end of the link name) must only have alphanumeric
     * characters and underscores within it.
     *
     *     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *
     * For example:
     *
     *   `projects/my-project/locations/global/buckets/my-bucket/links/my_link
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the link. The name can have up to 100 characters.
     * A valid link id (at the end of the link name) must only have alphanumeric
     * characters and underscores within it.
     *
     *     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *
     * For example:
     *
     *   `projects/my-project/locations/global/buckets/my-bucket/links/my_link
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the link. The name can have up to 100 characters.
     * A valid link id (at the end of the link name) must only have alphanumeric
     * characters and underscores within it.
     *
     *     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *
     * For example:
     *
     *   `projects/my-project/locations/global/buckets/my-bucket/links/my_link
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the link. The name can have up to 100 characters.
     * A valid link id (at the end of the link name) must only have alphanumeric
     * characters and underscores within it.
     *
     *     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_ID]"
     *
     * For example:
     *
     *   `projects/my-project/locations/global/buckets/my-bucket/links/my_link
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Describes this link.
     *
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Describes this link.
     *
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Describes this link.
     *
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes this link.
     *
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes this link.
     *
     * The maximum length of the description is 8000 characters.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the link.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the link.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the link.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the link.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the link.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the link.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the link.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the link.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the link.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private int lifecycleState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The resource lifecycle state.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LifecycleState lifecycle_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for lifecycleState.
     */
    @java.lang.Override
    public int getLifecycleStateValue() {
      return lifecycleState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource lifecycle state.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LifecycleState lifecycle_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for lifecycleState to set.
     * @return This builder for chaining.
     */
    public Builder setLifecycleStateValue(int value) {
      lifecycleState_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource lifecycle state.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LifecycleState lifecycle_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lifecycleState.
     */
    @java.lang.Override
    public com.google.logging.v2.LifecycleState getLifecycleState() {
      com.google.logging.v2.LifecycleState result =
          com.google.logging.v2.LifecycleState.forNumber(lifecycleState_);
      return result == null ? com.google.logging.v2.LifecycleState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource lifecycle state.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LifecycleState lifecycle_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The lifecycleState to set.
     * @return This builder for chaining.
     */
    public Builder setLifecycleState(com.google.logging.v2.LifecycleState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      lifecycleState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource lifecycle state.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LifecycleState lifecycle_state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLifecycleState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      lifecycleState_ = 0;
      onChanged();
      return this;
    }

    private com.google.logging.v2.BigQueryDataset bigqueryDataset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.v2.BigQueryDataset,
            com.google.logging.v2.BigQueryDataset.Builder,
            com.google.logging.v2.BigQueryDatasetOrBuilder>
        bigqueryDatasetBuilder_;
    /**
     *
     *
     * <pre>
     * The information of a BigQuery Dataset. When a link is created, a BigQuery
     * dataset is created along with it, in the same project as the LogBucket it's
     * linked to. This dataset will also have BigQuery Views corresponding to the
     * LogViews in the bucket.
     * </pre>
     *
     * <code>.google.logging.v2.BigQueryDataset bigquery_dataset = 5;</code>
     *
     * @return Whether the bigqueryDataset field is set.
     */
    public boolean hasBigqueryDataset() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The information of a BigQuery Dataset. When a link is created, a BigQuery
     * dataset is created along with it, in the same project as the LogBucket it's
     * linked to. This dataset will also have BigQuery Views corresponding to the
     * LogViews in the bucket.
     * </pre>
     *
     * <code>.google.logging.v2.BigQueryDataset bigquery_dataset = 5;</code>
     *
     * @return The bigqueryDataset.
     */
    public com.google.logging.v2.BigQueryDataset getBigqueryDataset() {
      if (bigqueryDatasetBuilder_ == null) {
        return bigqueryDataset_ == null
            ? com.google.logging.v2.BigQueryDataset.getDefaultInstance()
            : bigqueryDataset_;
      } else {
        return bigqueryDatasetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The information of a BigQuery Dataset. When a link is created, a BigQuery
     * dataset is created along with it, in the same project as the LogBucket it's
     * linked to. This dataset will also have BigQuery Views corresponding to the
     * LogViews in the bucket.
     * </pre>
     *
     * <code>.google.logging.v2.BigQueryDataset bigquery_dataset = 5;</code>
     */
    public Builder setBigqueryDataset(com.google.logging.v2.BigQueryDataset value) {
      if (bigqueryDatasetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        bigqueryDataset_ = value;
      } else {
        bigqueryDatasetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The information of a BigQuery Dataset. When a link is created, a BigQuery
     * dataset is created along with it, in the same project as the LogBucket it's
     * linked to. This dataset will also have BigQuery Views corresponding to the
     * LogViews in the bucket.
     * </pre>
     *
     * <code>.google.logging.v2.BigQueryDataset bigquery_dataset = 5;</code>
     */
    public Builder setBigqueryDataset(
        com.google.logging.v2.BigQueryDataset.Builder builderForValue) {
      if (bigqueryDatasetBuilder_ == null) {
        bigqueryDataset_ = builderForValue.build();
      } else {
        bigqueryDatasetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The information of a BigQuery Dataset. When a link is created, a BigQuery
     * dataset is created along with it, in the same project as the LogBucket it's
     * linked to. This dataset will also have BigQuery Views corresponding to the
     * LogViews in the bucket.
     * </pre>
     *
     * <code>.google.logging.v2.BigQueryDataset bigquery_dataset = 5;</code>
     */
    public Builder mergeBigqueryDataset(com.google.logging.v2.BigQueryDataset value) {
      if (bigqueryDatasetBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && bigqueryDataset_ != null
            && bigqueryDataset_ != com.google.logging.v2.BigQueryDataset.getDefaultInstance()) {
          getBigqueryDatasetBuilder().mergeFrom(value);
        } else {
          bigqueryDataset_ = value;
        }
      } else {
        bigqueryDatasetBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The information of a BigQuery Dataset. When a link is created, a BigQuery
     * dataset is created along with it, in the same project as the LogBucket it's
     * linked to. This dataset will also have BigQuery Views corresponding to the
     * LogViews in the bucket.
     * </pre>
     *
     * <code>.google.logging.v2.BigQueryDataset bigquery_dataset = 5;</code>
     */
    public Builder clearBigqueryDataset() {
      bitField0_ = (bitField0_ & ~0x00000010);
      bigqueryDataset_ = null;
      if (bigqueryDatasetBuilder_ != null) {
        bigqueryDatasetBuilder_.dispose();
        bigqueryDatasetBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The information of a BigQuery Dataset. When a link is created, a BigQuery
     * dataset is created along with it, in the same project as the LogBucket it's
     * linked to. This dataset will also have BigQuery Views corresponding to the
     * LogViews in the bucket.
     * </pre>
     *
     * <code>.google.logging.v2.BigQueryDataset bigquery_dataset = 5;</code>
     */
    public com.google.logging.v2.BigQueryDataset.Builder getBigqueryDatasetBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getBigqueryDatasetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The information of a BigQuery Dataset. When a link is created, a BigQuery
     * dataset is created along with it, in the same project as the LogBucket it's
     * linked to. This dataset will also have BigQuery Views corresponding to the
     * LogViews in the bucket.
     * </pre>
     *
     * <code>.google.logging.v2.BigQueryDataset bigquery_dataset = 5;</code>
     */
    public com.google.logging.v2.BigQueryDatasetOrBuilder getBigqueryDatasetOrBuilder() {
      if (bigqueryDatasetBuilder_ != null) {
        return bigqueryDatasetBuilder_.getMessageOrBuilder();
      } else {
        return bigqueryDataset_ == null
            ? com.google.logging.v2.BigQueryDataset.getDefaultInstance()
            : bigqueryDataset_;
      }
    }
    /**
     *
     *
     * <pre>
     * The information of a BigQuery Dataset. When a link is created, a BigQuery
     * dataset is created along with it, in the same project as the LogBucket it's
     * linked to. This dataset will also have BigQuery Views corresponding to the
     * LogViews in the bucket.
     * </pre>
     *
     * <code>.google.logging.v2.BigQueryDataset bigquery_dataset = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.v2.BigQueryDataset,
            com.google.logging.v2.BigQueryDataset.Builder,
            com.google.logging.v2.BigQueryDatasetOrBuilder>
        getBigqueryDatasetFieldBuilder() {
      if (bigqueryDatasetBuilder_ == null) {
        bigqueryDatasetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.logging.v2.BigQueryDataset,
                com.google.logging.v2.BigQueryDataset.Builder,
                com.google.logging.v2.BigQueryDatasetOrBuilder>(
                getBigqueryDataset(), getParentForChildren(), isClean());
        bigqueryDataset_ = null;
      }
      return bigqueryDatasetBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.logging.v2.Link)
  }

  // @@protoc_insertion_point(class_scope:google.logging.v2.Link)
  private static final com.google.logging.v2.Link DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.logging.v2.Link();
  }

  public static com.google.logging.v2.Link getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Link> PARSER =
      new com.google.protobuf.AbstractParser<Link>() {
        @java.lang.Override
        public Link parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Link> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Link> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.logging.v2.Link getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
