/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/logging/v2/log_entry.proto

package com.google.logging.v2;

/**
 *
 *
 * <pre>
 * An individual entry in a log.
 * </pre>
 *
 * Protobuf type {@code google.logging.v2.LogEntry}
 */
public final class LogEntry extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.logging.v2.LogEntry)
    LogEntryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LogEntry.newBuilder() to construct.
  private LogEntry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LogEntry() {
    logName_ = "";
    severity_ = 0;
    insertId_ = "";
    trace_ = "";
    spanId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LogEntry();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.logging.v2.LogEntryProto
        .internal_static_google_logging_v2_LogEntry_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 11:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.logging.v2.LogEntryProto
        .internal_static_google_logging_v2_LogEntry_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.logging.v2.LogEntry.class, com.google.logging.v2.LogEntry.Builder.class);
  }

  private int payloadCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object payload_;

  public enum PayloadCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PROTO_PAYLOAD(2),
    TEXT_PAYLOAD(3),
    JSON_PAYLOAD(6),
    PAYLOAD_NOT_SET(0);
    private final int value;

    private PayloadCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PayloadCase valueOf(int value) {
      return forNumber(value);
    }

    public static PayloadCase forNumber(int value) {
      switch (value) {
        case 2:
          return PROTO_PAYLOAD;
        case 3:
          return TEXT_PAYLOAD;
        case 6:
          return JSON_PAYLOAD;
        case 0:
          return PAYLOAD_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PayloadCase getPayloadCase() {
    return PayloadCase.forNumber(payloadCase_);
  }

  public static final int LOG_NAME_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object logName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the log to which this log entry belongs:
   *
   *     "projects/[PROJECT_ID]/logs/[LOG_ID]"
   *     "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
   *     "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
   *     "folders/[FOLDER_ID]/logs/[LOG_ID]"
   *
   * A project number may be used in place of PROJECT_ID. The project number is
   * translated to its corresponding PROJECT_ID internally and the `log_name`
   * field will contain PROJECT_ID in queries and exports.
   *
   * `[LOG_ID]` must be URL-encoded within `log_name`. Example:
   * `"organizations/1234567890/logs/cloudresourcemanager.googleapis.com%2Factivity"`.
   *
   * `[LOG_ID]` must be less than 512 characters long and can only include the
   * following characters: upper and lower case alphanumeric characters,
   * forward-slash, underscore, hyphen, and period.
   *
   * For backward compatibility, if `log_name` begins with a forward-slash, such
   * as `/projects/...`, then the log entry is ingested as usual, but the
   * forward-slash is removed. Listing the log entry will not show the leading
   * slash and filtering for a log name with a leading slash will never return
   * any results.
   * </pre>
   *
   * <code>string log_name = 12 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The logName.
   */
  @java.lang.Override
  public java.lang.String getLogName() {
    java.lang.Object ref = logName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      logName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the log to which this log entry belongs:
   *
   *     "projects/[PROJECT_ID]/logs/[LOG_ID]"
   *     "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
   *     "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
   *     "folders/[FOLDER_ID]/logs/[LOG_ID]"
   *
   * A project number may be used in place of PROJECT_ID. The project number is
   * translated to its corresponding PROJECT_ID internally and the `log_name`
   * field will contain PROJECT_ID in queries and exports.
   *
   * `[LOG_ID]` must be URL-encoded within `log_name`. Example:
   * `"organizations/1234567890/logs/cloudresourcemanager.googleapis.com%2Factivity"`.
   *
   * `[LOG_ID]` must be less than 512 characters long and can only include the
   * following characters: upper and lower case alphanumeric characters,
   * forward-slash, underscore, hyphen, and period.
   *
   * For backward compatibility, if `log_name` begins with a forward-slash, such
   * as `/projects/...`, then the log entry is ingested as usual, but the
   * forward-slash is removed. Listing the log entry will not show the leading
   * slash and filtering for a log name with a leading slash will never return
   * any results.
   * </pre>
   *
   * <code>string log_name = 12 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for logName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLogNameBytes() {
    java.lang.Object ref = logName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      logName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_FIELD_NUMBER = 8;
  private com.google.api.MonitoredResource resource_;
  /**
   *
   *
   * <pre>
   * Required. The monitored resource that produced this log entry.
   *
   * Example: a log entry that reports a database error would be associated with
   * the monitored resource designating the particular database that reported
   * the error.
   * </pre>
   *
   * <code>.google.api.MonitoredResource resource = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the resource field is set.
   */
  @java.lang.Override
  public boolean hasResource() {
    return resource_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The monitored resource that produced this log entry.
   *
   * Example: a log entry that reports a database error would be associated with
   * the monitored resource designating the particular database that reported
   * the error.
   * </pre>
   *
   * <code>.google.api.MonitoredResource resource = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The resource.
   */
  @java.lang.Override
  public com.google.api.MonitoredResource getResource() {
    return resource_ == null ? com.google.api.MonitoredResource.getDefaultInstance() : resource_;
  }
  /**
   *
   *
   * <pre>
   * Required. The monitored resource that produced this log entry.
   *
   * Example: a log entry that reports a database error would be associated with
   * the monitored resource designating the particular database that reported
   * the error.
   * </pre>
   *
   * <code>.google.api.MonitoredResource resource = 8 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.api.MonitoredResourceOrBuilder getResourceOrBuilder() {
    return resource_ == null ? com.google.api.MonitoredResource.getDefaultInstance() : resource_;
  }

  public static final int PROTO_PAYLOAD_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The log entry payload, represented as a protocol buffer. Some Google
   * Cloud Platform services use this field for their log entry payloads.
   *
   * The following protocol buffer types are supported; user-defined types
   * are not supported:
   *
   *   "type.googleapis.com/google.cloud.audit.AuditLog"
   *   "type.googleapis.com/google.appengine.logging.v1.RequestLog"
   * </pre>
   *
   * <code>.google.protobuf.Any proto_payload = 2;</code>
   *
   * @return Whether the protoPayload field is set.
   */
  @java.lang.Override
  public boolean hasProtoPayload() {
    return payloadCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The log entry payload, represented as a protocol buffer. Some Google
   * Cloud Platform services use this field for their log entry payloads.
   *
   * The following protocol buffer types are supported; user-defined types
   * are not supported:
   *
   *   "type.googleapis.com/google.cloud.audit.AuditLog"
   *   "type.googleapis.com/google.appengine.logging.v1.RequestLog"
   * </pre>
   *
   * <code>.google.protobuf.Any proto_payload = 2;</code>
   *
   * @return The protoPayload.
   */
  @java.lang.Override
  public com.google.protobuf.Any getProtoPayload() {
    if (payloadCase_ == 2) {
      return (com.google.protobuf.Any) payload_;
    }
    return com.google.protobuf.Any.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The log entry payload, represented as a protocol buffer. Some Google
   * Cloud Platform services use this field for their log entry payloads.
   *
   * The following protocol buffer types are supported; user-defined types
   * are not supported:
   *
   *   "type.googleapis.com/google.cloud.audit.AuditLog"
   *   "type.googleapis.com/google.appengine.logging.v1.RequestLog"
   * </pre>
   *
   * <code>.google.protobuf.Any proto_payload = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.AnyOrBuilder getProtoPayloadOrBuilder() {
    if (payloadCase_ == 2) {
      return (com.google.protobuf.Any) payload_;
    }
    return com.google.protobuf.Any.getDefaultInstance();
  }

  public static final int TEXT_PAYLOAD_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The log entry payload, represented as a Unicode string (UTF-8).
   * </pre>
   *
   * <code>string text_payload = 3;</code>
   *
   * @return Whether the textPayload field is set.
   */
  public boolean hasTextPayload() {
    return payloadCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The log entry payload, represented as a Unicode string (UTF-8).
   * </pre>
   *
   * <code>string text_payload = 3;</code>
   *
   * @return The textPayload.
   */
  public java.lang.String getTextPayload() {
    java.lang.Object ref = "";
    if (payloadCase_ == 3) {
      ref = payload_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (payloadCase_ == 3) {
        payload_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The log entry payload, represented as a Unicode string (UTF-8).
   * </pre>
   *
   * <code>string text_payload = 3;</code>
   *
   * @return The bytes for textPayload.
   */
  public com.google.protobuf.ByteString getTextPayloadBytes() {
    java.lang.Object ref = "";
    if (payloadCase_ == 3) {
      ref = payload_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (payloadCase_ == 3) {
        payload_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int JSON_PAYLOAD_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * The log entry payload, represented as a structure that is
   * expressed as a JSON object.
   * </pre>
   *
   * <code>.google.protobuf.Struct json_payload = 6;</code>
   *
   * @return Whether the jsonPayload field is set.
   */
  @java.lang.Override
  public boolean hasJsonPayload() {
    return payloadCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * The log entry payload, represented as a structure that is
   * expressed as a JSON object.
   * </pre>
   *
   * <code>.google.protobuf.Struct json_payload = 6;</code>
   *
   * @return The jsonPayload.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getJsonPayload() {
    if (payloadCase_ == 6) {
      return (com.google.protobuf.Struct) payload_;
    }
    return com.google.protobuf.Struct.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The log entry payload, represented as a structure that is
   * expressed as a JSON object.
   * </pre>
   *
   * <code>.google.protobuf.Struct json_payload = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getJsonPayloadOrBuilder() {
    if (payloadCase_ == 6) {
      return (com.google.protobuf.Struct) payload_;
    }
    return com.google.protobuf.Struct.getDefaultInstance();
  }

  public static final int TIMESTAMP_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp timestamp_;
  /**
   *
   *
   * <pre>
   * Optional. The time the event described by the log entry occurred. This time
   * is used to compute the log entry's age and to enforce the logs retention
   * period. If this field is omitted in a new log entry, then Logging assigns
   * it the current time. Timestamps have nanosecond accuracy, but trailing
   * zeros in the fractional seconds might be omitted when the timestamp is
   * displayed.
   *
   * Incoming log entries must have timestamps that don't exceed the
   * [logs retention
   * period](https://cloud.google.com/logging/quotas#logs_retention_periods) in
   * the past, and that don't exceed 24 hours in the future. Log entries outside
   * those time boundaries aren't ingested by Logging.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the timestamp field is set.
   */
  @java.lang.Override
  public boolean hasTimestamp() {
    return timestamp_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The time the event described by the log entry occurred. This time
   * is used to compute the log entry's age and to enforce the logs retention
   * period. If this field is omitted in a new log entry, then Logging assigns
   * it the current time. Timestamps have nanosecond accuracy, but trailing
   * zeros in the fractional seconds might be omitted when the timestamp is
   * displayed.
   *
   * Incoming log entries must have timestamps that don't exceed the
   * [logs retention
   * period](https://cloud.google.com/logging/quotas#logs_retention_periods) in
   * the past, and that don't exceed 24 hours in the future. Log entries outside
   * those time boundaries aren't ingested by Logging.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The timestamp.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getTimestamp() {
    return timestamp_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The time the event described by the log entry occurred. This time
   * is used to compute the log entry's age and to enforce the logs retention
   * period. If this field is omitted in a new log entry, then Logging assigns
   * it the current time. Timestamps have nanosecond accuracy, but trailing
   * zeros in the fractional seconds might be omitted when the timestamp is
   * displayed.
   *
   * Incoming log entries must have timestamps that don't exceed the
   * [logs retention
   * period](https://cloud.google.com/logging/quotas#logs_retention_periods) in
   * the past, and that don't exceed 24 hours in the future. Log entries outside
   * those time boundaries aren't ingested by Logging.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder() {
    return timestamp_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
  }

  public static final int RECEIVE_TIMESTAMP_FIELD_NUMBER = 24;
  private com.google.protobuf.Timestamp receiveTimestamp_;
  /**
   *
   *
   * <pre>
   * Output only. The time the log entry was received by Logging.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp receive_timestamp = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the receiveTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasReceiveTimestamp() {
    return receiveTimestamp_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the log entry was received by Logging.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp receive_timestamp = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The receiveTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReceiveTimestamp() {
    return receiveTimestamp_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : receiveTimestamp_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the log entry was received by Logging.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp receive_timestamp = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReceiveTimestampOrBuilder() {
    return receiveTimestamp_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : receiveTimestamp_;
  }

  public static final int SEVERITY_FIELD_NUMBER = 10;
  private int severity_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The severity of the log entry. The default value is
   * `LogSeverity.DEFAULT`.
   * </pre>
   *
   * <code>.google.logging.type.LogSeverity severity = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for severity.
   */
  @java.lang.Override
  public int getSeverityValue() {
    return severity_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The severity of the log entry. The default value is
   * `LogSeverity.DEFAULT`.
   * </pre>
   *
   * <code>.google.logging.type.LogSeverity severity = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The severity.
   */
  @java.lang.Override
  public com.google.logging.type.LogSeverity getSeverity() {
    com.google.logging.type.LogSeverity result =
        com.google.logging.type.LogSeverity.forNumber(severity_);
    return result == null ? com.google.logging.type.LogSeverity.UNRECOGNIZED : result;
  }

  public static final int INSERT_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object insertId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for the log entry. If you provide a value,
   * then Logging considers other log entries in the same project, with the same
   * `timestamp`, and with the same `insert_id` to be duplicates which are
   * removed in a single query result. However, there are no guarantees of
   * de-duplication in the export of logs.
   *
   * If the `insert_id` is omitted when writing a log entry, the Logging API
   * assigns its own unique identifier in this field.
   *
   * In queries, the `insert_id` is also used to order log entries that have
   * the same `log_name` and `timestamp` values.
   * </pre>
   *
   * <code>string insert_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The insertId.
   */
  @java.lang.Override
  public java.lang.String getInsertId() {
    java.lang.Object ref = insertId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      insertId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for the log entry. If you provide a value,
   * then Logging considers other log entries in the same project, with the same
   * `timestamp`, and with the same `insert_id` to be duplicates which are
   * removed in a single query result. However, there are no guarantees of
   * de-duplication in the export of logs.
   *
   * If the `insert_id` is omitted when writing a log entry, the Logging API
   * assigns its own unique identifier in this field.
   *
   * In queries, the `insert_id` is also used to order log entries that have
   * the same `log_name` and `timestamp` values.
   * </pre>
   *
   * <code>string insert_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for insertId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInsertIdBytes() {
    java.lang.Object ref = insertId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      insertId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HTTP_REQUEST_FIELD_NUMBER = 7;
  private com.google.logging.type.HttpRequest httpRequest_;
  /**
   *
   *
   * <pre>
   * Optional. Information about the HTTP request associated with this log
   * entry, if applicable.
   * </pre>
   *
   * <code>
   * .google.logging.type.HttpRequest http_request = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the httpRequest field is set.
   */
  @java.lang.Override
  public boolean hasHttpRequest() {
    return httpRequest_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Information about the HTTP request associated with this log
   * entry, if applicable.
   * </pre>
   *
   * <code>
   * .google.logging.type.HttpRequest http_request = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The httpRequest.
   */
  @java.lang.Override
  public com.google.logging.type.HttpRequest getHttpRequest() {
    return httpRequest_ == null
        ? com.google.logging.type.HttpRequest.getDefaultInstance()
        : httpRequest_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Information about the HTTP request associated with this log
   * entry, if applicable.
   * </pre>
   *
   * <code>
   * .google.logging.type.HttpRequest http_request = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.logging.type.HttpRequestOrBuilder getHttpRequestOrBuilder() {
    return httpRequest_ == null
        ? com.google.logging.type.HttpRequest.getDefaultInstance()
        : httpRequest_;
  }

  public static final int LABELS_FIELD_NUMBER = 11;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.logging.v2.LogEntryProto
                .internal_static_google_logging_v2_LogEntry_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A map of key, value pairs that provides additional information
   * about the log entry. The labels can be user-defined or system-defined.
   *
   * User-defined labels are arbitrary key, value pairs that you can use to
   * classify logs.
   *
   * System-defined labels are defined by GCP services for platform logs.
   * They have two components - a service namespace component and the
   * attribute name. For example: `compute.googleapis.com/resource_name`.
   *
   * Cloud Logging truncates label keys that exceed 512 B and label
   * values that exceed 64 KB upon their associated log entry being
   * written. The truncation is indicated by an ellipsis at the
   * end of the character string.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. A map of key, value pairs that provides additional information
   * about the log entry. The labels can be user-defined or system-defined.
   *
   * User-defined labels are arbitrary key, value pairs that you can use to
   * classify logs.
   *
   * System-defined labels are defined by GCP services for platform logs.
   * They have two components - a service namespace component and the
   * attribute name. For example: `compute.googleapis.com/resource_name`.
   *
   * Cloud Logging truncates label keys that exceed 512 B and label
   * values that exceed 64 KB upon their associated log entry being
   * written. The truncation is indicated by an ellipsis at the
   * end of the character string.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. A map of key, value pairs that provides additional information
   * about the log entry. The labels can be user-defined or system-defined.
   *
   * User-defined labels are arbitrary key, value pairs that you can use to
   * classify logs.
   *
   * System-defined labels are defined by GCP services for platform logs.
   * They have two components - a service namespace component and the
   * attribute name. For example: `compute.googleapis.com/resource_name`.
   *
   * Cloud Logging truncates label keys that exceed 512 B and label
   * values that exceed 64 KB upon their associated log entry being
   * written. The truncation is indicated by an ellipsis at the
   * end of the character string.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. A map of key, value pairs that provides additional information
   * about the log entry. The labels can be user-defined or system-defined.
   *
   * User-defined labels are arbitrary key, value pairs that you can use to
   * classify logs.
   *
   * System-defined labels are defined by GCP services for platform logs.
   * They have two components - a service namespace component and the
   * attribute name. For example: `compute.googleapis.com/resource_name`.
   *
   * Cloud Logging truncates label keys that exceed 512 B and label
   * values that exceed 64 KB upon their associated log entry being
   * written. The truncation is indicated by an ellipsis at the
   * end of the character string.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int OPERATION_FIELD_NUMBER = 15;
  private com.google.logging.v2.LogEntryOperation operation_;
  /**
   *
   *
   * <pre>
   * Optional. Information about an operation associated with the log entry, if
   * applicable.
   * </pre>
   *
   * <code>
   * .google.logging.v2.LogEntryOperation operation = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the operation field is set.
   */
  @java.lang.Override
  public boolean hasOperation() {
    return operation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Information about an operation associated with the log entry, if
   * applicable.
   * </pre>
   *
   * <code>
   * .google.logging.v2.LogEntryOperation operation = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The operation.
   */
  @java.lang.Override
  public com.google.logging.v2.LogEntryOperation getOperation() {
    return operation_ == null
        ? com.google.logging.v2.LogEntryOperation.getDefaultInstance()
        : operation_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Information about an operation associated with the log entry, if
   * applicable.
   * </pre>
   *
   * <code>
   * .google.logging.v2.LogEntryOperation operation = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.logging.v2.LogEntryOperationOrBuilder getOperationOrBuilder() {
    return operation_ == null
        ? com.google.logging.v2.LogEntryOperation.getDefaultInstance()
        : operation_;
  }

  public static final int TRACE_FIELD_NUMBER = 22;

  @SuppressWarnings("serial")
  private volatile java.lang.Object trace_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The REST resource name of the trace being written to
   * [Cloud Trace](https://cloud.google.com/trace) in
   * association with this log entry. For example, if your trace data is stored
   * in the Cloud project "my-trace-project" and if the service that is creating
   * the log entry receives a trace header that includes the trace ID "12345",
   * then the service should use "projects/my-tracing-project/traces/12345".
   *
   * The `trace` field provides the link between logs and traces. By using
   * this field, you can navigate from a log entry to a trace.
   * </pre>
   *
   * <code>string trace = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The trace.
   */
  @java.lang.Override
  public java.lang.String getTrace() {
    java.lang.Object ref = trace_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      trace_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The REST resource name of the trace being written to
   * [Cloud Trace](https://cloud.google.com/trace) in
   * association with this log entry. For example, if your trace data is stored
   * in the Cloud project "my-trace-project" and if the service that is creating
   * the log entry receives a trace header that includes the trace ID "12345",
   * then the service should use "projects/my-tracing-project/traces/12345".
   *
   * The `trace` field provides the link between logs and traces. By using
   * this field, you can navigate from a log entry to a trace.
   * </pre>
   *
   * <code>string trace = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for trace.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTraceBytes() {
    java.lang.Object ref = trace_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      trace_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SPAN_ID_FIELD_NUMBER = 27;

  @SuppressWarnings("serial")
  private volatile java.lang.Object spanId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The ID of the [Cloud Trace](https://cloud.google.com/trace) span
   * associated with the current operation in which the log is being written.
   * For example, if a span has the REST resource name of
   * "projects/some-project/traces/some-trace/spans/some-span-id", then the
   * `span_id` field is "some-span-id".
   *
   * A
   * [Span](https://cloud.google.com/trace/docs/reference/v2/rest/v2/projects.traces/batchWrite#Span)
   * represents a single operation within a trace. Whereas a trace may involve
   * multiple different microservices running on multiple different machines,
   * a span generally corresponds to a single logical operation being performed
   * in a single instance of a microservice on one specific machine. Spans
   * are the nodes within the tree that is a trace.
   *
   * Applications that are [instrumented for
   * tracing](https://cloud.google.com/trace/docs/setup) will generally assign a
   * new, unique span ID on each incoming request. It is also common to create
   * and record additional spans corresponding to internal processing elements
   * as well as issuing requests to dependencies.
   *
   * The span ID is expected to be a 16-character, hexadecimal encoding of an
   * 8-byte array and should not be zero. It should be unique within the trace
   * and should, ideally, be generated in a manner that is uniformly random.
   *
   * Example values:
   *
   *   - `000000000000004a`
   *   - `7a2190356c3fc94b`
   *   - `0000f00300090021`
   *   - `d39223e101960076`
   * </pre>
   *
   * <code>string span_id = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The spanId.
   */
  @java.lang.Override
  public java.lang.String getSpanId() {
    java.lang.Object ref = spanId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      spanId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The ID of the [Cloud Trace](https://cloud.google.com/trace) span
   * associated with the current operation in which the log is being written.
   * For example, if a span has the REST resource name of
   * "projects/some-project/traces/some-trace/spans/some-span-id", then the
   * `span_id` field is "some-span-id".
   *
   * A
   * [Span](https://cloud.google.com/trace/docs/reference/v2/rest/v2/projects.traces/batchWrite#Span)
   * represents a single operation within a trace. Whereas a trace may involve
   * multiple different microservices running on multiple different machines,
   * a span generally corresponds to a single logical operation being performed
   * in a single instance of a microservice on one specific machine. Spans
   * are the nodes within the tree that is a trace.
   *
   * Applications that are [instrumented for
   * tracing](https://cloud.google.com/trace/docs/setup) will generally assign a
   * new, unique span ID on each incoming request. It is also common to create
   * and record additional spans corresponding to internal processing elements
   * as well as issuing requests to dependencies.
   *
   * The span ID is expected to be a 16-character, hexadecimal encoding of an
   * 8-byte array and should not be zero. It should be unique within the trace
   * and should, ideally, be generated in a manner that is uniformly random.
   *
   * Example values:
   *
   *   - `000000000000004a`
   *   - `7a2190356c3fc94b`
   *   - `0000f00300090021`
   *   - `d39223e101960076`
   * </pre>
   *
   * <code>string span_id = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for spanId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSpanIdBytes() {
    java.lang.Object ref = spanId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      spanId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRACE_SAMPLED_FIELD_NUMBER = 30;
  private boolean traceSampled_ = false;
  /**
   *
   *
   * <pre>
   * Optional. The sampling decision of the trace associated with the log entry.
   *
   * True means that the trace resource name in the `trace` field was sampled
   * for storage in a trace backend. False means that the trace was not sampled
   * for storage when this log entry was written, or the sampling decision was
   * unknown at the time. A non-sampled `trace` value is still useful as a
   * request correlation identifier. The default is False.
   * </pre>
   *
   * <code>bool trace_sampled = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The traceSampled.
   */
  @java.lang.Override
  public boolean getTraceSampled() {
    return traceSampled_;
  }

  public static final int SOURCE_LOCATION_FIELD_NUMBER = 23;
  private com.google.logging.v2.LogEntrySourceLocation sourceLocation_;
  /**
   *
   *
   * <pre>
   * Optional. Source code location information associated with the log entry,
   * if any.
   * </pre>
   *
   * <code>
   * .google.logging.v2.LogEntrySourceLocation source_location = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sourceLocation field is set.
   */
  @java.lang.Override
  public boolean hasSourceLocation() {
    return sourceLocation_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Source code location information associated with the log entry,
   * if any.
   * </pre>
   *
   * <code>
   * .google.logging.v2.LogEntrySourceLocation source_location = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sourceLocation.
   */
  @java.lang.Override
  public com.google.logging.v2.LogEntrySourceLocation getSourceLocation() {
    return sourceLocation_ == null
        ? com.google.logging.v2.LogEntrySourceLocation.getDefaultInstance()
        : sourceLocation_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Source code location information associated with the log entry,
   * if any.
   * </pre>
   *
   * <code>
   * .google.logging.v2.LogEntrySourceLocation source_location = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.logging.v2.LogEntrySourceLocationOrBuilder getSourceLocationOrBuilder() {
    return sourceLocation_ == null
        ? com.google.logging.v2.LogEntrySourceLocation.getDefaultInstance()
        : sourceLocation_;
  }

  public static final int SPLIT_FIELD_NUMBER = 35;
  private com.google.logging.v2.LogSplit split_;
  /**
   *
   *
   * <pre>
   * Optional. Information indicating this LogEntry is part of a sequence of
   * multiple log entries split from a single LogEntry.
   * </pre>
   *
   * <code>.google.logging.v2.LogSplit split = 35 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the split field is set.
   */
  @java.lang.Override
  public boolean hasSplit() {
    return split_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Information indicating this LogEntry is part of a sequence of
   * multiple log entries split from a single LogEntry.
   * </pre>
   *
   * <code>.google.logging.v2.LogSplit split = 35 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The split.
   */
  @java.lang.Override
  public com.google.logging.v2.LogSplit getSplit() {
    return split_ == null ? com.google.logging.v2.LogSplit.getDefaultInstance() : split_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Information indicating this LogEntry is part of a sequence of
   * multiple log entries split from a single LogEntry.
   * </pre>
   *
   * <code>.google.logging.v2.LogSplit split = 35 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public com.google.logging.v2.LogSplitOrBuilder getSplitOrBuilder() {
    return split_ == null ? com.google.logging.v2.LogSplit.getDefaultInstance() : split_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (payloadCase_ == 2) {
      output.writeMessage(2, (com.google.protobuf.Any) payload_);
    }
    if (payloadCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, payload_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(insertId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, insertId_);
    }
    if (payloadCase_ == 6) {
      output.writeMessage(6, (com.google.protobuf.Struct) payload_);
    }
    if (httpRequest_ != null) {
      output.writeMessage(7, getHttpRequest());
    }
    if (resource_ != null) {
      output.writeMessage(8, getResource());
    }
    if (timestamp_ != null) {
      output.writeMessage(9, getTimestamp());
    }
    if (severity_ != com.google.logging.type.LogSeverity.DEFAULT.getNumber()) {
      output.writeEnum(10, severity_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 11);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, logName_);
    }
    if (operation_ != null) {
      output.writeMessage(15, getOperation());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trace_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 22, trace_);
    }
    if (sourceLocation_ != null) {
      output.writeMessage(23, getSourceLocation());
    }
    if (receiveTimestamp_ != null) {
      output.writeMessage(24, getReceiveTimestamp());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(spanId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 27, spanId_);
    }
    if (traceSampled_ != false) {
      output.writeBool(30, traceSampled_);
    }
    if (split_ != null) {
      output.writeMessage(35, getSplit());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (payloadCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.protobuf.Any) payload_);
    }
    if (payloadCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, payload_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(insertId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, insertId_);
    }
    if (payloadCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.protobuf.Struct) payload_);
    }
    if (httpRequest_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getHttpRequest());
    }
    if (resource_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getResource());
    }
    if (timestamp_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getTimestamp());
    }
    if (severity_ != com.google.logging.type.LogSeverity.DEFAULT.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, severity_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(logName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, logName_);
    }
    if (operation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getOperation());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trace_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(22, trace_);
    }
    if (sourceLocation_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getSourceLocation());
    }
    if (receiveTimestamp_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(24, getReceiveTimestamp());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(spanId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(27, spanId_);
    }
    if (traceSampled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(30, traceSampled_);
    }
    if (split_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(35, getSplit());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.logging.v2.LogEntry)) {
      return super.equals(obj);
    }
    com.google.logging.v2.LogEntry other = (com.google.logging.v2.LogEntry) obj;

    if (!getLogName().equals(other.getLogName())) return false;
    if (hasResource() != other.hasResource()) return false;
    if (hasResource()) {
      if (!getResource().equals(other.getResource())) return false;
    }
    if (hasTimestamp() != other.hasTimestamp()) return false;
    if (hasTimestamp()) {
      if (!getTimestamp().equals(other.getTimestamp())) return false;
    }
    if (hasReceiveTimestamp() != other.hasReceiveTimestamp()) return false;
    if (hasReceiveTimestamp()) {
      if (!getReceiveTimestamp().equals(other.getReceiveTimestamp())) return false;
    }
    if (severity_ != other.severity_) return false;
    if (!getInsertId().equals(other.getInsertId())) return false;
    if (hasHttpRequest() != other.hasHttpRequest()) return false;
    if (hasHttpRequest()) {
      if (!getHttpRequest().equals(other.getHttpRequest())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasOperation() != other.hasOperation()) return false;
    if (hasOperation()) {
      if (!getOperation().equals(other.getOperation())) return false;
    }
    if (!getTrace().equals(other.getTrace())) return false;
    if (!getSpanId().equals(other.getSpanId())) return false;
    if (getTraceSampled() != other.getTraceSampled()) return false;
    if (hasSourceLocation() != other.hasSourceLocation()) return false;
    if (hasSourceLocation()) {
      if (!getSourceLocation().equals(other.getSourceLocation())) return false;
    }
    if (hasSplit() != other.hasSplit()) return false;
    if (hasSplit()) {
      if (!getSplit().equals(other.getSplit())) return false;
    }
    if (!getPayloadCase().equals(other.getPayloadCase())) return false;
    switch (payloadCase_) {
      case 2:
        if (!getProtoPayload().equals(other.getProtoPayload())) return false;
        break;
      case 3:
        if (!getTextPayload().equals(other.getTextPayload())) return false;
        break;
      case 6:
        if (!getJsonPayload().equals(other.getJsonPayload())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LOG_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getLogName().hashCode();
    if (hasResource()) {
      hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getResource().hashCode();
    }
    if (hasTimestamp()) {
      hash = (37 * hash) + TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getTimestamp().hashCode();
    }
    if (hasReceiveTimestamp()) {
      hash = (37 * hash) + RECEIVE_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getReceiveTimestamp().hashCode();
    }
    hash = (37 * hash) + SEVERITY_FIELD_NUMBER;
    hash = (53 * hash) + severity_;
    hash = (37 * hash) + INSERT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getInsertId().hashCode();
    if (hasHttpRequest()) {
      hash = (37 * hash) + HTTP_REQUEST_FIELD_NUMBER;
      hash = (53 * hash) + getHttpRequest().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasOperation()) {
      hash = (37 * hash) + OPERATION_FIELD_NUMBER;
      hash = (53 * hash) + getOperation().hashCode();
    }
    hash = (37 * hash) + TRACE_FIELD_NUMBER;
    hash = (53 * hash) + getTrace().hashCode();
    hash = (37 * hash) + SPAN_ID_FIELD_NUMBER;
    hash = (53 * hash) + getSpanId().hashCode();
    hash = (37 * hash) + TRACE_SAMPLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getTraceSampled());
    if (hasSourceLocation()) {
      hash = (37 * hash) + SOURCE_LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getSourceLocation().hashCode();
    }
    if (hasSplit()) {
      hash = (37 * hash) + SPLIT_FIELD_NUMBER;
      hash = (53 * hash) + getSplit().hashCode();
    }
    switch (payloadCase_) {
      case 2:
        hash = (37 * hash) + PROTO_PAYLOAD_FIELD_NUMBER;
        hash = (53 * hash) + getProtoPayload().hashCode();
        break;
      case 3:
        hash = (37 * hash) + TEXT_PAYLOAD_FIELD_NUMBER;
        hash = (53 * hash) + getTextPayload().hashCode();
        break;
      case 6:
        hash = (37 * hash) + JSON_PAYLOAD_FIELD_NUMBER;
        hash = (53 * hash) + getJsonPayload().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.logging.v2.LogEntry parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.LogEntry parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.LogEntry parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.LogEntry parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.LogEntry parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.LogEntry parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.LogEntry parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.LogEntry parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.LogEntry parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.LogEntry parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.LogEntry parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.LogEntry parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.logging.v2.LogEntry prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An individual entry in a log.
   * </pre>
   *
   * Protobuf type {@code google.logging.v2.LogEntry}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.logging.v2.LogEntry)
      com.google.logging.v2.LogEntryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.logging.v2.LogEntryProto
          .internal_static_google_logging_v2_LogEntry_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 11:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 11:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.logging.v2.LogEntryProto
          .internal_static_google_logging_v2_LogEntry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.logging.v2.LogEntry.class, com.google.logging.v2.LogEntry.Builder.class);
    }

    // Construct using com.google.logging.v2.LogEntry.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      logName_ = "";
      resource_ = null;
      if (resourceBuilder_ != null) {
        resourceBuilder_.dispose();
        resourceBuilder_ = null;
      }
      if (protoPayloadBuilder_ != null) {
        protoPayloadBuilder_.clear();
      }
      if (jsonPayloadBuilder_ != null) {
        jsonPayloadBuilder_.clear();
      }
      timestamp_ = null;
      if (timestampBuilder_ != null) {
        timestampBuilder_.dispose();
        timestampBuilder_ = null;
      }
      receiveTimestamp_ = null;
      if (receiveTimestampBuilder_ != null) {
        receiveTimestampBuilder_.dispose();
        receiveTimestampBuilder_ = null;
      }
      severity_ = 0;
      insertId_ = "";
      httpRequest_ = null;
      if (httpRequestBuilder_ != null) {
        httpRequestBuilder_.dispose();
        httpRequestBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      operation_ = null;
      if (operationBuilder_ != null) {
        operationBuilder_.dispose();
        operationBuilder_ = null;
      }
      trace_ = "";
      spanId_ = "";
      traceSampled_ = false;
      sourceLocation_ = null;
      if (sourceLocationBuilder_ != null) {
        sourceLocationBuilder_.dispose();
        sourceLocationBuilder_ = null;
      }
      split_ = null;
      if (splitBuilder_ != null) {
        splitBuilder_.dispose();
        splitBuilder_ = null;
      }
      payloadCase_ = 0;
      payload_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.logging.v2.LogEntryProto
          .internal_static_google_logging_v2_LogEntry_descriptor;
    }

    @java.lang.Override
    public com.google.logging.v2.LogEntry getDefaultInstanceForType() {
      return com.google.logging.v2.LogEntry.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.logging.v2.LogEntry build() {
      com.google.logging.v2.LogEntry result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.logging.v2.LogEntry buildPartial() {
      com.google.logging.v2.LogEntry result = new com.google.logging.v2.LogEntry(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.logging.v2.LogEntry result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.logName_ = logName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.resource_ = resourceBuilder_ == null ? resource_ : resourceBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.timestamp_ = timestampBuilder_ == null ? timestamp_ : timestampBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.receiveTimestamp_ =
            receiveTimestampBuilder_ == null ? receiveTimestamp_ : receiveTimestampBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.severity_ = severity_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.insertId_ = insertId_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.httpRequest_ =
            httpRequestBuilder_ == null ? httpRequest_ : httpRequestBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.operation_ = operationBuilder_ == null ? operation_ : operationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.trace_ = trace_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.spanId_ = spanId_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.traceSampled_ = traceSampled_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.sourceLocation_ =
            sourceLocationBuilder_ == null ? sourceLocation_ : sourceLocationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.split_ = splitBuilder_ == null ? split_ : splitBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.logging.v2.LogEntry result) {
      result.payloadCase_ = payloadCase_;
      result.payload_ = this.payload_;
      if (payloadCase_ == 2 && protoPayloadBuilder_ != null) {
        result.payload_ = protoPayloadBuilder_.build();
      }
      if (payloadCase_ == 6 && jsonPayloadBuilder_ != null) {
        result.payload_ = jsonPayloadBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.logging.v2.LogEntry) {
        return mergeFrom((com.google.logging.v2.LogEntry) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.logging.v2.LogEntry other) {
      if (other == com.google.logging.v2.LogEntry.getDefaultInstance()) return this;
      if (!other.getLogName().isEmpty()) {
        logName_ = other.logName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasResource()) {
        mergeResource(other.getResource());
      }
      if (other.hasTimestamp()) {
        mergeTimestamp(other.getTimestamp());
      }
      if (other.hasReceiveTimestamp()) {
        mergeReceiveTimestamp(other.getReceiveTimestamp());
      }
      if (other.severity_ != 0) {
        setSeverityValue(other.getSeverityValue());
      }
      if (!other.getInsertId().isEmpty()) {
        insertId_ = other.insertId_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasHttpRequest()) {
        mergeHttpRequest(other.getHttpRequest());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000400;
      if (other.hasOperation()) {
        mergeOperation(other.getOperation());
      }
      if (!other.getTrace().isEmpty()) {
        trace_ = other.trace_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (!other.getSpanId().isEmpty()) {
        spanId_ = other.spanId_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.getTraceSampled() != false) {
        setTraceSampled(other.getTraceSampled());
      }
      if (other.hasSourceLocation()) {
        mergeSourceLocation(other.getSourceLocation());
      }
      if (other.hasSplit()) {
        mergeSplit(other.getSplit());
      }
      switch (other.getPayloadCase()) {
        case PROTO_PAYLOAD:
          {
            mergeProtoPayload(other.getProtoPayload());
            break;
          }
        case TEXT_PAYLOAD:
          {
            payloadCase_ = 3;
            payload_ = other.payload_;
            onChanged();
            break;
          }
        case JSON_PAYLOAD:
          {
            mergeJsonPayload(other.getJsonPayload());
            break;
          }
        case PAYLOAD_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(getProtoPayloadFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                payloadCase_ = 3;
                payload_ = s;
                break;
              } // case 26
            case 34:
              {
                insertId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 34
            case 50:
              {
                input.readMessage(getJsonPayloadFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getHttpRequestFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getResourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getTimestampFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 74
            case 80:
              {
                severity_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 80
            case 90:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                logName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 98
            case 122:
              {
                input.readMessage(getOperationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 122
            case 178:
              {
                trace_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 178
            case 186:
              {
                input.readMessage(getSourceLocationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 186
            case 194:
              {
                input.readMessage(
                    getReceiveTimestampFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 194
            case 218:
              {
                spanId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 218
            case 240:
              {
                traceSampled_ = input.readBool();
                bitField0_ |= 0x00004000;
                break;
              } // case 240
            case 282:
              {
                input.readMessage(getSplitFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 282
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int payloadCase_ = 0;
    private java.lang.Object payload_;

    public PayloadCase getPayloadCase() {
      return PayloadCase.forNumber(payloadCase_);
    }

    public Builder clearPayload() {
      payloadCase_ = 0;
      payload_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object logName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the log to which this log entry belongs:
     *
     *     "projects/[PROJECT_ID]/logs/[LOG_ID]"
     *     "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
     *     "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
     *     "folders/[FOLDER_ID]/logs/[LOG_ID]"
     *
     * A project number may be used in place of PROJECT_ID. The project number is
     * translated to its corresponding PROJECT_ID internally and the `log_name`
     * field will contain PROJECT_ID in queries and exports.
     *
     * `[LOG_ID]` must be URL-encoded within `log_name`. Example:
     * `"organizations/1234567890/logs/cloudresourcemanager.googleapis.com%2Factivity"`.
     *
     * `[LOG_ID]` must be less than 512 characters long and can only include the
     * following characters: upper and lower case alphanumeric characters,
     * forward-slash, underscore, hyphen, and period.
     *
     * For backward compatibility, if `log_name` begins with a forward-slash, such
     * as `/projects/...`, then the log entry is ingested as usual, but the
     * forward-slash is removed. Listing the log entry will not show the leading
     * slash and filtering for a log name with a leading slash will never return
     * any results.
     * </pre>
     *
     * <code>string log_name = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The logName.
     */
    public java.lang.String getLogName() {
      java.lang.Object ref = logName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the log to which this log entry belongs:
     *
     *     "projects/[PROJECT_ID]/logs/[LOG_ID]"
     *     "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
     *     "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
     *     "folders/[FOLDER_ID]/logs/[LOG_ID]"
     *
     * A project number may be used in place of PROJECT_ID. The project number is
     * translated to its corresponding PROJECT_ID internally and the `log_name`
     * field will contain PROJECT_ID in queries and exports.
     *
     * `[LOG_ID]` must be URL-encoded within `log_name`. Example:
     * `"organizations/1234567890/logs/cloudresourcemanager.googleapis.com%2Factivity"`.
     *
     * `[LOG_ID]` must be less than 512 characters long and can only include the
     * following characters: upper and lower case alphanumeric characters,
     * forward-slash, underscore, hyphen, and period.
     *
     * For backward compatibility, if `log_name` begins with a forward-slash, such
     * as `/projects/...`, then the log entry is ingested as usual, but the
     * forward-slash is removed. Listing the log entry will not show the leading
     * slash and filtering for a log name with a leading slash will never return
     * any results.
     * </pre>
     *
     * <code>string log_name = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for logName.
     */
    public com.google.protobuf.ByteString getLogNameBytes() {
      java.lang.Object ref = logName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        logName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the log to which this log entry belongs:
     *
     *     "projects/[PROJECT_ID]/logs/[LOG_ID]"
     *     "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
     *     "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
     *     "folders/[FOLDER_ID]/logs/[LOG_ID]"
     *
     * A project number may be used in place of PROJECT_ID. The project number is
     * translated to its corresponding PROJECT_ID internally and the `log_name`
     * field will contain PROJECT_ID in queries and exports.
     *
     * `[LOG_ID]` must be URL-encoded within `log_name`. Example:
     * `"organizations/1234567890/logs/cloudresourcemanager.googleapis.com%2Factivity"`.
     *
     * `[LOG_ID]` must be less than 512 characters long and can only include the
     * following characters: upper and lower case alphanumeric characters,
     * forward-slash, underscore, hyphen, and period.
     *
     * For backward compatibility, if `log_name` begins with a forward-slash, such
     * as `/projects/...`, then the log entry is ingested as usual, but the
     * forward-slash is removed. Listing the log entry will not show the leading
     * slash and filtering for a log name with a leading slash will never return
     * any results.
     * </pre>
     *
     * <code>string log_name = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The logName to set.
     * @return This builder for chaining.
     */
    public Builder setLogName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      logName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the log to which this log entry belongs:
     *
     *     "projects/[PROJECT_ID]/logs/[LOG_ID]"
     *     "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
     *     "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
     *     "folders/[FOLDER_ID]/logs/[LOG_ID]"
     *
     * A project number may be used in place of PROJECT_ID. The project number is
     * translated to its corresponding PROJECT_ID internally and the `log_name`
     * field will contain PROJECT_ID in queries and exports.
     *
     * `[LOG_ID]` must be URL-encoded within `log_name`. Example:
     * `"organizations/1234567890/logs/cloudresourcemanager.googleapis.com%2Factivity"`.
     *
     * `[LOG_ID]` must be less than 512 characters long and can only include the
     * following characters: upper and lower case alphanumeric characters,
     * forward-slash, underscore, hyphen, and period.
     *
     * For backward compatibility, if `log_name` begins with a forward-slash, such
     * as `/projects/...`, then the log entry is ingested as usual, but the
     * forward-slash is removed. Listing the log entry will not show the leading
     * slash and filtering for a log name with a leading slash will never return
     * any results.
     * </pre>
     *
     * <code>string log_name = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogName() {
      logName_ = getDefaultInstance().getLogName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the log to which this log entry belongs:
     *
     *     "projects/[PROJECT_ID]/logs/[LOG_ID]"
     *     "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
     *     "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
     *     "folders/[FOLDER_ID]/logs/[LOG_ID]"
     *
     * A project number may be used in place of PROJECT_ID. The project number is
     * translated to its corresponding PROJECT_ID internally and the `log_name`
     * field will contain PROJECT_ID in queries and exports.
     *
     * `[LOG_ID]` must be URL-encoded within `log_name`. Example:
     * `"organizations/1234567890/logs/cloudresourcemanager.googleapis.com%2Factivity"`.
     *
     * `[LOG_ID]` must be less than 512 characters long and can only include the
     * following characters: upper and lower case alphanumeric characters,
     * forward-slash, underscore, hyphen, and period.
     *
     * For backward compatibility, if `log_name` begins with a forward-slash, such
     * as `/projects/...`, then the log entry is ingested as usual, but the
     * forward-slash is removed. Listing the log entry will not show the leading
     * slash and filtering for a log name with a leading slash will never return
     * any results.
     * </pre>
     *
     * <code>string log_name = 12 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for logName to set.
     * @return This builder for chaining.
     */
    public Builder setLogNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      logName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.api.MonitoredResource resource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.MonitoredResource,
            com.google.api.MonitoredResource.Builder,
            com.google.api.MonitoredResourceOrBuilder>
        resourceBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The monitored resource that produced this log entry.
     *
     * Example: a log entry that reports a database error would be associated with
     * the monitored resource designating the particular database that reported
     * the error.
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the resource field is set.
     */
    public boolean hasResource() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The monitored resource that produced this log entry.
     *
     * Example: a log entry that reports a database error would be associated with
     * the monitored resource designating the particular database that reported
     * the error.
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The resource.
     */
    public com.google.api.MonitoredResource getResource() {
      if (resourceBuilder_ == null) {
        return resource_ == null
            ? com.google.api.MonitoredResource.getDefaultInstance()
            : resource_;
      } else {
        return resourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The monitored resource that produced this log entry.
     *
     * Example: a log entry that reports a database error would be associated with
     * the monitored resource designating the particular database that reported
     * the error.
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setResource(com.google.api.MonitoredResource value) {
      if (resourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
      } else {
        resourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The monitored resource that produced this log entry.
     *
     * Example: a log entry that reports a database error would be associated with
     * the monitored resource designating the particular database that reported
     * the error.
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setResource(com.google.api.MonitoredResource.Builder builderForValue) {
      if (resourceBuilder_ == null) {
        resource_ = builderForValue.build();
      } else {
        resourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The monitored resource that produced this log entry.
     *
     * Example: a log entry that reports a database error would be associated with
     * the monitored resource designating the particular database that reported
     * the error.
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeResource(com.google.api.MonitoredResource value) {
      if (resourceBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && resource_ != null
            && resource_ != com.google.api.MonitoredResource.getDefaultInstance()) {
          getResourceBuilder().mergeFrom(value);
        } else {
          resource_ = value;
        }
      } else {
        resourceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The monitored resource that produced this log entry.
     *
     * Example: a log entry that reports a database error would be associated with
     * the monitored resource designating the particular database that reported
     * the error.
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearResource() {
      bitField0_ = (bitField0_ & ~0x00000002);
      resource_ = null;
      if (resourceBuilder_ != null) {
        resourceBuilder_.dispose();
        resourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The monitored resource that produced this log entry.
     *
     * Example: a log entry that reports a database error would be associated with
     * the monitored resource designating the particular database that reported
     * the error.
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.api.MonitoredResource.Builder getResourceBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getResourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The monitored resource that produced this log entry.
     *
     * Example: a log entry that reports a database error would be associated with
     * the monitored resource designating the particular database that reported
     * the error.
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.api.MonitoredResourceOrBuilder getResourceOrBuilder() {
      if (resourceBuilder_ != null) {
        return resourceBuilder_.getMessageOrBuilder();
      } else {
        return resource_ == null
            ? com.google.api.MonitoredResource.getDefaultInstance()
            : resource_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The monitored resource that produced this log entry.
     *
     * Example: a log entry that reports a database error would be associated with
     * the monitored resource designating the particular database that reported
     * the error.
     * </pre>
     *
     * <code>.google.api.MonitoredResource resource = 8 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.MonitoredResource,
            com.google.api.MonitoredResource.Builder,
            com.google.api.MonitoredResourceOrBuilder>
        getResourceFieldBuilder() {
      if (resourceBuilder_ == null) {
        resourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.MonitoredResource,
                com.google.api.MonitoredResource.Builder,
                com.google.api.MonitoredResourceOrBuilder>(
                getResource(), getParentForChildren(), isClean());
        resource_ = null;
      }
      return resourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Any,
            com.google.protobuf.Any.Builder,
            com.google.protobuf.AnyOrBuilder>
        protoPayloadBuilder_;
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a protocol buffer. Some Google
     * Cloud Platform services use this field for their log entry payloads.
     *
     * The following protocol buffer types are supported; user-defined types
     * are not supported:
     *
     *   "type.googleapis.com/google.cloud.audit.AuditLog"
     *   "type.googleapis.com/google.appengine.logging.v1.RequestLog"
     * </pre>
     *
     * <code>.google.protobuf.Any proto_payload = 2;</code>
     *
     * @return Whether the protoPayload field is set.
     */
    @java.lang.Override
    public boolean hasProtoPayload() {
      return payloadCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a protocol buffer. Some Google
     * Cloud Platform services use this field for their log entry payloads.
     *
     * The following protocol buffer types are supported; user-defined types
     * are not supported:
     *
     *   "type.googleapis.com/google.cloud.audit.AuditLog"
     *   "type.googleapis.com/google.appengine.logging.v1.RequestLog"
     * </pre>
     *
     * <code>.google.protobuf.Any proto_payload = 2;</code>
     *
     * @return The protoPayload.
     */
    @java.lang.Override
    public com.google.protobuf.Any getProtoPayload() {
      if (protoPayloadBuilder_ == null) {
        if (payloadCase_ == 2) {
          return (com.google.protobuf.Any) payload_;
        }
        return com.google.protobuf.Any.getDefaultInstance();
      } else {
        if (payloadCase_ == 2) {
          return protoPayloadBuilder_.getMessage();
        }
        return com.google.protobuf.Any.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a protocol buffer. Some Google
     * Cloud Platform services use this field for their log entry payloads.
     *
     * The following protocol buffer types are supported; user-defined types
     * are not supported:
     *
     *   "type.googleapis.com/google.cloud.audit.AuditLog"
     *   "type.googleapis.com/google.appengine.logging.v1.RequestLog"
     * </pre>
     *
     * <code>.google.protobuf.Any proto_payload = 2;</code>
     */
    public Builder setProtoPayload(com.google.protobuf.Any value) {
      if (protoPayloadBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        protoPayloadBuilder_.setMessage(value);
      }
      payloadCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a protocol buffer. Some Google
     * Cloud Platform services use this field for their log entry payloads.
     *
     * The following protocol buffer types are supported; user-defined types
     * are not supported:
     *
     *   "type.googleapis.com/google.cloud.audit.AuditLog"
     *   "type.googleapis.com/google.appengine.logging.v1.RequestLog"
     * </pre>
     *
     * <code>.google.protobuf.Any proto_payload = 2;</code>
     */
    public Builder setProtoPayload(com.google.protobuf.Any.Builder builderForValue) {
      if (protoPayloadBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        protoPayloadBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a protocol buffer. Some Google
     * Cloud Platform services use this field for their log entry payloads.
     *
     * The following protocol buffer types are supported; user-defined types
     * are not supported:
     *
     *   "type.googleapis.com/google.cloud.audit.AuditLog"
     *   "type.googleapis.com/google.appengine.logging.v1.RequestLog"
     * </pre>
     *
     * <code>.google.protobuf.Any proto_payload = 2;</code>
     */
    public Builder mergeProtoPayload(com.google.protobuf.Any value) {
      if (protoPayloadBuilder_ == null) {
        if (payloadCase_ == 2 && payload_ != com.google.protobuf.Any.getDefaultInstance()) {
          payload_ =
              com.google.protobuf.Any.newBuilder((com.google.protobuf.Any) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 2) {
          protoPayloadBuilder_.mergeFrom(value);
        } else {
          protoPayloadBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a protocol buffer. Some Google
     * Cloud Platform services use this field for their log entry payloads.
     *
     * The following protocol buffer types are supported; user-defined types
     * are not supported:
     *
     *   "type.googleapis.com/google.cloud.audit.AuditLog"
     *   "type.googleapis.com/google.appengine.logging.v1.RequestLog"
     * </pre>
     *
     * <code>.google.protobuf.Any proto_payload = 2;</code>
     */
    public Builder clearProtoPayload() {
      if (protoPayloadBuilder_ == null) {
        if (payloadCase_ == 2) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 2) {
          payloadCase_ = 0;
          payload_ = null;
        }
        protoPayloadBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a protocol buffer. Some Google
     * Cloud Platform services use this field for their log entry payloads.
     *
     * The following protocol buffer types are supported; user-defined types
     * are not supported:
     *
     *   "type.googleapis.com/google.cloud.audit.AuditLog"
     *   "type.googleapis.com/google.appengine.logging.v1.RequestLog"
     * </pre>
     *
     * <code>.google.protobuf.Any proto_payload = 2;</code>
     */
    public com.google.protobuf.Any.Builder getProtoPayloadBuilder() {
      return getProtoPayloadFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a protocol buffer. Some Google
     * Cloud Platform services use this field for their log entry payloads.
     *
     * The following protocol buffer types are supported; user-defined types
     * are not supported:
     *
     *   "type.googleapis.com/google.cloud.audit.AuditLog"
     *   "type.googleapis.com/google.appengine.logging.v1.RequestLog"
     * </pre>
     *
     * <code>.google.protobuf.Any proto_payload = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.AnyOrBuilder getProtoPayloadOrBuilder() {
      if ((payloadCase_ == 2) && (protoPayloadBuilder_ != null)) {
        return protoPayloadBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 2) {
          return (com.google.protobuf.Any) payload_;
        }
        return com.google.protobuf.Any.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a protocol buffer. Some Google
     * Cloud Platform services use this field for their log entry payloads.
     *
     * The following protocol buffer types are supported; user-defined types
     * are not supported:
     *
     *   "type.googleapis.com/google.cloud.audit.AuditLog"
     *   "type.googleapis.com/google.appengine.logging.v1.RequestLog"
     * </pre>
     *
     * <code>.google.protobuf.Any proto_payload = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Any,
            com.google.protobuf.Any.Builder,
            com.google.protobuf.AnyOrBuilder>
        getProtoPayloadFieldBuilder() {
      if (protoPayloadBuilder_ == null) {
        if (!(payloadCase_ == 2)) {
          payload_ = com.google.protobuf.Any.getDefaultInstance();
        }
        protoPayloadBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Any,
                com.google.protobuf.Any.Builder,
                com.google.protobuf.AnyOrBuilder>(
                (com.google.protobuf.Any) payload_, getParentForChildren(), isClean());
        payload_ = null;
      }
      payloadCase_ = 2;
      onChanged();
      return protoPayloadBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a Unicode string (UTF-8).
     * </pre>
     *
     * <code>string text_payload = 3;</code>
     *
     * @return Whether the textPayload field is set.
     */
    @java.lang.Override
    public boolean hasTextPayload() {
      return payloadCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a Unicode string (UTF-8).
     * </pre>
     *
     * <code>string text_payload = 3;</code>
     *
     * @return The textPayload.
     */
    @java.lang.Override
    public java.lang.String getTextPayload() {
      java.lang.Object ref = "";
      if (payloadCase_ == 3) {
        ref = payload_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (payloadCase_ == 3) {
          payload_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a Unicode string (UTF-8).
     * </pre>
     *
     * <code>string text_payload = 3;</code>
     *
     * @return The bytes for textPayload.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextPayloadBytes() {
      java.lang.Object ref = "";
      if (payloadCase_ == 3) {
        ref = payload_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (payloadCase_ == 3) {
          payload_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a Unicode string (UTF-8).
     * </pre>
     *
     * <code>string text_payload = 3;</code>
     *
     * @param value The textPayload to set.
     * @return This builder for chaining.
     */
    public Builder setTextPayload(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      payloadCase_ = 3;
      payload_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a Unicode string (UTF-8).
     * </pre>
     *
     * <code>string text_payload = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTextPayload() {
      if (payloadCase_ == 3) {
        payloadCase_ = 0;
        payload_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a Unicode string (UTF-8).
     * </pre>
     *
     * <code>string text_payload = 3;</code>
     *
     * @param value The bytes for textPayload to set.
     * @return This builder for chaining.
     */
    public Builder setTextPayloadBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      payloadCase_ = 3;
      payload_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        jsonPayloadBuilder_;
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a structure that is
     * expressed as a JSON object.
     * </pre>
     *
     * <code>.google.protobuf.Struct json_payload = 6;</code>
     *
     * @return Whether the jsonPayload field is set.
     */
    @java.lang.Override
    public boolean hasJsonPayload() {
      return payloadCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a structure that is
     * expressed as a JSON object.
     * </pre>
     *
     * <code>.google.protobuf.Struct json_payload = 6;</code>
     *
     * @return The jsonPayload.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getJsonPayload() {
      if (jsonPayloadBuilder_ == null) {
        if (payloadCase_ == 6) {
          return (com.google.protobuf.Struct) payload_;
        }
        return com.google.protobuf.Struct.getDefaultInstance();
      } else {
        if (payloadCase_ == 6) {
          return jsonPayloadBuilder_.getMessage();
        }
        return com.google.protobuf.Struct.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a structure that is
     * expressed as a JSON object.
     * </pre>
     *
     * <code>.google.protobuf.Struct json_payload = 6;</code>
     */
    public Builder setJsonPayload(com.google.protobuf.Struct value) {
      if (jsonPayloadBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        jsonPayloadBuilder_.setMessage(value);
      }
      payloadCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a structure that is
     * expressed as a JSON object.
     * </pre>
     *
     * <code>.google.protobuf.Struct json_payload = 6;</code>
     */
    public Builder setJsonPayload(com.google.protobuf.Struct.Builder builderForValue) {
      if (jsonPayloadBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        jsonPayloadBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a structure that is
     * expressed as a JSON object.
     * </pre>
     *
     * <code>.google.protobuf.Struct json_payload = 6;</code>
     */
    public Builder mergeJsonPayload(com.google.protobuf.Struct value) {
      if (jsonPayloadBuilder_ == null) {
        if (payloadCase_ == 6 && payload_ != com.google.protobuf.Struct.getDefaultInstance()) {
          payload_ =
              com.google.protobuf.Struct.newBuilder((com.google.protobuf.Struct) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 6) {
          jsonPayloadBuilder_.mergeFrom(value);
        } else {
          jsonPayloadBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a structure that is
     * expressed as a JSON object.
     * </pre>
     *
     * <code>.google.protobuf.Struct json_payload = 6;</code>
     */
    public Builder clearJsonPayload() {
      if (jsonPayloadBuilder_ == null) {
        if (payloadCase_ == 6) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 6) {
          payloadCase_ = 0;
          payload_ = null;
        }
        jsonPayloadBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a structure that is
     * expressed as a JSON object.
     * </pre>
     *
     * <code>.google.protobuf.Struct json_payload = 6;</code>
     */
    public com.google.protobuf.Struct.Builder getJsonPayloadBuilder() {
      return getJsonPayloadFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a structure that is
     * expressed as a JSON object.
     * </pre>
     *
     * <code>.google.protobuf.Struct json_payload = 6;</code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getJsonPayloadOrBuilder() {
      if ((payloadCase_ == 6) && (jsonPayloadBuilder_ != null)) {
        return jsonPayloadBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 6) {
          return (com.google.protobuf.Struct) payload_;
        }
        return com.google.protobuf.Struct.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The log entry payload, represented as a structure that is
     * expressed as a JSON object.
     * </pre>
     *
     * <code>.google.protobuf.Struct json_payload = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getJsonPayloadFieldBuilder() {
      if (jsonPayloadBuilder_ == null) {
        if (!(payloadCase_ == 6)) {
          payload_ = com.google.protobuf.Struct.getDefaultInstance();
        }
        jsonPayloadBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                (com.google.protobuf.Struct) payload_, getParentForChildren(), isClean());
        payload_ = null;
      }
      payloadCase_ = 6;
      onChanged();
      return jsonPayloadBuilder_;
    }

    private com.google.protobuf.Timestamp timestamp_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        timestampBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The time the event described by the log entry occurred. This time
     * is used to compute the log entry's age and to enforce the logs retention
     * period. If this field is omitted in a new log entry, then Logging assigns
     * it the current time. Timestamps have nanosecond accuracy, but trailing
     * zeros in the fractional seconds might be omitted when the timestamp is
     * displayed.
     *
     * Incoming log entries must have timestamps that don't exceed the
     * [logs retention
     * period](https://cloud.google.com/logging/quotas#logs_retention_periods) in
     * the past, and that don't exceed 24 hours in the future. Log entries outside
     * those time boundaries aren't ingested by Logging.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the timestamp field is set.
     */
    public boolean hasTimestamp() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The time the event described by the log entry occurred. This time
     * is used to compute the log entry's age and to enforce the logs retention
     * period. If this field is omitted in a new log entry, then Logging assigns
     * it the current time. Timestamps have nanosecond accuracy, but trailing
     * zeros in the fractional seconds might be omitted when the timestamp is
     * displayed.
     *
     * Incoming log entries must have timestamps that don't exceed the
     * [logs retention
     * period](https://cloud.google.com/logging/quotas#logs_retention_periods) in
     * the past, and that don't exceed 24 hours in the future. Log entries outside
     * those time boundaries aren't ingested by Logging.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The timestamp.
     */
    public com.google.protobuf.Timestamp getTimestamp() {
      if (timestampBuilder_ == null) {
        return timestamp_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
      } else {
        return timestampBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The time the event described by the log entry occurred. This time
     * is used to compute the log entry's age and to enforce the logs retention
     * period. If this field is omitted in a new log entry, then Logging assigns
     * it the current time. Timestamps have nanosecond accuracy, but trailing
     * zeros in the fractional seconds might be omitted when the timestamp is
     * displayed.
     *
     * Incoming log entries must have timestamps that don't exceed the
     * [logs retention
     * period](https://cloud.google.com/logging/quotas#logs_retention_periods) in
     * the past, and that don't exceed 24 hours in the future. Log entries outside
     * those time boundaries aren't ingested by Logging.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTimestamp(com.google.protobuf.Timestamp value) {
      if (timestampBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timestamp_ = value;
      } else {
        timestampBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time the event described by the log entry occurred. This time
     * is used to compute the log entry's age and to enforce the logs retention
     * period. If this field is omitted in a new log entry, then Logging assigns
     * it the current time. Timestamps have nanosecond accuracy, but trailing
     * zeros in the fractional seconds might be omitted when the timestamp is
     * displayed.
     *
     * Incoming log entries must have timestamps that don't exceed the
     * [logs retention
     * period](https://cloud.google.com/logging/quotas#logs_retention_periods) in
     * the past, and that don't exceed 24 hours in the future. Log entries outside
     * those time boundaries aren't ingested by Logging.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTimestamp(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (timestampBuilder_ == null) {
        timestamp_ = builderForValue.build();
      } else {
        timestampBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time the event described by the log entry occurred. This time
     * is used to compute the log entry's age and to enforce the logs retention
     * period. If this field is omitted in a new log entry, then Logging assigns
     * it the current time. Timestamps have nanosecond accuracy, but trailing
     * zeros in the fractional seconds might be omitted when the timestamp is
     * displayed.
     *
     * Incoming log entries must have timestamps that don't exceed the
     * [logs retention
     * period](https://cloud.google.com/logging/quotas#logs_retention_periods) in
     * the past, and that don't exceed 24 hours in the future. Log entries outside
     * those time boundaries aren't ingested by Logging.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeTimestamp(com.google.protobuf.Timestamp value) {
      if (timestampBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && timestamp_ != null
            && timestamp_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getTimestampBuilder().mergeFrom(value);
        } else {
          timestamp_ = value;
        }
      } else {
        timestampBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time the event described by the log entry occurred. This time
     * is used to compute the log entry's age and to enforce the logs retention
     * period. If this field is omitted in a new log entry, then Logging assigns
     * it the current time. Timestamps have nanosecond accuracy, but trailing
     * zeros in the fractional seconds might be omitted when the timestamp is
     * displayed.
     *
     * Incoming log entries must have timestamps that don't exceed the
     * [logs retention
     * period](https://cloud.google.com/logging/quotas#logs_retention_periods) in
     * the past, and that don't exceed 24 hours in the future. Log entries outside
     * those time boundaries aren't ingested by Logging.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTimestamp() {
      bitField0_ = (bitField0_ & ~0x00000020);
      timestamp_ = null;
      if (timestampBuilder_ != null) {
        timestampBuilder_.dispose();
        timestampBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time the event described by the log entry occurred. This time
     * is used to compute the log entry's age and to enforce the logs retention
     * period. If this field is omitted in a new log entry, then Logging assigns
     * it the current time. Timestamps have nanosecond accuracy, but trailing
     * zeros in the fractional seconds might be omitted when the timestamp is
     * displayed.
     *
     * Incoming log entries must have timestamps that don't exceed the
     * [logs retention
     * period](https://cloud.google.com/logging/quotas#logs_retention_periods) in
     * the past, and that don't exceed 24 hours in the future. Log entries outside
     * those time boundaries aren't ingested by Logging.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getTimestampBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getTimestampFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The time the event described by the log entry occurred. This time
     * is used to compute the log entry's age and to enforce the logs retention
     * period. If this field is omitted in a new log entry, then Logging assigns
     * it the current time. Timestamps have nanosecond accuracy, but trailing
     * zeros in the fractional seconds might be omitted when the timestamp is
     * displayed.
     *
     * Incoming log entries must have timestamps that don't exceed the
     * [logs retention
     * period](https://cloud.google.com/logging/quotas#logs_retention_periods) in
     * the past, and that don't exceed 24 hours in the future. Log entries outside
     * those time boundaries aren't ingested by Logging.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder() {
      if (timestampBuilder_ != null) {
        return timestampBuilder_.getMessageOrBuilder();
      } else {
        return timestamp_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The time the event described by the log entry occurred. This time
     * is used to compute the log entry's age and to enforce the logs retention
     * period. If this field is omitted in a new log entry, then Logging assigns
     * it the current time. Timestamps have nanosecond accuracy, but trailing
     * zeros in the fractional seconds might be omitted when the timestamp is
     * displayed.
     *
     * Incoming log entries must have timestamps that don't exceed the
     * [logs retention
     * period](https://cloud.google.com/logging/quotas#logs_retention_periods) in
     * the past, and that don't exceed 24 hours in the future. Log entries outside
     * those time boundaries aren't ingested by Logging.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getTimestampFieldBuilder() {
      if (timestampBuilder_ == null) {
        timestampBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getTimestamp(), getParentForChildren(), isClean());
        timestamp_ = null;
      }
      return timestampBuilder_;
    }

    private com.google.protobuf.Timestamp receiveTimestamp_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        receiveTimestampBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the log entry was received by Logging.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp receive_timestamp = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the receiveTimestamp field is set.
     */
    public boolean hasReceiveTimestamp() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the log entry was received by Logging.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp receive_timestamp = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The receiveTimestamp.
     */
    public com.google.protobuf.Timestamp getReceiveTimestamp() {
      if (receiveTimestampBuilder_ == null) {
        return receiveTimestamp_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : receiveTimestamp_;
      } else {
        return receiveTimestampBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the log entry was received by Logging.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp receive_timestamp = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setReceiveTimestamp(com.google.protobuf.Timestamp value) {
      if (receiveTimestampBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        receiveTimestamp_ = value;
      } else {
        receiveTimestampBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the log entry was received by Logging.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp receive_timestamp = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setReceiveTimestamp(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (receiveTimestampBuilder_ == null) {
        receiveTimestamp_ = builderForValue.build();
      } else {
        receiveTimestampBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the log entry was received by Logging.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp receive_timestamp = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeReceiveTimestamp(com.google.protobuf.Timestamp value) {
      if (receiveTimestampBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && receiveTimestamp_ != null
            && receiveTimestamp_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getReceiveTimestampBuilder().mergeFrom(value);
        } else {
          receiveTimestamp_ = value;
        }
      } else {
        receiveTimestampBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the log entry was received by Logging.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp receive_timestamp = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearReceiveTimestamp() {
      bitField0_ = (bitField0_ & ~0x00000040);
      receiveTimestamp_ = null;
      if (receiveTimestampBuilder_ != null) {
        receiveTimestampBuilder_.dispose();
        receiveTimestampBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the log entry was received by Logging.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp receive_timestamp = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getReceiveTimestampBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getReceiveTimestampFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the log entry was received by Logging.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp receive_timestamp = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getReceiveTimestampOrBuilder() {
      if (receiveTimestampBuilder_ != null) {
        return receiveTimestampBuilder_.getMessageOrBuilder();
      } else {
        return receiveTimestamp_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : receiveTimestamp_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the log entry was received by Logging.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp receive_timestamp = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getReceiveTimestampFieldBuilder() {
      if (receiveTimestampBuilder_ == null) {
        receiveTimestampBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getReceiveTimestamp(), getParentForChildren(), isClean());
        receiveTimestamp_ = null;
      }
      return receiveTimestampBuilder_;
    }

    private int severity_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The severity of the log entry. The default value is
     * `LogSeverity.DEFAULT`.
     * </pre>
     *
     * <code>
     * .google.logging.type.LogSeverity severity = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for severity.
     */
    @java.lang.Override
    public int getSeverityValue() {
      return severity_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The severity of the log entry. The default value is
     * `LogSeverity.DEFAULT`.
     * </pre>
     *
     * <code>
     * .google.logging.type.LogSeverity severity = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverityValue(int value) {
      severity_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The severity of the log entry. The default value is
     * `LogSeverity.DEFAULT`.
     * </pre>
     *
     * <code>
     * .google.logging.type.LogSeverity severity = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The severity.
     */
    @java.lang.Override
    public com.google.logging.type.LogSeverity getSeverity() {
      com.google.logging.type.LogSeverity result =
          com.google.logging.type.LogSeverity.forNumber(severity_);
      return result == null ? com.google.logging.type.LogSeverity.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The severity of the log entry. The default value is
     * `LogSeverity.DEFAULT`.
     * </pre>
     *
     * <code>
     * .google.logging.type.LogSeverity severity = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The severity to set.
     * @return This builder for chaining.
     */
    public Builder setSeverity(com.google.logging.type.LogSeverity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      severity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The severity of the log entry. The default value is
     * `LogSeverity.DEFAULT`.
     * </pre>
     *
     * <code>
     * .google.logging.type.LogSeverity severity = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSeverity() {
      bitField0_ = (bitField0_ & ~0x00000080);
      severity_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object insertId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for the log entry. If you provide a value,
     * then Logging considers other log entries in the same project, with the same
     * `timestamp`, and with the same `insert_id` to be duplicates which are
     * removed in a single query result. However, there are no guarantees of
     * de-duplication in the export of logs.
     *
     * If the `insert_id` is omitted when writing a log entry, the Logging API
     * assigns its own unique identifier in this field.
     *
     * In queries, the `insert_id` is also used to order log entries that have
     * the same `log_name` and `timestamp` values.
     * </pre>
     *
     * <code>string insert_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The insertId.
     */
    public java.lang.String getInsertId() {
      java.lang.Object ref = insertId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        insertId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for the log entry. If you provide a value,
     * then Logging considers other log entries in the same project, with the same
     * `timestamp`, and with the same `insert_id` to be duplicates which are
     * removed in a single query result. However, there are no guarantees of
     * de-duplication in the export of logs.
     *
     * If the `insert_id` is omitted when writing a log entry, the Logging API
     * assigns its own unique identifier in this field.
     *
     * In queries, the `insert_id` is also used to order log entries that have
     * the same `log_name` and `timestamp` values.
     * </pre>
     *
     * <code>string insert_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for insertId.
     */
    public com.google.protobuf.ByteString getInsertIdBytes() {
      java.lang.Object ref = insertId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        insertId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for the log entry. If you provide a value,
     * then Logging considers other log entries in the same project, with the same
     * `timestamp`, and with the same `insert_id` to be duplicates which are
     * removed in a single query result. However, there are no guarantees of
     * de-duplication in the export of logs.
     *
     * If the `insert_id` is omitted when writing a log entry, the Logging API
     * assigns its own unique identifier in this field.
     *
     * In queries, the `insert_id` is also used to order log entries that have
     * the same `log_name` and `timestamp` values.
     * </pre>
     *
     * <code>string insert_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The insertId to set.
     * @return This builder for chaining.
     */
    public Builder setInsertId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      insertId_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for the log entry. If you provide a value,
     * then Logging considers other log entries in the same project, with the same
     * `timestamp`, and with the same `insert_id` to be duplicates which are
     * removed in a single query result. However, there are no guarantees of
     * de-duplication in the export of logs.
     *
     * If the `insert_id` is omitted when writing a log entry, the Logging API
     * assigns its own unique identifier in this field.
     *
     * In queries, the `insert_id` is also used to order log entries that have
     * the same `log_name` and `timestamp` values.
     * </pre>
     *
     * <code>string insert_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInsertId() {
      insertId_ = getDefaultInstance().getInsertId();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for the log entry. If you provide a value,
     * then Logging considers other log entries in the same project, with the same
     * `timestamp`, and with the same `insert_id` to be duplicates which are
     * removed in a single query result. However, there are no guarantees of
     * de-duplication in the export of logs.
     *
     * If the `insert_id` is omitted when writing a log entry, the Logging API
     * assigns its own unique identifier in this field.
     *
     * In queries, the `insert_id` is also used to order log entries that have
     * the same `log_name` and `timestamp` values.
     * </pre>
     *
     * <code>string insert_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for insertId to set.
     * @return This builder for chaining.
     */
    public Builder setInsertIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      insertId_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.logging.type.HttpRequest httpRequest_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.type.HttpRequest,
            com.google.logging.type.HttpRequest.Builder,
            com.google.logging.type.HttpRequestOrBuilder>
        httpRequestBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Information about the HTTP request associated with this log
     * entry, if applicable.
     * </pre>
     *
     * <code>
     * .google.logging.type.HttpRequest http_request = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the httpRequest field is set.
     */
    public boolean hasHttpRequest() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the HTTP request associated with this log
     * entry, if applicable.
     * </pre>
     *
     * <code>
     * .google.logging.type.HttpRequest http_request = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The httpRequest.
     */
    public com.google.logging.type.HttpRequest getHttpRequest() {
      if (httpRequestBuilder_ == null) {
        return httpRequest_ == null
            ? com.google.logging.type.HttpRequest.getDefaultInstance()
            : httpRequest_;
      } else {
        return httpRequestBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the HTTP request associated with this log
     * entry, if applicable.
     * </pre>
     *
     * <code>
     * .google.logging.type.HttpRequest http_request = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHttpRequest(com.google.logging.type.HttpRequest value) {
      if (httpRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        httpRequest_ = value;
      } else {
        httpRequestBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the HTTP request associated with this log
     * entry, if applicable.
     * </pre>
     *
     * <code>
     * .google.logging.type.HttpRequest http_request = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHttpRequest(com.google.logging.type.HttpRequest.Builder builderForValue) {
      if (httpRequestBuilder_ == null) {
        httpRequest_ = builderForValue.build();
      } else {
        httpRequestBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the HTTP request associated with this log
     * entry, if applicable.
     * </pre>
     *
     * <code>
     * .google.logging.type.HttpRequest http_request = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeHttpRequest(com.google.logging.type.HttpRequest value) {
      if (httpRequestBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && httpRequest_ != null
            && httpRequest_ != com.google.logging.type.HttpRequest.getDefaultInstance()) {
          getHttpRequestBuilder().mergeFrom(value);
        } else {
          httpRequest_ = value;
        }
      } else {
        httpRequestBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the HTTP request associated with this log
     * entry, if applicable.
     * </pre>
     *
     * <code>
     * .google.logging.type.HttpRequest http_request = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearHttpRequest() {
      bitField0_ = (bitField0_ & ~0x00000200);
      httpRequest_ = null;
      if (httpRequestBuilder_ != null) {
        httpRequestBuilder_.dispose();
        httpRequestBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the HTTP request associated with this log
     * entry, if applicable.
     * </pre>
     *
     * <code>
     * .google.logging.type.HttpRequest http_request = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.logging.type.HttpRequest.Builder getHttpRequestBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getHttpRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the HTTP request associated with this log
     * entry, if applicable.
     * </pre>
     *
     * <code>
     * .google.logging.type.HttpRequest http_request = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.logging.type.HttpRequestOrBuilder getHttpRequestOrBuilder() {
      if (httpRequestBuilder_ != null) {
        return httpRequestBuilder_.getMessageOrBuilder();
      } else {
        return httpRequest_ == null
            ? com.google.logging.type.HttpRequest.getDefaultInstance()
            : httpRequest_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about the HTTP request associated with this log
     * entry, if applicable.
     * </pre>
     *
     * <code>
     * .google.logging.type.HttpRequest http_request = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.type.HttpRequest,
            com.google.logging.type.HttpRequest.Builder,
            com.google.logging.type.HttpRequestOrBuilder>
        getHttpRequestFieldBuilder() {
      if (httpRequestBuilder_ == null) {
        httpRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.logging.type.HttpRequest,
                com.google.logging.type.HttpRequest.Builder,
                com.google.logging.type.HttpRequestOrBuilder>(
                getHttpRequest(), getParentForChildren(), isClean());
        httpRequest_ = null;
      }
      return httpRequestBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A map of key, value pairs that provides additional information
     * about the log entry. The labels can be user-defined or system-defined.
     *
     * User-defined labels are arbitrary key, value pairs that you can use to
     * classify logs.
     *
     * System-defined labels are defined by GCP services for platform logs.
     * They have two components - a service namespace component and the
     * attribute name. For example: `compute.googleapis.com/resource_name`.
     *
     * Cloud Logging truncates label keys that exceed 512 B and label
     * values that exceed 64 KB upon their associated log entry being
     * written. The truncation is indicated by an ellipsis at the
     * end of the character string.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A map of key, value pairs that provides additional information
     * about the log entry. The labels can be user-defined or system-defined.
     *
     * User-defined labels are arbitrary key, value pairs that you can use to
     * classify logs.
     *
     * System-defined labels are defined by GCP services for platform logs.
     * They have two components - a service namespace component and the
     * attribute name. For example: `compute.googleapis.com/resource_name`.
     *
     * Cloud Logging truncates label keys that exceed 512 B and label
     * values that exceed 64 KB upon their associated log entry being
     * written. The truncation is indicated by an ellipsis at the
     * end of the character string.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A map of key, value pairs that provides additional information
     * about the log entry. The labels can be user-defined or system-defined.
     *
     * User-defined labels are arbitrary key, value pairs that you can use to
     * classify logs.
     *
     * System-defined labels are defined by GCP services for platform logs.
     * They have two components - a service namespace component and the
     * attribute name. For example: `compute.googleapis.com/resource_name`.
     *
     * Cloud Logging truncates label keys that exceed 512 B and label
     * values that exceed 64 KB upon their associated log entry being
     * written. The truncation is indicated by an ellipsis at the
     * end of the character string.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. A map of key, value pairs that provides additional information
     * about the log entry. The labels can be user-defined or system-defined.
     *
     * User-defined labels are arbitrary key, value pairs that you can use to
     * classify logs.
     *
     * System-defined labels are defined by GCP services for platform logs.
     * They have two components - a service namespace component and the
     * attribute name. For example: `compute.googleapis.com/resource_name`.
     *
     * Cloud Logging truncates label keys that exceed 512 B and label
     * values that exceed 64 KB upon their associated log entry being
     * written. The truncation is indicated by an ellipsis at the
     * end of the character string.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000400);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A map of key, value pairs that provides additional information
     * about the log entry. The labels can be user-defined or system-defined.
     *
     * User-defined labels are arbitrary key, value pairs that you can use to
     * classify logs.
     *
     * System-defined labels are defined by GCP services for platform logs.
     * They have two components - a service namespace component and the
     * attribute name. For example: `compute.googleapis.com/resource_name`.
     *
     * Cloud Logging truncates label keys that exceed 512 B and label
     * values that exceed 64 KB upon their associated log entry being
     * written. The truncation is indicated by an ellipsis at the
     * end of the character string.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000400;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A map of key, value pairs that provides additional information
     * about the log entry. The labels can be user-defined or system-defined.
     *
     * User-defined labels are arbitrary key, value pairs that you can use to
     * classify logs.
     *
     * System-defined labels are defined by GCP services for platform logs.
     * They have two components - a service namespace component and the
     * attribute name. For example: `compute.googleapis.com/resource_name`.
     *
     * Cloud Logging truncates label keys that exceed 512 B and label
     * values that exceed 64 KB upon their associated log entry being
     * written. The truncation is indicated by an ellipsis at the
     * end of the character string.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000400;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A map of key, value pairs that provides additional information
     * about the log entry. The labels can be user-defined or system-defined.
     *
     * User-defined labels are arbitrary key, value pairs that you can use to
     * classify logs.
     *
     * System-defined labels are defined by GCP services for platform logs.
     * They have two components - a service namespace component and the
     * attribute name. For example: `compute.googleapis.com/resource_name`.
     *
     * Cloud Logging truncates label keys that exceed 512 B and label
     * values that exceed 64 KB upon their associated log entry being
     * written. The truncation is indicated by an ellipsis at the
     * end of the character string.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000400;
      return this;
    }

    private com.google.logging.v2.LogEntryOperation operation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.v2.LogEntryOperation,
            com.google.logging.v2.LogEntryOperation.Builder,
            com.google.logging.v2.LogEntryOperationOrBuilder>
        operationBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Information about an operation associated with the log entry, if
     * applicable.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LogEntryOperation operation = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the operation field is set.
     */
    public boolean hasOperation() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about an operation associated with the log entry, if
     * applicable.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LogEntryOperation operation = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The operation.
     */
    public com.google.logging.v2.LogEntryOperation getOperation() {
      if (operationBuilder_ == null) {
        return operation_ == null
            ? com.google.logging.v2.LogEntryOperation.getDefaultInstance()
            : operation_;
      } else {
        return operationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about an operation associated with the log entry, if
     * applicable.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LogEntryOperation operation = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOperation(com.google.logging.v2.LogEntryOperation value) {
      if (operationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
      } else {
        operationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about an operation associated with the log entry, if
     * applicable.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LogEntryOperation operation = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setOperation(com.google.logging.v2.LogEntryOperation.Builder builderForValue) {
      if (operationBuilder_ == null) {
        operation_ = builderForValue.build();
      } else {
        operationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about an operation associated with the log entry, if
     * applicable.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LogEntryOperation operation = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeOperation(com.google.logging.v2.LogEntryOperation value) {
      if (operationBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && operation_ != null
            && operation_ != com.google.logging.v2.LogEntryOperation.getDefaultInstance()) {
          getOperationBuilder().mergeFrom(value);
        } else {
          operation_ = value;
        }
      } else {
        operationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about an operation associated with the log entry, if
     * applicable.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LogEntryOperation operation = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearOperation() {
      bitField0_ = (bitField0_ & ~0x00000800);
      operation_ = null;
      if (operationBuilder_ != null) {
        operationBuilder_.dispose();
        operationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about an operation associated with the log entry, if
     * applicable.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LogEntryOperation operation = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.logging.v2.LogEntryOperation.Builder getOperationBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getOperationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about an operation associated with the log entry, if
     * applicable.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LogEntryOperation operation = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.logging.v2.LogEntryOperationOrBuilder getOperationOrBuilder() {
      if (operationBuilder_ != null) {
        return operationBuilder_.getMessageOrBuilder();
      } else {
        return operation_ == null
            ? com.google.logging.v2.LogEntryOperation.getDefaultInstance()
            : operation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information about an operation associated with the log entry, if
     * applicable.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LogEntryOperation operation = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.v2.LogEntryOperation,
            com.google.logging.v2.LogEntryOperation.Builder,
            com.google.logging.v2.LogEntryOperationOrBuilder>
        getOperationFieldBuilder() {
      if (operationBuilder_ == null) {
        operationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.logging.v2.LogEntryOperation,
                com.google.logging.v2.LogEntryOperation.Builder,
                com.google.logging.v2.LogEntryOperationOrBuilder>(
                getOperation(), getParentForChildren(), isClean());
        operation_ = null;
      }
      return operationBuilder_;
    }

    private java.lang.Object trace_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The REST resource name of the trace being written to
     * [Cloud Trace](https://cloud.google.com/trace) in
     * association with this log entry. For example, if your trace data is stored
     * in the Cloud project "my-trace-project" and if the service that is creating
     * the log entry receives a trace header that includes the trace ID "12345",
     * then the service should use "projects/my-tracing-project/traces/12345".
     *
     * The `trace` field provides the link between logs and traces. By using
     * this field, you can navigate from a log entry to a trace.
     * </pre>
     *
     * <code>string trace = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The trace.
     */
    public java.lang.String getTrace() {
      java.lang.Object ref = trace_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        trace_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The REST resource name of the trace being written to
     * [Cloud Trace](https://cloud.google.com/trace) in
     * association with this log entry. For example, if your trace data is stored
     * in the Cloud project "my-trace-project" and if the service that is creating
     * the log entry receives a trace header that includes the trace ID "12345",
     * then the service should use "projects/my-tracing-project/traces/12345".
     *
     * The `trace` field provides the link between logs and traces. By using
     * this field, you can navigate from a log entry to a trace.
     * </pre>
     *
     * <code>string trace = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for trace.
     */
    public com.google.protobuf.ByteString getTraceBytes() {
      java.lang.Object ref = trace_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        trace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The REST resource name of the trace being written to
     * [Cloud Trace](https://cloud.google.com/trace) in
     * association with this log entry. For example, if your trace data is stored
     * in the Cloud project "my-trace-project" and if the service that is creating
     * the log entry receives a trace header that includes the trace ID "12345",
     * then the service should use "projects/my-tracing-project/traces/12345".
     *
     * The `trace` field provides the link between logs and traces. By using
     * this field, you can navigate from a log entry to a trace.
     * </pre>
     *
     * <code>string trace = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The trace to set.
     * @return This builder for chaining.
     */
    public Builder setTrace(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      trace_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The REST resource name of the trace being written to
     * [Cloud Trace](https://cloud.google.com/trace) in
     * association with this log entry. For example, if your trace data is stored
     * in the Cloud project "my-trace-project" and if the service that is creating
     * the log entry receives a trace header that includes the trace ID "12345",
     * then the service should use "projects/my-tracing-project/traces/12345".
     *
     * The `trace` field provides the link between logs and traces. By using
     * this field, you can navigate from a log entry to a trace.
     * </pre>
     *
     * <code>string trace = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrace() {
      trace_ = getDefaultInstance().getTrace();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The REST resource name of the trace being written to
     * [Cloud Trace](https://cloud.google.com/trace) in
     * association with this log entry. For example, if your trace data is stored
     * in the Cloud project "my-trace-project" and if the service that is creating
     * the log entry receives a trace header that includes the trace ID "12345",
     * then the service should use "projects/my-tracing-project/traces/12345".
     *
     * The `trace` field provides the link between logs and traces. By using
     * this field, you can navigate from a log entry to a trace.
     * </pre>
     *
     * <code>string trace = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for trace to set.
     * @return This builder for chaining.
     */
    public Builder setTraceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      trace_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object spanId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The ID of the [Cloud Trace](https://cloud.google.com/trace) span
     * associated with the current operation in which the log is being written.
     * For example, if a span has the REST resource name of
     * "projects/some-project/traces/some-trace/spans/some-span-id", then the
     * `span_id` field is "some-span-id".
     *
     * A
     * [Span](https://cloud.google.com/trace/docs/reference/v2/rest/v2/projects.traces/batchWrite#Span)
     * represents a single operation within a trace. Whereas a trace may involve
     * multiple different microservices running on multiple different machines,
     * a span generally corresponds to a single logical operation being performed
     * in a single instance of a microservice on one specific machine. Spans
     * are the nodes within the tree that is a trace.
     *
     * Applications that are [instrumented for
     * tracing](https://cloud.google.com/trace/docs/setup) will generally assign a
     * new, unique span ID on each incoming request. It is also common to create
     * and record additional spans corresponding to internal processing elements
     * as well as issuing requests to dependencies.
     *
     * The span ID is expected to be a 16-character, hexadecimal encoding of an
     * 8-byte array and should not be zero. It should be unique within the trace
     * and should, ideally, be generated in a manner that is uniformly random.
     *
     * Example values:
     *
     *   - `000000000000004a`
     *   - `7a2190356c3fc94b`
     *   - `0000f00300090021`
     *   - `d39223e101960076`
     * </pre>
     *
     * <code>string span_id = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The spanId.
     */
    public java.lang.String getSpanId() {
      java.lang.Object ref = spanId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        spanId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID of the [Cloud Trace](https://cloud.google.com/trace) span
     * associated with the current operation in which the log is being written.
     * For example, if a span has the REST resource name of
     * "projects/some-project/traces/some-trace/spans/some-span-id", then the
     * `span_id` field is "some-span-id".
     *
     * A
     * [Span](https://cloud.google.com/trace/docs/reference/v2/rest/v2/projects.traces/batchWrite#Span)
     * represents a single operation within a trace. Whereas a trace may involve
     * multiple different microservices running on multiple different machines,
     * a span generally corresponds to a single logical operation being performed
     * in a single instance of a microservice on one specific machine. Spans
     * are the nodes within the tree that is a trace.
     *
     * Applications that are [instrumented for
     * tracing](https://cloud.google.com/trace/docs/setup) will generally assign a
     * new, unique span ID on each incoming request. It is also common to create
     * and record additional spans corresponding to internal processing elements
     * as well as issuing requests to dependencies.
     *
     * The span ID is expected to be a 16-character, hexadecimal encoding of an
     * 8-byte array and should not be zero. It should be unique within the trace
     * and should, ideally, be generated in a manner that is uniformly random.
     *
     * Example values:
     *
     *   - `000000000000004a`
     *   - `7a2190356c3fc94b`
     *   - `0000f00300090021`
     *   - `d39223e101960076`
     * </pre>
     *
     * <code>string span_id = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for spanId.
     */
    public com.google.protobuf.ByteString getSpanIdBytes() {
      java.lang.Object ref = spanId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        spanId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID of the [Cloud Trace](https://cloud.google.com/trace) span
     * associated with the current operation in which the log is being written.
     * For example, if a span has the REST resource name of
     * "projects/some-project/traces/some-trace/spans/some-span-id", then the
     * `span_id` field is "some-span-id".
     *
     * A
     * [Span](https://cloud.google.com/trace/docs/reference/v2/rest/v2/projects.traces/batchWrite#Span)
     * represents a single operation within a trace. Whereas a trace may involve
     * multiple different microservices running on multiple different machines,
     * a span generally corresponds to a single logical operation being performed
     * in a single instance of a microservice on one specific machine. Spans
     * are the nodes within the tree that is a trace.
     *
     * Applications that are [instrumented for
     * tracing](https://cloud.google.com/trace/docs/setup) will generally assign a
     * new, unique span ID on each incoming request. It is also common to create
     * and record additional spans corresponding to internal processing elements
     * as well as issuing requests to dependencies.
     *
     * The span ID is expected to be a 16-character, hexadecimal encoding of an
     * 8-byte array and should not be zero. It should be unique within the trace
     * and should, ideally, be generated in a manner that is uniformly random.
     *
     * Example values:
     *
     *   - `000000000000004a`
     *   - `7a2190356c3fc94b`
     *   - `0000f00300090021`
     *   - `d39223e101960076`
     * </pre>
     *
     * <code>string span_id = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The spanId to set.
     * @return This builder for chaining.
     */
    public Builder setSpanId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      spanId_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID of the [Cloud Trace](https://cloud.google.com/trace) span
     * associated with the current operation in which the log is being written.
     * For example, if a span has the REST resource name of
     * "projects/some-project/traces/some-trace/spans/some-span-id", then the
     * `span_id` field is "some-span-id".
     *
     * A
     * [Span](https://cloud.google.com/trace/docs/reference/v2/rest/v2/projects.traces/batchWrite#Span)
     * represents a single operation within a trace. Whereas a trace may involve
     * multiple different microservices running on multiple different machines,
     * a span generally corresponds to a single logical operation being performed
     * in a single instance of a microservice on one specific machine. Spans
     * are the nodes within the tree that is a trace.
     *
     * Applications that are [instrumented for
     * tracing](https://cloud.google.com/trace/docs/setup) will generally assign a
     * new, unique span ID on each incoming request. It is also common to create
     * and record additional spans corresponding to internal processing elements
     * as well as issuing requests to dependencies.
     *
     * The span ID is expected to be a 16-character, hexadecimal encoding of an
     * 8-byte array and should not be zero. It should be unique within the trace
     * and should, ideally, be generated in a manner that is uniformly random.
     *
     * Example values:
     *
     *   - `000000000000004a`
     *   - `7a2190356c3fc94b`
     *   - `0000f00300090021`
     *   - `d39223e101960076`
     * </pre>
     *
     * <code>string span_id = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpanId() {
      spanId_ = getDefaultInstance().getSpanId();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The ID of the [Cloud Trace](https://cloud.google.com/trace) span
     * associated with the current operation in which the log is being written.
     * For example, if a span has the REST resource name of
     * "projects/some-project/traces/some-trace/spans/some-span-id", then the
     * `span_id` field is "some-span-id".
     *
     * A
     * [Span](https://cloud.google.com/trace/docs/reference/v2/rest/v2/projects.traces/batchWrite#Span)
     * represents a single operation within a trace. Whereas a trace may involve
     * multiple different microservices running on multiple different machines,
     * a span generally corresponds to a single logical operation being performed
     * in a single instance of a microservice on one specific machine. Spans
     * are the nodes within the tree that is a trace.
     *
     * Applications that are [instrumented for
     * tracing](https://cloud.google.com/trace/docs/setup) will generally assign a
     * new, unique span ID on each incoming request. It is also common to create
     * and record additional spans corresponding to internal processing elements
     * as well as issuing requests to dependencies.
     *
     * The span ID is expected to be a 16-character, hexadecimal encoding of an
     * 8-byte array and should not be zero. It should be unique within the trace
     * and should, ideally, be generated in a manner that is uniformly random.
     *
     * Example values:
     *
     *   - `000000000000004a`
     *   - `7a2190356c3fc94b`
     *   - `0000f00300090021`
     *   - `d39223e101960076`
     * </pre>
     *
     * <code>string span_id = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for spanId to set.
     * @return This builder for chaining.
     */
    public Builder setSpanIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      spanId_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private boolean traceSampled_;
    /**
     *
     *
     * <pre>
     * Optional. The sampling decision of the trace associated with the log entry.
     *
     * True means that the trace resource name in the `trace` field was sampled
     * for storage in a trace backend. False means that the trace was not sampled
     * for storage when this log entry was written, or the sampling decision was
     * unknown at the time. A non-sampled `trace` value is still useful as a
     * request correlation identifier. The default is False.
     * </pre>
     *
     * <code>bool trace_sampled = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The traceSampled.
     */
    @java.lang.Override
    public boolean getTraceSampled() {
      return traceSampled_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The sampling decision of the trace associated with the log entry.
     *
     * True means that the trace resource name in the `trace` field was sampled
     * for storage in a trace backend. False means that the trace was not sampled
     * for storage when this log entry was written, or the sampling decision was
     * unknown at the time. A non-sampled `trace` value is still useful as a
     * request correlation identifier. The default is False.
     * </pre>
     *
     * <code>bool trace_sampled = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The traceSampled to set.
     * @return This builder for chaining.
     */
    public Builder setTraceSampled(boolean value) {

      traceSampled_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The sampling decision of the trace associated with the log entry.
     *
     * True means that the trace resource name in the `trace` field was sampled
     * for storage in a trace backend. False means that the trace was not sampled
     * for storage when this log entry was written, or the sampling decision was
     * unknown at the time. A non-sampled `trace` value is still useful as a
     * request correlation identifier. The default is False.
     * </pre>
     *
     * <code>bool trace_sampled = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTraceSampled() {
      bitField0_ = (bitField0_ & ~0x00004000);
      traceSampled_ = false;
      onChanged();
      return this;
    }

    private com.google.logging.v2.LogEntrySourceLocation sourceLocation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.v2.LogEntrySourceLocation,
            com.google.logging.v2.LogEntrySourceLocation.Builder,
            com.google.logging.v2.LogEntrySourceLocationOrBuilder>
        sourceLocationBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Source code location information associated with the log entry,
     * if any.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LogEntrySourceLocation source_location = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sourceLocation field is set.
     */
    public boolean hasSourceLocation() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Source code location information associated with the log entry,
     * if any.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LogEntrySourceLocation source_location = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sourceLocation.
     */
    public com.google.logging.v2.LogEntrySourceLocation getSourceLocation() {
      if (sourceLocationBuilder_ == null) {
        return sourceLocation_ == null
            ? com.google.logging.v2.LogEntrySourceLocation.getDefaultInstance()
            : sourceLocation_;
      } else {
        return sourceLocationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Source code location information associated with the log entry,
     * if any.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LogEntrySourceLocation source_location = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSourceLocation(com.google.logging.v2.LogEntrySourceLocation value) {
      if (sourceLocationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceLocation_ = value;
      } else {
        sourceLocationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Source code location information associated with the log entry,
     * if any.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LogEntrySourceLocation source_location = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSourceLocation(
        com.google.logging.v2.LogEntrySourceLocation.Builder builderForValue) {
      if (sourceLocationBuilder_ == null) {
        sourceLocation_ = builderForValue.build();
      } else {
        sourceLocationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Source code location information associated with the log entry,
     * if any.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LogEntrySourceLocation source_location = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSourceLocation(com.google.logging.v2.LogEntrySourceLocation value) {
      if (sourceLocationBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && sourceLocation_ != null
            && sourceLocation_
                != com.google.logging.v2.LogEntrySourceLocation.getDefaultInstance()) {
          getSourceLocationBuilder().mergeFrom(value);
        } else {
          sourceLocation_ = value;
        }
      } else {
        sourceLocationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Source code location information associated with the log entry,
     * if any.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LogEntrySourceLocation source_location = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSourceLocation() {
      bitField0_ = (bitField0_ & ~0x00008000);
      sourceLocation_ = null;
      if (sourceLocationBuilder_ != null) {
        sourceLocationBuilder_.dispose();
        sourceLocationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Source code location information associated with the log entry,
     * if any.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LogEntrySourceLocation source_location = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.logging.v2.LogEntrySourceLocation.Builder getSourceLocationBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getSourceLocationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Source code location information associated with the log entry,
     * if any.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LogEntrySourceLocation source_location = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.logging.v2.LogEntrySourceLocationOrBuilder getSourceLocationOrBuilder() {
      if (sourceLocationBuilder_ != null) {
        return sourceLocationBuilder_.getMessageOrBuilder();
      } else {
        return sourceLocation_ == null
            ? com.google.logging.v2.LogEntrySourceLocation.getDefaultInstance()
            : sourceLocation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Source code location information associated with the log entry,
     * if any.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LogEntrySourceLocation source_location = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.v2.LogEntrySourceLocation,
            com.google.logging.v2.LogEntrySourceLocation.Builder,
            com.google.logging.v2.LogEntrySourceLocationOrBuilder>
        getSourceLocationFieldBuilder() {
      if (sourceLocationBuilder_ == null) {
        sourceLocationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.logging.v2.LogEntrySourceLocation,
                com.google.logging.v2.LogEntrySourceLocation.Builder,
                com.google.logging.v2.LogEntrySourceLocationOrBuilder>(
                getSourceLocation(), getParentForChildren(), isClean());
        sourceLocation_ = null;
      }
      return sourceLocationBuilder_;
    }

    private com.google.logging.v2.LogSplit split_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.v2.LogSplit,
            com.google.logging.v2.LogSplit.Builder,
            com.google.logging.v2.LogSplitOrBuilder>
        splitBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Information indicating this LogEntry is part of a sequence of
     * multiple log entries split from a single LogEntry.
     * </pre>
     *
     * <code>.google.logging.v2.LogSplit split = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the split field is set.
     */
    public boolean hasSplit() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Information indicating this LogEntry is part of a sequence of
     * multiple log entries split from a single LogEntry.
     * </pre>
     *
     * <code>.google.logging.v2.LogSplit split = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The split.
     */
    public com.google.logging.v2.LogSplit getSplit() {
      if (splitBuilder_ == null) {
        return split_ == null ? com.google.logging.v2.LogSplit.getDefaultInstance() : split_;
      } else {
        return splitBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information indicating this LogEntry is part of a sequence of
     * multiple log entries split from a single LogEntry.
     * </pre>
     *
     * <code>.google.logging.v2.LogSplit split = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSplit(com.google.logging.v2.LogSplit value) {
      if (splitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        split_ = value;
      } else {
        splitBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information indicating this LogEntry is part of a sequence of
     * multiple log entries split from a single LogEntry.
     * </pre>
     *
     * <code>.google.logging.v2.LogSplit split = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSplit(com.google.logging.v2.LogSplit.Builder builderForValue) {
      if (splitBuilder_ == null) {
        split_ = builderForValue.build();
      } else {
        splitBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information indicating this LogEntry is part of a sequence of
     * multiple log entries split from a single LogEntry.
     * </pre>
     *
     * <code>.google.logging.v2.LogSplit split = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSplit(com.google.logging.v2.LogSplit value) {
      if (splitBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && split_ != null
            && split_ != com.google.logging.v2.LogSplit.getDefaultInstance()) {
          getSplitBuilder().mergeFrom(value);
        } else {
          split_ = value;
        }
      } else {
        splitBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information indicating this LogEntry is part of a sequence of
     * multiple log entries split from a single LogEntry.
     * </pre>
     *
     * <code>.google.logging.v2.LogSplit split = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSplit() {
      bitField0_ = (bitField0_ & ~0x00010000);
      split_ = null;
      if (splitBuilder_ != null) {
        splitBuilder_.dispose();
        splitBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Information indicating this LogEntry is part of a sequence of
     * multiple log entries split from a single LogEntry.
     * </pre>
     *
     * <code>.google.logging.v2.LogSplit split = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.logging.v2.LogSplit.Builder getSplitBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getSplitFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Information indicating this LogEntry is part of a sequence of
     * multiple log entries split from a single LogEntry.
     * </pre>
     *
     * <code>.google.logging.v2.LogSplit split = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.logging.v2.LogSplitOrBuilder getSplitOrBuilder() {
      if (splitBuilder_ != null) {
        return splitBuilder_.getMessageOrBuilder();
      } else {
        return split_ == null ? com.google.logging.v2.LogSplit.getDefaultInstance() : split_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Information indicating this LogEntry is part of a sequence of
     * multiple log entries split from a single LogEntry.
     * </pre>
     *
     * <code>.google.logging.v2.LogSplit split = 35 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.v2.LogSplit,
            com.google.logging.v2.LogSplit.Builder,
            com.google.logging.v2.LogSplitOrBuilder>
        getSplitFieldBuilder() {
      if (splitBuilder_ == null) {
        splitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.logging.v2.LogSplit,
                com.google.logging.v2.LogSplit.Builder,
                com.google.logging.v2.LogSplitOrBuilder>(
                getSplit(), getParentForChildren(), isClean());
        split_ = null;
      }
      return splitBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.logging.v2.LogEntry)
  }

  // @@protoc_insertion_point(class_scope:google.logging.v2.LogEntry)
  private static final com.google.logging.v2.LogEntry DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.logging.v2.LogEntry();
  }

  public static com.google.logging.v2.LogEntry getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LogEntry> PARSER =
      new com.google.protobuf.AbstractParser<LogEntry>() {
        @java.lang.Override
        public LogEntry parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LogEntry> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LogEntry> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.logging.v2.LogEntry getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
