/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/logging/v2/logging_config.proto

package com.google.logging.v2;

/**
 *
 *
 * <pre>
 * Describes the settings associated with a project, folder, organization,
 * billing account, or flexible resource.
 * </pre>
 *
 * Protobuf type {@code google.logging.v2.Settings}
 */
public final class Settings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.logging.v2.Settings)
    SettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Settings.newBuilder() to construct.
  private Settings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Settings() {
    name_ = "";
    kmsKeyName_ = "";
    kmsServiceAccountId_ = "";
    storageLocation_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Settings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.logging.v2.LoggingConfigProto
        .internal_static_google_logging_v2_Settings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.logging.v2.LoggingConfigProto
        .internal_static_google_logging_v2_Settings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.logging.v2.Settings.class, com.google.logging.v2.Settings.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the settings.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the settings.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KMS_KEY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKeyName_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The resource name for the configured Cloud KMS key.
   *
   * KMS key name format:
   *
   *     "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
   *
   * For example:
   *
   *   `"projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key"`
   *
   *
   *
   * To enable CMEK for the Log Router, set this field to a valid
   * `kms_key_name` for which the associated service account has the required
   * `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key.
   *
   * The Cloud KMS key used by the Log Router can be updated by changing the
   * `kms_key_name` to a new valid key name. Encryption operations that are in
   * progress will be completed with the key that was in use when they started.
   * Decryption operations will be completed using the key that was used at the
   * time of encryption unless access to that key has been revoked.
   *
   * To disable CMEK for the Log Router, set this field to an empty string.
   *
   * See [Enabling CMEK for Log
   * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
   * for more information.
   * </pre>
   *
   * <code>string kms_key_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The kmsKeyName.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyName() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The resource name for the configured Cloud KMS key.
   *
   * KMS key name format:
   *
   *     "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
   *
   * For example:
   *
   *   `"projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key"`
   *
   *
   *
   * To enable CMEK for the Log Router, set this field to a valid
   * `kms_key_name` for which the associated service account has the required
   * `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key.
   *
   * The Cloud KMS key used by the Log Router can be updated by changing the
   * `kms_key_name` to a new valid key name. Encryption operations that are in
   * progress will be completed with the key that was in use when they started.
   * Decryption operations will be completed using the key that was used at the
   * time of encryption unless access to that key has been revoked.
   *
   * To disable CMEK for the Log Router, set this field to an empty string.
   *
   * See [Enabling CMEK for Log
   * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
   * for more information.
   * </pre>
   *
   * <code>string kms_key_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for kmsKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyNameBytes() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KMS_SERVICE_ACCOUNT_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsServiceAccountId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The service account that will be used by the Log Router to
   * access your Cloud KMS key.
   *
   * Before enabling CMEK for Log Router, you must first assign the role
   * `roles/cloudkms.cryptoKeyEncrypterDecrypter` to the service account that
   * the Log Router will use to access your Cloud KMS key. Use
   * [GetSettings][google.logging.v2.ConfigServiceV2.GetSettings] to
   * obtain the service account ID.
   *
   * See [Enabling CMEK for Log
   * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
   * for more information.
   * </pre>
   *
   * <code>string kms_service_account_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The kmsServiceAccountId.
   */
  @java.lang.Override
  public java.lang.String getKmsServiceAccountId() {
    java.lang.Object ref = kmsServiceAccountId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsServiceAccountId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The service account that will be used by the Log Router to
   * access your Cloud KMS key.
   *
   * Before enabling CMEK for Log Router, you must first assign the role
   * `roles/cloudkms.cryptoKeyEncrypterDecrypter` to the service account that
   * the Log Router will use to access your Cloud KMS key. Use
   * [GetSettings][google.logging.v2.ConfigServiceV2.GetSettings] to
   * obtain the service account ID.
   *
   * See [Enabling CMEK for Log
   * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
   * for more information.
   * </pre>
   *
   * <code>string kms_service_account_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for kmsServiceAccountId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsServiceAccountIdBytes() {
    java.lang.Object ref = kmsServiceAccountId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsServiceAccountId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STORAGE_LOCATION_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object storageLocation_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The Cloud region that will be used for _Default and _Required log
   * buckets for newly created projects and folders. For example `europe-west1`.
   * This setting does not affect the location of custom log buckets.
   * </pre>
   *
   * <code>string storage_location = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The storageLocation.
   */
  @java.lang.Override
  public java.lang.String getStorageLocation() {
    java.lang.Object ref = storageLocation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      storageLocation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The Cloud region that will be used for _Default and _Required log
   * buckets for newly created projects and folders. For example `europe-west1`.
   * This setting does not affect the location of custom log buckets.
   * </pre>
   *
   * <code>string storage_location = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for storageLocation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStorageLocationBytes() {
    java.lang.Object ref = storageLocation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      storageLocation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISABLE_DEFAULT_SINK_FIELD_NUMBER = 5;
  private boolean disableDefaultSink_ = false;
  /**
   *
   *
   * <pre>
   * Optional. If set to true, the _Default sink in newly created projects and
   * folders will created in a disabled state. This can be used to automatically
   * disable log ingestion if there is already an aggregated sink configured in
   * the hierarchy. The _Default sink can be re-enabled manually if needed.
   * </pre>
   *
   * <code>bool disable_default_sink = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The disableDefaultSink.
   */
  @java.lang.Override
  public boolean getDisableDefaultSink() {
    return disableDefaultSink_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, kmsKeyName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsServiceAccountId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, kmsServiceAccountId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageLocation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, storageLocation_);
    }
    if (disableDefaultSink_ != false) {
      output.writeBool(5, disableDefaultSink_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, kmsKeyName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsServiceAccountId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, kmsServiceAccountId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageLocation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, storageLocation_);
    }
    if (disableDefaultSink_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, disableDefaultSink_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.logging.v2.Settings)) {
      return super.equals(obj);
    }
    com.google.logging.v2.Settings other = (com.google.logging.v2.Settings) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getKmsKeyName().equals(other.getKmsKeyName())) return false;
    if (!getKmsServiceAccountId().equals(other.getKmsServiceAccountId())) return false;
    if (!getStorageLocation().equals(other.getStorageLocation())) return false;
    if (getDisableDefaultSink() != other.getDisableDefaultSink()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + KMS_KEY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyName().hashCode();
    hash = (37 * hash) + KMS_SERVICE_ACCOUNT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getKmsServiceAccountId().hashCode();
    hash = (37 * hash) + STORAGE_LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getStorageLocation().hashCode();
    hash = (37 * hash) + DISABLE_DEFAULT_SINK_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableDefaultSink());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.logging.v2.Settings parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.Settings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.Settings parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.Settings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.Settings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.Settings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.Settings parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.Settings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.Settings parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.Settings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.Settings parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.Settings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.logging.v2.Settings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes the settings associated with a project, folder, organization,
   * billing account, or flexible resource.
   * </pre>
   *
   * Protobuf type {@code google.logging.v2.Settings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.logging.v2.Settings)
      com.google.logging.v2.SettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.logging.v2.LoggingConfigProto
          .internal_static_google_logging_v2_Settings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.logging.v2.LoggingConfigProto
          .internal_static_google_logging_v2_Settings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.logging.v2.Settings.class, com.google.logging.v2.Settings.Builder.class);
    }

    // Construct using com.google.logging.v2.Settings.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      kmsKeyName_ = "";
      kmsServiceAccountId_ = "";
      storageLocation_ = "";
      disableDefaultSink_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.logging.v2.LoggingConfigProto
          .internal_static_google_logging_v2_Settings_descriptor;
    }

    @java.lang.Override
    public com.google.logging.v2.Settings getDefaultInstanceForType() {
      return com.google.logging.v2.Settings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.logging.v2.Settings build() {
      com.google.logging.v2.Settings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.logging.v2.Settings buildPartial() {
      com.google.logging.v2.Settings result = new com.google.logging.v2.Settings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.logging.v2.Settings result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.kmsKeyName_ = kmsKeyName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.kmsServiceAccountId_ = kmsServiceAccountId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.storageLocation_ = storageLocation_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.disableDefaultSink_ = disableDefaultSink_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.logging.v2.Settings) {
        return mergeFrom((com.google.logging.v2.Settings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.logging.v2.Settings other) {
      if (other == com.google.logging.v2.Settings.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getKmsKeyName().isEmpty()) {
        kmsKeyName_ = other.kmsKeyName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getKmsServiceAccountId().isEmpty()) {
        kmsServiceAccountId_ = other.kmsServiceAccountId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getStorageLocation().isEmpty()) {
        storageLocation_ = other.storageLocation_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getDisableDefaultSink() != false) {
        setDisableDefaultSink(other.getDisableDefaultSink());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                kmsKeyName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                kmsServiceAccountId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                storageLocation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                disableDefaultSink_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the settings.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the settings.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the settings.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the settings.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the settings.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKeyName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The resource name for the configured Cloud KMS key.
     *
     * KMS key name format:
     *
     *     "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
     *
     * For example:
     *
     *   `"projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key"`
     *
     *
     *
     * To enable CMEK for the Log Router, set this field to a valid
     * `kms_key_name` for which the associated service account has the required
     * `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key.
     *
     * The Cloud KMS key used by the Log Router can be updated by changing the
     * `kms_key_name` to a new valid key name. Encryption operations that are in
     * progress will be completed with the key that was in use when they started.
     * Decryption operations will be completed using the key that was used at the
     * time of encryption unless access to that key has been revoked.
     *
     * To disable CMEK for the Log Router, set this field to an empty string.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     * </pre>
     *
     * <code>string kms_key_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The kmsKeyName.
     */
    public java.lang.String getKmsKeyName() {
      java.lang.Object ref = kmsKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name for the configured Cloud KMS key.
     *
     * KMS key name format:
     *
     *     "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
     *
     * For example:
     *
     *   `"projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key"`
     *
     *
     *
     * To enable CMEK for the Log Router, set this field to a valid
     * `kms_key_name` for which the associated service account has the required
     * `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key.
     *
     * The Cloud KMS key used by the Log Router can be updated by changing the
     * `kms_key_name` to a new valid key name. Encryption operations that are in
     * progress will be completed with the key that was in use when they started.
     * Decryption operations will be completed using the key that was used at the
     * time of encryption unless access to that key has been revoked.
     *
     * To disable CMEK for the Log Router, set this field to an empty string.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     * </pre>
     *
     * <code>string kms_key_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for kmsKeyName.
     */
    public com.google.protobuf.ByteString getKmsKeyNameBytes() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name for the configured Cloud KMS key.
     *
     * KMS key name format:
     *
     *     "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
     *
     * For example:
     *
     *   `"projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key"`
     *
     *
     *
     * To enable CMEK for the Log Router, set this field to a valid
     * `kms_key_name` for which the associated service account has the required
     * `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key.
     *
     * The Cloud KMS key used by the Log Router can be updated by changing the
     * `kms_key_name` to a new valid key name. Encryption operations that are in
     * progress will be completed with the key that was in use when they started.
     * Decryption operations will be completed using the key that was used at the
     * time of encryption unless access to that key has been revoked.
     *
     * To disable CMEK for the Log Router, set this field to an empty string.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     * </pre>
     *
     * <code>string kms_key_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKeyName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name for the configured Cloud KMS key.
     *
     * KMS key name format:
     *
     *     "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
     *
     * For example:
     *
     *   `"projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key"`
     *
     *
     *
     * To enable CMEK for the Log Router, set this field to a valid
     * `kms_key_name` for which the associated service account has the required
     * `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key.
     *
     * The Cloud KMS key used by the Log Router can be updated by changing the
     * `kms_key_name` to a new valid key name. Encryption operations that are in
     * progress will be completed with the key that was in use when they started.
     * Decryption operations will be completed using the key that was used at the
     * time of encryption unless access to that key has been revoked.
     *
     * To disable CMEK for the Log Router, set this field to an empty string.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     * </pre>
     *
     * <code>string kms_key_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyName() {
      kmsKeyName_ = getDefaultInstance().getKmsKeyName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource name for the configured Cloud KMS key.
     *
     * KMS key name format:
     *
     *     "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
     *
     * For example:
     *
     *   `"projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKeys/my-key"`
     *
     *
     *
     * To enable CMEK for the Log Router, set this field to a valid
     * `kms_key_name` for which the associated service account has the required
     * `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key.
     *
     * The Cloud KMS key used by the Log Router can be updated by changing the
     * `kms_key_name` to a new valid key name. Encryption operations that are in
     * progress will be completed with the key that was in use when they started.
     * Decryption operations will be completed using the key that was used at the
     * time of encryption unless access to that key has been revoked.
     *
     * To disable CMEK for the Log Router, set this field to an empty string.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     * </pre>
     *
     * <code>string kms_key_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKeyName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object kmsServiceAccountId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The service account that will be used by the Log Router to
     * access your Cloud KMS key.
     *
     * Before enabling CMEK for Log Router, you must first assign the role
     * `roles/cloudkms.cryptoKeyEncrypterDecrypter` to the service account that
     * the Log Router will use to access your Cloud KMS key. Use
     * [GetSettings][google.logging.v2.ConfigServiceV2.GetSettings] to
     * obtain the service account ID.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     * </pre>
     *
     * <code>string kms_service_account_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The kmsServiceAccountId.
     */
    public java.lang.String getKmsServiceAccountId() {
      java.lang.Object ref = kmsServiceAccountId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsServiceAccountId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The service account that will be used by the Log Router to
     * access your Cloud KMS key.
     *
     * Before enabling CMEK for Log Router, you must first assign the role
     * `roles/cloudkms.cryptoKeyEncrypterDecrypter` to the service account that
     * the Log Router will use to access your Cloud KMS key. Use
     * [GetSettings][google.logging.v2.ConfigServiceV2.GetSettings] to
     * obtain the service account ID.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     * </pre>
     *
     * <code>string kms_service_account_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for kmsServiceAccountId.
     */
    public com.google.protobuf.ByteString getKmsServiceAccountIdBytes() {
      java.lang.Object ref = kmsServiceAccountId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsServiceAccountId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The service account that will be used by the Log Router to
     * access your Cloud KMS key.
     *
     * Before enabling CMEK for Log Router, you must first assign the role
     * `roles/cloudkms.cryptoKeyEncrypterDecrypter` to the service account that
     * the Log Router will use to access your Cloud KMS key. Use
     * [GetSettings][google.logging.v2.ConfigServiceV2.GetSettings] to
     * obtain the service account ID.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     * </pre>
     *
     * <code>string kms_service_account_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The kmsServiceAccountId to set.
     * @return This builder for chaining.
     */
    public Builder setKmsServiceAccountId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsServiceAccountId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The service account that will be used by the Log Router to
     * access your Cloud KMS key.
     *
     * Before enabling CMEK for Log Router, you must first assign the role
     * `roles/cloudkms.cryptoKeyEncrypterDecrypter` to the service account that
     * the Log Router will use to access your Cloud KMS key. Use
     * [GetSettings][google.logging.v2.ConfigServiceV2.GetSettings] to
     * obtain the service account ID.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     * </pre>
     *
     * <code>string kms_service_account_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsServiceAccountId() {
      kmsServiceAccountId_ = getDefaultInstance().getKmsServiceAccountId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The service account that will be used by the Log Router to
     * access your Cloud KMS key.
     *
     * Before enabling CMEK for Log Router, you must first assign the role
     * `roles/cloudkms.cryptoKeyEncrypterDecrypter` to the service account that
     * the Log Router will use to access your Cloud KMS key. Use
     * [GetSettings][google.logging.v2.ConfigServiceV2.GetSettings] to
     * obtain the service account ID.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     * </pre>
     *
     * <code>string kms_service_account_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for kmsServiceAccountId to set.
     * @return This builder for chaining.
     */
    public Builder setKmsServiceAccountIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsServiceAccountId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object storageLocation_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Cloud region that will be used for _Default and _Required log
     * buckets for newly created projects and folders. For example `europe-west1`.
     * This setting does not affect the location of custom log buckets.
     * </pre>
     *
     * <code>string storage_location = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The storageLocation.
     */
    public java.lang.String getStorageLocation() {
      java.lang.Object ref = storageLocation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        storageLocation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Cloud region that will be used for _Default and _Required log
     * buckets for newly created projects and folders. For example `europe-west1`.
     * This setting does not affect the location of custom log buckets.
     * </pre>
     *
     * <code>string storage_location = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for storageLocation.
     */
    public com.google.protobuf.ByteString getStorageLocationBytes() {
      java.lang.Object ref = storageLocation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        storageLocation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Cloud region that will be used for _Default and _Required log
     * buckets for newly created projects and folders. For example `europe-west1`.
     * This setting does not affect the location of custom log buckets.
     * </pre>
     *
     * <code>string storage_location = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The storageLocation to set.
     * @return This builder for chaining.
     */
    public Builder setStorageLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      storageLocation_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Cloud region that will be used for _Default and _Required log
     * buckets for newly created projects and folders. For example `europe-west1`.
     * This setting does not affect the location of custom log buckets.
     * </pre>
     *
     * <code>string storage_location = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStorageLocation() {
      storageLocation_ = getDefaultInstance().getStorageLocation();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Cloud region that will be used for _Default and _Required log
     * buckets for newly created projects and folders. For example `europe-west1`.
     * This setting does not affect the location of custom log buckets.
     * </pre>
     *
     * <code>string storage_location = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for storageLocation to set.
     * @return This builder for chaining.
     */
    public Builder setStorageLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      storageLocation_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean disableDefaultSink_;
    /**
     *
     *
     * <pre>
     * Optional. If set to true, the _Default sink in newly created projects and
     * folders will created in a disabled state. This can be used to automatically
     * disable log ingestion if there is already an aggregated sink configured in
     * the hierarchy. The _Default sink can be re-enabled manually if needed.
     * </pre>
     *
     * <code>bool disable_default_sink = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The disableDefaultSink.
     */
    @java.lang.Override
    public boolean getDisableDefaultSink() {
      return disableDefaultSink_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set to true, the _Default sink in newly created projects and
     * folders will created in a disabled state. This can be used to automatically
     * disable log ingestion if there is already an aggregated sink configured in
     * the hierarchy. The _Default sink can be re-enabled manually if needed.
     * </pre>
     *
     * <code>bool disable_default_sink = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The disableDefaultSink to set.
     * @return This builder for chaining.
     */
    public Builder setDisableDefaultSink(boolean value) {

      disableDefaultSink_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set to true, the _Default sink in newly created projects and
     * folders will created in a disabled state. This can be used to automatically
     * disable log ingestion if there is already an aggregated sink configured in
     * the hierarchy. The _Default sink can be re-enabled manually if needed.
     * </pre>
     *
     * <code>bool disable_default_sink = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableDefaultSink() {
      bitField0_ = (bitField0_ & ~0x00000010);
      disableDefaultSink_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.logging.v2.Settings)
  }

  // @@protoc_insertion_point(class_scope:google.logging.v2.Settings)
  private static final com.google.logging.v2.Settings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.logging.v2.Settings();
  }

  public static com.google.logging.v2.Settings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Settings> PARSER =
      new com.google.protobuf.AbstractParser<Settings>() {
        @java.lang.Override
        public Settings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Settings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Settings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.logging.v2.Settings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
