/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/logging/v2/logging_config.proto

// Protobuf Java Version: 3.25.5
package com.google.logging.v2;

/**
 *
 *
 * <pre>
 * Describes a repository in which log entries are stored.
 * </pre>
 *
 * Protobuf type {@code google.logging.v2.LogBucket}
 */
public final class LogBucket extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.logging.v2.LogBucket)
    LogBucketOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LogBucket.newBuilder() to construct.
  private LogBucket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LogBucket() {
    name_ = "";
    description_ = "";
    lifecycleState_ = 0;
    restrictedFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
    indexConfigs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LogBucket();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.logging.v2.LoggingConfigProto
        .internal_static_google_logging_v2_LogBucket_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.logging.v2.LoggingConfigProto
        .internal_static_google_logging_v2_LogBucket_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.logging.v2.LogBucket.class, com.google.logging.v2.LogBucket.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the bucket.
   *
   * For example:
   *
   *   `projects/my-project/locations/global/buckets/my-bucket`
   *
   * For a list of supported locations, see [Supported
   * Regions](https://cloud.google.com/logging/docs/region-support)
   *
   * For the location of `global` it is unspecified where log entries are
   * actually stored.
   *
   * After a bucket has been created, the location cannot be changed.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the bucket.
   *
   * For example:
   *
   *   `projects/my-project/locations/global/buckets/my-bucket`
   *
   * For a list of supported locations, see [Supported
   * Regions](https://cloud.google.com/logging/docs/region-support)
   *
   * For the location of `global` it is unspecified where log entries are
   * actually stored.
   *
   * After a bucket has been created, the location cannot be changed.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Describes this bucket.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Describes this bucket.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of the bucket. This is not set for any
   * of the default buckets.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of the bucket. This is not set for any
   * of the default buckets.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation timestamp of the bucket. This is not set for any
   * of the default buckets.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of the bucket.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of the bucket.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of the bucket.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int RETENTION_DAYS_FIELD_NUMBER = 11;
  private int retentionDays_ = 0;
  /**
   *
   *
   * <pre>
   * Logs will be retained by default for this amount of time, after which they
   * will automatically be deleted. The minimum retention period is 1 day. If
   * this value is set to zero at bucket creation time, the default time of 30
   * days will be used.
   * </pre>
   *
   * <code>int32 retention_days = 11;</code>
   *
   * @return The retentionDays.
   */
  @java.lang.Override
  public int getRetentionDays() {
    return retentionDays_;
  }

  public static final int LOCKED_FIELD_NUMBER = 9;
  private boolean locked_ = false;
  /**
   *
   *
   * <pre>
   * Whether the bucket is locked.
   *
   * The retention period on a locked bucket cannot be changed. Locked buckets
   * may only be deleted if they are empty.
   * </pre>
   *
   * <code>bool locked = 9;</code>
   *
   * @return The locked.
   */
  @java.lang.Override
  public boolean getLocked() {
    return locked_;
  }

  public static final int LIFECYCLE_STATE_FIELD_NUMBER = 12;
  private int lifecycleState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The bucket lifecycle state.
   * </pre>
   *
   * <code>
   * .google.logging.v2.LifecycleState lifecycle_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for lifecycleState.
   */
  @java.lang.Override
  public int getLifecycleStateValue() {
    return lifecycleState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The bucket lifecycle state.
   * </pre>
   *
   * <code>
   * .google.logging.v2.LifecycleState lifecycle_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lifecycleState.
   */
  @java.lang.Override
  public com.google.logging.v2.LifecycleState getLifecycleState() {
    com.google.logging.v2.LifecycleState result =
        com.google.logging.v2.LifecycleState.forNumber(lifecycleState_);
    return result == null ? com.google.logging.v2.LifecycleState.UNRECOGNIZED : result;
  }

  public static final int ANALYTICS_ENABLED_FIELD_NUMBER = 14;
  private boolean analyticsEnabled_ = false;
  /**
   *
   *
   * <pre>
   * Whether log analytics is enabled for this bucket.
   *
   * Once enabled, log analytics features cannot be disabled.
   * </pre>
   *
   * <code>bool analytics_enabled = 14;</code>
   *
   * @return The analyticsEnabled.
   */
  @java.lang.Override
  public boolean getAnalyticsEnabled() {
    return analyticsEnabled_;
  }

  public static final int RESTRICTED_FIELDS_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList restrictedFields_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Log entry field paths that are denied access in this bucket.
   *
   * The following fields and their children are eligible: `textPayload`,
   * `jsonPayload`, `protoPayload`, `httpRequest`, `labels`, `sourceLocation`.
   *
   * Restricting a repeated field will restrict all values. Adding a parent will
   * block all child fields. (e.g. `foo.bar` will block `foo.bar.baz`)
   * </pre>
   *
   * <code>repeated string restricted_fields = 15;</code>
   *
   * @return A list containing the restrictedFields.
   */
  public com.google.protobuf.ProtocolStringList getRestrictedFieldsList() {
    return restrictedFields_;
  }
  /**
   *
   *
   * <pre>
   * Log entry field paths that are denied access in this bucket.
   *
   * The following fields and their children are eligible: `textPayload`,
   * `jsonPayload`, `protoPayload`, `httpRequest`, `labels`, `sourceLocation`.
   *
   * Restricting a repeated field will restrict all values. Adding a parent will
   * block all child fields. (e.g. `foo.bar` will block `foo.bar.baz`)
   * </pre>
   *
   * <code>repeated string restricted_fields = 15;</code>
   *
   * @return The count of restrictedFields.
   */
  public int getRestrictedFieldsCount() {
    return restrictedFields_.size();
  }
  /**
   *
   *
   * <pre>
   * Log entry field paths that are denied access in this bucket.
   *
   * The following fields and their children are eligible: `textPayload`,
   * `jsonPayload`, `protoPayload`, `httpRequest`, `labels`, `sourceLocation`.
   *
   * Restricting a repeated field will restrict all values. Adding a parent will
   * block all child fields. (e.g. `foo.bar` will block `foo.bar.baz`)
   * </pre>
   *
   * <code>repeated string restricted_fields = 15;</code>
   *
   * @param index The index of the element to return.
   * @return The restrictedFields at the given index.
   */
  public java.lang.String getRestrictedFields(int index) {
    return restrictedFields_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Log entry field paths that are denied access in this bucket.
   *
   * The following fields and their children are eligible: `textPayload`,
   * `jsonPayload`, `protoPayload`, `httpRequest`, `labels`, `sourceLocation`.
   *
   * Restricting a repeated field will restrict all values. Adding a parent will
   * block all child fields. (e.g. `foo.bar` will block `foo.bar.baz`)
   * </pre>
   *
   * <code>repeated string restricted_fields = 15;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the restrictedFields at the given index.
   */
  public com.google.protobuf.ByteString getRestrictedFieldsBytes(int index) {
    return restrictedFields_.getByteString(index);
  }

  public static final int INDEX_CONFIGS_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private java.util.List<com.google.logging.v2.IndexConfig> indexConfigs_;
  /**
   *
   *
   * <pre>
   * A list of indexed fields and related configuration data.
   * </pre>
   *
   * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.logging.v2.IndexConfig> getIndexConfigsList() {
    return indexConfigs_;
  }
  /**
   *
   *
   * <pre>
   * A list of indexed fields and related configuration data.
   * </pre>
   *
   * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.logging.v2.IndexConfigOrBuilder>
      getIndexConfigsOrBuilderList() {
    return indexConfigs_;
  }
  /**
   *
   *
   * <pre>
   * A list of indexed fields and related configuration data.
   * </pre>
   *
   * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
   */
  @java.lang.Override
  public int getIndexConfigsCount() {
    return indexConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of indexed fields and related configuration data.
   * </pre>
   *
   * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
   */
  @java.lang.Override
  public com.google.logging.v2.IndexConfig getIndexConfigs(int index) {
    return indexConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of indexed fields and related configuration data.
   * </pre>
   *
   * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
   */
  @java.lang.Override
  public com.google.logging.v2.IndexConfigOrBuilder getIndexConfigsOrBuilder(int index) {
    return indexConfigs_.get(index);
  }

  public static final int CMEK_SETTINGS_FIELD_NUMBER = 19;
  private com.google.logging.v2.CmekSettings cmekSettings_;
  /**
   *
   *
   * <pre>
   * The CMEK settings of the log bucket. If present, new log entries written to
   * this log bucket are encrypted using the CMEK key provided in this
   * configuration. If a log bucket has CMEK settings, the CMEK settings cannot
   * be disabled later by updating the log bucket. Changing the KMS key is
   * allowed.
   * </pre>
   *
   * <code>.google.logging.v2.CmekSettings cmek_settings = 19;</code>
   *
   * @return Whether the cmekSettings field is set.
   */
  @java.lang.Override
  public boolean hasCmekSettings() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The CMEK settings of the log bucket. If present, new log entries written to
   * this log bucket are encrypted using the CMEK key provided in this
   * configuration. If a log bucket has CMEK settings, the CMEK settings cannot
   * be disabled later by updating the log bucket. Changing the KMS key is
   * allowed.
   * </pre>
   *
   * <code>.google.logging.v2.CmekSettings cmek_settings = 19;</code>
   *
   * @return The cmekSettings.
   */
  @java.lang.Override
  public com.google.logging.v2.CmekSettings getCmekSettings() {
    return cmekSettings_ == null
        ? com.google.logging.v2.CmekSettings.getDefaultInstance()
        : cmekSettings_;
  }
  /**
   *
   *
   * <pre>
   * The CMEK settings of the log bucket. If present, new log entries written to
   * this log bucket are encrypted using the CMEK key provided in this
   * configuration. If a log bucket has CMEK settings, the CMEK settings cannot
   * be disabled later by updating the log bucket. Changing the KMS key is
   * allowed.
   * </pre>
   *
   * <code>.google.logging.v2.CmekSettings cmek_settings = 19;</code>
   */
  @java.lang.Override
  public com.google.logging.v2.CmekSettingsOrBuilder getCmekSettingsOrBuilder() {
    return cmekSettings_ == null
        ? com.google.logging.v2.CmekSettings.getDefaultInstance()
        : cmekSettings_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getUpdateTime());
    }
    if (locked_ != false) {
      output.writeBool(9, locked_);
    }
    if (retentionDays_ != 0) {
      output.writeInt32(11, retentionDays_);
    }
    if (lifecycleState_
        != com.google.logging.v2.LifecycleState.LIFECYCLE_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(12, lifecycleState_);
    }
    if (analyticsEnabled_ != false) {
      output.writeBool(14, analyticsEnabled_);
    }
    for (int i = 0; i < restrictedFields_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, restrictedFields_.getRaw(i));
    }
    for (int i = 0; i < indexConfigs_.size(); i++) {
      output.writeMessage(17, indexConfigs_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(19, getCmekSettings());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
    }
    if (locked_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, locked_);
    }
    if (retentionDays_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(11, retentionDays_);
    }
    if (lifecycleState_
        != com.google.logging.v2.LifecycleState.LIFECYCLE_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(12, lifecycleState_);
    }
    if (analyticsEnabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(14, analyticsEnabled_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < restrictedFields_.size(); i++) {
        dataSize += computeStringSizeNoTag(restrictedFields_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getRestrictedFieldsList().size();
    }
    for (int i = 0; i < indexConfigs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, indexConfigs_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, getCmekSettings());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.logging.v2.LogBucket)) {
      return super.equals(obj);
    }
    com.google.logging.v2.LogBucket other = (com.google.logging.v2.LogBucket) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (getRetentionDays() != other.getRetentionDays()) return false;
    if (getLocked() != other.getLocked()) return false;
    if (lifecycleState_ != other.lifecycleState_) return false;
    if (getAnalyticsEnabled() != other.getAnalyticsEnabled()) return false;
    if (!getRestrictedFieldsList().equals(other.getRestrictedFieldsList())) return false;
    if (!getIndexConfigsList().equals(other.getIndexConfigsList())) return false;
    if (hasCmekSettings() != other.hasCmekSettings()) return false;
    if (hasCmekSettings()) {
      if (!getCmekSettings().equals(other.getCmekSettings())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + RETENTION_DAYS_FIELD_NUMBER;
    hash = (53 * hash) + getRetentionDays();
    hash = (37 * hash) + LOCKED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getLocked());
    hash = (37 * hash) + LIFECYCLE_STATE_FIELD_NUMBER;
    hash = (53 * hash) + lifecycleState_;
    hash = (37 * hash) + ANALYTICS_ENABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAnalyticsEnabled());
    if (getRestrictedFieldsCount() > 0) {
      hash = (37 * hash) + RESTRICTED_FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getRestrictedFieldsList().hashCode();
    }
    if (getIndexConfigsCount() > 0) {
      hash = (37 * hash) + INDEX_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getIndexConfigsList().hashCode();
    }
    if (hasCmekSettings()) {
      hash = (37 * hash) + CMEK_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getCmekSettings().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.logging.v2.LogBucket parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.LogBucket parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.LogBucket parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.LogBucket parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.LogBucket parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.LogBucket parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.LogBucket parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.LogBucket parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.LogBucket parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.LogBucket parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.LogBucket parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.LogBucket parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.logging.v2.LogBucket prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes a repository in which log entries are stored.
   * </pre>
   *
   * Protobuf type {@code google.logging.v2.LogBucket}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.logging.v2.LogBucket)
      com.google.logging.v2.LogBucketOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.logging.v2.LoggingConfigProto
          .internal_static_google_logging_v2_LogBucket_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.logging.v2.LoggingConfigProto
          .internal_static_google_logging_v2_LogBucket_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.logging.v2.LogBucket.class, com.google.logging.v2.LogBucket.Builder.class);
    }

    // Construct using com.google.logging.v2.LogBucket.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getIndexConfigsFieldBuilder();
        getCmekSettingsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      retentionDays_ = 0;
      locked_ = false;
      lifecycleState_ = 0;
      analyticsEnabled_ = false;
      restrictedFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (indexConfigsBuilder_ == null) {
        indexConfigs_ = java.util.Collections.emptyList();
      } else {
        indexConfigs_ = null;
        indexConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      cmekSettings_ = null;
      if (cmekSettingsBuilder_ != null) {
        cmekSettingsBuilder_.dispose();
        cmekSettingsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.logging.v2.LoggingConfigProto
          .internal_static_google_logging_v2_LogBucket_descriptor;
    }

    @java.lang.Override
    public com.google.logging.v2.LogBucket getDefaultInstanceForType() {
      return com.google.logging.v2.LogBucket.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.logging.v2.LogBucket build() {
      com.google.logging.v2.LogBucket result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.logging.v2.LogBucket buildPartial() {
      com.google.logging.v2.LogBucket result = new com.google.logging.v2.LogBucket(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.logging.v2.LogBucket result) {
      if (indexConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          indexConfigs_ = java.util.Collections.unmodifiableList(indexConfigs_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.indexConfigs_ = indexConfigs_;
      } else {
        result.indexConfigs_ = indexConfigsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.logging.v2.LogBucket result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.retentionDays_ = retentionDays_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.locked_ = locked_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.lifecycleState_ = lifecycleState_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.analyticsEnabled_ = analyticsEnabled_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        restrictedFields_.makeImmutable();
        result.restrictedFields_ = restrictedFields_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.cmekSettings_ =
            cmekSettingsBuilder_ == null ? cmekSettings_ : cmekSettingsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.logging.v2.LogBucket) {
        return mergeFrom((com.google.logging.v2.LogBucket) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.logging.v2.LogBucket other) {
      if (other == com.google.logging.v2.LogBucket.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.getRetentionDays() != 0) {
        setRetentionDays(other.getRetentionDays());
      }
      if (other.getLocked() != false) {
        setLocked(other.getLocked());
      }
      if (other.lifecycleState_ != 0) {
        setLifecycleStateValue(other.getLifecycleStateValue());
      }
      if (other.getAnalyticsEnabled() != false) {
        setAnalyticsEnabled(other.getAnalyticsEnabled());
      }
      if (!other.restrictedFields_.isEmpty()) {
        if (restrictedFields_.isEmpty()) {
          restrictedFields_ = other.restrictedFields_;
          bitField0_ |= 0x00000100;
        } else {
          ensureRestrictedFieldsIsMutable();
          restrictedFields_.addAll(other.restrictedFields_);
        }
        onChanged();
      }
      if (indexConfigsBuilder_ == null) {
        if (!other.indexConfigs_.isEmpty()) {
          if (indexConfigs_.isEmpty()) {
            indexConfigs_ = other.indexConfigs_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureIndexConfigsIsMutable();
            indexConfigs_.addAll(other.indexConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.indexConfigs_.isEmpty()) {
          if (indexConfigsBuilder_.isEmpty()) {
            indexConfigsBuilder_.dispose();
            indexConfigsBuilder_ = null;
            indexConfigs_ = other.indexConfigs_;
            bitField0_ = (bitField0_ & ~0x00000200);
            indexConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getIndexConfigsFieldBuilder()
                    : null;
          } else {
            indexConfigsBuilder_.addAllMessages(other.indexConfigs_);
          }
        }
      }
      if (other.hasCmekSettings()) {
        mergeCmekSettings(other.getCmekSettings());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 72:
              {
                locked_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 72
            case 88:
              {
                retentionDays_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 88
            case 96:
              {
                lifecycleState_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 96
            case 112:
              {
                analyticsEnabled_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 112
            case 122:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRestrictedFieldsIsMutable();
                restrictedFields_.add(s);
                break;
              } // case 122
            case 138:
              {
                com.google.logging.v2.IndexConfig m =
                    input.readMessage(
                        com.google.logging.v2.IndexConfig.parser(), extensionRegistry);
                if (indexConfigsBuilder_ == null) {
                  ensureIndexConfigsIsMutable();
                  indexConfigs_.add(m);
                } else {
                  indexConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 138
            case 154:
              {
                input.readMessage(getCmekSettingsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 154
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the bucket.
     *
     * For example:
     *
     *   `projects/my-project/locations/global/buckets/my-bucket`
     *
     * For a list of supported locations, see [Supported
     * Regions](https://cloud.google.com/logging/docs/region-support)
     *
     * For the location of `global` it is unspecified where log entries are
     * actually stored.
     *
     * After a bucket has been created, the location cannot be changed.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the bucket.
     *
     * For example:
     *
     *   `projects/my-project/locations/global/buckets/my-bucket`
     *
     * For a list of supported locations, see [Supported
     * Regions](https://cloud.google.com/logging/docs/region-support)
     *
     * For the location of `global` it is unspecified where log entries are
     * actually stored.
     *
     * After a bucket has been created, the location cannot be changed.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the bucket.
     *
     * For example:
     *
     *   `projects/my-project/locations/global/buckets/my-bucket`
     *
     * For a list of supported locations, see [Supported
     * Regions](https://cloud.google.com/logging/docs/region-support)
     *
     * For the location of `global` it is unspecified where log entries are
     * actually stored.
     *
     * After a bucket has been created, the location cannot be changed.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the bucket.
     *
     * For example:
     *
     *   `projects/my-project/locations/global/buckets/my-bucket`
     *
     * For a list of supported locations, see [Supported
     * Regions](https://cloud.google.com/logging/docs/region-support)
     *
     * For the location of `global` it is unspecified where log entries are
     * actually stored.
     *
     * After a bucket has been created, the location cannot be changed.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the bucket.
     *
     * For example:
     *
     *   `projects/my-project/locations/global/buckets/my-bucket`
     *
     * For a list of supported locations, see [Supported
     * Regions](https://cloud.google.com/logging/docs/region-support)
     *
     * For the location of `global` it is unspecified where log entries are
     * actually stored.
     *
     * After a bucket has been created, the location cannot be changed.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Describes this bucket.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Describes this bucket.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Describes this bucket.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes this bucket.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes this bucket.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the bucket. This is not set for any
     * of the default buckets.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the bucket. This is not set for any
     * of the default buckets.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the bucket. This is not set for any
     * of the default buckets.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the bucket. This is not set for any
     * of the default buckets.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the bucket. This is not set for any
     * of the default buckets.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the bucket. This is not set for any
     * of the default buckets.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the bucket. This is not set for any
     * of the default buckets.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the bucket. This is not set for any
     * of the default buckets.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation timestamp of the bucket. This is not set for any
     * of the default buckets.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of the bucket.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private int retentionDays_;
    /**
     *
     *
     * <pre>
     * Logs will be retained by default for this amount of time, after which they
     * will automatically be deleted. The minimum retention period is 1 day. If
     * this value is set to zero at bucket creation time, the default time of 30
     * days will be used.
     * </pre>
     *
     * <code>int32 retention_days = 11;</code>
     *
     * @return The retentionDays.
     */
    @java.lang.Override
    public int getRetentionDays() {
      return retentionDays_;
    }
    /**
     *
     *
     * <pre>
     * Logs will be retained by default for this amount of time, after which they
     * will automatically be deleted. The minimum retention period is 1 day. If
     * this value is set to zero at bucket creation time, the default time of 30
     * days will be used.
     * </pre>
     *
     * <code>int32 retention_days = 11;</code>
     *
     * @param value The retentionDays to set.
     * @return This builder for chaining.
     */
    public Builder setRetentionDays(int value) {

      retentionDays_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Logs will be retained by default for this amount of time, after which they
     * will automatically be deleted. The minimum retention period is 1 day. If
     * this value is set to zero at bucket creation time, the default time of 30
     * days will be used.
     * </pre>
     *
     * <code>int32 retention_days = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRetentionDays() {
      bitField0_ = (bitField0_ & ~0x00000010);
      retentionDays_ = 0;
      onChanged();
      return this;
    }

    private boolean locked_;
    /**
     *
     *
     * <pre>
     * Whether the bucket is locked.
     *
     * The retention period on a locked bucket cannot be changed. Locked buckets
     * may only be deleted if they are empty.
     * </pre>
     *
     * <code>bool locked = 9;</code>
     *
     * @return The locked.
     */
    @java.lang.Override
    public boolean getLocked() {
      return locked_;
    }
    /**
     *
     *
     * <pre>
     * Whether the bucket is locked.
     *
     * The retention period on a locked bucket cannot be changed. Locked buckets
     * may only be deleted if they are empty.
     * </pre>
     *
     * <code>bool locked = 9;</code>
     *
     * @param value The locked to set.
     * @return This builder for chaining.
     */
    public Builder setLocked(boolean value) {

      locked_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether the bucket is locked.
     *
     * The retention period on a locked bucket cannot be changed. Locked buckets
     * may only be deleted if they are empty.
     * </pre>
     *
     * <code>bool locked = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocked() {
      bitField0_ = (bitField0_ & ~0x00000020);
      locked_ = false;
      onChanged();
      return this;
    }

    private int lifecycleState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The bucket lifecycle state.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LifecycleState lifecycle_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for lifecycleState.
     */
    @java.lang.Override
    public int getLifecycleStateValue() {
      return lifecycleState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The bucket lifecycle state.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LifecycleState lifecycle_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for lifecycleState to set.
     * @return This builder for chaining.
     */
    public Builder setLifecycleStateValue(int value) {
      lifecycleState_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The bucket lifecycle state.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LifecycleState lifecycle_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lifecycleState.
     */
    @java.lang.Override
    public com.google.logging.v2.LifecycleState getLifecycleState() {
      com.google.logging.v2.LifecycleState result =
          com.google.logging.v2.LifecycleState.forNumber(lifecycleState_);
      return result == null ? com.google.logging.v2.LifecycleState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The bucket lifecycle state.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LifecycleState lifecycle_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The lifecycleState to set.
     * @return This builder for chaining.
     */
    public Builder setLifecycleState(com.google.logging.v2.LifecycleState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      lifecycleState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The bucket lifecycle state.
     * </pre>
     *
     * <code>
     * .google.logging.v2.LifecycleState lifecycle_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLifecycleState() {
      bitField0_ = (bitField0_ & ~0x00000040);
      lifecycleState_ = 0;
      onChanged();
      return this;
    }

    private boolean analyticsEnabled_;
    /**
     *
     *
     * <pre>
     * Whether log analytics is enabled for this bucket.
     *
     * Once enabled, log analytics features cannot be disabled.
     * </pre>
     *
     * <code>bool analytics_enabled = 14;</code>
     *
     * @return The analyticsEnabled.
     */
    @java.lang.Override
    public boolean getAnalyticsEnabled() {
      return analyticsEnabled_;
    }
    /**
     *
     *
     * <pre>
     * Whether log analytics is enabled for this bucket.
     *
     * Once enabled, log analytics features cannot be disabled.
     * </pre>
     *
     * <code>bool analytics_enabled = 14;</code>
     *
     * @param value The analyticsEnabled to set.
     * @return This builder for chaining.
     */
    public Builder setAnalyticsEnabled(boolean value) {

      analyticsEnabled_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether log analytics is enabled for this bucket.
     *
     * Once enabled, log analytics features cannot be disabled.
     * </pre>
     *
     * <code>bool analytics_enabled = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnalyticsEnabled() {
      bitField0_ = (bitField0_ & ~0x00000080);
      analyticsEnabled_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList restrictedFields_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureRestrictedFieldsIsMutable() {
      if (!restrictedFields_.isModifiable()) {
        restrictedFields_ = new com.google.protobuf.LazyStringArrayList(restrictedFields_);
      }
      bitField0_ |= 0x00000100;
    }
    /**
     *
     *
     * <pre>
     * Log entry field paths that are denied access in this bucket.
     *
     * The following fields and their children are eligible: `textPayload`,
     * `jsonPayload`, `protoPayload`, `httpRequest`, `labels`, `sourceLocation`.
     *
     * Restricting a repeated field will restrict all values. Adding a parent will
     * block all child fields. (e.g. `foo.bar` will block `foo.bar.baz`)
     * </pre>
     *
     * <code>repeated string restricted_fields = 15;</code>
     *
     * @return A list containing the restrictedFields.
     */
    public com.google.protobuf.ProtocolStringList getRestrictedFieldsList() {
      restrictedFields_.makeImmutable();
      return restrictedFields_;
    }
    /**
     *
     *
     * <pre>
     * Log entry field paths that are denied access in this bucket.
     *
     * The following fields and their children are eligible: `textPayload`,
     * `jsonPayload`, `protoPayload`, `httpRequest`, `labels`, `sourceLocation`.
     *
     * Restricting a repeated field will restrict all values. Adding a parent will
     * block all child fields. (e.g. `foo.bar` will block `foo.bar.baz`)
     * </pre>
     *
     * <code>repeated string restricted_fields = 15;</code>
     *
     * @return The count of restrictedFields.
     */
    public int getRestrictedFieldsCount() {
      return restrictedFields_.size();
    }
    /**
     *
     *
     * <pre>
     * Log entry field paths that are denied access in this bucket.
     *
     * The following fields and their children are eligible: `textPayload`,
     * `jsonPayload`, `protoPayload`, `httpRequest`, `labels`, `sourceLocation`.
     *
     * Restricting a repeated field will restrict all values. Adding a parent will
     * block all child fields. (e.g. `foo.bar` will block `foo.bar.baz`)
     * </pre>
     *
     * <code>repeated string restricted_fields = 15;</code>
     *
     * @param index The index of the element to return.
     * @return The restrictedFields at the given index.
     */
    public java.lang.String getRestrictedFields(int index) {
      return restrictedFields_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Log entry field paths that are denied access in this bucket.
     *
     * The following fields and their children are eligible: `textPayload`,
     * `jsonPayload`, `protoPayload`, `httpRequest`, `labels`, `sourceLocation`.
     *
     * Restricting a repeated field will restrict all values. Adding a parent will
     * block all child fields. (e.g. `foo.bar` will block `foo.bar.baz`)
     * </pre>
     *
     * <code>repeated string restricted_fields = 15;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the restrictedFields at the given index.
     */
    public com.google.protobuf.ByteString getRestrictedFieldsBytes(int index) {
      return restrictedFields_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Log entry field paths that are denied access in this bucket.
     *
     * The following fields and their children are eligible: `textPayload`,
     * `jsonPayload`, `protoPayload`, `httpRequest`, `labels`, `sourceLocation`.
     *
     * Restricting a repeated field will restrict all values. Adding a parent will
     * block all child fields. (e.g. `foo.bar` will block `foo.bar.baz`)
     * </pre>
     *
     * <code>repeated string restricted_fields = 15;</code>
     *
     * @param index The index to set the value at.
     * @param value The restrictedFields to set.
     * @return This builder for chaining.
     */
    public Builder setRestrictedFields(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRestrictedFieldsIsMutable();
      restrictedFields_.set(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Log entry field paths that are denied access in this bucket.
     *
     * The following fields and their children are eligible: `textPayload`,
     * `jsonPayload`, `protoPayload`, `httpRequest`, `labels`, `sourceLocation`.
     *
     * Restricting a repeated field will restrict all values. Adding a parent will
     * block all child fields. (e.g. `foo.bar` will block `foo.bar.baz`)
     * </pre>
     *
     * <code>repeated string restricted_fields = 15;</code>
     *
     * @param value The restrictedFields to add.
     * @return This builder for chaining.
     */
    public Builder addRestrictedFields(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRestrictedFieldsIsMutable();
      restrictedFields_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Log entry field paths that are denied access in this bucket.
     *
     * The following fields and their children are eligible: `textPayload`,
     * `jsonPayload`, `protoPayload`, `httpRequest`, `labels`, `sourceLocation`.
     *
     * Restricting a repeated field will restrict all values. Adding a parent will
     * block all child fields. (e.g. `foo.bar` will block `foo.bar.baz`)
     * </pre>
     *
     * <code>repeated string restricted_fields = 15;</code>
     *
     * @param values The restrictedFields to add.
     * @return This builder for chaining.
     */
    public Builder addAllRestrictedFields(java.lang.Iterable<java.lang.String> values) {
      ensureRestrictedFieldsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, restrictedFields_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Log entry field paths that are denied access in this bucket.
     *
     * The following fields and their children are eligible: `textPayload`,
     * `jsonPayload`, `protoPayload`, `httpRequest`, `labels`, `sourceLocation`.
     *
     * Restricting a repeated field will restrict all values. Adding a parent will
     * block all child fields. (e.g. `foo.bar` will block `foo.bar.baz`)
     * </pre>
     *
     * <code>repeated string restricted_fields = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRestrictedFields() {
      restrictedFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Log entry field paths that are denied access in this bucket.
     *
     * The following fields and their children are eligible: `textPayload`,
     * `jsonPayload`, `protoPayload`, `httpRequest`, `labels`, `sourceLocation`.
     *
     * Restricting a repeated field will restrict all values. Adding a parent will
     * block all child fields. (e.g. `foo.bar` will block `foo.bar.baz`)
     * </pre>
     *
     * <code>repeated string restricted_fields = 15;</code>
     *
     * @param value The bytes of the restrictedFields to add.
     * @return This builder for chaining.
     */
    public Builder addRestrictedFieldsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRestrictedFieldsIsMutable();
      restrictedFields_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.util.List<com.google.logging.v2.IndexConfig> indexConfigs_ =
        java.util.Collections.emptyList();

    private void ensureIndexConfigsIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        indexConfigs_ = new java.util.ArrayList<com.google.logging.v2.IndexConfig>(indexConfigs_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.logging.v2.IndexConfig,
            com.google.logging.v2.IndexConfig.Builder,
            com.google.logging.v2.IndexConfigOrBuilder>
        indexConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of indexed fields and related configuration data.
     * </pre>
     *
     * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
     */
    public java.util.List<com.google.logging.v2.IndexConfig> getIndexConfigsList() {
      if (indexConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(indexConfigs_);
      } else {
        return indexConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of indexed fields and related configuration data.
     * </pre>
     *
     * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
     */
    public int getIndexConfigsCount() {
      if (indexConfigsBuilder_ == null) {
        return indexConfigs_.size();
      } else {
        return indexConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of indexed fields and related configuration data.
     * </pre>
     *
     * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
     */
    public com.google.logging.v2.IndexConfig getIndexConfigs(int index) {
      if (indexConfigsBuilder_ == null) {
        return indexConfigs_.get(index);
      } else {
        return indexConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of indexed fields and related configuration data.
     * </pre>
     *
     * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
     */
    public Builder setIndexConfigs(int index, com.google.logging.v2.IndexConfig value) {
      if (indexConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIndexConfigsIsMutable();
        indexConfigs_.set(index, value);
        onChanged();
      } else {
        indexConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of indexed fields and related configuration data.
     * </pre>
     *
     * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
     */
    public Builder setIndexConfigs(
        int index, com.google.logging.v2.IndexConfig.Builder builderForValue) {
      if (indexConfigsBuilder_ == null) {
        ensureIndexConfigsIsMutable();
        indexConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        indexConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of indexed fields and related configuration data.
     * </pre>
     *
     * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
     */
    public Builder addIndexConfigs(com.google.logging.v2.IndexConfig value) {
      if (indexConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIndexConfigsIsMutable();
        indexConfigs_.add(value);
        onChanged();
      } else {
        indexConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of indexed fields and related configuration data.
     * </pre>
     *
     * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
     */
    public Builder addIndexConfigs(int index, com.google.logging.v2.IndexConfig value) {
      if (indexConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIndexConfigsIsMutable();
        indexConfigs_.add(index, value);
        onChanged();
      } else {
        indexConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of indexed fields and related configuration data.
     * </pre>
     *
     * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
     */
    public Builder addIndexConfigs(com.google.logging.v2.IndexConfig.Builder builderForValue) {
      if (indexConfigsBuilder_ == null) {
        ensureIndexConfigsIsMutable();
        indexConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        indexConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of indexed fields and related configuration data.
     * </pre>
     *
     * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
     */
    public Builder addIndexConfigs(
        int index, com.google.logging.v2.IndexConfig.Builder builderForValue) {
      if (indexConfigsBuilder_ == null) {
        ensureIndexConfigsIsMutable();
        indexConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        indexConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of indexed fields and related configuration data.
     * </pre>
     *
     * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
     */
    public Builder addAllIndexConfigs(
        java.lang.Iterable<? extends com.google.logging.v2.IndexConfig> values) {
      if (indexConfigsBuilder_ == null) {
        ensureIndexConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, indexConfigs_);
        onChanged();
      } else {
        indexConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of indexed fields and related configuration data.
     * </pre>
     *
     * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
     */
    public Builder clearIndexConfigs() {
      if (indexConfigsBuilder_ == null) {
        indexConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        indexConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of indexed fields and related configuration data.
     * </pre>
     *
     * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
     */
    public Builder removeIndexConfigs(int index) {
      if (indexConfigsBuilder_ == null) {
        ensureIndexConfigsIsMutable();
        indexConfigs_.remove(index);
        onChanged();
      } else {
        indexConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of indexed fields and related configuration data.
     * </pre>
     *
     * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
     */
    public com.google.logging.v2.IndexConfig.Builder getIndexConfigsBuilder(int index) {
      return getIndexConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of indexed fields and related configuration data.
     * </pre>
     *
     * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
     */
    public com.google.logging.v2.IndexConfigOrBuilder getIndexConfigsOrBuilder(int index) {
      if (indexConfigsBuilder_ == null) {
        return indexConfigs_.get(index);
      } else {
        return indexConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of indexed fields and related configuration data.
     * </pre>
     *
     * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
     */
    public java.util.List<? extends com.google.logging.v2.IndexConfigOrBuilder>
        getIndexConfigsOrBuilderList() {
      if (indexConfigsBuilder_ != null) {
        return indexConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(indexConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of indexed fields and related configuration data.
     * </pre>
     *
     * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
     */
    public com.google.logging.v2.IndexConfig.Builder addIndexConfigsBuilder() {
      return getIndexConfigsFieldBuilder()
          .addBuilder(com.google.logging.v2.IndexConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of indexed fields and related configuration data.
     * </pre>
     *
     * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
     */
    public com.google.logging.v2.IndexConfig.Builder addIndexConfigsBuilder(int index) {
      return getIndexConfigsFieldBuilder()
          .addBuilder(index, com.google.logging.v2.IndexConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of indexed fields and related configuration data.
     * </pre>
     *
     * <code>repeated .google.logging.v2.IndexConfig index_configs = 17;</code>
     */
    public java.util.List<com.google.logging.v2.IndexConfig.Builder> getIndexConfigsBuilderList() {
      return getIndexConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.logging.v2.IndexConfig,
            com.google.logging.v2.IndexConfig.Builder,
            com.google.logging.v2.IndexConfigOrBuilder>
        getIndexConfigsFieldBuilder() {
      if (indexConfigsBuilder_ == null) {
        indexConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.logging.v2.IndexConfig,
                com.google.logging.v2.IndexConfig.Builder,
                com.google.logging.v2.IndexConfigOrBuilder>(
                indexConfigs_, ((bitField0_ & 0x00000200) != 0), getParentForChildren(), isClean());
        indexConfigs_ = null;
      }
      return indexConfigsBuilder_;
    }

    private com.google.logging.v2.CmekSettings cmekSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.v2.CmekSettings,
            com.google.logging.v2.CmekSettings.Builder,
            com.google.logging.v2.CmekSettingsOrBuilder>
        cmekSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * The CMEK settings of the log bucket. If present, new log entries written to
     * this log bucket are encrypted using the CMEK key provided in this
     * configuration. If a log bucket has CMEK settings, the CMEK settings cannot
     * be disabled later by updating the log bucket. Changing the KMS key is
     * allowed.
     * </pre>
     *
     * <code>.google.logging.v2.CmekSettings cmek_settings = 19;</code>
     *
     * @return Whether the cmekSettings field is set.
     */
    public boolean hasCmekSettings() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * The CMEK settings of the log bucket. If present, new log entries written to
     * this log bucket are encrypted using the CMEK key provided in this
     * configuration. If a log bucket has CMEK settings, the CMEK settings cannot
     * be disabled later by updating the log bucket. Changing the KMS key is
     * allowed.
     * </pre>
     *
     * <code>.google.logging.v2.CmekSettings cmek_settings = 19;</code>
     *
     * @return The cmekSettings.
     */
    public com.google.logging.v2.CmekSettings getCmekSettings() {
      if (cmekSettingsBuilder_ == null) {
        return cmekSettings_ == null
            ? com.google.logging.v2.CmekSettings.getDefaultInstance()
            : cmekSettings_;
      } else {
        return cmekSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The CMEK settings of the log bucket. If present, new log entries written to
     * this log bucket are encrypted using the CMEK key provided in this
     * configuration. If a log bucket has CMEK settings, the CMEK settings cannot
     * be disabled later by updating the log bucket. Changing the KMS key is
     * allowed.
     * </pre>
     *
     * <code>.google.logging.v2.CmekSettings cmek_settings = 19;</code>
     */
    public Builder setCmekSettings(com.google.logging.v2.CmekSettings value) {
      if (cmekSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cmekSettings_ = value;
      } else {
        cmekSettingsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CMEK settings of the log bucket. If present, new log entries written to
     * this log bucket are encrypted using the CMEK key provided in this
     * configuration. If a log bucket has CMEK settings, the CMEK settings cannot
     * be disabled later by updating the log bucket. Changing the KMS key is
     * allowed.
     * </pre>
     *
     * <code>.google.logging.v2.CmekSettings cmek_settings = 19;</code>
     */
    public Builder setCmekSettings(com.google.logging.v2.CmekSettings.Builder builderForValue) {
      if (cmekSettingsBuilder_ == null) {
        cmekSettings_ = builderForValue.build();
      } else {
        cmekSettingsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CMEK settings of the log bucket. If present, new log entries written to
     * this log bucket are encrypted using the CMEK key provided in this
     * configuration. If a log bucket has CMEK settings, the CMEK settings cannot
     * be disabled later by updating the log bucket. Changing the KMS key is
     * allowed.
     * </pre>
     *
     * <code>.google.logging.v2.CmekSettings cmek_settings = 19;</code>
     */
    public Builder mergeCmekSettings(com.google.logging.v2.CmekSettings value) {
      if (cmekSettingsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && cmekSettings_ != null
            && cmekSettings_ != com.google.logging.v2.CmekSettings.getDefaultInstance()) {
          getCmekSettingsBuilder().mergeFrom(value);
        } else {
          cmekSettings_ = value;
        }
      } else {
        cmekSettingsBuilder_.mergeFrom(value);
      }
      if (cmekSettings_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CMEK settings of the log bucket. If present, new log entries written to
     * this log bucket are encrypted using the CMEK key provided in this
     * configuration. If a log bucket has CMEK settings, the CMEK settings cannot
     * be disabled later by updating the log bucket. Changing the KMS key is
     * allowed.
     * </pre>
     *
     * <code>.google.logging.v2.CmekSettings cmek_settings = 19;</code>
     */
    public Builder clearCmekSettings() {
      bitField0_ = (bitField0_ & ~0x00000400);
      cmekSettings_ = null;
      if (cmekSettingsBuilder_ != null) {
        cmekSettingsBuilder_.dispose();
        cmekSettingsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The CMEK settings of the log bucket. If present, new log entries written to
     * this log bucket are encrypted using the CMEK key provided in this
     * configuration. If a log bucket has CMEK settings, the CMEK settings cannot
     * be disabled later by updating the log bucket. Changing the KMS key is
     * allowed.
     * </pre>
     *
     * <code>.google.logging.v2.CmekSettings cmek_settings = 19;</code>
     */
    public com.google.logging.v2.CmekSettings.Builder getCmekSettingsBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getCmekSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The CMEK settings of the log bucket. If present, new log entries written to
     * this log bucket are encrypted using the CMEK key provided in this
     * configuration. If a log bucket has CMEK settings, the CMEK settings cannot
     * be disabled later by updating the log bucket. Changing the KMS key is
     * allowed.
     * </pre>
     *
     * <code>.google.logging.v2.CmekSettings cmek_settings = 19;</code>
     */
    public com.google.logging.v2.CmekSettingsOrBuilder getCmekSettingsOrBuilder() {
      if (cmekSettingsBuilder_ != null) {
        return cmekSettingsBuilder_.getMessageOrBuilder();
      } else {
        return cmekSettings_ == null
            ? com.google.logging.v2.CmekSettings.getDefaultInstance()
            : cmekSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * The CMEK settings of the log bucket. If present, new log entries written to
     * this log bucket are encrypted using the CMEK key provided in this
     * configuration. If a log bucket has CMEK settings, the CMEK settings cannot
     * be disabled later by updating the log bucket. Changing the KMS key is
     * allowed.
     * </pre>
     *
     * <code>.google.logging.v2.CmekSettings cmek_settings = 19;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.logging.v2.CmekSettings,
            com.google.logging.v2.CmekSettings.Builder,
            com.google.logging.v2.CmekSettingsOrBuilder>
        getCmekSettingsFieldBuilder() {
      if (cmekSettingsBuilder_ == null) {
        cmekSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.logging.v2.CmekSettings,
                com.google.logging.v2.CmekSettings.Builder,
                com.google.logging.v2.CmekSettingsOrBuilder>(
                getCmekSettings(), getParentForChildren(), isClean());
        cmekSettings_ = null;
      }
      return cmekSettingsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.logging.v2.LogBucket)
  }

  // @@protoc_insertion_point(class_scope:google.logging.v2.LogBucket)
  private static final com.google.logging.v2.LogBucket DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.logging.v2.LogBucket();
  }

  public static com.google.logging.v2.LogBucket getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LogBucket> PARSER =
      new com.google.protobuf.AbstractParser<LogBucket>() {
        @java.lang.Override
        public LogBucket parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LogBucket> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LogBucket> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.logging.v2.LogBucket getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
