/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BillingAccountName
implements ResourceName {
    private static final PathTemplate BILLING_ACCOUNT = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}");
    private volatile Map<String, String> fieldValuesMap;
    private final String billingAccount;

    @Deprecated
    protected BillingAccountName() {
        this.billingAccount = null;
    }

    private BillingAccountName(Builder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BillingAccountName of(String billingAccount) {
        return BillingAccountName.newBuilder().setBillingAccount(billingAccount).build();
    }

    public static String format(String billingAccount) {
        return BillingAccountName.newBuilder().setBillingAccount(billingAccount).build().toString();
    }

    public static BillingAccountName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = BILLING_ACCOUNT.validatedMatch(formattedString, "BillingAccountName.parse: formattedString not in valid format");
        return BillingAccountName.of((String)matchMap.get("billing_account"));
    }

    public static List<BillingAccountName> parseList(List<String> formattedStrings) {
        ArrayList<BillingAccountName> list = new ArrayList<BillingAccountName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BillingAccountName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BillingAccountName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BillingAccountName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return BILLING_ACCOUNT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BillingAccountName billingAccountName = this;
            synchronized (billingAccountName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put((Object)"billing_account", (Object)this.billingAccount);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return BILLING_ACCOUNT.instantiate(new String[]{"billing_account", this.billingAccount});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BillingAccountName that = (BillingAccountName)o;
            return Objects.equals(this.billingAccount, that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingAccount);
    }

    public static class Builder {
        private String billingAccount;

        protected Builder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public Builder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        private Builder(BillingAccountName billingAccountName) {
            this.billingAccount = billingAccountName.billingAccount;
        }

        public BillingAccountName build() {
            return new BillingAccountName(this);
        }
    }
}

