/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/logging/v2/logging_config.proto

// Protobuf Java Version: 3.25.5
package com.google.logging.v2;

public interface UpdateBucketRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.logging.v2.UpdateBucketRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The full resource name of the bucket to update.
   *
   *     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
   *     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
   *     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
   *     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
   *
   * For example:
   *
   *   `"projects/my-project/locations/global/buckets/my-bucket"`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Required. The full resource name of the bucket to update.
   *
   *     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
   *     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
   *     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
   *     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
   *
   * For example:
   *
   *   `"projects/my-project/locations/global/buckets/my-bucket"`
   * </pre>
   *
   * <code>
   * string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The updated bucket.
   * </pre>
   *
   * <code>.google.logging.v2.LogBucket bucket = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the bucket field is set.
   */
  boolean hasBucket();

  /**
   *
   *
   * <pre>
   * Required. The updated bucket.
   * </pre>
   *
   * <code>.google.logging.v2.LogBucket bucket = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bucket.
   */
  com.google.logging.v2.LogBucket getBucket();

  /**
   *
   *
   * <pre>
   * Required. The updated bucket.
   * </pre>
   *
   * <code>.google.logging.v2.LogBucket bucket = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  com.google.logging.v2.LogBucketOrBuilder getBucketOrBuilder();

  /**
   *
   *
   * <pre>
   * Required. Field mask that specifies the fields in `bucket` that need an
   * update. A bucket field will be overwritten if, and only if, it is in the
   * update mask. `name` and output only fields cannot be updated.
   *
   * For a detailed `FieldMask` definition, see:
   * https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMask
   *
   * For example: `updateMask=retention_days`
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the updateMask field is set.
   */
  boolean hasUpdateMask();

  /**
   *
   *
   * <pre>
   * Required. Field mask that specifies the fields in `bucket` that need an
   * update. A bucket field will be overwritten if, and only if, it is in the
   * update mask. `name` and output only fields cannot be updated.
   *
   * For a detailed `FieldMask` definition, see:
   * https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMask
   *
   * For example: `updateMask=retention_days`
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The updateMask.
   */
  com.google.protobuf.FieldMask getUpdateMask();

  /**
   *
   *
   * <pre>
   * Required. Field mask that specifies the fields in `bucket` that need an
   * update. A bucket field will be overwritten if, and only if, it is in the
   * update mask. `name` and output only fields cannot be updated.
   *
   * For a detailed `FieldMask` definition, see:
   * https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMask
   *
   * For example: `updateMask=retention_days`
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder();
}
