/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/logging/v2/logging.proto

// Protobuf Java Version: 3.25.8
package com.google.logging.v2;

/**
 *
 *
 * <pre>
 * Result returned from `TailLogEntries`.
 * </pre>
 *
 * Protobuf type {@code google.logging.v2.TailLogEntriesResponse}
 */
public final class TailLogEntriesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.logging.v2.TailLogEntriesResponse)
    TailLogEntriesResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use TailLogEntriesResponse.newBuilder() to construct.
  private TailLogEntriesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TailLogEntriesResponse() {
    entries_ = java.util.Collections.emptyList();
    suppressionInfo_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TailLogEntriesResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.logging.v2.LoggingProto
        .internal_static_google_logging_v2_TailLogEntriesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.logging.v2.LoggingProto
        .internal_static_google_logging_v2_TailLogEntriesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.logging.v2.TailLogEntriesResponse.class,
            com.google.logging.v2.TailLogEntriesResponse.Builder.class);
  }

  public interface SuppressionInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.logging.v2.TailLogEntriesResponse.SuppressionInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The reason that entries were omitted from the session.
     * </pre>
     *
     * <code>.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason reason = 1;</code>
     *
     * @return The enum numeric value on the wire for reason.
     */
    int getReasonValue();

    /**
     *
     *
     * <pre>
     * The reason that entries were omitted from the session.
     * </pre>
     *
     * <code>.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason reason = 1;</code>
     *
     * @return The reason.
     */
    com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason getReason();

    /**
     *
     *
     * <pre>
     * A lower bound on the count of entries omitted due to `reason`.
     * </pre>
     *
     * <code>int32 suppressed_count = 2;</code>
     *
     * @return The suppressedCount.
     */
    int getSuppressedCount();
  }

  /**
   *
   *
   * <pre>
   * Information about entries that were omitted from the session.
   * </pre>
   *
   * Protobuf type {@code google.logging.v2.TailLogEntriesResponse.SuppressionInfo}
   */
  public static final class SuppressionInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.logging.v2.TailLogEntriesResponse.SuppressionInfo)
      SuppressionInfoOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use SuppressionInfo.newBuilder() to construct.
    private SuppressionInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SuppressionInfo() {
      reason_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SuppressionInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.logging.v2.LoggingProto
          .internal_static_google_logging_v2_TailLogEntriesResponse_SuppressionInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.logging.v2.LoggingProto
          .internal_static_google_logging_v2_TailLogEntriesResponse_SuppressionInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.class,
              com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * An indicator of why entries were omitted.
     * </pre>
     *
     * Protobuf enum {@code google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason}
     */
    public enum Reason implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unexpected default.
       * </pre>
       *
       * <code>REASON_UNSPECIFIED = 0;</code>
       */
      REASON_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Indicates suppression occurred due to relevant entries being
       * received in excess of rate limits. For quotas and limits, see
       * [Logging API quotas and
       * limits](https://cloud.google.com/logging/quotas#api-limits).
       * </pre>
       *
       * <code>RATE_LIMIT = 1;</code>
       */
      RATE_LIMIT(1),
      /**
       *
       *
       * <pre>
       * Indicates suppression occurred due to the client not consuming
       * responses quickly enough.
       * </pre>
       *
       * <code>NOT_CONSUMED = 2;</code>
       */
      NOT_CONSUMED(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unexpected default.
       * </pre>
       *
       * <code>REASON_UNSPECIFIED = 0;</code>
       */
      public static final int REASON_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Indicates suppression occurred due to relevant entries being
       * received in excess of rate limits. For quotas and limits, see
       * [Logging API quotas and
       * limits](https://cloud.google.com/logging/quotas#api-limits).
       * </pre>
       *
       * <code>RATE_LIMIT = 1;</code>
       */
      public static final int RATE_LIMIT_VALUE = 1;

      /**
       *
       *
       * <pre>
       * Indicates suppression occurred due to the client not consuming
       * responses quickly enough.
       * </pre>
       *
       * <code>NOT_CONSUMED = 2;</code>
       */
      public static final int NOT_CONSUMED_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Reason valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Reason forNumber(int value) {
        switch (value) {
          case 0:
            return REASON_UNSPECIFIED;
          case 1:
            return RATE_LIMIT;
          case 2:
            return NOT_CONSUMED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Reason> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Reason> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Reason>() {
            public Reason findValueByNumber(int number) {
              return Reason.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Reason[] VALUES = values();

      public static Reason valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Reason(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason)
    }

    public static final int REASON_FIELD_NUMBER = 1;
    private int reason_ = 0;

    /**
     *
     *
     * <pre>
     * The reason that entries were omitted from the session.
     * </pre>
     *
     * <code>.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason reason = 1;</code>
     *
     * @return The enum numeric value on the wire for reason.
     */
    @java.lang.Override
    public int getReasonValue() {
      return reason_;
    }

    /**
     *
     *
     * <pre>
     * The reason that entries were omitted from the session.
     * </pre>
     *
     * <code>.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason reason = 1;</code>
     *
     * @return The reason.
     */
    @java.lang.Override
    public com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason getReason() {
      com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason result =
          com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason.forNumber(reason_);
      return result == null
          ? com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason.UNRECOGNIZED
          : result;
    }

    public static final int SUPPRESSED_COUNT_FIELD_NUMBER = 2;
    private int suppressedCount_ = 0;

    /**
     *
     *
     * <pre>
     * A lower bound on the count of entries omitted due to `reason`.
     * </pre>
     *
     * <code>int32 suppressed_count = 2;</code>
     *
     * @return The suppressedCount.
     */
    @java.lang.Override
    public int getSuppressedCount() {
      return suppressedCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (reason_
          != com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason.REASON_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, reason_);
      }
      if (suppressedCount_ != 0) {
        output.writeInt32(2, suppressedCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (reason_
          != com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason.REASON_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, reason_);
      }
      if (suppressedCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, suppressedCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo)) {
        return super.equals(obj);
      }
      com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo other =
          (com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo) obj;

      if (reason_ != other.reason_) return false;
      if (getSuppressedCount() != other.getSuppressedCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + REASON_FIELD_NUMBER;
      hash = (53 * hash) + reason_;
      hash = (37 * hash) + SUPPRESSED_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getSuppressedCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Information about entries that were omitted from the session.
     * </pre>
     *
     * Protobuf type {@code google.logging.v2.TailLogEntriesResponse.SuppressionInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.logging.v2.TailLogEntriesResponse.SuppressionInfo)
        com.google.logging.v2.TailLogEntriesResponse.SuppressionInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.logging.v2.LoggingProto
            .internal_static_google_logging_v2_TailLogEntriesResponse_SuppressionInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.logging.v2.LoggingProto
            .internal_static_google_logging_v2_TailLogEntriesResponse_SuppressionInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.class,
                com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Builder.class);
      }

      // Construct using com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        reason_ = 0;
        suppressedCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.logging.v2.LoggingProto
            .internal_static_google_logging_v2_TailLogEntriesResponse_SuppressionInfo_descriptor;
      }

      @java.lang.Override
      public com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo
          getDefaultInstanceForType() {
        return com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo build() {
        com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo buildPartial() {
        com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo result =
            new com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.reason_ = reason_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.suppressedCount_ = suppressedCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo) {
          return mergeFrom((com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo other) {
        if (other
            == com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.getDefaultInstance())
          return this;
        if (other.reason_ != 0) {
          setReasonValue(other.getReasonValue());
        }
        if (other.getSuppressedCount() != 0) {
          setSuppressedCount(other.getSuppressedCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  reason_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  suppressedCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int reason_ = 0;

      /**
       *
       *
       * <pre>
       * The reason that entries were omitted from the session.
       * </pre>
       *
       * <code>.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason reason = 1;</code>
       *
       * @return The enum numeric value on the wire for reason.
       */
      @java.lang.Override
      public int getReasonValue() {
        return reason_;
      }

      /**
       *
       *
       * <pre>
       * The reason that entries were omitted from the session.
       * </pre>
       *
       * <code>.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason reason = 1;</code>
       *
       * @param value The enum numeric value on the wire for reason to set.
       * @return This builder for chaining.
       */
      public Builder setReasonValue(int value) {
        reason_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The reason that entries were omitted from the session.
       * </pre>
       *
       * <code>.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason reason = 1;</code>
       *
       * @return The reason.
       */
      @java.lang.Override
      public com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason getReason() {
        com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason result =
            com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason.forNumber(reason_);
        return result == null
            ? com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The reason that entries were omitted from the session.
       * </pre>
       *
       * <code>.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason reason = 1;</code>
       *
       * @param value The reason to set.
       * @return This builder for chaining.
       */
      public Builder setReason(
          com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        reason_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The reason that entries were omitted from the session.
       * </pre>
       *
       * <code>.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Reason reason = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearReason() {
        bitField0_ = (bitField0_ & ~0x00000001);
        reason_ = 0;
        onChanged();
        return this;
      }

      private int suppressedCount_;

      /**
       *
       *
       * <pre>
       * A lower bound on the count of entries omitted due to `reason`.
       * </pre>
       *
       * <code>int32 suppressed_count = 2;</code>
       *
       * @return The suppressedCount.
       */
      @java.lang.Override
      public int getSuppressedCount() {
        return suppressedCount_;
      }

      /**
       *
       *
       * <pre>
       * A lower bound on the count of entries omitted due to `reason`.
       * </pre>
       *
       * <code>int32 suppressed_count = 2;</code>
       *
       * @param value The suppressedCount to set.
       * @return This builder for chaining.
       */
      public Builder setSuppressedCount(int value) {

        suppressedCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A lower bound on the count of entries omitted due to `reason`.
       * </pre>
       *
       * <code>int32 suppressed_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSuppressedCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        suppressedCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.logging.v2.TailLogEntriesResponse.SuppressionInfo)
    }

    // @@protoc_insertion_point(class_scope:google.logging.v2.TailLogEntriesResponse.SuppressionInfo)
    private static final com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo();
    }

    public static com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SuppressionInfo> PARSER =
        new com.google.protobuf.AbstractParser<SuppressionInfo>() {
          @java.lang.Override
          public SuppressionInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SuppressionInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SuppressionInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ENTRIES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.logging.v2.LogEntry> entries_;

  /**
   *
   *
   * <pre>
   * A list of log entries. Each response in the stream will order entries with
   * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
   * between separate responses.
   * </pre>
   *
   * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.logging.v2.LogEntry> getEntriesList() {
    return entries_;
  }

  /**
   *
   *
   * <pre>
   * A list of log entries. Each response in the stream will order entries with
   * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
   * between separate responses.
   * </pre>
   *
   * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.logging.v2.LogEntryOrBuilder>
      getEntriesOrBuilderList() {
    return entries_;
  }

  /**
   *
   *
   * <pre>
   * A list of log entries. Each response in the stream will order entries with
   * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
   * between separate responses.
   * </pre>
   *
   * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
   */
  @java.lang.Override
  public int getEntriesCount() {
    return entries_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of log entries. Each response in the stream will order entries with
   * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
   * between separate responses.
   * </pre>
   *
   * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
   */
  @java.lang.Override
  public com.google.logging.v2.LogEntry getEntries(int index) {
    return entries_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of log entries. Each response in the stream will order entries with
   * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
   * between separate responses.
   * </pre>
   *
   * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
   */
  @java.lang.Override
  public com.google.logging.v2.LogEntryOrBuilder getEntriesOrBuilder(int index) {
    return entries_.get(index);
  }

  public static final int SUPPRESSION_INFO_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo>
      suppressionInfo_;

  /**
   *
   *
   * <pre>
   * If entries that otherwise would have been included in the session were not
   * sent back to the client, counts of relevant entries omitted from the
   * session with the reason that they were not included. There will be at most
   * one of each reason per response. The counts represent the number of
   * suppressed entries since the last streamed response.
   * </pre>
   *
   * <code>repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo>
      getSuppressionInfoList() {
    return suppressionInfo_;
  }

  /**
   *
   *
   * <pre>
   * If entries that otherwise would have been included in the session were not
   * sent back to the client, counts of relevant entries omitted from the
   * session with the reason that they were not included. There will be at most
   * one of each reason per response. The counts represent the number of
   * suppressed entries since the last streamed response.
   * </pre>
   *
   * <code>repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.logging.v2.TailLogEntriesResponse.SuppressionInfoOrBuilder>
      getSuppressionInfoOrBuilderList() {
    return suppressionInfo_;
  }

  /**
   *
   *
   * <pre>
   * If entries that otherwise would have been included in the session were not
   * sent back to the client, counts of relevant entries omitted from the
   * session with the reason that they were not included. There will be at most
   * one of each reason per response. The counts represent the number of
   * suppressed entries since the last streamed response.
   * </pre>
   *
   * <code>repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
   * </code>
   */
  @java.lang.Override
  public int getSuppressionInfoCount() {
    return suppressionInfo_.size();
  }

  /**
   *
   *
   * <pre>
   * If entries that otherwise would have been included in the session were not
   * sent back to the client, counts of relevant entries omitted from the
   * session with the reason that they were not included. There will be at most
   * one of each reason per response. The counts represent the number of
   * suppressed entries since the last streamed response.
   * </pre>
   *
   * <code>repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo getSuppressionInfo(
      int index) {
    return suppressionInfo_.get(index);
  }

  /**
   *
   *
   * <pre>
   * If entries that otherwise would have been included in the session were not
   * sent back to the client, counts of relevant entries omitted from the
   * session with the reason that they were not included. There will be at most
   * one of each reason per response. The counts represent the number of
   * suppressed entries since the last streamed response.
   * </pre>
   *
   * <code>repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.logging.v2.TailLogEntriesResponse.SuppressionInfoOrBuilder
      getSuppressionInfoOrBuilder(int index) {
    return suppressionInfo_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < entries_.size(); i++) {
      output.writeMessage(1, entries_.get(i));
    }
    for (int i = 0; i < suppressionInfo_.size(); i++) {
      output.writeMessage(2, suppressionInfo_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < entries_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, entries_.get(i));
    }
    for (int i = 0; i < suppressionInfo_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, suppressionInfo_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.logging.v2.TailLogEntriesResponse)) {
      return super.equals(obj);
    }
    com.google.logging.v2.TailLogEntriesResponse other =
        (com.google.logging.v2.TailLogEntriesResponse) obj;

    if (!getEntriesList().equals(other.getEntriesList())) return false;
    if (!getSuppressionInfoList().equals(other.getSuppressionInfoList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getEntriesCount() > 0) {
      hash = (37 * hash) + ENTRIES_FIELD_NUMBER;
      hash = (53 * hash) + getEntriesList().hashCode();
    }
    if (getSuppressionInfoCount() > 0) {
      hash = (37 * hash) + SUPPRESSION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getSuppressionInfoList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.logging.v2.TailLogEntriesResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.TailLogEntriesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.TailLogEntriesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.TailLogEntriesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.TailLogEntriesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.logging.v2.TailLogEntriesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.logging.v2.TailLogEntriesResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.TailLogEntriesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.TailLogEntriesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.TailLogEntriesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.logging.v2.TailLogEntriesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.logging.v2.TailLogEntriesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.logging.v2.TailLogEntriesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Result returned from `TailLogEntries`.
   * </pre>
   *
   * Protobuf type {@code google.logging.v2.TailLogEntriesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.logging.v2.TailLogEntriesResponse)
      com.google.logging.v2.TailLogEntriesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.logging.v2.LoggingProto
          .internal_static_google_logging_v2_TailLogEntriesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.logging.v2.LoggingProto
          .internal_static_google_logging_v2_TailLogEntriesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.logging.v2.TailLogEntriesResponse.class,
              com.google.logging.v2.TailLogEntriesResponse.Builder.class);
    }

    // Construct using com.google.logging.v2.TailLogEntriesResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (entriesBuilder_ == null) {
        entries_ = java.util.Collections.emptyList();
      } else {
        entries_ = null;
        entriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (suppressionInfoBuilder_ == null) {
        suppressionInfo_ = java.util.Collections.emptyList();
      } else {
        suppressionInfo_ = null;
        suppressionInfoBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.logging.v2.LoggingProto
          .internal_static_google_logging_v2_TailLogEntriesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.logging.v2.TailLogEntriesResponse getDefaultInstanceForType() {
      return com.google.logging.v2.TailLogEntriesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.logging.v2.TailLogEntriesResponse build() {
      com.google.logging.v2.TailLogEntriesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.logging.v2.TailLogEntriesResponse buildPartial() {
      com.google.logging.v2.TailLogEntriesResponse result =
          new com.google.logging.v2.TailLogEntriesResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.logging.v2.TailLogEntriesResponse result) {
      if (entriesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          entries_ = java.util.Collections.unmodifiableList(entries_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.entries_ = entries_;
      } else {
        result.entries_ = entriesBuilder_.build();
      }
      if (suppressionInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          suppressionInfo_ = java.util.Collections.unmodifiableList(suppressionInfo_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.suppressionInfo_ = suppressionInfo_;
      } else {
        result.suppressionInfo_ = suppressionInfoBuilder_.build();
      }
    }

    private void buildPartial0(com.google.logging.v2.TailLogEntriesResponse result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.logging.v2.TailLogEntriesResponse) {
        return mergeFrom((com.google.logging.v2.TailLogEntriesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.logging.v2.TailLogEntriesResponse other) {
      if (other == com.google.logging.v2.TailLogEntriesResponse.getDefaultInstance()) return this;
      if (entriesBuilder_ == null) {
        if (!other.entries_.isEmpty()) {
          if (entries_.isEmpty()) {
            entries_ = other.entries_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureEntriesIsMutable();
            entries_.addAll(other.entries_);
          }
          onChanged();
        }
      } else {
        if (!other.entries_.isEmpty()) {
          if (entriesBuilder_.isEmpty()) {
            entriesBuilder_.dispose();
            entriesBuilder_ = null;
            entries_ = other.entries_;
            bitField0_ = (bitField0_ & ~0x00000001);
            entriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEntriesFieldBuilder()
                    : null;
          } else {
            entriesBuilder_.addAllMessages(other.entries_);
          }
        }
      }
      if (suppressionInfoBuilder_ == null) {
        if (!other.suppressionInfo_.isEmpty()) {
          if (suppressionInfo_.isEmpty()) {
            suppressionInfo_ = other.suppressionInfo_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSuppressionInfoIsMutable();
            suppressionInfo_.addAll(other.suppressionInfo_);
          }
          onChanged();
        }
      } else {
        if (!other.suppressionInfo_.isEmpty()) {
          if (suppressionInfoBuilder_.isEmpty()) {
            suppressionInfoBuilder_.dispose();
            suppressionInfoBuilder_ = null;
            suppressionInfo_ = other.suppressionInfo_;
            bitField0_ = (bitField0_ & ~0x00000002);
            suppressionInfoBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSuppressionInfoFieldBuilder()
                    : null;
          } else {
            suppressionInfoBuilder_.addAllMessages(other.suppressionInfo_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.logging.v2.LogEntry m =
                    input.readMessage(com.google.logging.v2.LogEntry.parser(), extensionRegistry);
                if (entriesBuilder_ == null) {
                  ensureEntriesIsMutable();
                  entries_.add(m);
                } else {
                  entriesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo m =
                    input.readMessage(
                        com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.parser(),
                        extensionRegistry);
                if (suppressionInfoBuilder_ == null) {
                  ensureSuppressionInfoIsMutable();
                  suppressionInfo_.add(m);
                } else {
                  suppressionInfoBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.logging.v2.LogEntry> entries_ =
        java.util.Collections.emptyList();

    private void ensureEntriesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        entries_ = new java.util.ArrayList<com.google.logging.v2.LogEntry>(entries_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.logging.v2.LogEntry,
            com.google.logging.v2.LogEntry.Builder,
            com.google.logging.v2.LogEntryOrBuilder>
        entriesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of log entries. Each response in the stream will order entries with
     * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
     * between separate responses.
     * </pre>
     *
     * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
     */
    public java.util.List<com.google.logging.v2.LogEntry> getEntriesList() {
      if (entriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(entries_);
      } else {
        return entriesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of log entries. Each response in the stream will order entries with
     * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
     * between separate responses.
     * </pre>
     *
     * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
     */
    public int getEntriesCount() {
      if (entriesBuilder_ == null) {
        return entries_.size();
      } else {
        return entriesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of log entries. Each response in the stream will order entries with
     * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
     * between separate responses.
     * </pre>
     *
     * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
     */
    public com.google.logging.v2.LogEntry getEntries(int index) {
      if (entriesBuilder_ == null) {
        return entries_.get(index);
      } else {
        return entriesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of log entries. Each response in the stream will order entries with
     * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
     * between separate responses.
     * </pre>
     *
     * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
     */
    public Builder setEntries(int index, com.google.logging.v2.LogEntry value) {
      if (entriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntriesIsMutable();
        entries_.set(index, value);
        onChanged();
      } else {
        entriesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of log entries. Each response in the stream will order entries with
     * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
     * between separate responses.
     * </pre>
     *
     * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
     */
    public Builder setEntries(int index, com.google.logging.v2.LogEntry.Builder builderForValue) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        entries_.set(index, builderForValue.build());
        onChanged();
      } else {
        entriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of log entries. Each response in the stream will order entries with
     * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
     * between separate responses.
     * </pre>
     *
     * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
     */
    public Builder addEntries(com.google.logging.v2.LogEntry value) {
      if (entriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntriesIsMutable();
        entries_.add(value);
        onChanged();
      } else {
        entriesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of log entries. Each response in the stream will order entries with
     * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
     * between separate responses.
     * </pre>
     *
     * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
     */
    public Builder addEntries(int index, com.google.logging.v2.LogEntry value) {
      if (entriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntriesIsMutable();
        entries_.add(index, value);
        onChanged();
      } else {
        entriesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of log entries. Each response in the stream will order entries with
     * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
     * between separate responses.
     * </pre>
     *
     * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
     */
    public Builder addEntries(com.google.logging.v2.LogEntry.Builder builderForValue) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        entries_.add(builderForValue.build());
        onChanged();
      } else {
        entriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of log entries. Each response in the stream will order entries with
     * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
     * between separate responses.
     * </pre>
     *
     * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
     */
    public Builder addEntries(int index, com.google.logging.v2.LogEntry.Builder builderForValue) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        entries_.add(index, builderForValue.build());
        onChanged();
      } else {
        entriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of log entries. Each response in the stream will order entries with
     * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
     * between separate responses.
     * </pre>
     *
     * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
     */
    public Builder addAllEntries(
        java.lang.Iterable<? extends com.google.logging.v2.LogEntry> values) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, entries_);
        onChanged();
      } else {
        entriesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of log entries. Each response in the stream will order entries with
     * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
     * between separate responses.
     * </pre>
     *
     * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
     */
    public Builder clearEntries() {
      if (entriesBuilder_ == null) {
        entries_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        entriesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of log entries. Each response in the stream will order entries with
     * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
     * between separate responses.
     * </pre>
     *
     * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
     */
    public Builder removeEntries(int index) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        entries_.remove(index);
        onChanged();
      } else {
        entriesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of log entries. Each response in the stream will order entries with
     * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
     * between separate responses.
     * </pre>
     *
     * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
     */
    public com.google.logging.v2.LogEntry.Builder getEntriesBuilder(int index) {
      return getEntriesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of log entries. Each response in the stream will order entries with
     * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
     * between separate responses.
     * </pre>
     *
     * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
     */
    public com.google.logging.v2.LogEntryOrBuilder getEntriesOrBuilder(int index) {
      if (entriesBuilder_ == null) {
        return entries_.get(index);
      } else {
        return entriesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of log entries. Each response in the stream will order entries with
     * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
     * between separate responses.
     * </pre>
     *
     * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
     */
    public java.util.List<? extends com.google.logging.v2.LogEntryOrBuilder>
        getEntriesOrBuilderList() {
      if (entriesBuilder_ != null) {
        return entriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(entries_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of log entries. Each response in the stream will order entries with
     * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
     * between separate responses.
     * </pre>
     *
     * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
     */
    public com.google.logging.v2.LogEntry.Builder addEntriesBuilder() {
      return getEntriesFieldBuilder()
          .addBuilder(com.google.logging.v2.LogEntry.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of log entries. Each response in the stream will order entries with
     * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
     * between separate responses.
     * </pre>
     *
     * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
     */
    public com.google.logging.v2.LogEntry.Builder addEntriesBuilder(int index) {
      return getEntriesFieldBuilder()
          .addBuilder(index, com.google.logging.v2.LogEntry.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of log entries. Each response in the stream will order entries with
     * increasing values of `LogEntry.timestamp`. Ordering is not guaranteed
     * between separate responses.
     * </pre>
     *
     * <code>repeated .google.logging.v2.LogEntry entries = 1;</code>
     */
    public java.util.List<com.google.logging.v2.LogEntry.Builder> getEntriesBuilderList() {
      return getEntriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.logging.v2.LogEntry,
            com.google.logging.v2.LogEntry.Builder,
            com.google.logging.v2.LogEntryOrBuilder>
        getEntriesFieldBuilder() {
      if (entriesBuilder_ == null) {
        entriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.logging.v2.LogEntry,
                com.google.logging.v2.LogEntry.Builder,
                com.google.logging.v2.LogEntryOrBuilder>(
                entries_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        entries_ = null;
      }
      return entriesBuilder_;
    }

    private java.util.List<com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo>
        suppressionInfo_ = java.util.Collections.emptyList();

    private void ensureSuppressionInfoIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        suppressionInfo_ =
            new java.util.ArrayList<com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo>(
                suppressionInfo_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo,
            com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Builder,
            com.google.logging.v2.TailLogEntriesResponse.SuppressionInfoOrBuilder>
        suppressionInfoBuilder_;

    /**
     *
     *
     * <pre>
     * If entries that otherwise would have been included in the session were not
     * sent back to the client, counts of relevant entries omitted from the
     * session with the reason that they were not included. There will be at most
     * one of each reason per response. The counts represent the number of
     * suppressed entries since the last streamed response.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
     * </code>
     */
    public java.util.List<com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo>
        getSuppressionInfoList() {
      if (suppressionInfoBuilder_ == null) {
        return java.util.Collections.unmodifiableList(suppressionInfo_);
      } else {
        return suppressionInfoBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * If entries that otherwise would have been included in the session were not
     * sent back to the client, counts of relevant entries omitted from the
     * session with the reason that they were not included. There will be at most
     * one of each reason per response. The counts represent the number of
     * suppressed entries since the last streamed response.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
     * </code>
     */
    public int getSuppressionInfoCount() {
      if (suppressionInfoBuilder_ == null) {
        return suppressionInfo_.size();
      } else {
        return suppressionInfoBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * If entries that otherwise would have been included in the session were not
     * sent back to the client, counts of relevant entries omitted from the
     * session with the reason that they were not included. There will be at most
     * one of each reason per response. The counts represent the number of
     * suppressed entries since the last streamed response.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
     * </code>
     */
    public com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo getSuppressionInfo(
        int index) {
      if (suppressionInfoBuilder_ == null) {
        return suppressionInfo_.get(index);
      } else {
        return suppressionInfoBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * If entries that otherwise would have been included in the session were not
     * sent back to the client, counts of relevant entries omitted from the
     * session with the reason that they were not included. There will be at most
     * one of each reason per response. The counts represent the number of
     * suppressed entries since the last streamed response.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
     * </code>
     */
    public Builder setSuppressionInfo(
        int index, com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo value) {
      if (suppressionInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSuppressionInfoIsMutable();
        suppressionInfo_.set(index, value);
        onChanged();
      } else {
        suppressionInfoBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If entries that otherwise would have been included in the session were not
     * sent back to the client, counts of relevant entries omitted from the
     * session with the reason that they were not included. There will be at most
     * one of each reason per response. The counts represent the number of
     * suppressed entries since the last streamed response.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
     * </code>
     */
    public Builder setSuppressionInfo(
        int index,
        com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Builder builderForValue) {
      if (suppressionInfoBuilder_ == null) {
        ensureSuppressionInfoIsMutable();
        suppressionInfo_.set(index, builderForValue.build());
        onChanged();
      } else {
        suppressionInfoBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If entries that otherwise would have been included in the session were not
     * sent back to the client, counts of relevant entries omitted from the
     * session with the reason that they were not included. There will be at most
     * one of each reason per response. The counts represent the number of
     * suppressed entries since the last streamed response.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
     * </code>
     */
    public Builder addSuppressionInfo(
        com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo value) {
      if (suppressionInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSuppressionInfoIsMutable();
        suppressionInfo_.add(value);
        onChanged();
      } else {
        suppressionInfoBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If entries that otherwise would have been included in the session were not
     * sent back to the client, counts of relevant entries omitted from the
     * session with the reason that they were not included. There will be at most
     * one of each reason per response. The counts represent the number of
     * suppressed entries since the last streamed response.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
     * </code>
     */
    public Builder addSuppressionInfo(
        int index, com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo value) {
      if (suppressionInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSuppressionInfoIsMutable();
        suppressionInfo_.add(index, value);
        onChanged();
      } else {
        suppressionInfoBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If entries that otherwise would have been included in the session were not
     * sent back to the client, counts of relevant entries omitted from the
     * session with the reason that they were not included. There will be at most
     * one of each reason per response. The counts represent the number of
     * suppressed entries since the last streamed response.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
     * </code>
     */
    public Builder addSuppressionInfo(
        com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Builder builderForValue) {
      if (suppressionInfoBuilder_ == null) {
        ensureSuppressionInfoIsMutable();
        suppressionInfo_.add(builderForValue.build());
        onChanged();
      } else {
        suppressionInfoBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If entries that otherwise would have been included in the session were not
     * sent back to the client, counts of relevant entries omitted from the
     * session with the reason that they were not included. There will be at most
     * one of each reason per response. The counts represent the number of
     * suppressed entries since the last streamed response.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
     * </code>
     */
    public Builder addSuppressionInfo(
        int index,
        com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Builder builderForValue) {
      if (suppressionInfoBuilder_ == null) {
        ensureSuppressionInfoIsMutable();
        suppressionInfo_.add(index, builderForValue.build());
        onChanged();
      } else {
        suppressionInfoBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If entries that otherwise would have been included in the session were not
     * sent back to the client, counts of relevant entries omitted from the
     * session with the reason that they were not included. There will be at most
     * one of each reason per response. The counts represent the number of
     * suppressed entries since the last streamed response.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
     * </code>
     */
    public Builder addAllSuppressionInfo(
        java.lang.Iterable<? extends com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo>
            values) {
      if (suppressionInfoBuilder_ == null) {
        ensureSuppressionInfoIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, suppressionInfo_);
        onChanged();
      } else {
        suppressionInfoBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If entries that otherwise would have been included in the session were not
     * sent back to the client, counts of relevant entries omitted from the
     * session with the reason that they were not included. There will be at most
     * one of each reason per response. The counts represent the number of
     * suppressed entries since the last streamed response.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
     * </code>
     */
    public Builder clearSuppressionInfo() {
      if (suppressionInfoBuilder_ == null) {
        suppressionInfo_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        suppressionInfoBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If entries that otherwise would have been included in the session were not
     * sent back to the client, counts of relevant entries omitted from the
     * session with the reason that they were not included. There will be at most
     * one of each reason per response. The counts represent the number of
     * suppressed entries since the last streamed response.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
     * </code>
     */
    public Builder removeSuppressionInfo(int index) {
      if (suppressionInfoBuilder_ == null) {
        ensureSuppressionInfoIsMutable();
        suppressionInfo_.remove(index);
        onChanged();
      } else {
        suppressionInfoBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If entries that otherwise would have been included in the session were not
     * sent back to the client, counts of relevant entries omitted from the
     * session with the reason that they were not included. There will be at most
     * one of each reason per response. The counts represent the number of
     * suppressed entries since the last streamed response.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
     * </code>
     */
    public com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Builder
        getSuppressionInfoBuilder(int index) {
      return getSuppressionInfoFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * If entries that otherwise would have been included in the session were not
     * sent back to the client, counts of relevant entries omitted from the
     * session with the reason that they were not included. There will be at most
     * one of each reason per response. The counts represent the number of
     * suppressed entries since the last streamed response.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
     * </code>
     */
    public com.google.logging.v2.TailLogEntriesResponse.SuppressionInfoOrBuilder
        getSuppressionInfoOrBuilder(int index) {
      if (suppressionInfoBuilder_ == null) {
        return suppressionInfo_.get(index);
      } else {
        return suppressionInfoBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * If entries that otherwise would have been included in the session were not
     * sent back to the client, counts of relevant entries omitted from the
     * session with the reason that they were not included. There will be at most
     * one of each reason per response. The counts represent the number of
     * suppressed entries since the last streamed response.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.logging.v2.TailLogEntriesResponse.SuppressionInfoOrBuilder>
        getSuppressionInfoOrBuilderList() {
      if (suppressionInfoBuilder_ != null) {
        return suppressionInfoBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(suppressionInfo_);
      }
    }

    /**
     *
     *
     * <pre>
     * If entries that otherwise would have been included in the session were not
     * sent back to the client, counts of relevant entries omitted from the
     * session with the reason that they were not included. There will be at most
     * one of each reason per response. The counts represent the number of
     * suppressed entries since the last streamed response.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
     * </code>
     */
    public com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Builder
        addSuppressionInfoBuilder() {
      return getSuppressionInfoFieldBuilder()
          .addBuilder(
              com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * If entries that otherwise would have been included in the session were not
     * sent back to the client, counts of relevant entries omitted from the
     * session with the reason that they were not included. There will be at most
     * one of each reason per response. The counts represent the number of
     * suppressed entries since the last streamed response.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
     * </code>
     */
    public com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Builder
        addSuppressionInfoBuilder(int index) {
      return getSuppressionInfoFieldBuilder()
          .addBuilder(
              index,
              com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * If entries that otherwise would have been included in the session were not
     * sent back to the client, counts of relevant entries omitted from the
     * session with the reason that they were not included. There will be at most
     * one of each reason per response. The counts represent the number of
     * suppressed entries since the last streamed response.
     * </pre>
     *
     * <code>
     * repeated .google.logging.v2.TailLogEntriesResponse.SuppressionInfo suppression_info = 2;
     * </code>
     */
    public java.util.List<com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Builder>
        getSuppressionInfoBuilderList() {
      return getSuppressionInfoFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo,
            com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Builder,
            com.google.logging.v2.TailLogEntriesResponse.SuppressionInfoOrBuilder>
        getSuppressionInfoFieldBuilder() {
      if (suppressionInfoBuilder_ == null) {
        suppressionInfoBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo,
                com.google.logging.v2.TailLogEntriesResponse.SuppressionInfo.Builder,
                com.google.logging.v2.TailLogEntriesResponse.SuppressionInfoOrBuilder>(
                suppressionInfo_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        suppressionInfo_ = null;
      }
      return suppressionInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.logging.v2.TailLogEntriesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.logging.v2.TailLogEntriesResponse)
  private static final com.google.logging.v2.TailLogEntriesResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.logging.v2.TailLogEntriesResponse();
  }

  public static com.google.logging.v2.TailLogEntriesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TailLogEntriesResponse> PARSER =
      new com.google.protobuf.AbstractParser<TailLogEntriesResponse>() {
        @java.lang.Override
        public TailLogEntriesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TailLogEntriesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TailLogEntriesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.logging.v2.TailLogEntriesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
