/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.logging.v2.ExclusionName;
import java.util.ArrayList;
import java.util.List;

public class UntypedExclusionName
extends ExclusionName {
    private final String rawValue;

    private UntypedExclusionName(String rawValue) {
        this.rawValue = (String)Preconditions.checkNotNull((Object)rawValue);
    }

    public static UntypedExclusionName from(ResourceName resourceName) {
        return new UntypedExclusionName(resourceName.toString());
    }

    public static UntypedExclusionName parse(String formattedString) {
        return new UntypedExclusionName(formattedString);
    }

    public static List<UntypedExclusionName> parseList(List<String> formattedStrings) {
        ArrayList<UntypedExclusionName> list = new ArrayList<UntypedExclusionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UntypedExclusionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UntypedExclusionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UntypedExclusionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return true;
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("UntypedExclusionName.getType() not supported");
    }

    public String toString() {
        return this.rawValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UntypedExclusionName) {
            UntypedExclusionName that = (UntypedExclusionName)o;
            return this.rawValue.equals(that.rawValue);
        }
        return false;
    }

    public int hashCode() {
        return this.rawValue.hashCode();
    }
}

