/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.type;

import com.google.api.pathtemplate.PathTemplate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.logging.type.ExclusionName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FolderExclusionName
extends ExclusionName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/exclusions/{exclusion}");
    private volatile Map<String, String> fieldValuesMap;
    private final String folder;
    private final String exclusion;

    public String getFolder() {
        return this.folder;
    }

    public String getExclusion() {
        return this.exclusion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private FolderExclusionName(Builder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.exclusion = (String)Preconditions.checkNotNull((Object)builder.getExclusion());
    }

    public static FolderExclusionName of(String folder, String exclusion) {
        return FolderExclusionName.newBuilder().setFolder(folder).setExclusion(exclusion).build();
    }

    public static String format(String folder, String exclusion) {
        return FolderExclusionName.newBuilder().setFolder(folder).setExclusion(exclusion).build().toString();
    }

    public static FolderExclusionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "FolderExclusionName.parse: formattedString not in valid format");
        return FolderExclusionName.of((String)matchMap.get("folder"), (String)matchMap.get("exclusion"));
    }

    public static List<FolderExclusionName> parseList(List<String> formattedStrings) {
        ArrayList<FolderExclusionName> list = new ArrayList<FolderExclusionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FolderExclusionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FolderExclusionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FolderExclusionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FolderExclusionName folderExclusionName = this;
            synchronized (folderExclusionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    fieldMapBuilder.put((Object)"exclusion", (Object)this.exclusion);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"folder", this.folder, "exclusion", this.exclusion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FolderExclusionName) {
            FolderExclusionName that = (FolderExclusionName)o;
            return this.folder.equals(that.folder) && this.exclusion.equals(that.exclusion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.folder.hashCode();
        h *= 1000003;
        return h ^= this.exclusion.hashCode();
    }

    public static class Builder {
        private String folder;
        private String exclusion;

        public String getFolder() {
            return this.folder;
        }

        public String getExclusion() {
            return this.exclusion;
        }

        public Builder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public Builder setExclusion(String exclusion) {
            this.exclusion = exclusion;
            return this;
        }

        private Builder() {
        }

        private Builder(FolderExclusionName folderExclusionName) {
            this.folder = folderExclusionName.folder;
            this.exclusion = folderExclusionName.exclusion;
        }

        public FolderExclusionName build() {
            return new FolderExclusionName(this);
        }
    }
}

