/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.type;

import com.google.api.pathtemplate.PathTemplate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.logging.type.LogName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProjectLogName
extends LogName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/logs/{log}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String log;

    public String getProject() {
        return this.project;
    }

    public String getLog() {
        return this.log;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectLogName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.log = (String)Preconditions.checkNotNull((Object)builder.getLog());
    }

    public static ProjectLogName of(String project, String log) {
        return ProjectLogName.newBuilder().setProject(project).setLog(log).build();
    }

    public static String format(String project, String log) {
        return ProjectLogName.newBuilder().setProject(project).setLog(log).build().toString();
    }

    public static ProjectLogName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectLogName.parse: formattedString not in valid format");
        return ProjectLogName.of((String)matchMap.get("project"), (String)matchMap.get("log"));
    }

    public static List<ProjectLogName> parseList(List<String> formattedStrings) {
        ArrayList<ProjectLogName> list = new ArrayList<ProjectLogName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProjectLogName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProjectLogName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProjectLogName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectLogName projectLogName = this;
            synchronized (projectLogName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"log", (Object)this.log);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "log", this.log});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectLogName) {
            ProjectLogName that = (ProjectLogName)o;
            return this.project.equals(that.project) && this.log.equals(that.log);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.log.hashCode();
    }

    public static class Builder {
        private String project;
        private String log;

        public String getProject() {
            return this.project;
        }

        public String getLog() {
            return this.log;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLog(String log) {
            this.log = log;
            return this;
        }

        private Builder() {
        }

        private Builder(ProjectLogName projectLogName) {
            this.project = projectLogName.project;
            this.log = projectLogName.log;
        }

        public ProjectLogName build() {
            return new ProjectLogName(this);
        }
    }
}

