/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BillingAccountName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}");
    private volatile Map<String, String> fieldValuesMap;
    private final String billingAccount;

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private BillingAccountName(Builder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
    }

    public static BillingAccountName of(String billingAccount) {
        return BillingAccountName.newBuilder().setBillingAccount(billingAccount).build();
    }

    public static String format(String billingAccount) {
        return BillingAccountName.newBuilder().setBillingAccount(billingAccount).build().toString();
    }

    public static BillingAccountName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "BillingAccountName.parse: formattedString not in valid format");
        return BillingAccountName.of((String)matchMap.get("billing_account"));
    }

    public static List<BillingAccountName> parseList(List<String> formattedStrings) {
        ArrayList<BillingAccountName> list = new ArrayList<BillingAccountName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BillingAccountName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BillingAccountName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BillingAccountName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BillingAccountName billingAccountName = this;
            synchronized (billingAccountName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"billingAccount", (Object)this.billingAccount);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"billing_account", this.billingAccount});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BillingAccountName) {
            BillingAccountName that = (BillingAccountName)o;
            return this.billingAccount.equals(that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.billingAccount.hashCode();
    }

    public static class Builder {
        private String billingAccount;

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public Builder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        private Builder() {
        }

        private Builder(BillingAccountName billingAccountName) {
            this.billingAccount = billingAccountName.billingAccount;
        }

        public BillingAccountName build() {
            return new BillingAccountName(this);
        }
    }
}

