/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LogExclusionName
implements ResourceName {
    private static final PathTemplate PROJECT_EXCLUSION_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/exclusions/{exclusion}");
    private static final PathTemplate ORGANIZATION_EXCLUSION_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/exclusions/{exclusion}");
    private static final PathTemplate FOLDER_EXCLUSION_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/exclusions/{exclusion}");
    private static final PathTemplate BILLING_ACCOUNT_EXCLUSION_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}/exclusions/{exclusion}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private String project;
    private String exclusion;
    private String organization;
    private String folder;
    private String billingAccount;

    @Deprecated
    protected LogExclusionName() {
    }

    public String getProject() {
        return this.project;
    }

    public String getExclusion() {
        return this.exclusion;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    private LogExclusionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.exclusion = (String)Preconditions.checkNotNull((Object)builder.getExclusion());
        this.pathTemplate = PROJECT_EXCLUSION_PATH_TEMPLATE;
    }

    private LogExclusionName(OrganizationExclusionBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.exclusion = (String)Preconditions.checkNotNull((Object)builder.getExclusion());
        this.pathTemplate = ORGANIZATION_EXCLUSION_PATH_TEMPLATE;
    }

    private LogExclusionName(FolderExclusionBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.exclusion = (String)Preconditions.checkNotNull((Object)builder.getExclusion());
        this.pathTemplate = FOLDER_EXCLUSION_PATH_TEMPLATE;
    }

    private LogExclusionName(BillingAccountExclusionBuilder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.exclusion = (String)Preconditions.checkNotNull((Object)builder.getExclusion());
        this.pathTemplate = BILLING_ACCOUNT_EXCLUSION_PATH_TEMPLATE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectExclusionBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationExclusionBuilder newOrganizationExclusionBuilder() {
        return new OrganizationExclusionBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderExclusionBuilder newFolderExclusionBuilder() {
        return new FolderExclusionBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static BillingAccountExclusionBuilder newBillingAccountExclusionBuilder() {
        return new BillingAccountExclusionBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LogExclusionName of(String project, String exclusion) {
        return LogExclusionName.newProjectExclusionBuilder().setProject(project).setExclusion(exclusion).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static LogExclusionName ofProjectExclusionName(String project, String exclusion) {
        return LogExclusionName.newProjectExclusionBuilder().setProject(project).setExclusion(exclusion).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static LogExclusionName ofOrganizationExclusionName(String organization, String exclusion) {
        return LogExclusionName.newOrganizationExclusionBuilder().setOrganization(organization).setExclusion(exclusion).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static LogExclusionName ofFolderExclusionName(String folder, String exclusion) {
        return LogExclusionName.newFolderExclusionBuilder().setFolder(folder).setExclusion(exclusion).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static LogExclusionName ofBillingAccountExclusionName(String billingAccount, String exclusion) {
        return LogExclusionName.newBillingAccountExclusionBuilder().setBillingAccount(billingAccount).setExclusion(exclusion).build();
    }

    public static String format(String project, String exclusion) {
        return LogExclusionName.newBuilder().setProject(project).setExclusion(exclusion).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectExclusionName(String project, String exclusion) {
        return LogExclusionName.newBuilder().setProject(project).setExclusion(exclusion).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationExclusionName(String organization, String exclusion) {
        return LogExclusionName.newOrganizationExclusionBuilder().setOrganization(organization).setExclusion(exclusion).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderExclusionName(String folder, String exclusion) {
        return LogExclusionName.newFolderExclusionBuilder().setFolder(folder).setExclusion(exclusion).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatBillingAccountExclusionName(String billingAccount, String exclusion) {
        return LogExclusionName.newBillingAccountExclusionBuilder().setBillingAccount(billingAccount).setExclusion(exclusion).build().toString();
    }

    public static LogExclusionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_EXCLUSION_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_EXCLUSION_PATH_TEMPLATE.match(formattedString);
            return LogExclusionName.ofProjectExclusionName((String)matchMap.get("project"), (String)matchMap.get("exclusion"));
        }
        if (ORGANIZATION_EXCLUSION_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_EXCLUSION_PATH_TEMPLATE.match(formattedString);
            return LogExclusionName.ofOrganizationExclusionName((String)matchMap.get("organization"), (String)matchMap.get("exclusion"));
        }
        if (FOLDER_EXCLUSION_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = FOLDER_EXCLUSION_PATH_TEMPLATE.match(formattedString);
            return LogExclusionName.ofFolderExclusionName((String)matchMap.get("folder"), (String)matchMap.get("exclusion"));
        }
        if (BILLING_ACCOUNT_EXCLUSION_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = BILLING_ACCOUNT_EXCLUSION_PATH_TEMPLATE.match(formattedString);
            return LogExclusionName.ofBillingAccountExclusionName((String)matchMap.get("billing_account"), (String)matchMap.get("exclusion"));
        }
        throw new ValidationException("JobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<LogExclusionName> parseList(List<String> formattedStrings) {
        ArrayList<LogExclusionName> list = new ArrayList<LogExclusionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LogExclusionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LogExclusionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LogExclusionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_EXCLUSION_PATH_TEMPLATE.matches(formattedString) || ORGANIZATION_EXCLUSION_PATH_TEMPLATE.matches(formattedString) || FOLDER_EXCLUSION_PATH_TEMPLATE.matches(formattedString) || BILLING_ACCOUNT_EXCLUSION_PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LogExclusionName logExclusionName = this;
            synchronized (logExclusionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.exclusion != null) {
                        fieldMapBuilder.put((Object)"exclusion", (Object)this.exclusion);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put((Object)"billing_account", (Object)this.billingAccount);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            LogExclusionName that = (LogExclusionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.exclusion, that.exclusion) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder) && Objects.equals(this.billingAccount, that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.exclusion);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingAccount);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class BillingAccountExclusionBuilder {
        private String billingAccount;
        private String exclusion;

        private BillingAccountExclusionBuilder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getExclusion() {
            return this.exclusion;
        }

        public BillingAccountExclusionBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public BillingAccountExclusionBuilder setExclusion(String exclusion) {
            this.exclusion = exclusion;
            return this;
        }

        public LogExclusionName build() {
            return new LogExclusionName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderExclusionBuilder {
        private String folder;
        private String exclusion;

        private FolderExclusionBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getExclusion() {
            return this.exclusion;
        }

        public FolderExclusionBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderExclusionBuilder setExclusion(String exclusion) {
            this.exclusion = exclusion;
            return this;
        }

        public LogExclusionName build() {
            return new LogExclusionName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationExclusionBuilder {
        private String organization;
        private String exclusion;

        private OrganizationExclusionBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getExclusion() {
            return this.exclusion;
        }

        public OrganizationExclusionBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationExclusionBuilder setExclusion(String exclusion) {
            this.exclusion = exclusion;
            return this;
        }

        public LogExclusionName build() {
            return new LogExclusionName(this);
        }
    }

    public static class Builder {
        private String project;
        private String exclusion;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getExclusion() {
            return this.exclusion;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setExclusion(String exclusion) {
            this.exclusion = exclusion;
            return this;
        }

        private Builder(LogExclusionName logExclusionName) {
            Preconditions.checkArgument((logExclusionName.pathTemplate == PROJECT_EXCLUSION_PATH_TEMPLATE ? 1 : 0) != 0, (Object)"toBuilder is only supported when LogExclusionName has the pattern of projects/{project}/exclusions/{exclusion}.");
            this.project = logExclusionName.project;
            this.exclusion = logExclusionName.exclusion;
        }

        public LogExclusionName build() {
            return new LogExclusionName(this);
        }
    }
}

