/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LogName
implements ResourceName {
    private static final PathTemplate PROJECT_LOG_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/logs/{log}");
    private static final PathTemplate ORGANIZATION_LOG_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/logs/{log}");
    private static final PathTemplate FOLDER_LOG_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/logs/{log}");
    private static final PathTemplate BILLING_ACCOUNT_LOG_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}/logs/{log}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private String project;
    private String log;
    private String organization;
    private String folder;
    private String billingAccount;

    @Deprecated
    protected LogName() {
    }

    public String getProject() {
        return this.project;
    }

    public String getLog() {
        return this.log;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    private LogName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.log = (String)Preconditions.checkNotNull((Object)builder.getLog());
        this.pathTemplate = PROJECT_LOG_PATH_TEMPLATE;
    }

    private LogName(OrganizationLogBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.log = (String)Preconditions.checkNotNull((Object)builder.getLog());
        this.pathTemplate = ORGANIZATION_LOG_PATH_TEMPLATE;
    }

    private LogName(FolderLogBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.log = (String)Preconditions.checkNotNull((Object)builder.getLog());
        this.pathTemplate = FOLDER_LOG_PATH_TEMPLATE;
    }

    private LogName(BillingAccountLogBuilder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.log = (String)Preconditions.checkNotNull((Object)builder.getLog());
        this.pathTemplate = BILLING_ACCOUNT_LOG_PATH_TEMPLATE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectLogBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationLogBuilder newOrganizationLogBuilder() {
        return new OrganizationLogBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderLogBuilder newFolderLogBuilder() {
        return new FolderLogBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static BillingAccountLogBuilder newBillingAccountLogBuilder() {
        return new BillingAccountLogBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LogName of(String project, String log) {
        return LogName.newProjectLogBuilder().setProject(project).setLog(log).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static LogName ofProjectLogName(String project, String log) {
        return LogName.newProjectLogBuilder().setProject(project).setLog(log).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static LogName ofOrganizationLogName(String organization, String log) {
        return LogName.newOrganizationLogBuilder().setOrganization(organization).setLog(log).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static LogName ofFolderLogName(String folder, String log) {
        return LogName.newFolderLogBuilder().setFolder(folder).setLog(log).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static LogName ofBillingAccountLogName(String billingAccount, String log) {
        return LogName.newBillingAccountLogBuilder().setBillingAccount(billingAccount).setLog(log).build();
    }

    public static String format(String project, String log) {
        return LogName.newBuilder().setProject(project).setLog(log).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLogName(String project, String log) {
        return LogName.newBuilder().setProject(project).setLog(log).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationLogName(String organization, String log) {
        return LogName.newOrganizationLogBuilder().setOrganization(organization).setLog(log).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderLogName(String folder, String log) {
        return LogName.newFolderLogBuilder().setFolder(folder).setLog(log).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatBillingAccountLogName(String billingAccount, String log) {
        return LogName.newBillingAccountLogBuilder().setBillingAccount(billingAccount).setLog(log).build().toString();
    }

    public static LogName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOG_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_LOG_PATH_TEMPLATE.match(formattedString);
            return LogName.ofProjectLogName((String)matchMap.get("project"), (String)matchMap.get("log"));
        }
        if (ORGANIZATION_LOG_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOG_PATH_TEMPLATE.match(formattedString);
            return LogName.ofOrganizationLogName((String)matchMap.get("organization"), (String)matchMap.get("log"));
        }
        if (FOLDER_LOG_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = FOLDER_LOG_PATH_TEMPLATE.match(formattedString);
            return LogName.ofFolderLogName((String)matchMap.get("folder"), (String)matchMap.get("log"));
        }
        if (BILLING_ACCOUNT_LOG_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = BILLING_ACCOUNT_LOG_PATH_TEMPLATE.match(formattedString);
            return LogName.ofBillingAccountLogName((String)matchMap.get("billing_account"), (String)matchMap.get("log"));
        }
        throw new ValidationException("JobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<LogName> parseList(List<String> formattedStrings) {
        ArrayList<LogName> list = new ArrayList<LogName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LogName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LogName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LogName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOG_PATH_TEMPLATE.matches(formattedString) || ORGANIZATION_LOG_PATH_TEMPLATE.matches(formattedString) || FOLDER_LOG_PATH_TEMPLATE.matches(formattedString) || BILLING_ACCOUNT_LOG_PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LogName logName = this;
            synchronized (logName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.log != null) {
                        fieldMapBuilder.put((Object)"log", (Object)this.log);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put((Object)"billing_account", (Object)this.billingAccount);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            LogName that = (LogName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.log, that.log) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder) && Objects.equals(this.billingAccount, that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.log);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingAccount);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class BillingAccountLogBuilder {
        private String billingAccount;
        private String log;

        private BillingAccountLogBuilder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getLog() {
            return this.log;
        }

        public BillingAccountLogBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public BillingAccountLogBuilder setLog(String log) {
            this.log = log;
            return this;
        }

        public LogName build() {
            return new LogName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderLogBuilder {
        private String folder;
        private String log;

        private FolderLogBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLog() {
            return this.log;
        }

        public FolderLogBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLogBuilder setLog(String log) {
            this.log = log;
            return this;
        }

        public LogName build() {
            return new LogName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationLogBuilder {
        private String organization;
        private String log;

        private OrganizationLogBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLog() {
            return this.log;
        }

        public OrganizationLogBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLogBuilder setLog(String log) {
            this.log = log;
            return this;
        }

        public LogName build() {
            return new LogName(this);
        }
    }

    public static class Builder {
        private String project;
        private String log;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLog() {
            return this.log;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLog(String log) {
            this.log = log;
            return this;
        }

        private Builder(LogName logName) {
            Preconditions.checkArgument((logName.pathTemplate == PROJECT_LOG_PATH_TEMPLATE ? 1 : 0) != 0, (Object)"toBuilder is only supported when LogName has the pattern of projects/{project}/logs/{log}.");
            this.project = logName.project;
            this.log = logName.log;
        }

        public LogName build() {
            return new LogName(this);
        }
    }
}

