/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LogSinkName
implements ResourceName {
    private static final PathTemplate PROJECT_SINK_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/sinks/{sink}");
    private static final PathTemplate ORGANIZATION_SINK_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/sinks/{sink}");
    private static final PathTemplate FOLDER_SINK_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/sinks/{sink}");
    private static final PathTemplate BILLING_ACCOUNT_SINK_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}/sinks/{sink}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private String project;
    private String sink;
    private String organization;
    private String folder;
    private String billingAccount;

    @Deprecated
    protected LogSinkName() {
    }

    public String getProject() {
        return this.project;
    }

    public String getSink() {
        return this.sink;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    private LogSinkName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.sink = (String)Preconditions.checkNotNull((Object)builder.getSink());
        this.pathTemplate = PROJECT_SINK_PATH_TEMPLATE;
    }

    private LogSinkName(OrganizationSinkBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.sink = (String)Preconditions.checkNotNull((Object)builder.getSink());
        this.pathTemplate = ORGANIZATION_SINK_PATH_TEMPLATE;
    }

    private LogSinkName(FolderSinkBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.sink = (String)Preconditions.checkNotNull((Object)builder.getSink());
        this.pathTemplate = FOLDER_SINK_PATH_TEMPLATE;
    }

    private LogSinkName(BillingAccountSinkBuilder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.sink = (String)Preconditions.checkNotNull((Object)builder.getSink());
        this.pathTemplate = BILLING_ACCOUNT_SINK_PATH_TEMPLATE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectSinkBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationSinkBuilder newOrganizationSinkBuilder() {
        return new OrganizationSinkBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderSinkBuilder newFolderSinkBuilder() {
        return new FolderSinkBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static BillingAccountSinkBuilder newBillingAccountSinkBuilder() {
        return new BillingAccountSinkBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LogSinkName of(String project, String sink) {
        return LogSinkName.newProjectSinkBuilder().setProject(project).setSink(sink).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static LogSinkName ofProjectSinkName(String project, String sink) {
        return LogSinkName.newProjectSinkBuilder().setProject(project).setSink(sink).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static LogSinkName ofOrganizationSinkName(String organization, String sink) {
        return LogSinkName.newOrganizationSinkBuilder().setOrganization(organization).setSink(sink).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static LogSinkName ofFolderSinkName(String folder, String sink) {
        return LogSinkName.newFolderSinkBuilder().setFolder(folder).setSink(sink).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static LogSinkName ofBillingAccountSinkName(String billingAccount, String sink) {
        return LogSinkName.newBillingAccountSinkBuilder().setBillingAccount(billingAccount).setSink(sink).build();
    }

    public static String format(String project, String sink) {
        return LogSinkName.newBuilder().setProject(project).setSink(sink).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectSinkName(String project, String sink) {
        return LogSinkName.newBuilder().setProject(project).setSink(sink).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationSinkName(String organization, String sink) {
        return LogSinkName.newOrganizationSinkBuilder().setOrganization(organization).setSink(sink).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderSinkName(String folder, String sink) {
        return LogSinkName.newFolderSinkBuilder().setFolder(folder).setSink(sink).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatBillingAccountSinkName(String billingAccount, String sink) {
        return LogSinkName.newBillingAccountSinkBuilder().setBillingAccount(billingAccount).setSink(sink).build().toString();
    }

    public static LogSinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_SINK_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_SINK_PATH_TEMPLATE.match(formattedString);
            return LogSinkName.ofProjectSinkName((String)matchMap.get("project"), (String)matchMap.get("sink"));
        }
        if (ORGANIZATION_SINK_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = ORGANIZATION_SINK_PATH_TEMPLATE.match(formattedString);
            return LogSinkName.ofOrganizationSinkName((String)matchMap.get("organization"), (String)matchMap.get("sink"));
        }
        if (FOLDER_SINK_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = FOLDER_SINK_PATH_TEMPLATE.match(formattedString);
            return LogSinkName.ofFolderSinkName((String)matchMap.get("folder"), (String)matchMap.get("sink"));
        }
        if (BILLING_ACCOUNT_SINK_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = BILLING_ACCOUNT_SINK_PATH_TEMPLATE.match(formattedString);
            return LogSinkName.ofBillingAccountSinkName((String)matchMap.get("billing_account"), (String)matchMap.get("sink"));
        }
        throw new ValidationException("JobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<LogSinkName> parseList(List<String> formattedStrings) {
        ArrayList<LogSinkName> list = new ArrayList<LogSinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LogSinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LogSinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LogSinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SINK_PATH_TEMPLATE.matches(formattedString) || ORGANIZATION_SINK_PATH_TEMPLATE.matches(formattedString) || FOLDER_SINK_PATH_TEMPLATE.matches(formattedString) || BILLING_ACCOUNT_SINK_PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LogSinkName logSinkName = this;
            synchronized (logSinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.sink != null) {
                        fieldMapBuilder.put((Object)"sink", (Object)this.sink);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put((Object)"billing_account", (Object)this.billingAccount);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            LogSinkName that = (LogSinkName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.sink, that.sink) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder) && Objects.equals(this.billingAccount, that.billingAccount);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.sink);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.billingAccount);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class BillingAccountSinkBuilder {
        private String billingAccount;
        private String sink;

        private BillingAccountSinkBuilder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getSink() {
            return this.sink;
        }

        public BillingAccountSinkBuilder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public BillingAccountSinkBuilder setSink(String sink) {
            this.sink = sink;
            return this;
        }

        public LogSinkName build() {
            return new LogSinkName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderSinkBuilder {
        private String folder;
        private String sink;

        private FolderSinkBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getSink() {
            return this.sink;
        }

        public FolderSinkBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderSinkBuilder setSink(String sink) {
            this.sink = sink;
            return this;
        }

        public LogSinkName build() {
            return new LogSinkName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationSinkBuilder {
        private String organization;
        private String sink;

        private OrganizationSinkBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getSink() {
            return this.sink;
        }

        public OrganizationSinkBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationSinkBuilder setSink(String sink) {
            this.sink = sink;
            return this;
        }

        public LogSinkName build() {
            return new LogSinkName(this);
        }
    }

    public static class Builder {
        private String project;
        private String sink;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getSink() {
            return this.sink;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSink(String sink) {
            this.sink = sink;
            return this;
        }

        private Builder(LogSinkName logSinkName) {
            Preconditions.checkArgument((logSinkName.pathTemplate == PROJECT_SINK_PATH_TEMPLATE ? 1 : 0) != 0, (Object)"toBuilder is only supported when LogSinkName has the pattern of projects/{project}/sinks/{sink}.");
            this.project = logSinkName.project;
            this.sink = logSinkName.sink;
        }

        public LogSinkName build() {
            return new LogSinkName(this);
        }
    }
}

