/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BillingAccountLocationName
implements ResourceName {
    private static final PathTemplate BILLING_ACCOUNT_LOCATION = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}/locations/{location}");
    private volatile Map<String, String> fieldValuesMap;
    private final String billingAccount;
    private final String location;

    @Deprecated
    protected BillingAccountLocationName() {
        this.billingAccount = null;
        this.location = null;
    }

    private BillingAccountLocationName(Builder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BillingAccountLocationName of(String billingAccount, String location) {
        return BillingAccountLocationName.newBuilder().setBillingAccount(billingAccount).setLocation(location).build();
    }

    public static String format(String billingAccount, String location) {
        return BillingAccountLocationName.newBuilder().setBillingAccount(billingAccount).setLocation(location).build().toString();
    }

    public static BillingAccountLocationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = BILLING_ACCOUNT_LOCATION.validatedMatch(formattedString, "BillingAccountLocationName.parse: formattedString not in valid format");
        return BillingAccountLocationName.of((String)matchMap.get("billing_account"), (String)matchMap.get("location"));
    }

    public static List<BillingAccountLocationName> parseList(List<String> formattedStrings) {
        ArrayList<BillingAccountLocationName> list = new ArrayList<BillingAccountLocationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BillingAccountLocationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BillingAccountLocationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BillingAccountLocationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return BILLING_ACCOUNT_LOCATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BillingAccountLocationName billingAccountLocationName = this;
            synchronized (billingAccountLocationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put((Object)"billing_account", (Object)this.billingAccount);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return BILLING_ACCOUNT_LOCATION.instantiate(new String[]{"billing_account", this.billingAccount, "location", this.location});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            BillingAccountLocationName that = (BillingAccountLocationName)o;
            return Objects.equals(this.billingAccount, that.billingAccount) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.billingAccount);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class Builder {
        private String billingAccount;
        private String location;

        protected Builder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getLocation() {
            return this.location;
        }

        public Builder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        private Builder(BillingAccountLocationName billingAccountLocationName) {
            this.billingAccount = billingAccountLocationName.billingAccount;
            this.location = billingAccountLocationName.location;
        }

        public BillingAccountLocationName build() {
            return new BillingAccountLocationName(this);
        }
    }
}

