/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.managedidentities.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DomainName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DOMAIN = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/domains/{domain}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String domain;

    @Deprecated
    protected DomainName() {
        this.project = null;
        this.location = null;
        this.domain = null;
    }

    private DomainName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.domain = (String)Preconditions.checkNotNull((Object)builder.getDomain());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDomain() {
        return this.domain;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DomainName of(String project, String location, String domain) {
        return DomainName.newBuilder().setProject(project).setLocation(location).setDomain(domain).build();
    }

    public static String format(String project, String location, String domain) {
        return DomainName.newBuilder().setProject(project).setLocation(location).setDomain(domain).build().toString();
    }

    public static DomainName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DOMAIN.validatedMatch(formattedString, "DomainName.parse: formattedString not in valid format");
        return DomainName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("domain"));
    }

    public static List<DomainName> parseList(List<String> formattedStrings) {
        ArrayList<DomainName> list = new ArrayList<DomainName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DomainName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DomainName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DomainName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DOMAIN.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DomainName domainName = this;
            synchronized (domainName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.domain != null) {
                        fieldMapBuilder.put((Object)"domain", (Object)this.domain);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DOMAIN.instantiate(new String[]{"project", this.project, "location", this.location, "domain", this.domain});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DomainName that = (DomainName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.domain, that.domain);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.domain);
    }

    public static class Builder {
        private String project;
        private String location;
        private String domain;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDomain() {
            return this.domain;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        private Builder(DomainName domainName) {
            this.project = domainName.project;
            this.location = domainName.location;
            this.domain = domainName.domain;
        }

        public DomainName build() {
            return new DomainName(this);
        }
    }
}

