/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/managedidentities/v1/resource.proto

package com.google.cloud.managedidentities.v1;

/**
 *
 *
 * <pre>
 * Represents a managed Microsoft Active Directory domain.
 * </pre>
 *
 * Protobuf type {@code google.cloud.managedidentities.v1.Domain}
 */
public final class Domain extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.managedidentities.v1.Domain)
    DomainOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Domain.newBuilder() to construct.
  private Domain(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Domain() {
    name_ = "";
    authorizedNetworks_ = com.google.protobuf.LazyStringArrayList.emptyList();
    reservedIpRange_ = "";
    locations_ = com.google.protobuf.LazyStringArrayList.emptyList();
    admin_ = "";
    fqdn_ = "";
    state_ = 0;
    statusMessage_ = "";
    trusts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Domain();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.managedidentities.v1.ResourceProto
        .internal_static_google_cloud_managedidentities_v1_Domain_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 2:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.managedidentities.v1.ResourceProto
        .internal_static_google_cloud_managedidentities_v1_Domain_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.managedidentities.v1.Domain.class,
            com.google.cloud.managedidentities.v1.Domain.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents the different states of a managed domain.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.managedidentities.v1.Domain.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The domain is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The domain has been created and is fully usable.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    READY(2),
    /**
     *
     *
     * <pre>
     * The domain's configuration is being updated.
     * </pre>
     *
     * <code>UPDATING = 3;</code>
     */
    UPDATING(3),
    /**
     *
     *
     * <pre>
     * The domain is being deleted.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    DELETING(4),
    /**
     *
     *
     * <pre>
     * The domain is being repaired and may be unusable. Details
     * can be found in the `status_message` field.
     * </pre>
     *
     * <code>REPAIRING = 5;</code>
     */
    REPAIRING(5),
    /**
     *
     *
     * <pre>
     * The domain is undergoing maintenance.
     * </pre>
     *
     * <code>PERFORMING_MAINTENANCE = 6;</code>
     */
    PERFORMING_MAINTENANCE(6),
    /**
     *
     *
     * <pre>
     * The domain is not serving requests.
     * </pre>
     *
     * <code>UNAVAILABLE = 7;</code>
     */
    UNAVAILABLE(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The domain is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The domain has been created and is fully usable.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    public static final int READY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The domain's configuration is being updated.
     * </pre>
     *
     * <code>UPDATING = 3;</code>
     */
    public static final int UPDATING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The domain is being deleted.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    public static final int DELETING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The domain is being repaired and may be unusable. Details
     * can be found in the `status_message` field.
     * </pre>
     *
     * <code>REPAIRING = 5;</code>
     */
    public static final int REPAIRING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The domain is undergoing maintenance.
     * </pre>
     *
     * <code>PERFORMING_MAINTENANCE = 6;</code>
     */
    public static final int PERFORMING_MAINTENANCE_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The domain is not serving requests.
     * </pre>
     *
     * <code>UNAVAILABLE = 7;</code>
     */
    public static final int UNAVAILABLE_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return READY;
        case 3:
          return UPDATING;
        case 4:
          return DELETING;
        case 5:
          return REPAIRING;
        case 6:
          return PERFORMING_MAINTENANCE;
        case 7:
          return UNAVAILABLE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.managedidentities.v1.Domain.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.managedidentities.v1.Domain.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The unique name of the domain using the form:
   * `projects/{project_id}/locations/global/domains/{domain_name}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The unique name of the domain using the form:
   * `projects/{project_id}/locations/global/domains/{domain_name}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 2;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.managedidentities.v1.ResourceProto
                .internal_static_google_cloud_managedidentities_v1_Domain_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Resource labels that can contain user-provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Resource labels that can contain user-provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Resource labels that can contain user-provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Resource labels that can contain user-provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int AUTHORIZED_NETWORKS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList authorizedNetworks_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. The full names of the Google Compute Engine
   * [networks](/compute/docs/networks-and-firewalls#networks) the domain
   * instance is connected to. Networks can be added using UpdateDomain.
   * The domain is only available on networks listed in `authorized_networks`.
   * If CIDR subnets overlap between networks, domain creation will fail.
   * </pre>
   *
   * <code>repeated string authorized_networks = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the authorizedNetworks.
   */
  public com.google.protobuf.ProtocolStringList getAuthorizedNetworksList() {
    return authorizedNetworks_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The full names of the Google Compute Engine
   * [networks](/compute/docs/networks-and-firewalls#networks) the domain
   * instance is connected to. Networks can be added using UpdateDomain.
   * The domain is only available on networks listed in `authorized_networks`.
   * If CIDR subnets overlap between networks, domain creation will fail.
   * </pre>
   *
   * <code>repeated string authorized_networks = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of authorizedNetworks.
   */
  public int getAuthorizedNetworksCount() {
    return authorizedNetworks_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The full names of the Google Compute Engine
   * [networks](/compute/docs/networks-and-firewalls#networks) the domain
   * instance is connected to. Networks can be added using UpdateDomain.
   * The domain is only available on networks listed in `authorized_networks`.
   * If CIDR subnets overlap between networks, domain creation will fail.
   * </pre>
   *
   * <code>repeated string authorized_networks = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The authorizedNetworks at the given index.
   */
  public java.lang.String getAuthorizedNetworks(int index) {
    return authorizedNetworks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The full names of the Google Compute Engine
   * [networks](/compute/docs/networks-and-firewalls#networks) the domain
   * instance is connected to. Networks can be added using UpdateDomain.
   * The domain is only available on networks listed in `authorized_networks`.
   * If CIDR subnets overlap between networks, domain creation will fail.
   * </pre>
   *
   * <code>repeated string authorized_networks = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the authorizedNetworks at the given index.
   */
  public com.google.protobuf.ByteString getAuthorizedNetworksBytes(int index) {
    return authorizedNetworks_.getByteString(index);
  }

  public static final int RESERVED_IP_RANGE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object reservedIpRange_ = "";
  /**
   *
   *
   * <pre>
   * Required. The CIDR range of internal addresses that are reserved for this
   * domain. Reserved networks must be /24 or larger. Ranges must be
   * unique and non-overlapping with existing subnets in
   * [Domain].[authorized_networks].
   * </pre>
   *
   * <code>string reserved_ip_range = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The reservedIpRange.
   */
  @java.lang.Override
  public java.lang.String getReservedIpRange() {
    java.lang.Object ref = reservedIpRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      reservedIpRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The CIDR range of internal addresses that are reserved for this
   * domain. Reserved networks must be /24 or larger. Ranges must be
   * unique and non-overlapping with existing subnets in
   * [Domain].[authorized_networks].
   * </pre>
   *
   * <code>string reserved_ip_range = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for reservedIpRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReservedIpRangeBytes() {
    java.lang.Object ref = reservedIpRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      reservedIpRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATIONS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList locations_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Required. Locations where domain needs to be provisioned.
   * [regions][compute/docs/regions-zones/]
   * e.g. us-west1 or us-east4
   * Service supports up to 4 locations at once. Each location will use a /26
   * block.
   * </pre>
   *
   * <code>repeated string locations = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the locations.
   */
  public com.google.protobuf.ProtocolStringList getLocationsList() {
    return locations_;
  }
  /**
   *
   *
   * <pre>
   * Required. Locations where domain needs to be provisioned.
   * [regions][compute/docs/regions-zones/]
   * e.g. us-west1 or us-east4
   * Service supports up to 4 locations at once. Each location will use a /26
   * block.
   * </pre>
   *
   * <code>repeated string locations = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of locations.
   */
  public int getLocationsCount() {
    return locations_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Locations where domain needs to be provisioned.
   * [regions][compute/docs/regions-zones/]
   * e.g. us-west1 or us-east4
   * Service supports up to 4 locations at once. Each location will use a /26
   * block.
   * </pre>
   *
   * <code>repeated string locations = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The locations at the given index.
   */
  public java.lang.String getLocations(int index) {
    return locations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Locations where domain needs to be provisioned.
   * [regions][compute/docs/regions-zones/]
   * e.g. us-west1 or us-east4
   * Service supports up to 4 locations at once. Each location will use a /26
   * block.
   * </pre>
   *
   * <code>repeated string locations = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the locations at the given index.
   */
  public com.google.protobuf.ByteString getLocationsBytes(int index) {
    return locations_.getByteString(index);
  }

  public static final int ADMIN_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object admin_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The name of delegated administrator account used to perform
   * Active Directory operations. If not specified, `setupadmin` will be used.
   * </pre>
   *
   * <code>string admin = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The admin.
   */
  @java.lang.Override
  public java.lang.String getAdmin() {
    java.lang.Object ref = admin_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      admin_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of delegated administrator account used to perform
   * Active Directory operations. If not specified, `setupadmin` will be used.
   * </pre>
   *
   * <code>string admin = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for admin.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAdminBytes() {
    java.lang.Object ref = admin_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      admin_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FQDN_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fqdn_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The fully-qualified domain name of the exposed domain used by
   * clients to connect to the service. Similar to what would be chosen for an
   * Active Directory set up on an internal network.
   * </pre>
   *
   * <code>string fqdn = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The fqdn.
   */
  @java.lang.Override
  public java.lang.String getFqdn() {
    java.lang.Object ref = fqdn_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fqdn_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The fully-qualified domain name of the exposed domain used by
   * clients to connect to the service. Similar to what would be chosen for an
   * Active Directory set up on an internal network.
   * </pre>
   *
   * <code>string fqdn = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for fqdn.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFqdnBytes() {
    java.lang.Object ref = fqdn_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fqdn_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int STATE_FIELD_NUMBER = 13;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current state of this domain.
   * </pre>
   *
   * <code>
   * .google.cloud.managedidentities.v1.Domain.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of this domain.
   * </pre>
   *
   * <code>
   * .google.cloud.managedidentities.v1.Domain.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.managedidentities.v1.Domain.State getState() {
    com.google.cloud.managedidentities.v1.Domain.State result =
        com.google.cloud.managedidentities.v1.Domain.State.forNumber(state_);
    return result == null
        ? com.google.cloud.managedidentities.v1.Domain.State.UNRECOGNIZED
        : result;
  }

  public static final int STATUS_MESSAGE_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object statusMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the current status of this
   * domain, if available.
   * </pre>
   *
   * <code>string status_message = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The statusMessage.
   */
  @java.lang.Override
  public java.lang.String getStatusMessage() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statusMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the current status of this
   * domain, if available.
   * </pre>
   *
   * <code>string status_message = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for statusMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusMessageBytes() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statusMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRUSTS_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.managedidentities.v1.Trust> trusts_;
  /**
   *
   *
   * <pre>
   * Output only. The current trusts associated with the domain.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.managedidentities.v1.Trust> getTrustsList() {
    return trusts_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current trusts associated with the domain.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.managedidentities.v1.TrustOrBuilder>
      getTrustsOrBuilderList() {
    return trusts_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current trusts associated with the domain.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getTrustsCount() {
    return trusts_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The current trusts associated with the domain.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.managedidentities.v1.Trust getTrusts(int index) {
    return trusts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The current trusts associated with the domain.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.managedidentities.v1.TrustOrBuilder getTrustsOrBuilder(int index) {
    return trusts_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 2);
    for (int i = 0; i < authorizedNetworks_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, authorizedNetworks_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reservedIpRange_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, reservedIpRange_);
    }
    for (int i = 0; i < locations_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, locations_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(admin_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, admin_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fqdn_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, fqdn_);
    }
    if (createTime_ != null) {
      output.writeMessage(11, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(12, getUpdateTime());
    }
    if (state_
        != com.google.cloud.managedidentities.v1.Domain.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(13, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, statusMessage_);
    }
    for (int i = 0; i < trusts_.size(); i++) {
      output.writeMessage(15, trusts_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, labels__);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < authorizedNetworks_.size(); i++) {
        dataSize += computeStringSizeNoTag(authorizedNetworks_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAuthorizedNetworksList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reservedIpRange_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, reservedIpRange_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < locations_.size(); i++) {
        dataSize += computeStringSizeNoTag(locations_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getLocationsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(admin_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, admin_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fqdn_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, fqdn_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getUpdateTime());
    }
    if (state_
        != com.google.cloud.managedidentities.v1.Domain.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(13, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(statusMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, statusMessage_);
    }
    for (int i = 0; i < trusts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, trusts_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.managedidentities.v1.Domain)) {
      return super.equals(obj);
    }
    com.google.cloud.managedidentities.v1.Domain other =
        (com.google.cloud.managedidentities.v1.Domain) obj;

    if (!getName().equals(other.getName())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getAuthorizedNetworksList().equals(other.getAuthorizedNetworksList())) return false;
    if (!getReservedIpRange().equals(other.getReservedIpRange())) return false;
    if (!getLocationsList().equals(other.getLocationsList())) return false;
    if (!getAdmin().equals(other.getAdmin())) return false;
    if (!getFqdn().equals(other.getFqdn())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getStatusMessage().equals(other.getStatusMessage())) return false;
    if (!getTrustsList().equals(other.getTrustsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getAuthorizedNetworksCount() > 0) {
      hash = (37 * hash) + AUTHORIZED_NETWORKS_FIELD_NUMBER;
      hash = (53 * hash) + getAuthorizedNetworksList().hashCode();
    }
    hash = (37 * hash) + RESERVED_IP_RANGE_FIELD_NUMBER;
    hash = (53 * hash) + getReservedIpRange().hashCode();
    if (getLocationsCount() > 0) {
      hash = (37 * hash) + LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getLocationsList().hashCode();
    }
    hash = (37 * hash) + ADMIN_FIELD_NUMBER;
    hash = (53 * hash) + getAdmin().hashCode();
    hash = (37 * hash) + FQDN_FIELD_NUMBER;
    hash = (53 * hash) + getFqdn().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + STATUS_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getStatusMessage().hashCode();
    if (getTrustsCount() > 0) {
      hash = (37 * hash) + TRUSTS_FIELD_NUMBER;
      hash = (53 * hash) + getTrustsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.managedidentities.v1.Domain parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.managedidentities.v1.Domain parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.managedidentities.v1.Domain parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.managedidentities.v1.Domain parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.managedidentities.v1.Domain parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.managedidentities.v1.Domain parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.managedidentities.v1.Domain parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.managedidentities.v1.Domain parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.managedidentities.v1.Domain parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.managedidentities.v1.Domain parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.managedidentities.v1.Domain parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.managedidentities.v1.Domain parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.managedidentities.v1.Domain prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a managed Microsoft Active Directory domain.
   * </pre>
   *
   * Protobuf type {@code google.cloud.managedidentities.v1.Domain}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.managedidentities.v1.Domain)
      com.google.cloud.managedidentities.v1.DomainOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.managedidentities.v1.ResourceProto
          .internal_static_google_cloud_managedidentities_v1_Domain_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 2:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 2:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.managedidentities.v1.ResourceProto
          .internal_static_google_cloud_managedidentities_v1_Domain_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.managedidentities.v1.Domain.class,
              com.google.cloud.managedidentities.v1.Domain.Builder.class);
    }

    // Construct using com.google.cloud.managedidentities.v1.Domain.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      internalGetMutableLabels().clear();
      authorizedNetworks_ = com.google.protobuf.LazyStringArrayList.emptyList();
      reservedIpRange_ = "";
      locations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      admin_ = "";
      fqdn_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      state_ = 0;
      statusMessage_ = "";
      if (trustsBuilder_ == null) {
        trusts_ = java.util.Collections.emptyList();
      } else {
        trusts_ = null;
        trustsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.managedidentities.v1.ResourceProto
          .internal_static_google_cloud_managedidentities_v1_Domain_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.managedidentities.v1.Domain getDefaultInstanceForType() {
      return com.google.cloud.managedidentities.v1.Domain.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.managedidentities.v1.Domain build() {
      com.google.cloud.managedidentities.v1.Domain result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.managedidentities.v1.Domain buildPartial() {
      com.google.cloud.managedidentities.v1.Domain result =
          new com.google.cloud.managedidentities.v1.Domain(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.managedidentities.v1.Domain result) {
      if (trustsBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          trusts_ = java.util.Collections.unmodifiableList(trusts_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.trusts_ = trusts_;
      } else {
        result.trusts_ = trustsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.managedidentities.v1.Domain result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        authorizedNetworks_.makeImmutable();
        result.authorizedNetworks_ = authorizedNetworks_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.reservedIpRange_ = reservedIpRange_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        locations_.makeImmutable();
        result.locations_ = locations_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.admin_ = admin_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.fqdn_ = fqdn_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.statusMessage_ = statusMessage_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.managedidentities.v1.Domain) {
        return mergeFrom((com.google.cloud.managedidentities.v1.Domain) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.managedidentities.v1.Domain other) {
      if (other == com.google.cloud.managedidentities.v1.Domain.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000002;
      if (!other.authorizedNetworks_.isEmpty()) {
        if (authorizedNetworks_.isEmpty()) {
          authorizedNetworks_ = other.authorizedNetworks_;
          bitField0_ |= 0x00000004;
        } else {
          ensureAuthorizedNetworksIsMutable();
          authorizedNetworks_.addAll(other.authorizedNetworks_);
        }
        onChanged();
      }
      if (!other.getReservedIpRange().isEmpty()) {
        reservedIpRange_ = other.reservedIpRange_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.locations_.isEmpty()) {
        if (locations_.isEmpty()) {
          locations_ = other.locations_;
          bitField0_ |= 0x00000010;
        } else {
          ensureLocationsIsMutable();
          locations_.addAll(other.locations_);
        }
        onChanged();
      }
      if (!other.getAdmin().isEmpty()) {
        admin_ = other.admin_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getFqdn().isEmpty()) {
        fqdn_ = other.fqdn_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getStatusMessage().isEmpty()) {
        statusMessage_ = other.statusMessage_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (trustsBuilder_ == null) {
        if (!other.trusts_.isEmpty()) {
          if (trusts_.isEmpty()) {
            trusts_ = other.trusts_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureTrustsIsMutable();
            trusts_.addAll(other.trusts_);
          }
          onChanged();
        }
      } else {
        if (!other.trusts_.isEmpty()) {
          if (trustsBuilder_.isEmpty()) {
            trustsBuilder_.dispose();
            trustsBuilder_ = null;
            trusts_ = other.trusts_;
            bitField0_ = (bitField0_ & ~0x00000800);
            trustsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTrustsFieldBuilder()
                    : null;
          } else {
            trustsBuilder_.addAllMessages(other.trusts_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAuthorizedNetworksIsMutable();
                authorizedNetworks_.add(s);
                break;
              } // case 26
            case 34:
              {
                reservedIpRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLocationsIsMutable();
                locations_.add(s);
                break;
              } // case 42
            case 50:
              {
                admin_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 82:
              {
                fqdn_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 98
            case 104:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 104
            case 114:
              {
                statusMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 114
            case 122:
              {
                com.google.cloud.managedidentities.v1.Trust m =
                    input.readMessage(
                        com.google.cloud.managedidentities.v1.Trust.parser(), extensionRegistry);
                if (trustsBuilder_ == null) {
                  ensureTrustsIsMutable();
                  trusts_.add(m);
                } else {
                  trustsBuilder_.addMessage(m);
                }
                break;
              } // case 122
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The unique name of the domain using the form:
     * `projects/{project_id}/locations/global/domains/{domain_name}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the domain using the form:
     * `projects/{project_id}/locations/global/domains/{domain_name}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the domain using the form:
     * `projects/{project_id}/locations/global/domains/{domain_name}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the domain using the form:
     * `projects/{project_id}/locations/global/domains/{domain_name}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the domain using the form:
     * `projects/{project_id}/locations/global/domains/{domain_name}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Resource labels that can contain user-provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Resource labels that can contain user-provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Resource labels that can contain user-provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resource labels that can contain user-provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resource labels that can contain user-provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000002;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Resource labels that can contain user-provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Resource labels that can contain user-provided metadata.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    private com.google.protobuf.LazyStringArrayList authorizedNetworks_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAuthorizedNetworksIsMutable() {
      if (!authorizedNetworks_.isModifiable()) {
        authorizedNetworks_ = new com.google.protobuf.LazyStringArrayList(authorizedNetworks_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Optional. The full names of the Google Compute Engine
     * [networks](/compute/docs/networks-and-firewalls#networks) the domain
     * instance is connected to. Networks can be added using UpdateDomain.
     * The domain is only available on networks listed in `authorized_networks`.
     * If CIDR subnets overlap between networks, domain creation will fail.
     * </pre>
     *
     * <code>repeated string authorized_networks = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the authorizedNetworks.
     */
    public com.google.protobuf.ProtocolStringList getAuthorizedNetworksList() {
      authorizedNetworks_.makeImmutable();
      return authorizedNetworks_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The full names of the Google Compute Engine
     * [networks](/compute/docs/networks-and-firewalls#networks) the domain
     * instance is connected to. Networks can be added using UpdateDomain.
     * The domain is only available on networks listed in `authorized_networks`.
     * If CIDR subnets overlap between networks, domain creation will fail.
     * </pre>
     *
     * <code>repeated string authorized_networks = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of authorizedNetworks.
     */
    public int getAuthorizedNetworksCount() {
      return authorizedNetworks_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The full names of the Google Compute Engine
     * [networks](/compute/docs/networks-and-firewalls#networks) the domain
     * instance is connected to. Networks can be added using UpdateDomain.
     * The domain is only available on networks listed in `authorized_networks`.
     * If CIDR subnets overlap between networks, domain creation will fail.
     * </pre>
     *
     * <code>repeated string authorized_networks = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The authorizedNetworks at the given index.
     */
    public java.lang.String getAuthorizedNetworks(int index) {
      return authorizedNetworks_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The full names of the Google Compute Engine
     * [networks](/compute/docs/networks-and-firewalls#networks) the domain
     * instance is connected to. Networks can be added using UpdateDomain.
     * The domain is only available on networks listed in `authorized_networks`.
     * If CIDR subnets overlap between networks, domain creation will fail.
     * </pre>
     *
     * <code>repeated string authorized_networks = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the authorizedNetworks at the given index.
     */
    public com.google.protobuf.ByteString getAuthorizedNetworksBytes(int index) {
      return authorizedNetworks_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The full names of the Google Compute Engine
     * [networks](/compute/docs/networks-and-firewalls#networks) the domain
     * instance is connected to. Networks can be added using UpdateDomain.
     * The domain is only available on networks listed in `authorized_networks`.
     * If CIDR subnets overlap between networks, domain creation will fail.
     * </pre>
     *
     * <code>repeated string authorized_networks = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The authorizedNetworks to set.
     * @return This builder for chaining.
     */
    public Builder setAuthorizedNetworks(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAuthorizedNetworksIsMutable();
      authorizedNetworks_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The full names of the Google Compute Engine
     * [networks](/compute/docs/networks-and-firewalls#networks) the domain
     * instance is connected to. Networks can be added using UpdateDomain.
     * The domain is only available on networks listed in `authorized_networks`.
     * If CIDR subnets overlap between networks, domain creation will fail.
     * </pre>
     *
     * <code>repeated string authorized_networks = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The authorizedNetworks to add.
     * @return This builder for chaining.
     */
    public Builder addAuthorizedNetworks(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAuthorizedNetworksIsMutable();
      authorizedNetworks_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The full names of the Google Compute Engine
     * [networks](/compute/docs/networks-and-firewalls#networks) the domain
     * instance is connected to. Networks can be added using UpdateDomain.
     * The domain is only available on networks listed in `authorized_networks`.
     * If CIDR subnets overlap between networks, domain creation will fail.
     * </pre>
     *
     * <code>repeated string authorized_networks = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The authorizedNetworks to add.
     * @return This builder for chaining.
     */
    public Builder addAllAuthorizedNetworks(java.lang.Iterable<java.lang.String> values) {
      ensureAuthorizedNetworksIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, authorizedNetworks_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The full names of the Google Compute Engine
     * [networks](/compute/docs/networks-and-firewalls#networks) the domain
     * instance is connected to. Networks can be added using UpdateDomain.
     * The domain is only available on networks listed in `authorized_networks`.
     * If CIDR subnets overlap between networks, domain creation will fail.
     * </pre>
     *
     * <code>repeated string authorized_networks = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAuthorizedNetworks() {
      authorizedNetworks_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The full names of the Google Compute Engine
     * [networks](/compute/docs/networks-and-firewalls#networks) the domain
     * instance is connected to. Networks can be added using UpdateDomain.
     * The domain is only available on networks listed in `authorized_networks`.
     * If CIDR subnets overlap between networks, domain creation will fail.
     * </pre>
     *
     * <code>repeated string authorized_networks = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the authorizedNetworks to add.
     * @return This builder for chaining.
     */
    public Builder addAuthorizedNetworksBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAuthorizedNetworksIsMutable();
      authorizedNetworks_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object reservedIpRange_ = "";
    /**
     *
     *
     * <pre>
     * Required. The CIDR range of internal addresses that are reserved for this
     * domain. Reserved networks must be /24 or larger. Ranges must be
     * unique and non-overlapping with existing subnets in
     * [Domain].[authorized_networks].
     * </pre>
     *
     * <code>string reserved_ip_range = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The reservedIpRange.
     */
    public java.lang.String getReservedIpRange() {
      java.lang.Object ref = reservedIpRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        reservedIpRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The CIDR range of internal addresses that are reserved for this
     * domain. Reserved networks must be /24 or larger. Ranges must be
     * unique and non-overlapping with existing subnets in
     * [Domain].[authorized_networks].
     * </pre>
     *
     * <code>string reserved_ip_range = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for reservedIpRange.
     */
    public com.google.protobuf.ByteString getReservedIpRangeBytes() {
      java.lang.Object ref = reservedIpRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reservedIpRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The CIDR range of internal addresses that are reserved for this
     * domain. Reserved networks must be /24 or larger. Ranges must be
     * unique and non-overlapping with existing subnets in
     * [Domain].[authorized_networks].
     * </pre>
     *
     * <code>string reserved_ip_range = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The reservedIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setReservedIpRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      reservedIpRange_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The CIDR range of internal addresses that are reserved for this
     * domain. Reserved networks must be /24 or larger. Ranges must be
     * unique and non-overlapping with existing subnets in
     * [Domain].[authorized_networks].
     * </pre>
     *
     * <code>string reserved_ip_range = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReservedIpRange() {
      reservedIpRange_ = getDefaultInstance().getReservedIpRange();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The CIDR range of internal addresses that are reserved for this
     * domain. Reserved networks must be /24 or larger. Ranges must be
     * unique and non-overlapping with existing subnets in
     * [Domain].[authorized_networks].
     * </pre>
     *
     * <code>string reserved_ip_range = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for reservedIpRange to set.
     * @return This builder for chaining.
     */
    public Builder setReservedIpRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      reservedIpRange_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList locations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureLocationsIsMutable() {
      if (!locations_.isModifiable()) {
        locations_ = new com.google.protobuf.LazyStringArrayList(locations_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Required. Locations where domain needs to be provisioned.
     * [regions][compute/docs/regions-zones/]
     * e.g. us-west1 or us-east4
     * Service supports up to 4 locations at once. Each location will use a /26
     * block.
     * </pre>
     *
     * <code>repeated string locations = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the locations.
     */
    public com.google.protobuf.ProtocolStringList getLocationsList() {
      locations_.makeImmutable();
      return locations_;
    }
    /**
     *
     *
     * <pre>
     * Required. Locations where domain needs to be provisioned.
     * [regions][compute/docs/regions-zones/]
     * e.g. us-west1 or us-east4
     * Service supports up to 4 locations at once. Each location will use a /26
     * block.
     * </pre>
     *
     * <code>repeated string locations = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of locations.
     */
    public int getLocationsCount() {
      return locations_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. Locations where domain needs to be provisioned.
     * [regions][compute/docs/regions-zones/]
     * e.g. us-west1 or us-east4
     * Service supports up to 4 locations at once. Each location will use a /26
     * block.
     * </pre>
     *
     * <code>repeated string locations = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The locations at the given index.
     */
    public java.lang.String getLocations(int index) {
      return locations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Locations where domain needs to be provisioned.
     * [regions][compute/docs/regions-zones/]
     * e.g. us-west1 or us-east4
     * Service supports up to 4 locations at once. Each location will use a /26
     * block.
     * </pre>
     *
     * <code>repeated string locations = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the locations at the given index.
     */
    public com.google.protobuf.ByteString getLocationsBytes(int index) {
      return locations_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Locations where domain needs to be provisioned.
     * [regions][compute/docs/regions-zones/]
     * e.g. us-west1 or us-east4
     * Service supports up to 4 locations at once. Each location will use a /26
     * block.
     * </pre>
     *
     * <code>repeated string locations = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The locations to set.
     * @return This builder for chaining.
     */
    public Builder setLocations(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLocationsIsMutable();
      locations_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Locations where domain needs to be provisioned.
     * [regions][compute/docs/regions-zones/]
     * e.g. us-west1 or us-east4
     * Service supports up to 4 locations at once. Each location will use a /26
     * block.
     * </pre>
     *
     * <code>repeated string locations = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The locations to add.
     * @return This builder for chaining.
     */
    public Builder addLocations(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLocationsIsMutable();
      locations_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Locations where domain needs to be provisioned.
     * [regions][compute/docs/regions-zones/]
     * e.g. us-west1 or us-east4
     * Service supports up to 4 locations at once. Each location will use a /26
     * block.
     * </pre>
     *
     * <code>repeated string locations = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The locations to add.
     * @return This builder for chaining.
     */
    public Builder addAllLocations(java.lang.Iterable<java.lang.String> values) {
      ensureLocationsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, locations_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Locations where domain needs to be provisioned.
     * [regions][compute/docs/regions-zones/]
     * e.g. us-west1 or us-east4
     * Service supports up to 4 locations at once. Each location will use a /26
     * block.
     * </pre>
     *
     * <code>repeated string locations = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocations() {
      locations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Locations where domain needs to be provisioned.
     * [regions][compute/docs/regions-zones/]
     * e.g. us-west1 or us-east4
     * Service supports up to 4 locations at once. Each location will use a /26
     * block.
     * </pre>
     *
     * <code>repeated string locations = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes of the locations to add.
     * @return This builder for chaining.
     */
    public Builder addLocationsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLocationsIsMutable();
      locations_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object admin_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of delegated administrator account used to perform
     * Active Directory operations. If not specified, `setupadmin` will be used.
     * </pre>
     *
     * <code>string admin = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The admin.
     */
    public java.lang.String getAdmin() {
      java.lang.Object ref = admin_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        admin_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of delegated administrator account used to perform
     * Active Directory operations. If not specified, `setupadmin` will be used.
     * </pre>
     *
     * <code>string admin = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for admin.
     */
    public com.google.protobuf.ByteString getAdminBytes() {
      java.lang.Object ref = admin_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        admin_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of delegated administrator account used to perform
     * Active Directory operations. If not specified, `setupadmin` will be used.
     * </pre>
     *
     * <code>string admin = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The admin to set.
     * @return This builder for chaining.
     */
    public Builder setAdmin(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      admin_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of delegated administrator account used to perform
     * Active Directory operations. If not specified, `setupadmin` will be used.
     * </pre>
     *
     * <code>string admin = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdmin() {
      admin_ = getDefaultInstance().getAdmin();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of delegated administrator account used to perform
     * Active Directory operations. If not specified, `setupadmin` will be used.
     * </pre>
     *
     * <code>string admin = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for admin to set.
     * @return This builder for chaining.
     */
    public Builder setAdminBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      admin_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object fqdn_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The fully-qualified domain name of the exposed domain used by
     * clients to connect to the service. Similar to what would be chosen for an
     * Active Directory set up on an internal network.
     * </pre>
     *
     * <code>string fqdn = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The fqdn.
     */
    public java.lang.String getFqdn() {
      java.lang.Object ref = fqdn_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fqdn_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The fully-qualified domain name of the exposed domain used by
     * clients to connect to the service. Similar to what would be chosen for an
     * Active Directory set up on an internal network.
     * </pre>
     *
     * <code>string fqdn = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for fqdn.
     */
    public com.google.protobuf.ByteString getFqdnBytes() {
      java.lang.Object ref = fqdn_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fqdn_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The fully-qualified domain name of the exposed domain used by
     * clients to connect to the service. Similar to what would be chosen for an
     * Active Directory set up on an internal network.
     * </pre>
     *
     * <code>string fqdn = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The fqdn to set.
     * @return This builder for chaining.
     */
    public Builder setFqdn(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fqdn_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The fully-qualified domain name of the exposed domain used by
     * clients to connect to the service. Similar to what would be chosen for an
     * Active Directory set up on an internal network.
     * </pre>
     *
     * <code>string fqdn = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFqdn() {
      fqdn_ = getDefaultInstance().getFqdn();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The fully-qualified domain name of the exposed domain used by
     * clients to connect to the service. Similar to what would be chosen for an
     * Active Directory set up on an internal network.
     * </pre>
     *
     * <code>string fqdn = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for fqdn to set.
     * @return This builder for chaining.
     */
    public Builder setFqdnBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fqdn_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of this domain.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Domain.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this domain.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Domain.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this domain.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Domain.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.managedidentities.v1.Domain.State getState() {
      com.google.cloud.managedidentities.v1.Domain.State result =
          com.google.cloud.managedidentities.v1.Domain.State.forNumber(state_);
      return result == null
          ? com.google.cloud.managedidentities.v1.Domain.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this domain.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Domain.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.managedidentities.v1.Domain.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of this domain.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Domain.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000200);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object statusMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current status of this
     * domain, if available.
     * </pre>
     *
     * <code>string status_message = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The statusMessage.
     */
    public java.lang.String getStatusMessage() {
      java.lang.Object ref = statusMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statusMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current status of this
     * domain, if available.
     * </pre>
     *
     * <code>string status_message = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for statusMessage.
     */
    public com.google.protobuf.ByteString getStatusMessageBytes() {
      java.lang.Object ref = statusMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statusMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current status of this
     * domain, if available.
     * </pre>
     *
     * <code>string status_message = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      statusMessage_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current status of this
     * domain, if available.
     * </pre>
     *
     * <code>string status_message = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatusMessage() {
      statusMessage_ = getDefaultInstance().getStatusMessage();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current status of this
     * domain, if available.
     * </pre>
     *
     * <code>string status_message = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      statusMessage_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.managedidentities.v1.Trust> trusts_ =
        java.util.Collections.emptyList();

    private void ensureTrustsIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        trusts_ = new java.util.ArrayList<com.google.cloud.managedidentities.v1.Trust>(trusts_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.managedidentities.v1.Trust,
            com.google.cloud.managedidentities.v1.Trust.Builder,
            com.google.cloud.managedidentities.v1.TrustOrBuilder>
        trustsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The current trusts associated with the domain.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.managedidentities.v1.Trust> getTrustsList() {
      if (trustsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(trusts_);
      } else {
        return trustsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The current trusts associated with the domain.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getTrustsCount() {
      if (trustsBuilder_ == null) {
        return trusts_.size();
      } else {
        return trustsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The current trusts associated with the domain.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.managedidentities.v1.Trust getTrusts(int index) {
      if (trustsBuilder_ == null) {
        return trusts_.get(index);
      } else {
        return trustsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The current trusts associated with the domain.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTrusts(int index, com.google.cloud.managedidentities.v1.Trust value) {
      if (trustsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrustsIsMutable();
        trusts_.set(index, value);
        onChanged();
      } else {
        trustsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current trusts associated with the domain.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTrusts(
        int index, com.google.cloud.managedidentities.v1.Trust.Builder builderForValue) {
      if (trustsBuilder_ == null) {
        ensureTrustsIsMutable();
        trusts_.set(index, builderForValue.build());
        onChanged();
      } else {
        trustsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current trusts associated with the domain.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTrusts(com.google.cloud.managedidentities.v1.Trust value) {
      if (trustsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrustsIsMutable();
        trusts_.add(value);
        onChanged();
      } else {
        trustsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current trusts associated with the domain.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTrusts(int index, com.google.cloud.managedidentities.v1.Trust value) {
      if (trustsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrustsIsMutable();
        trusts_.add(index, value);
        onChanged();
      } else {
        trustsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current trusts associated with the domain.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTrusts(com.google.cloud.managedidentities.v1.Trust.Builder builderForValue) {
      if (trustsBuilder_ == null) {
        ensureTrustsIsMutable();
        trusts_.add(builderForValue.build());
        onChanged();
      } else {
        trustsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current trusts associated with the domain.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTrusts(
        int index, com.google.cloud.managedidentities.v1.Trust.Builder builderForValue) {
      if (trustsBuilder_ == null) {
        ensureTrustsIsMutable();
        trusts_.add(index, builderForValue.build());
        onChanged();
      } else {
        trustsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current trusts associated with the domain.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllTrusts(
        java.lang.Iterable<? extends com.google.cloud.managedidentities.v1.Trust> values) {
      if (trustsBuilder_ == null) {
        ensureTrustsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, trusts_);
        onChanged();
      } else {
        trustsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current trusts associated with the domain.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTrusts() {
      if (trustsBuilder_ == null) {
        trusts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        trustsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current trusts associated with the domain.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeTrusts(int index) {
      if (trustsBuilder_ == null) {
        ensureTrustsIsMutable();
        trusts_.remove(index);
        onChanged();
      } else {
        trustsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current trusts associated with the domain.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.managedidentities.v1.Trust.Builder getTrustsBuilder(int index) {
      return getTrustsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The current trusts associated with the domain.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.managedidentities.v1.TrustOrBuilder getTrustsOrBuilder(int index) {
      if (trustsBuilder_ == null) {
        return trusts_.get(index);
      } else {
        return trustsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The current trusts associated with the domain.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.managedidentities.v1.TrustOrBuilder>
        getTrustsOrBuilderList() {
      if (trustsBuilder_ != null) {
        return trustsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(trusts_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The current trusts associated with the domain.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.managedidentities.v1.Trust.Builder addTrustsBuilder() {
      return getTrustsFieldBuilder()
          .addBuilder(com.google.cloud.managedidentities.v1.Trust.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The current trusts associated with the domain.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.managedidentities.v1.Trust.Builder addTrustsBuilder(int index) {
      return getTrustsFieldBuilder()
          .addBuilder(index, com.google.cloud.managedidentities.v1.Trust.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The current trusts associated with the domain.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.managedidentities.v1.Trust.Builder>
        getTrustsBuilderList() {
      return getTrustsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.managedidentities.v1.Trust,
            com.google.cloud.managedidentities.v1.Trust.Builder,
            com.google.cloud.managedidentities.v1.TrustOrBuilder>
        getTrustsFieldBuilder() {
      if (trustsBuilder_ == null) {
        trustsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.managedidentities.v1.Trust,
                com.google.cloud.managedidentities.v1.Trust.Builder,
                com.google.cloud.managedidentities.v1.TrustOrBuilder>(
                trusts_, ((bitField0_ & 0x00000800) != 0), getParentForChildren(), isClean());
        trusts_ = null;
      }
      return trustsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.managedidentities.v1.Domain)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.managedidentities.v1.Domain)
  private static final com.google.cloud.managedidentities.v1.Domain DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.managedidentities.v1.Domain();
  }

  public static com.google.cloud.managedidentities.v1.Domain getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Domain> PARSER =
      new com.google.protobuf.AbstractParser<Domain>() {
        @java.lang.Override
        public Domain parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Domain> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Domain> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.managedidentities.v1.Domain getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
