/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/managedidentities/v1/resource.proto

package com.google.cloud.managedidentities.v1;

public interface DomainOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.managedidentities.v1.Domain)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The unique name of the domain using the form:
   * `projects/{project_id}/locations/global/domains/{domain_name}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Required. The unique name of the domain using the form:
   * `projects/{project_id}/locations/global/domains/{domain_name}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Optional. Resource labels that can contain user-provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * Optional. Resource labels that can contain user-provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * Optional. Resource labels that can contain user-provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * Optional. Resource labels that can contain user-provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Optional. Resource labels that can contain user-provided metadata.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. The full names of the Google Compute Engine
   * [networks](/compute/docs/networks-and-firewalls#networks) the domain
   * instance is connected to. Networks can be added using UpdateDomain.
   * The domain is only available on networks listed in `authorized_networks`.
   * If CIDR subnets overlap between networks, domain creation will fail.
   * </pre>
   *
   * <code>repeated string authorized_networks = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the authorizedNetworks.
   */
  java.util.List<java.lang.String> getAuthorizedNetworksList();
  /**
   *
   *
   * <pre>
   * Optional. The full names of the Google Compute Engine
   * [networks](/compute/docs/networks-and-firewalls#networks) the domain
   * instance is connected to. Networks can be added using UpdateDomain.
   * The domain is only available on networks listed in `authorized_networks`.
   * If CIDR subnets overlap between networks, domain creation will fail.
   * </pre>
   *
   * <code>repeated string authorized_networks = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of authorizedNetworks.
   */
  int getAuthorizedNetworksCount();
  /**
   *
   *
   * <pre>
   * Optional. The full names of the Google Compute Engine
   * [networks](/compute/docs/networks-and-firewalls#networks) the domain
   * instance is connected to. Networks can be added using UpdateDomain.
   * The domain is only available on networks listed in `authorized_networks`.
   * If CIDR subnets overlap between networks, domain creation will fail.
   * </pre>
   *
   * <code>repeated string authorized_networks = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The authorizedNetworks at the given index.
   */
  java.lang.String getAuthorizedNetworks(int index);
  /**
   *
   *
   * <pre>
   * Optional. The full names of the Google Compute Engine
   * [networks](/compute/docs/networks-and-firewalls#networks) the domain
   * instance is connected to. Networks can be added using UpdateDomain.
   * The domain is only available on networks listed in `authorized_networks`.
   * If CIDR subnets overlap between networks, domain creation will fail.
   * </pre>
   *
   * <code>repeated string authorized_networks = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the authorizedNetworks at the given index.
   */
  com.google.protobuf.ByteString getAuthorizedNetworksBytes(int index);

  /**
   *
   *
   * <pre>
   * Required. The CIDR range of internal addresses that are reserved for this
   * domain. Reserved networks must be /24 or larger. Ranges must be
   * unique and non-overlapping with existing subnets in
   * [Domain].[authorized_networks].
   * </pre>
   *
   * <code>string reserved_ip_range = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The reservedIpRange.
   */
  java.lang.String getReservedIpRange();
  /**
   *
   *
   * <pre>
   * Required. The CIDR range of internal addresses that are reserved for this
   * domain. Reserved networks must be /24 or larger. Ranges must be
   * unique and non-overlapping with existing subnets in
   * [Domain].[authorized_networks].
   * </pre>
   *
   * <code>string reserved_ip_range = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for reservedIpRange.
   */
  com.google.protobuf.ByteString getReservedIpRangeBytes();

  /**
   *
   *
   * <pre>
   * Required. Locations where domain needs to be provisioned.
   * [regions][compute/docs/regions-zones/]
   * e.g. us-west1 or us-east4
   * Service supports up to 4 locations at once. Each location will use a /26
   * block.
   * </pre>
   *
   * <code>repeated string locations = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the locations.
   */
  java.util.List<java.lang.String> getLocationsList();
  /**
   *
   *
   * <pre>
   * Required. Locations where domain needs to be provisioned.
   * [regions][compute/docs/regions-zones/]
   * e.g. us-west1 or us-east4
   * Service supports up to 4 locations at once. Each location will use a /26
   * block.
   * </pre>
   *
   * <code>repeated string locations = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of locations.
   */
  int getLocationsCount();
  /**
   *
   *
   * <pre>
   * Required. Locations where domain needs to be provisioned.
   * [regions][compute/docs/regions-zones/]
   * e.g. us-west1 or us-east4
   * Service supports up to 4 locations at once. Each location will use a /26
   * block.
   * </pre>
   *
   * <code>repeated string locations = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The locations at the given index.
   */
  java.lang.String getLocations(int index);
  /**
   *
   *
   * <pre>
   * Required. Locations where domain needs to be provisioned.
   * [regions][compute/docs/regions-zones/]
   * e.g. us-west1 or us-east4
   * Service supports up to 4 locations at once. Each location will use a /26
   * block.
   * </pre>
   *
   * <code>repeated string locations = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the locations at the given index.
   */
  com.google.protobuf.ByteString getLocationsBytes(int index);

  /**
   *
   *
   * <pre>
   * Optional. The name of delegated administrator account used to perform
   * Active Directory operations. If not specified, `setupadmin` will be used.
   * </pre>
   *
   * <code>string admin = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The admin.
   */
  java.lang.String getAdmin();
  /**
   *
   *
   * <pre>
   * Optional. The name of delegated administrator account used to perform
   * Active Directory operations. If not specified, `setupadmin` will be used.
   * </pre>
   *
   * <code>string admin = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for admin.
   */
  com.google.protobuf.ByteString getAdminBytes();

  /**
   *
   *
   * <pre>
   * Output only. The fully-qualified domain name of the exposed domain used by
   * clients to connect to the service. Similar to what would be chosen for an
   * Active Directory set up on an internal network.
   * </pre>
   *
   * <code>string fqdn = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The fqdn.
   */
  java.lang.String getFqdn();
  /**
   *
   *
   * <pre>
   * Output only. The fully-qualified domain name of the exposed domain used by
   * clients to connect to the service. Similar to what would be chosen for an
   * Active Directory set up on an internal network.
   * </pre>
   *
   * <code>string fqdn = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for fqdn.
   */
  com.google.protobuf.ByteString getFqdnBytes();

  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The last update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The last update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The last update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The current state of this domain.
   * </pre>
   *
   * <code>
   * .google.cloud.managedidentities.v1.Domain.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. The current state of this domain.
   * </pre>
   *
   * <code>
   * .google.cloud.managedidentities.v1.Domain.State state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.cloud.managedidentities.v1.Domain.State getState();

  /**
   *
   *
   * <pre>
   * Output only. Additional information about the current status of this
   * domain, if available.
   * </pre>
   *
   * <code>string status_message = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The statusMessage.
   */
  java.lang.String getStatusMessage();
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the current status of this
   * domain, if available.
   * </pre>
   *
   * <code>string status_message = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for statusMessage.
   */
  com.google.protobuf.ByteString getStatusMessageBytes();

  /**
   *
   *
   * <pre>
   * Output only. The current trusts associated with the domain.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.managedidentities.v1.Trust> getTrustsList();
  /**
   *
   *
   * <pre>
   * Output only. The current trusts associated with the domain.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.managedidentities.v1.Trust getTrusts(int index);
  /**
   *
   *
   * <pre>
   * Output only. The current trusts associated with the domain.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getTrustsCount();
  /**
   *
   *
   * <pre>
   * Output only. The current trusts associated with the domain.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.managedidentities.v1.TrustOrBuilder>
      getTrustsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Output only. The current trusts associated with the domain.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.managedidentities.v1.Trust trusts = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.managedidentities.v1.TrustOrBuilder getTrustsOrBuilder(int index);
}
