/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/managedidentities/v1/resource.proto

package com.google.cloud.managedidentities.v1;

/**
 *
 *
 * <pre>
 * Represents a relationship between two domains. This allows a controller in
 * one domain to authenticate a user in another domain.
 * </pre>
 *
 * Protobuf type {@code google.cloud.managedidentities.v1.Trust}
 */
public final class Trust extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.managedidentities.v1.Trust)
    TrustOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Trust.newBuilder() to construct.
  private Trust(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Trust() {
    targetDomainName_ = "";
    trustType_ = 0;
    trustDirection_ = 0;
    targetDnsIpAddresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
    trustHandshakeSecret_ = "";
    state_ = 0;
    stateDescription_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Trust();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.managedidentities.v1.ResourceProto
        .internal_static_google_cloud_managedidentities_v1_Trust_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.managedidentities.v1.ResourceProto
        .internal_static_google_cloud_managedidentities_v1_Trust_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.managedidentities.v1.Trust.class,
            com.google.cloud.managedidentities.v1.Trust.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents the different states of a domain trust.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.managedidentities.v1.Trust.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The domain trust is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The domain trust is being updated.
     * </pre>
     *
     * <code>UPDATING = 2;</code>
     */
    UPDATING(2),
    /**
     *
     *
     * <pre>
     * The domain trust is being deleted.
     * </pre>
     *
     * <code>DELETING = 3;</code>
     */
    DELETING(3),
    /**
     *
     *
     * <pre>
     * The domain trust is connected.
     * </pre>
     *
     * <code>CONNECTED = 4;</code>
     */
    CONNECTED(4),
    /**
     *
     *
     * <pre>
     * The domain trust is disconnected.
     * </pre>
     *
     * <code>DISCONNECTED = 5;</code>
     */
    DISCONNECTED(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The domain trust is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The domain trust is being updated.
     * </pre>
     *
     * <code>UPDATING = 2;</code>
     */
    public static final int UPDATING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The domain trust is being deleted.
     * </pre>
     *
     * <code>DELETING = 3;</code>
     */
    public static final int DELETING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The domain trust is connected.
     * </pre>
     *
     * <code>CONNECTED = 4;</code>
     */
    public static final int CONNECTED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The domain trust is disconnected.
     * </pre>
     *
     * <code>DISCONNECTED = 5;</code>
     */
    public static final int DISCONNECTED_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return UPDATING;
        case 3:
          return DELETING;
        case 4:
          return CONNECTED;
        case 5:
          return DISCONNECTED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.managedidentities.v1.Trust.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.managedidentities.v1.Trust.State)
  }

  /**
   *
   *
   * <pre>
   * Represents the different inter-forest trust types.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.managedidentities.v1.Trust.TrustType}
   */
  public enum TrustType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>TRUST_TYPE_UNSPECIFIED = 0;</code>
     */
    TRUST_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The forest trust.
     * </pre>
     *
     * <code>FOREST = 1;</code>
     */
    FOREST(1),
    /**
     *
     *
     * <pre>
     * The external domain trust.
     * </pre>
     *
     * <code>EXTERNAL = 2;</code>
     */
    EXTERNAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>TRUST_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TRUST_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The forest trust.
     * </pre>
     *
     * <code>FOREST = 1;</code>
     */
    public static final int FOREST_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The external domain trust.
     * </pre>
     *
     * <code>EXTERNAL = 2;</code>
     */
    public static final int EXTERNAL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TrustType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TrustType forNumber(int value) {
      switch (value) {
        case 0:
          return TRUST_TYPE_UNSPECIFIED;
        case 1:
          return FOREST;
        case 2:
          return EXTERNAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TrustType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TrustType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TrustType>() {
          public TrustType findValueByNumber(int number) {
            return TrustType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.managedidentities.v1.Trust.getDescriptor().getEnumTypes().get(1);
    }

    private static final TrustType[] VALUES = values();

    public static TrustType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TrustType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.managedidentities.v1.Trust.TrustType)
  }

  /**
   *
   *
   * <pre>
   * Represents the direction of trust.
   * See
   * [System.DirectoryServices.ActiveDirectory.TrustDirection](https://docs.microsoft.com/en-us/dotnet/api/system.directoryservices.activedirectory.trustdirection?view=netframework-4.7.2)
   * for more information.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.managedidentities.v1.Trust.TrustDirection}
   */
  public enum TrustDirection implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>TRUST_DIRECTION_UNSPECIFIED = 0;</code>
     */
    TRUST_DIRECTION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The inbound direction represents the trusting side.
     * </pre>
     *
     * <code>INBOUND = 1;</code>
     */
    INBOUND(1),
    /**
     *
     *
     * <pre>
     * The outboud direction represents the trusted side.
     * </pre>
     *
     * <code>OUTBOUND = 2;</code>
     */
    OUTBOUND(2),
    /**
     *
     *
     * <pre>
     * The bidirectional direction represents the trusted / trusting side.
     * </pre>
     *
     * <code>BIDIRECTIONAL = 3;</code>
     */
    BIDIRECTIONAL(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>TRUST_DIRECTION_UNSPECIFIED = 0;</code>
     */
    public static final int TRUST_DIRECTION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The inbound direction represents the trusting side.
     * </pre>
     *
     * <code>INBOUND = 1;</code>
     */
    public static final int INBOUND_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The outboud direction represents the trusted side.
     * </pre>
     *
     * <code>OUTBOUND = 2;</code>
     */
    public static final int OUTBOUND_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The bidirectional direction represents the trusted / trusting side.
     * </pre>
     *
     * <code>BIDIRECTIONAL = 3;</code>
     */
    public static final int BIDIRECTIONAL_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TrustDirection valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TrustDirection forNumber(int value) {
      switch (value) {
        case 0:
          return TRUST_DIRECTION_UNSPECIFIED;
        case 1:
          return INBOUND;
        case 2:
          return OUTBOUND;
        case 3:
          return BIDIRECTIONAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TrustDirection> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TrustDirection> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TrustDirection>() {
          public TrustDirection findValueByNumber(int number) {
            return TrustDirection.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.managedidentities.v1.Trust.getDescriptor().getEnumTypes().get(2);
    }

    private static final TrustDirection[] VALUES = values();

    public static TrustDirection valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TrustDirection(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.managedidentities.v1.Trust.TrustDirection)
  }

  public static final int TARGET_DOMAIN_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetDomainName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The fully qualified target domain name which will be in trust with the
   * current domain.
   * </pre>
   *
   * <code>string target_domain_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The targetDomainName.
   */
  @java.lang.Override
  public java.lang.String getTargetDomainName() {
    java.lang.Object ref = targetDomainName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetDomainName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The fully qualified target domain name which will be in trust with the
   * current domain.
   * </pre>
   *
   * <code>string target_domain_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for targetDomainName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetDomainNameBytes() {
    java.lang.Object ref = targetDomainName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetDomainName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRUST_TYPE_FIELD_NUMBER = 2;
  private int trustType_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The type of trust represented by the trust resource.
   * </pre>
   *
   * <code>
   * .google.cloud.managedidentities.v1.Trust.TrustType trust_type = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for trustType.
   */
  @java.lang.Override
  public int getTrustTypeValue() {
    return trustType_;
  }
  /**
   *
   *
   * <pre>
   * Required. The type of trust represented by the trust resource.
   * </pre>
   *
   * <code>
   * .google.cloud.managedidentities.v1.Trust.TrustType trust_type = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The trustType.
   */
  @java.lang.Override
  public com.google.cloud.managedidentities.v1.Trust.TrustType getTrustType() {
    com.google.cloud.managedidentities.v1.Trust.TrustType result =
        com.google.cloud.managedidentities.v1.Trust.TrustType.forNumber(trustType_);
    return result == null
        ? com.google.cloud.managedidentities.v1.Trust.TrustType.UNRECOGNIZED
        : result;
  }

  public static final int TRUST_DIRECTION_FIELD_NUMBER = 3;
  private int trustDirection_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The trust direction, which decides if the current domain is trusted,
   * trusting, or both.
   * </pre>
   *
   * <code>
   * .google.cloud.managedidentities.v1.Trust.TrustDirection trust_direction = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for trustDirection.
   */
  @java.lang.Override
  public int getTrustDirectionValue() {
    return trustDirection_;
  }
  /**
   *
   *
   * <pre>
   * Required. The trust direction, which decides if the current domain is trusted,
   * trusting, or both.
   * </pre>
   *
   * <code>
   * .google.cloud.managedidentities.v1.Trust.TrustDirection trust_direction = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The trustDirection.
   */
  @java.lang.Override
  public com.google.cloud.managedidentities.v1.Trust.TrustDirection getTrustDirection() {
    com.google.cloud.managedidentities.v1.Trust.TrustDirection result =
        com.google.cloud.managedidentities.v1.Trust.TrustDirection.forNumber(trustDirection_);
    return result == null
        ? com.google.cloud.managedidentities.v1.Trust.TrustDirection.UNRECOGNIZED
        : result;
  }

  public static final int SELECTIVE_AUTHENTICATION_FIELD_NUMBER = 4;
  private boolean selectiveAuthentication_ = false;
  /**
   *
   *
   * <pre>
   * Optional. The trust authentication type, which decides whether the trusted side has
   * forest/domain wide access or selective access to an approved set of
   * resources.
   * </pre>
   *
   * <code>bool selective_authentication = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The selectiveAuthentication.
   */
  @java.lang.Override
  public boolean getSelectiveAuthentication() {
    return selectiveAuthentication_;
  }

  public static final int TARGET_DNS_IP_ADDRESSES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList targetDnsIpAddresses_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Required. The target DNS server IP addresses which can resolve the remote domain
   * involved in the trust.
   * </pre>
   *
   * <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return A list containing the targetDnsIpAddresses.
   */
  public com.google.protobuf.ProtocolStringList getTargetDnsIpAddressesList() {
    return targetDnsIpAddresses_;
  }
  /**
   *
   *
   * <pre>
   * Required. The target DNS server IP addresses which can resolve the remote domain
   * involved in the trust.
   * </pre>
   *
   * <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The count of targetDnsIpAddresses.
   */
  public int getTargetDnsIpAddressesCount() {
    return targetDnsIpAddresses_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The target DNS server IP addresses which can resolve the remote domain
   * involved in the trust.
   * </pre>
   *
   * <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The targetDnsIpAddresses at the given index.
   */
  public java.lang.String getTargetDnsIpAddresses(int index) {
    return targetDnsIpAddresses_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The target DNS server IP addresses which can resolve the remote domain
   * involved in the trust.
   * </pre>
   *
   * <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the targetDnsIpAddresses at the given index.
   */
  public com.google.protobuf.ByteString getTargetDnsIpAddressesBytes(int index) {
    return targetDnsIpAddresses_.getByteString(index);
  }

  public static final int TRUST_HANDSHAKE_SECRET_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object trustHandshakeSecret_ = "";
  /**
   *
   *
   * <pre>
   * Required. The trust secret used for the handshake with the target domain. This will
   * not be stored.
   * </pre>
   *
   * <code>string trust_handshake_secret = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The trustHandshakeSecret.
   */
  @java.lang.Override
  public java.lang.String getTrustHandshakeSecret() {
    java.lang.Object ref = trustHandshakeSecret_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      trustHandshakeSecret_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The trust secret used for the handshake with the target domain. This will
   * not be stored.
   * </pre>
   *
   * <code>string trust_handshake_secret = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for trustHandshakeSecret.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTrustHandshakeSecretBytes() {
    java.lang.Object ref = trustHandshakeSecret_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      trustHandshakeSecret_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int STATE_FIELD_NUMBER = 9;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The current state of the trust.
   * </pre>
   *
   * <code>
   * .google.cloud.managedidentities.v1.Trust.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The current state of the trust.
   * </pre>
   *
   * <code>
   * .google.cloud.managedidentities.v1.Trust.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.managedidentities.v1.Trust.State getState() {
    com.google.cloud.managedidentities.v1.Trust.State result =
        com.google.cloud.managedidentities.v1.Trust.State.forNumber(state_);
    return result == null ? com.google.cloud.managedidentities.v1.Trust.State.UNRECOGNIZED : result;
  }

  public static final int STATE_DESCRIPTION_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stateDescription_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the current state of the trust, if available.
   * </pre>
   *
   * <code>string state_description = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stateDescription.
   */
  @java.lang.Override
  public java.lang.String getStateDescription() {
    java.lang.Object ref = stateDescription_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stateDescription_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the current state of the trust, if available.
   * </pre>
   *
   * <code>string state_description = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for stateDescription.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateDescriptionBytes() {
    java.lang.Object ref = stateDescription_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stateDescription_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LAST_TRUST_HEARTBEAT_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp lastTrustHeartbeatTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last heartbeat time when the trust was known to be connected.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_trust_heartbeat_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastTrustHeartbeatTime field is set.
   */
  @java.lang.Override
  public boolean hasLastTrustHeartbeatTime() {
    return lastTrustHeartbeatTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last heartbeat time when the trust was known to be connected.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_trust_heartbeat_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastTrustHeartbeatTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastTrustHeartbeatTime() {
    return lastTrustHeartbeatTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastTrustHeartbeatTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last heartbeat time when the trust was known to be connected.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_trust_heartbeat_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastTrustHeartbeatTimeOrBuilder() {
    return lastTrustHeartbeatTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastTrustHeartbeatTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetDomainName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, targetDomainName_);
    }
    if (trustType_
        != com.google.cloud.managedidentities.v1.Trust.TrustType.TRUST_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, trustType_);
    }
    if (trustDirection_
        != com.google.cloud.managedidentities.v1.Trust.TrustDirection.TRUST_DIRECTION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, trustDirection_);
    }
    if (selectiveAuthentication_ != false) {
      output.writeBool(4, selectiveAuthentication_);
    }
    for (int i = 0; i < targetDnsIpAddresses_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 5, targetDnsIpAddresses_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trustHandshakeSecret_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, trustHandshakeSecret_);
    }
    if (createTime_ != null) {
      output.writeMessage(7, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(8, getUpdateTime());
    }
    if (state_ != com.google.cloud.managedidentities.v1.Trust.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(9, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateDescription_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, stateDescription_);
    }
    if (lastTrustHeartbeatTime_ != null) {
      output.writeMessage(12, getLastTrustHeartbeatTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetDomainName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, targetDomainName_);
    }
    if (trustType_
        != com.google.cloud.managedidentities.v1.Trust.TrustType.TRUST_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, trustType_);
    }
    if (trustDirection_
        != com.google.cloud.managedidentities.v1.Trust.TrustDirection.TRUST_DIRECTION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, trustDirection_);
    }
    if (selectiveAuthentication_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, selectiveAuthentication_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < targetDnsIpAddresses_.size(); i++) {
        dataSize += computeStringSizeNoTag(targetDnsIpAddresses_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTargetDnsIpAddressesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(trustHandshakeSecret_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, trustHandshakeSecret_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getUpdateTime());
    }
    if (state_ != com.google.cloud.managedidentities.v1.Trust.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateDescription_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, stateDescription_);
    }
    if (lastTrustHeartbeatTime_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(12, getLastTrustHeartbeatTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.managedidentities.v1.Trust)) {
      return super.equals(obj);
    }
    com.google.cloud.managedidentities.v1.Trust other =
        (com.google.cloud.managedidentities.v1.Trust) obj;

    if (!getTargetDomainName().equals(other.getTargetDomainName())) return false;
    if (trustType_ != other.trustType_) return false;
    if (trustDirection_ != other.trustDirection_) return false;
    if (getSelectiveAuthentication() != other.getSelectiveAuthentication()) return false;
    if (!getTargetDnsIpAddressesList().equals(other.getTargetDnsIpAddressesList())) return false;
    if (!getTrustHandshakeSecret().equals(other.getTrustHandshakeSecret())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getStateDescription().equals(other.getStateDescription())) return false;
    if (hasLastTrustHeartbeatTime() != other.hasLastTrustHeartbeatTime()) return false;
    if (hasLastTrustHeartbeatTime()) {
      if (!getLastTrustHeartbeatTime().equals(other.getLastTrustHeartbeatTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TARGET_DOMAIN_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getTargetDomainName().hashCode();
    hash = (37 * hash) + TRUST_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + trustType_;
    hash = (37 * hash) + TRUST_DIRECTION_FIELD_NUMBER;
    hash = (53 * hash) + trustDirection_;
    hash = (37 * hash) + SELECTIVE_AUTHENTICATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSelectiveAuthentication());
    if (getTargetDnsIpAddressesCount() > 0) {
      hash = (37 * hash) + TARGET_DNS_IP_ADDRESSES_FIELD_NUMBER;
      hash = (53 * hash) + getTargetDnsIpAddressesList().hashCode();
    }
    hash = (37 * hash) + TRUST_HANDSHAKE_SECRET_FIELD_NUMBER;
    hash = (53 * hash) + getTrustHandshakeSecret().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + STATE_DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getStateDescription().hashCode();
    if (hasLastTrustHeartbeatTime()) {
      hash = (37 * hash) + LAST_TRUST_HEARTBEAT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastTrustHeartbeatTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.managedidentities.v1.Trust parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.managedidentities.v1.Trust parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.managedidentities.v1.Trust parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.managedidentities.v1.Trust parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.managedidentities.v1.Trust parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.managedidentities.v1.Trust parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.managedidentities.v1.Trust parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.managedidentities.v1.Trust parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.managedidentities.v1.Trust parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.managedidentities.v1.Trust parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.managedidentities.v1.Trust parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.managedidentities.v1.Trust parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.managedidentities.v1.Trust prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a relationship between two domains. This allows a controller in
   * one domain to authenticate a user in another domain.
   * </pre>
   *
   * Protobuf type {@code google.cloud.managedidentities.v1.Trust}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.managedidentities.v1.Trust)
      com.google.cloud.managedidentities.v1.TrustOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.managedidentities.v1.ResourceProto
          .internal_static_google_cloud_managedidentities_v1_Trust_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.managedidentities.v1.ResourceProto
          .internal_static_google_cloud_managedidentities_v1_Trust_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.managedidentities.v1.Trust.class,
              com.google.cloud.managedidentities.v1.Trust.Builder.class);
    }

    // Construct using com.google.cloud.managedidentities.v1.Trust.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      targetDomainName_ = "";
      trustType_ = 0;
      trustDirection_ = 0;
      selectiveAuthentication_ = false;
      targetDnsIpAddresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      trustHandshakeSecret_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      state_ = 0;
      stateDescription_ = "";
      lastTrustHeartbeatTime_ = null;
      if (lastTrustHeartbeatTimeBuilder_ != null) {
        lastTrustHeartbeatTimeBuilder_.dispose();
        lastTrustHeartbeatTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.managedidentities.v1.ResourceProto
          .internal_static_google_cloud_managedidentities_v1_Trust_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.managedidentities.v1.Trust getDefaultInstanceForType() {
      return com.google.cloud.managedidentities.v1.Trust.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.managedidentities.v1.Trust build() {
      com.google.cloud.managedidentities.v1.Trust result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.managedidentities.v1.Trust buildPartial() {
      com.google.cloud.managedidentities.v1.Trust result =
          new com.google.cloud.managedidentities.v1.Trust(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.managedidentities.v1.Trust result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.targetDomainName_ = targetDomainName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.trustType_ = trustType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.trustDirection_ = trustDirection_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.selectiveAuthentication_ = selectiveAuthentication_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        targetDnsIpAddresses_.makeImmutable();
        result.targetDnsIpAddresses_ = targetDnsIpAddresses_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.trustHandshakeSecret_ = trustHandshakeSecret_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.stateDescription_ = stateDescription_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.lastTrustHeartbeatTime_ =
            lastTrustHeartbeatTimeBuilder_ == null
                ? lastTrustHeartbeatTime_
                : lastTrustHeartbeatTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.managedidentities.v1.Trust) {
        return mergeFrom((com.google.cloud.managedidentities.v1.Trust) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.managedidentities.v1.Trust other) {
      if (other == com.google.cloud.managedidentities.v1.Trust.getDefaultInstance()) return this;
      if (!other.getTargetDomainName().isEmpty()) {
        targetDomainName_ = other.targetDomainName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.trustType_ != 0) {
        setTrustTypeValue(other.getTrustTypeValue());
      }
      if (other.trustDirection_ != 0) {
        setTrustDirectionValue(other.getTrustDirectionValue());
      }
      if (other.getSelectiveAuthentication() != false) {
        setSelectiveAuthentication(other.getSelectiveAuthentication());
      }
      if (!other.targetDnsIpAddresses_.isEmpty()) {
        if (targetDnsIpAddresses_.isEmpty()) {
          targetDnsIpAddresses_ = other.targetDnsIpAddresses_;
          bitField0_ |= 0x00000010;
        } else {
          ensureTargetDnsIpAddressesIsMutable();
          targetDnsIpAddresses_.addAll(other.targetDnsIpAddresses_);
        }
        onChanged();
      }
      if (!other.getTrustHandshakeSecret().isEmpty()) {
        trustHandshakeSecret_ = other.trustHandshakeSecret_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getStateDescription().isEmpty()) {
        stateDescription_ = other.stateDescription_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasLastTrustHeartbeatTime()) {
        mergeLastTrustHeartbeatTime(other.getLastTrustHeartbeatTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                targetDomainName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                trustType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                trustDirection_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                selectiveAuthentication_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTargetDnsIpAddressesIsMutable();
                targetDnsIpAddresses_.add(s);
                break;
              } // case 42
            case 50:
              {
                trustHandshakeSecret_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 72:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 90:
              {
                stateDescription_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getLastTrustHeartbeatTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object targetDomainName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The fully qualified target domain name which will be in trust with the
     * current domain.
     * </pre>
     *
     * <code>string target_domain_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The targetDomainName.
     */
    public java.lang.String getTargetDomainName() {
      java.lang.Object ref = targetDomainName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetDomainName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified target domain name which will be in trust with the
     * current domain.
     * </pre>
     *
     * <code>string target_domain_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for targetDomainName.
     */
    public com.google.protobuf.ByteString getTargetDomainNameBytes() {
      java.lang.Object ref = targetDomainName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetDomainName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified target domain name which will be in trust with the
     * current domain.
     * </pre>
     *
     * <code>string target_domain_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The targetDomainName to set.
     * @return This builder for chaining.
     */
    public Builder setTargetDomainName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetDomainName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified target domain name which will be in trust with the
     * current domain.
     * </pre>
     *
     * <code>string target_domain_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetDomainName() {
      targetDomainName_ = getDefaultInstance().getTargetDomainName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The fully qualified target domain name which will be in trust with the
     * current domain.
     * </pre>
     *
     * <code>string target_domain_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for targetDomainName to set.
     * @return This builder for chaining.
     */
    public Builder setTargetDomainNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetDomainName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int trustType_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The type of trust represented by the trust resource.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Trust.TrustType trust_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for trustType.
     */
    @java.lang.Override
    public int getTrustTypeValue() {
      return trustType_;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of trust represented by the trust resource.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Trust.TrustType trust_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for trustType to set.
     * @return This builder for chaining.
     */
    public Builder setTrustTypeValue(int value) {
      trustType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of trust represented by the trust resource.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Trust.TrustType trust_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The trustType.
     */
    @java.lang.Override
    public com.google.cloud.managedidentities.v1.Trust.TrustType getTrustType() {
      com.google.cloud.managedidentities.v1.Trust.TrustType result =
          com.google.cloud.managedidentities.v1.Trust.TrustType.forNumber(trustType_);
      return result == null
          ? com.google.cloud.managedidentities.v1.Trust.TrustType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of trust represented by the trust resource.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Trust.TrustType trust_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The trustType to set.
     * @return This builder for chaining.
     */
    public Builder setTrustType(com.google.cloud.managedidentities.v1.Trust.TrustType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      trustType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of trust represented by the trust resource.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Trust.TrustType trust_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrustType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      trustType_ = 0;
      onChanged();
      return this;
    }

    private int trustDirection_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The trust direction, which decides if the current domain is trusted,
     * trusting, or both.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Trust.TrustDirection trust_direction = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for trustDirection.
     */
    @java.lang.Override
    public int getTrustDirectionValue() {
      return trustDirection_;
    }
    /**
     *
     *
     * <pre>
     * Required. The trust direction, which decides if the current domain is trusted,
     * trusting, or both.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Trust.TrustDirection trust_direction = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for trustDirection to set.
     * @return This builder for chaining.
     */
    public Builder setTrustDirectionValue(int value) {
      trustDirection_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The trust direction, which decides if the current domain is trusted,
     * trusting, or both.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Trust.TrustDirection trust_direction = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The trustDirection.
     */
    @java.lang.Override
    public com.google.cloud.managedidentities.v1.Trust.TrustDirection getTrustDirection() {
      com.google.cloud.managedidentities.v1.Trust.TrustDirection result =
          com.google.cloud.managedidentities.v1.Trust.TrustDirection.forNumber(trustDirection_);
      return result == null
          ? com.google.cloud.managedidentities.v1.Trust.TrustDirection.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The trust direction, which decides if the current domain is trusted,
     * trusting, or both.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Trust.TrustDirection trust_direction = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The trustDirection to set.
     * @return This builder for chaining.
     */
    public Builder setTrustDirection(
        com.google.cloud.managedidentities.v1.Trust.TrustDirection value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      trustDirection_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The trust direction, which decides if the current domain is trusted,
     * trusting, or both.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Trust.TrustDirection trust_direction = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrustDirection() {
      bitField0_ = (bitField0_ & ~0x00000004);
      trustDirection_ = 0;
      onChanged();
      return this;
    }

    private boolean selectiveAuthentication_;
    /**
     *
     *
     * <pre>
     * Optional. The trust authentication type, which decides whether the trusted side has
     * forest/domain wide access or selective access to an approved set of
     * resources.
     * </pre>
     *
     * <code>bool selective_authentication = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The selectiveAuthentication.
     */
    @java.lang.Override
    public boolean getSelectiveAuthentication() {
      return selectiveAuthentication_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The trust authentication type, which decides whether the trusted side has
     * forest/domain wide access or selective access to an approved set of
     * resources.
     * </pre>
     *
     * <code>bool selective_authentication = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The selectiveAuthentication to set.
     * @return This builder for chaining.
     */
    public Builder setSelectiveAuthentication(boolean value) {

      selectiveAuthentication_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The trust authentication type, which decides whether the trusted side has
     * forest/domain wide access or selective access to an approved set of
     * resources.
     * </pre>
     *
     * <code>bool selective_authentication = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelectiveAuthentication() {
      bitField0_ = (bitField0_ & ~0x00000008);
      selectiveAuthentication_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList targetDnsIpAddresses_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTargetDnsIpAddressesIsMutable() {
      if (!targetDnsIpAddresses_.isModifiable()) {
        targetDnsIpAddresses_ = new com.google.protobuf.LazyStringArrayList(targetDnsIpAddresses_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Required. The target DNS server IP addresses which can resolve the remote domain
     * involved in the trust.
     * </pre>
     *
     * <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return A list containing the targetDnsIpAddresses.
     */
    public com.google.protobuf.ProtocolStringList getTargetDnsIpAddressesList() {
      targetDnsIpAddresses_.makeImmutable();
      return targetDnsIpAddresses_;
    }
    /**
     *
     *
     * <pre>
     * Required. The target DNS server IP addresses which can resolve the remote domain
     * involved in the trust.
     * </pre>
     *
     * <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The count of targetDnsIpAddresses.
     */
    public int getTargetDnsIpAddressesCount() {
      return targetDnsIpAddresses_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The target DNS server IP addresses which can resolve the remote domain
     * involved in the trust.
     * </pre>
     *
     * <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The targetDnsIpAddresses at the given index.
     */
    public java.lang.String getTargetDnsIpAddresses(int index) {
      return targetDnsIpAddresses_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The target DNS server IP addresses which can resolve the remote domain
     * involved in the trust.
     * </pre>
     *
     * <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the targetDnsIpAddresses at the given index.
     */
    public com.google.protobuf.ByteString getTargetDnsIpAddressesBytes(int index) {
      return targetDnsIpAddresses_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The target DNS server IP addresses which can resolve the remote domain
     * involved in the trust.
     * </pre>
     *
     * <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The targetDnsIpAddresses to set.
     * @return This builder for chaining.
     */
    public Builder setTargetDnsIpAddresses(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetDnsIpAddressesIsMutable();
      targetDnsIpAddresses_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The target DNS server IP addresses which can resolve the remote domain
     * involved in the trust.
     * </pre>
     *
     * <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The targetDnsIpAddresses to add.
     * @return This builder for chaining.
     */
    public Builder addTargetDnsIpAddresses(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetDnsIpAddressesIsMutable();
      targetDnsIpAddresses_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The target DNS server IP addresses which can resolve the remote domain
     * involved in the trust.
     * </pre>
     *
     * <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param values The targetDnsIpAddresses to add.
     * @return This builder for chaining.
     */
    public Builder addAllTargetDnsIpAddresses(java.lang.Iterable<java.lang.String> values) {
      ensureTargetDnsIpAddressesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targetDnsIpAddresses_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The target DNS server IP addresses which can resolve the remote domain
     * involved in the trust.
     * </pre>
     *
     * <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetDnsIpAddresses() {
      targetDnsIpAddresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The target DNS server IP addresses which can resolve the remote domain
     * involved in the trust.
     * </pre>
     *
     * <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The bytes of the targetDnsIpAddresses to add.
     * @return This builder for chaining.
     */
    public Builder addTargetDnsIpAddressesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTargetDnsIpAddressesIsMutable();
      targetDnsIpAddresses_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object trustHandshakeSecret_ = "";
    /**
     *
     *
     * <pre>
     * Required. The trust secret used for the handshake with the target domain. This will
     * not be stored.
     * </pre>
     *
     * <code>string trust_handshake_secret = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The trustHandshakeSecret.
     */
    public java.lang.String getTrustHandshakeSecret() {
      java.lang.Object ref = trustHandshakeSecret_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        trustHandshakeSecret_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The trust secret used for the handshake with the target domain. This will
     * not be stored.
     * </pre>
     *
     * <code>string trust_handshake_secret = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for trustHandshakeSecret.
     */
    public com.google.protobuf.ByteString getTrustHandshakeSecretBytes() {
      java.lang.Object ref = trustHandshakeSecret_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        trustHandshakeSecret_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The trust secret used for the handshake with the target domain. This will
     * not be stored.
     * </pre>
     *
     * <code>string trust_handshake_secret = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The trustHandshakeSecret to set.
     * @return This builder for chaining.
     */
    public Builder setTrustHandshakeSecret(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      trustHandshakeSecret_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The trust secret used for the handshake with the target domain. This will
     * not be stored.
     * </pre>
     *
     * <code>string trust_handshake_secret = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrustHandshakeSecret() {
      trustHandshakeSecret_ = getDefaultInstance().getTrustHandshakeSecret();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The trust secret used for the handshake with the target domain. This will
     * not be stored.
     * </pre>
     *
     * <code>string trust_handshake_secret = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for trustHandshakeSecret to set.
     * @return This builder for chaining.
     */
    public Builder setTrustHandshakeSecretBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      trustHandshakeSecret_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The current state of the trust.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Trust.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the trust.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Trust.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the trust.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Trust.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.managedidentities.v1.Trust.State getState() {
      com.google.cloud.managedidentities.v1.Trust.State result =
          com.google.cloud.managedidentities.v1.Trust.State.forNumber(state_);
      return result == null
          ? com.google.cloud.managedidentities.v1.Trust.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the trust.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Trust.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.managedidentities.v1.Trust.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The current state of the trust.
     * </pre>
     *
     * <code>
     * .google.cloud.managedidentities.v1.Trust.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000100);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object stateDescription_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of the trust, if available.
     * </pre>
     *
     * <code>string state_description = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateDescription.
     */
    public java.lang.String getStateDescription() {
      java.lang.Object ref = stateDescription_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateDescription_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of the trust, if available.
     * </pre>
     *
     * <code>string state_description = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateDescription.
     */
    public com.google.protobuf.ByteString getStateDescriptionBytes() {
      java.lang.Object ref = stateDescription_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateDescription_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of the trust, if available.
     * </pre>
     *
     * <code>string state_description = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The stateDescription to set.
     * @return This builder for chaining.
     */
    public Builder setStateDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stateDescription_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of the trust, if available.
     * </pre>
     *
     * <code>string state_description = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateDescription() {
      stateDescription_ = getDefaultInstance().getStateDescription();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the current state of the trust, if available.
     * </pre>
     *
     * <code>string state_description = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for stateDescription to set.
     * @return This builder for chaining.
     */
    public Builder setStateDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stateDescription_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp lastTrustHeartbeatTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastTrustHeartbeatTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last heartbeat time when the trust was known to be connected.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_trust_heartbeat_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastTrustHeartbeatTime field is set.
     */
    public boolean hasLastTrustHeartbeatTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last heartbeat time when the trust was known to be connected.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_trust_heartbeat_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastTrustHeartbeatTime.
     */
    public com.google.protobuf.Timestamp getLastTrustHeartbeatTime() {
      if (lastTrustHeartbeatTimeBuilder_ == null) {
        return lastTrustHeartbeatTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastTrustHeartbeatTime_;
      } else {
        return lastTrustHeartbeatTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last heartbeat time when the trust was known to be connected.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_trust_heartbeat_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastTrustHeartbeatTime(com.google.protobuf.Timestamp value) {
      if (lastTrustHeartbeatTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastTrustHeartbeatTime_ = value;
      } else {
        lastTrustHeartbeatTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last heartbeat time when the trust was known to be connected.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_trust_heartbeat_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastTrustHeartbeatTime(
        com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastTrustHeartbeatTimeBuilder_ == null) {
        lastTrustHeartbeatTime_ = builderForValue.build();
      } else {
        lastTrustHeartbeatTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last heartbeat time when the trust was known to be connected.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_trust_heartbeat_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastTrustHeartbeatTime(com.google.protobuf.Timestamp value) {
      if (lastTrustHeartbeatTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && lastTrustHeartbeatTime_ != null
            && lastTrustHeartbeatTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastTrustHeartbeatTimeBuilder().mergeFrom(value);
        } else {
          lastTrustHeartbeatTime_ = value;
        }
      } else {
        lastTrustHeartbeatTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last heartbeat time when the trust was known to be connected.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_trust_heartbeat_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastTrustHeartbeatTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      lastTrustHeartbeatTime_ = null;
      if (lastTrustHeartbeatTimeBuilder_ != null) {
        lastTrustHeartbeatTimeBuilder_.dispose();
        lastTrustHeartbeatTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last heartbeat time when the trust was known to be connected.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_trust_heartbeat_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastTrustHeartbeatTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getLastTrustHeartbeatTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last heartbeat time when the trust was known to be connected.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_trust_heartbeat_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastTrustHeartbeatTimeOrBuilder() {
      if (lastTrustHeartbeatTimeBuilder_ != null) {
        return lastTrustHeartbeatTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastTrustHeartbeatTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastTrustHeartbeatTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last heartbeat time when the trust was known to be connected.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_trust_heartbeat_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastTrustHeartbeatTimeFieldBuilder() {
      if (lastTrustHeartbeatTimeBuilder_ == null) {
        lastTrustHeartbeatTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastTrustHeartbeatTime(), getParentForChildren(), isClean());
        lastTrustHeartbeatTime_ = null;
      }
      return lastTrustHeartbeatTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.managedidentities.v1.Trust)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.managedidentities.v1.Trust)
  private static final com.google.cloud.managedidentities.v1.Trust DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.managedidentities.v1.Trust();
  }

  public static com.google.cloud.managedidentities.v1.Trust getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Trust> PARSER =
      new com.google.protobuf.AbstractParser<Trust>() {
        @java.lang.Override
        public Trust parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Trust> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Trust> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.managedidentities.v1.Trust getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
