/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/managedidentities/v1/resource.proto

package com.google.cloud.managedidentities.v1;

public interface TrustOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.managedidentities.v1.Trust)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The fully qualified target domain name which will be in trust with the
   * current domain.
   * </pre>
   *
   * <code>string target_domain_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The targetDomainName.
   */
  java.lang.String getTargetDomainName();
  /**
   *
   *
   * <pre>
   * Required. The fully qualified target domain name which will be in trust with the
   * current domain.
   * </pre>
   *
   * <code>string target_domain_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for targetDomainName.
   */
  com.google.protobuf.ByteString getTargetDomainNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The type of trust represented by the trust resource.
   * </pre>
   *
   * <code>
   * .google.cloud.managedidentities.v1.Trust.TrustType trust_type = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for trustType.
   */
  int getTrustTypeValue();
  /**
   *
   *
   * <pre>
   * Required. The type of trust represented by the trust resource.
   * </pre>
   *
   * <code>
   * .google.cloud.managedidentities.v1.Trust.TrustType trust_type = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The trustType.
   */
  com.google.cloud.managedidentities.v1.Trust.TrustType getTrustType();

  /**
   *
   *
   * <pre>
   * Required. The trust direction, which decides if the current domain is trusted,
   * trusting, or both.
   * </pre>
   *
   * <code>
   * .google.cloud.managedidentities.v1.Trust.TrustDirection trust_direction = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for trustDirection.
   */
  int getTrustDirectionValue();
  /**
   *
   *
   * <pre>
   * Required. The trust direction, which decides if the current domain is trusted,
   * trusting, or both.
   * </pre>
   *
   * <code>
   * .google.cloud.managedidentities.v1.Trust.TrustDirection trust_direction = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The trustDirection.
   */
  com.google.cloud.managedidentities.v1.Trust.TrustDirection getTrustDirection();

  /**
   *
   *
   * <pre>
   * Optional. The trust authentication type, which decides whether the trusted side has
   * forest/domain wide access or selective access to an approved set of
   * resources.
   * </pre>
   *
   * <code>bool selective_authentication = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The selectiveAuthentication.
   */
  boolean getSelectiveAuthentication();

  /**
   *
   *
   * <pre>
   * Required. The target DNS server IP addresses which can resolve the remote domain
   * involved in the trust.
   * </pre>
   *
   * <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return A list containing the targetDnsIpAddresses.
   */
  java.util.List<java.lang.String> getTargetDnsIpAddressesList();
  /**
   *
   *
   * <pre>
   * Required. The target DNS server IP addresses which can resolve the remote domain
   * involved in the trust.
   * </pre>
   *
   * <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The count of targetDnsIpAddresses.
   */
  int getTargetDnsIpAddressesCount();
  /**
   *
   *
   * <pre>
   * Required. The target DNS server IP addresses which can resolve the remote domain
   * involved in the trust.
   * </pre>
   *
   * <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The targetDnsIpAddresses at the given index.
   */
  java.lang.String getTargetDnsIpAddresses(int index);
  /**
   *
   *
   * <pre>
   * Required. The target DNS server IP addresses which can resolve the remote domain
   * involved in the trust.
   * </pre>
   *
   * <code>repeated string target_dns_ip_addresses = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the targetDnsIpAddresses at the given index.
   */
  com.google.protobuf.ByteString getTargetDnsIpAddressesBytes(int index);

  /**
   *
   *
   * <pre>
   * Required. The trust secret used for the handshake with the target domain. This will
   * not be stored.
   * </pre>
   *
   * <code>string trust_handshake_secret = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The trustHandshakeSecret.
   */
  java.lang.String getTrustHandshakeSecret();
  /**
   *
   *
   * <pre>
   * Required. The trust secret used for the handshake with the target domain. This will
   * not be stored.
   * </pre>
   *
   * <code>string trust_handshake_secret = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for trustHandshakeSecret.
   */
  com.google.protobuf.ByteString getTrustHandshakeSecretBytes();

  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The last update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The last update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The last update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The current state of the trust.
   * </pre>
   *
   * <code>
   * .google.cloud.managedidentities.v1.Trust.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  int getStateValue();
  /**
   *
   *
   * <pre>
   * Output only. The current state of the trust.
   * </pre>
   *
   * <code>
   * .google.cloud.managedidentities.v1.Trust.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  com.google.cloud.managedidentities.v1.Trust.State getState();

  /**
   *
   *
   * <pre>
   * Output only. Additional information about the current state of the trust, if available.
   * </pre>
   *
   * <code>string state_description = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stateDescription.
   */
  java.lang.String getStateDescription();
  /**
   *
   *
   * <pre>
   * Output only. Additional information about the current state of the trust, if available.
   * </pre>
   *
   * <code>string state_description = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for stateDescription.
   */
  com.google.protobuf.ByteString getStateDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Output only. The last heartbeat time when the trust was known to be connected.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_trust_heartbeat_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastTrustHeartbeatTime field is set.
   */
  boolean hasLastTrustHeartbeatTime();
  /**
   *
   *
   * <pre>
   * Output only. The last heartbeat time when the trust was known to be connected.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_trust_heartbeat_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastTrustHeartbeatTime.
   */
  com.google.protobuf.Timestamp getLastTrustHeartbeatTime();
  /**
   *
   *
   * <pre>
   * Output only. The last heartbeat time when the trust was known to be connected.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_trust_heartbeat_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getLastTrustHeartbeatTimeOrBuilder();
}
