/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.managedkafka.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConnectClusterName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CONNECT_CLUSTER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/connectClusters/{connect_cluster}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String connectCluster;

    @Deprecated
    protected ConnectClusterName() {
        this.project = null;
        this.location = null;
        this.connectCluster = null;
    }

    private ConnectClusterName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.connectCluster = (String)Preconditions.checkNotNull((Object)builder.getConnectCluster());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getConnectCluster() {
        return this.connectCluster;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConnectClusterName of(String project, String location, String connectCluster) {
        return ConnectClusterName.newBuilder().setProject(project).setLocation(location).setConnectCluster(connectCluster).build();
    }

    public static String format(String project, String location, String connectCluster) {
        return ConnectClusterName.newBuilder().setProject(project).setLocation(location).setConnectCluster(connectCluster).build().toString();
    }

    public static ConnectClusterName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CONNECT_CLUSTER.validatedMatch(formattedString, "ConnectClusterName.parse: formattedString not in valid format");
        return ConnectClusterName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("connect_cluster"));
    }

    public static List<ConnectClusterName> parseList(List<String> formattedStrings) {
        ArrayList<ConnectClusterName> list = new ArrayList<ConnectClusterName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConnectClusterName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConnectClusterName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConnectClusterName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CONNECT_CLUSTER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConnectClusterName connectClusterName = this;
            synchronized (connectClusterName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.connectCluster != null) {
                        fieldMapBuilder.put((Object)"connect_cluster", (Object)this.connectCluster);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CONNECT_CLUSTER.instantiate(new String[]{"project", this.project, "location", this.location, "connect_cluster", this.connectCluster});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConnectClusterName that = (ConnectClusterName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.connectCluster, that.connectCluster);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.connectCluster);
    }

    public static class Builder {
        private String project;
        private String location;
        private String connectCluster;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConnectCluster() {
            return this.connectCluster;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setConnectCluster(String connectCluster) {
            this.connectCluster = connectCluster;
            return this;
        }

        private Builder(ConnectClusterName connectClusterName) {
            this.project = connectClusterName.project;
            this.location = connectClusterName.location;
            this.connectCluster = connectClusterName.connectCluster;
        }

        public ConnectClusterName build() {
            return new ConnectClusterName(this);
        }
    }
}

