/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.managedkafka.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConsumerGroupName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CLUSTER_CONSUMER_GROUP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/clusters/{cluster}/consumerGroups/{consumer_group}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String cluster;
    private final String consumerGroup;

    @Deprecated
    protected ConsumerGroupName() {
        this.project = null;
        this.location = null;
        this.cluster = null;
        this.consumerGroup = null;
    }

    private ConsumerGroupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.consumerGroup = (String)Preconditions.checkNotNull((Object)builder.getConsumerGroup());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConsumerGroupName of(String project, String location, String cluster, String consumerGroup) {
        return ConsumerGroupName.newBuilder().setProject(project).setLocation(location).setCluster(cluster).setConsumerGroup(consumerGroup).build();
    }

    public static String format(String project, String location, String cluster, String consumerGroup) {
        return ConsumerGroupName.newBuilder().setProject(project).setLocation(location).setCluster(cluster).setConsumerGroup(consumerGroup).build().toString();
    }

    public static ConsumerGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CLUSTER_CONSUMER_GROUP.validatedMatch(formattedString, "ConsumerGroupName.parse: formattedString not in valid format");
        return ConsumerGroupName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cluster"), (String)matchMap.get("consumer_group"));
    }

    public static List<ConsumerGroupName> parseList(List<String> formattedStrings) {
        ArrayList<ConsumerGroupName> list = new ArrayList<ConsumerGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConsumerGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConsumerGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConsumerGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CLUSTER_CONSUMER_GROUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConsumerGroupName consumerGroupName = this;
            synchronized (consumerGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cluster != null) {
                        fieldMapBuilder.put((Object)"cluster", (Object)this.cluster);
                    }
                    if (this.consumerGroup != null) {
                        fieldMapBuilder.put((Object)"consumer_group", (Object)this.consumerGroup);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CLUSTER_CONSUMER_GROUP.instantiate(new String[]{"project", this.project, "location", this.location, "cluster", this.cluster, "consumer_group", this.consumerGroup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConsumerGroupName that = (ConsumerGroupName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.consumerGroup, that.consumerGroup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.cluster);
        h *= 1000003;
        return h ^= Objects.hashCode(this.consumerGroup);
    }

    public static class Builder {
        private String project;
        private String location;
        private String cluster;
        private String consumerGroup;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getConsumerGroup() {
            return this.consumerGroup;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder setConsumerGroup(String consumerGroup) {
            this.consumerGroup = consumerGroup;
            return this;
        }

        private Builder(ConsumerGroupName consumerGroupName) {
            this.project = consumerGroupName.project;
            this.location = consumerGroupName.location;
            this.cluster = consumerGroupName.cluster;
            this.consumerGroup = consumerGroupName.consumerGroup;
        }

        public ConsumerGroupName build() {
            return new ConsumerGroupName(this);
        }
    }
}

