/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/mediatranslation/v1beta1/media_translation.proto

package com.google.cloud.mediatranslation.v1beta1;

/**
 *
 *
 * <pre>
 * A streaming speech translation response corresponding to a portion of
 * the audio currently processed.
 * </pre>
 *
 * Protobuf type {@code google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse}
 */
public final class StreamingTranslateSpeechResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse)
    StreamingTranslateSpeechResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StreamingTranslateSpeechResponse.newBuilder() to construct.
  private StreamingTranslateSpeechResponse(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamingTranslateSpeechResponse() {
    speechEventType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamingTranslateSpeechResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
        .internal_static_google_cloud_mediatranslation_v1beta1_StreamingTranslateSpeechResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
        .internal_static_google_cloud_mediatranslation_v1beta1_StreamingTranslateSpeechResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.class,
            com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.Builder
                .class);
  }

  /**
   *
   *
   * <pre>
   * Indicates the type of speech event.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.SpeechEventType}
   */
  public enum SpeechEventType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No speech event specified.
     * </pre>
     *
     * <code>SPEECH_EVENT_TYPE_UNSPECIFIED = 0;</code>
     */
    SPEECH_EVENT_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * This event indicates that the server has detected the end of the user's
     * speech utterance and expects no additional speech. Therefore, the server
     * will not process additional audio (although it may subsequently return
     * additional results). When the client receives 'END_OF_SINGLE_UTTERANCE'
     * event, the client should stop sending the requests. However, clients
     * should keep receiving remaining responses until the stream is terminated.
     * To construct the complete sentence in a streaming way, one should
     * override (if 'is_final' of previous response is false), or append (if
     * 'is_final' of previous response is true). This event is only sent if
     * `single_utterance` was set to `true`, and is not used otherwise.
     * </pre>
     *
     * <code>END_OF_SINGLE_UTTERANCE = 1;</code>
     */
    END_OF_SINGLE_UTTERANCE(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No speech event specified.
     * </pre>
     *
     * <code>SPEECH_EVENT_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int SPEECH_EVENT_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * This event indicates that the server has detected the end of the user's
     * speech utterance and expects no additional speech. Therefore, the server
     * will not process additional audio (although it may subsequently return
     * additional results). When the client receives 'END_OF_SINGLE_UTTERANCE'
     * event, the client should stop sending the requests. However, clients
     * should keep receiving remaining responses until the stream is terminated.
     * To construct the complete sentence in a streaming way, one should
     * override (if 'is_final' of previous response is false), or append (if
     * 'is_final' of previous response is true). This event is only sent if
     * `single_utterance` was set to `true`, and is not used otherwise.
     * </pre>
     *
     * <code>END_OF_SINGLE_UTTERANCE = 1;</code>
     */
    public static final int END_OF_SINGLE_UTTERANCE_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SpeechEventType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SpeechEventType forNumber(int value) {
      switch (value) {
        case 0:
          return SPEECH_EVENT_TYPE_UNSPECIFIED;
        case 1:
          return END_OF_SINGLE_UTTERANCE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SpeechEventType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SpeechEventType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SpeechEventType>() {
              public SpeechEventType findValueByNumber(int number) {
                return SpeechEventType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
          .getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final SpeechEventType[] VALUES = values();

    public static SpeechEventType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SpeechEventType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.SpeechEventType)
  }

  public static final int ERROR_FIELD_NUMBER = 1;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * Output only. If set, returns a [google.rpc.Status][google.rpc.Status] message that
   * specifies the error for the operation.
   * </pre>
   *
   * <code>.google.rpc.Status error = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return error_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. If set, returns a [google.rpc.Status][google.rpc.Status] message that
   * specifies the error for the operation.
   * </pre>
   *
   * <code>.google.rpc.Status error = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * Output only. If set, returns a [google.rpc.Status][google.rpc.Status] message that
   * specifies the error for the operation.
   * </pre>
   *
   * <code>.google.rpc.Status error = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  public static final int RESULT_FIELD_NUMBER = 2;
  private com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult result_;
  /**
   *
   *
   * <pre>
   * Output only. The translation result that is currently being processed (is_final could be
   * true or false).
   * </pre>
   *
   * <code>
   * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult result = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the result field is set.
   */
  @java.lang.Override
  public boolean hasResult() {
    return result_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The translation result that is currently being processed (is_final could be
   * true or false).
   * </pre>
   *
   * <code>
   * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult result = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The result.
   */
  @java.lang.Override
  public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult getResult() {
    return result_ == null
        ? com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .getDefaultInstance()
        : result_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The translation result that is currently being processed (is_final could be
   * true or false).
   * </pre>
   *
   * <code>
   * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult result = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResultOrBuilder
      getResultOrBuilder() {
    return result_ == null
        ? com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .getDefaultInstance()
        : result_;
  }

  public static final int SPEECH_EVENT_TYPE_FIELD_NUMBER = 3;
  private int speechEventType_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Indicates the type of speech event.
   * </pre>
   *
   * <code>
   * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.SpeechEventType speech_event_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for speechEventType.
   */
  @java.lang.Override
  public int getSpeechEventTypeValue() {
    return speechEventType_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Indicates the type of speech event.
   * </pre>
   *
   * <code>
   * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.SpeechEventType speech_event_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The speechEventType.
   */
  @java.lang.Override
  public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.SpeechEventType
      getSpeechEventType() {
    com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.SpeechEventType
        result =
            com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
                .SpeechEventType.forNumber(speechEventType_);
    return result == null
        ? com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.SpeechEventType
            .UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (error_ != null) {
      output.writeMessage(1, getError());
    }
    if (result_ != null) {
      output.writeMessage(2, getResult());
    }
    if (speechEventType_
        != com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
            .SpeechEventType.SPEECH_EVENT_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, speechEventType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (error_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getError());
    }
    if (result_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getResult());
    }
    if (speechEventType_
        != com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
            .SpeechEventType.SPEECH_EVENT_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, speechEventType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse other =
        (com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse) obj;

    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (hasResult() != other.hasResult()) return false;
    if (hasResult()) {
      if (!getResult().equals(other.getResult())) return false;
    }
    if (speechEventType_ != other.speechEventType_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (hasResult()) {
      hash = (37 * hash) + RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getResult().hashCode();
    }
    hash = (37 * hash) + SPEECH_EVENT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + speechEventType_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A streaming speech translation response corresponding to a portion of
   * the audio currently processed.
   * </pre>
   *
   * Protobuf type {@code google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse)
      com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
          .internal_static_google_cloud_mediatranslation_v1beta1_StreamingTranslateSpeechResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
          .internal_static_google_cloud_mediatranslation_v1beta1_StreamingTranslateSpeechResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.class,
              com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      result_ = null;
      if (resultBuilder_ != null) {
        resultBuilder_.dispose();
        resultBuilder_ = null;
      }
      speechEventType_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
          .internal_static_google_cloud_mediatranslation_v1beta1_StreamingTranslateSpeechResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
        getDefaultInstanceForType() {
      return com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse build() {
      com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
        buildPartial() {
      com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse result =
          new com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.result_ = resultBuilder_ == null ? result_ : resultBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.speechEventType_ = speechEventType_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse) {
        return mergeFrom(
            (com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse other) {
      if (other
          == com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
              .getDefaultInstance()) return this;
      if (other.hasError()) {
        mergeError(other.getError());
      }
      if (other.hasResult()) {
        mergeResult(other.getResult());
      }
      if (other.speechEventType_ != 0) {
        setSpeechEventTypeValue(other.getSpeechEventTypeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getResultFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                speechEventType_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && error_ != null
            && error_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00000001);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult result_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult,
            com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.Builder,
            com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResultOrBuilder>
        resultBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The translation result that is currently being processed (is_final could be
     * true or false).
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult result = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the result field is set.
     */
    public boolean hasResult() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The translation result that is currently being processed (is_final could be
     * true or false).
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult result = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The result.
     */
    public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult getResult() {
      if (resultBuilder_ == null) {
        return result_ == null
            ? com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                .getDefaultInstance()
            : result_;
      } else {
        return resultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The translation result that is currently being processed (is_final could be
     * true or false).
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult result = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setResult(
        com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult value) {
      if (resultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        result_ = value;
      } else {
        resultBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The translation result that is currently being processed (is_final could be
     * true or false).
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult result = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setResult(
        com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.Builder
            builderForValue) {
      if (resultBuilder_ == null) {
        result_ = builderForValue.build();
      } else {
        resultBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The translation result that is currently being processed (is_final could be
     * true or false).
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult result = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeResult(
        com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult value) {
      if (resultBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && result_ != null
            && result_
                != com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                    .getDefaultInstance()) {
          getResultBuilder().mergeFrom(value);
        } else {
          result_ = value;
        }
      } else {
        resultBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The translation result that is currently being processed (is_final could be
     * true or false).
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult result = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearResult() {
      bitField0_ = (bitField0_ & ~0x00000002);
      result_ = null;
      if (resultBuilder_ != null) {
        resultBuilder_.dispose();
        resultBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The translation result that is currently being processed (is_final could be
     * true or false).
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult result = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.Builder
        getResultBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The translation result that is currently being processed (is_final could be
     * true or false).
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult result = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResultOrBuilder
        getResultOrBuilder() {
      if (resultBuilder_ != null) {
        return resultBuilder_.getMessageOrBuilder();
      } else {
        return result_ == null
            ? com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                .getDefaultInstance()
            : result_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The translation result that is currently being processed (is_final could be
     * true or false).
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult result = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult,
            com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.Builder,
            com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResultOrBuilder>
        getResultFieldBuilder() {
      if (resultBuilder_ == null) {
        resultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult,
                com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.Builder,
                com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResultOrBuilder>(
                getResult(), getParentForChildren(), isClean());
        result_ = null;
      }
      return resultBuilder_;
    }

    private int speechEventType_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Indicates the type of speech event.
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.SpeechEventType speech_event_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for speechEventType.
     */
    @java.lang.Override
    public int getSpeechEventTypeValue() {
      return speechEventType_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates the type of speech event.
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.SpeechEventType speech_event_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for speechEventType to set.
     * @return This builder for chaining.
     */
    public Builder setSpeechEventTypeValue(int value) {
      speechEventType_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates the type of speech event.
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.SpeechEventType speech_event_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The speechEventType.
     */
    @java.lang.Override
    public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
            .SpeechEventType
        getSpeechEventType() {
      com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.SpeechEventType
          result =
              com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
                  .SpeechEventType.forNumber(speechEventType_);
      return result == null
          ? com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
              .SpeechEventType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates the type of speech event.
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.SpeechEventType speech_event_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The speechEventType to set.
     * @return This builder for chaining.
     */
    public Builder setSpeechEventType(
        com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.SpeechEventType
            value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      speechEventType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates the type of speech event.
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse.SpeechEventType speech_event_type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpeechEventType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      speechEventType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse)
  private static final com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse();
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamingTranslateSpeechResponse> PARSER =
      new com.google.protobuf.AbstractParser<StreamingTranslateSpeechResponse>() {
        @java.lang.Override
        public StreamingTranslateSpeechResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StreamingTranslateSpeechResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamingTranslateSpeechResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
