/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/mediatranslation/v1beta1/media_translation.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.mediatranslation.v1beta1;

/**
 *
 *
 * <pre>
 * Provides information to the speech translation that specifies how to process
 * the request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig}
 */
public final class TranslateSpeechConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig)
    TranslateSpeechConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TranslateSpeechConfig.newBuilder() to construct.
  private TranslateSpeechConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TranslateSpeechConfig() {
    audioEncoding_ = "";
    sourceLanguageCode_ = "";
    targetLanguageCode_ = "";
    model_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TranslateSpeechConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
        .internal_static_google_cloud_mediatranslation_v1beta1_TranslateSpeechConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
        .internal_static_google_cloud_mediatranslation_v1beta1_TranslateSpeechConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig.class,
            com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig.Builder.class);
  }

  public static final int AUDIO_ENCODING_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object audioEncoding_ = "";
  /**
   *
   *
   * <pre>
   * Required. Encoding of audio data.
   * Supported formats:
   *
   * - `linear16`
   *
   *   Uncompressed 16-bit signed little-endian samples (Linear PCM).
   *
   * - `flac`
   *
   *   `flac` (Free Lossless Audio Codec) is the recommended encoding
   *   because it is lossless--therefore recognition is not compromised--and
   *   requires only about half the bandwidth of `linear16`.
   *
   * - `mulaw`
   *
   *   8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
   *
   * - `amr`
   *
   *   Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000.
   *
   * - `amr-wb`
   *
   *   Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000.
   *
   * - `ogg-opus`
   *
   *   Opus encoded audio frames in [Ogg](https://wikipedia.org/wiki/Ogg)
   *   container. `sample_rate_hertz` must be one of 8000, 12000, 16000, 24000,
   *   or 48000.
   *
   * - `mp3`
   *
   *   MP3 audio. Support all standard MP3 bitrates (which range from 32-320
   *   kbps). When using this encoding, `sample_rate_hertz` has to match the
   *   sample rate of the file being used.
   * </pre>
   *
   * <code>string audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The audioEncoding.
   */
  @java.lang.Override
  public java.lang.String getAudioEncoding() {
    java.lang.Object ref = audioEncoding_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      audioEncoding_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Encoding of audio data.
   * Supported formats:
   *
   * - `linear16`
   *
   *   Uncompressed 16-bit signed little-endian samples (Linear PCM).
   *
   * - `flac`
   *
   *   `flac` (Free Lossless Audio Codec) is the recommended encoding
   *   because it is lossless--therefore recognition is not compromised--and
   *   requires only about half the bandwidth of `linear16`.
   *
   * - `mulaw`
   *
   *   8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
   *
   * - `amr`
   *
   *   Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000.
   *
   * - `amr-wb`
   *
   *   Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000.
   *
   * - `ogg-opus`
   *
   *   Opus encoded audio frames in [Ogg](https://wikipedia.org/wiki/Ogg)
   *   container. `sample_rate_hertz` must be one of 8000, 12000, 16000, 24000,
   *   or 48000.
   *
   * - `mp3`
   *
   *   MP3 audio. Support all standard MP3 bitrates (which range from 32-320
   *   kbps). When using this encoding, `sample_rate_hertz` has to match the
   *   sample rate of the file being used.
   * </pre>
   *
   * <code>string audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for audioEncoding.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAudioEncodingBytes() {
    java.lang.Object ref = audioEncoding_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      audioEncoding_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_LANGUAGE_CODE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceLanguageCode_ = "";
  /**
   *
   *
   * <pre>
   * Required. Source language code (BCP-47) of the input audio.
   * </pre>
   *
   * <code>string source_language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The sourceLanguageCode.
   */
  @java.lang.Override
  public java.lang.String getSourceLanguageCode() {
    java.lang.Object ref = sourceLanguageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceLanguageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Source language code (BCP-47) of the input audio.
   * </pre>
   *
   * <code>string source_language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for sourceLanguageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceLanguageCodeBytes() {
    java.lang.Object ref = sourceLanguageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceLanguageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_LANGUAGE_CODE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetLanguageCode_ = "";
  /**
   *
   *
   * <pre>
   * Required. Target language code (BCP-47) of the output.
   * </pre>
   *
   * <code>string target_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The targetLanguageCode.
   */
  @java.lang.Override
  public java.lang.String getTargetLanguageCode() {
    java.lang.Object ref = targetLanguageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetLanguageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Target language code (BCP-47) of the output.
   * </pre>
   *
   * <code>string target_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for targetLanguageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetLanguageCodeBytes() {
    java.lang.Object ref = targetLanguageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetLanguageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SAMPLE_RATE_HERTZ_FIELD_NUMBER = 4;
  private int sampleRateHertz_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Sample rate in Hertz of the audio data. Valid values are:
   * 8000-48000. 16000 is optimal. For best results, set the sampling rate of
   * the audio source to 16000 Hz. If that's not possible, use the native sample
   * rate of the audio source (instead of re-sampling).
   * </pre>
   *
   * <code>int32 sample_rate_hertz = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The sampleRateHertz.
   */
  @java.lang.Override
  public int getSampleRateHertz() {
    return sampleRateHertz_;
  }

  public static final int MODEL_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object model_ = "";
  /**
   *
   *
   * <pre>
   * Optional. `google-provided-model/video` and
   * `google-provided-model/enhanced-phone-call` are premium models.
   * `google-provided-model/phone-call` is not premium model.
   * </pre>
   *
   * <code>string model = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The model.
   */
  @java.lang.Override
  public java.lang.String getModel() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      model_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. `google-provided-model/video` and
   * `google-provided-model/enhanced-phone-call` are premium models.
   * `google-provided-model/phone-call` is not premium model.
   * </pre>
   *
   * <code>string model = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for model.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getModelBytes() {
    java.lang.Object ref = model_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      model_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audioEncoding_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, audioEncoding_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceLanguageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sourceLanguageCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetLanguageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, targetLanguageCode_);
    }
    if (sampleRateHertz_ != 0) {
      output.writeInt32(4, sampleRateHertz_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, model_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(audioEncoding_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, audioEncoding_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceLanguageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, sourceLanguageCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetLanguageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, targetLanguageCode_);
    }
    if (sampleRateHertz_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, sampleRateHertz_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, model_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig other =
        (com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig) obj;

    if (!getAudioEncoding().equals(other.getAudioEncoding())) return false;
    if (!getSourceLanguageCode().equals(other.getSourceLanguageCode())) return false;
    if (!getTargetLanguageCode().equals(other.getTargetLanguageCode())) return false;
    if (getSampleRateHertz() != other.getSampleRateHertz()) return false;
    if (!getModel().equals(other.getModel())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + AUDIO_ENCODING_FIELD_NUMBER;
    hash = (53 * hash) + getAudioEncoding().hashCode();
    hash = (37 * hash) + SOURCE_LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getSourceLanguageCode().hashCode();
    hash = (37 * hash) + TARGET_LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getTargetLanguageCode().hashCode();
    hash = (37 * hash) + SAMPLE_RATE_HERTZ_FIELD_NUMBER;
    hash = (53 * hash) + getSampleRateHertz();
    hash = (37 * hash) + MODEL_FIELD_NUMBER;
    hash = (53 * hash) + getModel().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Provides information to the speech translation that specifies how to process
   * the request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig)
      com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
          .internal_static_google_cloud_mediatranslation_v1beta1_TranslateSpeechConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
          .internal_static_google_cloud_mediatranslation_v1beta1_TranslateSpeechConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig.class,
              com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig.Builder.class);
    }

    // Construct using com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      audioEncoding_ = "";
      sourceLanguageCode_ = "";
      targetLanguageCode_ = "";
      sampleRateHertz_ = 0;
      model_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
          .internal_static_google_cloud_mediatranslation_v1beta1_TranslateSpeechConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig
        getDefaultInstanceForType() {
      return com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig build() {
      com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig buildPartial() {
      com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig result =
          new com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.audioEncoding_ = audioEncoding_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.sourceLanguageCode_ = sourceLanguageCode_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.targetLanguageCode_ = targetLanguageCode_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.sampleRateHertz_ = sampleRateHertz_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.model_ = model_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig) {
        return mergeFrom((com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig other) {
      if (other
          == com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig.getDefaultInstance())
        return this;
      if (!other.getAudioEncoding().isEmpty()) {
        audioEncoding_ = other.audioEncoding_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getSourceLanguageCode().isEmpty()) {
        sourceLanguageCode_ = other.sourceLanguageCode_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getTargetLanguageCode().isEmpty()) {
        targetLanguageCode_ = other.targetLanguageCode_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getSampleRateHertz() != 0) {
        setSampleRateHertz(other.getSampleRateHertz());
      }
      if (!other.getModel().isEmpty()) {
        model_ = other.model_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                audioEncoding_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                sourceLanguageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                targetLanguageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                sampleRateHertz_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                model_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object audioEncoding_ = "";
    /**
     *
     *
     * <pre>
     * Required. Encoding of audio data.
     * Supported formats:
     *
     * - `linear16`
     *
     *   Uncompressed 16-bit signed little-endian samples (Linear PCM).
     *
     * - `flac`
     *
     *   `flac` (Free Lossless Audio Codec) is the recommended encoding
     *   because it is lossless--therefore recognition is not compromised--and
     *   requires only about half the bandwidth of `linear16`.
     *
     * - `mulaw`
     *
     *   8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
     *
     * - `amr`
     *
     *   Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000.
     *
     * - `amr-wb`
     *
     *   Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000.
     *
     * - `ogg-opus`
     *
     *   Opus encoded audio frames in [Ogg](https://wikipedia.org/wiki/Ogg)
     *   container. `sample_rate_hertz` must be one of 8000, 12000, 16000, 24000,
     *   or 48000.
     *
     * - `mp3`
     *
     *   MP3 audio. Support all standard MP3 bitrates (which range from 32-320
     *   kbps). When using this encoding, `sample_rate_hertz` has to match the
     *   sample rate of the file being used.
     * </pre>
     *
     * <code>string audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The audioEncoding.
     */
    public java.lang.String getAudioEncoding() {
      java.lang.Object ref = audioEncoding_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        audioEncoding_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Encoding of audio data.
     * Supported formats:
     *
     * - `linear16`
     *
     *   Uncompressed 16-bit signed little-endian samples (Linear PCM).
     *
     * - `flac`
     *
     *   `flac` (Free Lossless Audio Codec) is the recommended encoding
     *   because it is lossless--therefore recognition is not compromised--and
     *   requires only about half the bandwidth of `linear16`.
     *
     * - `mulaw`
     *
     *   8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
     *
     * - `amr`
     *
     *   Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000.
     *
     * - `amr-wb`
     *
     *   Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000.
     *
     * - `ogg-opus`
     *
     *   Opus encoded audio frames in [Ogg](https://wikipedia.org/wiki/Ogg)
     *   container. `sample_rate_hertz` must be one of 8000, 12000, 16000, 24000,
     *   or 48000.
     *
     * - `mp3`
     *
     *   MP3 audio. Support all standard MP3 bitrates (which range from 32-320
     *   kbps). When using this encoding, `sample_rate_hertz` has to match the
     *   sample rate of the file being used.
     * </pre>
     *
     * <code>string audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for audioEncoding.
     */
    public com.google.protobuf.ByteString getAudioEncodingBytes() {
      java.lang.Object ref = audioEncoding_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        audioEncoding_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Encoding of audio data.
     * Supported formats:
     *
     * - `linear16`
     *
     *   Uncompressed 16-bit signed little-endian samples (Linear PCM).
     *
     * - `flac`
     *
     *   `flac` (Free Lossless Audio Codec) is the recommended encoding
     *   because it is lossless--therefore recognition is not compromised--and
     *   requires only about half the bandwidth of `linear16`.
     *
     * - `mulaw`
     *
     *   8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
     *
     * - `amr`
     *
     *   Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000.
     *
     * - `amr-wb`
     *
     *   Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000.
     *
     * - `ogg-opus`
     *
     *   Opus encoded audio frames in [Ogg](https://wikipedia.org/wiki/Ogg)
     *   container. `sample_rate_hertz` must be one of 8000, 12000, 16000, 24000,
     *   or 48000.
     *
     * - `mp3`
     *
     *   MP3 audio. Support all standard MP3 bitrates (which range from 32-320
     *   kbps). When using this encoding, `sample_rate_hertz` has to match the
     *   sample rate of the file being used.
     * </pre>
     *
     * <code>string audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The audioEncoding to set.
     * @return This builder for chaining.
     */
    public Builder setAudioEncoding(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      audioEncoding_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Encoding of audio data.
     * Supported formats:
     *
     * - `linear16`
     *
     *   Uncompressed 16-bit signed little-endian samples (Linear PCM).
     *
     * - `flac`
     *
     *   `flac` (Free Lossless Audio Codec) is the recommended encoding
     *   because it is lossless--therefore recognition is not compromised--and
     *   requires only about half the bandwidth of `linear16`.
     *
     * - `mulaw`
     *
     *   8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
     *
     * - `amr`
     *
     *   Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000.
     *
     * - `amr-wb`
     *
     *   Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000.
     *
     * - `ogg-opus`
     *
     *   Opus encoded audio frames in [Ogg](https://wikipedia.org/wiki/Ogg)
     *   container. `sample_rate_hertz` must be one of 8000, 12000, 16000, 24000,
     *   or 48000.
     *
     * - `mp3`
     *
     *   MP3 audio. Support all standard MP3 bitrates (which range from 32-320
     *   kbps). When using this encoding, `sample_rate_hertz` has to match the
     *   sample rate of the file being used.
     * </pre>
     *
     * <code>string audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAudioEncoding() {
      audioEncoding_ = getDefaultInstance().getAudioEncoding();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Encoding of audio data.
     * Supported formats:
     *
     * - `linear16`
     *
     *   Uncompressed 16-bit signed little-endian samples (Linear PCM).
     *
     * - `flac`
     *
     *   `flac` (Free Lossless Audio Codec) is the recommended encoding
     *   because it is lossless--therefore recognition is not compromised--and
     *   requires only about half the bandwidth of `linear16`.
     *
     * - `mulaw`
     *
     *   8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
     *
     * - `amr`
     *
     *   Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000.
     *
     * - `amr-wb`
     *
     *   Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000.
     *
     * - `ogg-opus`
     *
     *   Opus encoded audio frames in [Ogg](https://wikipedia.org/wiki/Ogg)
     *   container. `sample_rate_hertz` must be one of 8000, 12000, 16000, 24000,
     *   or 48000.
     *
     * - `mp3`
     *
     *   MP3 audio. Support all standard MP3 bitrates (which range from 32-320
     *   kbps). When using this encoding, `sample_rate_hertz` has to match the
     *   sample rate of the file being used.
     * </pre>
     *
     * <code>string audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for audioEncoding to set.
     * @return This builder for chaining.
     */
    public Builder setAudioEncodingBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      audioEncoding_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object sourceLanguageCode_ = "";
    /**
     *
     *
     * <pre>
     * Required. Source language code (BCP-47) of the input audio.
     * </pre>
     *
     * <code>string source_language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The sourceLanguageCode.
     */
    public java.lang.String getSourceLanguageCode() {
      java.lang.Object ref = sourceLanguageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceLanguageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Source language code (BCP-47) of the input audio.
     * </pre>
     *
     * <code>string source_language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for sourceLanguageCode.
     */
    public com.google.protobuf.ByteString getSourceLanguageCodeBytes() {
      java.lang.Object ref = sourceLanguageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceLanguageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Source language code (BCP-47) of the input audio.
     * </pre>
     *
     * <code>string source_language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The sourceLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setSourceLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceLanguageCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Source language code (BCP-47) of the input audio.
     * </pre>
     *
     * <code>string source_language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceLanguageCode() {
      sourceLanguageCode_ = getDefaultInstance().getSourceLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Source language code (BCP-47) of the input audio.
     * </pre>
     *
     * <code>string source_language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for sourceLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setSourceLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceLanguageCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object targetLanguageCode_ = "";
    /**
     *
     *
     * <pre>
     * Required. Target language code (BCP-47) of the output.
     * </pre>
     *
     * <code>string target_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The targetLanguageCode.
     */
    public java.lang.String getTargetLanguageCode() {
      java.lang.Object ref = targetLanguageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetLanguageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Target language code (BCP-47) of the output.
     * </pre>
     *
     * <code>string target_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for targetLanguageCode.
     */
    public com.google.protobuf.ByteString getTargetLanguageCodeBytes() {
      java.lang.Object ref = targetLanguageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetLanguageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Target language code (BCP-47) of the output.
     * </pre>
     *
     * <code>string target_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The targetLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setTargetLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetLanguageCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Target language code (BCP-47) of the output.
     * </pre>
     *
     * <code>string target_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetLanguageCode() {
      targetLanguageCode_ = getDefaultInstance().getTargetLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Target language code (BCP-47) of the output.
     * </pre>
     *
     * <code>string target_language_code = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for targetLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setTargetLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetLanguageCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int sampleRateHertz_;
    /**
     *
     *
     * <pre>
     * Optional. Sample rate in Hertz of the audio data. Valid values are:
     * 8000-48000. 16000 is optimal. For best results, set the sampling rate of
     * the audio source to 16000 Hz. If that's not possible, use the native sample
     * rate of the audio source (instead of re-sampling).
     * </pre>
     *
     * <code>int32 sample_rate_hertz = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The sampleRateHertz.
     */
    @java.lang.Override
    public int getSampleRateHertz() {
      return sampleRateHertz_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Sample rate in Hertz of the audio data. Valid values are:
     * 8000-48000. 16000 is optimal. For best results, set the sampling rate of
     * the audio source to 16000 Hz. If that's not possible, use the native sample
     * rate of the audio source (instead of re-sampling).
     * </pre>
     *
     * <code>int32 sample_rate_hertz = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The sampleRateHertz to set.
     * @return This builder for chaining.
     */
    public Builder setSampleRateHertz(int value) {

      sampleRateHertz_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Sample rate in Hertz of the audio data. Valid values are:
     * 8000-48000. 16000 is optimal. For best results, set the sampling rate of
     * the audio source to 16000 Hz. If that's not possible, use the native sample
     * rate of the audio source (instead of re-sampling).
     * </pre>
     *
     * <code>int32 sample_rate_hertz = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSampleRateHertz() {
      bitField0_ = (bitField0_ & ~0x00000008);
      sampleRateHertz_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * Optional. `google-provided-model/video` and
     * `google-provided-model/enhanced-phone-call` are premium models.
     * `google-provided-model/phone-call` is not premium model.
     * </pre>
     *
     * <code>string model = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The model.
     */
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. `google-provided-model/video` and
     * `google-provided-model/enhanced-phone-call` are premium models.
     * `google-provided-model/phone-call` is not premium model.
     * </pre>
     *
     * <code>string model = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for model.
     */
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. `google-provided-model/video` and
     * `google-provided-model/enhanced-phone-call` are premium models.
     * `google-provided-model/phone-call` is not premium model.
     * </pre>
     *
     * <code>string model = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The model to set.
     * @return This builder for chaining.
     */
    public Builder setModel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      model_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. `google-provided-model/video` and
     * `google-provided-model/enhanced-phone-call` are premium models.
     * `google-provided-model/phone-call` is not premium model.
     * </pre>
     *
     * <code>string model = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModel() {
      model_ = getDefaultInstance().getModel();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. `google-provided-model/video` and
     * `google-provided-model/enhanced-phone-call` are premium models.
     * `google-provided-model/phone-call` is not premium model.
     * </pre>
     *
     * <code>string model = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for model to set.
     * @return This builder for chaining.
     */
    public Builder setModelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      model_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig)
  private static final com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig();
  }

  public static com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TranslateSpeechConfig> PARSER =
      new com.google.protobuf.AbstractParser<TranslateSpeechConfig>() {
        @java.lang.Override
        public TranslateSpeechConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TranslateSpeechConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TranslateSpeechConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.mediatranslation.v1beta1.TranslateSpeechConfig
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
