/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/mediatranslation/v1beta1/media_translation.proto

package com.google.cloud.mediatranslation.v1beta1;

/**
 *
 *
 * <pre>
 * A streaming speech translation result corresponding to a portion of the audio
 * that is currently being processed.
 * </pre>
 *
 * Protobuf type {@code google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult}
 */
public final class StreamingTranslateSpeechResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult)
    StreamingTranslateSpeechResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StreamingTranslateSpeechResult.newBuilder() to construct.
  private StreamingTranslateSpeechResult(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamingTranslateSpeechResult() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamingTranslateSpeechResult();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private StreamingTranslateSpeechResult(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                      .TextTranslationResult.Builder
                  subBuilder = null;
              if (resultCase_ == 1) {
                subBuilder =
                    ((com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                                .TextTranslationResult)
                            result_)
                        .toBuilder();
              }
              result_ =
                  input.readMessage(
                      com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                          .TextTranslationResult.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                            .TextTranslationResult)
                        result_);
                result_ = subBuilder.buildPartial();
              }
              resultCase_ = 1;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
        .internal_static_google_cloud_mediatranslation_v1beta1_StreamingTranslateSpeechResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
        .internal_static_google_cloud_mediatranslation_v1beta1_StreamingTranslateSpeechResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.class,
            com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.Builder.class);
  }

  public interface TextTranslationResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The translated sentence.
     * </pre>
     *
     * <code>string translation = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The translation.
     */
    java.lang.String getTranslation();
    /**
     *
     *
     * <pre>
     * Output only. The translated sentence.
     * </pre>
     *
     * <code>string translation = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for translation.
     */
    com.google.protobuf.ByteString getTranslationBytes();

    /**
     *
     *
     * <pre>
     * Output only. If `false`, this `StreamingTranslateSpeechResult` represents
     * an interim result that may change. If `true`, this is the final time the
     * translation service will return this particular
     * `StreamingTranslateSpeechResult`, the streaming translator will not
     * return any further hypotheses for this portion of the transcript and
     * corresponding audio.
     * </pre>
     *
     * <code>bool is_final = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The isFinal.
     */
    boolean getIsFinal();
  }
  /**
   *
   *
   * <pre>
   * Text translation result.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult}
   */
  public static final class TextTranslationResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult)
      TextTranslationResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TextTranslationResult.newBuilder() to construct.
    private TextTranslationResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TextTranslationResult() {
      translation_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TextTranslationResult();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private TextTranslationResult(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                translation_ = s;
                break;
              }
            case 16:
              {
                isFinal_ = input.readBool();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
          .internal_static_google_cloud_mediatranslation_v1beta1_StreamingTranslateSpeechResult_TextTranslationResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
          .internal_static_google_cloud_mediatranslation_v1beta1_StreamingTranslateSpeechResult_TextTranslationResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                  .TextTranslationResult.class,
              com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                  .TextTranslationResult.Builder.class);
    }

    public static final int TRANSLATION_FIELD_NUMBER = 1;
    private volatile java.lang.Object translation_;
    /**
     *
     *
     * <pre>
     * Output only. The translated sentence.
     * </pre>
     *
     * <code>string translation = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The translation.
     */
    @java.lang.Override
    public java.lang.String getTranslation() {
      java.lang.Object ref = translation_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        translation_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The translated sentence.
     * </pre>
     *
     * <code>string translation = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for translation.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTranslationBytes() {
      java.lang.Object ref = translation_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        translation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IS_FINAL_FIELD_NUMBER = 2;
    private boolean isFinal_;
    /**
     *
     *
     * <pre>
     * Output only. If `false`, this `StreamingTranslateSpeechResult` represents
     * an interim result that may change. If `true`, this is the final time the
     * translation service will return this particular
     * `StreamingTranslateSpeechResult`, the streaming translator will not
     * return any further hypotheses for this portion of the transcript and
     * corresponding audio.
     * </pre>
     *
     * <code>bool is_final = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The isFinal.
     */
    @java.lang.Override
    public boolean getIsFinal() {
      return isFinal_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(translation_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, translation_);
      }
      if (isFinal_ != false) {
        output.writeBool(2, isFinal_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(translation_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, translation_);
      }
      if (isFinal_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, isFinal_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
              .TextTranslationResult)) {
        return super.equals(obj);
      }
      com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult
          other =
              (com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                      .TextTranslationResult)
                  obj;

      if (!getTranslation().equals(other.getTranslation())) return false;
      if (getIsFinal() != other.getIsFinal()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TRANSLATION_FIELD_NUMBER;
      hash = (53 * hash) + getTranslation().hashCode();
      hash = (37 * hash) + IS_FINAL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsFinal());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                .TextTranslationResult
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Text translation result.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult)
        com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
            .internal_static_google_cloud_mediatranslation_v1beta1_StreamingTranslateSpeechResult_TextTranslationResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
            .internal_static_google_cloud_mediatranslation_v1beta1_StreamingTranslateSpeechResult_TextTranslationResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                    .TextTranslationResult.class,
                com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                    .TextTranslationResult.Builder.class);
      }

      // Construct using
      // com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        translation_ = "";

        isFinal_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
            .internal_static_google_cloud_mediatranslation_v1beta1_StreamingTranslateSpeechResult_TextTranslationResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
              .TextTranslationResult
          getDefaultInstanceForType() {
        return com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
              .TextTranslationResult
          build() {
        com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                .TextTranslationResult
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
              .TextTranslationResult
          buildPartial() {
        com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                .TextTranslationResult
            result =
                new com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                    .TextTranslationResult(this);
        result.translation_ = translation_;
        result.isFinal_ = isFinal_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                .TextTranslationResult) {
          return mergeFrom(
              (com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                      .TextTranslationResult)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                  .TextTranslationResult
              other) {
        if (other
            == com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                .TextTranslationResult.getDefaultInstance()) return this;
        if (!other.getTranslation().isEmpty()) {
          translation_ = other.translation_;
          onChanged();
        }
        if (other.getIsFinal() != false) {
          setIsFinal(other.getIsFinal());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                .TextTranslationResult
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                      .TextTranslationResult)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object translation_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The translated sentence.
       * </pre>
       *
       * <code>string translation = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The translation.
       */
      public java.lang.String getTranslation() {
        java.lang.Object ref = translation_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          translation_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The translated sentence.
       * </pre>
       *
       * <code>string translation = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for translation.
       */
      public com.google.protobuf.ByteString getTranslationBytes() {
        java.lang.Object ref = translation_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          translation_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The translated sentence.
       * </pre>
       *
       * <code>string translation = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The translation to set.
       * @return This builder for chaining.
       */
      public Builder setTranslation(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        translation_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The translated sentence.
       * </pre>
       *
       * <code>string translation = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTranslation() {

        translation_ = getDefaultInstance().getTranslation();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The translated sentence.
       * </pre>
       *
       * <code>string translation = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for translation to set.
       * @return This builder for chaining.
       */
      public Builder setTranslationBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        translation_ = value;
        onChanged();
        return this;
      }

      private boolean isFinal_;
      /**
       *
       *
       * <pre>
       * Output only. If `false`, this `StreamingTranslateSpeechResult` represents
       * an interim result that may change. If `true`, this is the final time the
       * translation service will return this particular
       * `StreamingTranslateSpeechResult`, the streaming translator will not
       * return any further hypotheses for this portion of the transcript and
       * corresponding audio.
       * </pre>
       *
       * <code>bool is_final = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The isFinal.
       */
      @java.lang.Override
      public boolean getIsFinal() {
        return isFinal_;
      }
      /**
       *
       *
       * <pre>
       * Output only. If `false`, this `StreamingTranslateSpeechResult` represents
       * an interim result that may change. If `true`, this is the final time the
       * translation service will return this particular
       * `StreamingTranslateSpeechResult`, the streaming translator will not
       * return any further hypotheses for this portion of the transcript and
       * corresponding audio.
       * </pre>
       *
       * <code>bool is_final = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The isFinal to set.
       * @return This builder for chaining.
       */
      public Builder setIsFinal(boolean value) {

        isFinal_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. If `false`, this `StreamingTranslateSpeechResult` represents
       * an interim result that may change. If `true`, this is the final time the
       * translation service will return this particular
       * `StreamingTranslateSpeechResult`, the streaming translator will not
       * return any further hypotheses for this portion of the transcript and
       * corresponding audio.
       * </pre>
       *
       * <code>bool is_final = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIsFinal() {

        isFinal_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult)
    private static final com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
              .TextTranslationResult();
    }

    public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TextTranslationResult> PARSER =
        new com.google.protobuf.AbstractParser<TextTranslationResult>() {
          @java.lang.Override
          public TextTranslationResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new TextTranslationResult(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<TextTranslationResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TextTranslationResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int resultCase_ = 0;
  private java.lang.Object result_;

  public enum ResultCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TEXT_TRANSLATION_RESULT(1),
    RESULT_NOT_SET(0);
    private final int value;

    private ResultCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResultCase valueOf(int value) {
      return forNumber(value);
    }

    public static ResultCase forNumber(int value) {
      switch (value) {
        case 1:
          return TEXT_TRANSLATION_RESULT;
        case 0:
          return RESULT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ResultCase getResultCase() {
    return ResultCase.forNumber(resultCase_);
  }

  public static final int TEXT_TRANSLATION_RESULT_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Text translation result.
   * </pre>
   *
   * <code>
   * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult text_translation_result = 1;
   * </code>
   *
   * @return Whether the textTranslationResult field is set.
   */
  @java.lang.Override
  public boolean hasTextTranslationResult() {
    return resultCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Text translation result.
   * </pre>
   *
   * <code>
   * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult text_translation_result = 1;
   * </code>
   *
   * @return The textTranslationResult.
   */
  @java.lang.Override
  public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
          .TextTranslationResult
      getTextTranslationResult() {
    if (resultCase_ == 1) {
      return (com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
              .TextTranslationResult)
          result_;
    }
    return com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
        .TextTranslationResult.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Text translation result.
   * </pre>
   *
   * <code>
   * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult text_translation_result = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
          .TextTranslationResultOrBuilder
      getTextTranslationResultOrBuilder() {
    if (resultCase_ == 1) {
      return (com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
              .TextTranslationResult)
          result_;
    }
    return com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
        .TextTranslationResult.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (resultCase_ == 1) {
      output.writeMessage(
          1,
          (com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                  .TextTranslationResult)
              result_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (resultCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                      .TextTranslationResult)
                  result_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult)) {
      return super.equals(obj);
    }
    com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult other =
        (com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult) obj;

    if (!getResultCase().equals(other.getResultCase())) return false;
    switch (resultCase_) {
      case 1:
        if (!getTextTranslationResult().equals(other.getTextTranslationResult())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (resultCase_) {
      case 1:
        hash = (37 * hash) + TEXT_TRANSLATION_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getTextTranslationResult().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A streaming speech translation result corresponding to a portion of the audio
   * that is currently being processed.
   * </pre>
   *
   * Protobuf type {@code google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult)
      com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
          .internal_static_google_cloud_mediatranslation_v1beta1_StreamingTranslateSpeechResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
          .internal_static_google_cloud_mediatranslation_v1beta1_StreamingTranslateSpeechResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.class,
              com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      resultCase_ = 0;
      result_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.mediatranslation.v1beta1.MediaTranslationProto
          .internal_static_google_cloud_mediatranslation_v1beta1_StreamingTranslateSpeechResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
        getDefaultInstanceForType() {
      return com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult build() {
      com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult buildPartial() {
      com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult result =
          new com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult(this);
      if (resultCase_ == 1) {
        if (textTranslationResultBuilder_ == null) {
          result.result_ = result_;
        } else {
          result.result_ = textTranslationResultBuilder_.build();
        }
      }
      result.resultCase_ = resultCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult) {
        return mergeFrom(
            (com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult other) {
      if (other
          == com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
              .getDefaultInstance()) return this;
      switch (other.getResultCase()) {
        case TEXT_TRANSLATION_RESULT:
          {
            mergeTextTranslationResult(other.getTextTranslationResult());
            break;
          }
        case RESULT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int resultCase_ = 0;
    private java.lang.Object result_;

    public ResultCase getResultCase() {
      return ResultCase.forNumber(resultCase_);
    }

    public Builder clearResult() {
      resultCase_ = 0;
      result_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                .TextTranslationResult,
            com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                .TextTranslationResult.Builder,
            com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                .TextTranslationResultOrBuilder>
        textTranslationResultBuilder_;
    /**
     *
     *
     * <pre>
     * Text translation result.
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult text_translation_result = 1;
     * </code>
     *
     * @return Whether the textTranslationResult field is set.
     */
    @java.lang.Override
    public boolean hasTextTranslationResult() {
      return resultCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Text translation result.
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult text_translation_result = 1;
     * </code>
     *
     * @return The textTranslationResult.
     */
    @java.lang.Override
    public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult
        getTextTranslationResult() {
      if (textTranslationResultBuilder_ == null) {
        if (resultCase_ == 1) {
          return (com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                  .TextTranslationResult)
              result_;
        }
        return com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult.getDefaultInstance();
      } else {
        if (resultCase_ == 1) {
          return textTranslationResultBuilder_.getMessage();
        }
        return com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Text translation result.
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult text_translation_result = 1;
     * </code>
     */
    public Builder setTextTranslationResult(
        com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                .TextTranslationResult
            value) {
      if (textTranslationResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        result_ = value;
        onChanged();
      } else {
        textTranslationResultBuilder_.setMessage(value);
      }
      resultCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation result.
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult text_translation_result = 1;
     * </code>
     */
    public Builder setTextTranslationResult(
        com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                .TextTranslationResult.Builder
            builderForValue) {
      if (textTranslationResultBuilder_ == null) {
        result_ = builderForValue.build();
        onChanged();
      } else {
        textTranslationResultBuilder_.setMessage(builderForValue.build());
      }
      resultCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation result.
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult text_translation_result = 1;
     * </code>
     */
    public Builder mergeTextTranslationResult(
        com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                .TextTranslationResult
            value) {
      if (textTranslationResultBuilder_ == null) {
        if (resultCase_ == 1
            && result_
                != com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                    .TextTranslationResult.getDefaultInstance()) {
          result_ =
              com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                  .TextTranslationResult.newBuilder(
                      (com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                              .TextTranslationResult)
                          result_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          result_ = value;
        }
        onChanged();
      } else {
        if (resultCase_ == 1) {
          textTranslationResultBuilder_.mergeFrom(value);
        }
        textTranslationResultBuilder_.setMessage(value);
      }
      resultCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation result.
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult text_translation_result = 1;
     * </code>
     */
    public Builder clearTextTranslationResult() {
      if (textTranslationResultBuilder_ == null) {
        if (resultCase_ == 1) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
      } else {
        if (resultCase_ == 1) {
          resultCase_ = 0;
          result_ = null;
        }
        textTranslationResultBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation result.
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult text_translation_result = 1;
     * </code>
     */
    public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult.Builder
        getTextTranslationResultBuilder() {
      return getTextTranslationResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Text translation result.
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult text_translation_result = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResultOrBuilder
        getTextTranslationResultOrBuilder() {
      if ((resultCase_ == 1) && (textTranslationResultBuilder_ != null)) {
        return textTranslationResultBuilder_.getMessageOrBuilder();
      } else {
        if (resultCase_ == 1) {
          return (com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                  .TextTranslationResult)
              result_;
        }
        return com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
            .TextTranslationResult.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Text translation result.
     * </pre>
     *
     * <code>
     * .google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult.TextTranslationResult text_translation_result = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                .TextTranslationResult,
            com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                .TextTranslationResult.Builder,
            com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                .TextTranslationResultOrBuilder>
        getTextTranslationResultFieldBuilder() {
      if (textTranslationResultBuilder_ == null) {
        if (!(resultCase_ == 1)) {
          result_ =
              com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                  .TextTranslationResult.getDefaultInstance();
        }
        textTranslationResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                    .TextTranslationResult,
                com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                    .TextTranslationResult.Builder,
                com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                    .TextTranslationResultOrBuilder>(
                (com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
                        .TextTranslationResult)
                    result_,
                getParentForChildren(),
                isClean());
        result_ = null;
      }
      resultCase_ = 1;
      onChanged();
      ;
      return textTranslationResultBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult)
  private static final com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult();
  }

  public static com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamingTranslateSpeechResult> PARSER =
      new com.google.protobuf.AbstractParser<StreamingTranslateSpeechResult>() {
        @java.lang.Override
        public StreamingTranslateSpeechResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new StreamingTranslateSpeechResult(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<StreamingTranslateSpeechResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamingTranslateSpeechResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.mediatranslation.v1beta1.StreamingTranslateSpeechResult
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
