/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/apps/meet/v2/resource.proto

// Protobuf Java Version: 3.25.2
package com.google.apps.meet.v2;

/**
 *
 *
 * <pre>
 * User who attended or is attending a conference.
 * </pre>
 *
 * Protobuf type {@code google.apps.meet.v2.Participant}
 */
public final class Participant extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.apps.meet.v2.Participant)
    ParticipantOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Participant.newBuilder() to construct.
  private Participant(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Participant() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Participant();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.apps.meet.v2.ResourceProto
        .internal_static_google_apps_meet_v2_Participant_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.apps.meet.v2.ResourceProto
        .internal_static_google_apps_meet_v2_Participant_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.apps.meet.v2.Participant.class,
            com.google.apps.meet.v2.Participant.Builder.class);
  }

  private int bitField0_;
  private int userCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object user_;

  public enum UserCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SIGNEDIN_USER(4),
    ANONYMOUS_USER(5),
    PHONE_USER(6),
    USER_NOT_SET(0);
    private final int value;

    private UserCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static UserCase valueOf(int value) {
      return forNumber(value);
    }

    public static UserCase forNumber(int value) {
      switch (value) {
        case 4:
          return SIGNEDIN_USER;
        case 5:
          return ANONYMOUS_USER;
        case 6:
          return PHONE_USER;
        case 0:
          return USER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public UserCase getUserCase() {
    return UserCase.forNumber(userCase_);
  }

  public static final int SIGNEDIN_USER_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Signed-in user.
   * </pre>
   *
   * <code>.google.apps.meet.v2.SignedinUser signedin_user = 4;</code>
   *
   * @return Whether the signedinUser field is set.
   */
  @java.lang.Override
  public boolean hasSignedinUser() {
    return userCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Signed-in user.
   * </pre>
   *
   * <code>.google.apps.meet.v2.SignedinUser signedin_user = 4;</code>
   *
   * @return The signedinUser.
   */
  @java.lang.Override
  public com.google.apps.meet.v2.SignedinUser getSignedinUser() {
    if (userCase_ == 4) {
      return (com.google.apps.meet.v2.SignedinUser) user_;
    }
    return com.google.apps.meet.v2.SignedinUser.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Signed-in user.
   * </pre>
   *
   * <code>.google.apps.meet.v2.SignedinUser signedin_user = 4;</code>
   */
  @java.lang.Override
  public com.google.apps.meet.v2.SignedinUserOrBuilder getSignedinUserOrBuilder() {
    if (userCase_ == 4) {
      return (com.google.apps.meet.v2.SignedinUser) user_;
    }
    return com.google.apps.meet.v2.SignedinUser.getDefaultInstance();
  }

  public static final int ANONYMOUS_USER_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Anonymous user.
   * </pre>
   *
   * <code>.google.apps.meet.v2.AnonymousUser anonymous_user = 5;</code>
   *
   * @return Whether the anonymousUser field is set.
   */
  @java.lang.Override
  public boolean hasAnonymousUser() {
    return userCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Anonymous user.
   * </pre>
   *
   * <code>.google.apps.meet.v2.AnonymousUser anonymous_user = 5;</code>
   *
   * @return The anonymousUser.
   */
  @java.lang.Override
  public com.google.apps.meet.v2.AnonymousUser getAnonymousUser() {
    if (userCase_ == 5) {
      return (com.google.apps.meet.v2.AnonymousUser) user_;
    }
    return com.google.apps.meet.v2.AnonymousUser.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Anonymous user.
   * </pre>
   *
   * <code>.google.apps.meet.v2.AnonymousUser anonymous_user = 5;</code>
   */
  @java.lang.Override
  public com.google.apps.meet.v2.AnonymousUserOrBuilder getAnonymousUserOrBuilder() {
    if (userCase_ == 5) {
      return (com.google.apps.meet.v2.AnonymousUser) user_;
    }
    return com.google.apps.meet.v2.AnonymousUser.getDefaultInstance();
  }

  public static final int PHONE_USER_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * User calling from their phone.
   * </pre>
   *
   * <code>.google.apps.meet.v2.PhoneUser phone_user = 6;</code>
   *
   * @return Whether the phoneUser field is set.
   */
  @java.lang.Override
  public boolean hasPhoneUser() {
    return userCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * User calling from their phone.
   * </pre>
   *
   * <code>.google.apps.meet.v2.PhoneUser phone_user = 6;</code>
   *
   * @return The phoneUser.
   */
  @java.lang.Override
  public com.google.apps.meet.v2.PhoneUser getPhoneUser() {
    if (userCase_ == 6) {
      return (com.google.apps.meet.v2.PhoneUser) user_;
    }
    return com.google.apps.meet.v2.PhoneUser.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * User calling from their phone.
   * </pre>
   *
   * <code>.google.apps.meet.v2.PhoneUser phone_user = 6;</code>
   */
  @java.lang.Override
  public com.google.apps.meet.v2.PhoneUserOrBuilder getPhoneUserOrBuilder() {
    if (userCase_ == 6) {
      return (com.google.apps.meet.v2.PhoneUser) user_;
    }
    return com.google.apps.meet.v2.PhoneUser.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the participant.
   * Format: `conferenceRecords/{conference_record}/participants/{participant}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of the participant.
   * Format: `conferenceRecords/{conference_record}/participants/{participant}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EARLIEST_START_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp earliestStartTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the participant first joined the meeting.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp earliest_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the earliestStartTime field is set.
   */
  @java.lang.Override
  public boolean hasEarliestStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the participant first joined the meeting.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp earliest_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The earliestStartTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEarliestStartTime() {
    return earliestStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : earliestStartTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the participant first joined the meeting.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp earliest_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEarliestStartTimeOrBuilder() {
    return earliestStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : earliestStartTime_;
  }

  public static final int LATEST_END_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp latestEndTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time when the participant left the meeting for the last time.
   * This can be null if it's an active meeting.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp latest_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the latestEndTime field is set.
   */
  @java.lang.Override
  public boolean hasLatestEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the participant left the meeting for the last time.
   * This can be null if it's an active meeting.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp latest_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The latestEndTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLatestEndTime() {
    return latestEndTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : latestEndTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time when the participant left the meeting for the last time.
   * This can be null if it's an active meeting.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp latest_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLatestEndTimeOrBuilder() {
    return latestEndTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : latestEndTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (userCase_ == 4) {
      output.writeMessage(4, (com.google.apps.meet.v2.SignedinUser) user_);
    }
    if (userCase_ == 5) {
      output.writeMessage(5, (com.google.apps.meet.v2.AnonymousUser) user_);
    }
    if (userCase_ == 6) {
      output.writeMessage(6, (com.google.apps.meet.v2.PhoneUser) user_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getEarliestStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getLatestEndTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (userCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.apps.meet.v2.SignedinUser) user_);
    }
    if (userCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.apps.meet.v2.AnonymousUser) user_);
    }
    if (userCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.apps.meet.v2.PhoneUser) user_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getEarliestStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getLatestEndTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.apps.meet.v2.Participant)) {
      return super.equals(obj);
    }
    com.google.apps.meet.v2.Participant other = (com.google.apps.meet.v2.Participant) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasEarliestStartTime() != other.hasEarliestStartTime()) return false;
    if (hasEarliestStartTime()) {
      if (!getEarliestStartTime().equals(other.getEarliestStartTime())) return false;
    }
    if (hasLatestEndTime() != other.hasLatestEndTime()) return false;
    if (hasLatestEndTime()) {
      if (!getLatestEndTime().equals(other.getLatestEndTime())) return false;
    }
    if (!getUserCase().equals(other.getUserCase())) return false;
    switch (userCase_) {
      case 4:
        if (!getSignedinUser().equals(other.getSignedinUser())) return false;
        break;
      case 5:
        if (!getAnonymousUser().equals(other.getAnonymousUser())) return false;
        break;
      case 6:
        if (!getPhoneUser().equals(other.getPhoneUser())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasEarliestStartTime()) {
      hash = (37 * hash) + EARLIEST_START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEarliestStartTime().hashCode();
    }
    if (hasLatestEndTime()) {
      hash = (37 * hash) + LATEST_END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLatestEndTime().hashCode();
    }
    switch (userCase_) {
      case 4:
        hash = (37 * hash) + SIGNEDIN_USER_FIELD_NUMBER;
        hash = (53 * hash) + getSignedinUser().hashCode();
        break;
      case 5:
        hash = (37 * hash) + ANONYMOUS_USER_FIELD_NUMBER;
        hash = (53 * hash) + getAnonymousUser().hashCode();
        break;
      case 6:
        hash = (37 * hash) + PHONE_USER_FIELD_NUMBER;
        hash = (53 * hash) + getPhoneUser().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.apps.meet.v2.Participant parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.meet.v2.Participant parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.meet.v2.Participant parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.meet.v2.Participant parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.meet.v2.Participant parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.meet.v2.Participant parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.meet.v2.Participant parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.meet.v2.Participant parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.meet.v2.Participant parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.apps.meet.v2.Participant parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.meet.v2.Participant parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.meet.v2.Participant parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.apps.meet.v2.Participant prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * User who attended or is attending a conference.
   * </pre>
   *
   * Protobuf type {@code google.apps.meet.v2.Participant}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.apps.meet.v2.Participant)
      com.google.apps.meet.v2.ParticipantOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.meet.v2.ResourceProto
          .internal_static_google_apps_meet_v2_Participant_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.meet.v2.ResourceProto
          .internal_static_google_apps_meet_v2_Participant_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.meet.v2.Participant.class,
              com.google.apps.meet.v2.Participant.Builder.class);
    }

    // Construct using com.google.apps.meet.v2.Participant.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEarliestStartTimeFieldBuilder();
        getLatestEndTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (signedinUserBuilder_ != null) {
        signedinUserBuilder_.clear();
      }
      if (anonymousUserBuilder_ != null) {
        anonymousUserBuilder_.clear();
      }
      if (phoneUserBuilder_ != null) {
        phoneUserBuilder_.clear();
      }
      name_ = "";
      earliestStartTime_ = null;
      if (earliestStartTimeBuilder_ != null) {
        earliestStartTimeBuilder_.dispose();
        earliestStartTimeBuilder_ = null;
      }
      latestEndTime_ = null;
      if (latestEndTimeBuilder_ != null) {
        latestEndTimeBuilder_.dispose();
        latestEndTimeBuilder_ = null;
      }
      userCase_ = 0;
      user_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.apps.meet.v2.ResourceProto
          .internal_static_google_apps_meet_v2_Participant_descriptor;
    }

    @java.lang.Override
    public com.google.apps.meet.v2.Participant getDefaultInstanceForType() {
      return com.google.apps.meet.v2.Participant.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.apps.meet.v2.Participant build() {
      com.google.apps.meet.v2.Participant result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.apps.meet.v2.Participant buildPartial() {
      com.google.apps.meet.v2.Participant result = new com.google.apps.meet.v2.Participant(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.apps.meet.v2.Participant result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.earliestStartTime_ =
            earliestStartTimeBuilder_ == null
                ? earliestStartTime_
                : earliestStartTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.latestEndTime_ =
            latestEndTimeBuilder_ == null ? latestEndTime_ : latestEndTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.apps.meet.v2.Participant result) {
      result.userCase_ = userCase_;
      result.user_ = this.user_;
      if (userCase_ == 4 && signedinUserBuilder_ != null) {
        result.user_ = signedinUserBuilder_.build();
      }
      if (userCase_ == 5 && anonymousUserBuilder_ != null) {
        result.user_ = anonymousUserBuilder_.build();
      }
      if (userCase_ == 6 && phoneUserBuilder_ != null) {
        result.user_ = phoneUserBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.apps.meet.v2.Participant) {
        return mergeFrom((com.google.apps.meet.v2.Participant) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.apps.meet.v2.Participant other) {
      if (other == com.google.apps.meet.v2.Participant.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasEarliestStartTime()) {
        mergeEarliestStartTime(other.getEarliestStartTime());
      }
      if (other.hasLatestEndTime()) {
        mergeLatestEndTime(other.getLatestEndTime());
      }
      switch (other.getUserCase()) {
        case SIGNEDIN_USER:
          {
            mergeSignedinUser(other.getSignedinUser());
            break;
          }
        case ANONYMOUS_USER:
          {
            mergeAnonymousUser(other.getAnonymousUser());
            break;
          }
        case PHONE_USER:
          {
            mergePhoneUser(other.getPhoneUser());
            break;
          }
        case USER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 34:
              {
                input.readMessage(getSignedinUserFieldBuilder().getBuilder(), extensionRegistry);
                userCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getAnonymousUserFieldBuilder().getBuilder(), extensionRegistry);
                userCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getPhoneUserFieldBuilder().getBuilder(), extensionRegistry);
                userCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getEarliestStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getLatestEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int userCase_ = 0;
    private java.lang.Object user_;

    public UserCase getUserCase() {
      return UserCase.forNumber(userCase_);
    }

    public Builder clearUser() {
      userCase_ = 0;
      user_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.meet.v2.SignedinUser,
            com.google.apps.meet.v2.SignedinUser.Builder,
            com.google.apps.meet.v2.SignedinUserOrBuilder>
        signedinUserBuilder_;
    /**
     *
     *
     * <pre>
     * Signed-in user.
     * </pre>
     *
     * <code>.google.apps.meet.v2.SignedinUser signedin_user = 4;</code>
     *
     * @return Whether the signedinUser field is set.
     */
    @java.lang.Override
    public boolean hasSignedinUser() {
      return userCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Signed-in user.
     * </pre>
     *
     * <code>.google.apps.meet.v2.SignedinUser signedin_user = 4;</code>
     *
     * @return The signedinUser.
     */
    @java.lang.Override
    public com.google.apps.meet.v2.SignedinUser getSignedinUser() {
      if (signedinUserBuilder_ == null) {
        if (userCase_ == 4) {
          return (com.google.apps.meet.v2.SignedinUser) user_;
        }
        return com.google.apps.meet.v2.SignedinUser.getDefaultInstance();
      } else {
        if (userCase_ == 4) {
          return signedinUserBuilder_.getMessage();
        }
        return com.google.apps.meet.v2.SignedinUser.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Signed-in user.
     * </pre>
     *
     * <code>.google.apps.meet.v2.SignedinUser signedin_user = 4;</code>
     */
    public Builder setSignedinUser(com.google.apps.meet.v2.SignedinUser value) {
      if (signedinUserBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        user_ = value;
        onChanged();
      } else {
        signedinUserBuilder_.setMessage(value);
      }
      userCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Signed-in user.
     * </pre>
     *
     * <code>.google.apps.meet.v2.SignedinUser signedin_user = 4;</code>
     */
    public Builder setSignedinUser(com.google.apps.meet.v2.SignedinUser.Builder builderForValue) {
      if (signedinUserBuilder_ == null) {
        user_ = builderForValue.build();
        onChanged();
      } else {
        signedinUserBuilder_.setMessage(builderForValue.build());
      }
      userCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Signed-in user.
     * </pre>
     *
     * <code>.google.apps.meet.v2.SignedinUser signedin_user = 4;</code>
     */
    public Builder mergeSignedinUser(com.google.apps.meet.v2.SignedinUser value) {
      if (signedinUserBuilder_ == null) {
        if (userCase_ == 4 && user_ != com.google.apps.meet.v2.SignedinUser.getDefaultInstance()) {
          user_ =
              com.google.apps.meet.v2.SignedinUser.newBuilder(
                      (com.google.apps.meet.v2.SignedinUser) user_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          user_ = value;
        }
        onChanged();
      } else {
        if (userCase_ == 4) {
          signedinUserBuilder_.mergeFrom(value);
        } else {
          signedinUserBuilder_.setMessage(value);
        }
      }
      userCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Signed-in user.
     * </pre>
     *
     * <code>.google.apps.meet.v2.SignedinUser signedin_user = 4;</code>
     */
    public Builder clearSignedinUser() {
      if (signedinUserBuilder_ == null) {
        if (userCase_ == 4) {
          userCase_ = 0;
          user_ = null;
          onChanged();
        }
      } else {
        if (userCase_ == 4) {
          userCase_ = 0;
          user_ = null;
        }
        signedinUserBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Signed-in user.
     * </pre>
     *
     * <code>.google.apps.meet.v2.SignedinUser signedin_user = 4;</code>
     */
    public com.google.apps.meet.v2.SignedinUser.Builder getSignedinUserBuilder() {
      return getSignedinUserFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Signed-in user.
     * </pre>
     *
     * <code>.google.apps.meet.v2.SignedinUser signedin_user = 4;</code>
     */
    @java.lang.Override
    public com.google.apps.meet.v2.SignedinUserOrBuilder getSignedinUserOrBuilder() {
      if ((userCase_ == 4) && (signedinUserBuilder_ != null)) {
        return signedinUserBuilder_.getMessageOrBuilder();
      } else {
        if (userCase_ == 4) {
          return (com.google.apps.meet.v2.SignedinUser) user_;
        }
        return com.google.apps.meet.v2.SignedinUser.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Signed-in user.
     * </pre>
     *
     * <code>.google.apps.meet.v2.SignedinUser signedin_user = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.meet.v2.SignedinUser,
            com.google.apps.meet.v2.SignedinUser.Builder,
            com.google.apps.meet.v2.SignedinUserOrBuilder>
        getSignedinUserFieldBuilder() {
      if (signedinUserBuilder_ == null) {
        if (!(userCase_ == 4)) {
          user_ = com.google.apps.meet.v2.SignedinUser.getDefaultInstance();
        }
        signedinUserBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.meet.v2.SignedinUser,
                com.google.apps.meet.v2.SignedinUser.Builder,
                com.google.apps.meet.v2.SignedinUserOrBuilder>(
                (com.google.apps.meet.v2.SignedinUser) user_, getParentForChildren(), isClean());
        user_ = null;
      }
      userCase_ = 4;
      onChanged();
      return signedinUserBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.meet.v2.AnonymousUser,
            com.google.apps.meet.v2.AnonymousUser.Builder,
            com.google.apps.meet.v2.AnonymousUserOrBuilder>
        anonymousUserBuilder_;
    /**
     *
     *
     * <pre>
     * Anonymous user.
     * </pre>
     *
     * <code>.google.apps.meet.v2.AnonymousUser anonymous_user = 5;</code>
     *
     * @return Whether the anonymousUser field is set.
     */
    @java.lang.Override
    public boolean hasAnonymousUser() {
      return userCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Anonymous user.
     * </pre>
     *
     * <code>.google.apps.meet.v2.AnonymousUser anonymous_user = 5;</code>
     *
     * @return The anonymousUser.
     */
    @java.lang.Override
    public com.google.apps.meet.v2.AnonymousUser getAnonymousUser() {
      if (anonymousUserBuilder_ == null) {
        if (userCase_ == 5) {
          return (com.google.apps.meet.v2.AnonymousUser) user_;
        }
        return com.google.apps.meet.v2.AnonymousUser.getDefaultInstance();
      } else {
        if (userCase_ == 5) {
          return anonymousUserBuilder_.getMessage();
        }
        return com.google.apps.meet.v2.AnonymousUser.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Anonymous user.
     * </pre>
     *
     * <code>.google.apps.meet.v2.AnonymousUser anonymous_user = 5;</code>
     */
    public Builder setAnonymousUser(com.google.apps.meet.v2.AnonymousUser value) {
      if (anonymousUserBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        user_ = value;
        onChanged();
      } else {
        anonymousUserBuilder_.setMessage(value);
      }
      userCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Anonymous user.
     * </pre>
     *
     * <code>.google.apps.meet.v2.AnonymousUser anonymous_user = 5;</code>
     */
    public Builder setAnonymousUser(com.google.apps.meet.v2.AnonymousUser.Builder builderForValue) {
      if (anonymousUserBuilder_ == null) {
        user_ = builderForValue.build();
        onChanged();
      } else {
        anonymousUserBuilder_.setMessage(builderForValue.build());
      }
      userCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Anonymous user.
     * </pre>
     *
     * <code>.google.apps.meet.v2.AnonymousUser anonymous_user = 5;</code>
     */
    public Builder mergeAnonymousUser(com.google.apps.meet.v2.AnonymousUser value) {
      if (anonymousUserBuilder_ == null) {
        if (userCase_ == 5 && user_ != com.google.apps.meet.v2.AnonymousUser.getDefaultInstance()) {
          user_ =
              com.google.apps.meet.v2.AnonymousUser.newBuilder(
                      (com.google.apps.meet.v2.AnonymousUser) user_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          user_ = value;
        }
        onChanged();
      } else {
        if (userCase_ == 5) {
          anonymousUserBuilder_.mergeFrom(value);
        } else {
          anonymousUserBuilder_.setMessage(value);
        }
      }
      userCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Anonymous user.
     * </pre>
     *
     * <code>.google.apps.meet.v2.AnonymousUser anonymous_user = 5;</code>
     */
    public Builder clearAnonymousUser() {
      if (anonymousUserBuilder_ == null) {
        if (userCase_ == 5) {
          userCase_ = 0;
          user_ = null;
          onChanged();
        }
      } else {
        if (userCase_ == 5) {
          userCase_ = 0;
          user_ = null;
        }
        anonymousUserBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Anonymous user.
     * </pre>
     *
     * <code>.google.apps.meet.v2.AnonymousUser anonymous_user = 5;</code>
     */
    public com.google.apps.meet.v2.AnonymousUser.Builder getAnonymousUserBuilder() {
      return getAnonymousUserFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Anonymous user.
     * </pre>
     *
     * <code>.google.apps.meet.v2.AnonymousUser anonymous_user = 5;</code>
     */
    @java.lang.Override
    public com.google.apps.meet.v2.AnonymousUserOrBuilder getAnonymousUserOrBuilder() {
      if ((userCase_ == 5) && (anonymousUserBuilder_ != null)) {
        return anonymousUserBuilder_.getMessageOrBuilder();
      } else {
        if (userCase_ == 5) {
          return (com.google.apps.meet.v2.AnonymousUser) user_;
        }
        return com.google.apps.meet.v2.AnonymousUser.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Anonymous user.
     * </pre>
     *
     * <code>.google.apps.meet.v2.AnonymousUser anonymous_user = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.meet.v2.AnonymousUser,
            com.google.apps.meet.v2.AnonymousUser.Builder,
            com.google.apps.meet.v2.AnonymousUserOrBuilder>
        getAnonymousUserFieldBuilder() {
      if (anonymousUserBuilder_ == null) {
        if (!(userCase_ == 5)) {
          user_ = com.google.apps.meet.v2.AnonymousUser.getDefaultInstance();
        }
        anonymousUserBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.meet.v2.AnonymousUser,
                com.google.apps.meet.v2.AnonymousUser.Builder,
                com.google.apps.meet.v2.AnonymousUserOrBuilder>(
                (com.google.apps.meet.v2.AnonymousUser) user_, getParentForChildren(), isClean());
        user_ = null;
      }
      userCase_ = 5;
      onChanged();
      return anonymousUserBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.meet.v2.PhoneUser,
            com.google.apps.meet.v2.PhoneUser.Builder,
            com.google.apps.meet.v2.PhoneUserOrBuilder>
        phoneUserBuilder_;
    /**
     *
     *
     * <pre>
     * User calling from their phone.
     * </pre>
     *
     * <code>.google.apps.meet.v2.PhoneUser phone_user = 6;</code>
     *
     * @return Whether the phoneUser field is set.
     */
    @java.lang.Override
    public boolean hasPhoneUser() {
      return userCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * User calling from their phone.
     * </pre>
     *
     * <code>.google.apps.meet.v2.PhoneUser phone_user = 6;</code>
     *
     * @return The phoneUser.
     */
    @java.lang.Override
    public com.google.apps.meet.v2.PhoneUser getPhoneUser() {
      if (phoneUserBuilder_ == null) {
        if (userCase_ == 6) {
          return (com.google.apps.meet.v2.PhoneUser) user_;
        }
        return com.google.apps.meet.v2.PhoneUser.getDefaultInstance();
      } else {
        if (userCase_ == 6) {
          return phoneUserBuilder_.getMessage();
        }
        return com.google.apps.meet.v2.PhoneUser.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * User calling from their phone.
     * </pre>
     *
     * <code>.google.apps.meet.v2.PhoneUser phone_user = 6;</code>
     */
    public Builder setPhoneUser(com.google.apps.meet.v2.PhoneUser value) {
      if (phoneUserBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        user_ = value;
        onChanged();
      } else {
        phoneUserBuilder_.setMessage(value);
      }
      userCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * User calling from their phone.
     * </pre>
     *
     * <code>.google.apps.meet.v2.PhoneUser phone_user = 6;</code>
     */
    public Builder setPhoneUser(com.google.apps.meet.v2.PhoneUser.Builder builderForValue) {
      if (phoneUserBuilder_ == null) {
        user_ = builderForValue.build();
        onChanged();
      } else {
        phoneUserBuilder_.setMessage(builderForValue.build());
      }
      userCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * User calling from their phone.
     * </pre>
     *
     * <code>.google.apps.meet.v2.PhoneUser phone_user = 6;</code>
     */
    public Builder mergePhoneUser(com.google.apps.meet.v2.PhoneUser value) {
      if (phoneUserBuilder_ == null) {
        if (userCase_ == 6 && user_ != com.google.apps.meet.v2.PhoneUser.getDefaultInstance()) {
          user_ =
              com.google.apps.meet.v2.PhoneUser.newBuilder(
                      (com.google.apps.meet.v2.PhoneUser) user_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          user_ = value;
        }
        onChanged();
      } else {
        if (userCase_ == 6) {
          phoneUserBuilder_.mergeFrom(value);
        } else {
          phoneUserBuilder_.setMessage(value);
        }
      }
      userCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * User calling from their phone.
     * </pre>
     *
     * <code>.google.apps.meet.v2.PhoneUser phone_user = 6;</code>
     */
    public Builder clearPhoneUser() {
      if (phoneUserBuilder_ == null) {
        if (userCase_ == 6) {
          userCase_ = 0;
          user_ = null;
          onChanged();
        }
      } else {
        if (userCase_ == 6) {
          userCase_ = 0;
          user_ = null;
        }
        phoneUserBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * User calling from their phone.
     * </pre>
     *
     * <code>.google.apps.meet.v2.PhoneUser phone_user = 6;</code>
     */
    public com.google.apps.meet.v2.PhoneUser.Builder getPhoneUserBuilder() {
      return getPhoneUserFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * User calling from their phone.
     * </pre>
     *
     * <code>.google.apps.meet.v2.PhoneUser phone_user = 6;</code>
     */
    @java.lang.Override
    public com.google.apps.meet.v2.PhoneUserOrBuilder getPhoneUserOrBuilder() {
      if ((userCase_ == 6) && (phoneUserBuilder_ != null)) {
        return phoneUserBuilder_.getMessageOrBuilder();
      } else {
        if (userCase_ == 6) {
          return (com.google.apps.meet.v2.PhoneUser) user_;
        }
        return com.google.apps.meet.v2.PhoneUser.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * User calling from their phone.
     * </pre>
     *
     * <code>.google.apps.meet.v2.PhoneUser phone_user = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.meet.v2.PhoneUser,
            com.google.apps.meet.v2.PhoneUser.Builder,
            com.google.apps.meet.v2.PhoneUserOrBuilder>
        getPhoneUserFieldBuilder() {
      if (phoneUserBuilder_ == null) {
        if (!(userCase_ == 6)) {
          user_ = com.google.apps.meet.v2.PhoneUser.getDefaultInstance();
        }
        phoneUserBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.meet.v2.PhoneUser,
                com.google.apps.meet.v2.PhoneUser.Builder,
                com.google.apps.meet.v2.PhoneUserOrBuilder>(
                (com.google.apps.meet.v2.PhoneUser) user_, getParentForChildren(), isClean());
        user_ = null;
      }
      userCase_ = 6;
      onChanged();
      return phoneUserBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the participant.
     * Format: `conferenceRecords/{conference_record}/participants/{participant}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the participant.
     * Format: `conferenceRecords/{conference_record}/participants/{participant}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the participant.
     * Format: `conferenceRecords/{conference_record}/participants/{participant}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the participant.
     * Format: `conferenceRecords/{conference_record}/participants/{participant}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of the participant.
     * Format: `conferenceRecords/{conference_record}/participants/{participant}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp earliestStartTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        earliestStartTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the participant first joined the meeting.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the earliestStartTime field is set.
     */
    public boolean hasEarliestStartTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the participant first joined the meeting.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The earliestStartTime.
     */
    public com.google.protobuf.Timestamp getEarliestStartTime() {
      if (earliestStartTimeBuilder_ == null) {
        return earliestStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : earliestStartTime_;
      } else {
        return earliestStartTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the participant first joined the meeting.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEarliestStartTime(com.google.protobuf.Timestamp value) {
      if (earliestStartTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        earliestStartTime_ = value;
      } else {
        earliestStartTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the participant first joined the meeting.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEarliestStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (earliestStartTimeBuilder_ == null) {
        earliestStartTime_ = builderForValue.build();
      } else {
        earliestStartTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the participant first joined the meeting.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEarliestStartTime(com.google.protobuf.Timestamp value) {
      if (earliestStartTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && earliestStartTime_ != null
            && earliestStartTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEarliestStartTimeBuilder().mergeFrom(value);
        } else {
          earliestStartTime_ = value;
        }
      } else {
        earliestStartTimeBuilder_.mergeFrom(value);
      }
      if (earliestStartTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the participant first joined the meeting.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEarliestStartTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      earliestStartTime_ = null;
      if (earliestStartTimeBuilder_ != null) {
        earliestStartTimeBuilder_.dispose();
        earliestStartTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the participant first joined the meeting.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEarliestStartTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getEarliestStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the participant first joined the meeting.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEarliestStartTimeOrBuilder() {
      if (earliestStartTimeBuilder_ != null) {
        return earliestStartTimeBuilder_.getMessageOrBuilder();
      } else {
        return earliestStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : earliestStartTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the participant first joined the meeting.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp earliest_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEarliestStartTimeFieldBuilder() {
      if (earliestStartTimeBuilder_ == null) {
        earliestStartTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEarliestStartTime(), getParentForChildren(), isClean());
        earliestStartTime_ = null;
      }
      return earliestStartTimeBuilder_;
    }

    private com.google.protobuf.Timestamp latestEndTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        latestEndTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time when the participant left the meeting for the last time.
     * This can be null if it's an active meeting.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the latestEndTime field is set.
     */
    public boolean hasLatestEndTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the participant left the meeting for the last time.
     * This can be null if it's an active meeting.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The latestEndTime.
     */
    public com.google.protobuf.Timestamp getLatestEndTime() {
      if (latestEndTimeBuilder_ == null) {
        return latestEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : latestEndTime_;
      } else {
        return latestEndTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the participant left the meeting for the last time.
     * This can be null if it's an active meeting.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLatestEndTime(com.google.protobuf.Timestamp value) {
      if (latestEndTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        latestEndTime_ = value;
      } else {
        latestEndTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the participant left the meeting for the last time.
     * This can be null if it's an active meeting.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLatestEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (latestEndTimeBuilder_ == null) {
        latestEndTime_ = builderForValue.build();
      } else {
        latestEndTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the participant left the meeting for the last time.
     * This can be null if it's an active meeting.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLatestEndTime(com.google.protobuf.Timestamp value) {
      if (latestEndTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && latestEndTime_ != null
            && latestEndTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLatestEndTimeBuilder().mergeFrom(value);
        } else {
          latestEndTime_ = value;
        }
      } else {
        latestEndTimeBuilder_.mergeFrom(value);
      }
      if (latestEndTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the participant left the meeting for the last time.
     * This can be null if it's an active meeting.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLatestEndTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      latestEndTime_ = null;
      if (latestEndTimeBuilder_ != null) {
        latestEndTimeBuilder_.dispose();
        latestEndTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the participant left the meeting for the last time.
     * This can be null if it's an active meeting.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLatestEndTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getLatestEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the participant left the meeting for the last time.
     * This can be null if it's an active meeting.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLatestEndTimeOrBuilder() {
      if (latestEndTimeBuilder_ != null) {
        return latestEndTimeBuilder_.getMessageOrBuilder();
      } else {
        return latestEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : latestEndTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time when the participant left the meeting for the last time.
     * This can be null if it's an active meeting.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp latest_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLatestEndTimeFieldBuilder() {
      if (latestEndTimeBuilder_ == null) {
        latestEndTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLatestEndTime(), getParentForChildren(), isClean());
        latestEndTime_ = null;
      }
      return latestEndTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.apps.meet.v2.Participant)
  }

  // @@protoc_insertion_point(class_scope:google.apps.meet.v2.Participant)
  private static final com.google.apps.meet.v2.Participant DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.apps.meet.v2.Participant();
  }

  public static com.google.apps.meet.v2.Participant getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Participant> PARSER =
      new com.google.protobuf.AbstractParser<Participant>() {
        @java.lang.Override
        public Participant parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Participant> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Participant> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.apps.meet.v2.Participant getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
