/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/apps/meet/v2beta/resource.proto

// Protobuf Java Version: 3.25.2
package com.google.apps.meet.v2beta;

/**
 *
 *
 * <pre>
 * The configuration pertaining to a meeting space.
 * </pre>
 *
 * Protobuf type {@code google.apps.meet.v2beta.SpaceConfig}
 */
public final class SpaceConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.apps.meet.v2beta.SpaceConfig)
    SpaceConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SpaceConfig.newBuilder() to construct.
  private SpaceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SpaceConfig() {
    accessType_ = 0;
    entryPointAccess_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SpaceConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.apps.meet.v2beta.ResourceProto
        .internal_static_google_apps_meet_v2beta_SpaceConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.apps.meet.v2beta.ResourceProto
        .internal_static_google_apps_meet_v2beta_SpaceConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.apps.meet.v2beta.SpaceConfig.class,
            com.google.apps.meet.v2beta.SpaceConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible access types for a meeting space.
   * </pre>
   *
   * Protobuf enum {@code google.apps.meet.v2beta.SpaceConfig.AccessType}
   */
  public enum AccessType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value specified by the user's organization.
     * Note: This is never returned, as the configured access type is
     * returned instead.
     * </pre>
     *
     * <code>ACCESS_TYPE_UNSPECIFIED = 0;</code>
     */
    ACCESS_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Anyone with the join information (for example, the URL or phone access
     * information) can join without knocking.
     * </pre>
     *
     * <code>OPEN = 1;</code>
     */
    OPEN(1),
    /**
     *
     *
     * <pre>
     * Members of the host's organization, invited external users, and dial-in
     * users can join without knocking. Everyone else must knock.
     * </pre>
     *
     * <code>TRUSTED = 2;</code>
     */
    TRUSTED(2),
    /**
     *
     *
     * <pre>
     * Only invitees can join without knocking. Everyone else must knock.
     * </pre>
     *
     * <code>RESTRICTED = 3;</code>
     */
    RESTRICTED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value specified by the user's organization.
     * Note: This is never returned, as the configured access type is
     * returned instead.
     * </pre>
     *
     * <code>ACCESS_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int ACCESS_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Anyone with the join information (for example, the URL or phone access
     * information) can join without knocking.
     * </pre>
     *
     * <code>OPEN = 1;</code>
     */
    public static final int OPEN_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Members of the host's organization, invited external users, and dial-in
     * users can join without knocking. Everyone else must knock.
     * </pre>
     *
     * <code>TRUSTED = 2;</code>
     */
    public static final int TRUSTED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Only invitees can join without knocking. Everyone else must knock.
     * </pre>
     *
     * <code>RESTRICTED = 3;</code>
     */
    public static final int RESTRICTED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AccessType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AccessType forNumber(int value) {
      switch (value) {
        case 0:
          return ACCESS_TYPE_UNSPECIFIED;
        case 1:
          return OPEN;
        case 2:
          return TRUSTED;
        case 3:
          return RESTRICTED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AccessType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AccessType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<AccessType>() {
          public AccessType findValueByNumber(int number) {
            return AccessType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.apps.meet.v2beta.SpaceConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final AccessType[] VALUES = values();

    public static AccessType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AccessType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.apps.meet.v2beta.SpaceConfig.AccessType)
  }

  /**
   *
   *
   * <pre>
   * Entry points that can be used to join a meeting.  Example:
   * `meet.google.com`, the Embed SDK Web, or a mobile application.
   * </pre>
   *
   * Protobuf enum {@code google.apps.meet.v2beta.SpaceConfig.EntryPointAccess}
   */
  public enum EntryPointAccess implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>ENTRY_POINT_ACCESS_UNSPECIFIED = 0;</code>
     */
    ENTRY_POINT_ACCESS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * All entry points are allowed.
     * </pre>
     *
     * <code>ALL = 1;</code>
     */
    ALL(1),
    /**
     *
     *
     * <pre>
     * Only entry points owned by the Google Cloud project that created the
     * space can be used to join meetings in this space.  Apps can use the Embed
     * SDK Web or mobile Meet SDKs to create owned entry points.
     * </pre>
     *
     * <code>CREATOR_APP_ONLY = 2;</code>
     */
    CREATOR_APP_ONLY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unused.
     * </pre>
     *
     * <code>ENTRY_POINT_ACCESS_UNSPECIFIED = 0;</code>
     */
    public static final int ENTRY_POINT_ACCESS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * All entry points are allowed.
     * </pre>
     *
     * <code>ALL = 1;</code>
     */
    public static final int ALL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Only entry points owned by the Google Cloud project that created the
     * space can be used to join meetings in this space.  Apps can use the Embed
     * SDK Web or mobile Meet SDKs to create owned entry points.
     * </pre>
     *
     * <code>CREATOR_APP_ONLY = 2;</code>
     */
    public static final int CREATOR_APP_ONLY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EntryPointAccess valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static EntryPointAccess forNumber(int value) {
      switch (value) {
        case 0:
          return ENTRY_POINT_ACCESS_UNSPECIFIED;
        case 1:
          return ALL;
        case 2:
          return CREATOR_APP_ONLY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EntryPointAccess> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EntryPointAccess>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<EntryPointAccess>() {
              public EntryPointAccess findValueByNumber(int number) {
                return EntryPointAccess.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.apps.meet.v2beta.SpaceConfig.getDescriptor().getEnumTypes().get(1);
    }

    private static final EntryPointAccess[] VALUES = values();

    public static EntryPointAccess valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EntryPointAccess(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.apps.meet.v2beta.SpaceConfig.EntryPointAccess)
  }

  public static final int ACCESS_TYPE_FIELD_NUMBER = 1;
  private int accessType_ = 0;
  /**
   *
   *
   * <pre>
   * Access type of the meeting space that determines who can join without
   * knocking. Default: The user's default access settings.  Controlled by the
   * user's admin for enterprise users or RESTRICTED.
   * </pre>
   *
   * <code>.google.apps.meet.v2beta.SpaceConfig.AccessType access_type = 1;</code>
   *
   * @return The enum numeric value on the wire for accessType.
   */
  @java.lang.Override
  public int getAccessTypeValue() {
    return accessType_;
  }
  /**
   *
   *
   * <pre>
   * Access type of the meeting space that determines who can join without
   * knocking. Default: The user's default access settings.  Controlled by the
   * user's admin for enterprise users or RESTRICTED.
   * </pre>
   *
   * <code>.google.apps.meet.v2beta.SpaceConfig.AccessType access_type = 1;</code>
   *
   * @return The accessType.
   */
  @java.lang.Override
  public com.google.apps.meet.v2beta.SpaceConfig.AccessType getAccessType() {
    com.google.apps.meet.v2beta.SpaceConfig.AccessType result =
        com.google.apps.meet.v2beta.SpaceConfig.AccessType.forNumber(accessType_);
    return result == null
        ? com.google.apps.meet.v2beta.SpaceConfig.AccessType.UNRECOGNIZED
        : result;
  }

  public static final int ENTRY_POINT_ACCESS_FIELD_NUMBER = 2;
  private int entryPointAccess_ = 0;
  /**
   *
   *
   * <pre>
   * Defines the entry points that can be used to join meetings hosted in this
   * meeting space.
   * Default: EntryPointAccess.ALL
   * </pre>
   *
   * <code>.google.apps.meet.v2beta.SpaceConfig.EntryPointAccess entry_point_access = 2;</code>
   *
   * @return The enum numeric value on the wire for entryPointAccess.
   */
  @java.lang.Override
  public int getEntryPointAccessValue() {
    return entryPointAccess_;
  }
  /**
   *
   *
   * <pre>
   * Defines the entry points that can be used to join meetings hosted in this
   * meeting space.
   * Default: EntryPointAccess.ALL
   * </pre>
   *
   * <code>.google.apps.meet.v2beta.SpaceConfig.EntryPointAccess entry_point_access = 2;</code>
   *
   * @return The entryPointAccess.
   */
  @java.lang.Override
  public com.google.apps.meet.v2beta.SpaceConfig.EntryPointAccess getEntryPointAccess() {
    com.google.apps.meet.v2beta.SpaceConfig.EntryPointAccess result =
        com.google.apps.meet.v2beta.SpaceConfig.EntryPointAccess.forNumber(entryPointAccess_);
    return result == null
        ? com.google.apps.meet.v2beta.SpaceConfig.EntryPointAccess.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (accessType_
        != com.google.apps.meet.v2beta.SpaceConfig.AccessType.ACCESS_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, accessType_);
    }
    if (entryPointAccess_
        != com.google.apps.meet.v2beta.SpaceConfig.EntryPointAccess.ENTRY_POINT_ACCESS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, entryPointAccess_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (accessType_
        != com.google.apps.meet.v2beta.SpaceConfig.AccessType.ACCESS_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, accessType_);
    }
    if (entryPointAccess_
        != com.google.apps.meet.v2beta.SpaceConfig.EntryPointAccess.ENTRY_POINT_ACCESS_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, entryPointAccess_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.apps.meet.v2beta.SpaceConfig)) {
      return super.equals(obj);
    }
    com.google.apps.meet.v2beta.SpaceConfig other = (com.google.apps.meet.v2beta.SpaceConfig) obj;

    if (accessType_ != other.accessType_) return false;
    if (entryPointAccess_ != other.entryPointAccess_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ACCESS_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + accessType_;
    hash = (37 * hash) + ENTRY_POINT_ACCESS_FIELD_NUMBER;
    hash = (53 * hash) + entryPointAccess_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.apps.meet.v2beta.SpaceConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.meet.v2beta.SpaceConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.meet.v2beta.SpaceConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.meet.v2beta.SpaceConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.meet.v2beta.SpaceConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.meet.v2beta.SpaceConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.meet.v2beta.SpaceConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.meet.v2beta.SpaceConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.meet.v2beta.SpaceConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.apps.meet.v2beta.SpaceConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.meet.v2beta.SpaceConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.meet.v2beta.SpaceConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.apps.meet.v2beta.SpaceConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The configuration pertaining to a meeting space.
   * </pre>
   *
   * Protobuf type {@code google.apps.meet.v2beta.SpaceConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.apps.meet.v2beta.SpaceConfig)
      com.google.apps.meet.v2beta.SpaceConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.meet.v2beta.ResourceProto
          .internal_static_google_apps_meet_v2beta_SpaceConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.meet.v2beta.ResourceProto
          .internal_static_google_apps_meet_v2beta_SpaceConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.meet.v2beta.SpaceConfig.class,
              com.google.apps.meet.v2beta.SpaceConfig.Builder.class);
    }

    // Construct using com.google.apps.meet.v2beta.SpaceConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      accessType_ = 0;
      entryPointAccess_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.apps.meet.v2beta.ResourceProto
          .internal_static_google_apps_meet_v2beta_SpaceConfig_descriptor;
    }

    @java.lang.Override
    public com.google.apps.meet.v2beta.SpaceConfig getDefaultInstanceForType() {
      return com.google.apps.meet.v2beta.SpaceConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.apps.meet.v2beta.SpaceConfig build() {
      com.google.apps.meet.v2beta.SpaceConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.apps.meet.v2beta.SpaceConfig buildPartial() {
      com.google.apps.meet.v2beta.SpaceConfig result =
          new com.google.apps.meet.v2beta.SpaceConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.apps.meet.v2beta.SpaceConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.accessType_ = accessType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.entryPointAccess_ = entryPointAccess_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.apps.meet.v2beta.SpaceConfig) {
        return mergeFrom((com.google.apps.meet.v2beta.SpaceConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.apps.meet.v2beta.SpaceConfig other) {
      if (other == com.google.apps.meet.v2beta.SpaceConfig.getDefaultInstance()) return this;
      if (other.accessType_ != 0) {
        setAccessTypeValue(other.getAccessTypeValue());
      }
      if (other.entryPointAccess_ != 0) {
        setEntryPointAccessValue(other.getEntryPointAccessValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                accessType_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                entryPointAccess_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int accessType_ = 0;
    /**
     *
     *
     * <pre>
     * Access type of the meeting space that determines who can join without
     * knocking. Default: The user's default access settings.  Controlled by the
     * user's admin for enterprise users or RESTRICTED.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig.AccessType access_type = 1;</code>
     *
     * @return The enum numeric value on the wire for accessType.
     */
    @java.lang.Override
    public int getAccessTypeValue() {
      return accessType_;
    }
    /**
     *
     *
     * <pre>
     * Access type of the meeting space that determines who can join without
     * knocking. Default: The user's default access settings.  Controlled by the
     * user's admin for enterprise users or RESTRICTED.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig.AccessType access_type = 1;</code>
     *
     * @param value The enum numeric value on the wire for accessType to set.
     * @return This builder for chaining.
     */
    public Builder setAccessTypeValue(int value) {
      accessType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access type of the meeting space that determines who can join without
     * knocking. Default: The user's default access settings.  Controlled by the
     * user's admin for enterprise users or RESTRICTED.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig.AccessType access_type = 1;</code>
     *
     * @return The accessType.
     */
    @java.lang.Override
    public com.google.apps.meet.v2beta.SpaceConfig.AccessType getAccessType() {
      com.google.apps.meet.v2beta.SpaceConfig.AccessType result =
          com.google.apps.meet.v2beta.SpaceConfig.AccessType.forNumber(accessType_);
      return result == null
          ? com.google.apps.meet.v2beta.SpaceConfig.AccessType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Access type of the meeting space that determines who can join without
     * knocking. Default: The user's default access settings.  Controlled by the
     * user's admin for enterprise users or RESTRICTED.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig.AccessType access_type = 1;</code>
     *
     * @param value The accessType to set.
     * @return This builder for chaining.
     */
    public Builder setAccessType(com.google.apps.meet.v2beta.SpaceConfig.AccessType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      accessType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Access type of the meeting space that determines who can join without
     * knocking. Default: The user's default access settings.  Controlled by the
     * user's admin for enterprise users or RESTRICTED.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig.AccessType access_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAccessType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      accessType_ = 0;
      onChanged();
      return this;
    }

    private int entryPointAccess_ = 0;
    /**
     *
     *
     * <pre>
     * Defines the entry points that can be used to join meetings hosted in this
     * meeting space.
     * Default: EntryPointAccess.ALL
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig.EntryPointAccess entry_point_access = 2;</code>
     *
     * @return The enum numeric value on the wire for entryPointAccess.
     */
    @java.lang.Override
    public int getEntryPointAccessValue() {
      return entryPointAccess_;
    }
    /**
     *
     *
     * <pre>
     * Defines the entry points that can be used to join meetings hosted in this
     * meeting space.
     * Default: EntryPointAccess.ALL
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig.EntryPointAccess entry_point_access = 2;</code>
     *
     * @param value The enum numeric value on the wire for entryPointAccess to set.
     * @return This builder for chaining.
     */
    public Builder setEntryPointAccessValue(int value) {
      entryPointAccess_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the entry points that can be used to join meetings hosted in this
     * meeting space.
     * Default: EntryPointAccess.ALL
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig.EntryPointAccess entry_point_access = 2;</code>
     *
     * @return The entryPointAccess.
     */
    @java.lang.Override
    public com.google.apps.meet.v2beta.SpaceConfig.EntryPointAccess getEntryPointAccess() {
      com.google.apps.meet.v2beta.SpaceConfig.EntryPointAccess result =
          com.google.apps.meet.v2beta.SpaceConfig.EntryPointAccess.forNumber(entryPointAccess_);
      return result == null
          ? com.google.apps.meet.v2beta.SpaceConfig.EntryPointAccess.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Defines the entry points that can be used to join meetings hosted in this
     * meeting space.
     * Default: EntryPointAccess.ALL
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig.EntryPointAccess entry_point_access = 2;</code>
     *
     * @param value The entryPointAccess to set.
     * @return This builder for chaining.
     */
    public Builder setEntryPointAccess(
        com.google.apps.meet.v2beta.SpaceConfig.EntryPointAccess value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      entryPointAccess_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the entry points that can be used to join meetings hosted in this
     * meeting space.
     * Default: EntryPointAccess.ALL
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig.EntryPointAccess entry_point_access = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntryPointAccess() {
      bitField0_ = (bitField0_ & ~0x00000002);
      entryPointAccess_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.apps.meet.v2beta.SpaceConfig)
  }

  // @@protoc_insertion_point(class_scope:google.apps.meet.v2beta.SpaceConfig)
  private static final com.google.apps.meet.v2beta.SpaceConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.apps.meet.v2beta.SpaceConfig();
  }

  public static com.google.apps.meet.v2beta.SpaceConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SpaceConfig> PARSER =
      new com.google.protobuf.AbstractParser<SpaceConfig>() {
        @java.lang.Override
        public SpaceConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SpaceConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SpaceConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.apps.meet.v2beta.SpaceConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
