/*
 * Decompiled with CFR 0.152.
 */
package com.google.apps.meet.v2beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ParticipantName
implements ResourceName {
    private static final PathTemplate CONFERENCE_RECORD_PARTICIPANT = PathTemplate.createWithoutUrlEncoding((String)"conferenceRecords/{conference_record}/participants/{participant}");
    private volatile Map<String, String> fieldValuesMap;
    private final String conferenceRecord;
    private final String participant;

    @Deprecated
    protected ParticipantName() {
        this.conferenceRecord = null;
        this.participant = null;
    }

    private ParticipantName(Builder builder) {
        this.conferenceRecord = (String)Preconditions.checkNotNull((Object)builder.getConferenceRecord());
        this.participant = (String)Preconditions.checkNotNull((Object)builder.getParticipant());
    }

    public String getConferenceRecord() {
        return this.conferenceRecord;
    }

    public String getParticipant() {
        return this.participant;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ParticipantName of(String conferenceRecord, String participant) {
        return ParticipantName.newBuilder().setConferenceRecord(conferenceRecord).setParticipant(participant).build();
    }

    public static String format(String conferenceRecord, String participant) {
        return ParticipantName.newBuilder().setConferenceRecord(conferenceRecord).setParticipant(participant).build().toString();
    }

    public static ParticipantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CONFERENCE_RECORD_PARTICIPANT.validatedMatch(formattedString, "ParticipantName.parse: formattedString not in valid format");
        return ParticipantName.of((String)matchMap.get("conference_record"), (String)matchMap.get("participant"));
    }

    public static List<ParticipantName> parseList(List<String> formattedStrings) {
        ArrayList<ParticipantName> list = new ArrayList<ParticipantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ParticipantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ParticipantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ParticipantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CONFERENCE_RECORD_PARTICIPANT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ParticipantName participantName = this;
            synchronized (participantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.conferenceRecord != null) {
                        fieldMapBuilder.put((Object)"conference_record", (Object)this.conferenceRecord);
                    }
                    if (this.participant != null) {
                        fieldMapBuilder.put((Object)"participant", (Object)this.participant);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CONFERENCE_RECORD_PARTICIPANT.instantiate(new String[]{"conference_record", this.conferenceRecord, "participant", this.participant});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ParticipantName that = (ParticipantName)o;
            return Objects.equals(this.conferenceRecord, that.conferenceRecord) && Objects.equals(this.participant, that.participant);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.conferenceRecord);
        h *= 1000003;
        return h ^= Objects.hashCode(this.participant);
    }

    public static class Builder {
        private String conferenceRecord;
        private String participant;

        protected Builder() {
        }

        public String getConferenceRecord() {
            return this.conferenceRecord;
        }

        public String getParticipant() {
            return this.participant;
        }

        public Builder setConferenceRecord(String conferenceRecord) {
            this.conferenceRecord = conferenceRecord;
            return this;
        }

        public Builder setParticipant(String participant) {
            this.participant = participant;
            return this;
        }

        private Builder(ParticipantName participantName) {
            this.conferenceRecord = participantName.conferenceRecord;
            this.participant = participantName.participant;
        }

        public ParticipantName build() {
            return new ParticipantName(this);
        }
    }
}

