/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/apps/meet/v2beta/resource.proto

// Protobuf Java Version: 3.25.2
package com.google.apps.meet.v2beta;

/**
 *
 *
 * <pre>
 * [Developer Preview](https://developers.google.com/workspace/preview).
 * Virtual place where conferences are held. Only one active conference can be
 * held in one space at any given time.
 * </pre>
 *
 * Protobuf type {@code google.apps.meet.v2beta.Space}
 */
public final class Space extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.apps.meet.v2beta.Space)
    SpaceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Space.newBuilder() to construct.
  private Space(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Space() {
    name_ = "";
    meetingUri_ = "";
    meetingCode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Space();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.apps.meet.v2beta.ResourceProto
        .internal_static_google_apps_meet_v2beta_Space_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.apps.meet.v2beta.ResourceProto
        .internal_static_google_apps_meet_v2beta_Space_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.apps.meet.v2beta.Space.class,
            com.google.apps.meet.v2beta.Space.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Resource name of the space.
   * Format: `spaces/{space}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Resource name of the space.
   * Format: `spaces/{space}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MEETING_URI_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object meetingUri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. URI used to join meeting, such as
   * `https://meet.google.com/abc-mnop-xyz`.
   * </pre>
   *
   * <code>string meeting_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The meetingUri.
   */
  @java.lang.Override
  public java.lang.String getMeetingUri() {
    java.lang.Object ref = meetingUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      meetingUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. URI used to join meeting, such as
   * `https://meet.google.com/abc-mnop-xyz`.
   * </pre>
   *
   * <code>string meeting_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for meetingUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMeetingUriBytes() {
    java.lang.Object ref = meetingUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      meetingUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MEETING_CODE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object meetingCode_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Type friendly code to join the meeting. Format:
   * `[a-z]+-[a-z]+-[a-z]+` such as `abc-mnop-xyz`. The maximum length is 128
   * characters. Can ONLY be used as alias of the space ID to get the space.
   * </pre>
   *
   * <code>string meeting_code = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The meetingCode.
   */
  @java.lang.Override
  public java.lang.String getMeetingCode() {
    java.lang.Object ref = meetingCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      meetingCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Type friendly code to join the meeting. Format:
   * `[a-z]+-[a-z]+-[a-z]+` such as `abc-mnop-xyz`. The maximum length is 128
   * characters. Can ONLY be used as alias of the space ID to get the space.
   * </pre>
   *
   * <code>string meeting_code = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for meetingCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMeetingCodeBytes() {
    java.lang.Object ref = meetingCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      meetingCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIG_FIELD_NUMBER = 5;
  private com.google.apps.meet.v2beta.SpaceConfig config_;
  /**
   *
   *
   * <pre>
   * Configuration pertaining to the meeting space.
   * </pre>
   *
   * <code>.google.apps.meet.v2beta.SpaceConfig config = 5;</code>
   *
   * @return Whether the config field is set.
   */
  @java.lang.Override
  public boolean hasConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration pertaining to the meeting space.
   * </pre>
   *
   * <code>.google.apps.meet.v2beta.SpaceConfig config = 5;</code>
   *
   * @return The config.
   */
  @java.lang.Override
  public com.google.apps.meet.v2beta.SpaceConfig getConfig() {
    return config_ == null ? com.google.apps.meet.v2beta.SpaceConfig.getDefaultInstance() : config_;
  }
  /**
   *
   *
   * <pre>
   * Configuration pertaining to the meeting space.
   * </pre>
   *
   * <code>.google.apps.meet.v2beta.SpaceConfig config = 5;</code>
   */
  @java.lang.Override
  public com.google.apps.meet.v2beta.SpaceConfigOrBuilder getConfigOrBuilder() {
    return config_ == null ? com.google.apps.meet.v2beta.SpaceConfig.getDefaultInstance() : config_;
  }

  public static final int ACTIVE_CONFERENCE_FIELD_NUMBER = 6;
  private com.google.apps.meet.v2beta.ActiveConference activeConference_;
  /**
   *
   *
   * <pre>
   * Active conference if it exists.
   * </pre>
   *
   * <code>.google.apps.meet.v2beta.ActiveConference active_conference = 6;</code>
   *
   * @return Whether the activeConference field is set.
   */
  @java.lang.Override
  public boolean hasActiveConference() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Active conference if it exists.
   * </pre>
   *
   * <code>.google.apps.meet.v2beta.ActiveConference active_conference = 6;</code>
   *
   * @return The activeConference.
   */
  @java.lang.Override
  public com.google.apps.meet.v2beta.ActiveConference getActiveConference() {
    return activeConference_ == null
        ? com.google.apps.meet.v2beta.ActiveConference.getDefaultInstance()
        : activeConference_;
  }
  /**
   *
   *
   * <pre>
   * Active conference if it exists.
   * </pre>
   *
   * <code>.google.apps.meet.v2beta.ActiveConference active_conference = 6;</code>
   */
  @java.lang.Override
  public com.google.apps.meet.v2beta.ActiveConferenceOrBuilder getActiveConferenceOrBuilder() {
    return activeConference_ == null
        ? com.google.apps.meet.v2beta.ActiveConference.getDefaultInstance()
        : activeConference_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(meetingUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, meetingUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(meetingCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, meetingCode_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getActiveConference());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(meetingUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, meetingUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(meetingCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, meetingCode_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getActiveConference());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.apps.meet.v2beta.Space)) {
      return super.equals(obj);
    }
    com.google.apps.meet.v2beta.Space other = (com.google.apps.meet.v2beta.Space) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getMeetingUri().equals(other.getMeetingUri())) return false;
    if (!getMeetingCode().equals(other.getMeetingCode())) return false;
    if (hasConfig() != other.hasConfig()) return false;
    if (hasConfig()) {
      if (!getConfig().equals(other.getConfig())) return false;
    }
    if (hasActiveConference() != other.hasActiveConference()) return false;
    if (hasActiveConference()) {
      if (!getActiveConference().equals(other.getActiveConference())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + MEETING_URI_FIELD_NUMBER;
    hash = (53 * hash) + getMeetingUri().hashCode();
    hash = (37 * hash) + MEETING_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getMeetingCode().hashCode();
    if (hasConfig()) {
      hash = (37 * hash) + CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfig().hashCode();
    }
    if (hasActiveConference()) {
      hash = (37 * hash) + ACTIVE_CONFERENCE_FIELD_NUMBER;
      hash = (53 * hash) + getActiveConference().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.apps.meet.v2beta.Space parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.meet.v2beta.Space parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.meet.v2beta.Space parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.meet.v2beta.Space parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.meet.v2beta.Space parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.meet.v2beta.Space parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.meet.v2beta.Space parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.meet.v2beta.Space parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.meet.v2beta.Space parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.apps.meet.v2beta.Space parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.meet.v2beta.Space parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.meet.v2beta.Space parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.apps.meet.v2beta.Space prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * [Developer Preview](https://developers.google.com/workspace/preview).
   * Virtual place where conferences are held. Only one active conference can be
   * held in one space at any given time.
   * </pre>
   *
   * Protobuf type {@code google.apps.meet.v2beta.Space}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.apps.meet.v2beta.Space)
      com.google.apps.meet.v2beta.SpaceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.meet.v2beta.ResourceProto
          .internal_static_google_apps_meet_v2beta_Space_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.meet.v2beta.ResourceProto
          .internal_static_google_apps_meet_v2beta_Space_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.meet.v2beta.Space.class,
              com.google.apps.meet.v2beta.Space.Builder.class);
    }

    // Construct using com.google.apps.meet.v2beta.Space.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getConfigFieldBuilder();
        getActiveConferenceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      meetingUri_ = "";
      meetingCode_ = "";
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      activeConference_ = null;
      if (activeConferenceBuilder_ != null) {
        activeConferenceBuilder_.dispose();
        activeConferenceBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.apps.meet.v2beta.ResourceProto
          .internal_static_google_apps_meet_v2beta_Space_descriptor;
    }

    @java.lang.Override
    public com.google.apps.meet.v2beta.Space getDefaultInstanceForType() {
      return com.google.apps.meet.v2beta.Space.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.apps.meet.v2beta.Space build() {
      com.google.apps.meet.v2beta.Space result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.apps.meet.v2beta.Space buildPartial() {
      com.google.apps.meet.v2beta.Space result = new com.google.apps.meet.v2beta.Space(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.apps.meet.v2beta.Space result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.meetingUri_ = meetingUri_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.meetingCode_ = meetingCode_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.config_ = configBuilder_ == null ? config_ : configBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.activeConference_ =
            activeConferenceBuilder_ == null ? activeConference_ : activeConferenceBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.apps.meet.v2beta.Space) {
        return mergeFrom((com.google.apps.meet.v2beta.Space) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.apps.meet.v2beta.Space other) {
      if (other == com.google.apps.meet.v2beta.Space.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getMeetingUri().isEmpty()) {
        meetingUri_ = other.meetingUri_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getMeetingCode().isEmpty()) {
        meetingCode_ = other.meetingCode_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasConfig()) {
        mergeConfig(other.getConfig());
      }
      if (other.hasActiveConference()) {
        mergeActiveConference(other.getActiveConference());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                meetingUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                meetingCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(getConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getActiveConferenceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Resource name of the space.
     * Format: `spaces/{space}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Resource name of the space.
     * Format: `spaces/{space}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Resource name of the space.
     * Format: `spaces/{space}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Resource name of the space.
     * Format: `spaces/{space}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Resource name of the space.
     * Format: `spaces/{space}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object meetingUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. URI used to join meeting, such as
     * `https://meet.google.com/abc-mnop-xyz`.
     * </pre>
     *
     * <code>string meeting_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The meetingUri.
     */
    public java.lang.String getMeetingUri() {
      java.lang.Object ref = meetingUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        meetingUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. URI used to join meeting, such as
     * `https://meet.google.com/abc-mnop-xyz`.
     * </pre>
     *
     * <code>string meeting_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for meetingUri.
     */
    public com.google.protobuf.ByteString getMeetingUriBytes() {
      java.lang.Object ref = meetingUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        meetingUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. URI used to join meeting, such as
     * `https://meet.google.com/abc-mnop-xyz`.
     * </pre>
     *
     * <code>string meeting_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The meetingUri to set.
     * @return This builder for chaining.
     */
    public Builder setMeetingUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      meetingUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URI used to join meeting, such as
     * `https://meet.google.com/abc-mnop-xyz`.
     * </pre>
     *
     * <code>string meeting_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMeetingUri() {
      meetingUri_ = getDefaultInstance().getMeetingUri();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URI used to join meeting, such as
     * `https://meet.google.com/abc-mnop-xyz`.
     * </pre>
     *
     * <code>string meeting_uri = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for meetingUri to set.
     * @return This builder for chaining.
     */
    public Builder setMeetingUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      meetingUri_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object meetingCode_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Type friendly code to join the meeting. Format:
     * `[a-z]+-[a-z]+-[a-z]+` such as `abc-mnop-xyz`. The maximum length is 128
     * characters. Can ONLY be used as alias of the space ID to get the space.
     * </pre>
     *
     * <code>string meeting_code = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The meetingCode.
     */
    public java.lang.String getMeetingCode() {
      java.lang.Object ref = meetingCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        meetingCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Type friendly code to join the meeting. Format:
     * `[a-z]+-[a-z]+-[a-z]+` such as `abc-mnop-xyz`. The maximum length is 128
     * characters. Can ONLY be used as alias of the space ID to get the space.
     * </pre>
     *
     * <code>string meeting_code = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for meetingCode.
     */
    public com.google.protobuf.ByteString getMeetingCodeBytes() {
      java.lang.Object ref = meetingCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        meetingCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Type friendly code to join the meeting. Format:
     * `[a-z]+-[a-z]+-[a-z]+` such as `abc-mnop-xyz`. The maximum length is 128
     * characters. Can ONLY be used as alias of the space ID to get the space.
     * </pre>
     *
     * <code>string meeting_code = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The meetingCode to set.
     * @return This builder for chaining.
     */
    public Builder setMeetingCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      meetingCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type friendly code to join the meeting. Format:
     * `[a-z]+-[a-z]+-[a-z]+` such as `abc-mnop-xyz`. The maximum length is 128
     * characters. Can ONLY be used as alias of the space ID to get the space.
     * </pre>
     *
     * <code>string meeting_code = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMeetingCode() {
      meetingCode_ = getDefaultInstance().getMeetingCode();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type friendly code to join the meeting. Format:
     * `[a-z]+-[a-z]+-[a-z]+` such as `abc-mnop-xyz`. The maximum length is 128
     * characters. Can ONLY be used as alias of the space ID to get the space.
     * </pre>
     *
     * <code>string meeting_code = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for meetingCode to set.
     * @return This builder for chaining.
     */
    public Builder setMeetingCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      meetingCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.apps.meet.v2beta.SpaceConfig config_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.meet.v2beta.SpaceConfig,
            com.google.apps.meet.v2beta.SpaceConfig.Builder,
            com.google.apps.meet.v2beta.SpaceConfigOrBuilder>
        configBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration pertaining to the meeting space.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig config = 5;</code>
     *
     * @return Whether the config field is set.
     */
    public boolean hasConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration pertaining to the meeting space.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig config = 5;</code>
     *
     * @return The config.
     */
    public com.google.apps.meet.v2beta.SpaceConfig getConfig() {
      if (configBuilder_ == null) {
        return config_ == null
            ? com.google.apps.meet.v2beta.SpaceConfig.getDefaultInstance()
            : config_;
      } else {
        return configBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration pertaining to the meeting space.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig config = 5;</code>
     */
    public Builder setConfig(com.google.apps.meet.v2beta.SpaceConfig value) {
      if (configBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
      } else {
        configBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration pertaining to the meeting space.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig config = 5;</code>
     */
    public Builder setConfig(com.google.apps.meet.v2beta.SpaceConfig.Builder builderForValue) {
      if (configBuilder_ == null) {
        config_ = builderForValue.build();
      } else {
        configBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration pertaining to the meeting space.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig config = 5;</code>
     */
    public Builder mergeConfig(com.google.apps.meet.v2beta.SpaceConfig value) {
      if (configBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && config_ != null
            && config_ != com.google.apps.meet.v2beta.SpaceConfig.getDefaultInstance()) {
          getConfigBuilder().mergeFrom(value);
        } else {
          config_ = value;
        }
      } else {
        configBuilder_.mergeFrom(value);
      }
      if (config_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration pertaining to the meeting space.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig config = 5;</code>
     */
    public Builder clearConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration pertaining to the meeting space.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig config = 5;</code>
     */
    public com.google.apps.meet.v2beta.SpaceConfig.Builder getConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration pertaining to the meeting space.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig config = 5;</code>
     */
    public com.google.apps.meet.v2beta.SpaceConfigOrBuilder getConfigOrBuilder() {
      if (configBuilder_ != null) {
        return configBuilder_.getMessageOrBuilder();
      } else {
        return config_ == null
            ? com.google.apps.meet.v2beta.SpaceConfig.getDefaultInstance()
            : config_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration pertaining to the meeting space.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.SpaceConfig config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.meet.v2beta.SpaceConfig,
            com.google.apps.meet.v2beta.SpaceConfig.Builder,
            com.google.apps.meet.v2beta.SpaceConfigOrBuilder>
        getConfigFieldBuilder() {
      if (configBuilder_ == null) {
        configBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.meet.v2beta.SpaceConfig,
                com.google.apps.meet.v2beta.SpaceConfig.Builder,
                com.google.apps.meet.v2beta.SpaceConfigOrBuilder>(
                getConfig(), getParentForChildren(), isClean());
        config_ = null;
      }
      return configBuilder_;
    }

    private com.google.apps.meet.v2beta.ActiveConference activeConference_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.meet.v2beta.ActiveConference,
            com.google.apps.meet.v2beta.ActiveConference.Builder,
            com.google.apps.meet.v2beta.ActiveConferenceOrBuilder>
        activeConferenceBuilder_;
    /**
     *
     *
     * <pre>
     * Active conference if it exists.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.ActiveConference active_conference = 6;</code>
     *
     * @return Whether the activeConference field is set.
     */
    public boolean hasActiveConference() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Active conference if it exists.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.ActiveConference active_conference = 6;</code>
     *
     * @return The activeConference.
     */
    public com.google.apps.meet.v2beta.ActiveConference getActiveConference() {
      if (activeConferenceBuilder_ == null) {
        return activeConference_ == null
            ? com.google.apps.meet.v2beta.ActiveConference.getDefaultInstance()
            : activeConference_;
      } else {
        return activeConferenceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Active conference if it exists.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.ActiveConference active_conference = 6;</code>
     */
    public Builder setActiveConference(com.google.apps.meet.v2beta.ActiveConference value) {
      if (activeConferenceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        activeConference_ = value;
      } else {
        activeConferenceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Active conference if it exists.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.ActiveConference active_conference = 6;</code>
     */
    public Builder setActiveConference(
        com.google.apps.meet.v2beta.ActiveConference.Builder builderForValue) {
      if (activeConferenceBuilder_ == null) {
        activeConference_ = builderForValue.build();
      } else {
        activeConferenceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Active conference if it exists.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.ActiveConference active_conference = 6;</code>
     */
    public Builder mergeActiveConference(com.google.apps.meet.v2beta.ActiveConference value) {
      if (activeConferenceBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && activeConference_ != null
            && activeConference_
                != com.google.apps.meet.v2beta.ActiveConference.getDefaultInstance()) {
          getActiveConferenceBuilder().mergeFrom(value);
        } else {
          activeConference_ = value;
        }
      } else {
        activeConferenceBuilder_.mergeFrom(value);
      }
      if (activeConference_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Active conference if it exists.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.ActiveConference active_conference = 6;</code>
     */
    public Builder clearActiveConference() {
      bitField0_ = (bitField0_ & ~0x00000010);
      activeConference_ = null;
      if (activeConferenceBuilder_ != null) {
        activeConferenceBuilder_.dispose();
        activeConferenceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Active conference if it exists.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.ActiveConference active_conference = 6;</code>
     */
    public com.google.apps.meet.v2beta.ActiveConference.Builder getActiveConferenceBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getActiveConferenceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Active conference if it exists.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.ActiveConference active_conference = 6;</code>
     */
    public com.google.apps.meet.v2beta.ActiveConferenceOrBuilder getActiveConferenceOrBuilder() {
      if (activeConferenceBuilder_ != null) {
        return activeConferenceBuilder_.getMessageOrBuilder();
      } else {
        return activeConference_ == null
            ? com.google.apps.meet.v2beta.ActiveConference.getDefaultInstance()
            : activeConference_;
      }
    }
    /**
     *
     *
     * <pre>
     * Active conference if it exists.
     * </pre>
     *
     * <code>.google.apps.meet.v2beta.ActiveConference active_conference = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.meet.v2beta.ActiveConference,
            com.google.apps.meet.v2beta.ActiveConference.Builder,
            com.google.apps.meet.v2beta.ActiveConferenceOrBuilder>
        getActiveConferenceFieldBuilder() {
      if (activeConferenceBuilder_ == null) {
        activeConferenceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.meet.v2beta.ActiveConference,
                com.google.apps.meet.v2beta.ActiveConference.Builder,
                com.google.apps.meet.v2beta.ActiveConferenceOrBuilder>(
                getActiveConference(), getParentForChildren(), isClean());
        activeConference_ = null;
      }
      return activeConferenceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.apps.meet.v2beta.Space)
  }

  // @@protoc_insertion_point(class_scope:google.apps.meet.v2beta.Space)
  private static final com.google.apps.meet.v2beta.Space DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.apps.meet.v2beta.Space();
  }

  public static com.google.apps.meet.v2beta.Space getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Space> PARSER =
      new com.google.protobuf.AbstractParser<Space>() {
        @java.lang.Override
        public Space parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Space> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Space> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.apps.meet.v2beta.Space getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
