/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/memcache/v1beta2/cloud_memcache.proto

package com.google.cloud.memcache.v1beta2;

public interface ApplySoftwareUpdateRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.memcache.v1beta2.ApplySoftwareUpdateRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. Resource name of the Memcached instance for which software update should be
   * applied.
   * </pre>
   *
   * <code>
   * string instance = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The instance.
   */
  java.lang.String getInstance();
  /**
   *
   *
   * <pre>
   * Required. Resource name of the Memcached instance for which software update should be
   * applied.
   * </pre>
   *
   * <code>
   * string instance = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for instance.
   */
  com.google.protobuf.ByteString getInstanceBytes();

  /**
   *
   *
   * <pre>
   * Nodes to which we should apply the update to. Note all the selected nodes
   * are updated in parallel.
   * </pre>
   *
   * <code>repeated string node_ids = 2;</code>
   *
   * @return A list containing the nodeIds.
   */
  java.util.List<java.lang.String> getNodeIdsList();
  /**
   *
   *
   * <pre>
   * Nodes to which we should apply the update to. Note all the selected nodes
   * are updated in parallel.
   * </pre>
   *
   * <code>repeated string node_ids = 2;</code>
   *
   * @return The count of nodeIds.
   */
  int getNodeIdsCount();
  /**
   *
   *
   * <pre>
   * Nodes to which we should apply the update to. Note all the selected nodes
   * are updated in parallel.
   * </pre>
   *
   * <code>repeated string node_ids = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The nodeIds at the given index.
   */
  java.lang.String getNodeIds(int index);
  /**
   *
   *
   * <pre>
   * Nodes to which we should apply the update to. Note all the selected nodes
   * are updated in parallel.
   * </pre>
   *
   * <code>repeated string node_ids = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the nodeIds at the given index.
   */
  com.google.protobuf.ByteString getNodeIdsBytes(int index);

  /**
   *
   *
   * <pre>
   * Whether to apply the update to all nodes. If set to
   * true, will explicitly restrict users from specifying any nodes, and apply
   * software update to all nodes (where applicable) within the instance.
   * </pre>
   *
   * <code>bool apply_all = 3;</code>
   *
   * @return The applyAll.
   */
  boolean getApplyAll();
}
