/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/memcache/v1beta2/cloud_memcache.proto

package com.google.cloud.memcache.v1beta2;

/**
 *
 *
 * <pre>
 * A Memorystore for Memcached instance
 * </pre>
 *
 * Protobuf type {@code google.cloud.memcache.v1beta2.Instance}
 */
public final class Instance extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.memcache.v1beta2.Instance)
    InstanceOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Instance.newBuilder() to construct.
  private Instance(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Instance() {
    name_ = "";
    displayName_ = "";
    authorizedNetwork_ = "";
    zones_ = com.google.protobuf.LazyStringArrayList.emptyList();
    memcacheVersion_ = 0;
    memcacheNodes_ = java.util.Collections.emptyList();
    state_ = 0;
    memcacheFullVersion_ = "";
    instanceMessages_ = java.util.Collections.emptyList();
    discoveryEndpoint_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Instance();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
        .internal_static_google_cloud_memcache_v1beta2_Instance_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
        .internal_static_google_cloud_memcache_v1beta2_Instance_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.memcache.v1beta2.Instance.class,
            com.google.cloud.memcache.v1beta2.Instance.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Different states of a Memcached instance.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.memcache.v1beta2.Instance.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * State not set.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Memcached instance is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * Memcached instance has been created and ready to be used.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    READY(2),
    /**
     *
     *
     * <pre>
     * Memcached instance is updating configuration such as maintenance policy
     * and schedule.
     * </pre>
     *
     * <code>UPDATING = 3;</code>
     */
    UPDATING(3),
    /**
     *
     *
     * <pre>
     * Memcached instance is being deleted.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    DELETING(4),
    /**
     *
     *
     * <pre>
     * Memcached instance is going through maintenance, e.g. data plane rollout.
     * </pre>
     *
     * <code>PERFORMING_MAINTENANCE = 5;</code>
     */
    PERFORMING_MAINTENANCE(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * State not set.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Memcached instance is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Memcached instance has been created and ready to be used.
     * </pre>
     *
     * <code>READY = 2;</code>
     */
    public static final int READY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Memcached instance is updating configuration such as maintenance policy
     * and schedule.
     * </pre>
     *
     * <code>UPDATING = 3;</code>
     */
    public static final int UPDATING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Memcached instance is being deleted.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    public static final int DELETING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Memcached instance is going through maintenance, e.g. data plane rollout.
     * </pre>
     *
     * <code>PERFORMING_MAINTENANCE = 5;</code>
     */
    public static final int PERFORMING_MAINTENANCE_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return READY;
        case 3:
          return UPDATING;
        case 4:
          return DELETING;
        case 5:
          return PERFORMING_MAINTENANCE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.memcache.v1beta2.Instance.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.memcache.v1beta2.Instance.State)
  }

  public interface NodeConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.memcache.v1beta2.Instance.NodeConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Number of cpus per Memcached node.
     * </pre>
     *
     * <code>int32 cpu_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The cpuCount.
     */
    int getCpuCount();

    /**
     *
     *
     * <pre>
     * Required. Memory size in MiB for each Memcached node.
     * </pre>
     *
     * <code>int32 memory_size_mb = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The memorySizeMb.
     */
    int getMemorySizeMb();
  }
  /**
   *
   *
   * <pre>
   * Configuration for a Memcached Node.
   * </pre>
   *
   * Protobuf type {@code google.cloud.memcache.v1beta2.Instance.NodeConfig}
   */
  public static final class NodeConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.memcache.v1beta2.Instance.NodeConfig)
      NodeConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use NodeConfig.newBuilder() to construct.
    private NodeConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NodeConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new NodeConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
          .internal_static_google_cloud_memcache_v1beta2_Instance_NodeConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
          .internal_static_google_cloud_memcache_v1beta2_Instance_NodeConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.memcache.v1beta2.Instance.NodeConfig.class,
              com.google.cloud.memcache.v1beta2.Instance.NodeConfig.Builder.class);
    }

    public static final int CPU_COUNT_FIELD_NUMBER = 1;
    private int cpuCount_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Number of cpus per Memcached node.
     * </pre>
     *
     * <code>int32 cpu_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The cpuCount.
     */
    @java.lang.Override
    public int getCpuCount() {
      return cpuCount_;
    }

    public static final int MEMORY_SIZE_MB_FIELD_NUMBER = 2;
    private int memorySizeMb_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Memory size in MiB for each Memcached node.
     * </pre>
     *
     * <code>int32 memory_size_mb = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The memorySizeMb.
     */
    @java.lang.Override
    public int getMemorySizeMb() {
      return memorySizeMb_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (cpuCount_ != 0) {
        output.writeInt32(1, cpuCount_);
      }
      if (memorySizeMb_ != 0) {
        output.writeInt32(2, memorySizeMb_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (cpuCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, cpuCount_);
      }
      if (memorySizeMb_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, memorySizeMb_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.memcache.v1beta2.Instance.NodeConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.memcache.v1beta2.Instance.NodeConfig other =
          (com.google.cloud.memcache.v1beta2.Instance.NodeConfig) obj;

      if (getCpuCount() != other.getCpuCount()) return false;
      if (getMemorySizeMb() != other.getMemorySizeMb()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CPU_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getCpuCount();
      hash = (37 * hash) + MEMORY_SIZE_MB_FIELD_NUMBER;
      hash = (53 * hash) + getMemorySizeMb();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.memcache.v1beta2.Instance.NodeConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.NodeConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.NodeConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.NodeConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.NodeConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.NodeConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.NodeConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.NodeConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.NodeConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.NodeConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.NodeConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.NodeConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.memcache.v1beta2.Instance.NodeConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a Memcached Node.
     * </pre>
     *
     * Protobuf type {@code google.cloud.memcache.v1beta2.Instance.NodeConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.memcache.v1beta2.Instance.NodeConfig)
        com.google.cloud.memcache.v1beta2.Instance.NodeConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
            .internal_static_google_cloud_memcache_v1beta2_Instance_NodeConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
            .internal_static_google_cloud_memcache_v1beta2_Instance_NodeConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.memcache.v1beta2.Instance.NodeConfig.class,
                com.google.cloud.memcache.v1beta2.Instance.NodeConfig.Builder.class);
      }

      // Construct using com.google.cloud.memcache.v1beta2.Instance.NodeConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        cpuCount_ = 0;
        memorySizeMb_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
            .internal_static_google_cloud_memcache_v1beta2_Instance_NodeConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.memcache.v1beta2.Instance.NodeConfig getDefaultInstanceForType() {
        return com.google.cloud.memcache.v1beta2.Instance.NodeConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.memcache.v1beta2.Instance.NodeConfig build() {
        com.google.cloud.memcache.v1beta2.Instance.NodeConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.memcache.v1beta2.Instance.NodeConfig buildPartial() {
        com.google.cloud.memcache.v1beta2.Instance.NodeConfig result =
            new com.google.cloud.memcache.v1beta2.Instance.NodeConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.memcache.v1beta2.Instance.NodeConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.cpuCount_ = cpuCount_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.memorySizeMb_ = memorySizeMb_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.memcache.v1beta2.Instance.NodeConfig) {
          return mergeFrom((com.google.cloud.memcache.v1beta2.Instance.NodeConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.memcache.v1beta2.Instance.NodeConfig other) {
        if (other == com.google.cloud.memcache.v1beta2.Instance.NodeConfig.getDefaultInstance())
          return this;
        if (other.getCpuCount() != 0) {
          setCpuCount(other.getCpuCount());
        }
        if (other.getMemorySizeMb() != 0) {
          setMemorySizeMb(other.getMemorySizeMb());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  cpuCount_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  memorySizeMb_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int cpuCount_;
      /**
       *
       *
       * <pre>
       * Required. Number of cpus per Memcached node.
       * </pre>
       *
       * <code>int32 cpu_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The cpuCount.
       */
      @java.lang.Override
      public int getCpuCount() {
        return cpuCount_;
      }
      /**
       *
       *
       * <pre>
       * Required. Number of cpus per Memcached node.
       * </pre>
       *
       * <code>int32 cpu_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The cpuCount to set.
       * @return This builder for chaining.
       */
      public Builder setCpuCount(int value) {

        cpuCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Number of cpus per Memcached node.
       * </pre>
       *
       * <code>int32 cpu_count = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCpuCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        cpuCount_ = 0;
        onChanged();
        return this;
      }

      private int memorySizeMb_;
      /**
       *
       *
       * <pre>
       * Required. Memory size in MiB for each Memcached node.
       * </pre>
       *
       * <code>int32 memory_size_mb = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The memorySizeMb.
       */
      @java.lang.Override
      public int getMemorySizeMb() {
        return memorySizeMb_;
      }
      /**
       *
       *
       * <pre>
       * Required. Memory size in MiB for each Memcached node.
       * </pre>
       *
       * <code>int32 memory_size_mb = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The memorySizeMb to set.
       * @return This builder for chaining.
       */
      public Builder setMemorySizeMb(int value) {

        memorySizeMb_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Memory size in MiB for each Memcached node.
       * </pre>
       *
       * <code>int32 memory_size_mb = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMemorySizeMb() {
        bitField0_ = (bitField0_ & ~0x00000002);
        memorySizeMb_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.memcache.v1beta2.Instance.NodeConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.memcache.v1beta2.Instance.NodeConfig)
    private static final com.google.cloud.memcache.v1beta2.Instance.NodeConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.memcache.v1beta2.Instance.NodeConfig();
    }

    public static com.google.cloud.memcache.v1beta2.Instance.NodeConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NodeConfig> PARSER =
        new com.google.protobuf.AbstractParser<NodeConfig>() {
          @java.lang.Override
          public NodeConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<NodeConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NodeConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.memcache.v1beta2.Instance.NodeConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NodeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.memcache.v1beta2.Instance.Node)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Identifier of the Memcached node. The node id does not
     * include project or location like the Memcached instance name.
     * </pre>
     *
     * <code>string node_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The nodeId.
     */
    java.lang.String getNodeId();
    /**
     *
     *
     * <pre>
     * Output only. Identifier of the Memcached node. The node id does not
     * include project or location like the Memcached instance name.
     * </pre>
     *
     * <code>string node_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for nodeId.
     */
    com.google.protobuf.ByteString getNodeIdBytes();

    /**
     *
     *
     * <pre>
     * Output only. Location (GCP Zone) for the Memcached node.
     * </pre>
     *
     * <code>string zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The zone.
     */
    java.lang.String getZone();
    /**
     *
     *
     * <pre>
     * Output only. Location (GCP Zone) for the Memcached node.
     * </pre>
     *
     * <code>string zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for zone.
     */
    com.google.protobuf.ByteString getZoneBytes();

    /**
     *
     *
     * <pre>
     * Output only. Current state of the Memcached node.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.Instance.Node.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * Output only. Current state of the Memcached node.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.Instance.Node.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    com.google.cloud.memcache.v1beta2.Instance.Node.State getState();

    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the Memcached node used by the
     * clients to connect to the Memcached server on this node.
     * </pre>
     *
     * <code>string host = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The host.
     */
    java.lang.String getHost();
    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the Memcached node used by the
     * clients to connect to the Memcached server on this node.
     * </pre>
     *
     * <code>string host = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for host.
     */
    com.google.protobuf.ByteString getHostBytes();

    /**
     *
     *
     * <pre>
     * Output only. The port number of the Memcached server on this node.
     * </pre>
     *
     * <code>int32 port = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The port.
     */
    int getPort();

    /**
     *
     *
     * <pre>
     * User defined parameters currently applied to the node.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 6;</code>
     *
     * @return Whether the parameters field is set.
     */
    boolean hasParameters();
    /**
     *
     *
     * <pre>
     * User defined parameters currently applied to the node.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 6;</code>
     *
     * @return The parameters.
     */
    com.google.cloud.memcache.v1beta2.MemcacheParameters getParameters();
    /**
     *
     *
     * <pre>
     * User defined parameters currently applied to the node.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 6;</code>
     */
    com.google.cloud.memcache.v1beta2.MemcacheParametersOrBuilder getParametersOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. Returns true if there is an update waiting to be applied
     * </pre>
     *
     * <code>bool update_available = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The updateAvailable.
     */
    boolean getUpdateAvailable();
  }
  /** Protobuf type {@code google.cloud.memcache.v1beta2.Instance.Node} */
  public static final class Node extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.memcache.v1beta2.Instance.Node)
      NodeOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Node.newBuilder() to construct.
    private Node(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Node() {
      nodeId_ = "";
      zone_ = "";
      state_ = 0;
      host_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Node();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
          .internal_static_google_cloud_memcache_v1beta2_Instance_Node_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
          .internal_static_google_cloud_memcache_v1beta2_Instance_Node_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.memcache.v1beta2.Instance.Node.class,
              com.google.cloud.memcache.v1beta2.Instance.Node.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Different states of a Memcached node.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.memcache.v1beta2.Instance.Node.State}
     */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Node state is not set.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Node is being created.
       * </pre>
       *
       * <code>CREATING = 1;</code>
       */
      CREATING(1),
      /**
       *
       *
       * <pre>
       * Node has been created and ready to be used.
       * </pre>
       *
       * <code>READY = 2;</code>
       */
      READY(2),
      /**
       *
       *
       * <pre>
       * Node is being deleted.
       * </pre>
       *
       * <code>DELETING = 3;</code>
       */
      DELETING(3),
      /**
       *
       *
       * <pre>
       * Node is being updated.
       * </pre>
       *
       * <code>UPDATING = 4;</code>
       */
      UPDATING(4),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Node state is not set.
       * </pre>
       *
       * <code>STATE_UNSPECIFIED = 0;</code>
       */
      public static final int STATE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Node is being created.
       * </pre>
       *
       * <code>CREATING = 1;</code>
       */
      public static final int CREATING_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Node has been created and ready to be used.
       * </pre>
       *
       * <code>READY = 2;</code>
       */
      public static final int READY_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Node is being deleted.
       * </pre>
       *
       * <code>DELETING = 3;</code>
       */
      public static final int DELETING_VALUE = 3;
      /**
       *
       *
       * <pre>
       * Node is being updated.
       * </pre>
       *
       * <code>UPDATING = 4;</code>
       */
      public static final int UPDATING_VALUE = 4;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return CREATING;
          case 2:
            return READY;
          case 3:
            return DELETING;
          case 4:
            return UPDATING;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.memcache.v1beta2.Instance.Node.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.memcache.v1beta2.Instance.Node.State)
    }

    public static final int NODE_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object nodeId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Identifier of the Memcached node. The node id does not
     * include project or location like the Memcached instance name.
     * </pre>
     *
     * <code>string node_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The nodeId.
     */
    @java.lang.Override
    public java.lang.String getNodeId() {
      java.lang.Object ref = nodeId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nodeId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Identifier of the Memcached node. The node id does not
     * include project or location like the Memcached instance name.
     * </pre>
     *
     * <code>string node_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for nodeId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNodeIdBytes() {
      java.lang.Object ref = nodeId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nodeId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ZONE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object zone_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Location (GCP Zone) for the Memcached node.
     * </pre>
     *
     * <code>string zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The zone.
     */
    @java.lang.Override
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Location (GCP Zone) for the Memcached node.
     * </pre>
     *
     * <code>string zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for zone.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATE_FIELD_NUMBER = 3;
    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Current state of the Memcached node.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.Instance.Node.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the Memcached node.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.Instance.Node.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.memcache.v1beta2.Instance.Node.State getState() {
      com.google.cloud.memcache.v1beta2.Instance.Node.State result =
          com.google.cloud.memcache.v1beta2.Instance.Node.State.forNumber(state_);
      return result == null
          ? com.google.cloud.memcache.v1beta2.Instance.Node.State.UNRECOGNIZED
          : result;
    }

    public static final int HOST_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object host_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the Memcached node used by the
     * clients to connect to the Memcached server on this node.
     * </pre>
     *
     * <code>string host = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The host.
     */
    @java.lang.Override
    public java.lang.String getHost() {
      java.lang.Object ref = host_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        host_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Hostname or IP address of the Memcached node used by the
     * clients to connect to the Memcached server on this node.
     * </pre>
     *
     * <code>string host = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for host.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getHostBytes() {
      java.lang.Object ref = host_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        host_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PORT_FIELD_NUMBER = 5;
    private int port_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The port number of the Memcached server on this node.
     * </pre>
     *
     * <code>int32 port = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }

    public static final int PARAMETERS_FIELD_NUMBER = 6;
    private com.google.cloud.memcache.v1beta2.MemcacheParameters parameters_;
    /**
     *
     *
     * <pre>
     * User defined parameters currently applied to the node.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 6;</code>
     *
     * @return Whether the parameters field is set.
     */
    @java.lang.Override
    public boolean hasParameters() {
      return parameters_ != null;
    }
    /**
     *
     *
     * <pre>
     * User defined parameters currently applied to the node.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 6;</code>
     *
     * @return The parameters.
     */
    @java.lang.Override
    public com.google.cloud.memcache.v1beta2.MemcacheParameters getParameters() {
      return parameters_ == null
          ? com.google.cloud.memcache.v1beta2.MemcacheParameters.getDefaultInstance()
          : parameters_;
    }
    /**
     *
     *
     * <pre>
     * User defined parameters currently applied to the node.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.memcache.v1beta2.MemcacheParametersOrBuilder getParametersOrBuilder() {
      return parameters_ == null
          ? com.google.cloud.memcache.v1beta2.MemcacheParameters.getDefaultInstance()
          : parameters_;
    }

    public static final int UPDATE_AVAILABLE_FIELD_NUMBER = 7;
    private boolean updateAvailable_ = false;
    /**
     *
     *
     * <pre>
     * Output only. Returns true if there is an update waiting to be applied
     * </pre>
     *
     * <code>bool update_available = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The updateAvailable.
     */
    @java.lang.Override
    public boolean getUpdateAvailable() {
      return updateAvailable_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodeId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, nodeId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, zone_);
      }
      if (state_
          != com.google.cloud.memcache.v1beta2.Instance.Node.State.STATE_UNSPECIFIED.getNumber()) {
        output.writeEnum(3, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(host_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, host_);
      }
      if (port_ != 0) {
        output.writeInt32(5, port_);
      }
      if (parameters_ != null) {
        output.writeMessage(6, getParameters());
      }
      if (updateAvailable_ != false) {
        output.writeBool(7, updateAvailable_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nodeId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, nodeId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, zone_);
      }
      if (state_
          != com.google.cloud.memcache.v1beta2.Instance.Node.State.STATE_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(host_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, host_);
      }
      if (port_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, port_);
      }
      if (parameters_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getParameters());
      }
      if (updateAvailable_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, updateAvailable_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.memcache.v1beta2.Instance.Node)) {
        return super.equals(obj);
      }
      com.google.cloud.memcache.v1beta2.Instance.Node other =
          (com.google.cloud.memcache.v1beta2.Instance.Node) obj;

      if (!getNodeId().equals(other.getNodeId())) return false;
      if (!getZone().equals(other.getZone())) return false;
      if (state_ != other.state_) return false;
      if (!getHost().equals(other.getHost())) return false;
      if (getPort() != other.getPort()) return false;
      if (hasParameters() != other.hasParameters()) return false;
      if (hasParameters()) {
        if (!getParameters().equals(other.getParameters())) return false;
      }
      if (getUpdateAvailable() != other.getUpdateAvailable()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NODE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getNodeId().hashCode();
      hash = (37 * hash) + ZONE_FIELD_NUMBER;
      hash = (53 * hash) + getZone().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (37 * hash) + HOST_FIELD_NUMBER;
      hash = (53 * hash) + getHost().hashCode();
      hash = (37 * hash) + PORT_FIELD_NUMBER;
      hash = (53 * hash) + getPort();
      if (hasParameters()) {
        hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
        hash = (53 * hash) + getParameters().hashCode();
      }
      hash = (37 * hash) + UPDATE_AVAILABLE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUpdateAvailable());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.memcache.v1beta2.Instance.Node parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.Node parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.Node parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.Node parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.Node parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.Node parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.Node parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.Node parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.Node parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.Node parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.Node parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.Node parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.memcache.v1beta2.Instance.Node prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /** Protobuf type {@code google.cloud.memcache.v1beta2.Instance.Node} */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.memcache.v1beta2.Instance.Node)
        com.google.cloud.memcache.v1beta2.Instance.NodeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
            .internal_static_google_cloud_memcache_v1beta2_Instance_Node_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
            .internal_static_google_cloud_memcache_v1beta2_Instance_Node_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.memcache.v1beta2.Instance.Node.class,
                com.google.cloud.memcache.v1beta2.Instance.Node.Builder.class);
      }

      // Construct using com.google.cloud.memcache.v1beta2.Instance.Node.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        nodeId_ = "";
        zone_ = "";
        state_ = 0;
        host_ = "";
        port_ = 0;
        parameters_ = null;
        if (parametersBuilder_ != null) {
          parametersBuilder_.dispose();
          parametersBuilder_ = null;
        }
        updateAvailable_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
            .internal_static_google_cloud_memcache_v1beta2_Instance_Node_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.memcache.v1beta2.Instance.Node getDefaultInstanceForType() {
        return com.google.cloud.memcache.v1beta2.Instance.Node.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.memcache.v1beta2.Instance.Node build() {
        com.google.cloud.memcache.v1beta2.Instance.Node result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.memcache.v1beta2.Instance.Node buildPartial() {
        com.google.cloud.memcache.v1beta2.Instance.Node result =
            new com.google.cloud.memcache.v1beta2.Instance.Node(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.memcache.v1beta2.Instance.Node result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.nodeId_ = nodeId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.zone_ = zone_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.state_ = state_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.host_ = host_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.port_ = port_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.parameters_ =
              parametersBuilder_ == null ? parameters_ : parametersBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.updateAvailable_ = updateAvailable_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.memcache.v1beta2.Instance.Node) {
          return mergeFrom((com.google.cloud.memcache.v1beta2.Instance.Node) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.memcache.v1beta2.Instance.Node other) {
        if (other == com.google.cloud.memcache.v1beta2.Instance.Node.getDefaultInstance())
          return this;
        if (!other.getNodeId().isEmpty()) {
          nodeId_ = other.nodeId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getZone().isEmpty()) {
          zone_ = other.zone_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (!other.getHost().isEmpty()) {
          host_ = other.host_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (other.getPort() != 0) {
          setPort(other.getPort());
        }
        if (other.hasParameters()) {
          mergeParameters(other.getParameters());
        }
        if (other.getUpdateAvailable() != false) {
          setUpdateAvailable(other.getUpdateAvailable());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  nodeId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  zone_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  host_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 40:
                {
                  port_ = input.readInt32();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              case 50:
                {
                  input.readMessage(getParametersFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              case 56:
                {
                  updateAvailable_ = input.readBool();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 56
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object nodeId_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Identifier of the Memcached node. The node id does not
       * include project or location like the Memcached instance name.
       * </pre>
       *
       * <code>string node_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The nodeId.
       */
      public java.lang.String getNodeId() {
        java.lang.Object ref = nodeId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          nodeId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Identifier of the Memcached node. The node id does not
       * include project or location like the Memcached instance name.
       * </pre>
       *
       * <code>string node_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for nodeId.
       */
      public com.google.protobuf.ByteString getNodeIdBytes() {
        java.lang.Object ref = nodeId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          nodeId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Identifier of the Memcached node. The node id does not
       * include project or location like the Memcached instance name.
       * </pre>
       *
       * <code>string node_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The nodeId to set.
       * @return This builder for chaining.
       */
      public Builder setNodeId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        nodeId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Identifier of the Memcached node. The node id does not
       * include project or location like the Memcached instance name.
       * </pre>
       *
       * <code>string node_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNodeId() {
        nodeId_ = getDefaultInstance().getNodeId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Identifier of the Memcached node. The node id does not
       * include project or location like the Memcached instance name.
       * </pre>
       *
       * <code>string node_id = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for nodeId to set.
       * @return This builder for chaining.
       */
      public Builder setNodeIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        nodeId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object zone_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Location (GCP Zone) for the Memcached node.
       * </pre>
       *
       * <code>string zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The zone.
       */
      public java.lang.String getZone() {
        java.lang.Object ref = zone_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          zone_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Location (GCP Zone) for the Memcached node.
       * </pre>
       *
       * <code>string zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for zone.
       */
      public com.google.protobuf.ByteString getZoneBytes() {
        java.lang.Object ref = zone_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          zone_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Location (GCP Zone) for the Memcached node.
       * </pre>
       *
       * <code>string zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The zone to set.
       * @return This builder for chaining.
       */
      public Builder setZone(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        zone_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Location (GCP Zone) for the Memcached node.
       * </pre>
       *
       * <code>string zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearZone() {
        zone_ = getDefaultInstance().getZone();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Location (GCP Zone) for the Memcached node.
       * </pre>
       *
       * <code>string zone = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for zone to set.
       * @return This builder for chaining.
       */
      public Builder setZoneBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        zone_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. Current state of the Memcached node.
       * </pre>
       *
       * <code>
       * .google.cloud.memcache.v1beta2.Instance.Node.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Current state of the Memcached node.
       * </pre>
       *
       * <code>
       * .google.cloud.memcache.v1beta2.Instance.Node.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Current state of the Memcached node.
       * </pre>
       *
       * <code>
       * .google.cloud.memcache.v1beta2.Instance.Node.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.memcache.v1beta2.Instance.Node.State getState() {
        com.google.cloud.memcache.v1beta2.Instance.Node.State result =
            com.google.cloud.memcache.v1beta2.Instance.Node.State.forNumber(state_);
        return result == null
            ? com.google.cloud.memcache.v1beta2.Instance.Node.State.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. Current state of the Memcached node.
       * </pre>
       *
       * <code>
       * .google.cloud.memcache.v1beta2.Instance.Node.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(com.google.cloud.memcache.v1beta2.Instance.Node.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Current state of the Memcached node.
       * </pre>
       *
       * <code>
       * .google.cloud.memcache.v1beta2.Instance.Node.State state = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000004);
        state_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object host_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Hostname or IP address of the Memcached node used by the
       * clients to connect to the Memcached server on this node.
       * </pre>
       *
       * <code>string host = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The host.
       */
      public java.lang.String getHost() {
        java.lang.Object ref = host_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          host_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Hostname or IP address of the Memcached node used by the
       * clients to connect to the Memcached server on this node.
       * </pre>
       *
       * <code>string host = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for host.
       */
      public com.google.protobuf.ByteString getHostBytes() {
        java.lang.Object ref = host_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          host_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Hostname or IP address of the Memcached node used by the
       * clients to connect to the Memcached server on this node.
       * </pre>
       *
       * <code>string host = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The host to set.
       * @return This builder for chaining.
       */
      public Builder setHost(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        host_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Hostname or IP address of the Memcached node used by the
       * clients to connect to the Memcached server on this node.
       * </pre>
       *
       * <code>string host = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHost() {
        host_ = getDefaultInstance().getHost();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Hostname or IP address of the Memcached node used by the
       * clients to connect to the Memcached server on this node.
       * </pre>
       *
       * <code>string host = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for host to set.
       * @return This builder for chaining.
       */
      public Builder setHostBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        host_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private int port_;
      /**
       *
       *
       * <pre>
       * Output only. The port number of the Memcached server on this node.
       * </pre>
       *
       * <code>int32 port = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The port.
       */
      @java.lang.Override
      public int getPort() {
        return port_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The port number of the Memcached server on this node.
       * </pre>
       *
       * <code>int32 port = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The port to set.
       * @return This builder for chaining.
       */
      public Builder setPort(int value) {

        port_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The port number of the Memcached server on this node.
       * </pre>
       *
       * <code>int32 port = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPort() {
        bitField0_ = (bitField0_ & ~0x00000010);
        port_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.memcache.v1beta2.MemcacheParameters parameters_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.memcache.v1beta2.MemcacheParameters,
              com.google.cloud.memcache.v1beta2.MemcacheParameters.Builder,
              com.google.cloud.memcache.v1beta2.MemcacheParametersOrBuilder>
          parametersBuilder_;
      /**
       *
       *
       * <pre>
       * User defined parameters currently applied to the node.
       * </pre>
       *
       * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 6;</code>
       *
       * @return Whether the parameters field is set.
       */
      public boolean hasParameters() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * User defined parameters currently applied to the node.
       * </pre>
       *
       * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 6;</code>
       *
       * @return The parameters.
       */
      public com.google.cloud.memcache.v1beta2.MemcacheParameters getParameters() {
        if (parametersBuilder_ == null) {
          return parameters_ == null
              ? com.google.cloud.memcache.v1beta2.MemcacheParameters.getDefaultInstance()
              : parameters_;
        } else {
          return parametersBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * User defined parameters currently applied to the node.
       * </pre>
       *
       * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 6;</code>
       */
      public Builder setParameters(com.google.cloud.memcache.v1beta2.MemcacheParameters value) {
        if (parametersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          parameters_ = value;
        } else {
          parametersBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * User defined parameters currently applied to the node.
       * </pre>
       *
       * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 6;</code>
       */
      public Builder setParameters(
          com.google.cloud.memcache.v1beta2.MemcacheParameters.Builder builderForValue) {
        if (parametersBuilder_ == null) {
          parameters_ = builderForValue.build();
        } else {
          parametersBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * User defined parameters currently applied to the node.
       * </pre>
       *
       * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 6;</code>
       */
      public Builder mergeParameters(com.google.cloud.memcache.v1beta2.MemcacheParameters value) {
        if (parametersBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && parameters_ != null
              && parameters_
                  != com.google.cloud.memcache.v1beta2.MemcacheParameters.getDefaultInstance()) {
            getParametersBuilder().mergeFrom(value);
          } else {
            parameters_ = value;
          }
        } else {
          parametersBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * User defined parameters currently applied to the node.
       * </pre>
       *
       * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 6;</code>
       */
      public Builder clearParameters() {
        bitField0_ = (bitField0_ & ~0x00000020);
        parameters_ = null;
        if (parametersBuilder_ != null) {
          parametersBuilder_.dispose();
          parametersBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * User defined parameters currently applied to the node.
       * </pre>
       *
       * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 6;</code>
       */
      public com.google.cloud.memcache.v1beta2.MemcacheParameters.Builder getParametersBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getParametersFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * User defined parameters currently applied to the node.
       * </pre>
       *
       * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 6;</code>
       */
      public com.google.cloud.memcache.v1beta2.MemcacheParametersOrBuilder
          getParametersOrBuilder() {
        if (parametersBuilder_ != null) {
          return parametersBuilder_.getMessageOrBuilder();
        } else {
          return parameters_ == null
              ? com.google.cloud.memcache.v1beta2.MemcacheParameters.getDefaultInstance()
              : parameters_;
        }
      }
      /**
       *
       *
       * <pre>
       * User defined parameters currently applied to the node.
       * </pre>
       *
       * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.memcache.v1beta2.MemcacheParameters,
              com.google.cloud.memcache.v1beta2.MemcacheParameters.Builder,
              com.google.cloud.memcache.v1beta2.MemcacheParametersOrBuilder>
          getParametersFieldBuilder() {
        if (parametersBuilder_ == null) {
          parametersBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.memcache.v1beta2.MemcacheParameters,
                  com.google.cloud.memcache.v1beta2.MemcacheParameters.Builder,
                  com.google.cloud.memcache.v1beta2.MemcacheParametersOrBuilder>(
                  getParameters(), getParentForChildren(), isClean());
          parameters_ = null;
        }
        return parametersBuilder_;
      }

      private boolean updateAvailable_;
      /**
       *
       *
       * <pre>
       * Output only. Returns true if there is an update waiting to be applied
       * </pre>
       *
       * <code>bool update_available = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The updateAvailable.
       */
      @java.lang.Override
      public boolean getUpdateAvailable() {
        return updateAvailable_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Returns true if there is an update waiting to be applied
       * </pre>
       *
       * <code>bool update_available = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The updateAvailable to set.
       * @return This builder for chaining.
       */
      public Builder setUpdateAvailable(boolean value) {

        updateAvailable_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Returns true if there is an update waiting to be applied
       * </pre>
       *
       * <code>bool update_available = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUpdateAvailable() {
        bitField0_ = (bitField0_ & ~0x00000040);
        updateAvailable_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.memcache.v1beta2.Instance.Node)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.memcache.v1beta2.Instance.Node)
    private static final com.google.cloud.memcache.v1beta2.Instance.Node DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.memcache.v1beta2.Instance.Node();
    }

    public static com.google.cloud.memcache.v1beta2.Instance.Node getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Node> PARSER =
        new com.google.protobuf.AbstractParser<Node>() {
          @java.lang.Override
          public Node parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Node> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Node> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.memcache.v1beta2.Instance.Node getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface InstanceMessageOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.memcache.v1beta2.Instance.InstanceMessage)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A code that correspond to one type of user-facing message.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code code = 1;</code>
     *
     * @return The enum numeric value on the wire for code.
     */
    int getCodeValue();
    /**
     *
     *
     * <pre>
     * A code that correspond to one type of user-facing message.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code code = 1;</code>
     *
     * @return The code.
     */
    com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code getCode();

    /**
     *
     *
     * <pre>
     * Message on memcached instance which will be exposed to users.
     * </pre>
     *
     * <code>string message = 2;</code>
     *
     * @return The message.
     */
    java.lang.String getMessage();
    /**
     *
     *
     * <pre>
     * Message on memcached instance which will be exposed to users.
     * </pre>
     *
     * <code>string message = 2;</code>
     *
     * @return The bytes for message.
     */
    com.google.protobuf.ByteString getMessageBytes();
  }
  /** Protobuf type {@code google.cloud.memcache.v1beta2.Instance.InstanceMessage} */
  public static final class InstanceMessage extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.memcache.v1beta2.Instance.InstanceMessage)
      InstanceMessageOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InstanceMessage.newBuilder() to construct.
    private InstanceMessage(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InstanceMessage() {
      code_ = 0;
      message_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InstanceMessage();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
          .internal_static_google_cloud_memcache_v1beta2_Instance_InstanceMessage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
          .internal_static_google_cloud_memcache_v1beta2_Instance_InstanceMessage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.class,
              com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Builder.class);
    }

    /** Protobuf enum {@code google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code} */
    public enum Code implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Message Code not set.
       * </pre>
       *
       * <code>CODE_UNSPECIFIED = 0;</code>
       */
      CODE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Memcached nodes are distributed unevenly.
       * </pre>
       *
       * <code>ZONE_DISTRIBUTION_UNBALANCED = 1;</code>
       */
      ZONE_DISTRIBUTION_UNBALANCED(1),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Message Code not set.
       * </pre>
       *
       * <code>CODE_UNSPECIFIED = 0;</code>
       */
      public static final int CODE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Memcached nodes are distributed unevenly.
       * </pre>
       *
       * <code>ZONE_DISTRIBUTION_UNBALANCED = 1;</code>
       */
      public static final int ZONE_DISTRIBUTION_UNBALANCED_VALUE = 1;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Code valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Code forNumber(int value) {
        switch (value) {
          case 0:
            return CODE_UNSPECIFIED;
          case 1:
            return ZONE_DISTRIBUTION_UNBALANCED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Code> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Code> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Code>() {
            public Code findValueByNumber(int number) {
              return Code.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Code[] VALUES = values();

      public static Code valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Code(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code)
    }

    public static final int CODE_FIELD_NUMBER = 1;
    private int code_ = 0;
    /**
     *
     *
     * <pre>
     * A code that correspond to one type of user-facing message.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code code = 1;</code>
     *
     * @return The enum numeric value on the wire for code.
     */
    @java.lang.Override
    public int getCodeValue() {
      return code_;
    }
    /**
     *
     *
     * <pre>
     * A code that correspond to one type of user-facing message.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code code = 1;</code>
     *
     * @return The code.
     */
    @java.lang.Override
    public com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code getCode() {
      com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code result =
          com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code.forNumber(code_);
      return result == null
          ? com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code.UNRECOGNIZED
          : result;
    }

    public static final int MESSAGE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object message_ = "";
    /**
     *
     *
     * <pre>
     * Message on memcached instance which will be exposed to users.
     * </pre>
     *
     * <code>string message = 2;</code>
     *
     * @return The message.
     */
    @java.lang.Override
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        message_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Message on memcached instance which will be exposed to users.
     * </pre>
     *
     * <code>string message = 2;</code>
     *
     * @return The bytes for message.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (code_
          != com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code.CODE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, code_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, message_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (code_
          != com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code.CODE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, code_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, message_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.memcache.v1beta2.Instance.InstanceMessage)) {
        return super.equals(obj);
      }
      com.google.cloud.memcache.v1beta2.Instance.InstanceMessage other =
          (com.google.cloud.memcache.v1beta2.Instance.InstanceMessage) obj;

      if (code_ != other.code_) return false;
      if (!getMessage().equals(other.getMessage())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CODE_FIELD_NUMBER;
      hash = (53 * hash) + code_;
      hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getMessage().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.memcache.v1beta2.Instance.InstanceMessage parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.InstanceMessage parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.InstanceMessage parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.InstanceMessage parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.InstanceMessage parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.InstanceMessage parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.InstanceMessage parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.InstanceMessage parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.InstanceMessage parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.InstanceMessage parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.InstanceMessage parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.memcache.v1beta2.Instance.InstanceMessage parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.memcache.v1beta2.Instance.InstanceMessage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /** Protobuf type {@code google.cloud.memcache.v1beta2.Instance.InstanceMessage} */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.memcache.v1beta2.Instance.InstanceMessage)
        com.google.cloud.memcache.v1beta2.Instance.InstanceMessageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
            .internal_static_google_cloud_memcache_v1beta2_Instance_InstanceMessage_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
            .internal_static_google_cloud_memcache_v1beta2_Instance_InstanceMessage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.class,
                com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Builder.class);
      }

      // Construct using com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        code_ = 0;
        message_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
            .internal_static_google_cloud_memcache_v1beta2_Instance_InstanceMessage_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.memcache.v1beta2.Instance.InstanceMessage
          getDefaultInstanceForType() {
        return com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.memcache.v1beta2.Instance.InstanceMessage build() {
        com.google.cloud.memcache.v1beta2.Instance.InstanceMessage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.memcache.v1beta2.Instance.InstanceMessage buildPartial() {
        com.google.cloud.memcache.v1beta2.Instance.InstanceMessage result =
            new com.google.cloud.memcache.v1beta2.Instance.InstanceMessage(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.memcache.v1beta2.Instance.InstanceMessage result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.code_ = code_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.message_ = message_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.memcache.v1beta2.Instance.InstanceMessage) {
          return mergeFrom((com.google.cloud.memcache.v1beta2.Instance.InstanceMessage) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.memcache.v1beta2.Instance.InstanceMessage other) {
        if (other
            == com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.getDefaultInstance())
          return this;
        if (other.code_ != 0) {
          setCodeValue(other.getCodeValue());
        }
        if (!other.getMessage().isEmpty()) {
          message_ = other.message_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  code_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  message_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int code_ = 0;
      /**
       *
       *
       * <pre>
       * A code that correspond to one type of user-facing message.
       * </pre>
       *
       * <code>.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code code = 1;</code>
       *
       * @return The enum numeric value on the wire for code.
       */
      @java.lang.Override
      public int getCodeValue() {
        return code_;
      }
      /**
       *
       *
       * <pre>
       * A code that correspond to one type of user-facing message.
       * </pre>
       *
       * <code>.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code code = 1;</code>
       *
       * @param value The enum numeric value on the wire for code to set.
       * @return This builder for chaining.
       */
      public Builder setCodeValue(int value) {
        code_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A code that correspond to one type of user-facing message.
       * </pre>
       *
       * <code>.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code code = 1;</code>
       *
       * @return The code.
       */
      @java.lang.Override
      public com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code getCode() {
        com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code result =
            com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code.forNumber(code_);
        return result == null
            ? com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * A code that correspond to one type of user-facing message.
       * </pre>
       *
       * <code>.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code code = 1;</code>
       *
       * @param value The code to set.
       * @return This builder for chaining.
       */
      public Builder setCode(
          com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        code_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A code that correspond to one type of user-facing message.
       * </pre>
       *
       * <code>.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Code code = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCode() {
        bitField0_ = (bitField0_ & ~0x00000001);
        code_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object message_ = "";
      /**
       *
       *
       * <pre>
       * Message on memcached instance which will be exposed to users.
       * </pre>
       *
       * <code>string message = 2;</code>
       *
       * @return The message.
       */
      public java.lang.String getMessage() {
        java.lang.Object ref = message_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          message_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Message on memcached instance which will be exposed to users.
       * </pre>
       *
       * <code>string message = 2;</code>
       *
       * @return The bytes for message.
       */
      public com.google.protobuf.ByteString getMessageBytes() {
        java.lang.Object ref = message_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          message_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Message on memcached instance which will be exposed to users.
       * </pre>
       *
       * <code>string message = 2;</code>
       *
       * @param value The message to set.
       * @return This builder for chaining.
       */
      public Builder setMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        message_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Message on memcached instance which will be exposed to users.
       * </pre>
       *
       * <code>string message = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMessage() {
        message_ = getDefaultInstance().getMessage();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Message on memcached instance which will be exposed to users.
       * </pre>
       *
       * <code>string message = 2;</code>
       *
       * @param value The bytes for message to set.
       * @return This builder for chaining.
       */
      public Builder setMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        message_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.memcache.v1beta2.Instance.InstanceMessage)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.memcache.v1beta2.Instance.InstanceMessage)
    private static final com.google.cloud.memcache.v1beta2.Instance.InstanceMessage
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.memcache.v1beta2.Instance.InstanceMessage();
    }

    public static com.google.cloud.memcache.v1beta2.Instance.InstanceMessage getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InstanceMessage> PARSER =
        new com.google.protobuf.AbstractParser<InstanceMessage>() {
          @java.lang.Override
          public InstanceMessage parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InstanceMessage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InstanceMessage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.memcache.v1beta2.Instance.InstanceMessage getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. Unique name of the resource in this scope including project and
   * location using the form:
   *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
   *
   * Note: Memcached instances are managed and addressed at the regional level
   * so `location_id` here refers to a Google Cloud region; however, users may
   * choose which zones Memcached nodes should be provisioned in within an
   * instance. Refer to [zones][google.cloud.memcache.v1beta2.Instance.zones] field for more details.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Unique name of the resource in this scope including project and
   * location using the form:
   *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
   *
   * Note: Memcached instances are managed and addressed at the regional level
   * so `location_id` here refers to a Google Cloud region; however, users may
   * choose which zones Memcached nodes should be provisioned in within an
   * instance. Refer to [zones][google.cloud.memcache.v1beta2.Instance.zones] field for more details.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * User provided name for the instance, which is only used for display
   * purposes. Cannot be more than 80 characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User provided name for the instance, which is only used for display
   * purposes. Cannot be more than 80 characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 3;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.memcache.v1beta2.CloudMemcacheProto
                .internal_static_google_cloud_memcache_v1beta2_Instance_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user-provided metadata.
   * Refer to cloud documentation on labels for more details.
   * https://cloud.google.com/compute/docs/labeling-resources
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user-provided metadata.
   * Refer to cloud documentation on labels for more details.
   * https://cloud.google.com/compute/docs/labeling-resources
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user-provided metadata.
   * Refer to cloud documentation on labels for more details.
   * https://cloud.google.com/compute/docs/labeling-resources
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Resource labels to represent user-provided metadata.
   * Refer to cloud documentation on labels for more details.
   * https://cloud.google.com/compute/docs/labeling-resources
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int AUTHORIZED_NETWORK_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object authorizedNetwork_ = "";
  /**
   *
   *
   * <pre>
   * The full name of the Google Compute Engine
   * [network](https://cloud.google.com/vpc/docs/vpc) to which the
   * instance is connected. If left unspecified, the `default` network
   * will be used.
   * </pre>
   *
   * <code>string authorized_network = 4;</code>
   *
   * @return The authorizedNetwork.
   */
  @java.lang.Override
  public java.lang.String getAuthorizedNetwork() {
    java.lang.Object ref = authorizedNetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      authorizedNetwork_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full name of the Google Compute Engine
   * [network](https://cloud.google.com/vpc/docs/vpc) to which the
   * instance is connected. If left unspecified, the `default` network
   * will be used.
   * </pre>
   *
   * <code>string authorized_network = 4;</code>
   *
   * @return The bytes for authorizedNetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAuthorizedNetworkBytes() {
    java.lang.Object ref = authorizedNetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      authorizedNetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList zones_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Zones in which Memcached nodes should be provisioned.
   * Memcached nodes will be equally distributed across these zones. If not
   * provided, the service will by default create nodes in all zones in the
   * region for the instance.
   * </pre>
   *
   * <code>repeated string zones = 5;</code>
   *
   * @return A list containing the zones.
   */
  public com.google.protobuf.ProtocolStringList getZonesList() {
    return zones_;
  }
  /**
   *
   *
   * <pre>
   * Zones in which Memcached nodes should be provisioned.
   * Memcached nodes will be equally distributed across these zones. If not
   * provided, the service will by default create nodes in all zones in the
   * region for the instance.
   * </pre>
   *
   * <code>repeated string zones = 5;</code>
   *
   * @return The count of zones.
   */
  public int getZonesCount() {
    return zones_.size();
  }
  /**
   *
   *
   * <pre>
   * Zones in which Memcached nodes should be provisioned.
   * Memcached nodes will be equally distributed across these zones. If not
   * provided, the service will by default create nodes in all zones in the
   * region for the instance.
   * </pre>
   *
   * <code>repeated string zones = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The zones at the given index.
   */
  public java.lang.String getZones(int index) {
    return zones_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Zones in which Memcached nodes should be provisioned.
   * Memcached nodes will be equally distributed across these zones. If not
   * provided, the service will by default create nodes in all zones in the
   * region for the instance.
   * </pre>
   *
   * <code>repeated string zones = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the zones at the given index.
   */
  public com.google.protobuf.ByteString getZonesBytes(int index) {
    return zones_.getByteString(index);
  }

  public static final int NODE_COUNT_FIELD_NUMBER = 6;
  private int nodeCount_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Number of nodes in the Memcached instance.
   * </pre>
   *
   * <code>int32 node_count = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The nodeCount.
   */
  @java.lang.Override
  public int getNodeCount() {
    return nodeCount_;
  }

  public static final int NODE_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.memcache.v1beta2.Instance.NodeConfig nodeConfig_;
  /**
   *
   *
   * <pre>
   * Required. Configuration for Memcached nodes.
   * </pre>
   *
   * <code>
   * .google.cloud.memcache.v1beta2.Instance.NodeConfig node_config = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the nodeConfig field is set.
   */
  @java.lang.Override
  public boolean hasNodeConfig() {
    return nodeConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Configuration for Memcached nodes.
   * </pre>
   *
   * <code>
   * .google.cloud.memcache.v1beta2.Instance.NodeConfig node_config = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The nodeConfig.
   */
  @java.lang.Override
  public com.google.cloud.memcache.v1beta2.Instance.NodeConfig getNodeConfig() {
    return nodeConfig_ == null
        ? com.google.cloud.memcache.v1beta2.Instance.NodeConfig.getDefaultInstance()
        : nodeConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Configuration for Memcached nodes.
   * </pre>
   *
   * <code>
   * .google.cloud.memcache.v1beta2.Instance.NodeConfig node_config = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.memcache.v1beta2.Instance.NodeConfigOrBuilder getNodeConfigOrBuilder() {
    return nodeConfig_ == null
        ? com.google.cloud.memcache.v1beta2.Instance.NodeConfig.getDefaultInstance()
        : nodeConfig_;
  }

  public static final int MEMCACHE_VERSION_FIELD_NUMBER = 9;
  private int memcacheVersion_ = 0;
  /**
   *
   *
   * <pre>
   * The major version of Memcached software.
   * If not provided, latest supported version will be used. Currently the
   * latest supported major version is `MEMCACHE_1_5`.
   * The minor version will be automatically determined by our system based on
   * the latest supported minor version.
   * </pre>
   *
   * <code>.google.cloud.memcache.v1beta2.MemcacheVersion memcache_version = 9;</code>
   *
   * @return The enum numeric value on the wire for memcacheVersion.
   */
  @java.lang.Override
  public int getMemcacheVersionValue() {
    return memcacheVersion_;
  }
  /**
   *
   *
   * <pre>
   * The major version of Memcached software.
   * If not provided, latest supported version will be used. Currently the
   * latest supported major version is `MEMCACHE_1_5`.
   * The minor version will be automatically determined by our system based on
   * the latest supported minor version.
   * </pre>
   *
   * <code>.google.cloud.memcache.v1beta2.MemcacheVersion memcache_version = 9;</code>
   *
   * @return The memcacheVersion.
   */
  @java.lang.Override
  public com.google.cloud.memcache.v1beta2.MemcacheVersion getMemcacheVersion() {
    com.google.cloud.memcache.v1beta2.MemcacheVersion result =
        com.google.cloud.memcache.v1beta2.MemcacheVersion.forNumber(memcacheVersion_);
    return result == null ? com.google.cloud.memcache.v1beta2.MemcacheVersion.UNRECOGNIZED : result;
  }

  public static final int PARAMETERS_FIELD_NUMBER = 11;
  private com.google.cloud.memcache.v1beta2.MemcacheParameters parameters_;
  /**
   *
   *
   * <pre>
   * User defined parameters to apply to the memcached process
   * on each node.
   * </pre>
   *
   * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 11;</code>
   *
   * @return Whether the parameters field is set.
   */
  @java.lang.Override
  public boolean hasParameters() {
    return parameters_ != null;
  }
  /**
   *
   *
   * <pre>
   * User defined parameters to apply to the memcached process
   * on each node.
   * </pre>
   *
   * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 11;</code>
   *
   * @return The parameters.
   */
  @java.lang.Override
  public com.google.cloud.memcache.v1beta2.MemcacheParameters getParameters() {
    return parameters_ == null
        ? com.google.cloud.memcache.v1beta2.MemcacheParameters.getDefaultInstance()
        : parameters_;
  }
  /**
   *
   *
   * <pre>
   * User defined parameters to apply to the memcached process
   * on each node.
   * </pre>
   *
   * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.memcache.v1beta2.MemcacheParametersOrBuilder getParametersOrBuilder() {
    return parameters_ == null
        ? com.google.cloud.memcache.v1beta2.MemcacheParameters.getDefaultInstance()
        : parameters_;
  }

  public static final int MEMCACHE_NODES_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.memcache.v1beta2.Instance.Node> memcacheNodes_;
  /**
   *
   *
   * <pre>
   * Output only. List of Memcached nodes.
   * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.memcache.v1beta2.Instance.Node> getMemcacheNodesList() {
    return memcacheNodes_;
  }
  /**
   *
   *
   * <pre>
   * Output only. List of Memcached nodes.
   * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.memcache.v1beta2.Instance.NodeOrBuilder>
      getMemcacheNodesOrBuilderList() {
    return memcacheNodes_;
  }
  /**
   *
   *
   * <pre>
   * Output only. List of Memcached nodes.
   * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getMemcacheNodesCount() {
    return memcacheNodes_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. List of Memcached nodes.
   * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.memcache.v1beta2.Instance.Node getMemcacheNodes(int index) {
    return memcacheNodes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. List of Memcached nodes.
   * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.memcache.v1beta2.Instance.NodeOrBuilder getMemcacheNodesOrBuilder(
      int index) {
    return memcacheNodes_.get(index);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 13;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 14;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the instance was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int STATE_FIELD_NUMBER = 15;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of this Memcached instance.
   * </pre>
   *
   * <code>
   * .google.cloud.memcache.v1beta2.Instance.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of this Memcached instance.
   * </pre>
   *
   * <code>
   * .google.cloud.memcache.v1beta2.Instance.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.memcache.v1beta2.Instance.State getState() {
    com.google.cloud.memcache.v1beta2.Instance.State result =
        com.google.cloud.memcache.v1beta2.Instance.State.forNumber(state_);
    return result == null ? com.google.cloud.memcache.v1beta2.Instance.State.UNRECOGNIZED : result;
  }

  public static final int MEMCACHE_FULL_VERSION_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object memcacheFullVersion_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The full version of memcached server running on this instance.
   * System automatically determines the full memcached version for an instance
   * based on the input MemcacheVersion.
   * The full version format will be "memcached-1.5.16".
   * </pre>
   *
   * <code>string memcache_full_version = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The memcacheFullVersion.
   */
  @java.lang.Override
  public java.lang.String getMemcacheFullVersion() {
    java.lang.Object ref = memcacheFullVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      memcacheFullVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The full version of memcached server running on this instance.
   * System automatically determines the full memcached version for an instance
   * based on the input MemcacheVersion.
   * The full version format will be "memcached-1.5.16".
   * </pre>
   *
   * <code>string memcache_full_version = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for memcacheFullVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMemcacheFullVersionBytes() {
    java.lang.Object ref = memcacheFullVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      memcacheFullVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_MESSAGES_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.memcache.v1beta2.Instance.InstanceMessage>
      instanceMessages_;
  /**
   *
   *
   * <pre>
   * List of messages that describe the current state of the Memcached instance.
   * </pre>
   *
   * <code>repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.memcache.v1beta2.Instance.InstanceMessage>
      getInstanceMessagesList() {
    return instanceMessages_;
  }
  /**
   *
   *
   * <pre>
   * List of messages that describe the current state of the Memcached instance.
   * </pre>
   *
   * <code>repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.memcache.v1beta2.Instance.InstanceMessageOrBuilder>
      getInstanceMessagesOrBuilderList() {
    return instanceMessages_;
  }
  /**
   *
   *
   * <pre>
   * List of messages that describe the current state of the Memcached instance.
   * </pre>
   *
   * <code>repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
   * </code>
   */
  @java.lang.Override
  public int getInstanceMessagesCount() {
    return instanceMessages_.size();
  }
  /**
   *
   *
   * <pre>
   * List of messages that describe the current state of the Memcached instance.
   * </pre>
   *
   * <code>repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.memcache.v1beta2.Instance.InstanceMessage getInstanceMessages(int index) {
    return instanceMessages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of messages that describe the current state of the Memcached instance.
   * </pre>
   *
   * <code>repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.memcache.v1beta2.Instance.InstanceMessageOrBuilder
      getInstanceMessagesOrBuilder(int index) {
    return instanceMessages_.get(index);
  }

  public static final int DISCOVERY_ENDPOINT_FIELD_NUMBER = 20;

  @SuppressWarnings("serial")
  private volatile java.lang.Object discoveryEndpoint_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Endpoint for the Discovery API.
   * </pre>
   *
   * <code>string discovery_endpoint = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The discoveryEndpoint.
   */
  @java.lang.Override
  public java.lang.String getDiscoveryEndpoint() {
    java.lang.Object ref = discoveryEndpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      discoveryEndpoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Endpoint for the Discovery API.
   * </pre>
   *
   * <code>string discovery_endpoint = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for discoveryEndpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDiscoveryEndpointBytes() {
    java.lang.Object ref = discoveryEndpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      discoveryEndpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPDATE_AVAILABLE_FIELD_NUMBER = 21;
  private boolean updateAvailable_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Returns true if there is an update waiting to be applied
   * </pre>
   *
   * <code>bool update_available = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The updateAvailable.
   */
  @java.lang.Override
  public boolean getUpdateAvailable() {
    return updateAvailable_;
  }

  public static final int MAINTENANCE_POLICY_FIELD_NUMBER = 22;
  private com.google.cloud.memcache.v1beta2.MaintenancePolicy maintenancePolicy_;
  /**
   *
   *
   * <pre>
   * The maintenance policy for the instance. If not provided,
   * the maintenance event will be performed based on Memorystore
   * internal rollout schedule.
   * </pre>
   *
   * <code>.google.cloud.memcache.v1beta2.MaintenancePolicy maintenance_policy = 22;</code>
   *
   * @return Whether the maintenancePolicy field is set.
   */
  @java.lang.Override
  public boolean hasMaintenancePolicy() {
    return maintenancePolicy_ != null;
  }
  /**
   *
   *
   * <pre>
   * The maintenance policy for the instance. If not provided,
   * the maintenance event will be performed based on Memorystore
   * internal rollout schedule.
   * </pre>
   *
   * <code>.google.cloud.memcache.v1beta2.MaintenancePolicy maintenance_policy = 22;</code>
   *
   * @return The maintenancePolicy.
   */
  @java.lang.Override
  public com.google.cloud.memcache.v1beta2.MaintenancePolicy getMaintenancePolicy() {
    return maintenancePolicy_ == null
        ? com.google.cloud.memcache.v1beta2.MaintenancePolicy.getDefaultInstance()
        : maintenancePolicy_;
  }
  /**
   *
   *
   * <pre>
   * The maintenance policy for the instance. If not provided,
   * the maintenance event will be performed based on Memorystore
   * internal rollout schedule.
   * </pre>
   *
   * <code>.google.cloud.memcache.v1beta2.MaintenancePolicy maintenance_policy = 22;</code>
   */
  @java.lang.Override
  public com.google.cloud.memcache.v1beta2.MaintenancePolicyOrBuilder
      getMaintenancePolicyOrBuilder() {
    return maintenancePolicy_ == null
        ? com.google.cloud.memcache.v1beta2.MaintenancePolicy.getDefaultInstance()
        : maintenancePolicy_;
  }

  public static final int MAINTENANCE_SCHEDULE_FIELD_NUMBER = 23;
  private com.google.cloud.memcache.v1beta2.MaintenanceSchedule maintenanceSchedule_;
  /**
   *
   *
   * <pre>
   * Output only. Published maintenance schedule.
   * </pre>
   *
   * <code>
   * .google.cloud.memcache.v1beta2.MaintenanceSchedule maintenance_schedule = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the maintenanceSchedule field is set.
   */
  @java.lang.Override
  public boolean hasMaintenanceSchedule() {
    return maintenanceSchedule_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Published maintenance schedule.
   * </pre>
   *
   * <code>
   * .google.cloud.memcache.v1beta2.MaintenanceSchedule maintenance_schedule = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The maintenanceSchedule.
   */
  @java.lang.Override
  public com.google.cloud.memcache.v1beta2.MaintenanceSchedule getMaintenanceSchedule() {
    return maintenanceSchedule_ == null
        ? com.google.cloud.memcache.v1beta2.MaintenanceSchedule.getDefaultInstance()
        : maintenanceSchedule_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Published maintenance schedule.
   * </pre>
   *
   * <code>
   * .google.cloud.memcache.v1beta2.MaintenanceSchedule maintenance_schedule = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.memcache.v1beta2.MaintenanceScheduleOrBuilder
      getMaintenanceScheduleOrBuilder() {
    return maintenanceSchedule_ == null
        ? com.google.cloud.memcache.v1beta2.MaintenanceSchedule.getDefaultInstance()
        : maintenanceSchedule_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 3);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(authorizedNetwork_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, authorizedNetwork_);
    }
    for (int i = 0; i < zones_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, zones_.getRaw(i));
    }
    if (nodeCount_ != 0) {
      output.writeInt32(6, nodeCount_);
    }
    if (nodeConfig_ != null) {
      output.writeMessage(7, getNodeConfig());
    }
    if (memcacheVersion_
        != com.google.cloud.memcache.v1beta2.MemcacheVersion.MEMCACHE_VERSION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(9, memcacheVersion_);
    }
    if (parameters_ != null) {
      output.writeMessage(11, getParameters());
    }
    for (int i = 0; i < memcacheNodes_.size(); i++) {
      output.writeMessage(12, memcacheNodes_.get(i));
    }
    if (createTime_ != null) {
      output.writeMessage(13, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(14, getUpdateTime());
    }
    if (state_ != com.google.cloud.memcache.v1beta2.Instance.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(15, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(memcacheFullVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, memcacheFullVersion_);
    }
    for (int i = 0; i < instanceMessages_.size(); i++) {
      output.writeMessage(19, instanceMessages_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(discoveryEndpoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 20, discoveryEndpoint_);
    }
    if (updateAvailable_ != false) {
      output.writeBool(21, updateAvailable_);
    }
    if (maintenancePolicy_ != null) {
      output.writeMessage(22, getMaintenancePolicy());
    }
    if (maintenanceSchedule_ != null) {
      output.writeMessage(23, getMaintenanceSchedule());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(authorizedNetwork_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, authorizedNetwork_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < zones_.size(); i++) {
        dataSize += computeStringSizeNoTag(zones_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getZonesList().size();
    }
    if (nodeCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, nodeCount_);
    }
    if (nodeConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getNodeConfig());
    }
    if (memcacheVersion_
        != com.google.cloud.memcache.v1beta2.MemcacheVersion.MEMCACHE_VERSION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, memcacheVersion_);
    }
    if (parameters_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getParameters());
    }
    for (int i = 0; i < memcacheNodes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, memcacheNodes_.get(i));
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getUpdateTime());
    }
    if (state_ != com.google.cloud.memcache.v1beta2.Instance.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(15, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(memcacheFullVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, memcacheFullVersion_);
    }
    for (int i = 0; i < instanceMessages_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(19, instanceMessages_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(discoveryEndpoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(20, discoveryEndpoint_);
    }
    if (updateAvailable_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(21, updateAvailable_);
    }
    if (maintenancePolicy_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, getMaintenancePolicy());
    }
    if (maintenanceSchedule_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(23, getMaintenanceSchedule());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.memcache.v1beta2.Instance)) {
      return super.equals(obj);
    }
    com.google.cloud.memcache.v1beta2.Instance other =
        (com.google.cloud.memcache.v1beta2.Instance) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getAuthorizedNetwork().equals(other.getAuthorizedNetwork())) return false;
    if (!getZonesList().equals(other.getZonesList())) return false;
    if (getNodeCount() != other.getNodeCount()) return false;
    if (hasNodeConfig() != other.hasNodeConfig()) return false;
    if (hasNodeConfig()) {
      if (!getNodeConfig().equals(other.getNodeConfig())) return false;
    }
    if (memcacheVersion_ != other.memcacheVersion_) return false;
    if (hasParameters() != other.hasParameters()) return false;
    if (hasParameters()) {
      if (!getParameters().equals(other.getParameters())) return false;
    }
    if (!getMemcacheNodesList().equals(other.getMemcacheNodesList())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getMemcacheFullVersion().equals(other.getMemcacheFullVersion())) return false;
    if (!getInstanceMessagesList().equals(other.getInstanceMessagesList())) return false;
    if (!getDiscoveryEndpoint().equals(other.getDiscoveryEndpoint())) return false;
    if (getUpdateAvailable() != other.getUpdateAvailable()) return false;
    if (hasMaintenancePolicy() != other.hasMaintenancePolicy()) return false;
    if (hasMaintenancePolicy()) {
      if (!getMaintenancePolicy().equals(other.getMaintenancePolicy())) return false;
    }
    if (hasMaintenanceSchedule() != other.hasMaintenanceSchedule()) return false;
    if (hasMaintenanceSchedule()) {
      if (!getMaintenanceSchedule().equals(other.getMaintenanceSchedule())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + AUTHORIZED_NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getAuthorizedNetwork().hashCode();
    if (getZonesCount() > 0) {
      hash = (37 * hash) + ZONES_FIELD_NUMBER;
      hash = (53 * hash) + getZonesList().hashCode();
    }
    hash = (37 * hash) + NODE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getNodeCount();
    if (hasNodeConfig()) {
      hash = (37 * hash) + NODE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNodeConfig().hashCode();
    }
    hash = (37 * hash) + MEMCACHE_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + memcacheVersion_;
    if (hasParameters()) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParameters().hashCode();
    }
    if (getMemcacheNodesCount() > 0) {
      hash = (37 * hash) + MEMCACHE_NODES_FIELD_NUMBER;
      hash = (53 * hash) + getMemcacheNodesList().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + MEMCACHE_FULL_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getMemcacheFullVersion().hashCode();
    if (getInstanceMessagesCount() > 0) {
      hash = (37 * hash) + INSTANCE_MESSAGES_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceMessagesList().hashCode();
    }
    hash = (37 * hash) + DISCOVERY_ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getDiscoveryEndpoint().hashCode();
    hash = (37 * hash) + UPDATE_AVAILABLE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUpdateAvailable());
    if (hasMaintenancePolicy()) {
      hash = (37 * hash) + MAINTENANCE_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getMaintenancePolicy().hashCode();
    }
    if (hasMaintenanceSchedule()) {
      hash = (37 * hash) + MAINTENANCE_SCHEDULE_FIELD_NUMBER;
      hash = (53 * hash) + getMaintenanceSchedule().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.memcache.v1beta2.Instance parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.memcache.v1beta2.Instance parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.memcache.v1beta2.Instance parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.memcache.v1beta2.Instance parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.memcache.v1beta2.Instance parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.memcache.v1beta2.Instance parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.memcache.v1beta2.Instance parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.memcache.v1beta2.Instance parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.memcache.v1beta2.Instance parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.memcache.v1beta2.Instance parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.memcache.v1beta2.Instance parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.memcache.v1beta2.Instance parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.memcache.v1beta2.Instance prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Memorystore for Memcached instance
   * </pre>
   *
   * Protobuf type {@code google.cloud.memcache.v1beta2.Instance}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.memcache.v1beta2.Instance)
      com.google.cloud.memcache.v1beta2.InstanceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
          .internal_static_google_cloud_memcache_v1beta2_Instance_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
          .internal_static_google_cloud_memcache_v1beta2_Instance_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.memcache.v1beta2.Instance.class,
              com.google.cloud.memcache.v1beta2.Instance.Builder.class);
    }

    // Construct using com.google.cloud.memcache.v1beta2.Instance.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      internalGetMutableLabels().clear();
      authorizedNetwork_ = "";
      zones_ = com.google.protobuf.LazyStringArrayList.emptyList();
      nodeCount_ = 0;
      nodeConfig_ = null;
      if (nodeConfigBuilder_ != null) {
        nodeConfigBuilder_.dispose();
        nodeConfigBuilder_ = null;
      }
      memcacheVersion_ = 0;
      parameters_ = null;
      if (parametersBuilder_ != null) {
        parametersBuilder_.dispose();
        parametersBuilder_ = null;
      }
      if (memcacheNodesBuilder_ == null) {
        memcacheNodes_ = java.util.Collections.emptyList();
      } else {
        memcacheNodes_ = null;
        memcacheNodesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      state_ = 0;
      memcacheFullVersion_ = "";
      if (instanceMessagesBuilder_ == null) {
        instanceMessages_ = java.util.Collections.emptyList();
      } else {
        instanceMessages_ = null;
        instanceMessagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00004000);
      discoveryEndpoint_ = "";
      updateAvailable_ = false;
      maintenancePolicy_ = null;
      if (maintenancePolicyBuilder_ != null) {
        maintenancePolicyBuilder_.dispose();
        maintenancePolicyBuilder_ = null;
      }
      maintenanceSchedule_ = null;
      if (maintenanceScheduleBuilder_ != null) {
        maintenanceScheduleBuilder_.dispose();
        maintenanceScheduleBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
          .internal_static_google_cloud_memcache_v1beta2_Instance_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.memcache.v1beta2.Instance getDefaultInstanceForType() {
      return com.google.cloud.memcache.v1beta2.Instance.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.memcache.v1beta2.Instance build() {
      com.google.cloud.memcache.v1beta2.Instance result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.memcache.v1beta2.Instance buildPartial() {
      com.google.cloud.memcache.v1beta2.Instance result =
          new com.google.cloud.memcache.v1beta2.Instance(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.memcache.v1beta2.Instance result) {
      if (memcacheNodesBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          memcacheNodes_ = java.util.Collections.unmodifiableList(memcacheNodes_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.memcacheNodes_ = memcacheNodes_;
      } else {
        result.memcacheNodes_ = memcacheNodesBuilder_.build();
      }
      if (instanceMessagesBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)) {
          instanceMessages_ = java.util.Collections.unmodifiableList(instanceMessages_);
          bitField0_ = (bitField0_ & ~0x00004000);
        }
        result.instanceMessages_ = instanceMessages_;
      } else {
        result.instanceMessages_ = instanceMessagesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.memcache.v1beta2.Instance result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.authorizedNetwork_ = authorizedNetwork_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        zones_.makeImmutable();
        result.zones_ = zones_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.nodeCount_ = nodeCount_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.nodeConfig_ = nodeConfigBuilder_ == null ? nodeConfig_ : nodeConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.memcacheVersion_ = memcacheVersion_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.parameters_ = parametersBuilder_ == null ? parameters_ : parametersBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.memcacheFullVersion_ = memcacheFullVersion_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.discoveryEndpoint_ = discoveryEndpoint_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.updateAvailable_ = updateAvailable_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.maintenancePolicy_ =
            maintenancePolicyBuilder_ == null
                ? maintenancePolicy_
                : maintenancePolicyBuilder_.build();
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.maintenanceSchedule_ =
            maintenanceScheduleBuilder_ == null
                ? maintenanceSchedule_
                : maintenanceScheduleBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.memcache.v1beta2.Instance) {
        return mergeFrom((com.google.cloud.memcache.v1beta2.Instance) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.memcache.v1beta2.Instance other) {
      if (other == com.google.cloud.memcache.v1beta2.Instance.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000004;
      if (!other.getAuthorizedNetwork().isEmpty()) {
        authorizedNetwork_ = other.authorizedNetwork_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.zones_.isEmpty()) {
        if (zones_.isEmpty()) {
          zones_ = other.zones_;
          bitField0_ |= 0x00000010;
        } else {
          ensureZonesIsMutable();
          zones_.addAll(other.zones_);
        }
        onChanged();
      }
      if (other.getNodeCount() != 0) {
        setNodeCount(other.getNodeCount());
      }
      if (other.hasNodeConfig()) {
        mergeNodeConfig(other.getNodeConfig());
      }
      if (other.memcacheVersion_ != 0) {
        setMemcacheVersionValue(other.getMemcacheVersionValue());
      }
      if (other.hasParameters()) {
        mergeParameters(other.getParameters());
      }
      if (memcacheNodesBuilder_ == null) {
        if (!other.memcacheNodes_.isEmpty()) {
          if (memcacheNodes_.isEmpty()) {
            memcacheNodes_ = other.memcacheNodes_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureMemcacheNodesIsMutable();
            memcacheNodes_.addAll(other.memcacheNodes_);
          }
          onChanged();
        }
      } else {
        if (!other.memcacheNodes_.isEmpty()) {
          if (memcacheNodesBuilder_.isEmpty()) {
            memcacheNodesBuilder_.dispose();
            memcacheNodesBuilder_ = null;
            memcacheNodes_ = other.memcacheNodes_;
            bitField0_ = (bitField0_ & ~0x00000200);
            memcacheNodesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMemcacheNodesFieldBuilder()
                    : null;
          } else {
            memcacheNodesBuilder_.addAllMessages(other.memcacheNodes_);
          }
        }
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getMemcacheFullVersion().isEmpty()) {
        memcacheFullVersion_ = other.memcacheFullVersion_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (instanceMessagesBuilder_ == null) {
        if (!other.instanceMessages_.isEmpty()) {
          if (instanceMessages_.isEmpty()) {
            instanceMessages_ = other.instanceMessages_;
            bitField0_ = (bitField0_ & ~0x00004000);
          } else {
            ensureInstanceMessagesIsMutable();
            instanceMessages_.addAll(other.instanceMessages_);
          }
          onChanged();
        }
      } else {
        if (!other.instanceMessages_.isEmpty()) {
          if (instanceMessagesBuilder_.isEmpty()) {
            instanceMessagesBuilder_.dispose();
            instanceMessagesBuilder_ = null;
            instanceMessages_ = other.instanceMessages_;
            bitField0_ = (bitField0_ & ~0x00004000);
            instanceMessagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInstanceMessagesFieldBuilder()
                    : null;
          } else {
            instanceMessagesBuilder_.addAllMessages(other.instanceMessages_);
          }
        }
      }
      if (!other.getDiscoveryEndpoint().isEmpty()) {
        discoveryEndpoint_ = other.discoveryEndpoint_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.getUpdateAvailable() != false) {
        setUpdateAvailable(other.getUpdateAvailable());
      }
      if (other.hasMaintenancePolicy()) {
        mergeMaintenancePolicy(other.getMaintenancePolicy());
      }
      if (other.hasMaintenanceSchedule()) {
        mergeMaintenanceSchedule(other.getMaintenanceSchedule());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                authorizedNetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureZonesIsMutable();
                zones_.add(s);
                break;
              } // case 42
            case 48:
              {
                nodeCount_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(getNodeConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 72:
              {
                memcacheVersion_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
            case 90:
              {
                input.readMessage(getParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            case 98:
              {
                com.google.cloud.memcache.v1beta2.Instance.Node m =
                    input.readMessage(
                        com.google.cloud.memcache.v1beta2.Instance.Node.parser(),
                        extensionRegistry);
                if (memcacheNodesBuilder_ == null) {
                  ensureMemcacheNodesIsMutable();
                  memcacheNodes_.add(m);
                } else {
                  memcacheNodesBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 114
            case 120:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00001000;
                break;
              } // case 120
            case 146:
              {
                memcacheFullVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 146
            case 154:
              {
                com.google.cloud.memcache.v1beta2.Instance.InstanceMessage m =
                    input.readMessage(
                        com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.parser(),
                        extensionRegistry);
                if (instanceMessagesBuilder_ == null) {
                  ensureInstanceMessagesIsMutable();
                  instanceMessages_.add(m);
                } else {
                  instanceMessagesBuilder_.addMessage(m);
                }
                break;
              } // case 154
            case 162:
              {
                discoveryEndpoint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 162
            case 168:
              {
                updateAvailable_ = input.readBool();
                bitField0_ |= 0x00010000;
                break;
              } // case 168
            case 178:
              {
                input.readMessage(
                    getMaintenancePolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 178
            case 186:
              {
                input.readMessage(
                    getMaintenanceScheduleFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 186
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource in this scope including project and
     * location using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     *
     * Note: Memcached instances are managed and addressed at the regional level
     * so `location_id` here refers to a Google Cloud region; however, users may
     * choose which zones Memcached nodes should be provisioned in within an
     * instance. Refer to [zones][google.cloud.memcache.v1beta2.Instance.zones] field for more details.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource in this scope including project and
     * location using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     *
     * Note: Memcached instances are managed and addressed at the regional level
     * so `location_id` here refers to a Google Cloud region; however, users may
     * choose which zones Memcached nodes should be provisioned in within an
     * instance. Refer to [zones][google.cloud.memcache.v1beta2.Instance.zones] field for more details.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource in this scope including project and
     * location using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     *
     * Note: Memcached instances are managed and addressed at the regional level
     * so `location_id` here refers to a Google Cloud region; however, users may
     * choose which zones Memcached nodes should be provisioned in within an
     * instance. Refer to [zones][google.cloud.memcache.v1beta2.Instance.zones] field for more details.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource in this scope including project and
     * location using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     *
     * Note: Memcached instances are managed and addressed at the regional level
     * so `location_id` here refers to a Google Cloud region; however, users may
     * choose which zones Memcached nodes should be provisioned in within an
     * instance. Refer to [zones][google.cloud.memcache.v1beta2.Instance.zones] field for more details.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Unique name of the resource in this scope including project and
     * location using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     *
     * Note: Memcached instances are managed and addressed at the regional level
     * so `location_id` here refers to a Google Cloud region; however, users may
     * choose which zones Memcached nodes should be provisioned in within an
     * instance. Refer to [zones][google.cloud.memcache.v1beta2.Instance.zones] field for more details.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * User provided name for the instance, which is only used for display
     * purposes. Cannot be more than 80 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User provided name for the instance, which is only used for display
     * purposes. Cannot be more than 80 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User provided name for the instance, which is only used for display
     * purposes. Cannot be more than 80 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User provided name for the instance, which is only used for display
     * purposes. Cannot be more than 80 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User provided name for the instance, which is only used for display
     * purposes. Cannot be more than 80 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user-provided metadata.
     * Refer to cloud documentation on labels for more details.
     * https://cloud.google.com/compute/docs/labeling-resources
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user-provided metadata.
     * Refer to cloud documentation on labels for more details.
     * https://cloud.google.com/compute/docs/labeling-resources
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user-provided metadata.
     * Refer to cloud documentation on labels for more details.
     * https://cloud.google.com/compute/docs/labeling-resources
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user-provided metadata.
     * Refer to cloud documentation on labels for more details.
     * https://cloud.google.com/compute/docs/labeling-resources
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user-provided metadata.
     * Refer to cloud documentation on labels for more details.
     * https://cloud.google.com/compute/docs/labeling-resources
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000004;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user-provided metadata.
     * Refer to cloud documentation on labels for more details.
     * https://cloud.google.com/compute/docs/labeling-resources
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource labels to represent user-provided metadata.
     * Refer to cloud documentation on labels for more details.
     * https://cloud.google.com/compute/docs/labeling-resources
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 3;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    private java.lang.Object authorizedNetwork_ = "";
    /**
     *
     *
     * <pre>
     * The full name of the Google Compute Engine
     * [network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected. If left unspecified, the `default` network
     * will be used.
     * </pre>
     *
     * <code>string authorized_network = 4;</code>
     *
     * @return The authorizedNetwork.
     */
    public java.lang.String getAuthorizedNetwork() {
      java.lang.Object ref = authorizedNetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        authorizedNetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the Google Compute Engine
     * [network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected. If left unspecified, the `default` network
     * will be used.
     * </pre>
     *
     * <code>string authorized_network = 4;</code>
     *
     * @return The bytes for authorizedNetwork.
     */
    public com.google.protobuf.ByteString getAuthorizedNetworkBytes() {
      java.lang.Object ref = authorizedNetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        authorizedNetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the Google Compute Engine
     * [network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected. If left unspecified, the `default` network
     * will be used.
     * </pre>
     *
     * <code>string authorized_network = 4;</code>
     *
     * @param value The authorizedNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setAuthorizedNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      authorizedNetwork_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the Google Compute Engine
     * [network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected. If left unspecified, the `default` network
     * will be used.
     * </pre>
     *
     * <code>string authorized_network = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAuthorizedNetwork() {
      authorizedNetwork_ = getDefaultInstance().getAuthorizedNetwork();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the Google Compute Engine
     * [network](https://cloud.google.com/vpc/docs/vpc) to which the
     * instance is connected. If left unspecified, the `default` network
     * will be used.
     * </pre>
     *
     * <code>string authorized_network = 4;</code>
     *
     * @param value The bytes for authorizedNetwork to set.
     * @return This builder for chaining.
     */
    public Builder setAuthorizedNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      authorizedNetwork_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList zones_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureZonesIsMutable() {
      if (!zones_.isModifiable()) {
        zones_ = new com.google.protobuf.LazyStringArrayList(zones_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Zones in which Memcached nodes should be provisioned.
     * Memcached nodes will be equally distributed across these zones. If not
     * provided, the service will by default create nodes in all zones in the
     * region for the instance.
     * </pre>
     *
     * <code>repeated string zones = 5;</code>
     *
     * @return A list containing the zones.
     */
    public com.google.protobuf.ProtocolStringList getZonesList() {
      zones_.makeImmutable();
      return zones_;
    }
    /**
     *
     *
     * <pre>
     * Zones in which Memcached nodes should be provisioned.
     * Memcached nodes will be equally distributed across these zones. If not
     * provided, the service will by default create nodes in all zones in the
     * region for the instance.
     * </pre>
     *
     * <code>repeated string zones = 5;</code>
     *
     * @return The count of zones.
     */
    public int getZonesCount() {
      return zones_.size();
    }
    /**
     *
     *
     * <pre>
     * Zones in which Memcached nodes should be provisioned.
     * Memcached nodes will be equally distributed across these zones. If not
     * provided, the service will by default create nodes in all zones in the
     * region for the instance.
     * </pre>
     *
     * <code>repeated string zones = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The zones at the given index.
     */
    public java.lang.String getZones(int index) {
      return zones_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Zones in which Memcached nodes should be provisioned.
     * Memcached nodes will be equally distributed across these zones. If not
     * provided, the service will by default create nodes in all zones in the
     * region for the instance.
     * </pre>
     *
     * <code>repeated string zones = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the zones at the given index.
     */
    public com.google.protobuf.ByteString getZonesBytes(int index) {
      return zones_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Zones in which Memcached nodes should be provisioned.
     * Memcached nodes will be equally distributed across these zones. If not
     * provided, the service will by default create nodes in all zones in the
     * region for the instance.
     * </pre>
     *
     * <code>repeated string zones = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The zones to set.
     * @return This builder for chaining.
     */
    public Builder setZones(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureZonesIsMutable();
      zones_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Zones in which Memcached nodes should be provisioned.
     * Memcached nodes will be equally distributed across these zones. If not
     * provided, the service will by default create nodes in all zones in the
     * region for the instance.
     * </pre>
     *
     * <code>repeated string zones = 5;</code>
     *
     * @param value The zones to add.
     * @return This builder for chaining.
     */
    public Builder addZones(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureZonesIsMutable();
      zones_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Zones in which Memcached nodes should be provisioned.
     * Memcached nodes will be equally distributed across these zones. If not
     * provided, the service will by default create nodes in all zones in the
     * region for the instance.
     * </pre>
     *
     * <code>repeated string zones = 5;</code>
     *
     * @param values The zones to add.
     * @return This builder for chaining.
     */
    public Builder addAllZones(java.lang.Iterable<java.lang.String> values) {
      ensureZonesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, zones_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Zones in which Memcached nodes should be provisioned.
     * Memcached nodes will be equally distributed across these zones. If not
     * provided, the service will by default create nodes in all zones in the
     * region for the instance.
     * </pre>
     *
     * <code>repeated string zones = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZones() {
      zones_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Zones in which Memcached nodes should be provisioned.
     * Memcached nodes will be equally distributed across these zones. If not
     * provided, the service will by default create nodes in all zones in the
     * region for the instance.
     * </pre>
     *
     * <code>repeated string zones = 5;</code>
     *
     * @param value The bytes of the zones to add.
     * @return This builder for chaining.
     */
    public Builder addZonesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureZonesIsMutable();
      zones_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int nodeCount_;
    /**
     *
     *
     * <pre>
     * Required. Number of nodes in the Memcached instance.
     * </pre>
     *
     * <code>int32 node_count = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The nodeCount.
     */
    @java.lang.Override
    public int getNodeCount() {
      return nodeCount_;
    }
    /**
     *
     *
     * <pre>
     * Required. Number of nodes in the Memcached instance.
     * </pre>
     *
     * <code>int32 node_count = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The nodeCount to set.
     * @return This builder for chaining.
     */
    public Builder setNodeCount(int value) {

      nodeCount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Number of nodes in the Memcached instance.
     * </pre>
     *
     * <code>int32 node_count = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNodeCount() {
      bitField0_ = (bitField0_ & ~0x00000020);
      nodeCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.memcache.v1beta2.Instance.NodeConfig nodeConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.memcache.v1beta2.Instance.NodeConfig,
            com.google.cloud.memcache.v1beta2.Instance.NodeConfig.Builder,
            com.google.cloud.memcache.v1beta2.Instance.NodeConfigOrBuilder>
        nodeConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Configuration for Memcached nodes.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.Instance.NodeConfig node_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the nodeConfig field is set.
     */
    public boolean hasNodeConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for Memcached nodes.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.Instance.NodeConfig node_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The nodeConfig.
     */
    public com.google.cloud.memcache.v1beta2.Instance.NodeConfig getNodeConfig() {
      if (nodeConfigBuilder_ == null) {
        return nodeConfig_ == null
            ? com.google.cloud.memcache.v1beta2.Instance.NodeConfig.getDefaultInstance()
            : nodeConfig_;
      } else {
        return nodeConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for Memcached nodes.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.Instance.NodeConfig node_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setNodeConfig(com.google.cloud.memcache.v1beta2.Instance.NodeConfig value) {
      if (nodeConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nodeConfig_ = value;
      } else {
        nodeConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for Memcached nodes.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.Instance.NodeConfig node_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setNodeConfig(
        com.google.cloud.memcache.v1beta2.Instance.NodeConfig.Builder builderForValue) {
      if (nodeConfigBuilder_ == null) {
        nodeConfig_ = builderForValue.build();
      } else {
        nodeConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for Memcached nodes.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.Instance.NodeConfig node_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeNodeConfig(com.google.cloud.memcache.v1beta2.Instance.NodeConfig value) {
      if (nodeConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && nodeConfig_ != null
            && nodeConfig_
                != com.google.cloud.memcache.v1beta2.Instance.NodeConfig.getDefaultInstance()) {
          getNodeConfigBuilder().mergeFrom(value);
        } else {
          nodeConfig_ = value;
        }
      } else {
        nodeConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for Memcached nodes.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.Instance.NodeConfig node_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearNodeConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      nodeConfig_ = null;
      if (nodeConfigBuilder_ != null) {
        nodeConfigBuilder_.dispose();
        nodeConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for Memcached nodes.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.Instance.NodeConfig node_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.memcache.v1beta2.Instance.NodeConfig.Builder getNodeConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getNodeConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for Memcached nodes.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.Instance.NodeConfig node_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.memcache.v1beta2.Instance.NodeConfigOrBuilder getNodeConfigOrBuilder() {
      if (nodeConfigBuilder_ != null) {
        return nodeConfigBuilder_.getMessageOrBuilder();
      } else {
        return nodeConfig_ == null
            ? com.google.cloud.memcache.v1beta2.Instance.NodeConfig.getDefaultInstance()
            : nodeConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration for Memcached nodes.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.Instance.NodeConfig node_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.memcache.v1beta2.Instance.NodeConfig,
            com.google.cloud.memcache.v1beta2.Instance.NodeConfig.Builder,
            com.google.cloud.memcache.v1beta2.Instance.NodeConfigOrBuilder>
        getNodeConfigFieldBuilder() {
      if (nodeConfigBuilder_ == null) {
        nodeConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.memcache.v1beta2.Instance.NodeConfig,
                com.google.cloud.memcache.v1beta2.Instance.NodeConfig.Builder,
                com.google.cloud.memcache.v1beta2.Instance.NodeConfigOrBuilder>(
                getNodeConfig(), getParentForChildren(), isClean());
        nodeConfig_ = null;
      }
      return nodeConfigBuilder_;
    }

    private int memcacheVersion_ = 0;
    /**
     *
     *
     * <pre>
     * The major version of Memcached software.
     * If not provided, latest supported version will be used. Currently the
     * latest supported major version is `MEMCACHE_1_5`.
     * The minor version will be automatically determined by our system based on
     * the latest supported minor version.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheVersion memcache_version = 9;</code>
     *
     * @return The enum numeric value on the wire for memcacheVersion.
     */
    @java.lang.Override
    public int getMemcacheVersionValue() {
      return memcacheVersion_;
    }
    /**
     *
     *
     * <pre>
     * The major version of Memcached software.
     * If not provided, latest supported version will be used. Currently the
     * latest supported major version is `MEMCACHE_1_5`.
     * The minor version will be automatically determined by our system based on
     * the latest supported minor version.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheVersion memcache_version = 9;</code>
     *
     * @param value The enum numeric value on the wire for memcacheVersion to set.
     * @return This builder for chaining.
     */
    public Builder setMemcacheVersionValue(int value) {
      memcacheVersion_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The major version of Memcached software.
     * If not provided, latest supported version will be used. Currently the
     * latest supported major version is `MEMCACHE_1_5`.
     * The minor version will be automatically determined by our system based on
     * the latest supported minor version.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheVersion memcache_version = 9;</code>
     *
     * @return The memcacheVersion.
     */
    @java.lang.Override
    public com.google.cloud.memcache.v1beta2.MemcacheVersion getMemcacheVersion() {
      com.google.cloud.memcache.v1beta2.MemcacheVersion result =
          com.google.cloud.memcache.v1beta2.MemcacheVersion.forNumber(memcacheVersion_);
      return result == null
          ? com.google.cloud.memcache.v1beta2.MemcacheVersion.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The major version of Memcached software.
     * If not provided, latest supported version will be used. Currently the
     * latest supported major version is `MEMCACHE_1_5`.
     * The minor version will be automatically determined by our system based on
     * the latest supported minor version.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheVersion memcache_version = 9;</code>
     *
     * @param value The memcacheVersion to set.
     * @return This builder for chaining.
     */
    public Builder setMemcacheVersion(com.google.cloud.memcache.v1beta2.MemcacheVersion value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      memcacheVersion_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The major version of Memcached software.
     * If not provided, latest supported version will be used. Currently the
     * latest supported major version is `MEMCACHE_1_5`.
     * The minor version will be automatically determined by our system based on
     * the latest supported minor version.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheVersion memcache_version = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMemcacheVersion() {
      bitField0_ = (bitField0_ & ~0x00000080);
      memcacheVersion_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.memcache.v1beta2.MemcacheParameters parameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.memcache.v1beta2.MemcacheParameters,
            com.google.cloud.memcache.v1beta2.MemcacheParameters.Builder,
            com.google.cloud.memcache.v1beta2.MemcacheParametersOrBuilder>
        parametersBuilder_;
    /**
     *
     *
     * <pre>
     * User defined parameters to apply to the memcached process
     * on each node.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 11;</code>
     *
     * @return Whether the parameters field is set.
     */
    public boolean hasParameters() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * User defined parameters to apply to the memcached process
     * on each node.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 11;</code>
     *
     * @return The parameters.
     */
    public com.google.cloud.memcache.v1beta2.MemcacheParameters getParameters() {
      if (parametersBuilder_ == null) {
        return parameters_ == null
            ? com.google.cloud.memcache.v1beta2.MemcacheParameters.getDefaultInstance()
            : parameters_;
      } else {
        return parametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * User defined parameters to apply to the memcached process
     * on each node.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 11;</code>
     */
    public Builder setParameters(com.google.cloud.memcache.v1beta2.MemcacheParameters value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parameters_ = value;
      } else {
        parametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User defined parameters to apply to the memcached process
     * on each node.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 11;</code>
     */
    public Builder setParameters(
        com.google.cloud.memcache.v1beta2.MemcacheParameters.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        parameters_ = builderForValue.build();
      } else {
        parametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User defined parameters to apply to the memcached process
     * on each node.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 11;</code>
     */
    public Builder mergeParameters(com.google.cloud.memcache.v1beta2.MemcacheParameters value) {
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && parameters_ != null
            && parameters_
                != com.google.cloud.memcache.v1beta2.MemcacheParameters.getDefaultInstance()) {
          getParametersBuilder().mergeFrom(value);
        } else {
          parameters_ = value;
        }
      } else {
        parametersBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User defined parameters to apply to the memcached process
     * on each node.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 11;</code>
     */
    public Builder clearParameters() {
      bitField0_ = (bitField0_ & ~0x00000100);
      parameters_ = null;
      if (parametersBuilder_ != null) {
        parametersBuilder_.dispose();
        parametersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User defined parameters to apply to the memcached process
     * on each node.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 11;</code>
     */
    public com.google.cloud.memcache.v1beta2.MemcacheParameters.Builder getParametersBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * User defined parameters to apply to the memcached process
     * on each node.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 11;</code>
     */
    public com.google.cloud.memcache.v1beta2.MemcacheParametersOrBuilder getParametersOrBuilder() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilder();
      } else {
        return parameters_ == null
            ? com.google.cloud.memcache.v1beta2.MemcacheParameters.getDefaultInstance()
            : parameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * User defined parameters to apply to the memcached process
     * on each node.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MemcacheParameters parameters = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.memcache.v1beta2.MemcacheParameters,
            com.google.cloud.memcache.v1beta2.MemcacheParameters.Builder,
            com.google.cloud.memcache.v1beta2.MemcacheParametersOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.memcache.v1beta2.MemcacheParameters,
                com.google.cloud.memcache.v1beta2.MemcacheParameters.Builder,
                com.google.cloud.memcache.v1beta2.MemcacheParametersOrBuilder>(
                getParameters(), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    private java.util.List<com.google.cloud.memcache.v1beta2.Instance.Node> memcacheNodes_ =
        java.util.Collections.emptyList();

    private void ensureMemcacheNodesIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        memcacheNodes_ =
            new java.util.ArrayList<com.google.cloud.memcache.v1beta2.Instance.Node>(
                memcacheNodes_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.memcache.v1beta2.Instance.Node,
            com.google.cloud.memcache.v1beta2.Instance.Node.Builder,
            com.google.cloud.memcache.v1beta2.Instance.NodeOrBuilder>
        memcacheNodesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. List of Memcached nodes.
     * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.memcache.v1beta2.Instance.Node> getMemcacheNodesList() {
      if (memcacheNodesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(memcacheNodes_);
      } else {
        return memcacheNodesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of Memcached nodes.
     * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getMemcacheNodesCount() {
      if (memcacheNodesBuilder_ == null) {
        return memcacheNodes_.size();
      } else {
        return memcacheNodesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of Memcached nodes.
     * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.memcache.v1beta2.Instance.Node getMemcacheNodes(int index) {
      if (memcacheNodesBuilder_ == null) {
        return memcacheNodes_.get(index);
      } else {
        return memcacheNodesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of Memcached nodes.
     * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMemcacheNodes(
        int index, com.google.cloud.memcache.v1beta2.Instance.Node value) {
      if (memcacheNodesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMemcacheNodesIsMutable();
        memcacheNodes_.set(index, value);
        onChanged();
      } else {
        memcacheNodesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of Memcached nodes.
     * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMemcacheNodes(
        int index, com.google.cloud.memcache.v1beta2.Instance.Node.Builder builderForValue) {
      if (memcacheNodesBuilder_ == null) {
        ensureMemcacheNodesIsMutable();
        memcacheNodes_.set(index, builderForValue.build());
        onChanged();
      } else {
        memcacheNodesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of Memcached nodes.
     * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMemcacheNodes(com.google.cloud.memcache.v1beta2.Instance.Node value) {
      if (memcacheNodesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMemcacheNodesIsMutable();
        memcacheNodes_.add(value);
        onChanged();
      } else {
        memcacheNodesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of Memcached nodes.
     * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMemcacheNodes(
        int index, com.google.cloud.memcache.v1beta2.Instance.Node value) {
      if (memcacheNodesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMemcacheNodesIsMutable();
        memcacheNodes_.add(index, value);
        onChanged();
      } else {
        memcacheNodesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of Memcached nodes.
     * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMemcacheNodes(
        com.google.cloud.memcache.v1beta2.Instance.Node.Builder builderForValue) {
      if (memcacheNodesBuilder_ == null) {
        ensureMemcacheNodesIsMutable();
        memcacheNodes_.add(builderForValue.build());
        onChanged();
      } else {
        memcacheNodesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of Memcached nodes.
     * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addMemcacheNodes(
        int index, com.google.cloud.memcache.v1beta2.Instance.Node.Builder builderForValue) {
      if (memcacheNodesBuilder_ == null) {
        ensureMemcacheNodesIsMutable();
        memcacheNodes_.add(index, builderForValue.build());
        onChanged();
      } else {
        memcacheNodesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of Memcached nodes.
     * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllMemcacheNodes(
        java.lang.Iterable<? extends com.google.cloud.memcache.v1beta2.Instance.Node> values) {
      if (memcacheNodesBuilder_ == null) {
        ensureMemcacheNodesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, memcacheNodes_);
        onChanged();
      } else {
        memcacheNodesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of Memcached nodes.
     * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMemcacheNodes() {
      if (memcacheNodesBuilder_ == null) {
        memcacheNodes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        memcacheNodesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of Memcached nodes.
     * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeMemcacheNodes(int index) {
      if (memcacheNodesBuilder_ == null) {
        ensureMemcacheNodesIsMutable();
        memcacheNodes_.remove(index);
        onChanged();
      } else {
        memcacheNodesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. List of Memcached nodes.
     * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.memcache.v1beta2.Instance.Node.Builder getMemcacheNodesBuilder(
        int index) {
      return getMemcacheNodesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. List of Memcached nodes.
     * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.memcache.v1beta2.Instance.NodeOrBuilder getMemcacheNodesOrBuilder(
        int index) {
      if (memcacheNodesBuilder_ == null) {
        return memcacheNodes_.get(index);
      } else {
        return memcacheNodesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of Memcached nodes.
     * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.memcache.v1beta2.Instance.NodeOrBuilder>
        getMemcacheNodesOrBuilderList() {
      if (memcacheNodesBuilder_ != null) {
        return memcacheNodesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(memcacheNodes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. List of Memcached nodes.
     * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.memcache.v1beta2.Instance.Node.Builder addMemcacheNodesBuilder() {
      return getMemcacheNodesFieldBuilder()
          .addBuilder(com.google.cloud.memcache.v1beta2.Instance.Node.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. List of Memcached nodes.
     * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.memcache.v1beta2.Instance.Node.Builder addMemcacheNodesBuilder(
        int index) {
      return getMemcacheNodesFieldBuilder()
          .addBuilder(index, com.google.cloud.memcache.v1beta2.Instance.Node.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. List of Memcached nodes.
     * Refer to [Node][google.cloud.memcache.v1beta2.Instance.Node] message for more details.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.Node memcache_nodes = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.memcache.v1beta2.Instance.Node.Builder>
        getMemcacheNodesBuilderList() {
      return getMemcacheNodesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.memcache.v1beta2.Instance.Node,
            com.google.cloud.memcache.v1beta2.Instance.Node.Builder,
            com.google.cloud.memcache.v1beta2.Instance.NodeOrBuilder>
        getMemcacheNodesFieldBuilder() {
      if (memcacheNodesBuilder_ == null) {
        memcacheNodesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.memcache.v1beta2.Instance.Node,
                com.google.cloud.memcache.v1beta2.Instance.Node.Builder,
                com.google.cloud.memcache.v1beta2.Instance.NodeOrBuilder>(
                memcacheNodes_,
                ((bitField0_ & 0x00000200) != 0),
                getParentForChildren(),
                isClean());
        memcacheNodes_ = null;
      }
      return memcacheNodesBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000800);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the instance was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of this Memcached instance.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.Instance.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this Memcached instance.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.Instance.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this Memcached instance.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.Instance.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.memcache.v1beta2.Instance.State getState() {
      com.google.cloud.memcache.v1beta2.Instance.State result =
          com.google.cloud.memcache.v1beta2.Instance.State.forNumber(state_);
      return result == null
          ? com.google.cloud.memcache.v1beta2.Instance.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this Memcached instance.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.Instance.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.memcache.v1beta2.Instance.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00001000;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this Memcached instance.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.Instance.State state = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00001000);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object memcacheFullVersion_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The full version of memcached server running on this instance.
     * System automatically determines the full memcached version for an instance
     * based on the input MemcacheVersion.
     * The full version format will be "memcached-1.5.16".
     * </pre>
     *
     * <code>string memcache_full_version = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The memcacheFullVersion.
     */
    public java.lang.String getMemcacheFullVersion() {
      java.lang.Object ref = memcacheFullVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        memcacheFullVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The full version of memcached server running on this instance.
     * System automatically determines the full memcached version for an instance
     * based on the input MemcacheVersion.
     * The full version format will be "memcached-1.5.16".
     * </pre>
     *
     * <code>string memcache_full_version = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for memcacheFullVersion.
     */
    public com.google.protobuf.ByteString getMemcacheFullVersionBytes() {
      java.lang.Object ref = memcacheFullVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        memcacheFullVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The full version of memcached server running on this instance.
     * System automatically determines the full memcached version for an instance
     * based on the input MemcacheVersion.
     * The full version format will be "memcached-1.5.16".
     * </pre>
     *
     * <code>string memcache_full_version = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The memcacheFullVersion to set.
     * @return This builder for chaining.
     */
    public Builder setMemcacheFullVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      memcacheFullVersion_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The full version of memcached server running on this instance.
     * System automatically determines the full memcached version for an instance
     * based on the input MemcacheVersion.
     * The full version format will be "memcached-1.5.16".
     * </pre>
     *
     * <code>string memcache_full_version = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMemcacheFullVersion() {
      memcacheFullVersion_ = getDefaultInstance().getMemcacheFullVersion();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The full version of memcached server running on this instance.
     * System automatically determines the full memcached version for an instance
     * based on the input MemcacheVersion.
     * The full version format will be "memcached-1.5.16".
     * </pre>
     *
     * <code>string memcache_full_version = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for memcacheFullVersion to set.
     * @return This builder for chaining.
     */
    public Builder setMemcacheFullVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      memcacheFullVersion_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.memcache.v1beta2.Instance.InstanceMessage>
        instanceMessages_ = java.util.Collections.emptyList();

    private void ensureInstanceMessagesIsMutable() {
      if (!((bitField0_ & 0x00004000) != 0)) {
        instanceMessages_ =
            new java.util.ArrayList<com.google.cloud.memcache.v1beta2.Instance.InstanceMessage>(
                instanceMessages_);
        bitField0_ |= 0x00004000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.memcache.v1beta2.Instance.InstanceMessage,
            com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Builder,
            com.google.cloud.memcache.v1beta2.Instance.InstanceMessageOrBuilder>
        instanceMessagesBuilder_;

    /**
     *
     *
     * <pre>
     * List of messages that describe the current state of the Memcached instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
     * </code>
     */
    public java.util.List<com.google.cloud.memcache.v1beta2.Instance.InstanceMessage>
        getInstanceMessagesList() {
      if (instanceMessagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(instanceMessages_);
      } else {
        return instanceMessagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of messages that describe the current state of the Memcached instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
     * </code>
     */
    public int getInstanceMessagesCount() {
      if (instanceMessagesBuilder_ == null) {
        return instanceMessages_.size();
      } else {
        return instanceMessagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of messages that describe the current state of the Memcached instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
     * </code>
     */
    public com.google.cloud.memcache.v1beta2.Instance.InstanceMessage getInstanceMessages(
        int index) {
      if (instanceMessagesBuilder_ == null) {
        return instanceMessages_.get(index);
      } else {
        return instanceMessagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of messages that describe the current state of the Memcached instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
     * </code>
     */
    public Builder setInstanceMessages(
        int index, com.google.cloud.memcache.v1beta2.Instance.InstanceMessage value) {
      if (instanceMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstanceMessagesIsMutable();
        instanceMessages_.set(index, value);
        onChanged();
      } else {
        instanceMessagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of messages that describe the current state of the Memcached instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
     * </code>
     */
    public Builder setInstanceMessages(
        int index,
        com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Builder builderForValue) {
      if (instanceMessagesBuilder_ == null) {
        ensureInstanceMessagesIsMutable();
        instanceMessages_.set(index, builderForValue.build());
        onChanged();
      } else {
        instanceMessagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of messages that describe the current state of the Memcached instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
     * </code>
     */
    public Builder addInstanceMessages(
        com.google.cloud.memcache.v1beta2.Instance.InstanceMessage value) {
      if (instanceMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstanceMessagesIsMutable();
        instanceMessages_.add(value);
        onChanged();
      } else {
        instanceMessagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of messages that describe the current state of the Memcached instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
     * </code>
     */
    public Builder addInstanceMessages(
        int index, com.google.cloud.memcache.v1beta2.Instance.InstanceMessage value) {
      if (instanceMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstanceMessagesIsMutable();
        instanceMessages_.add(index, value);
        onChanged();
      } else {
        instanceMessagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of messages that describe the current state of the Memcached instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
     * </code>
     */
    public Builder addInstanceMessages(
        com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Builder builderForValue) {
      if (instanceMessagesBuilder_ == null) {
        ensureInstanceMessagesIsMutable();
        instanceMessages_.add(builderForValue.build());
        onChanged();
      } else {
        instanceMessagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of messages that describe the current state of the Memcached instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
     * </code>
     */
    public Builder addInstanceMessages(
        int index,
        com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Builder builderForValue) {
      if (instanceMessagesBuilder_ == null) {
        ensureInstanceMessagesIsMutable();
        instanceMessages_.add(index, builderForValue.build());
        onChanged();
      } else {
        instanceMessagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of messages that describe the current state of the Memcached instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
     * </code>
     */
    public Builder addAllInstanceMessages(
        java.lang.Iterable<? extends com.google.cloud.memcache.v1beta2.Instance.InstanceMessage>
            values) {
      if (instanceMessagesBuilder_ == null) {
        ensureInstanceMessagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instanceMessages_);
        onChanged();
      } else {
        instanceMessagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of messages that describe the current state of the Memcached instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
     * </code>
     */
    public Builder clearInstanceMessages() {
      if (instanceMessagesBuilder_ == null) {
        instanceMessages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00004000);
        onChanged();
      } else {
        instanceMessagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of messages that describe the current state of the Memcached instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
     * </code>
     */
    public Builder removeInstanceMessages(int index) {
      if (instanceMessagesBuilder_ == null) {
        ensureInstanceMessagesIsMutable();
        instanceMessages_.remove(index);
        onChanged();
      } else {
        instanceMessagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of messages that describe the current state of the Memcached instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
     * </code>
     */
    public com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Builder
        getInstanceMessagesBuilder(int index) {
      return getInstanceMessagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of messages that describe the current state of the Memcached instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
     * </code>
     */
    public com.google.cloud.memcache.v1beta2.Instance.InstanceMessageOrBuilder
        getInstanceMessagesOrBuilder(int index) {
      if (instanceMessagesBuilder_ == null) {
        return instanceMessages_.get(index);
      } else {
        return instanceMessagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of messages that describe the current state of the Memcached instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.memcache.v1beta2.Instance.InstanceMessageOrBuilder>
        getInstanceMessagesOrBuilderList() {
      if (instanceMessagesBuilder_ != null) {
        return instanceMessagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(instanceMessages_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of messages that describe the current state of the Memcached instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
     * </code>
     */
    public com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Builder
        addInstanceMessagesBuilder() {
      return getInstanceMessagesFieldBuilder()
          .addBuilder(
              com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of messages that describe the current state of the Memcached instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
     * </code>
     */
    public com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Builder
        addInstanceMessagesBuilder(int index) {
      return getInstanceMessagesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of messages that describe the current state of the Memcached instance.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.memcache.v1beta2.Instance.InstanceMessage instance_messages = 19;
     * </code>
     */
    public java.util.List<com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Builder>
        getInstanceMessagesBuilderList() {
      return getInstanceMessagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.memcache.v1beta2.Instance.InstanceMessage,
            com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Builder,
            com.google.cloud.memcache.v1beta2.Instance.InstanceMessageOrBuilder>
        getInstanceMessagesFieldBuilder() {
      if (instanceMessagesBuilder_ == null) {
        instanceMessagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.memcache.v1beta2.Instance.InstanceMessage,
                com.google.cloud.memcache.v1beta2.Instance.InstanceMessage.Builder,
                com.google.cloud.memcache.v1beta2.Instance.InstanceMessageOrBuilder>(
                instanceMessages_,
                ((bitField0_ & 0x00004000) != 0),
                getParentForChildren(),
                isClean());
        instanceMessages_ = null;
      }
      return instanceMessagesBuilder_;
    }

    private java.lang.Object discoveryEndpoint_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Endpoint for the Discovery API.
     * </pre>
     *
     * <code>string discovery_endpoint = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The discoveryEndpoint.
     */
    public java.lang.String getDiscoveryEndpoint() {
      java.lang.Object ref = discoveryEndpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        discoveryEndpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Endpoint for the Discovery API.
     * </pre>
     *
     * <code>string discovery_endpoint = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for discoveryEndpoint.
     */
    public com.google.protobuf.ByteString getDiscoveryEndpointBytes() {
      java.lang.Object ref = discoveryEndpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        discoveryEndpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Endpoint for the Discovery API.
     * </pre>
     *
     * <code>string discovery_endpoint = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The discoveryEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setDiscoveryEndpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      discoveryEndpoint_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Endpoint for the Discovery API.
     * </pre>
     *
     * <code>string discovery_endpoint = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiscoveryEndpoint() {
      discoveryEndpoint_ = getDefaultInstance().getDiscoveryEndpoint();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Endpoint for the Discovery API.
     * </pre>
     *
     * <code>string discovery_endpoint = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for discoveryEndpoint to set.
     * @return This builder for chaining.
     */
    public Builder setDiscoveryEndpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      discoveryEndpoint_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private boolean updateAvailable_;
    /**
     *
     *
     * <pre>
     * Output only. Returns true if there is an update waiting to be applied
     * </pre>
     *
     * <code>bool update_available = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The updateAvailable.
     */
    @java.lang.Override
    public boolean getUpdateAvailable() {
      return updateAvailable_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Returns true if there is an update waiting to be applied
     * </pre>
     *
     * <code>bool update_available = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The updateAvailable to set.
     * @return This builder for chaining.
     */
    public Builder setUpdateAvailable(boolean value) {

      updateAvailable_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Returns true if there is an update waiting to be applied
     * </pre>
     *
     * <code>bool update_available = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUpdateAvailable() {
      bitField0_ = (bitField0_ & ~0x00010000);
      updateAvailable_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.memcache.v1beta2.MaintenancePolicy maintenancePolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.memcache.v1beta2.MaintenancePolicy,
            com.google.cloud.memcache.v1beta2.MaintenancePolicy.Builder,
            com.google.cloud.memcache.v1beta2.MaintenancePolicyOrBuilder>
        maintenancePolicyBuilder_;
    /**
     *
     *
     * <pre>
     * The maintenance policy for the instance. If not provided,
     * the maintenance event will be performed based on Memorystore
     * internal rollout schedule.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MaintenancePolicy maintenance_policy = 22;</code>
     *
     * @return Whether the maintenancePolicy field is set.
     */
    public boolean hasMaintenancePolicy() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The maintenance policy for the instance. If not provided,
     * the maintenance event will be performed based on Memorystore
     * internal rollout schedule.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MaintenancePolicy maintenance_policy = 22;</code>
     *
     * @return The maintenancePolicy.
     */
    public com.google.cloud.memcache.v1beta2.MaintenancePolicy getMaintenancePolicy() {
      if (maintenancePolicyBuilder_ == null) {
        return maintenancePolicy_ == null
            ? com.google.cloud.memcache.v1beta2.MaintenancePolicy.getDefaultInstance()
            : maintenancePolicy_;
      } else {
        return maintenancePolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The maintenance policy for the instance. If not provided,
     * the maintenance event will be performed based on Memorystore
     * internal rollout schedule.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MaintenancePolicy maintenance_policy = 22;</code>
     */
    public Builder setMaintenancePolicy(com.google.cloud.memcache.v1beta2.MaintenancePolicy value) {
      if (maintenancePolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maintenancePolicy_ = value;
      } else {
        maintenancePolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maintenance policy for the instance. If not provided,
     * the maintenance event will be performed based on Memorystore
     * internal rollout schedule.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MaintenancePolicy maintenance_policy = 22;</code>
     */
    public Builder setMaintenancePolicy(
        com.google.cloud.memcache.v1beta2.MaintenancePolicy.Builder builderForValue) {
      if (maintenancePolicyBuilder_ == null) {
        maintenancePolicy_ = builderForValue.build();
      } else {
        maintenancePolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maintenance policy for the instance. If not provided,
     * the maintenance event will be performed based on Memorystore
     * internal rollout schedule.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MaintenancePolicy maintenance_policy = 22;</code>
     */
    public Builder mergeMaintenancePolicy(
        com.google.cloud.memcache.v1beta2.MaintenancePolicy value) {
      if (maintenancePolicyBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && maintenancePolicy_ != null
            && maintenancePolicy_
                != com.google.cloud.memcache.v1beta2.MaintenancePolicy.getDefaultInstance()) {
          getMaintenancePolicyBuilder().mergeFrom(value);
        } else {
          maintenancePolicy_ = value;
        }
      } else {
        maintenancePolicyBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maintenance policy for the instance. If not provided,
     * the maintenance event will be performed based on Memorystore
     * internal rollout schedule.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MaintenancePolicy maintenance_policy = 22;</code>
     */
    public Builder clearMaintenancePolicy() {
      bitField0_ = (bitField0_ & ~0x00020000);
      maintenancePolicy_ = null;
      if (maintenancePolicyBuilder_ != null) {
        maintenancePolicyBuilder_.dispose();
        maintenancePolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maintenance policy for the instance. If not provided,
     * the maintenance event will be performed based on Memorystore
     * internal rollout schedule.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MaintenancePolicy maintenance_policy = 22;</code>
     */
    public com.google.cloud.memcache.v1beta2.MaintenancePolicy.Builder
        getMaintenancePolicyBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getMaintenancePolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The maintenance policy for the instance. If not provided,
     * the maintenance event will be performed based on Memorystore
     * internal rollout schedule.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MaintenancePolicy maintenance_policy = 22;</code>
     */
    public com.google.cloud.memcache.v1beta2.MaintenancePolicyOrBuilder
        getMaintenancePolicyOrBuilder() {
      if (maintenancePolicyBuilder_ != null) {
        return maintenancePolicyBuilder_.getMessageOrBuilder();
      } else {
        return maintenancePolicy_ == null
            ? com.google.cloud.memcache.v1beta2.MaintenancePolicy.getDefaultInstance()
            : maintenancePolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * The maintenance policy for the instance. If not provided,
     * the maintenance event will be performed based on Memorystore
     * internal rollout schedule.
     * </pre>
     *
     * <code>.google.cloud.memcache.v1beta2.MaintenancePolicy maintenance_policy = 22;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.memcache.v1beta2.MaintenancePolicy,
            com.google.cloud.memcache.v1beta2.MaintenancePolicy.Builder,
            com.google.cloud.memcache.v1beta2.MaintenancePolicyOrBuilder>
        getMaintenancePolicyFieldBuilder() {
      if (maintenancePolicyBuilder_ == null) {
        maintenancePolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.memcache.v1beta2.MaintenancePolicy,
                com.google.cloud.memcache.v1beta2.MaintenancePolicy.Builder,
                com.google.cloud.memcache.v1beta2.MaintenancePolicyOrBuilder>(
                getMaintenancePolicy(), getParentForChildren(), isClean());
        maintenancePolicy_ = null;
      }
      return maintenancePolicyBuilder_;
    }

    private com.google.cloud.memcache.v1beta2.MaintenanceSchedule maintenanceSchedule_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.memcache.v1beta2.MaintenanceSchedule,
            com.google.cloud.memcache.v1beta2.MaintenanceSchedule.Builder,
            com.google.cloud.memcache.v1beta2.MaintenanceScheduleOrBuilder>
        maintenanceScheduleBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Published maintenance schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.MaintenanceSchedule maintenance_schedule = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the maintenanceSchedule field is set.
     */
    public boolean hasMaintenanceSchedule() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Published maintenance schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.MaintenanceSchedule maintenance_schedule = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The maintenanceSchedule.
     */
    public com.google.cloud.memcache.v1beta2.MaintenanceSchedule getMaintenanceSchedule() {
      if (maintenanceScheduleBuilder_ == null) {
        return maintenanceSchedule_ == null
            ? com.google.cloud.memcache.v1beta2.MaintenanceSchedule.getDefaultInstance()
            : maintenanceSchedule_;
      } else {
        return maintenanceScheduleBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Published maintenance schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.MaintenanceSchedule maintenance_schedule = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMaintenanceSchedule(
        com.google.cloud.memcache.v1beta2.MaintenanceSchedule value) {
      if (maintenanceScheduleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maintenanceSchedule_ = value;
      } else {
        maintenanceScheduleBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Published maintenance schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.MaintenanceSchedule maintenance_schedule = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMaintenanceSchedule(
        com.google.cloud.memcache.v1beta2.MaintenanceSchedule.Builder builderForValue) {
      if (maintenanceScheduleBuilder_ == null) {
        maintenanceSchedule_ = builderForValue.build();
      } else {
        maintenanceScheduleBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Published maintenance schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.MaintenanceSchedule maintenance_schedule = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMaintenanceSchedule(
        com.google.cloud.memcache.v1beta2.MaintenanceSchedule value) {
      if (maintenanceScheduleBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && maintenanceSchedule_ != null
            && maintenanceSchedule_
                != com.google.cloud.memcache.v1beta2.MaintenanceSchedule.getDefaultInstance()) {
          getMaintenanceScheduleBuilder().mergeFrom(value);
        } else {
          maintenanceSchedule_ = value;
        }
      } else {
        maintenanceScheduleBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Published maintenance schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.MaintenanceSchedule maintenance_schedule = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMaintenanceSchedule() {
      bitField0_ = (bitField0_ & ~0x00040000);
      maintenanceSchedule_ = null;
      if (maintenanceScheduleBuilder_ != null) {
        maintenanceScheduleBuilder_.dispose();
        maintenanceScheduleBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Published maintenance schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.MaintenanceSchedule maintenance_schedule = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.memcache.v1beta2.MaintenanceSchedule.Builder
        getMaintenanceScheduleBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getMaintenanceScheduleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Published maintenance schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.MaintenanceSchedule maintenance_schedule = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.memcache.v1beta2.MaintenanceScheduleOrBuilder
        getMaintenanceScheduleOrBuilder() {
      if (maintenanceScheduleBuilder_ != null) {
        return maintenanceScheduleBuilder_.getMessageOrBuilder();
      } else {
        return maintenanceSchedule_ == null
            ? com.google.cloud.memcache.v1beta2.MaintenanceSchedule.getDefaultInstance()
            : maintenanceSchedule_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Published maintenance schedule.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.MaintenanceSchedule maintenance_schedule = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.memcache.v1beta2.MaintenanceSchedule,
            com.google.cloud.memcache.v1beta2.MaintenanceSchedule.Builder,
            com.google.cloud.memcache.v1beta2.MaintenanceScheduleOrBuilder>
        getMaintenanceScheduleFieldBuilder() {
      if (maintenanceScheduleBuilder_ == null) {
        maintenanceScheduleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.memcache.v1beta2.MaintenanceSchedule,
                com.google.cloud.memcache.v1beta2.MaintenanceSchedule.Builder,
                com.google.cloud.memcache.v1beta2.MaintenanceScheduleOrBuilder>(
                getMaintenanceSchedule(), getParentForChildren(), isClean());
        maintenanceSchedule_ = null;
      }
      return maintenanceScheduleBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.memcache.v1beta2.Instance)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.memcache.v1beta2.Instance)
  private static final com.google.cloud.memcache.v1beta2.Instance DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.memcache.v1beta2.Instance();
  }

  public static com.google.cloud.memcache.v1beta2.Instance getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Instance> PARSER =
      new com.google.protobuf.AbstractParser<Instance>() {
        @java.lang.Override
        public Instance parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Instance> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Instance> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.memcache.v1beta2.Instance getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
