/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/memcache/v1beta2/cloud_memcache.proto

package com.google.cloud.memcache.v1beta2;

/**
 *
 *
 * <pre>
 * Request for [RescheduleMaintenance][google.cloud.memcache.v1beta2.CloudMemcache.RescheduleMaintenance].
 * </pre>
 *
 * Protobuf type {@code google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest}
 */
public final class RescheduleMaintenanceRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest)
    RescheduleMaintenanceRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RescheduleMaintenanceRequest.newBuilder() to construct.
  private RescheduleMaintenanceRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RescheduleMaintenanceRequest() {
    instance_ = "";
    rescheduleType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RescheduleMaintenanceRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
        .internal_static_google_cloud_memcache_v1beta2_RescheduleMaintenanceRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
        .internal_static_google_cloud_memcache_v1beta2_RescheduleMaintenanceRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.class,
            com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Reschedule options.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType}
   */
  public enum RescheduleType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>RESCHEDULE_TYPE_UNSPECIFIED = 0;</code>
     */
    RESCHEDULE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * If the user wants to schedule the maintenance to happen now.
     * </pre>
     *
     * <code>IMMEDIATE = 1;</code>
     */
    IMMEDIATE(1),
    /**
     *
     *
     * <pre>
     * If the user wants to use the existing maintenance policy to find the
     * next available window.
     * </pre>
     *
     * <code>NEXT_AVAILABLE_WINDOW = 2;</code>
     */
    NEXT_AVAILABLE_WINDOW(2),
    /**
     *
     *
     * <pre>
     * If the user wants to reschedule the maintenance to a specific time.
     * </pre>
     *
     * <code>SPECIFIC_TIME = 3;</code>
     */
    SPECIFIC_TIME(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>RESCHEDULE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int RESCHEDULE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * If the user wants to schedule the maintenance to happen now.
     * </pre>
     *
     * <code>IMMEDIATE = 1;</code>
     */
    public static final int IMMEDIATE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * If the user wants to use the existing maintenance policy to find the
     * next available window.
     * </pre>
     *
     * <code>NEXT_AVAILABLE_WINDOW = 2;</code>
     */
    public static final int NEXT_AVAILABLE_WINDOW_VALUE = 2;
    /**
     *
     *
     * <pre>
     * If the user wants to reschedule the maintenance to a specific time.
     * </pre>
     *
     * <code>SPECIFIC_TIME = 3;</code>
     */
    public static final int SPECIFIC_TIME_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RescheduleType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RescheduleType forNumber(int value) {
      switch (value) {
        case 0:
          return RESCHEDULE_TYPE_UNSPECIFIED;
        case 1:
          return IMMEDIATE;
        case 2:
          return NEXT_AVAILABLE_WINDOW;
        case 3:
          return SPECIFIC_TIME;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RescheduleType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RescheduleType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RescheduleType>() {
          public RescheduleType findValueByNumber(int number) {
            return RescheduleType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final RescheduleType[] VALUES = values();

    public static RescheduleType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RescheduleType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType)
  }

  public static final int INSTANCE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instance_ = "";
  /**
   *
   *
   * <pre>
   * Required. Memcache instance resource name using the form:
   *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
   * where `location_id` refers to a GCP region.
   * </pre>
   *
   * <code>
   * string instance = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The instance.
   */
  @java.lang.Override
  public java.lang.String getInstance() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instance_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Memcache instance resource name using the form:
   *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
   * where `location_id` refers to a GCP region.
   * </pre>
   *
   * <code>
   * string instance = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for instance.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceBytes() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESCHEDULE_TYPE_FIELD_NUMBER = 2;
  private int rescheduleType_ = 0;
  /**
   *
   *
   * <pre>
   * Required. If reschedule type is SPECIFIC_TIME, must set up schedule_time as well.
   * </pre>
   *
   * <code>
   * .google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType reschedule_type = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for rescheduleType.
   */
  @java.lang.Override
  public int getRescheduleTypeValue() {
    return rescheduleType_;
  }
  /**
   *
   *
   * <pre>
   * Required. If reschedule type is SPECIFIC_TIME, must set up schedule_time as well.
   * </pre>
   *
   * <code>
   * .google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType reschedule_type = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The rescheduleType.
   */
  @java.lang.Override
  public com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType
      getRescheduleType() {
    com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType result =
        com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType.forNumber(
            rescheduleType_);
    return result == null
        ? com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType.UNRECOGNIZED
        : result;
  }

  public static final int SCHEDULE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp scheduleTime_;
  /**
   *
   *
   * <pre>
   * Timestamp when the maintenance shall be rescheduled to if
   * reschedule_type=SPECIFIC_TIME, in RFC 3339 format, for
   * example `2012-11-15T16:19:00.094Z`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
   *
   * @return Whether the scheduleTime field is set.
   */
  @java.lang.Override
  public boolean hasScheduleTime() {
    return scheduleTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Timestamp when the maintenance shall be rescheduled to if
   * reschedule_type=SPECIFIC_TIME, in RFC 3339 format, for
   * example `2012-11-15T16:19:00.094Z`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
   *
   * @return The scheduleTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getScheduleTime() {
    return scheduleTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : scheduleTime_;
  }
  /**
   *
   *
   * <pre>
   * Timestamp when the maintenance shall be rescheduled to if
   * reschedule_type=SPECIFIC_TIME, in RFC 3339 format, for
   * example `2012-11-15T16:19:00.094Z`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getScheduleTimeOrBuilder() {
    return scheduleTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : scheduleTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instance_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, instance_);
    }
    if (rescheduleType_
        != com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType
            .RESCHEDULE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, rescheduleType_);
    }
    if (scheduleTime_ != null) {
      output.writeMessage(3, getScheduleTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instance_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, instance_);
    }
    if (rescheduleType_
        != com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType
            .RESCHEDULE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, rescheduleType_);
    }
    if (scheduleTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getScheduleTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest other =
        (com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest) obj;

    if (!getInstance().equals(other.getInstance())) return false;
    if (rescheduleType_ != other.rescheduleType_) return false;
    if (hasScheduleTime() != other.hasScheduleTime()) return false;
    if (hasScheduleTime()) {
      if (!getScheduleTime().equals(other.getScheduleTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INSTANCE_FIELD_NUMBER;
    hash = (53 * hash) + getInstance().hashCode();
    hash = (37 * hash) + RESCHEDULE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + rescheduleType_;
    if (hasScheduleTime()) {
      hash = (37 * hash) + SCHEDULE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getScheduleTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request for [RescheduleMaintenance][google.cloud.memcache.v1beta2.CloudMemcache.RescheduleMaintenance].
   * </pre>
   *
   * Protobuf type {@code google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest)
      com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
          .internal_static_google_cloud_memcache_v1beta2_RescheduleMaintenanceRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
          .internal_static_google_cloud_memcache_v1beta2_RescheduleMaintenanceRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.class,
              com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.Builder.class);
    }

    // Construct using com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      instance_ = "";
      rescheduleType_ = 0;
      scheduleTime_ = null;
      if (scheduleTimeBuilder_ != null) {
        scheduleTimeBuilder_.dispose();
        scheduleTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.memcache.v1beta2.CloudMemcacheProto
          .internal_static_google_cloud_memcache_v1beta2_RescheduleMaintenanceRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest
        getDefaultInstanceForType() {
      return com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest build() {
      com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest buildPartial() {
      com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest result =
          new com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.instance_ = instance_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.rescheduleType_ = rescheduleType_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.scheduleTime_ =
            scheduleTimeBuilder_ == null ? scheduleTime_ : scheduleTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest) {
        return mergeFrom((com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest other) {
      if (other
          == com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.getDefaultInstance())
        return this;
      if (!other.getInstance().isEmpty()) {
        instance_ = other.instance_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.rescheduleType_ != 0) {
        setRescheduleTypeValue(other.getRescheduleTypeValue());
      }
      if (other.hasScheduleTime()) {
        mergeScheduleTime(other.getScheduleTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                instance_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                rescheduleType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getScheduleTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object instance_ = "";
    /**
     *
     *
     * <pre>
     * Required. Memcache instance resource name using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     * where `location_id` refers to a GCP region.
     * </pre>
     *
     * <code>
     * string instance = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The instance.
     */
    public java.lang.String getInstance() {
      java.lang.Object ref = instance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Memcache instance resource name using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     * where `location_id` refers to a GCP region.
     * </pre>
     *
     * <code>
     * string instance = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for instance.
     */
    public com.google.protobuf.ByteString getInstanceBytes() {
      java.lang.Object ref = instance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Memcache instance resource name using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     * where `location_id` refers to a GCP region.
     * </pre>
     *
     * <code>
     * string instance = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instance_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Memcache instance resource name using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     * where `location_id` refers to a GCP region.
     * </pre>
     *
     * <code>
     * string instance = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstance() {
      instance_ = getDefaultInstance().getInstance();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Memcache instance resource name using the form:
     *     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
     * where `location_id` refers to a GCP region.
     * </pre>
     *
     * <code>
     * string instance = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instance_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int rescheduleType_ = 0;
    /**
     *
     *
     * <pre>
     * Required. If reschedule type is SPECIFIC_TIME, must set up schedule_time as well.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType reschedule_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for rescheduleType.
     */
    @java.lang.Override
    public int getRescheduleTypeValue() {
      return rescheduleType_;
    }
    /**
     *
     *
     * <pre>
     * Required. If reschedule type is SPECIFIC_TIME, must set up schedule_time as well.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType reschedule_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for rescheduleType to set.
     * @return This builder for chaining.
     */
    public Builder setRescheduleTypeValue(int value) {
      rescheduleType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. If reschedule type is SPECIFIC_TIME, must set up schedule_time as well.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType reschedule_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The rescheduleType.
     */
    @java.lang.Override
    public com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType
        getRescheduleType() {
      com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType result =
          com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType.forNumber(
              rescheduleType_);
      return result == null
          ? com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. If reschedule type is SPECIFIC_TIME, must set up schedule_time as well.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType reschedule_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The rescheduleType to set.
     * @return This builder for chaining.
     */
    public Builder setRescheduleType(
        com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      rescheduleType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. If reschedule type is SPECIFIC_TIME, must set up schedule_time as well.
     * </pre>
     *
     * <code>
     * .google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest.RescheduleType reschedule_type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRescheduleType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      rescheduleType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp scheduleTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        scheduleTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Timestamp when the maintenance shall be rescheduled to if
     * reschedule_type=SPECIFIC_TIME, in RFC 3339 format, for
     * example `2012-11-15T16:19:00.094Z`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
     *
     * @return Whether the scheduleTime field is set.
     */
    public boolean hasScheduleTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Timestamp when the maintenance shall be rescheduled to if
     * reschedule_type=SPECIFIC_TIME, in RFC 3339 format, for
     * example `2012-11-15T16:19:00.094Z`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
     *
     * @return The scheduleTime.
     */
    public com.google.protobuf.Timestamp getScheduleTime() {
      if (scheduleTimeBuilder_ == null) {
        return scheduleTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : scheduleTime_;
      } else {
        return scheduleTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamp when the maintenance shall be rescheduled to if
     * reschedule_type=SPECIFIC_TIME, in RFC 3339 format, for
     * example `2012-11-15T16:19:00.094Z`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
     */
    public Builder setScheduleTime(com.google.protobuf.Timestamp value) {
      if (scheduleTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scheduleTime_ = value;
      } else {
        scheduleTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp when the maintenance shall be rescheduled to if
     * reschedule_type=SPECIFIC_TIME, in RFC 3339 format, for
     * example `2012-11-15T16:19:00.094Z`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
     */
    public Builder setScheduleTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (scheduleTimeBuilder_ == null) {
        scheduleTime_ = builderForValue.build();
      } else {
        scheduleTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp when the maintenance shall be rescheduled to if
     * reschedule_type=SPECIFIC_TIME, in RFC 3339 format, for
     * example `2012-11-15T16:19:00.094Z`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
     */
    public Builder mergeScheduleTime(com.google.protobuf.Timestamp value) {
      if (scheduleTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && scheduleTime_ != null
            && scheduleTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getScheduleTimeBuilder().mergeFrom(value);
        } else {
          scheduleTime_ = value;
        }
      } else {
        scheduleTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp when the maintenance shall be rescheduled to if
     * reschedule_type=SPECIFIC_TIME, in RFC 3339 format, for
     * example `2012-11-15T16:19:00.094Z`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
     */
    public Builder clearScheduleTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      scheduleTime_ = null;
      if (scheduleTimeBuilder_ != null) {
        scheduleTimeBuilder_.dispose();
        scheduleTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Timestamp when the maintenance shall be rescheduled to if
     * reschedule_type=SPECIFIC_TIME, in RFC 3339 format, for
     * example `2012-11-15T16:19:00.094Z`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getScheduleTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getScheduleTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Timestamp when the maintenance shall be rescheduled to if
     * reschedule_type=SPECIFIC_TIME, in RFC 3339 format, for
     * example `2012-11-15T16:19:00.094Z`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getScheduleTimeOrBuilder() {
      if (scheduleTimeBuilder_ != null) {
        return scheduleTimeBuilder_.getMessageOrBuilder();
      } else {
        return scheduleTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : scheduleTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Timestamp when the maintenance shall be rescheduled to if
     * reschedule_type=SPECIFIC_TIME, in RFC 3339 format, for
     * example `2012-11-15T16:19:00.094Z`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getScheduleTimeFieldBuilder() {
      if (scheduleTimeBuilder_ == null) {
        scheduleTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getScheduleTime(), getParentForChildren(), isClean());
        scheduleTime_ = null;
      }
      return scheduleTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest)
  private static final com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest();
  }

  public static com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RescheduleMaintenanceRequest> PARSER =
      new com.google.protobuf.AbstractParser<RescheduleMaintenanceRequest>() {
        @java.lang.Override
        public RescheduleMaintenanceRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RescheduleMaintenanceRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RescheduleMaintenanceRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.memcache.v1beta2.RescheduleMaintenanceRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
