/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * A request to add assets to a group.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.AddAssetsToGroupRequest}
 */
public final class AddAssetsToGroupRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.AddAssetsToGroupRequest)
    AddAssetsToGroupRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AddAssetsToGroupRequest.newBuilder() to construct.
  private AddAssetsToGroupRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AddAssetsToGroupRequest() {
    group_ = "";
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AddAssetsToGroupRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_AddAssetsToGroupRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_AddAssetsToGroupRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest.class,
            com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest.Builder.class);
  }

  public static final int GROUP_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object group_ = "";
  /**
   *
   *
   * <pre>
   * Required. Group reference.
   * </pre>
   *
   * <code>
   * string group = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The group.
   */
  @java.lang.Override
  public java.lang.String getGroup() {
    java.lang.Object ref = group_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      group_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Group reference.
   * </pre>
   *
   * <code>
   * string group = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for group.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGroupBytes() {
    java.lang.Object ref = group_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      group_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. An optional request ID to identify requests. Specify a unique
   * request ID so that if you must retry your request, the server will know to
   * ignore the request if it has already been completed. The server will
   * guarantee that for at least 60 minutes after the first request.
   *
   * For example, consider a situation where you make an initial request and
   * the request times out. If you make the request again with the same request
   * ID, the server can check if original operation with the same request ID
   * was received, and if so, will ignore the second request. This prevents
   * clients from accidentally creating duplicate commitments.
   *
   * The request ID must be a valid UUID with the exception that zero UUID is
   * not supported (00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional request ID to identify requests. Specify a unique
   * request ID so that if you must retry your request, the server will know to
   * ignore the request if it has already been completed. The server will
   * guarantee that for at least 60 minutes after the first request.
   *
   * For example, consider a situation where you make an initial request and
   * the request times out. If you make the request again with the same request
   * ID, the server can check if original operation with the same request ID
   * was received, and if so, will ignore the second request. This prevents
   * clients from accidentally creating duplicate commitments.
   *
   * The request ID must be a valid UUID with the exception that zero UUID is
   * not supported (00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ASSETS_FIELD_NUMBER = 3;
  private com.google.cloud.migrationcenter.v1.AssetList assets_;
  /**
   *
   *
   * <pre>
   * Required. List of assets to be added.
   * The maximum number of assets that can be added in a single request is
   * 1000.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.AssetList assets = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the assets field is set.
   */
  @java.lang.Override
  public boolean hasAssets() {
    return assets_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. List of assets to be added.
   * The maximum number of assets that can be added in a single request is
   * 1000.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.AssetList assets = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The assets.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AssetList getAssets() {
    return assets_ == null
        ? com.google.cloud.migrationcenter.v1.AssetList.getDefaultInstance()
        : assets_;
  }
  /**
   *
   *
   * <pre>
   * Required. List of assets to be added.
   * The maximum number of assets that can be added in a single request is
   * 1000.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.AssetList assets = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AssetListOrBuilder getAssetsOrBuilder() {
    return assets_ == null
        ? com.google.cloud.migrationcenter.v1.AssetList.getDefaultInstance()
        : assets_;
  }

  public static final int ALLOW_EXISTING_FIELD_NUMBER = 4;
  private boolean allowExisting_ = false;
  /**
   *
   *
   * <pre>
   * Optional. When this value is set to `false` and one of the given assets is
   * already an existing member of the group, the operation fails with an
   * `Already Exists` error. When set to `true` this situation is silently
   * ignored by the server.
   *
   * Default value is `false`.
   * </pre>
   *
   * <code>bool allow_existing = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The allowExisting.
   */
  @java.lang.Override
  public boolean getAllowExisting() {
    return allowExisting_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(group_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, group_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, requestId_);
    }
    if (assets_ != null) {
      output.writeMessage(3, getAssets());
    }
    if (allowExisting_ != false) {
      output.writeBool(4, allowExisting_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(group_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, group_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, requestId_);
    }
    if (assets_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAssets());
    }
    if (allowExisting_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, allowExisting_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest other =
        (com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest) obj;

    if (!getGroup().equals(other.getGroup())) return false;
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (hasAssets() != other.hasAssets()) return false;
    if (hasAssets()) {
      if (!getAssets().equals(other.getAssets())) return false;
    }
    if (getAllowExisting() != other.getAllowExisting()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + GROUP_FIELD_NUMBER;
    hash = (53 * hash) + getGroup().hashCode();
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    if (hasAssets()) {
      hash = (37 * hash) + ASSETS_FIELD_NUMBER;
      hash = (53 * hash) + getAssets().hashCode();
    }
    hash = (37 * hash) + ALLOW_EXISTING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowExisting());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request to add assets to a group.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.AddAssetsToGroupRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.AddAssetsToGroupRequest)
      com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AddAssetsToGroupRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AddAssetsToGroupRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest.class,
              com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      group_ = "";
      requestId_ = "";
      assets_ = null;
      if (assetsBuilder_ != null) {
        assetsBuilder_.dispose();
        assetsBuilder_ = null;
      }
      allowExisting_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AddAssetsToGroupRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest build() {
      com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest buildPartial() {
      com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest result =
          new com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.group_ = group_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.requestId_ = requestId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.assets_ = assetsBuilder_ == null ? assets_ : assetsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.allowExisting_ = allowExisting_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest other) {
      if (other == com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest.getDefaultInstance())
        return this;
      if (!other.getGroup().isEmpty()) {
        group_ = other.group_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasAssets()) {
        mergeAssets(other.getAssets());
      }
      if (other.getAllowExisting() != false) {
        setAllowExisting(other.getAllowExisting());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                group_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getAssetsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                allowExisting_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object group_ = "";
    /**
     *
     *
     * <pre>
     * Required. Group reference.
     * </pre>
     *
     * <code>
     * string group = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The group.
     */
    public java.lang.String getGroup() {
      java.lang.Object ref = group_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        group_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Group reference.
     * </pre>
     *
     * <code>
     * string group = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for group.
     */
    public com.google.protobuf.ByteString getGroupBytes() {
      java.lang.Object ref = group_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        group_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Group reference.
     * </pre>
     *
     * <code>
     * string group = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The group to set.
     * @return This builder for chaining.
     */
    public Builder setGroup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      group_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Group reference.
     * </pre>
     *
     * <code>
     * string group = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGroup() {
      group_ = getDefaultInstance().getGroup();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Group reference.
     * </pre>
     *
     * <code>
     * string group = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for group to set.
     * @return This builder for chaining.
     */
    public Builder setGroupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      group_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes after the first request.
     *
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes after the first request.
     *
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes after the first request.
     *
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes after the first request.
     *
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes after the first request.
     *
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.migrationcenter.v1.AssetList assets_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.AssetList,
            com.google.cloud.migrationcenter.v1.AssetList.Builder,
            com.google.cloud.migrationcenter.v1.AssetListOrBuilder>
        assetsBuilder_;
    /**
     *
     *
     * <pre>
     * Required. List of assets to be added.
     * The maximum number of assets that can be added in a single request is
     * 1000.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetList assets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the assets field is set.
     */
    public boolean hasAssets() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. List of assets to be added.
     * The maximum number of assets that can be added in a single request is
     * 1000.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetList assets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The assets.
     */
    public com.google.cloud.migrationcenter.v1.AssetList getAssets() {
      if (assetsBuilder_ == null) {
        return assets_ == null
            ? com.google.cloud.migrationcenter.v1.AssetList.getDefaultInstance()
            : assets_;
      } else {
        return assetsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. List of assets to be added.
     * The maximum number of assets that can be added in a single request is
     * 1000.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetList assets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAssets(com.google.cloud.migrationcenter.v1.AssetList value) {
      if (assetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        assets_ = value;
      } else {
        assetsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of assets to be added.
     * The maximum number of assets that can be added in a single request is
     * 1000.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetList assets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAssets(
        com.google.cloud.migrationcenter.v1.AssetList.Builder builderForValue) {
      if (assetsBuilder_ == null) {
        assets_ = builderForValue.build();
      } else {
        assetsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of assets to be added.
     * The maximum number of assets that can be added in a single request is
     * 1000.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetList assets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeAssets(com.google.cloud.migrationcenter.v1.AssetList value) {
      if (assetsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && assets_ != null
            && assets_ != com.google.cloud.migrationcenter.v1.AssetList.getDefaultInstance()) {
          getAssetsBuilder().mergeFrom(value);
        } else {
          assets_ = value;
        }
      } else {
        assetsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of assets to be added.
     * The maximum number of assets that can be added in a single request is
     * 1000.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetList assets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearAssets() {
      bitField0_ = (bitField0_ & ~0x00000004);
      assets_ = null;
      if (assetsBuilder_ != null) {
        assetsBuilder_.dispose();
        assetsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of assets to be added.
     * The maximum number of assets that can be added in a single request is
     * 1000.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetList assets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.AssetList.Builder getAssetsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getAssetsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. List of assets to be added.
     * The maximum number of assets that can be added in a single request is
     * 1000.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetList assets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.AssetListOrBuilder getAssetsOrBuilder() {
      if (assetsBuilder_ != null) {
        return assetsBuilder_.getMessageOrBuilder();
      } else {
        return assets_ == null
            ? com.google.cloud.migrationcenter.v1.AssetList.getDefaultInstance()
            : assets_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. List of assets to be added.
     * The maximum number of assets that can be added in a single request is
     * 1000.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetList assets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.AssetList,
            com.google.cloud.migrationcenter.v1.AssetList.Builder,
            com.google.cloud.migrationcenter.v1.AssetListOrBuilder>
        getAssetsFieldBuilder() {
      if (assetsBuilder_ == null) {
        assetsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.AssetList,
                com.google.cloud.migrationcenter.v1.AssetList.Builder,
                com.google.cloud.migrationcenter.v1.AssetListOrBuilder>(
                getAssets(), getParentForChildren(), isClean());
        assets_ = null;
      }
      return assetsBuilder_;
    }

    private boolean allowExisting_;
    /**
     *
     *
     * <pre>
     * Optional. When this value is set to `false` and one of the given assets is
     * already an existing member of the group, the operation fails with an
     * `Already Exists` error. When set to `true` this situation is silently
     * ignored by the server.
     *
     * Default value is `false`.
     * </pre>
     *
     * <code>bool allow_existing = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The allowExisting.
     */
    @java.lang.Override
    public boolean getAllowExisting() {
      return allowExisting_;
    }
    /**
     *
     *
     * <pre>
     * Optional. When this value is set to `false` and one of the given assets is
     * already an existing member of the group, the operation fails with an
     * `Already Exists` error. When set to `true` this situation is silently
     * ignored by the server.
     *
     * Default value is `false`.
     * </pre>
     *
     * <code>bool allow_existing = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The allowExisting to set.
     * @return This builder for chaining.
     */
    public Builder setAllowExisting(boolean value) {

      allowExisting_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When this value is set to `false` and one of the given assets is
     * already an existing member of the group, the operation fails with an
     * `Already Exists` error. When set to `true` this situation is silently
     * ignored by the server.
     *
     * Default value is `false`.
     * </pre>
     *
     * <code>bool allow_existing = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowExisting() {
      bitField0_ = (bitField0_ & ~0x00000008);
      allowExisting_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.AddAssetsToGroupRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.AddAssetsToGroupRequest)
  private static final com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest();
  }

  public static com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AddAssetsToGroupRequest> PARSER =
      new com.google.protobuf.AbstractParser<AddAssetsToGroupRequest>() {
        @java.lang.Override
        public AddAssetsToGroupRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AddAssetsToGroupRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AddAssetsToGroupRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AddAssetsToGroupRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
