/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * A request to aggregate one or more values.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest}
 */
public final class AggregateAssetsValuesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest)
    AggregateAssetsValuesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AggregateAssetsValuesRequest.newBuilder() to construct.
  private AggregateAssetsValuesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AggregateAssetsValuesRequest() {
    parent_ = "";
    aggregations_ = java.util.Collections.emptyList();
    filter_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AggregateAssetsValuesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_AggregateAssetsValuesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_AggregateAssetsValuesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest.class,
            com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. Parent value for `AggregateAssetsValuesRequest`.
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Parent value for `AggregateAssetsValuesRequest`.
   * </pre>
   *
   * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AGGREGATIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.migrationcenter.v1.Aggregation> aggregations_;
  /**
   *
   *
   * <pre>
   * Array of aggregations to perform.
   * Up to 25 aggregations can be defined.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.migrationcenter.v1.Aggregation> getAggregationsList() {
    return aggregations_;
  }
  /**
   *
   *
   * <pre>
   * Array of aggregations to perform.
   * Up to 25 aggregations can be defined.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.migrationcenter.v1.AggregationOrBuilder>
      getAggregationsOrBuilderList() {
    return aggregations_;
  }
  /**
   *
   *
   * <pre>
   * Array of aggregations to perform.
   * Up to 25 aggregations can be defined.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
   */
  @java.lang.Override
  public int getAggregationsCount() {
    return aggregations_.size();
  }
  /**
   *
   *
   * <pre>
   * Array of aggregations to perform.
   * Up to 25 aggregations can be defined.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.Aggregation getAggregations(int index) {
    return aggregations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Array of aggregations to perform.
   * Up to 25 aggregations can be defined.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AggregationOrBuilder getAggregationsOrBuilder(
      int index) {
    return aggregations_.get(index);
  }

  public static final int FILTER_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * The aggregation will be performed on assets that match the provided filter.
   * </pre>
   *
   * <code>string filter = 3;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The aggregation will be performed on assets that match the provided filter.
   * </pre>
   *
   * <code>string filter = 3;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    for (int i = 0; i < aggregations_.size(); i++) {
      output.writeMessage(2, aggregations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, filter_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    for (int i = 0; i < aggregations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, aggregations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, filter_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest other =
        (com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getAggregationsList().equals(other.getAggregationsList())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (getAggregationsCount() > 0) {
      hash = (37 * hash) + AGGREGATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAggregationsList().hashCode();
    }
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request to aggregate one or more values.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest)
      com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AggregateAssetsValuesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AggregateAssetsValuesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest.class,
              com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      if (aggregationsBuilder_ == null) {
        aggregations_ = java.util.Collections.emptyList();
      } else {
        aggregations_ = null;
        aggregationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      filter_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AggregateAssetsValuesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest
        getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest build() {
      com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest buildPartial() {
      com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest result =
          new com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest result) {
      if (aggregationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          aggregations_ = java.util.Collections.unmodifiableList(aggregations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.aggregations_ = aggregations_;
      } else {
        result.aggregations_ = aggregationsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.filter_ = filter_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest other) {
      if (other
          == com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (aggregationsBuilder_ == null) {
        if (!other.aggregations_.isEmpty()) {
          if (aggregations_.isEmpty()) {
            aggregations_ = other.aggregations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureAggregationsIsMutable();
            aggregations_.addAll(other.aggregations_);
          }
          onChanged();
        }
      } else {
        if (!other.aggregations_.isEmpty()) {
          if (aggregationsBuilder_.isEmpty()) {
            aggregationsBuilder_.dispose();
            aggregationsBuilder_ = null;
            aggregations_ = other.aggregations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            aggregationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAggregationsFieldBuilder()
                    : null;
          } else {
            aggregationsBuilder_.addAllMessages(other.aggregations_);
          }
        }
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.migrationcenter.v1.Aggregation m =
                    input.readMessage(
                        com.google.cloud.migrationcenter.v1.Aggregation.parser(),
                        extensionRegistry);
                if (aggregationsBuilder_ == null) {
                  ensureAggregationsIsMutable();
                  aggregations_.add(m);
                } else {
                  aggregationsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Parent value for `AggregateAssetsValuesRequest`.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Parent value for `AggregateAssetsValuesRequest`.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Parent value for `AggregateAssetsValuesRequest`.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Parent value for `AggregateAssetsValuesRequest`.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Parent value for `AggregateAssetsValuesRequest`.
     * </pre>
     *
     * <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.migrationcenter.v1.Aggregation> aggregations_ =
        java.util.Collections.emptyList();

    private void ensureAggregationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        aggregations_ =
            new java.util.ArrayList<com.google.cloud.migrationcenter.v1.Aggregation>(aggregations_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.Aggregation,
            com.google.cloud.migrationcenter.v1.Aggregation.Builder,
            com.google.cloud.migrationcenter.v1.AggregationOrBuilder>
        aggregationsBuilder_;

    /**
     *
     *
     * <pre>
     * Array of aggregations to perform.
     * Up to 25 aggregations can be defined.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.Aggregation> getAggregationsList() {
      if (aggregationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(aggregations_);
      } else {
        return aggregationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Array of aggregations to perform.
     * Up to 25 aggregations can be defined.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
     */
    public int getAggregationsCount() {
      if (aggregationsBuilder_ == null) {
        return aggregations_.size();
      } else {
        return aggregationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Array of aggregations to perform.
     * Up to 25 aggregations can be defined.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.Aggregation getAggregations(int index) {
      if (aggregationsBuilder_ == null) {
        return aggregations_.get(index);
      } else {
        return aggregationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Array of aggregations to perform.
     * Up to 25 aggregations can be defined.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
     */
    public Builder setAggregations(
        int index, com.google.cloud.migrationcenter.v1.Aggregation value) {
      if (aggregationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregationsIsMutable();
        aggregations_.set(index, value);
        onChanged();
      } else {
        aggregationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array of aggregations to perform.
     * Up to 25 aggregations can be defined.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
     */
    public Builder setAggregations(
        int index, com.google.cloud.migrationcenter.v1.Aggregation.Builder builderForValue) {
      if (aggregationsBuilder_ == null) {
        ensureAggregationsIsMutable();
        aggregations_.set(index, builderForValue.build());
        onChanged();
      } else {
        aggregationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array of aggregations to perform.
     * Up to 25 aggregations can be defined.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
     */
    public Builder addAggregations(com.google.cloud.migrationcenter.v1.Aggregation value) {
      if (aggregationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregationsIsMutable();
        aggregations_.add(value);
        onChanged();
      } else {
        aggregationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array of aggregations to perform.
     * Up to 25 aggregations can be defined.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
     */
    public Builder addAggregations(
        int index, com.google.cloud.migrationcenter.v1.Aggregation value) {
      if (aggregationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregationsIsMutable();
        aggregations_.add(index, value);
        onChanged();
      } else {
        aggregationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array of aggregations to perform.
     * Up to 25 aggregations can be defined.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
     */
    public Builder addAggregations(
        com.google.cloud.migrationcenter.v1.Aggregation.Builder builderForValue) {
      if (aggregationsBuilder_ == null) {
        ensureAggregationsIsMutable();
        aggregations_.add(builderForValue.build());
        onChanged();
      } else {
        aggregationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array of aggregations to perform.
     * Up to 25 aggregations can be defined.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
     */
    public Builder addAggregations(
        int index, com.google.cloud.migrationcenter.v1.Aggregation.Builder builderForValue) {
      if (aggregationsBuilder_ == null) {
        ensureAggregationsIsMutable();
        aggregations_.add(index, builderForValue.build());
        onChanged();
      } else {
        aggregationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array of aggregations to perform.
     * Up to 25 aggregations can be defined.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
     */
    public Builder addAllAggregations(
        java.lang.Iterable<? extends com.google.cloud.migrationcenter.v1.Aggregation> values) {
      if (aggregationsBuilder_ == null) {
        ensureAggregationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, aggregations_);
        onChanged();
      } else {
        aggregationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array of aggregations to perform.
     * Up to 25 aggregations can be defined.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
     */
    public Builder clearAggregations() {
      if (aggregationsBuilder_ == null) {
        aggregations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        aggregationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array of aggregations to perform.
     * Up to 25 aggregations can be defined.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
     */
    public Builder removeAggregations(int index) {
      if (aggregationsBuilder_ == null) {
        ensureAggregationsIsMutable();
        aggregations_.remove(index);
        onChanged();
      } else {
        aggregationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Array of aggregations to perform.
     * Up to 25 aggregations can be defined.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.Aggregation.Builder getAggregationsBuilder(
        int index) {
      return getAggregationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Array of aggregations to perform.
     * Up to 25 aggregations can be defined.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.AggregationOrBuilder getAggregationsOrBuilder(
        int index) {
      if (aggregationsBuilder_ == null) {
        return aggregations_.get(index);
      } else {
        return aggregationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Array of aggregations to perform.
     * Up to 25 aggregations can be defined.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.migrationcenter.v1.AggregationOrBuilder>
        getAggregationsOrBuilderList() {
      if (aggregationsBuilder_ != null) {
        return aggregationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(aggregations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Array of aggregations to perform.
     * Up to 25 aggregations can be defined.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.Aggregation.Builder addAggregationsBuilder() {
      return getAggregationsFieldBuilder()
          .addBuilder(com.google.cloud.migrationcenter.v1.Aggregation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Array of aggregations to perform.
     * Up to 25 aggregations can be defined.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.Aggregation.Builder addAggregationsBuilder(
        int index) {
      return getAggregationsFieldBuilder()
          .addBuilder(index, com.google.cloud.migrationcenter.v1.Aggregation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Array of aggregations to perform.
     * Up to 25 aggregations can be defined.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.Aggregation aggregations = 2;</code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.Aggregation.Builder>
        getAggregationsBuilderList() {
      return getAggregationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.Aggregation,
            com.google.cloud.migrationcenter.v1.Aggregation.Builder,
            com.google.cloud.migrationcenter.v1.AggregationOrBuilder>
        getAggregationsFieldBuilder() {
      if (aggregationsBuilder_ == null) {
        aggregationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.Aggregation,
                com.google.cloud.migrationcenter.v1.Aggregation.Builder,
                com.google.cloud.migrationcenter.v1.AggregationOrBuilder>(
                aggregations_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        aggregations_ = null;
      }
      return aggregationsBuilder_;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * The aggregation will be performed on assets that match the provided filter.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The aggregation will be performed on assets that match the provided filter.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The aggregation will be performed on assets that match the provided filter.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The aggregation will be performed on assets that match the provided filter.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The aggregation will be performed on assets that match the provided filter.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest)
  private static final com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest();
  }

  public static com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AggregateAssetsValuesRequest> PARSER =
      new com.google.protobuf.AbstractParser<AggregateAssetsValuesRequest>() {
        @java.lang.Override
        public AggregateAssetsValuesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AggregateAssetsValuesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AggregateAssetsValuesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AggregateAssetsValuesRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
