/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * Message describing an aggregation. The message includes the aggregation type,
 * parameters, and the field on which to perform the aggregation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.Aggregation}
 */
public final class Aggregation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.Aggregation)
    AggregationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Aggregation.newBuilder() to construct.
  private Aggregation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Aggregation() {
    field_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Aggregation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_Aggregation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_Aggregation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.Aggregation.class,
            com.google.cloud.migrationcenter.v1.Aggregation.Builder.class);
  }

  public interface CountOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.Aggregation.Count)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Object count.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.Aggregation.Count}
   */
  public static final class Count extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.Aggregation.Count)
      CountOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Count.newBuilder() to construct.
    private Count(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Count() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Count();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_Aggregation_Count_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_Aggregation_Count_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.Aggregation.Count.class,
              com.google.cloud.migrationcenter.v1.Aggregation.Count.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.migrationcenter.v1.Aggregation.Count)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.Aggregation.Count other =
          (com.google.cloud.migrationcenter.v1.Aggregation.Count) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Count parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Count parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Count parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Count parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Count parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Count parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Count parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Count parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Count parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Count parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Count parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Count parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.Aggregation.Count prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Object count.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.Aggregation.Count}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.Aggregation.Count)
        com.google.cloud.migrationcenter.v1.Aggregation.CountOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_Aggregation_Count_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_Aggregation_Count_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.Aggregation.Count.class,
                com.google.cloud.migrationcenter.v1.Aggregation.Count.Builder.class);
      }

      // Construct using com.google.cloud.migrationcenter.v1.Aggregation.Count.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_Aggregation_Count_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.Aggregation.Count getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.Aggregation.Count.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.Aggregation.Count build() {
        com.google.cloud.migrationcenter.v1.Aggregation.Count result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.Aggregation.Count buildPartial() {
        com.google.cloud.migrationcenter.v1.Aggregation.Count result =
            new com.google.cloud.migrationcenter.v1.Aggregation.Count(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.migrationcenter.v1.Aggregation.Count) {
          return mergeFrom((com.google.cloud.migrationcenter.v1.Aggregation.Count) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.migrationcenter.v1.Aggregation.Count other) {
        if (other == com.google.cloud.migrationcenter.v1.Aggregation.Count.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.Aggregation.Count)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.Aggregation.Count)
    private static final com.google.cloud.migrationcenter.v1.Aggregation.Count DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.Aggregation.Count();
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Count getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Count> PARSER =
        new com.google.protobuf.AbstractParser<Count>() {
          @java.lang.Override
          public Count parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Count> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Count> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.Aggregation.Count getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SumOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.Aggregation.Sum)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Sum of field values.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.Aggregation.Sum}
   */
  public static final class Sum extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.Aggregation.Sum)
      SumOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Sum.newBuilder() to construct.
    private Sum(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Sum() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Sum();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_Aggregation_Sum_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_Aggregation_Sum_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.Aggregation.Sum.class,
              com.google.cloud.migrationcenter.v1.Aggregation.Sum.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.migrationcenter.v1.Aggregation.Sum)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.Aggregation.Sum other =
          (com.google.cloud.migrationcenter.v1.Aggregation.Sum) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Sum parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Sum parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Sum parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Sum parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Sum parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Sum parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Sum parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Sum parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Sum parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Sum parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Sum parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Sum parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.Aggregation.Sum prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Sum of field values.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.Aggregation.Sum}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.Aggregation.Sum)
        com.google.cloud.migrationcenter.v1.Aggregation.SumOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_Aggregation_Sum_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_Aggregation_Sum_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.Aggregation.Sum.class,
                com.google.cloud.migrationcenter.v1.Aggregation.Sum.Builder.class);
      }

      // Construct using com.google.cloud.migrationcenter.v1.Aggregation.Sum.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_Aggregation_Sum_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.Aggregation.Sum getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.Aggregation.Sum.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.Aggregation.Sum build() {
        com.google.cloud.migrationcenter.v1.Aggregation.Sum result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.Aggregation.Sum buildPartial() {
        com.google.cloud.migrationcenter.v1.Aggregation.Sum result =
            new com.google.cloud.migrationcenter.v1.Aggregation.Sum(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.migrationcenter.v1.Aggregation.Sum) {
          return mergeFrom((com.google.cloud.migrationcenter.v1.Aggregation.Sum) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.migrationcenter.v1.Aggregation.Sum other) {
        if (other == com.google.cloud.migrationcenter.v1.Aggregation.Sum.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.Aggregation.Sum)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.Aggregation.Sum)
    private static final com.google.cloud.migrationcenter.v1.Aggregation.Sum DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.Aggregation.Sum();
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Sum getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Sum> PARSER =
        new com.google.protobuf.AbstractParser<Sum>() {
          @java.lang.Override
          public Sum parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Sum> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Sum> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.Aggregation.Sum getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface HistogramOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.Aggregation.Histogram)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Lower bounds of buckets.
     * The response will contain `n+1` buckets for `n` bounds.
     * The first bucket will count all assets for which the field value is
     * smaller than the first bound.
     * Subsequent buckets will count assets for which the field value is
     * greater or equal to a lower bound and smaller than the next one.
     * The last bucket will count assets for which the field value is greater or
     * equal to the final lower bound.
     * You can define up to 20 lower bounds.
     * </pre>
     *
     * <code>repeated double lower_bounds = 1;</code>
     *
     * @return A list containing the lowerBounds.
     */
    java.util.List<java.lang.Double> getLowerBoundsList();
    /**
     *
     *
     * <pre>
     * Lower bounds of buckets.
     * The response will contain `n+1` buckets for `n` bounds.
     * The first bucket will count all assets for which the field value is
     * smaller than the first bound.
     * Subsequent buckets will count assets for which the field value is
     * greater or equal to a lower bound and smaller than the next one.
     * The last bucket will count assets for which the field value is greater or
     * equal to the final lower bound.
     * You can define up to 20 lower bounds.
     * </pre>
     *
     * <code>repeated double lower_bounds = 1;</code>
     *
     * @return The count of lowerBounds.
     */
    int getLowerBoundsCount();
    /**
     *
     *
     * <pre>
     * Lower bounds of buckets.
     * The response will contain `n+1` buckets for `n` bounds.
     * The first bucket will count all assets for which the field value is
     * smaller than the first bound.
     * Subsequent buckets will count assets for which the field value is
     * greater or equal to a lower bound and smaller than the next one.
     * The last bucket will count assets for which the field value is greater or
     * equal to the final lower bound.
     * You can define up to 20 lower bounds.
     * </pre>
     *
     * <code>repeated double lower_bounds = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The lowerBounds at the given index.
     */
    double getLowerBounds(int index);
  }
  /**
   *
   *
   * <pre>
   * Histogram of bucketed assets counts by field value.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.Aggregation.Histogram}
   */
  public static final class Histogram extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.Aggregation.Histogram)
      HistogramOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Histogram.newBuilder() to construct.
    private Histogram(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Histogram() {
      lowerBounds_ = emptyDoubleList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Histogram();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_Aggregation_Histogram_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_Aggregation_Histogram_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.Aggregation.Histogram.class,
              com.google.cloud.migrationcenter.v1.Aggregation.Histogram.Builder.class);
    }

    public static final int LOWER_BOUNDS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.Internal.DoubleList lowerBounds_;
    /**
     *
     *
     * <pre>
     * Lower bounds of buckets.
     * The response will contain `n+1` buckets for `n` bounds.
     * The first bucket will count all assets for which the field value is
     * smaller than the first bound.
     * Subsequent buckets will count assets for which the field value is
     * greater or equal to a lower bound and smaller than the next one.
     * The last bucket will count assets for which the field value is greater or
     * equal to the final lower bound.
     * You can define up to 20 lower bounds.
     * </pre>
     *
     * <code>repeated double lower_bounds = 1;</code>
     *
     * @return A list containing the lowerBounds.
     */
    @java.lang.Override
    public java.util.List<java.lang.Double> getLowerBoundsList() {
      return lowerBounds_;
    }
    /**
     *
     *
     * <pre>
     * Lower bounds of buckets.
     * The response will contain `n+1` buckets for `n` bounds.
     * The first bucket will count all assets for which the field value is
     * smaller than the first bound.
     * Subsequent buckets will count assets for which the field value is
     * greater or equal to a lower bound and smaller than the next one.
     * The last bucket will count assets for which the field value is greater or
     * equal to the final lower bound.
     * You can define up to 20 lower bounds.
     * </pre>
     *
     * <code>repeated double lower_bounds = 1;</code>
     *
     * @return The count of lowerBounds.
     */
    public int getLowerBoundsCount() {
      return lowerBounds_.size();
    }
    /**
     *
     *
     * <pre>
     * Lower bounds of buckets.
     * The response will contain `n+1` buckets for `n` bounds.
     * The first bucket will count all assets for which the field value is
     * smaller than the first bound.
     * Subsequent buckets will count assets for which the field value is
     * greater or equal to a lower bound and smaller than the next one.
     * The last bucket will count assets for which the field value is greater or
     * equal to the final lower bound.
     * You can define up to 20 lower bounds.
     * </pre>
     *
     * <code>repeated double lower_bounds = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The lowerBounds at the given index.
     */
    public double getLowerBounds(int index) {
      return lowerBounds_.getDouble(index);
    }

    private int lowerBoundsMemoizedSerializedSize = -1;

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (getLowerBoundsList().size() > 0) {
        output.writeUInt32NoTag(10);
        output.writeUInt32NoTag(lowerBoundsMemoizedSerializedSize);
      }
      for (int i = 0; i < lowerBounds_.size(); i++) {
        output.writeDoubleNoTag(lowerBounds_.getDouble(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        dataSize = 8 * getLowerBoundsList().size();
        size += dataSize;
        if (!getLowerBoundsList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
        }
        lowerBoundsMemoizedSerializedSize = dataSize;
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.migrationcenter.v1.Aggregation.Histogram)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.Aggregation.Histogram other =
          (com.google.cloud.migrationcenter.v1.Aggregation.Histogram) obj;

      if (!getLowerBoundsList().equals(other.getLowerBoundsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getLowerBoundsCount() > 0) {
        hash = (37 * hash) + LOWER_BOUNDS_FIELD_NUMBER;
        hash = (53 * hash) + getLowerBoundsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Histogram parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Histogram parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Histogram parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Histogram parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Histogram parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Histogram parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Histogram parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Histogram parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Histogram parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Histogram parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Histogram parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Histogram parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.Aggregation.Histogram prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Histogram of bucketed assets counts by field value.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.Aggregation.Histogram}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.Aggregation.Histogram)
        com.google.cloud.migrationcenter.v1.Aggregation.HistogramOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_Aggregation_Histogram_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_Aggregation_Histogram_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.Aggregation.Histogram.class,
                com.google.cloud.migrationcenter.v1.Aggregation.Histogram.Builder.class);
      }

      // Construct using com.google.cloud.migrationcenter.v1.Aggregation.Histogram.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        lowerBounds_ = emptyDoubleList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_Aggregation_Histogram_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.Aggregation.Histogram getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.Aggregation.Histogram.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.Aggregation.Histogram build() {
        com.google.cloud.migrationcenter.v1.Aggregation.Histogram result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.Aggregation.Histogram buildPartial() {
        com.google.cloud.migrationcenter.v1.Aggregation.Histogram result =
            new com.google.cloud.migrationcenter.v1.Aggregation.Histogram(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.migrationcenter.v1.Aggregation.Histogram result) {
        if (((bitField0_ & 0x00000001) != 0)) {
          lowerBounds_.makeImmutable();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.lowerBounds_ = lowerBounds_;
      }

      private void buildPartial0(com.google.cloud.migrationcenter.v1.Aggregation.Histogram result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.migrationcenter.v1.Aggregation.Histogram) {
          return mergeFrom((com.google.cloud.migrationcenter.v1.Aggregation.Histogram) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.migrationcenter.v1.Aggregation.Histogram other) {
        if (other == com.google.cloud.migrationcenter.v1.Aggregation.Histogram.getDefaultInstance())
          return this;
        if (!other.lowerBounds_.isEmpty()) {
          if (lowerBounds_.isEmpty()) {
            lowerBounds_ = other.lowerBounds_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureLowerBoundsIsMutable();
            lowerBounds_.addAll(other.lowerBounds_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  double v = input.readDouble();
                  ensureLowerBoundsIsMutable();
                  lowerBounds_.addDouble(v);
                  break;
                } // case 9
              case 10:
                {
                  int length = input.readRawVarint32();
                  int limit = input.pushLimit(length);
                  ensureLowerBoundsIsMutable();
                  while (input.getBytesUntilLimit() > 0) {
                    lowerBounds_.addDouble(input.readDouble());
                  }
                  input.popLimit(limit);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Internal.DoubleList lowerBounds_ = emptyDoubleList();

      private void ensureLowerBoundsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          lowerBounds_ = mutableCopy(lowerBounds_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * Lower bounds of buckets.
       * The response will contain `n+1` buckets for `n` bounds.
       * The first bucket will count all assets for which the field value is
       * smaller than the first bound.
       * Subsequent buckets will count assets for which the field value is
       * greater or equal to a lower bound and smaller than the next one.
       * The last bucket will count assets for which the field value is greater or
       * equal to the final lower bound.
       * You can define up to 20 lower bounds.
       * </pre>
       *
       * <code>repeated double lower_bounds = 1;</code>
       *
       * @return A list containing the lowerBounds.
       */
      public java.util.List<java.lang.Double> getLowerBoundsList() {
        return ((bitField0_ & 0x00000001) != 0)
            ? java.util.Collections.unmodifiableList(lowerBounds_)
            : lowerBounds_;
      }
      /**
       *
       *
       * <pre>
       * Lower bounds of buckets.
       * The response will contain `n+1` buckets for `n` bounds.
       * The first bucket will count all assets for which the field value is
       * smaller than the first bound.
       * Subsequent buckets will count assets for which the field value is
       * greater or equal to a lower bound and smaller than the next one.
       * The last bucket will count assets for which the field value is greater or
       * equal to the final lower bound.
       * You can define up to 20 lower bounds.
       * </pre>
       *
       * <code>repeated double lower_bounds = 1;</code>
       *
       * @return The count of lowerBounds.
       */
      public int getLowerBoundsCount() {
        return lowerBounds_.size();
      }
      /**
       *
       *
       * <pre>
       * Lower bounds of buckets.
       * The response will contain `n+1` buckets for `n` bounds.
       * The first bucket will count all assets for which the field value is
       * smaller than the first bound.
       * Subsequent buckets will count assets for which the field value is
       * greater or equal to a lower bound and smaller than the next one.
       * The last bucket will count assets for which the field value is greater or
       * equal to the final lower bound.
       * You can define up to 20 lower bounds.
       * </pre>
       *
       * <code>repeated double lower_bounds = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The lowerBounds at the given index.
       */
      public double getLowerBounds(int index) {
        return lowerBounds_.getDouble(index);
      }
      /**
       *
       *
       * <pre>
       * Lower bounds of buckets.
       * The response will contain `n+1` buckets for `n` bounds.
       * The first bucket will count all assets for which the field value is
       * smaller than the first bound.
       * Subsequent buckets will count assets for which the field value is
       * greater or equal to a lower bound and smaller than the next one.
       * The last bucket will count assets for which the field value is greater or
       * equal to the final lower bound.
       * You can define up to 20 lower bounds.
       * </pre>
       *
       * <code>repeated double lower_bounds = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The lowerBounds to set.
       * @return This builder for chaining.
       */
      public Builder setLowerBounds(int index, double value) {

        ensureLowerBoundsIsMutable();
        lowerBounds_.setDouble(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Lower bounds of buckets.
       * The response will contain `n+1` buckets for `n` bounds.
       * The first bucket will count all assets for which the field value is
       * smaller than the first bound.
       * Subsequent buckets will count assets for which the field value is
       * greater or equal to a lower bound and smaller than the next one.
       * The last bucket will count assets for which the field value is greater or
       * equal to the final lower bound.
       * You can define up to 20 lower bounds.
       * </pre>
       *
       * <code>repeated double lower_bounds = 1;</code>
       *
       * @param value The lowerBounds to add.
       * @return This builder for chaining.
       */
      public Builder addLowerBounds(double value) {

        ensureLowerBoundsIsMutable();
        lowerBounds_.addDouble(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Lower bounds of buckets.
       * The response will contain `n+1` buckets for `n` bounds.
       * The first bucket will count all assets for which the field value is
       * smaller than the first bound.
       * Subsequent buckets will count assets for which the field value is
       * greater or equal to a lower bound and smaller than the next one.
       * The last bucket will count assets for which the field value is greater or
       * equal to the final lower bound.
       * You can define up to 20 lower bounds.
       * </pre>
       *
       * <code>repeated double lower_bounds = 1;</code>
       *
       * @param values The lowerBounds to add.
       * @return This builder for chaining.
       */
      public Builder addAllLowerBounds(java.lang.Iterable<? extends java.lang.Double> values) {
        ensureLowerBoundsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, lowerBounds_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Lower bounds of buckets.
       * The response will contain `n+1` buckets for `n` bounds.
       * The first bucket will count all assets for which the field value is
       * smaller than the first bound.
       * Subsequent buckets will count assets for which the field value is
       * greater or equal to a lower bound and smaller than the next one.
       * The last bucket will count assets for which the field value is greater or
       * equal to the final lower bound.
       * You can define up to 20 lower bounds.
       * </pre>
       *
       * <code>repeated double lower_bounds = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLowerBounds() {
        lowerBounds_ = emptyDoubleList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.Aggregation.Histogram)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.Aggregation.Histogram)
    private static final com.google.cloud.migrationcenter.v1.Aggregation.Histogram DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.Aggregation.Histogram();
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Histogram getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Histogram> PARSER =
        new com.google.protobuf.AbstractParser<Histogram>() {
          @java.lang.Override
          public Histogram parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Histogram> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Histogram> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.Aggregation.Histogram getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FrequencyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.Aggregation.Frequency)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Frequency distribution of all field values.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.Aggregation.Frequency}
   */
  public static final class Frequency extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.Aggregation.Frequency)
      FrequencyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Frequency.newBuilder() to construct.
    private Frequency(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Frequency() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Frequency();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_Aggregation_Frequency_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_Aggregation_Frequency_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.Aggregation.Frequency.class,
              com.google.cloud.migrationcenter.v1.Aggregation.Frequency.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.migrationcenter.v1.Aggregation.Frequency)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.Aggregation.Frequency other =
          (com.google.cloud.migrationcenter.v1.Aggregation.Frequency) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Frequency parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Frequency parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Frequency parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Frequency parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Frequency parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Frequency parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Frequency parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Frequency parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Frequency parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Frequency parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Frequency parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Frequency parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.Aggregation.Frequency prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Frequency distribution of all field values.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.Aggregation.Frequency}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.Aggregation.Frequency)
        com.google.cloud.migrationcenter.v1.Aggregation.FrequencyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_Aggregation_Frequency_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_Aggregation_Frequency_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.Aggregation.Frequency.class,
                com.google.cloud.migrationcenter.v1.Aggregation.Frequency.Builder.class);
      }

      // Construct using com.google.cloud.migrationcenter.v1.Aggregation.Frequency.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_Aggregation_Frequency_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.Aggregation.Frequency getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.Aggregation.Frequency.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.Aggregation.Frequency build() {
        com.google.cloud.migrationcenter.v1.Aggregation.Frequency result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.Aggregation.Frequency buildPartial() {
        com.google.cloud.migrationcenter.v1.Aggregation.Frequency result =
            new com.google.cloud.migrationcenter.v1.Aggregation.Frequency(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.migrationcenter.v1.Aggregation.Frequency) {
          return mergeFrom((com.google.cloud.migrationcenter.v1.Aggregation.Frequency) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.migrationcenter.v1.Aggregation.Frequency other) {
        if (other == com.google.cloud.migrationcenter.v1.Aggregation.Frequency.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.Aggregation.Frequency)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.Aggregation.Frequency)
    private static final com.google.cloud.migrationcenter.v1.Aggregation.Frequency DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.Aggregation.Frequency();
    }

    public static com.google.cloud.migrationcenter.v1.Aggregation.Frequency getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Frequency> PARSER =
        new com.google.protobuf.AbstractParser<Frequency>() {
          @java.lang.Override
          public Frequency parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Frequency> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Frequency> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.Aggregation.Frequency getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int aggregationFunctionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object aggregationFunction_;

  public enum AggregationFunctionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    COUNT(2),
    SUM(3),
    HISTOGRAM(4),
    FREQUENCY(5),
    AGGREGATIONFUNCTION_NOT_SET(0);
    private final int value;

    private AggregationFunctionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AggregationFunctionCase valueOf(int value) {
      return forNumber(value);
    }

    public static AggregationFunctionCase forNumber(int value) {
      switch (value) {
        case 2:
          return COUNT;
        case 3:
          return SUM;
        case 4:
          return HISTOGRAM;
        case 5:
          return FREQUENCY;
        case 0:
          return AGGREGATIONFUNCTION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AggregationFunctionCase getAggregationFunctionCase() {
    return AggregationFunctionCase.forNumber(aggregationFunctionCase_);
  }

  public static final int FIELD_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object field_ = "";
  /**
   *
   *
   * <pre>
   * The name of the field on which to aggregate.
   * </pre>
   *
   * <code>string field = 1;</code>
   *
   * @return The field.
   */
  @java.lang.Override
  public java.lang.String getField() {
    java.lang.Object ref = field_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      field_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the field on which to aggregate.
   * </pre>
   *
   * <code>string field = 1;</code>
   *
   * @return The bytes for field.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFieldBytes() {
    java.lang.Object ref = field_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      field_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COUNT_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Count the number of matching objects.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.Aggregation.Count count = 2;</code>
   *
   * @return Whether the count field is set.
   */
  @java.lang.Override
  public boolean hasCount() {
    return aggregationFunctionCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Count the number of matching objects.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.Aggregation.Count count = 2;</code>
   *
   * @return The count.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.Aggregation.Count getCount() {
    if (aggregationFunctionCase_ == 2) {
      return (com.google.cloud.migrationcenter.v1.Aggregation.Count) aggregationFunction_;
    }
    return com.google.cloud.migrationcenter.v1.Aggregation.Count.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Count the number of matching objects.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.Aggregation.Count count = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.Aggregation.CountOrBuilder getCountOrBuilder() {
    if (aggregationFunctionCase_ == 2) {
      return (com.google.cloud.migrationcenter.v1.Aggregation.Count) aggregationFunction_;
    }
    return com.google.cloud.migrationcenter.v1.Aggregation.Count.getDefaultInstance();
  }

  public static final int SUM_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Sum over a numeric field.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.Aggregation.Sum sum = 3;</code>
   *
   * @return Whether the sum field is set.
   */
  @java.lang.Override
  public boolean hasSum() {
    return aggregationFunctionCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Sum over a numeric field.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.Aggregation.Sum sum = 3;</code>
   *
   * @return The sum.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.Aggregation.Sum getSum() {
    if (aggregationFunctionCase_ == 3) {
      return (com.google.cloud.migrationcenter.v1.Aggregation.Sum) aggregationFunction_;
    }
    return com.google.cloud.migrationcenter.v1.Aggregation.Sum.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Sum over a numeric field.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.Aggregation.Sum sum = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.Aggregation.SumOrBuilder getSumOrBuilder() {
    if (aggregationFunctionCase_ == 3) {
      return (com.google.cloud.migrationcenter.v1.Aggregation.Sum) aggregationFunction_;
    }
    return com.google.cloud.migrationcenter.v1.Aggregation.Sum.getDefaultInstance();
  }

  public static final int HISTOGRAM_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Creates a bucketed histogram of field values.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.Aggregation.Histogram histogram = 4;</code>
   *
   * @return Whether the histogram field is set.
   */
  @java.lang.Override
  public boolean hasHistogram() {
    return aggregationFunctionCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Creates a bucketed histogram of field values.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.Aggregation.Histogram histogram = 4;</code>
   *
   * @return The histogram.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.Aggregation.Histogram getHistogram() {
    if (aggregationFunctionCase_ == 4) {
      return (com.google.cloud.migrationcenter.v1.Aggregation.Histogram) aggregationFunction_;
    }
    return com.google.cloud.migrationcenter.v1.Aggregation.Histogram.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Creates a bucketed histogram of field values.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.Aggregation.Histogram histogram = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.Aggregation.HistogramOrBuilder
      getHistogramOrBuilder() {
    if (aggregationFunctionCase_ == 4) {
      return (com.google.cloud.migrationcenter.v1.Aggregation.Histogram) aggregationFunction_;
    }
    return com.google.cloud.migrationcenter.v1.Aggregation.Histogram.getDefaultInstance();
  }

  public static final int FREQUENCY_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Creates a frequency distribution of all field values.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.Aggregation.Frequency frequency = 5;</code>
   *
   * @return Whether the frequency field is set.
   */
  @java.lang.Override
  public boolean hasFrequency() {
    return aggregationFunctionCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Creates a frequency distribution of all field values.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.Aggregation.Frequency frequency = 5;</code>
   *
   * @return The frequency.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.Aggregation.Frequency getFrequency() {
    if (aggregationFunctionCase_ == 5) {
      return (com.google.cloud.migrationcenter.v1.Aggregation.Frequency) aggregationFunction_;
    }
    return com.google.cloud.migrationcenter.v1.Aggregation.Frequency.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Creates a frequency distribution of all field values.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.Aggregation.Frequency frequency = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.Aggregation.FrequencyOrBuilder
      getFrequencyOrBuilder() {
    if (aggregationFunctionCase_ == 5) {
      return (com.google.cloud.migrationcenter.v1.Aggregation.Frequency) aggregationFunction_;
    }
    return com.google.cloud.migrationcenter.v1.Aggregation.Frequency.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(field_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, field_);
    }
    if (aggregationFunctionCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.migrationcenter.v1.Aggregation.Count) aggregationFunction_);
    }
    if (aggregationFunctionCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.migrationcenter.v1.Aggregation.Sum) aggregationFunction_);
    }
    if (aggregationFunctionCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.migrationcenter.v1.Aggregation.Histogram) aggregationFunction_);
    }
    if (aggregationFunctionCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.migrationcenter.v1.Aggregation.Frequency) aggregationFunction_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(field_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, field_);
    }
    if (aggregationFunctionCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.migrationcenter.v1.Aggregation.Count) aggregationFunction_);
    }
    if (aggregationFunctionCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.migrationcenter.v1.Aggregation.Sum) aggregationFunction_);
    }
    if (aggregationFunctionCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.migrationcenter.v1.Aggregation.Histogram) aggregationFunction_);
    }
    if (aggregationFunctionCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.migrationcenter.v1.Aggregation.Frequency) aggregationFunction_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.Aggregation)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.Aggregation other =
        (com.google.cloud.migrationcenter.v1.Aggregation) obj;

    if (!getField().equals(other.getField())) return false;
    if (!getAggregationFunctionCase().equals(other.getAggregationFunctionCase())) return false;
    switch (aggregationFunctionCase_) {
      case 2:
        if (!getCount().equals(other.getCount())) return false;
        break;
      case 3:
        if (!getSum().equals(other.getSum())) return false;
        break;
      case 4:
        if (!getHistogram().equals(other.getHistogram())) return false;
        break;
      case 5:
        if (!getFrequency().equals(other.getFrequency())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FIELD_FIELD_NUMBER;
    hash = (53 * hash) + getField().hashCode();
    switch (aggregationFunctionCase_) {
      case 2:
        hash = (37 * hash) + COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getCount().hashCode();
        break;
      case 3:
        hash = (37 * hash) + SUM_FIELD_NUMBER;
        hash = (53 * hash) + getSum().hashCode();
        break;
      case 4:
        hash = (37 * hash) + HISTOGRAM_FIELD_NUMBER;
        hash = (53 * hash) + getHistogram().hashCode();
        break;
      case 5:
        hash = (37 * hash) + FREQUENCY_FIELD_NUMBER;
        hash = (53 * hash) + getFrequency().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.Aggregation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.Aggregation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.Aggregation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.Aggregation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.Aggregation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.Aggregation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.Aggregation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.Aggregation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.Aggregation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.Aggregation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.Aggregation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.Aggregation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.migrationcenter.v1.Aggregation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Message describing an aggregation. The message includes the aggregation type,
   * parameters, and the field on which to perform the aggregation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.Aggregation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.Aggregation)
      com.google.cloud.migrationcenter.v1.AggregationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_Aggregation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_Aggregation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.Aggregation.class,
              com.google.cloud.migrationcenter.v1.Aggregation.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.Aggregation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      field_ = "";
      if (countBuilder_ != null) {
        countBuilder_.clear();
      }
      if (sumBuilder_ != null) {
        sumBuilder_.clear();
      }
      if (histogramBuilder_ != null) {
        histogramBuilder_.clear();
      }
      if (frequencyBuilder_ != null) {
        frequencyBuilder_.clear();
      }
      aggregationFunctionCase_ = 0;
      aggregationFunction_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_Aggregation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.Aggregation getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.Aggregation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.Aggregation build() {
      com.google.cloud.migrationcenter.v1.Aggregation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.Aggregation buildPartial() {
      com.google.cloud.migrationcenter.v1.Aggregation result =
          new com.google.cloud.migrationcenter.v1.Aggregation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.Aggregation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.field_ = field_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.migrationcenter.v1.Aggregation result) {
      result.aggregationFunctionCase_ = aggregationFunctionCase_;
      result.aggregationFunction_ = this.aggregationFunction_;
      if (aggregationFunctionCase_ == 2 && countBuilder_ != null) {
        result.aggregationFunction_ = countBuilder_.build();
      }
      if (aggregationFunctionCase_ == 3 && sumBuilder_ != null) {
        result.aggregationFunction_ = sumBuilder_.build();
      }
      if (aggregationFunctionCase_ == 4 && histogramBuilder_ != null) {
        result.aggregationFunction_ = histogramBuilder_.build();
      }
      if (aggregationFunctionCase_ == 5 && frequencyBuilder_ != null) {
        result.aggregationFunction_ = frequencyBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.Aggregation) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.Aggregation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.Aggregation other) {
      if (other == com.google.cloud.migrationcenter.v1.Aggregation.getDefaultInstance())
        return this;
      if (!other.getField().isEmpty()) {
        field_ = other.field_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      switch (other.getAggregationFunctionCase()) {
        case COUNT:
          {
            mergeCount(other.getCount());
            break;
          }
        case SUM:
          {
            mergeSum(other.getSum());
            break;
          }
        case HISTOGRAM:
          {
            mergeHistogram(other.getHistogram());
            break;
          }
        case FREQUENCY:
          {
            mergeFrequency(other.getFrequency());
            break;
          }
        case AGGREGATIONFUNCTION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                field_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCountFieldBuilder().getBuilder(), extensionRegistry);
                aggregationFunctionCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getSumFieldBuilder().getBuilder(), extensionRegistry);
                aggregationFunctionCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getHistogramFieldBuilder().getBuilder(), extensionRegistry);
                aggregationFunctionCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getFrequencyFieldBuilder().getBuilder(), extensionRegistry);
                aggregationFunctionCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int aggregationFunctionCase_ = 0;
    private java.lang.Object aggregationFunction_;

    public AggregationFunctionCase getAggregationFunctionCase() {
      return AggregationFunctionCase.forNumber(aggregationFunctionCase_);
    }

    public Builder clearAggregationFunction() {
      aggregationFunctionCase_ = 0;
      aggregationFunction_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object field_ = "";
    /**
     *
     *
     * <pre>
     * The name of the field on which to aggregate.
     * </pre>
     *
     * <code>string field = 1;</code>
     *
     * @return The field.
     */
    public java.lang.String getField() {
      java.lang.Object ref = field_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        field_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the field on which to aggregate.
     * </pre>
     *
     * <code>string field = 1;</code>
     *
     * @return The bytes for field.
     */
    public com.google.protobuf.ByteString getFieldBytes() {
      java.lang.Object ref = field_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        field_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the field on which to aggregate.
     * </pre>
     *
     * <code>string field = 1;</code>
     *
     * @param value The field to set.
     * @return This builder for chaining.
     */
    public Builder setField(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      field_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the field on which to aggregate.
     * </pre>
     *
     * <code>string field = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearField() {
      field_ = getDefaultInstance().getField();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the field on which to aggregate.
     * </pre>
     *
     * <code>string field = 1;</code>
     *
     * @param value The bytes for field to set.
     * @return This builder for chaining.
     */
    public Builder setFieldBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      field_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.Aggregation.Count,
            com.google.cloud.migrationcenter.v1.Aggregation.Count.Builder,
            com.google.cloud.migrationcenter.v1.Aggregation.CountOrBuilder>
        countBuilder_;
    /**
     *
     *
     * <pre>
     * Count the number of matching objects.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Count count = 2;</code>
     *
     * @return Whether the count field is set.
     */
    @java.lang.Override
    public boolean hasCount() {
      return aggregationFunctionCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Count the number of matching objects.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Count count = 2;</code>
     *
     * @return The count.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.Aggregation.Count getCount() {
      if (countBuilder_ == null) {
        if (aggregationFunctionCase_ == 2) {
          return (com.google.cloud.migrationcenter.v1.Aggregation.Count) aggregationFunction_;
        }
        return com.google.cloud.migrationcenter.v1.Aggregation.Count.getDefaultInstance();
      } else {
        if (aggregationFunctionCase_ == 2) {
          return countBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.Aggregation.Count.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Count the number of matching objects.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Count count = 2;</code>
     */
    public Builder setCount(com.google.cloud.migrationcenter.v1.Aggregation.Count value) {
      if (countBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        aggregationFunction_ = value;
        onChanged();
      } else {
        countBuilder_.setMessage(value);
      }
      aggregationFunctionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Count the number of matching objects.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Count count = 2;</code>
     */
    public Builder setCount(
        com.google.cloud.migrationcenter.v1.Aggregation.Count.Builder builderForValue) {
      if (countBuilder_ == null) {
        aggregationFunction_ = builderForValue.build();
        onChanged();
      } else {
        countBuilder_.setMessage(builderForValue.build());
      }
      aggregationFunctionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Count the number of matching objects.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Count count = 2;</code>
     */
    public Builder mergeCount(com.google.cloud.migrationcenter.v1.Aggregation.Count value) {
      if (countBuilder_ == null) {
        if (aggregationFunctionCase_ == 2
            && aggregationFunction_
                != com.google.cloud.migrationcenter.v1.Aggregation.Count.getDefaultInstance()) {
          aggregationFunction_ =
              com.google.cloud.migrationcenter.v1.Aggregation.Count.newBuilder(
                      (com.google.cloud.migrationcenter.v1.Aggregation.Count) aggregationFunction_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          aggregationFunction_ = value;
        }
        onChanged();
      } else {
        if (aggregationFunctionCase_ == 2) {
          countBuilder_.mergeFrom(value);
        } else {
          countBuilder_.setMessage(value);
        }
      }
      aggregationFunctionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Count the number of matching objects.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Count count = 2;</code>
     */
    public Builder clearCount() {
      if (countBuilder_ == null) {
        if (aggregationFunctionCase_ == 2) {
          aggregationFunctionCase_ = 0;
          aggregationFunction_ = null;
          onChanged();
        }
      } else {
        if (aggregationFunctionCase_ == 2) {
          aggregationFunctionCase_ = 0;
          aggregationFunction_ = null;
        }
        countBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Count the number of matching objects.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Count count = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.Aggregation.Count.Builder getCountBuilder() {
      return getCountFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Count the number of matching objects.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Count count = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.Aggregation.CountOrBuilder getCountOrBuilder() {
      if ((aggregationFunctionCase_ == 2) && (countBuilder_ != null)) {
        return countBuilder_.getMessageOrBuilder();
      } else {
        if (aggregationFunctionCase_ == 2) {
          return (com.google.cloud.migrationcenter.v1.Aggregation.Count) aggregationFunction_;
        }
        return com.google.cloud.migrationcenter.v1.Aggregation.Count.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Count the number of matching objects.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Count count = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.Aggregation.Count,
            com.google.cloud.migrationcenter.v1.Aggregation.Count.Builder,
            com.google.cloud.migrationcenter.v1.Aggregation.CountOrBuilder>
        getCountFieldBuilder() {
      if (countBuilder_ == null) {
        if (!(aggregationFunctionCase_ == 2)) {
          aggregationFunction_ =
              com.google.cloud.migrationcenter.v1.Aggregation.Count.getDefaultInstance();
        }
        countBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.Aggregation.Count,
                com.google.cloud.migrationcenter.v1.Aggregation.Count.Builder,
                com.google.cloud.migrationcenter.v1.Aggregation.CountOrBuilder>(
                (com.google.cloud.migrationcenter.v1.Aggregation.Count) aggregationFunction_,
                getParentForChildren(),
                isClean());
        aggregationFunction_ = null;
      }
      aggregationFunctionCase_ = 2;
      onChanged();
      return countBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.Aggregation.Sum,
            com.google.cloud.migrationcenter.v1.Aggregation.Sum.Builder,
            com.google.cloud.migrationcenter.v1.Aggregation.SumOrBuilder>
        sumBuilder_;
    /**
     *
     *
     * <pre>
     * Sum over a numeric field.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Sum sum = 3;</code>
     *
     * @return Whether the sum field is set.
     */
    @java.lang.Override
    public boolean hasSum() {
      return aggregationFunctionCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Sum over a numeric field.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Sum sum = 3;</code>
     *
     * @return The sum.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.Aggregation.Sum getSum() {
      if (sumBuilder_ == null) {
        if (aggregationFunctionCase_ == 3) {
          return (com.google.cloud.migrationcenter.v1.Aggregation.Sum) aggregationFunction_;
        }
        return com.google.cloud.migrationcenter.v1.Aggregation.Sum.getDefaultInstance();
      } else {
        if (aggregationFunctionCase_ == 3) {
          return sumBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.Aggregation.Sum.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Sum over a numeric field.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Sum sum = 3;</code>
     */
    public Builder setSum(com.google.cloud.migrationcenter.v1.Aggregation.Sum value) {
      if (sumBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        aggregationFunction_ = value;
        onChanged();
      } else {
        sumBuilder_.setMessage(value);
      }
      aggregationFunctionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sum over a numeric field.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Sum sum = 3;</code>
     */
    public Builder setSum(
        com.google.cloud.migrationcenter.v1.Aggregation.Sum.Builder builderForValue) {
      if (sumBuilder_ == null) {
        aggregationFunction_ = builderForValue.build();
        onChanged();
      } else {
        sumBuilder_.setMessage(builderForValue.build());
      }
      aggregationFunctionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sum over a numeric field.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Sum sum = 3;</code>
     */
    public Builder mergeSum(com.google.cloud.migrationcenter.v1.Aggregation.Sum value) {
      if (sumBuilder_ == null) {
        if (aggregationFunctionCase_ == 3
            && aggregationFunction_
                != com.google.cloud.migrationcenter.v1.Aggregation.Sum.getDefaultInstance()) {
          aggregationFunction_ =
              com.google.cloud.migrationcenter.v1.Aggregation.Sum.newBuilder(
                      (com.google.cloud.migrationcenter.v1.Aggregation.Sum) aggregationFunction_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          aggregationFunction_ = value;
        }
        onChanged();
      } else {
        if (aggregationFunctionCase_ == 3) {
          sumBuilder_.mergeFrom(value);
        } else {
          sumBuilder_.setMessage(value);
        }
      }
      aggregationFunctionCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sum over a numeric field.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Sum sum = 3;</code>
     */
    public Builder clearSum() {
      if (sumBuilder_ == null) {
        if (aggregationFunctionCase_ == 3) {
          aggregationFunctionCase_ = 0;
          aggregationFunction_ = null;
          onChanged();
        }
      } else {
        if (aggregationFunctionCase_ == 3) {
          aggregationFunctionCase_ = 0;
          aggregationFunction_ = null;
        }
        sumBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sum over a numeric field.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Sum sum = 3;</code>
     */
    public com.google.cloud.migrationcenter.v1.Aggregation.Sum.Builder getSumBuilder() {
      return getSumFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Sum over a numeric field.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Sum sum = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.Aggregation.SumOrBuilder getSumOrBuilder() {
      if ((aggregationFunctionCase_ == 3) && (sumBuilder_ != null)) {
        return sumBuilder_.getMessageOrBuilder();
      } else {
        if (aggregationFunctionCase_ == 3) {
          return (com.google.cloud.migrationcenter.v1.Aggregation.Sum) aggregationFunction_;
        }
        return com.google.cloud.migrationcenter.v1.Aggregation.Sum.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Sum over a numeric field.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Sum sum = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.Aggregation.Sum,
            com.google.cloud.migrationcenter.v1.Aggregation.Sum.Builder,
            com.google.cloud.migrationcenter.v1.Aggregation.SumOrBuilder>
        getSumFieldBuilder() {
      if (sumBuilder_ == null) {
        if (!(aggregationFunctionCase_ == 3)) {
          aggregationFunction_ =
              com.google.cloud.migrationcenter.v1.Aggregation.Sum.getDefaultInstance();
        }
        sumBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.Aggregation.Sum,
                com.google.cloud.migrationcenter.v1.Aggregation.Sum.Builder,
                com.google.cloud.migrationcenter.v1.Aggregation.SumOrBuilder>(
                (com.google.cloud.migrationcenter.v1.Aggregation.Sum) aggregationFunction_,
                getParentForChildren(),
                isClean());
        aggregationFunction_ = null;
      }
      aggregationFunctionCase_ = 3;
      onChanged();
      return sumBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.Aggregation.Histogram,
            com.google.cloud.migrationcenter.v1.Aggregation.Histogram.Builder,
            com.google.cloud.migrationcenter.v1.Aggregation.HistogramOrBuilder>
        histogramBuilder_;
    /**
     *
     *
     * <pre>
     * Creates a bucketed histogram of field values.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Histogram histogram = 4;</code>
     *
     * @return Whether the histogram field is set.
     */
    @java.lang.Override
    public boolean hasHistogram() {
      return aggregationFunctionCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Creates a bucketed histogram of field values.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Histogram histogram = 4;</code>
     *
     * @return The histogram.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.Aggregation.Histogram getHistogram() {
      if (histogramBuilder_ == null) {
        if (aggregationFunctionCase_ == 4) {
          return (com.google.cloud.migrationcenter.v1.Aggregation.Histogram) aggregationFunction_;
        }
        return com.google.cloud.migrationcenter.v1.Aggregation.Histogram.getDefaultInstance();
      } else {
        if (aggregationFunctionCase_ == 4) {
          return histogramBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.Aggregation.Histogram.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Creates a bucketed histogram of field values.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Histogram histogram = 4;</code>
     */
    public Builder setHistogram(com.google.cloud.migrationcenter.v1.Aggregation.Histogram value) {
      if (histogramBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        aggregationFunction_ = value;
        onChanged();
      } else {
        histogramBuilder_.setMessage(value);
      }
      aggregationFunctionCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Creates a bucketed histogram of field values.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Histogram histogram = 4;</code>
     */
    public Builder setHistogram(
        com.google.cloud.migrationcenter.v1.Aggregation.Histogram.Builder builderForValue) {
      if (histogramBuilder_ == null) {
        aggregationFunction_ = builderForValue.build();
        onChanged();
      } else {
        histogramBuilder_.setMessage(builderForValue.build());
      }
      aggregationFunctionCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Creates a bucketed histogram of field values.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Histogram histogram = 4;</code>
     */
    public Builder mergeHistogram(com.google.cloud.migrationcenter.v1.Aggregation.Histogram value) {
      if (histogramBuilder_ == null) {
        if (aggregationFunctionCase_ == 4
            && aggregationFunction_
                != com.google.cloud.migrationcenter.v1.Aggregation.Histogram.getDefaultInstance()) {
          aggregationFunction_ =
              com.google.cloud.migrationcenter.v1.Aggregation.Histogram.newBuilder(
                      (com.google.cloud.migrationcenter.v1.Aggregation.Histogram)
                          aggregationFunction_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          aggregationFunction_ = value;
        }
        onChanged();
      } else {
        if (aggregationFunctionCase_ == 4) {
          histogramBuilder_.mergeFrom(value);
        } else {
          histogramBuilder_.setMessage(value);
        }
      }
      aggregationFunctionCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Creates a bucketed histogram of field values.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Histogram histogram = 4;</code>
     */
    public Builder clearHistogram() {
      if (histogramBuilder_ == null) {
        if (aggregationFunctionCase_ == 4) {
          aggregationFunctionCase_ = 0;
          aggregationFunction_ = null;
          onChanged();
        }
      } else {
        if (aggregationFunctionCase_ == 4) {
          aggregationFunctionCase_ = 0;
          aggregationFunction_ = null;
        }
        histogramBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Creates a bucketed histogram of field values.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Histogram histogram = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.Aggregation.Histogram.Builder getHistogramBuilder() {
      return getHistogramFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Creates a bucketed histogram of field values.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Histogram histogram = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.Aggregation.HistogramOrBuilder
        getHistogramOrBuilder() {
      if ((aggregationFunctionCase_ == 4) && (histogramBuilder_ != null)) {
        return histogramBuilder_.getMessageOrBuilder();
      } else {
        if (aggregationFunctionCase_ == 4) {
          return (com.google.cloud.migrationcenter.v1.Aggregation.Histogram) aggregationFunction_;
        }
        return com.google.cloud.migrationcenter.v1.Aggregation.Histogram.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Creates a bucketed histogram of field values.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Histogram histogram = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.Aggregation.Histogram,
            com.google.cloud.migrationcenter.v1.Aggregation.Histogram.Builder,
            com.google.cloud.migrationcenter.v1.Aggregation.HistogramOrBuilder>
        getHistogramFieldBuilder() {
      if (histogramBuilder_ == null) {
        if (!(aggregationFunctionCase_ == 4)) {
          aggregationFunction_ =
              com.google.cloud.migrationcenter.v1.Aggregation.Histogram.getDefaultInstance();
        }
        histogramBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.Aggregation.Histogram,
                com.google.cloud.migrationcenter.v1.Aggregation.Histogram.Builder,
                com.google.cloud.migrationcenter.v1.Aggregation.HistogramOrBuilder>(
                (com.google.cloud.migrationcenter.v1.Aggregation.Histogram) aggregationFunction_,
                getParentForChildren(),
                isClean());
        aggregationFunction_ = null;
      }
      aggregationFunctionCase_ = 4;
      onChanged();
      return histogramBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.Aggregation.Frequency,
            com.google.cloud.migrationcenter.v1.Aggregation.Frequency.Builder,
            com.google.cloud.migrationcenter.v1.Aggregation.FrequencyOrBuilder>
        frequencyBuilder_;
    /**
     *
     *
     * <pre>
     * Creates a frequency distribution of all field values.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Frequency frequency = 5;</code>
     *
     * @return Whether the frequency field is set.
     */
    @java.lang.Override
    public boolean hasFrequency() {
      return aggregationFunctionCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Creates a frequency distribution of all field values.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Frequency frequency = 5;</code>
     *
     * @return The frequency.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.Aggregation.Frequency getFrequency() {
      if (frequencyBuilder_ == null) {
        if (aggregationFunctionCase_ == 5) {
          return (com.google.cloud.migrationcenter.v1.Aggregation.Frequency) aggregationFunction_;
        }
        return com.google.cloud.migrationcenter.v1.Aggregation.Frequency.getDefaultInstance();
      } else {
        if (aggregationFunctionCase_ == 5) {
          return frequencyBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.Aggregation.Frequency.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Creates a frequency distribution of all field values.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Frequency frequency = 5;</code>
     */
    public Builder setFrequency(com.google.cloud.migrationcenter.v1.Aggregation.Frequency value) {
      if (frequencyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        aggregationFunction_ = value;
        onChanged();
      } else {
        frequencyBuilder_.setMessage(value);
      }
      aggregationFunctionCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Creates a frequency distribution of all field values.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Frequency frequency = 5;</code>
     */
    public Builder setFrequency(
        com.google.cloud.migrationcenter.v1.Aggregation.Frequency.Builder builderForValue) {
      if (frequencyBuilder_ == null) {
        aggregationFunction_ = builderForValue.build();
        onChanged();
      } else {
        frequencyBuilder_.setMessage(builderForValue.build());
      }
      aggregationFunctionCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Creates a frequency distribution of all field values.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Frequency frequency = 5;</code>
     */
    public Builder mergeFrequency(com.google.cloud.migrationcenter.v1.Aggregation.Frequency value) {
      if (frequencyBuilder_ == null) {
        if (aggregationFunctionCase_ == 5
            && aggregationFunction_
                != com.google.cloud.migrationcenter.v1.Aggregation.Frequency.getDefaultInstance()) {
          aggregationFunction_ =
              com.google.cloud.migrationcenter.v1.Aggregation.Frequency.newBuilder(
                      (com.google.cloud.migrationcenter.v1.Aggregation.Frequency)
                          aggregationFunction_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          aggregationFunction_ = value;
        }
        onChanged();
      } else {
        if (aggregationFunctionCase_ == 5) {
          frequencyBuilder_.mergeFrom(value);
        } else {
          frequencyBuilder_.setMessage(value);
        }
      }
      aggregationFunctionCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Creates a frequency distribution of all field values.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Frequency frequency = 5;</code>
     */
    public Builder clearFrequency() {
      if (frequencyBuilder_ == null) {
        if (aggregationFunctionCase_ == 5) {
          aggregationFunctionCase_ = 0;
          aggregationFunction_ = null;
          onChanged();
        }
      } else {
        if (aggregationFunctionCase_ == 5) {
          aggregationFunctionCase_ = 0;
          aggregationFunction_ = null;
        }
        frequencyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Creates a frequency distribution of all field values.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Frequency frequency = 5;</code>
     */
    public com.google.cloud.migrationcenter.v1.Aggregation.Frequency.Builder getFrequencyBuilder() {
      return getFrequencyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Creates a frequency distribution of all field values.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Frequency frequency = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.Aggregation.FrequencyOrBuilder
        getFrequencyOrBuilder() {
      if ((aggregationFunctionCase_ == 5) && (frequencyBuilder_ != null)) {
        return frequencyBuilder_.getMessageOrBuilder();
      } else {
        if (aggregationFunctionCase_ == 5) {
          return (com.google.cloud.migrationcenter.v1.Aggregation.Frequency) aggregationFunction_;
        }
        return com.google.cloud.migrationcenter.v1.Aggregation.Frequency.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Creates a frequency distribution of all field values.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.Aggregation.Frequency frequency = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.Aggregation.Frequency,
            com.google.cloud.migrationcenter.v1.Aggregation.Frequency.Builder,
            com.google.cloud.migrationcenter.v1.Aggregation.FrequencyOrBuilder>
        getFrequencyFieldBuilder() {
      if (frequencyBuilder_ == null) {
        if (!(aggregationFunctionCase_ == 5)) {
          aggregationFunction_ =
              com.google.cloud.migrationcenter.v1.Aggregation.Frequency.getDefaultInstance();
        }
        frequencyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.Aggregation.Frequency,
                com.google.cloud.migrationcenter.v1.Aggregation.Frequency.Builder,
                com.google.cloud.migrationcenter.v1.Aggregation.FrequencyOrBuilder>(
                (com.google.cloud.migrationcenter.v1.Aggregation.Frequency) aggregationFunction_,
                getParentForChildren(),
                isClean());
        aggregationFunction_ = null;
      }
      aggregationFunctionCase_ = 5;
      onChanged();
      return frequencyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.Aggregation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.Aggregation)
  private static final com.google.cloud.migrationcenter.v1.Aggregation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.Aggregation();
  }

  public static com.google.cloud.migrationcenter.v1.Aggregation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Aggregation> PARSER =
      new com.google.protobuf.AbstractParser<Aggregation>() {
        @java.lang.Override
        public Aggregation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Aggregation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Aggregation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.Aggregation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
