/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * Message describing a result of an aggregation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.AggregationResult}
 */
public final class AggregationResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.AggregationResult)
    AggregationResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AggregationResult.newBuilder() to construct.
  private AggregationResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AggregationResult() {
    field_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AggregationResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_AggregationResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_AggregationResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.AggregationResult.class,
            com.google.cloud.migrationcenter.v1.AggregationResult.Builder.class);
  }

  public interface CountOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.AggregationResult.Count)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>int64 value = 1;</code>
     *
     * @return The value.
     */
    long getValue();
  }
  /**
   *
   *
   * <pre>
   * The result of a count aggregation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.AggregationResult.Count}
   */
  public static final class Count extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.AggregationResult.Count)
      CountOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Count.newBuilder() to construct.
    private Count(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Count() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Count();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Count_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Count_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.AggregationResult.Count.class,
              com.google.cloud.migrationcenter.v1.AggregationResult.Count.Builder.class);
    }

    public static final int VALUE_FIELD_NUMBER = 1;
    private long value_ = 0L;
    /**
     * <code>int64 value = 1;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public long getValue() {
      return value_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (value_ != 0L) {
        output.writeInt64(1, value_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (value_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.migrationcenter.v1.AggregationResult.Count)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.AggregationResult.Count other =
          (com.google.cloud.migrationcenter.v1.AggregationResult.Count) obj;

      if (getValue() != other.getValue()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getValue());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Count parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Count parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Count parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Count parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Count parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Count parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Count parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Count parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Count parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Count parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Count parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Count parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.AggregationResult.Count prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The result of a count aggregation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.AggregationResult.Count}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.AggregationResult.Count)
        com.google.cloud.migrationcenter.v1.AggregationResult.CountOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Count_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Count_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.AggregationResult.Count.class,
                com.google.cloud.migrationcenter.v1.AggregationResult.Count.Builder.class);
      }

      // Construct using com.google.cloud.migrationcenter.v1.AggregationResult.Count.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        value_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Count_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.AggregationResult.Count
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.AggregationResult.Count.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.AggregationResult.Count build() {
        com.google.cloud.migrationcenter.v1.AggregationResult.Count result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.AggregationResult.Count buildPartial() {
        com.google.cloud.migrationcenter.v1.AggregationResult.Count result =
            new com.google.cloud.migrationcenter.v1.AggregationResult.Count(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.AggregationResult.Count result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.value_ = value_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.migrationcenter.v1.AggregationResult.Count) {
          return mergeFrom((com.google.cloud.migrationcenter.v1.AggregationResult.Count) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.migrationcenter.v1.AggregationResult.Count other) {
        if (other
            == com.google.cloud.migrationcenter.v1.AggregationResult.Count.getDefaultInstance())
          return this;
        if (other.getValue() != 0L) {
          setValue(other.getValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  value_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long value_;
      /**
       * <code>int64 value = 1;</code>
       *
       * @return The value.
       */
      @java.lang.Override
      public long getValue() {
        return value_;
      }
      /**
       * <code>int64 value = 1;</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(long value) {

        value_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>int64 value = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        bitField0_ = (bitField0_ & ~0x00000001);
        value_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.AggregationResult.Count)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.AggregationResult.Count)
    private static final com.google.cloud.migrationcenter.v1.AggregationResult.Count
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.AggregationResult.Count();
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Count getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Count> PARSER =
        new com.google.protobuf.AbstractParser<Count>() {
          @java.lang.Override
          public Count parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Count> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Count> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregationResult.Count getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SumOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.AggregationResult.Sum)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>double value = 1;</code>
     *
     * @return The value.
     */
    double getValue();
  }
  /**
   *
   *
   * <pre>
   * The result of a sum aggregation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.AggregationResult.Sum}
   */
  public static final class Sum extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.AggregationResult.Sum)
      SumOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Sum.newBuilder() to construct.
    private Sum(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Sum() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Sum();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Sum_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Sum_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.AggregationResult.Sum.class,
              com.google.cloud.migrationcenter.v1.AggregationResult.Sum.Builder.class);
    }

    public static final int VALUE_FIELD_NUMBER = 1;
    private double value_ = 0D;
    /**
     * <code>double value = 1;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public double getValue() {
      return value_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Double.doubleToRawLongBits(value_) != 0) {
        output.writeDouble(1, value_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Double.doubleToRawLongBits(value_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.migrationcenter.v1.AggregationResult.Sum)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.AggregationResult.Sum other =
          (com.google.cloud.migrationcenter.v1.AggregationResult.Sum) obj;

      if (java.lang.Double.doubleToLongBits(getValue())
          != java.lang.Double.doubleToLongBits(other.getValue())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getValue()));
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Sum parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Sum parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Sum parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Sum parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Sum parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Sum parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Sum parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Sum parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Sum parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Sum parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Sum parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Sum parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.AggregationResult.Sum prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The result of a sum aggregation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.AggregationResult.Sum}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.AggregationResult.Sum)
        com.google.cloud.migrationcenter.v1.AggregationResult.SumOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Sum_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Sum_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.AggregationResult.Sum.class,
                com.google.cloud.migrationcenter.v1.AggregationResult.Sum.Builder.class);
      }

      // Construct using com.google.cloud.migrationcenter.v1.AggregationResult.Sum.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        value_ = 0D;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Sum_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.AggregationResult.Sum getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.AggregationResult.Sum.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.AggregationResult.Sum build() {
        com.google.cloud.migrationcenter.v1.AggregationResult.Sum result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.AggregationResult.Sum buildPartial() {
        com.google.cloud.migrationcenter.v1.AggregationResult.Sum result =
            new com.google.cloud.migrationcenter.v1.AggregationResult.Sum(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.migrationcenter.v1.AggregationResult.Sum result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.value_ = value_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.migrationcenter.v1.AggregationResult.Sum) {
          return mergeFrom((com.google.cloud.migrationcenter.v1.AggregationResult.Sum) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.migrationcenter.v1.AggregationResult.Sum other) {
        if (other == com.google.cloud.migrationcenter.v1.AggregationResult.Sum.getDefaultInstance())
          return this;
        if (other.getValue() != 0D) {
          setValue(other.getValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  value_ = input.readDouble();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 9
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private double value_;
      /**
       * <code>double value = 1;</code>
       *
       * @return The value.
       */
      @java.lang.Override
      public double getValue() {
        return value_;
      }
      /**
       * <code>double value = 1;</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(double value) {

        value_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <code>double value = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        bitField0_ = (bitField0_ & ~0x00000001);
        value_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.AggregationResult.Sum)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.AggregationResult.Sum)
    private static final com.google.cloud.migrationcenter.v1.AggregationResult.Sum DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.AggregationResult.Sum();
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Sum getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Sum> PARSER =
        new com.google.protobuf.AbstractParser<Sum>() {
          @java.lang.Override
          public Sum parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Sum> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Sum> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregationResult.Sum getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface HistogramOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.AggregationResult.Histogram)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
     * </code>
     */
    java.util.List<com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket>
        getBucketsList();
    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket getBuckets(int index);
    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
     * </code>
     */
    int getBucketsCount();
    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.BucketOrBuilder>
        getBucketsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.BucketOrBuilder
        getBucketsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * The result of a bucketed histogram aggregation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.AggregationResult.Histogram}
   */
  public static final class Histogram extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.AggregationResult.Histogram)
      HistogramOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Histogram.newBuilder() to construct.
    private Histogram(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Histogram() {
      buckets_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Histogram();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Histogram_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Histogram_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.class,
              com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Builder.class);
    }

    public interface BucketOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Lower bound - inclusive.
       * </pre>
       *
       * <code>double lower_bound = 1;</code>
       *
       * @return The lowerBound.
       */
      double getLowerBound();

      /**
       *
       *
       * <pre>
       * Upper bound - exclusive.
       * </pre>
       *
       * <code>double upper_bound = 2;</code>
       *
       * @return The upperBound.
       */
      double getUpperBound();

      /**
       *
       *
       * <pre>
       * Count of items in the bucket.
       * </pre>
       *
       * <code>int64 count = 3;</code>
       *
       * @return The count.
       */
      long getCount();
    }
    /**
     *
     *
     * <pre>
     * A histogram bucket with a lower and upper bound, and a count of items
     * with a field value between those bounds.
     * The lower bound is inclusive and the upper bound is exclusive.
     * Lower bound may be -infinity and upper bound may be infinity.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket}
     */
    public static final class Bucket extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket)
        BucketOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Bucket.newBuilder() to construct.
      private Bucket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Bucket() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Bucket();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Histogram_Bucket_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Histogram_Bucket_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket.class,
                com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket.Builder
                    .class);
      }

      public static final int LOWER_BOUND_FIELD_NUMBER = 1;
      private double lowerBound_ = 0D;
      /**
       *
       *
       * <pre>
       * Lower bound - inclusive.
       * </pre>
       *
       * <code>double lower_bound = 1;</code>
       *
       * @return The lowerBound.
       */
      @java.lang.Override
      public double getLowerBound() {
        return lowerBound_;
      }

      public static final int UPPER_BOUND_FIELD_NUMBER = 2;
      private double upperBound_ = 0D;
      /**
       *
       *
       * <pre>
       * Upper bound - exclusive.
       * </pre>
       *
       * <code>double upper_bound = 2;</code>
       *
       * @return The upperBound.
       */
      @java.lang.Override
      public double getUpperBound() {
        return upperBound_;
      }

      public static final int COUNT_FIELD_NUMBER = 3;
      private long count_ = 0L;
      /**
       *
       *
       * <pre>
       * Count of items in the bucket.
       * </pre>
       *
       * <code>int64 count = 3;</code>
       *
       * @return The count.
       */
      @java.lang.Override
      public long getCount() {
        return count_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (java.lang.Double.doubleToRawLongBits(lowerBound_) != 0) {
          output.writeDouble(1, lowerBound_);
        }
        if (java.lang.Double.doubleToRawLongBits(upperBound_) != 0) {
          output.writeDouble(2, upperBound_);
        }
        if (count_ != 0L) {
          output.writeInt64(3, count_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (java.lang.Double.doubleToRawLongBits(lowerBound_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, lowerBound_);
        }
        if (java.lang.Double.doubleToRawLongBits(upperBound_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, upperBound_);
        }
        if (count_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, count_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket)) {
          return super.equals(obj);
        }
        com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket other =
            (com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket) obj;

        if (java.lang.Double.doubleToLongBits(getLowerBound())
            != java.lang.Double.doubleToLongBits(other.getLowerBound())) return false;
        if (java.lang.Double.doubleToLongBits(getUpperBound())
            != java.lang.Double.doubleToLongBits(other.getUpperBound())) return false;
        if (getCount() != other.getCount()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + LOWER_BOUND_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getLowerBound()));
        hash = (37 * hash) + UPPER_BOUND_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getUpperBound()));
        hash = (37 * hash) + COUNT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCount());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A histogram bucket with a lower and upper bound, and a count of items
       * with a field value between those bounds.
       * The lower bound is inclusive and the upper bound is exclusive.
       * Lower bound may be -infinity and upper bound may be infinity.
       * </pre>
       *
       * Protobuf type {@code google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket)
          com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.BucketOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.migrationcenter.v1.MigrationCenterProto
              .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Histogram_Bucket_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.migrationcenter.v1.MigrationCenterProto
              .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Histogram_Bucket_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket.class,
                  com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          lowerBound_ = 0D;
          upperBound_ = 0D;
          count_ = 0L;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.migrationcenter.v1.MigrationCenterProto
              .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Histogram_Bucket_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
            getDefaultInstanceForType() {
          return com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket build() {
          com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
            buildPartial() {
          com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket result =
              new com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.lowerBound_ = lowerBound_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.upperBound_ = upperBound_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.count_ = count_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket) {
            return mergeFrom(
                (com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket other) {
          if (other
              == com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
                  .getDefaultInstance()) return this;
          if (other.getLowerBound() != 0D) {
            setLowerBound(other.getLowerBound());
          }
          if (other.getUpperBound() != 0D) {
            setUpperBound(other.getUpperBound());
          }
          if (other.getCount() != 0L) {
            setCount(other.getCount());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 9:
                  {
                    lowerBound_ = input.readDouble();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 9
                case 17:
                  {
                    upperBound_ = input.readDouble();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 17
                case 24:
                  {
                    count_ = input.readInt64();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private double lowerBound_;
        /**
         *
         *
         * <pre>
         * Lower bound - inclusive.
         * </pre>
         *
         * <code>double lower_bound = 1;</code>
         *
         * @return The lowerBound.
         */
        @java.lang.Override
        public double getLowerBound() {
          return lowerBound_;
        }
        /**
         *
         *
         * <pre>
         * Lower bound - inclusive.
         * </pre>
         *
         * <code>double lower_bound = 1;</code>
         *
         * @param value The lowerBound to set.
         * @return This builder for chaining.
         */
        public Builder setLowerBound(double value) {

          lowerBound_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Lower bound - inclusive.
         * </pre>
         *
         * <code>double lower_bound = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLowerBound() {
          bitField0_ = (bitField0_ & ~0x00000001);
          lowerBound_ = 0D;
          onChanged();
          return this;
        }

        private double upperBound_;
        /**
         *
         *
         * <pre>
         * Upper bound - exclusive.
         * </pre>
         *
         * <code>double upper_bound = 2;</code>
         *
         * @return The upperBound.
         */
        @java.lang.Override
        public double getUpperBound() {
          return upperBound_;
        }
        /**
         *
         *
         * <pre>
         * Upper bound - exclusive.
         * </pre>
         *
         * <code>double upper_bound = 2;</code>
         *
         * @param value The upperBound to set.
         * @return This builder for chaining.
         */
        public Builder setUpperBound(double value) {

          upperBound_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Upper bound - exclusive.
         * </pre>
         *
         * <code>double upper_bound = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearUpperBound() {
          bitField0_ = (bitField0_ & ~0x00000002);
          upperBound_ = 0D;
          onChanged();
          return this;
        }

        private long count_;
        /**
         *
         *
         * <pre>
         * Count of items in the bucket.
         * </pre>
         *
         * <code>int64 count = 3;</code>
         *
         * @return The count.
         */
        @java.lang.Override
        public long getCount() {
          return count_;
        }
        /**
         *
         *
         * <pre>
         * Count of items in the bucket.
         * </pre>
         *
         * <code>int64 count = 3;</code>
         *
         * @param value The count to set.
         * @return This builder for chaining.
         */
        public Builder setCount(long value) {

          count_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Count of items in the bucket.
         * </pre>
         *
         * <code>int64 count = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearCount() {
          bitField0_ = (bitField0_ & ~0x00000004);
          count_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket)
      private static final com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket();
      }

      public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Bucket> PARSER =
          new com.google.protobuf.AbstractParser<Bucket>() {
            @java.lang.Override
            public Bucket parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Bucket> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Bucket> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int BUCKETS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket>
        buckets_;
    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket>
        getBucketsList() {
      return buckets_;
    }
    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.BucketOrBuilder>
        getBucketsOrBuilderList() {
      return buckets_;
    }
    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
     * </code>
     */
    @java.lang.Override
    public int getBucketsCount() {
      return buckets_.size();
    }
    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket getBuckets(
        int index) {
      return buckets_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Buckets in the histogram.
     * There will be `n+1` buckets matching `n` lower bounds in the request.
     * The first bucket will be from -infinity to the first bound.
     * Subsequent buckets will be between one bound and the next.
     * The final bucket will be from the final bound to infinity.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.BucketOrBuilder
        getBucketsOrBuilder(int index) {
      return buckets_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < buckets_.size(); i++) {
        output.writeMessage(1, buckets_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < buckets_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, buckets_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.migrationcenter.v1.AggregationResult.Histogram)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.AggregationResult.Histogram other =
          (com.google.cloud.migrationcenter.v1.AggregationResult.Histogram) obj;

      if (!getBucketsList().equals(other.getBucketsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getBucketsCount() > 0) {
        hash = (37 * hash) + BUCKETS_FIELD_NUMBER;
        hash = (53 * hash) + getBucketsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.AggregationResult.Histogram prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The result of a bucketed histogram aggregation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.AggregationResult.Histogram}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.AggregationResult.Histogram)
        com.google.cloud.migrationcenter.v1.AggregationResult.HistogramOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Histogram_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Histogram_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.class,
                com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Builder.class);
      }

      // Construct using
      // com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (bucketsBuilder_ == null) {
          buckets_ = java.util.Collections.emptyList();
        } else {
          buckets_ = null;
          bucketsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Histogram_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.AggregationResult.Histogram
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.AggregationResult.Histogram build() {
        com.google.cloud.migrationcenter.v1.AggregationResult.Histogram result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.AggregationResult.Histogram buildPartial() {
        com.google.cloud.migrationcenter.v1.AggregationResult.Histogram result =
            new com.google.cloud.migrationcenter.v1.AggregationResult.Histogram(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.migrationcenter.v1.AggregationResult.Histogram result) {
        if (bucketsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            buckets_ = java.util.Collections.unmodifiableList(buckets_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.buckets_ = buckets_;
        } else {
          result.buckets_ = bucketsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.AggregationResult.Histogram result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.migrationcenter.v1.AggregationResult.Histogram) {
          return mergeFrom((com.google.cloud.migrationcenter.v1.AggregationResult.Histogram) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.AggregationResult.Histogram other) {
        if (other
            == com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.getDefaultInstance())
          return this;
        if (bucketsBuilder_ == null) {
          if (!other.buckets_.isEmpty()) {
            if (buckets_.isEmpty()) {
              buckets_ = other.buckets_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureBucketsIsMutable();
              buckets_.addAll(other.buckets_);
            }
            onChanged();
          }
        } else {
          if (!other.buckets_.isEmpty()) {
            if (bucketsBuilder_.isEmpty()) {
              bucketsBuilder_.dispose();
              bucketsBuilder_ = null;
              buckets_ = other.buckets_;
              bitField0_ = (bitField0_ & ~0x00000001);
              bucketsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getBucketsFieldBuilder()
                      : null;
            } else {
              bucketsBuilder_.addAllMessages(other.buckets_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket m =
                      input.readMessage(
                          com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
                              .parser(),
                          extensionRegistry);
                  if (bucketsBuilder_ == null) {
                    ensureBucketsIsMutable();
                    buckets_.add(m);
                  } else {
                    bucketsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket>
          buckets_ = java.util.Collections.emptyList();

      private void ensureBucketsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          buckets_ =
              new java.util.ArrayList<
                  com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket>(buckets_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket,
              com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket.Builder,
              com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.BucketOrBuilder>
          bucketsBuilder_;

      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
       * </code>
       */
      public java.util.List<com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket>
          getBucketsList() {
        if (bucketsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(buckets_);
        } else {
          return bucketsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
       * </code>
       */
      public int getBucketsCount() {
        if (bucketsBuilder_ == null) {
          return buckets_.size();
        } else {
          return bucketsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket getBuckets(
          int index) {
        if (bucketsBuilder_ == null) {
          return buckets_.get(index);
        } else {
          return bucketsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
       * </code>
       */
      public Builder setBuckets(
          int index, com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket value) {
        if (bucketsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBucketsIsMutable();
          buckets_.set(index, value);
          onChanged();
        } else {
          bucketsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
       * </code>
       */
      public Builder setBuckets(
          int index,
          com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket.Builder
              builderForValue) {
        if (bucketsBuilder_ == null) {
          ensureBucketsIsMutable();
          buckets_.set(index, builderForValue.build());
          onChanged();
        } else {
          bucketsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
       * </code>
       */
      public Builder addBuckets(
          com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket value) {
        if (bucketsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBucketsIsMutable();
          buckets_.add(value);
          onChanged();
        } else {
          bucketsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
       * </code>
       */
      public Builder addBuckets(
          int index, com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket value) {
        if (bucketsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureBucketsIsMutable();
          buckets_.add(index, value);
          onChanged();
        } else {
          bucketsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
       * </code>
       */
      public Builder addBuckets(
          com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket.Builder
              builderForValue) {
        if (bucketsBuilder_ == null) {
          ensureBucketsIsMutable();
          buckets_.add(builderForValue.build());
          onChanged();
        } else {
          bucketsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
       * </code>
       */
      public Builder addBuckets(
          int index,
          com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket.Builder
              builderForValue) {
        if (bucketsBuilder_ == null) {
          ensureBucketsIsMutable();
          buckets_.add(index, builderForValue.build());
          onChanged();
        } else {
          bucketsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
       * </code>
       */
      public Builder addAllBuckets(
          java.lang.Iterable<
                  ? extends com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket>
              values) {
        if (bucketsBuilder_ == null) {
          ensureBucketsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, buckets_);
          onChanged();
        } else {
          bucketsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
       * </code>
       */
      public Builder clearBuckets() {
        if (bucketsBuilder_ == null) {
          buckets_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          bucketsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
       * </code>
       */
      public Builder removeBuckets(int index) {
        if (bucketsBuilder_ == null) {
          ensureBucketsIsMutable();
          buckets_.remove(index);
          onChanged();
        } else {
          bucketsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket.Builder
          getBucketsBuilder(int index) {
        return getBucketsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.BucketOrBuilder
          getBucketsOrBuilder(int index) {
        if (bucketsBuilder_ == null) {
          return buckets_.get(index);
        } else {
          return bucketsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.BucketOrBuilder>
          getBucketsOrBuilderList() {
        if (bucketsBuilder_ != null) {
          return bucketsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(buckets_);
        }
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket.Builder
          addBucketsBuilder() {
        return getBucketsFieldBuilder()
            .addBuilder(
                com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket.Builder
          addBucketsBuilder(int index) {
        return getBucketsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Buckets in the histogram.
       * There will be `n+1` buckets matching `n` lower bounds in the request.
       * The first bucket will be from -infinity to the first bound.
       * Subsequent buckets will be between one bound and the next.
       * The final bucket will be from the final bound to infinity.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket buckets = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket.Builder>
          getBucketsBuilderList() {
        return getBucketsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket,
              com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket.Builder,
              com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.BucketOrBuilder>
          getBucketsFieldBuilder() {
        if (bucketsBuilder_ == null) {
          bucketsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket,
                  com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Bucket.Builder,
                  com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.BucketOrBuilder>(
                  buckets_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          buckets_ = null;
        }
        return bucketsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.AggregationResult.Histogram)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.AggregationResult.Histogram)
    private static final com.google.cloud.migrationcenter.v1.AggregationResult.Histogram
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.AggregationResult.Histogram();
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Histogram
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Histogram> PARSER =
        new com.google.protobuf.AbstractParser<Histogram>() {
          @java.lang.Override
          public Histogram parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Histogram> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Histogram> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregationResult.Histogram
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FrequencyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.AggregationResult.Frequency)
      com.google.protobuf.MessageOrBuilder {

    /** <code>map&lt;string, int64&gt; values = 1;</code> */
    int getValuesCount();
    /** <code>map&lt;string, int64&gt; values = 1;</code> */
    boolean containsValues(java.lang.String key);
    /** Use {@link #getValuesMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.Long> getValues();
    /** <code>map&lt;string, int64&gt; values = 1;</code> */
    java.util.Map<java.lang.String, java.lang.Long> getValuesMap();
    /** <code>map&lt;string, int64&gt; values = 1;</code> */
    long getValuesOrDefault(java.lang.String key, long defaultValue);
    /** <code>map&lt;string, int64&gt; values = 1;</code> */
    long getValuesOrThrow(java.lang.String key);
  }
  /**
   *
   *
   * <pre>
   * The result of a frequency distribution aggregation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.AggregationResult.Frequency}
   */
  public static final class Frequency extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.AggregationResult.Frequency)
      FrequencyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Frequency.newBuilder() to construct.
    private Frequency(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Frequency() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Frequency();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Frequency_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 1:
          return internalGetValues();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Frequency_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.class,
              com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.Builder.class);
    }

    public static final int VALUES_FIELD_NUMBER = 1;

    private static final class ValuesDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.Long>newDefaultInstance(
              com.google.cloud.migrationcenter.v1.MigrationCenterProto
                  .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Frequency_ValuesEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.INT64,
              0L);
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, java.lang.Long> values_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Long> internalGetValues() {
      if (values_ == null) {
        return com.google.protobuf.MapField.emptyMapField(ValuesDefaultEntryHolder.defaultEntry);
      }
      return values_;
    }

    public int getValuesCount() {
      return internalGetValues().getMap().size();
    }
    /** <code>map&lt;string, int64&gt; values = 1;</code> */
    @java.lang.Override
    public boolean containsValues(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetValues().getMap().containsKey(key);
    }
    /** Use {@link #getValuesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Long> getValues() {
      return getValuesMap();
    }
    /** <code>map&lt;string, int64&gt; values = 1;</code> */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Long> getValuesMap() {
      return internalGetValues().getMap();
    }
    /** <code>map&lt;string, int64&gt; values = 1;</code> */
    @java.lang.Override
    public long getValuesOrDefault(java.lang.String key, long defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Long> map = internalGetValues().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /** <code>map&lt;string, int64&gt; values = 1;</code> */
    @java.lang.Override
    public long getValuesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Long> map = internalGetValues().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetValues(), ValuesDefaultEntryHolder.defaultEntry, 1);
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (java.util.Map.Entry<java.lang.String, java.lang.Long> entry :
          internalGetValues().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> values__ =
            ValuesDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, values__);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.migrationcenter.v1.AggregationResult.Frequency)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.AggregationResult.Frequency other =
          (com.google.cloud.migrationcenter.v1.AggregationResult.Frequency) obj;

      if (!internalGetValues().equals(other.internalGetValues())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (!internalGetValues().getMap().isEmpty()) {
        hash = (37 * hash) + VALUES_FIELD_NUMBER;
        hash = (53 * hash) + internalGetValues().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Frequency parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Frequency parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Frequency parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Frequency parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Frequency parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Frequency parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Frequency parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Frequency parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Frequency
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Frequency
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Frequency parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Frequency parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.AggregationResult.Frequency prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The result of a frequency distribution aggregation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.AggregationResult.Frequency}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.AggregationResult.Frequency)
        com.google.cloud.migrationcenter.v1.AggregationResult.FrequencyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Frequency_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 1:
            return internalGetValues();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 1:
            return internalGetMutableValues();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Frequency_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.class,
                com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.Builder.class);
      }

      // Construct using
      // com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        internalGetMutableValues().clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_AggregationResult_Frequency_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.AggregationResult.Frequency
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.AggregationResult.Frequency build() {
        com.google.cloud.migrationcenter.v1.AggregationResult.Frequency result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.AggregationResult.Frequency buildPartial() {
        com.google.cloud.migrationcenter.v1.AggregationResult.Frequency result =
            new com.google.cloud.migrationcenter.v1.AggregationResult.Frequency(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.AggregationResult.Frequency result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.values_ = internalGetValues();
          result.values_.makeImmutable();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.migrationcenter.v1.AggregationResult.Frequency) {
          return mergeFrom((com.google.cloud.migrationcenter.v1.AggregationResult.Frequency) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.AggregationResult.Frequency other) {
        if (other
            == com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.getDefaultInstance())
          return this;
        internalGetMutableValues().mergeFrom(other.internalGetValues());
        bitField0_ |= 0x00000001;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.Long> values__ =
                      input.readMessage(
                          ValuesDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
                  internalGetMutableValues()
                      .getMutableMap()
                      .put(values__.getKey(), values__.getValue());
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.Long> values_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.Long> internalGetValues() {
        if (values_ == null) {
          return com.google.protobuf.MapField.emptyMapField(ValuesDefaultEntryHolder.defaultEntry);
        }
        return values_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.Long>
          internalGetMutableValues() {
        if (values_ == null) {
          values_ = com.google.protobuf.MapField.newMapField(ValuesDefaultEntryHolder.defaultEntry);
        }
        if (!values_.isMutable()) {
          values_ = values_.copy();
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return values_;
      }

      public int getValuesCount() {
        return internalGetValues().getMap().size();
      }
      /** <code>map&lt;string, int64&gt; values = 1;</code> */
      @java.lang.Override
      public boolean containsValues(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetValues().getMap().containsKey(key);
      }
      /** Use {@link #getValuesMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.Long> getValues() {
        return getValuesMap();
      }
      /** <code>map&lt;string, int64&gt; values = 1;</code> */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.Long> getValuesMap() {
        return internalGetValues().getMap();
      }
      /** <code>map&lt;string, int64&gt; values = 1;</code> */
      @java.lang.Override
      public long getValuesOrDefault(java.lang.String key, long defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.Long> map = internalGetValues().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /** <code>map&lt;string, int64&gt; values = 1;</code> */
      @java.lang.Override
      public long getValuesOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.Long> map = internalGetValues().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearValues() {
        bitField0_ = (bitField0_ & ~0x00000001);
        internalGetMutableValues().getMutableMap().clear();
        return this;
      }
      /** <code>map&lt;string, int64&gt; values = 1;</code> */
      public Builder removeValues(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableValues().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.Long> getMutableValues() {
        bitField0_ |= 0x00000001;
        return internalGetMutableValues().getMutableMap();
      }
      /** <code>map&lt;string, int64&gt; values = 1;</code> */
      public Builder putValues(java.lang.String key, long value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }

        internalGetMutableValues().getMutableMap().put(key, value);
        bitField0_ |= 0x00000001;
        return this;
      }
      /** <code>map&lt;string, int64&gt; values = 1;</code> */
      public Builder putAllValues(java.util.Map<java.lang.String, java.lang.Long> values) {
        internalGetMutableValues().getMutableMap().putAll(values);
        bitField0_ |= 0x00000001;
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.AggregationResult.Frequency)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.AggregationResult.Frequency)
    private static final com.google.cloud.migrationcenter.v1.AggregationResult.Frequency
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.AggregationResult.Frequency();
    }

    public static com.google.cloud.migrationcenter.v1.AggregationResult.Frequency
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Frequency> PARSER =
        new com.google.protobuf.AbstractParser<Frequency>() {
          @java.lang.Override
          public Frequency parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Frequency> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Frequency> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregationResult.Frequency
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int resultCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object result_;

  public enum ResultCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    COUNT(2),
    SUM(3),
    HISTOGRAM(4),
    FREQUENCY(5),
    RESULT_NOT_SET(0);
    private final int value;

    private ResultCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResultCase valueOf(int value) {
      return forNumber(value);
    }

    public static ResultCase forNumber(int value) {
      switch (value) {
        case 2:
          return COUNT;
        case 3:
          return SUM;
        case 4:
          return HISTOGRAM;
        case 5:
          return FREQUENCY;
        case 0:
          return RESULT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ResultCase getResultCase() {
    return ResultCase.forNumber(resultCase_);
  }

  public static final int FIELD_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object field_ = "";
  /**
   * <code>string field = 1;</code>
   *
   * @return The field.
   */
  @java.lang.Override
  public java.lang.String getField() {
    java.lang.Object ref = field_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      field_ = s;
      return s;
    }
  }
  /**
   * <code>string field = 1;</code>
   *
   * @return The bytes for field.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFieldBytes() {
    java.lang.Object ref = field_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      field_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COUNT_FIELD_NUMBER = 2;
  /**
   * <code>.google.cloud.migrationcenter.v1.AggregationResult.Count count = 2;</code>
   *
   * @return Whether the count field is set.
   */
  @java.lang.Override
  public boolean hasCount() {
    return resultCase_ == 2;
  }
  /**
   * <code>.google.cloud.migrationcenter.v1.AggregationResult.Count count = 2;</code>
   *
   * @return The count.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AggregationResult.Count getCount() {
    if (resultCase_ == 2) {
      return (com.google.cloud.migrationcenter.v1.AggregationResult.Count) result_;
    }
    return com.google.cloud.migrationcenter.v1.AggregationResult.Count.getDefaultInstance();
  }
  /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Count count = 2;</code> */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AggregationResult.CountOrBuilder getCountOrBuilder() {
    if (resultCase_ == 2) {
      return (com.google.cloud.migrationcenter.v1.AggregationResult.Count) result_;
    }
    return com.google.cloud.migrationcenter.v1.AggregationResult.Count.getDefaultInstance();
  }

  public static final int SUM_FIELD_NUMBER = 3;
  /**
   * <code>.google.cloud.migrationcenter.v1.AggregationResult.Sum sum = 3;</code>
   *
   * @return Whether the sum field is set.
   */
  @java.lang.Override
  public boolean hasSum() {
    return resultCase_ == 3;
  }
  /**
   * <code>.google.cloud.migrationcenter.v1.AggregationResult.Sum sum = 3;</code>
   *
   * @return The sum.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AggregationResult.Sum getSum() {
    if (resultCase_ == 3) {
      return (com.google.cloud.migrationcenter.v1.AggregationResult.Sum) result_;
    }
    return com.google.cloud.migrationcenter.v1.AggregationResult.Sum.getDefaultInstance();
  }
  /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Sum sum = 3;</code> */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AggregationResult.SumOrBuilder getSumOrBuilder() {
    if (resultCase_ == 3) {
      return (com.google.cloud.migrationcenter.v1.AggregationResult.Sum) result_;
    }
    return com.google.cloud.migrationcenter.v1.AggregationResult.Sum.getDefaultInstance();
  }

  public static final int HISTOGRAM_FIELD_NUMBER = 4;
  /**
   * <code>.google.cloud.migrationcenter.v1.AggregationResult.Histogram histogram = 4;</code>
   *
   * @return Whether the histogram field is set.
   */
  @java.lang.Override
  public boolean hasHistogram() {
    return resultCase_ == 4;
  }
  /**
   * <code>.google.cloud.migrationcenter.v1.AggregationResult.Histogram histogram = 4;</code>
   *
   * @return The histogram.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AggregationResult.Histogram getHistogram() {
    if (resultCase_ == 4) {
      return (com.google.cloud.migrationcenter.v1.AggregationResult.Histogram) result_;
    }
    return com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.getDefaultInstance();
  }
  /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Histogram histogram = 4;</code> */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AggregationResult.HistogramOrBuilder
      getHistogramOrBuilder() {
    if (resultCase_ == 4) {
      return (com.google.cloud.migrationcenter.v1.AggregationResult.Histogram) result_;
    }
    return com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.getDefaultInstance();
  }

  public static final int FREQUENCY_FIELD_NUMBER = 5;
  /**
   * <code>.google.cloud.migrationcenter.v1.AggregationResult.Frequency frequency = 5;</code>
   *
   * @return Whether the frequency field is set.
   */
  @java.lang.Override
  public boolean hasFrequency() {
    return resultCase_ == 5;
  }
  /**
   * <code>.google.cloud.migrationcenter.v1.AggregationResult.Frequency frequency = 5;</code>
   *
   * @return The frequency.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AggregationResult.Frequency getFrequency() {
    if (resultCase_ == 5) {
      return (com.google.cloud.migrationcenter.v1.AggregationResult.Frequency) result_;
    }
    return com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.getDefaultInstance();
  }
  /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Frequency frequency = 5;</code> */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AggregationResult.FrequencyOrBuilder
      getFrequencyOrBuilder() {
    if (resultCase_ == 5) {
      return (com.google.cloud.migrationcenter.v1.AggregationResult.Frequency) result_;
    }
    return com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(field_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, field_);
    }
    if (resultCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.migrationcenter.v1.AggregationResult.Count) result_);
    }
    if (resultCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.migrationcenter.v1.AggregationResult.Sum) result_);
    }
    if (resultCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.migrationcenter.v1.AggregationResult.Histogram) result_);
    }
    if (resultCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.migrationcenter.v1.AggregationResult.Frequency) result_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(field_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, field_);
    }
    if (resultCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.migrationcenter.v1.AggregationResult.Count) result_);
    }
    if (resultCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.migrationcenter.v1.AggregationResult.Sum) result_);
    }
    if (resultCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.migrationcenter.v1.AggregationResult.Histogram) result_);
    }
    if (resultCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.migrationcenter.v1.AggregationResult.Frequency) result_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.AggregationResult)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.AggregationResult other =
        (com.google.cloud.migrationcenter.v1.AggregationResult) obj;

    if (!getField().equals(other.getField())) return false;
    if (!getResultCase().equals(other.getResultCase())) return false;
    switch (resultCase_) {
      case 2:
        if (!getCount().equals(other.getCount())) return false;
        break;
      case 3:
        if (!getSum().equals(other.getSum())) return false;
        break;
      case 4:
        if (!getHistogram().equals(other.getHistogram())) return false;
        break;
      case 5:
        if (!getFrequency().equals(other.getFrequency())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FIELD_FIELD_NUMBER;
    hash = (53 * hash) + getField().hashCode();
    switch (resultCase_) {
      case 2:
        hash = (37 * hash) + COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getCount().hashCode();
        break;
      case 3:
        hash = (37 * hash) + SUM_FIELD_NUMBER;
        hash = (53 * hash) + getSum().hashCode();
        break;
      case 4:
        hash = (37 * hash) + HISTOGRAM_FIELD_NUMBER;
        hash = (53 * hash) + getHistogram().hashCode();
        break;
      case 5:
        hash = (37 * hash) + FREQUENCY_FIELD_NUMBER;
        hash = (53 * hash) + getFrequency().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.AggregationResult parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.AggregationResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AggregationResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.AggregationResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AggregationResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.AggregationResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AggregationResult parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.AggregationResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AggregationResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.AggregationResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AggregationResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.AggregationResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.migrationcenter.v1.AggregationResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Message describing a result of an aggregation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.AggregationResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.AggregationResult)
      com.google.cloud.migrationcenter.v1.AggregationResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AggregationResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AggregationResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.AggregationResult.class,
              com.google.cloud.migrationcenter.v1.AggregationResult.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.AggregationResult.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      field_ = "";
      if (countBuilder_ != null) {
        countBuilder_.clear();
      }
      if (sumBuilder_ != null) {
        sumBuilder_.clear();
      }
      if (histogramBuilder_ != null) {
        histogramBuilder_.clear();
      }
      if (frequencyBuilder_ != null) {
        frequencyBuilder_.clear();
      }
      resultCase_ = 0;
      result_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AggregationResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregationResult getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.AggregationResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregationResult build() {
      com.google.cloud.migrationcenter.v1.AggregationResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregationResult buildPartial() {
      com.google.cloud.migrationcenter.v1.AggregationResult result =
          new com.google.cloud.migrationcenter.v1.AggregationResult(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.AggregationResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.field_ = field_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.migrationcenter.v1.AggregationResult result) {
      result.resultCase_ = resultCase_;
      result.result_ = this.result_;
      if (resultCase_ == 2 && countBuilder_ != null) {
        result.result_ = countBuilder_.build();
      }
      if (resultCase_ == 3 && sumBuilder_ != null) {
        result.result_ = sumBuilder_.build();
      }
      if (resultCase_ == 4 && histogramBuilder_ != null) {
        result.result_ = histogramBuilder_.build();
      }
      if (resultCase_ == 5 && frequencyBuilder_ != null) {
        result.result_ = frequencyBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.AggregationResult) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.AggregationResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.AggregationResult other) {
      if (other == com.google.cloud.migrationcenter.v1.AggregationResult.getDefaultInstance())
        return this;
      if (!other.getField().isEmpty()) {
        field_ = other.field_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      switch (other.getResultCase()) {
        case COUNT:
          {
            mergeCount(other.getCount());
            break;
          }
        case SUM:
          {
            mergeSum(other.getSum());
            break;
          }
        case HISTOGRAM:
          {
            mergeHistogram(other.getHistogram());
            break;
          }
        case FREQUENCY:
          {
            mergeFrequency(other.getFrequency());
            break;
          }
        case RESULT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                field_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCountFieldBuilder().getBuilder(), extensionRegistry);
                resultCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getSumFieldBuilder().getBuilder(), extensionRegistry);
                resultCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getHistogramFieldBuilder().getBuilder(), extensionRegistry);
                resultCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getFrequencyFieldBuilder().getBuilder(), extensionRegistry);
                resultCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int resultCase_ = 0;
    private java.lang.Object result_;

    public ResultCase getResultCase() {
      return ResultCase.forNumber(resultCase_);
    }

    public Builder clearResult() {
      resultCase_ = 0;
      result_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object field_ = "";
    /**
     * <code>string field = 1;</code>
     *
     * @return The field.
     */
    public java.lang.String getField() {
      java.lang.Object ref = field_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        field_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <code>string field = 1;</code>
     *
     * @return The bytes for field.
     */
    public com.google.protobuf.ByteString getFieldBytes() {
      java.lang.Object ref = field_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        field_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <code>string field = 1;</code>
     *
     * @param value The field to set.
     * @return This builder for chaining.
     */
    public Builder setField(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      field_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <code>string field = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearField() {
      field_ = getDefaultInstance().getField();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <code>string field = 1;</code>
     *
     * @param value The bytes for field to set.
     * @return This builder for chaining.
     */
    public Builder setFieldBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      field_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.AggregationResult.Count,
            com.google.cloud.migrationcenter.v1.AggregationResult.Count.Builder,
            com.google.cloud.migrationcenter.v1.AggregationResult.CountOrBuilder>
        countBuilder_;
    /**
     * <code>.google.cloud.migrationcenter.v1.AggregationResult.Count count = 2;</code>
     *
     * @return Whether the count field is set.
     */
    @java.lang.Override
    public boolean hasCount() {
      return resultCase_ == 2;
    }
    /**
     * <code>.google.cloud.migrationcenter.v1.AggregationResult.Count count = 2;</code>
     *
     * @return The count.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregationResult.Count getCount() {
      if (countBuilder_ == null) {
        if (resultCase_ == 2) {
          return (com.google.cloud.migrationcenter.v1.AggregationResult.Count) result_;
        }
        return com.google.cloud.migrationcenter.v1.AggregationResult.Count.getDefaultInstance();
      } else {
        if (resultCase_ == 2) {
          return countBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.AggregationResult.Count.getDefaultInstance();
      }
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Count count = 2;</code> */
    public Builder setCount(com.google.cloud.migrationcenter.v1.AggregationResult.Count value) {
      if (countBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        result_ = value;
        onChanged();
      } else {
        countBuilder_.setMessage(value);
      }
      resultCase_ = 2;
      return this;
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Count count = 2;</code> */
    public Builder setCount(
        com.google.cloud.migrationcenter.v1.AggregationResult.Count.Builder builderForValue) {
      if (countBuilder_ == null) {
        result_ = builderForValue.build();
        onChanged();
      } else {
        countBuilder_.setMessage(builderForValue.build());
      }
      resultCase_ = 2;
      return this;
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Count count = 2;</code> */
    public Builder mergeCount(com.google.cloud.migrationcenter.v1.AggregationResult.Count value) {
      if (countBuilder_ == null) {
        if (resultCase_ == 2
            && result_
                != com.google.cloud.migrationcenter.v1.AggregationResult.Count
                    .getDefaultInstance()) {
          result_ =
              com.google.cloud.migrationcenter.v1.AggregationResult.Count.newBuilder(
                      (com.google.cloud.migrationcenter.v1.AggregationResult.Count) result_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          result_ = value;
        }
        onChanged();
      } else {
        if (resultCase_ == 2) {
          countBuilder_.mergeFrom(value);
        } else {
          countBuilder_.setMessage(value);
        }
      }
      resultCase_ = 2;
      return this;
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Count count = 2;</code> */
    public Builder clearCount() {
      if (countBuilder_ == null) {
        if (resultCase_ == 2) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
      } else {
        if (resultCase_ == 2) {
          resultCase_ = 0;
          result_ = null;
        }
        countBuilder_.clear();
      }
      return this;
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Count count = 2;</code> */
    public com.google.cloud.migrationcenter.v1.AggregationResult.Count.Builder getCountBuilder() {
      return getCountFieldBuilder().getBuilder();
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Count count = 2;</code> */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregationResult.CountOrBuilder
        getCountOrBuilder() {
      if ((resultCase_ == 2) && (countBuilder_ != null)) {
        return countBuilder_.getMessageOrBuilder();
      } else {
        if (resultCase_ == 2) {
          return (com.google.cloud.migrationcenter.v1.AggregationResult.Count) result_;
        }
        return com.google.cloud.migrationcenter.v1.AggregationResult.Count.getDefaultInstance();
      }
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Count count = 2;</code> */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.AggregationResult.Count,
            com.google.cloud.migrationcenter.v1.AggregationResult.Count.Builder,
            com.google.cloud.migrationcenter.v1.AggregationResult.CountOrBuilder>
        getCountFieldBuilder() {
      if (countBuilder_ == null) {
        if (!(resultCase_ == 2)) {
          result_ =
              com.google.cloud.migrationcenter.v1.AggregationResult.Count.getDefaultInstance();
        }
        countBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.AggregationResult.Count,
                com.google.cloud.migrationcenter.v1.AggregationResult.Count.Builder,
                com.google.cloud.migrationcenter.v1.AggregationResult.CountOrBuilder>(
                (com.google.cloud.migrationcenter.v1.AggregationResult.Count) result_,
                getParentForChildren(),
                isClean());
        result_ = null;
      }
      resultCase_ = 2;
      onChanged();
      return countBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.AggregationResult.Sum,
            com.google.cloud.migrationcenter.v1.AggregationResult.Sum.Builder,
            com.google.cloud.migrationcenter.v1.AggregationResult.SumOrBuilder>
        sumBuilder_;
    /**
     * <code>.google.cloud.migrationcenter.v1.AggregationResult.Sum sum = 3;</code>
     *
     * @return Whether the sum field is set.
     */
    @java.lang.Override
    public boolean hasSum() {
      return resultCase_ == 3;
    }
    /**
     * <code>.google.cloud.migrationcenter.v1.AggregationResult.Sum sum = 3;</code>
     *
     * @return The sum.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregationResult.Sum getSum() {
      if (sumBuilder_ == null) {
        if (resultCase_ == 3) {
          return (com.google.cloud.migrationcenter.v1.AggregationResult.Sum) result_;
        }
        return com.google.cloud.migrationcenter.v1.AggregationResult.Sum.getDefaultInstance();
      } else {
        if (resultCase_ == 3) {
          return sumBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.AggregationResult.Sum.getDefaultInstance();
      }
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Sum sum = 3;</code> */
    public Builder setSum(com.google.cloud.migrationcenter.v1.AggregationResult.Sum value) {
      if (sumBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        result_ = value;
        onChanged();
      } else {
        sumBuilder_.setMessage(value);
      }
      resultCase_ = 3;
      return this;
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Sum sum = 3;</code> */
    public Builder setSum(
        com.google.cloud.migrationcenter.v1.AggregationResult.Sum.Builder builderForValue) {
      if (sumBuilder_ == null) {
        result_ = builderForValue.build();
        onChanged();
      } else {
        sumBuilder_.setMessage(builderForValue.build());
      }
      resultCase_ = 3;
      return this;
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Sum sum = 3;</code> */
    public Builder mergeSum(com.google.cloud.migrationcenter.v1.AggregationResult.Sum value) {
      if (sumBuilder_ == null) {
        if (resultCase_ == 3
            && result_
                != com.google.cloud.migrationcenter.v1.AggregationResult.Sum.getDefaultInstance()) {
          result_ =
              com.google.cloud.migrationcenter.v1.AggregationResult.Sum.newBuilder(
                      (com.google.cloud.migrationcenter.v1.AggregationResult.Sum) result_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          result_ = value;
        }
        onChanged();
      } else {
        if (resultCase_ == 3) {
          sumBuilder_.mergeFrom(value);
        } else {
          sumBuilder_.setMessage(value);
        }
      }
      resultCase_ = 3;
      return this;
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Sum sum = 3;</code> */
    public Builder clearSum() {
      if (sumBuilder_ == null) {
        if (resultCase_ == 3) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
      } else {
        if (resultCase_ == 3) {
          resultCase_ = 0;
          result_ = null;
        }
        sumBuilder_.clear();
      }
      return this;
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Sum sum = 3;</code> */
    public com.google.cloud.migrationcenter.v1.AggregationResult.Sum.Builder getSumBuilder() {
      return getSumFieldBuilder().getBuilder();
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Sum sum = 3;</code> */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregationResult.SumOrBuilder getSumOrBuilder() {
      if ((resultCase_ == 3) && (sumBuilder_ != null)) {
        return sumBuilder_.getMessageOrBuilder();
      } else {
        if (resultCase_ == 3) {
          return (com.google.cloud.migrationcenter.v1.AggregationResult.Sum) result_;
        }
        return com.google.cloud.migrationcenter.v1.AggregationResult.Sum.getDefaultInstance();
      }
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Sum sum = 3;</code> */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.AggregationResult.Sum,
            com.google.cloud.migrationcenter.v1.AggregationResult.Sum.Builder,
            com.google.cloud.migrationcenter.v1.AggregationResult.SumOrBuilder>
        getSumFieldBuilder() {
      if (sumBuilder_ == null) {
        if (!(resultCase_ == 3)) {
          result_ = com.google.cloud.migrationcenter.v1.AggregationResult.Sum.getDefaultInstance();
        }
        sumBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.AggregationResult.Sum,
                com.google.cloud.migrationcenter.v1.AggregationResult.Sum.Builder,
                com.google.cloud.migrationcenter.v1.AggregationResult.SumOrBuilder>(
                (com.google.cloud.migrationcenter.v1.AggregationResult.Sum) result_,
                getParentForChildren(),
                isClean());
        result_ = null;
      }
      resultCase_ = 3;
      onChanged();
      return sumBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.AggregationResult.Histogram,
            com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Builder,
            com.google.cloud.migrationcenter.v1.AggregationResult.HistogramOrBuilder>
        histogramBuilder_;
    /**
     * <code>.google.cloud.migrationcenter.v1.AggregationResult.Histogram histogram = 4;</code>
     *
     * @return Whether the histogram field is set.
     */
    @java.lang.Override
    public boolean hasHistogram() {
      return resultCase_ == 4;
    }
    /**
     * <code>.google.cloud.migrationcenter.v1.AggregationResult.Histogram histogram = 4;</code>
     *
     * @return The histogram.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregationResult.Histogram getHistogram() {
      if (histogramBuilder_ == null) {
        if (resultCase_ == 4) {
          return (com.google.cloud.migrationcenter.v1.AggregationResult.Histogram) result_;
        }
        return com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.getDefaultInstance();
      } else {
        if (resultCase_ == 4) {
          return histogramBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.getDefaultInstance();
      }
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Histogram histogram = 4;</code> */
    public Builder setHistogram(
        com.google.cloud.migrationcenter.v1.AggregationResult.Histogram value) {
      if (histogramBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        result_ = value;
        onChanged();
      } else {
        histogramBuilder_.setMessage(value);
      }
      resultCase_ = 4;
      return this;
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Histogram histogram = 4;</code> */
    public Builder setHistogram(
        com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Builder builderForValue) {
      if (histogramBuilder_ == null) {
        result_ = builderForValue.build();
        onChanged();
      } else {
        histogramBuilder_.setMessage(builderForValue.build());
      }
      resultCase_ = 4;
      return this;
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Histogram histogram = 4;</code> */
    public Builder mergeHistogram(
        com.google.cloud.migrationcenter.v1.AggregationResult.Histogram value) {
      if (histogramBuilder_ == null) {
        if (resultCase_ == 4
            && result_
                != com.google.cloud.migrationcenter.v1.AggregationResult.Histogram
                    .getDefaultInstance()) {
          result_ =
              com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.newBuilder(
                      (com.google.cloud.migrationcenter.v1.AggregationResult.Histogram) result_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          result_ = value;
        }
        onChanged();
      } else {
        if (resultCase_ == 4) {
          histogramBuilder_.mergeFrom(value);
        } else {
          histogramBuilder_.setMessage(value);
        }
      }
      resultCase_ = 4;
      return this;
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Histogram histogram = 4;</code> */
    public Builder clearHistogram() {
      if (histogramBuilder_ == null) {
        if (resultCase_ == 4) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
      } else {
        if (resultCase_ == 4) {
          resultCase_ = 0;
          result_ = null;
        }
        histogramBuilder_.clear();
      }
      return this;
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Histogram histogram = 4;</code> */
    public com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Builder
        getHistogramBuilder() {
      return getHistogramFieldBuilder().getBuilder();
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Histogram histogram = 4;</code> */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregationResult.HistogramOrBuilder
        getHistogramOrBuilder() {
      if ((resultCase_ == 4) && (histogramBuilder_ != null)) {
        return histogramBuilder_.getMessageOrBuilder();
      } else {
        if (resultCase_ == 4) {
          return (com.google.cloud.migrationcenter.v1.AggregationResult.Histogram) result_;
        }
        return com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.getDefaultInstance();
      }
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Histogram histogram = 4;</code> */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.AggregationResult.Histogram,
            com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Builder,
            com.google.cloud.migrationcenter.v1.AggregationResult.HistogramOrBuilder>
        getHistogramFieldBuilder() {
      if (histogramBuilder_ == null) {
        if (!(resultCase_ == 4)) {
          result_ =
              com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.getDefaultInstance();
        }
        histogramBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.AggregationResult.Histogram,
                com.google.cloud.migrationcenter.v1.AggregationResult.Histogram.Builder,
                com.google.cloud.migrationcenter.v1.AggregationResult.HistogramOrBuilder>(
                (com.google.cloud.migrationcenter.v1.AggregationResult.Histogram) result_,
                getParentForChildren(),
                isClean());
        result_ = null;
      }
      resultCase_ = 4;
      onChanged();
      return histogramBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.AggregationResult.Frequency,
            com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.Builder,
            com.google.cloud.migrationcenter.v1.AggregationResult.FrequencyOrBuilder>
        frequencyBuilder_;
    /**
     * <code>.google.cloud.migrationcenter.v1.AggregationResult.Frequency frequency = 5;</code>
     *
     * @return Whether the frequency field is set.
     */
    @java.lang.Override
    public boolean hasFrequency() {
      return resultCase_ == 5;
    }
    /**
     * <code>.google.cloud.migrationcenter.v1.AggregationResult.Frequency frequency = 5;</code>
     *
     * @return The frequency.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregationResult.Frequency getFrequency() {
      if (frequencyBuilder_ == null) {
        if (resultCase_ == 5) {
          return (com.google.cloud.migrationcenter.v1.AggregationResult.Frequency) result_;
        }
        return com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.getDefaultInstance();
      } else {
        if (resultCase_ == 5) {
          return frequencyBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.getDefaultInstance();
      }
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Frequency frequency = 5;</code> */
    public Builder setFrequency(
        com.google.cloud.migrationcenter.v1.AggregationResult.Frequency value) {
      if (frequencyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        result_ = value;
        onChanged();
      } else {
        frequencyBuilder_.setMessage(value);
      }
      resultCase_ = 5;
      return this;
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Frequency frequency = 5;</code> */
    public Builder setFrequency(
        com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.Builder builderForValue) {
      if (frequencyBuilder_ == null) {
        result_ = builderForValue.build();
        onChanged();
      } else {
        frequencyBuilder_.setMessage(builderForValue.build());
      }
      resultCase_ = 5;
      return this;
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Frequency frequency = 5;</code> */
    public Builder mergeFrequency(
        com.google.cloud.migrationcenter.v1.AggregationResult.Frequency value) {
      if (frequencyBuilder_ == null) {
        if (resultCase_ == 5
            && result_
                != com.google.cloud.migrationcenter.v1.AggregationResult.Frequency
                    .getDefaultInstance()) {
          result_ =
              com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.newBuilder(
                      (com.google.cloud.migrationcenter.v1.AggregationResult.Frequency) result_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          result_ = value;
        }
        onChanged();
      } else {
        if (resultCase_ == 5) {
          frequencyBuilder_.mergeFrom(value);
        } else {
          frequencyBuilder_.setMessage(value);
        }
      }
      resultCase_ = 5;
      return this;
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Frequency frequency = 5;</code> */
    public Builder clearFrequency() {
      if (frequencyBuilder_ == null) {
        if (resultCase_ == 5) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
      } else {
        if (resultCase_ == 5) {
          resultCase_ = 0;
          result_ = null;
        }
        frequencyBuilder_.clear();
      }
      return this;
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Frequency frequency = 5;</code> */
    public com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.Builder
        getFrequencyBuilder() {
      return getFrequencyFieldBuilder().getBuilder();
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Frequency frequency = 5;</code> */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AggregationResult.FrequencyOrBuilder
        getFrequencyOrBuilder() {
      if ((resultCase_ == 5) && (frequencyBuilder_ != null)) {
        return frequencyBuilder_.getMessageOrBuilder();
      } else {
        if (resultCase_ == 5) {
          return (com.google.cloud.migrationcenter.v1.AggregationResult.Frequency) result_;
        }
        return com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.getDefaultInstance();
      }
    }
    /** <code>.google.cloud.migrationcenter.v1.AggregationResult.Frequency frequency = 5;</code> */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.AggregationResult.Frequency,
            com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.Builder,
            com.google.cloud.migrationcenter.v1.AggregationResult.FrequencyOrBuilder>
        getFrequencyFieldBuilder() {
      if (frequencyBuilder_ == null) {
        if (!(resultCase_ == 5)) {
          result_ =
              com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.getDefaultInstance();
        }
        frequencyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.AggregationResult.Frequency,
                com.google.cloud.migrationcenter.v1.AggregationResult.Frequency.Builder,
                com.google.cloud.migrationcenter.v1.AggregationResult.FrequencyOrBuilder>(
                (com.google.cloud.migrationcenter.v1.AggregationResult.Frequency) result_,
                getParentForChildren(),
                isClean());
        result_ = null;
      }
      resultCase_ = 5;
      onChanged();
      return frequencyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.AggregationResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.AggregationResult)
  private static final com.google.cloud.migrationcenter.v1.AggregationResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.AggregationResult();
  }

  public static com.google.cloud.migrationcenter.v1.AggregationResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AggregationResult> PARSER =
      new com.google.protobuf.AbstractParser<AggregationResult>() {
        @java.lang.Override
        public AggregationResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AggregationResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AggregationResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AggregationResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
