/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * An asset represents a resource in your environment. Asset types include
 * virtual machines and databases.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.Asset}
 */
public final class Asset extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.Asset)
    AssetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Asset.newBuilder() to construct.
  private Asset(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Asset() {
    name_ = "";
    sources_ = com.google.protobuf.LazyStringArrayList.emptyList();
    assignedGroups_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Asset();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_Asset_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      case 5:
        return internalGetAttributes();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_Asset_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.Asset.class,
            com.google.cloud.migrationcenter.v1.Asset.Builder.class);
  }

  private int assetDetailsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object assetDetails_;

  public enum AssetDetailsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MACHINE_DETAILS(6),
    ASSETDETAILS_NOT_SET(0);
    private final int value;

    private AssetDetailsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AssetDetailsCase valueOf(int value) {
      return forNumber(value);
    }

    public static AssetDetailsCase forNumber(int value) {
      switch (value) {
        case 6:
          return MACHINE_DETAILS;
        case 0:
          return ASSETDETAILS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AssetDetailsCase getAssetDetailsCase() {
    return AssetDetailsCase.forNumber(assetDetailsCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The full name of the asset.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The full name of the asset.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the asset was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the asset was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the asset was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the asset was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the asset was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the asset was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.migrationcenter.v1.MigrationCenterProto
                .internal_static_google_cloud_migrationcenter_v1_Asset_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ATTRIBUTES_FIELD_NUMBER = 5;

  private static final class AttributesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.migrationcenter.v1.MigrationCenterProto
                .internal_static_google_cloud_migrationcenter_v1_Asset_AttributesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> attributes_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetAttributes() {
    if (attributes_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AttributesDefaultEntryHolder.defaultEntry);
    }
    return attributes_;
  }

  public int getAttributesCount() {
    return internalGetAttributes().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Generic asset attributes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; attributes = 5;</code>
   */
  @java.lang.Override
  public boolean containsAttributes(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAttributes().getMap().containsKey(key);
  }
  /** Use {@link #getAttributesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAttributes() {
    return getAttributesMap();
  }
  /**
   *
   *
   * <pre>
   * Generic asset attributes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; attributes = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAttributesMap() {
    return internalGetAttributes().getMap();
  }
  /**
   *
   *
   * <pre>
   * Generic asset attributes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; attributes = 5;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAttributesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAttributes().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Generic asset attributes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; attributes = 5;</code>
   */
  @java.lang.Override
  public java.lang.String getAttributesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAttributes().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int MACHINE_DETAILS_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Output only. Asset information specific for virtual and physical
   * machines.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.MachineDetails machine_details = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the machineDetails field is set.
   */
  @java.lang.Override
  public boolean hasMachineDetails() {
    return assetDetailsCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Output only. Asset information specific for virtual and physical
   * machines.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.MachineDetails machine_details = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The machineDetails.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.MachineDetails getMachineDetails() {
    if (assetDetailsCase_ == 6) {
      return (com.google.cloud.migrationcenter.v1.MachineDetails) assetDetails_;
    }
    return com.google.cloud.migrationcenter.v1.MachineDetails.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Asset information specific for virtual and physical
   * machines.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.MachineDetails machine_details = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.MachineDetailsOrBuilder getMachineDetailsOrBuilder() {
    if (assetDetailsCase_ == 6) {
      return (com.google.cloud.migrationcenter.v1.MachineDetails) assetDetails_;
    }
    return com.google.cloud.migrationcenter.v1.MachineDetails.getDefaultInstance();
  }

  public static final int INSIGHT_LIST_FIELD_NUMBER = 20;
  private com.google.cloud.migrationcenter.v1.InsightList insightList_;
  /**
   *
   *
   * <pre>
   * Output only. The list of insights associated with the asset.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.InsightList insight_list = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the insightList field is set.
   */
  @java.lang.Override
  public boolean hasInsightList() {
    return insightList_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of insights associated with the asset.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.InsightList insight_list = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The insightList.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.InsightList getInsightList() {
    return insightList_ == null
        ? com.google.cloud.migrationcenter.v1.InsightList.getDefaultInstance()
        : insightList_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of insights associated with the asset.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.InsightList insight_list = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.InsightListOrBuilder getInsightListOrBuilder() {
    return insightList_ == null
        ? com.google.cloud.migrationcenter.v1.InsightList.getDefaultInstance()
        : insightList_;
  }

  public static final int PERFORMANCE_DATA_FIELD_NUMBER = 21;
  private com.google.cloud.migrationcenter.v1.AssetPerformanceData performanceData_;
  /**
   *
   *
   * <pre>
   * Output only. Performance data for the asset.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.AssetPerformanceData performance_data = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the performanceData field is set.
   */
  @java.lang.Override
  public boolean hasPerformanceData() {
    return performanceData_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Performance data for the asset.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.AssetPerformanceData performance_data = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The performanceData.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AssetPerformanceData getPerformanceData() {
    return performanceData_ == null
        ? com.google.cloud.migrationcenter.v1.AssetPerformanceData.getDefaultInstance()
        : performanceData_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Performance data for the asset.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.AssetPerformanceData performance_data = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AssetPerformanceDataOrBuilder
      getPerformanceDataOrBuilder() {
    return performanceData_ == null
        ? com.google.cloud.migrationcenter.v1.AssetPerformanceData.getDefaultInstance()
        : performanceData_;
  }

  public static final int SOURCES_FIELD_NUMBER = 22;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList sources_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. The list of sources contributing to the asset.
   * </pre>
   *
   * <code>
   * repeated string sources = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the sources.
   */
  public com.google.protobuf.ProtocolStringList getSourcesList() {
    return sources_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of sources contributing to the asset.
   * </pre>
   *
   * <code>
   * repeated string sources = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of sources.
   */
  public int getSourcesCount() {
    return sources_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of sources contributing to the asset.
   * </pre>
   *
   * <code>
   * repeated string sources = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The sources at the given index.
   */
  public java.lang.String getSources(int index) {
    return sources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of sources contributing to the asset.
   * </pre>
   *
   * <code>
   * repeated string sources = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sources at the given index.
   */
  public com.google.protobuf.ByteString getSourcesBytes(int index) {
    return sources_.getByteString(index);
  }

  public static final int ASSIGNED_GROUPS_FIELD_NUMBER = 23;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList assignedGroups_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. The list of groups that the asset is assigned to.
   * </pre>
   *
   * <code>
   * repeated string assigned_groups = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return A list containing the assignedGroups.
   */
  public com.google.protobuf.ProtocolStringList getAssignedGroupsList() {
    return assignedGroups_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of groups that the asset is assigned to.
   * </pre>
   *
   * <code>
   * repeated string assigned_groups = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The count of assignedGroups.
   */
  public int getAssignedGroupsCount() {
    return assignedGroups_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of groups that the asset is assigned to.
   * </pre>
   *
   * <code>
   * repeated string assigned_groups = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the element to return.
   * @return The assignedGroups at the given index.
   */
  public java.lang.String getAssignedGroups(int index) {
    return assignedGroups_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The list of groups that the asset is assigned to.
   * </pre>
   *
   * <code>
   * repeated string assigned_groups = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the assignedGroups at the given index.
   */
  public com.google.protobuf.ByteString getAssignedGroupsBytes(int index) {
    return assignedGroups_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAttributes(), AttributesDefaultEntryHolder.defaultEntry, 5);
    if (assetDetailsCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.migrationcenter.v1.MachineDetails) assetDetails_);
    }
    if (insightList_ != null) {
      output.writeMessage(20, getInsightList());
    }
    if (performanceData_ != null) {
      output.writeMessage(21, getPerformanceData());
    }
    for (int i = 0; i < sources_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 22, sources_.getRaw(i));
    }
    for (int i = 0; i < assignedGroups_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 23, assignedGroups_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAttributes().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> attributes__ =
          AttributesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, attributes__);
    }
    if (assetDetailsCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.migrationcenter.v1.MachineDetails) assetDetails_);
    }
    if (insightList_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getInsightList());
    }
    if (performanceData_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getPerformanceData());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sources_.size(); i++) {
        dataSize += computeStringSizeNoTag(sources_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getSourcesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < assignedGroups_.size(); i++) {
        dataSize += computeStringSizeNoTag(assignedGroups_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getAssignedGroupsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.Asset)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.Asset other =
        (com.google.cloud.migrationcenter.v1.Asset) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!internalGetAttributes().equals(other.internalGetAttributes())) return false;
    if (hasInsightList() != other.hasInsightList()) return false;
    if (hasInsightList()) {
      if (!getInsightList().equals(other.getInsightList())) return false;
    }
    if (hasPerformanceData() != other.hasPerformanceData()) return false;
    if (hasPerformanceData()) {
      if (!getPerformanceData().equals(other.getPerformanceData())) return false;
    }
    if (!getSourcesList().equals(other.getSourcesList())) return false;
    if (!getAssignedGroupsList().equals(other.getAssignedGroupsList())) return false;
    if (!getAssetDetailsCase().equals(other.getAssetDetailsCase())) return false;
    switch (assetDetailsCase_) {
      case 6:
        if (!getMachineDetails().equals(other.getMachineDetails())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (!internalGetAttributes().getMap().isEmpty()) {
      hash = (37 * hash) + ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAttributes().hashCode();
    }
    if (hasInsightList()) {
      hash = (37 * hash) + INSIGHT_LIST_FIELD_NUMBER;
      hash = (53 * hash) + getInsightList().hashCode();
    }
    if (hasPerformanceData()) {
      hash = (37 * hash) + PERFORMANCE_DATA_FIELD_NUMBER;
      hash = (53 * hash) + getPerformanceData().hashCode();
    }
    if (getSourcesCount() > 0) {
      hash = (37 * hash) + SOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getSourcesList().hashCode();
    }
    if (getAssignedGroupsCount() > 0) {
      hash = (37 * hash) + ASSIGNED_GROUPS_FIELD_NUMBER;
      hash = (53 * hash) + getAssignedGroupsList().hashCode();
    }
    switch (assetDetailsCase_) {
      case 6:
        hash = (37 * hash) + MACHINE_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getMachineDetails().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.Asset parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.Asset parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.Asset parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.Asset parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.Asset parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.Asset parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.Asset parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.Asset parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.Asset parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.Asset parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.Asset parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.Asset parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.migrationcenter.v1.Asset prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An asset represents a resource in your environment. Asset types include
   * virtual machines and databases.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.Asset}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.Asset)
      com.google.cloud.migrationcenter.v1.AssetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_Asset_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        case 5:
          return internalGetAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        case 5:
          return internalGetMutableAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_Asset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.Asset.class,
              com.google.cloud.migrationcenter.v1.Asset.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.Asset.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      internalGetMutableAttributes().clear();
      if (machineDetailsBuilder_ != null) {
        machineDetailsBuilder_.clear();
      }
      insightList_ = null;
      if (insightListBuilder_ != null) {
        insightListBuilder_.dispose();
        insightListBuilder_ = null;
      }
      performanceData_ = null;
      if (performanceDataBuilder_ != null) {
        performanceDataBuilder_.dispose();
        performanceDataBuilder_ = null;
      }
      sources_ = com.google.protobuf.LazyStringArrayList.emptyList();
      assignedGroups_ = com.google.protobuf.LazyStringArrayList.emptyList();
      assetDetailsCase_ = 0;
      assetDetails_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_Asset_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.Asset getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.Asset.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.Asset build() {
      com.google.cloud.migrationcenter.v1.Asset result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.Asset buildPartial() {
      com.google.cloud.migrationcenter.v1.Asset result =
          new com.google.cloud.migrationcenter.v1.Asset(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.Asset result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.attributes_ = internalGetAttributes();
        result.attributes_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.insightList_ =
            insightListBuilder_ == null ? insightList_ : insightListBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.performanceData_ =
            performanceDataBuilder_ == null ? performanceData_ : performanceDataBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        sources_.makeImmutable();
        result.sources_ = sources_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        assignedGroups_.makeImmutable();
        result.assignedGroups_ = assignedGroups_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.migrationcenter.v1.Asset result) {
      result.assetDetailsCase_ = assetDetailsCase_;
      result.assetDetails_ = this.assetDetails_;
      if (assetDetailsCase_ == 6 && machineDetailsBuilder_ != null) {
        result.assetDetails_ = machineDetailsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.Asset) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.Asset) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.Asset other) {
      if (other == com.google.cloud.migrationcenter.v1.Asset.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      internalGetMutableAttributes().mergeFrom(other.internalGetAttributes());
      bitField0_ |= 0x00000010;
      if (other.hasInsightList()) {
        mergeInsightList(other.getInsightList());
      }
      if (other.hasPerformanceData()) {
        mergePerformanceData(other.getPerformanceData());
      }
      if (!other.sources_.isEmpty()) {
        if (sources_.isEmpty()) {
          sources_ = other.sources_;
          bitField0_ |= 0x00000100;
        } else {
          ensureSourcesIsMutable();
          sources_.addAll(other.sources_);
        }
        onChanged();
      }
      if (!other.assignedGroups_.isEmpty()) {
        if (assignedGroups_.isEmpty()) {
          assignedGroups_ = other.assignedGroups_;
          bitField0_ |= 0x00000200;
        } else {
          ensureAssignedGroupsIsMutable();
          assignedGroups_.addAll(other.assignedGroups_);
        }
        onChanged();
      }
      switch (other.getAssetDetailsCase()) {
        case MACHINE_DETAILS:
          {
            mergeMachineDetails(other.getMachineDetails());
            break;
          }
        case ASSETDETAILS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> attributes__ =
                    input.readMessage(
                        AttributesDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAttributes()
                    .getMutableMap()
                    .put(attributes__.getKey(), attributes__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getMachineDetailsFieldBuilder().getBuilder(), extensionRegistry);
                assetDetailsCase_ = 6;
                break;
              } // case 50
            case 162:
              {
                input.readMessage(getInsightListFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(getPerformanceDataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 170
            case 178:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSourcesIsMutable();
                sources_.add(s);
                break;
              } // case 178
            case 186:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAssignedGroupsIsMutable();
                assignedGroups_.add(s);
                break;
              } // case 186
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int assetDetailsCase_ = 0;
    private java.lang.Object assetDetails_;

    public AssetDetailsCase getAssetDetailsCase() {
      return AssetDetailsCase.forNumber(assetDetailsCase_);
    }

    public Builder clearAssetDetails() {
      assetDetailsCase_ = 0;
      assetDetails_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The full name of the asset.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the asset.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the asset.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the asset.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The full name of the asset.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the asset was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the asset was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the asset was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the asset was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the asset was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the asset was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the asset was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the asset was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the asset was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the asset was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the asset was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the asset was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the asset was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the asset was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the asset was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the asset was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the asset was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the asset was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> attributes_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAttributes() {
      if (attributes_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AttributesDefaultEntryHolder.defaultEntry);
      }
      return attributes_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAttributes() {
      if (attributes_ == null) {
        attributes_ =
            com.google.protobuf.MapField.newMapField(AttributesDefaultEntryHolder.defaultEntry);
      }
      if (!attributes_.isMutable()) {
        attributes_ = attributes_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return attributes_;
    }

    public int getAttributesCount() {
      return internalGetAttributes().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Generic asset attributes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 5;</code>
     */
    @java.lang.Override
    public boolean containsAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAttributes().getMap().containsKey(key);
    }
    /** Use {@link #getAttributesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAttributes() {
      return getAttributesMap();
    }
    /**
     *
     *
     * <pre>
     * Generic asset attributes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAttributesMap() {
      return internalGetAttributes().getMap();
    }
    /**
     *
     *
     * <pre>
     * Generic asset attributes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 5;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAttributesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAttributes().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Generic asset attributes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getAttributesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAttributes().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAttributes() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableAttributes().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generic asset attributes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 5;</code>
     */
    public Builder removeAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAttributes().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAttributes() {
      bitField0_ |= 0x00000010;
      return internalGetMutableAttributes().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Generic asset attributes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 5;</code>
     */
    public Builder putAttributes(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAttributes().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generic asset attributes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 5;</code>
     */
    public Builder putAllAttributes(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAttributes().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.MachineDetails,
            com.google.cloud.migrationcenter.v1.MachineDetails.Builder,
            com.google.cloud.migrationcenter.v1.MachineDetailsOrBuilder>
        machineDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Asset information specific for virtual and physical
     * machines.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineDetails machine_details = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the machineDetails field is set.
     */
    @java.lang.Override
    public boolean hasMachineDetails() {
      return assetDetailsCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Output only. Asset information specific for virtual and physical
     * machines.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineDetails machine_details = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The machineDetails.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.MachineDetails getMachineDetails() {
      if (machineDetailsBuilder_ == null) {
        if (assetDetailsCase_ == 6) {
          return (com.google.cloud.migrationcenter.v1.MachineDetails) assetDetails_;
        }
        return com.google.cloud.migrationcenter.v1.MachineDetails.getDefaultInstance();
      } else {
        if (assetDetailsCase_ == 6) {
          return machineDetailsBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.MachineDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Asset information specific for virtual and physical
     * machines.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineDetails machine_details = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMachineDetails(com.google.cloud.migrationcenter.v1.MachineDetails value) {
      if (machineDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        assetDetails_ = value;
        onChanged();
      } else {
        machineDetailsBuilder_.setMessage(value);
      }
      assetDetailsCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Asset information specific for virtual and physical
     * machines.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineDetails machine_details = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setMachineDetails(
        com.google.cloud.migrationcenter.v1.MachineDetails.Builder builderForValue) {
      if (machineDetailsBuilder_ == null) {
        assetDetails_ = builderForValue.build();
        onChanged();
      } else {
        machineDetailsBuilder_.setMessage(builderForValue.build());
      }
      assetDetailsCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Asset information specific for virtual and physical
     * machines.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineDetails machine_details = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeMachineDetails(com.google.cloud.migrationcenter.v1.MachineDetails value) {
      if (machineDetailsBuilder_ == null) {
        if (assetDetailsCase_ == 6
            && assetDetails_
                != com.google.cloud.migrationcenter.v1.MachineDetails.getDefaultInstance()) {
          assetDetails_ =
              com.google.cloud.migrationcenter.v1.MachineDetails.newBuilder(
                      (com.google.cloud.migrationcenter.v1.MachineDetails) assetDetails_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          assetDetails_ = value;
        }
        onChanged();
      } else {
        if (assetDetailsCase_ == 6) {
          machineDetailsBuilder_.mergeFrom(value);
        } else {
          machineDetailsBuilder_.setMessage(value);
        }
      }
      assetDetailsCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Asset information specific for virtual and physical
     * machines.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineDetails machine_details = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearMachineDetails() {
      if (machineDetailsBuilder_ == null) {
        if (assetDetailsCase_ == 6) {
          assetDetailsCase_ = 0;
          assetDetails_ = null;
          onChanged();
        }
      } else {
        if (assetDetailsCase_ == 6) {
          assetDetailsCase_ = 0;
          assetDetails_ = null;
        }
        machineDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Asset information specific for virtual and physical
     * machines.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineDetails machine_details = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.MachineDetails.Builder getMachineDetailsBuilder() {
      return getMachineDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Asset information specific for virtual and physical
     * machines.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineDetails machine_details = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.MachineDetailsOrBuilder
        getMachineDetailsOrBuilder() {
      if ((assetDetailsCase_ == 6) && (machineDetailsBuilder_ != null)) {
        return machineDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (assetDetailsCase_ == 6) {
          return (com.google.cloud.migrationcenter.v1.MachineDetails) assetDetails_;
        }
        return com.google.cloud.migrationcenter.v1.MachineDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Asset information specific for virtual and physical
     * machines.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.MachineDetails machine_details = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.MachineDetails,
            com.google.cloud.migrationcenter.v1.MachineDetails.Builder,
            com.google.cloud.migrationcenter.v1.MachineDetailsOrBuilder>
        getMachineDetailsFieldBuilder() {
      if (machineDetailsBuilder_ == null) {
        if (!(assetDetailsCase_ == 6)) {
          assetDetails_ = com.google.cloud.migrationcenter.v1.MachineDetails.getDefaultInstance();
        }
        machineDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.MachineDetails,
                com.google.cloud.migrationcenter.v1.MachineDetails.Builder,
                com.google.cloud.migrationcenter.v1.MachineDetailsOrBuilder>(
                (com.google.cloud.migrationcenter.v1.MachineDetails) assetDetails_,
                getParentForChildren(),
                isClean());
        assetDetails_ = null;
      }
      assetDetailsCase_ = 6;
      onChanged();
      return machineDetailsBuilder_;
    }

    private com.google.cloud.migrationcenter.v1.InsightList insightList_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.InsightList,
            com.google.cloud.migrationcenter.v1.InsightList.Builder,
            com.google.cloud.migrationcenter.v1.InsightListOrBuilder>
        insightListBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The list of insights associated with the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.InsightList insight_list = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the insightList field is set.
     */
    public boolean hasInsightList() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of insights associated with the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.InsightList insight_list = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The insightList.
     */
    public com.google.cloud.migrationcenter.v1.InsightList getInsightList() {
      if (insightListBuilder_ == null) {
        return insightList_ == null
            ? com.google.cloud.migrationcenter.v1.InsightList.getDefaultInstance()
            : insightList_;
      } else {
        return insightListBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of insights associated with the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.InsightList insight_list = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setInsightList(com.google.cloud.migrationcenter.v1.InsightList value) {
      if (insightListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        insightList_ = value;
      } else {
        insightListBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of insights associated with the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.InsightList insight_list = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setInsightList(
        com.google.cloud.migrationcenter.v1.InsightList.Builder builderForValue) {
      if (insightListBuilder_ == null) {
        insightList_ = builderForValue.build();
      } else {
        insightListBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of insights associated with the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.InsightList insight_list = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeInsightList(com.google.cloud.migrationcenter.v1.InsightList value) {
      if (insightListBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && insightList_ != null
            && insightList_
                != com.google.cloud.migrationcenter.v1.InsightList.getDefaultInstance()) {
          getInsightListBuilder().mergeFrom(value);
        } else {
          insightList_ = value;
        }
      } else {
        insightListBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of insights associated with the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.InsightList insight_list = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearInsightList() {
      bitField0_ = (bitField0_ & ~0x00000040);
      insightList_ = null;
      if (insightListBuilder_ != null) {
        insightListBuilder_.dispose();
        insightListBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of insights associated with the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.InsightList insight_list = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.InsightList.Builder getInsightListBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getInsightListFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of insights associated with the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.InsightList insight_list = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.InsightListOrBuilder getInsightListOrBuilder() {
      if (insightListBuilder_ != null) {
        return insightListBuilder_.getMessageOrBuilder();
      } else {
        return insightList_ == null
            ? com.google.cloud.migrationcenter.v1.InsightList.getDefaultInstance()
            : insightList_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of insights associated with the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.InsightList insight_list = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.InsightList,
            com.google.cloud.migrationcenter.v1.InsightList.Builder,
            com.google.cloud.migrationcenter.v1.InsightListOrBuilder>
        getInsightListFieldBuilder() {
      if (insightListBuilder_ == null) {
        insightListBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.InsightList,
                com.google.cloud.migrationcenter.v1.InsightList.Builder,
                com.google.cloud.migrationcenter.v1.InsightListOrBuilder>(
                getInsightList(), getParentForChildren(), isClean());
        insightList_ = null;
      }
      return insightListBuilder_;
    }

    private com.google.cloud.migrationcenter.v1.AssetPerformanceData performanceData_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.AssetPerformanceData,
            com.google.cloud.migrationcenter.v1.AssetPerformanceData.Builder,
            com.google.cloud.migrationcenter.v1.AssetPerformanceDataOrBuilder>
        performanceDataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Performance data for the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetPerformanceData performance_data = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the performanceData field is set.
     */
    public boolean hasPerformanceData() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Performance data for the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetPerformanceData performance_data = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The performanceData.
     */
    public com.google.cloud.migrationcenter.v1.AssetPerformanceData getPerformanceData() {
      if (performanceDataBuilder_ == null) {
        return performanceData_ == null
            ? com.google.cloud.migrationcenter.v1.AssetPerformanceData.getDefaultInstance()
            : performanceData_;
      } else {
        return performanceDataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Performance data for the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetPerformanceData performance_data = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPerformanceData(
        com.google.cloud.migrationcenter.v1.AssetPerformanceData value) {
      if (performanceDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        performanceData_ = value;
      } else {
        performanceDataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Performance data for the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetPerformanceData performance_data = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPerformanceData(
        com.google.cloud.migrationcenter.v1.AssetPerformanceData.Builder builderForValue) {
      if (performanceDataBuilder_ == null) {
        performanceData_ = builderForValue.build();
      } else {
        performanceDataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Performance data for the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetPerformanceData performance_data = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePerformanceData(
        com.google.cloud.migrationcenter.v1.AssetPerformanceData value) {
      if (performanceDataBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && performanceData_ != null
            && performanceData_
                != com.google.cloud.migrationcenter.v1.AssetPerformanceData.getDefaultInstance()) {
          getPerformanceDataBuilder().mergeFrom(value);
        } else {
          performanceData_ = value;
        }
      } else {
        performanceDataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Performance data for the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetPerformanceData performance_data = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPerformanceData() {
      bitField0_ = (bitField0_ & ~0x00000080);
      performanceData_ = null;
      if (performanceDataBuilder_ != null) {
        performanceDataBuilder_.dispose();
        performanceDataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Performance data for the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetPerformanceData performance_data = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.AssetPerformanceData.Builder
        getPerformanceDataBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getPerformanceDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Performance data for the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetPerformanceData performance_data = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.AssetPerformanceDataOrBuilder
        getPerformanceDataOrBuilder() {
      if (performanceDataBuilder_ != null) {
        return performanceDataBuilder_.getMessageOrBuilder();
      } else {
        return performanceData_ == null
            ? com.google.cloud.migrationcenter.v1.AssetPerformanceData.getDefaultInstance()
            : performanceData_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Performance data for the asset.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetPerformanceData performance_data = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.AssetPerformanceData,
            com.google.cloud.migrationcenter.v1.AssetPerformanceData.Builder,
            com.google.cloud.migrationcenter.v1.AssetPerformanceDataOrBuilder>
        getPerformanceDataFieldBuilder() {
      if (performanceDataBuilder_ == null) {
        performanceDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.AssetPerformanceData,
                com.google.cloud.migrationcenter.v1.AssetPerformanceData.Builder,
                com.google.cloud.migrationcenter.v1.AssetPerformanceDataOrBuilder>(
                getPerformanceData(), getParentForChildren(), isClean());
        performanceData_ = null;
      }
      return performanceDataBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList sources_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSourcesIsMutable() {
      if (!sources_.isModifiable()) {
        sources_ = new com.google.protobuf.LazyStringArrayList(sources_);
      }
      bitField0_ |= 0x00000100;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of sources contributing to the asset.
     * </pre>
     *
     * <code>
     * repeated string sources = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the sources.
     */
    public com.google.protobuf.ProtocolStringList getSourcesList() {
      sources_.makeImmutable();
      return sources_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of sources contributing to the asset.
     * </pre>
     *
     * <code>
     * repeated string sources = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of sources.
     */
    public int getSourcesCount() {
      return sources_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of sources contributing to the asset.
     * </pre>
     *
     * <code>
     * repeated string sources = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The sources at the given index.
     */
    public java.lang.String getSources(int index) {
      return sources_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of sources contributing to the asset.
     * </pre>
     *
     * <code>
     * repeated string sources = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sources at the given index.
     */
    public com.google.protobuf.ByteString getSourcesBytes(int index) {
      return sources_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of sources contributing to the asset.
     * </pre>
     *
     * <code>
     * repeated string sources = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The sources to set.
     * @return This builder for chaining.
     */
    public Builder setSources(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourcesIsMutable();
      sources_.set(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of sources contributing to the asset.
     * </pre>
     *
     * <code>
     * repeated string sources = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The sources to add.
     * @return This builder for chaining.
     */
    public Builder addSources(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourcesIsMutable();
      sources_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of sources contributing to the asset.
     * </pre>
     *
     * <code>
     * repeated string sources = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param values The sources to add.
     * @return This builder for chaining.
     */
    public Builder addAllSources(java.lang.Iterable<java.lang.String> values) {
      ensureSourcesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sources_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of sources contributing to the asset.
     * </pre>
     *
     * <code>
     * repeated string sources = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSources() {
      sources_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of sources contributing to the asset.
     * </pre>
     *
     * <code>
     * repeated string sources = 22 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes of the sources to add.
     * @return This builder for chaining.
     */
    public Builder addSourcesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSourcesIsMutable();
      sources_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList assignedGroups_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAssignedGroupsIsMutable() {
      if (!assignedGroups_.isModifiable()) {
        assignedGroups_ = new com.google.protobuf.LazyStringArrayList(assignedGroups_);
      }
      bitField0_ |= 0x00000200;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of groups that the asset is assigned to.
     * </pre>
     *
     * <code>
     * repeated string assigned_groups = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the assignedGroups.
     */
    public com.google.protobuf.ProtocolStringList getAssignedGroupsList() {
      assignedGroups_.makeImmutable();
      return assignedGroups_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of groups that the asset is assigned to.
     * </pre>
     *
     * <code>
     * repeated string assigned_groups = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of assignedGroups.
     */
    public int getAssignedGroupsCount() {
      return assignedGroups_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of groups that the asset is assigned to.
     * </pre>
     *
     * <code>
     * repeated string assigned_groups = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The assignedGroups at the given index.
     */
    public java.lang.String getAssignedGroups(int index) {
      return assignedGroups_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of groups that the asset is assigned to.
     * </pre>
     *
     * <code>
     * repeated string assigned_groups = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the assignedGroups at the given index.
     */
    public com.google.protobuf.ByteString getAssignedGroupsBytes(int index) {
      return assignedGroups_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of groups that the asset is assigned to.
     * </pre>
     *
     * <code>
     * repeated string assigned_groups = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The assignedGroups to set.
     * @return This builder for chaining.
     */
    public Builder setAssignedGroups(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAssignedGroupsIsMutable();
      assignedGroups_.set(index, value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of groups that the asset is assigned to.
     * </pre>
     *
     * <code>
     * repeated string assigned_groups = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The assignedGroups to add.
     * @return This builder for chaining.
     */
    public Builder addAssignedGroups(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAssignedGroupsIsMutable();
      assignedGroups_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of groups that the asset is assigned to.
     * </pre>
     *
     * <code>
     * repeated string assigned_groups = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param values The assignedGroups to add.
     * @return This builder for chaining.
     */
    public Builder addAllAssignedGroups(java.lang.Iterable<java.lang.String> values) {
      ensureAssignedGroupsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, assignedGroups_);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of groups that the asset is assigned to.
     * </pre>
     *
     * <code>
     * repeated string assigned_groups = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAssignedGroups() {
      assignedGroups_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000200);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The list of groups that the asset is assigned to.
     * </pre>
     *
     * <code>
     * repeated string assigned_groups = 23 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes of the assignedGroups to add.
     * @return This builder for chaining.
     */
    public Builder addAssignedGroupsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAssignedGroupsIsMutable();
      assignedGroups_.add(value);
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.Asset)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.Asset)
  private static final com.google.cloud.migrationcenter.v1.Asset DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.Asset();
  }

  public static com.google.cloud.migrationcenter.v1.Asset getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Asset> PARSER =
      new com.google.protobuf.AbstractParser<Asset>() {
        @java.lang.Override
        public Asset parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Asset> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Asset> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.Asset getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
