/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * Contains data reported from an inventory source on an asset.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.AssetFrame}
 */
public final class AssetFrame extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.AssetFrame)
    AssetFrameOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AssetFrame.newBuilder() to construct.
  private AssetFrame(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AssetFrame() {
    performanceSamples_ = java.util.Collections.emptyList();
    traceToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AssetFrame();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_AssetFrame_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 11:
        return internalGetLabels();
      case 12:
        return internalGetAttributes();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_AssetFrame_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.AssetFrame.class,
            com.google.cloud.migrationcenter.v1.AssetFrame.Builder.class);
  }

  private int frameDataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object frameData_;

  public enum FrameDataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MACHINE_DETAILS(1),
    FRAMEDATA_NOT_SET(0);
    private final int value;

    private FrameDataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FrameDataCase valueOf(int value) {
      return forNumber(value);
    }

    public static FrameDataCase forNumber(int value) {
      switch (value) {
        case 1:
          return MACHINE_DETAILS;
        case 0:
          return FRAMEDATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FrameDataCase getFrameDataCase() {
    return FrameDataCase.forNumber(frameDataCase_);
  }

  public static final int MACHINE_DETAILS_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Asset information specific for virtual machines.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.MachineDetails machine_details = 1;</code>
   *
   * @return Whether the machineDetails field is set.
   */
  @java.lang.Override
  public boolean hasMachineDetails() {
    return frameDataCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Asset information specific for virtual machines.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.MachineDetails machine_details = 1;</code>
   *
   * @return The machineDetails.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.MachineDetails getMachineDetails() {
    if (frameDataCase_ == 1) {
      return (com.google.cloud.migrationcenter.v1.MachineDetails) frameData_;
    }
    return com.google.cloud.migrationcenter.v1.MachineDetails.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Asset information specific for virtual machines.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.MachineDetails machine_details = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.MachineDetailsOrBuilder getMachineDetailsOrBuilder() {
    if (frameDataCase_ == 1) {
      return (com.google.cloud.migrationcenter.v1.MachineDetails) frameData_;
    }
    return com.google.cloud.migrationcenter.v1.MachineDetails.getDefaultInstance();
  }

  public static final int REPORT_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp reportTime_;
  /**
   *
   *
   * <pre>
   * The time the data was reported.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp report_time = 10;</code>
   *
   * @return Whether the reportTime field is set.
   */
  @java.lang.Override
  public boolean hasReportTime() {
    return reportTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time the data was reported.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp report_time = 10;</code>
   *
   * @return The reportTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReportTime() {
    return reportTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : reportTime_;
  }
  /**
   *
   *
   * <pre>
   * The time the data was reported.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp report_time = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReportTimeOrBuilder() {
    return reportTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : reportTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 11;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.migrationcenter.v1.MigrationCenterProto
                .internal_static_google_cloud_migrationcenter_v1_AssetFrame_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels as key value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ATTRIBUTES_FIELD_NUMBER = 12;

  private static final class AttributesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.migrationcenter.v1.MigrationCenterProto
                .internal_static_google_cloud_migrationcenter_v1_AssetFrame_AttributesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> attributes_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetAttributes() {
    if (attributes_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AttributesDefaultEntryHolder.defaultEntry);
    }
    return attributes_;
  }

  public int getAttributesCount() {
    return internalGetAttributes().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Generic asset attributes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; attributes = 12;</code>
   */
  @java.lang.Override
  public boolean containsAttributes(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAttributes().getMap().containsKey(key);
  }
  /** Use {@link #getAttributesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAttributes() {
    return getAttributesMap();
  }
  /**
   *
   *
   * <pre>
   * Generic asset attributes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; attributes = 12;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAttributesMap() {
    return internalGetAttributes().getMap();
  }
  /**
   *
   *
   * <pre>
   * Generic asset attributes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; attributes = 12;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAttributesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAttributes().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Generic asset attributes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; attributes = 12;</code>
   */
  @java.lang.Override
  public java.lang.String getAttributesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAttributes().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int PERFORMANCE_SAMPLES_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.migrationcenter.v1.PerformanceSample> performanceSamples_;
  /**
   *
   *
   * <pre>
   * Asset performance data samples.
   * Samples that are from more than 40 days ago or after tomorrow are ignored.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.migrationcenter.v1.PerformanceSample>
      getPerformanceSamplesList() {
    return performanceSamples_;
  }
  /**
   *
   *
   * <pre>
   * Asset performance data samples.
   * Samples that are from more than 40 days ago or after tomorrow are ignored.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.migrationcenter.v1.PerformanceSampleOrBuilder>
      getPerformanceSamplesOrBuilderList() {
    return performanceSamples_;
  }
  /**
   *
   *
   * <pre>
   * Asset performance data samples.
   * Samples that are from more than 40 days ago or after tomorrow are ignored.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
   * </code>
   */
  @java.lang.Override
  public int getPerformanceSamplesCount() {
    return performanceSamples_.size();
  }
  /**
   *
   *
   * <pre>
   * Asset performance data samples.
   * Samples that are from more than 40 days ago or after tomorrow are ignored.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.PerformanceSample getPerformanceSamples(int index) {
    return performanceSamples_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Asset performance data samples.
   * Samples that are from more than 40 days ago or after tomorrow are ignored.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.PerformanceSampleOrBuilder
      getPerformanceSamplesOrBuilder(int index) {
    return performanceSamples_.get(index);
  }

  public static final int TRACE_TOKEN_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object traceToken_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Trace token is optionally provided to assist with debugging and
   * traceability.
   * </pre>
   *
   * <code>string trace_token = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The traceToken.
   */
  @java.lang.Override
  public java.lang.String getTraceToken() {
    java.lang.Object ref = traceToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      traceToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Trace token is optionally provided to assist with debugging and
   * traceability.
   * </pre>
   *
   * <code>string trace_token = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for traceToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTraceTokenBytes() {
    java.lang.Object ref = traceToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      traceToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (frameDataCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.migrationcenter.v1.MachineDetails) frameData_);
    }
    if (reportTime_ != null) {
      output.writeMessage(10, getReportTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 11);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAttributes(), AttributesDefaultEntryHolder.defaultEntry, 12);
    for (int i = 0; i < performanceSamples_.size(); i++) {
      output.writeMessage(13, performanceSamples_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(traceToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, traceToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (frameDataCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.migrationcenter.v1.MachineDetails) frameData_);
    }
    if (reportTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getReportTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, labels__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAttributes().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> attributes__ =
          AttributesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, attributes__);
    }
    for (int i = 0; i < performanceSamples_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(13, performanceSamples_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(traceToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, traceToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.AssetFrame)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.AssetFrame other =
        (com.google.cloud.migrationcenter.v1.AssetFrame) obj;

    if (hasReportTime() != other.hasReportTime()) return false;
    if (hasReportTime()) {
      if (!getReportTime().equals(other.getReportTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!internalGetAttributes().equals(other.internalGetAttributes())) return false;
    if (!getPerformanceSamplesList().equals(other.getPerformanceSamplesList())) return false;
    if (!getTraceToken().equals(other.getTraceToken())) return false;
    if (!getFrameDataCase().equals(other.getFrameDataCase())) return false;
    switch (frameDataCase_) {
      case 1:
        if (!getMachineDetails().equals(other.getMachineDetails())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasReportTime()) {
      hash = (37 * hash) + REPORT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getReportTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (!internalGetAttributes().getMap().isEmpty()) {
      hash = (37 * hash) + ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAttributes().hashCode();
    }
    if (getPerformanceSamplesCount() > 0) {
      hash = (37 * hash) + PERFORMANCE_SAMPLES_FIELD_NUMBER;
      hash = (53 * hash) + getPerformanceSamplesList().hashCode();
    }
    hash = (37 * hash) + TRACE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getTraceToken().hashCode();
    switch (frameDataCase_) {
      case 1:
        hash = (37 * hash) + MACHINE_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getMachineDetails().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.AssetFrame parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.AssetFrame parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AssetFrame parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.AssetFrame parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AssetFrame parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.AssetFrame parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AssetFrame parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.AssetFrame parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AssetFrame parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.AssetFrame parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.AssetFrame parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.AssetFrame parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.migrationcenter.v1.AssetFrame prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Contains data reported from an inventory source on an asset.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.AssetFrame}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.AssetFrame)
      com.google.cloud.migrationcenter.v1.AssetFrameOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AssetFrame_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 11:
          return internalGetLabels();
        case 12:
          return internalGetAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 11:
          return internalGetMutableLabels();
        case 12:
          return internalGetMutableAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AssetFrame_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.AssetFrame.class,
              com.google.cloud.migrationcenter.v1.AssetFrame.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.AssetFrame.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (machineDetailsBuilder_ != null) {
        machineDetailsBuilder_.clear();
      }
      reportTime_ = null;
      if (reportTimeBuilder_ != null) {
        reportTimeBuilder_.dispose();
        reportTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      internalGetMutableAttributes().clear();
      if (performanceSamplesBuilder_ == null) {
        performanceSamples_ = java.util.Collections.emptyList();
      } else {
        performanceSamples_ = null;
        performanceSamplesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      traceToken_ = "";
      frameDataCase_ = 0;
      frameData_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_AssetFrame_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AssetFrame getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.AssetFrame.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AssetFrame build() {
      com.google.cloud.migrationcenter.v1.AssetFrame result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.AssetFrame buildPartial() {
      com.google.cloud.migrationcenter.v1.AssetFrame result =
          new com.google.cloud.migrationcenter.v1.AssetFrame(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.migrationcenter.v1.AssetFrame result) {
      if (performanceSamplesBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          performanceSamples_ = java.util.Collections.unmodifiableList(performanceSamples_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.performanceSamples_ = performanceSamples_;
      } else {
        result.performanceSamples_ = performanceSamplesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.AssetFrame result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.reportTime_ = reportTimeBuilder_ == null ? reportTime_ : reportTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.attributes_ = internalGetAttributes();
        result.attributes_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.traceToken_ = traceToken_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.migrationcenter.v1.AssetFrame result) {
      result.frameDataCase_ = frameDataCase_;
      result.frameData_ = this.frameData_;
      if (frameDataCase_ == 1 && machineDetailsBuilder_ != null) {
        result.frameData_ = machineDetailsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.AssetFrame) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.AssetFrame) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.AssetFrame other) {
      if (other == com.google.cloud.migrationcenter.v1.AssetFrame.getDefaultInstance()) return this;
      if (other.hasReportTime()) {
        mergeReportTime(other.getReportTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000004;
      internalGetMutableAttributes().mergeFrom(other.internalGetAttributes());
      bitField0_ |= 0x00000008;
      if (performanceSamplesBuilder_ == null) {
        if (!other.performanceSamples_.isEmpty()) {
          if (performanceSamples_.isEmpty()) {
            performanceSamples_ = other.performanceSamples_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensurePerformanceSamplesIsMutable();
            performanceSamples_.addAll(other.performanceSamples_);
          }
          onChanged();
        }
      } else {
        if (!other.performanceSamples_.isEmpty()) {
          if (performanceSamplesBuilder_.isEmpty()) {
            performanceSamplesBuilder_.dispose();
            performanceSamplesBuilder_ = null;
            performanceSamples_ = other.performanceSamples_;
            bitField0_ = (bitField0_ & ~0x00000010);
            performanceSamplesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPerformanceSamplesFieldBuilder()
                    : null;
          } else {
            performanceSamplesBuilder_.addAllMessages(other.performanceSamples_);
          }
        }
      }
      if (!other.getTraceToken().isEmpty()) {
        traceToken_ = other.traceToken_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      switch (other.getFrameDataCase()) {
        case MACHINE_DETAILS:
          {
            mergeMachineDetails(other.getMachineDetails());
            break;
          }
        case FRAMEDATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getMachineDetailsFieldBuilder().getBuilder(), extensionRegistry);
                frameDataCase_ = 1;
                break;
              } // case 10
            case 82:
              {
                input.readMessage(getReportTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 82
            case 90:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 90
            case 98:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> attributes__ =
                    input.readMessage(
                        AttributesDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAttributes()
                    .getMutableMap()
                    .put(attributes__.getKey(), attributes__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 98
            case 106:
              {
                com.google.cloud.migrationcenter.v1.PerformanceSample m =
                    input.readMessage(
                        com.google.cloud.migrationcenter.v1.PerformanceSample.parser(),
                        extensionRegistry);
                if (performanceSamplesBuilder_ == null) {
                  ensurePerformanceSamplesIsMutable();
                  performanceSamples_.add(m);
                } else {
                  performanceSamplesBuilder_.addMessage(m);
                }
                break;
              } // case 106
            case 114:
              {
                traceToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int frameDataCase_ = 0;
    private java.lang.Object frameData_;

    public FrameDataCase getFrameDataCase() {
      return FrameDataCase.forNumber(frameDataCase_);
    }

    public Builder clearFrameData() {
      frameDataCase_ = 0;
      frameData_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.MachineDetails,
            com.google.cloud.migrationcenter.v1.MachineDetails.Builder,
            com.google.cloud.migrationcenter.v1.MachineDetailsOrBuilder>
        machineDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Asset information specific for virtual machines.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDetails machine_details = 1;</code>
     *
     * @return Whether the machineDetails field is set.
     */
    @java.lang.Override
    public boolean hasMachineDetails() {
      return frameDataCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Asset information specific for virtual machines.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDetails machine_details = 1;</code>
     *
     * @return The machineDetails.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.MachineDetails getMachineDetails() {
      if (machineDetailsBuilder_ == null) {
        if (frameDataCase_ == 1) {
          return (com.google.cloud.migrationcenter.v1.MachineDetails) frameData_;
        }
        return com.google.cloud.migrationcenter.v1.MachineDetails.getDefaultInstance();
      } else {
        if (frameDataCase_ == 1) {
          return machineDetailsBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.MachineDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Asset information specific for virtual machines.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDetails machine_details = 1;</code>
     */
    public Builder setMachineDetails(com.google.cloud.migrationcenter.v1.MachineDetails value) {
      if (machineDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        frameData_ = value;
        onChanged();
      } else {
        machineDetailsBuilder_.setMessage(value);
      }
      frameDataCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Asset information specific for virtual machines.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDetails machine_details = 1;</code>
     */
    public Builder setMachineDetails(
        com.google.cloud.migrationcenter.v1.MachineDetails.Builder builderForValue) {
      if (machineDetailsBuilder_ == null) {
        frameData_ = builderForValue.build();
        onChanged();
      } else {
        machineDetailsBuilder_.setMessage(builderForValue.build());
      }
      frameDataCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Asset information specific for virtual machines.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDetails machine_details = 1;</code>
     */
    public Builder mergeMachineDetails(com.google.cloud.migrationcenter.v1.MachineDetails value) {
      if (machineDetailsBuilder_ == null) {
        if (frameDataCase_ == 1
            && frameData_
                != com.google.cloud.migrationcenter.v1.MachineDetails.getDefaultInstance()) {
          frameData_ =
              com.google.cloud.migrationcenter.v1.MachineDetails.newBuilder(
                      (com.google.cloud.migrationcenter.v1.MachineDetails) frameData_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          frameData_ = value;
        }
        onChanged();
      } else {
        if (frameDataCase_ == 1) {
          machineDetailsBuilder_.mergeFrom(value);
        } else {
          machineDetailsBuilder_.setMessage(value);
        }
      }
      frameDataCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Asset information specific for virtual machines.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDetails machine_details = 1;</code>
     */
    public Builder clearMachineDetails() {
      if (machineDetailsBuilder_ == null) {
        if (frameDataCase_ == 1) {
          frameDataCase_ = 0;
          frameData_ = null;
          onChanged();
        }
      } else {
        if (frameDataCase_ == 1) {
          frameDataCase_ = 0;
          frameData_ = null;
        }
        machineDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Asset information specific for virtual machines.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDetails machine_details = 1;</code>
     */
    public com.google.cloud.migrationcenter.v1.MachineDetails.Builder getMachineDetailsBuilder() {
      return getMachineDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Asset information specific for virtual machines.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDetails machine_details = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.MachineDetailsOrBuilder
        getMachineDetailsOrBuilder() {
      if ((frameDataCase_ == 1) && (machineDetailsBuilder_ != null)) {
        return machineDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (frameDataCase_ == 1) {
          return (com.google.cloud.migrationcenter.v1.MachineDetails) frameData_;
        }
        return com.google.cloud.migrationcenter.v1.MachineDetails.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Asset information specific for virtual machines.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.MachineDetails machine_details = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.MachineDetails,
            com.google.cloud.migrationcenter.v1.MachineDetails.Builder,
            com.google.cloud.migrationcenter.v1.MachineDetailsOrBuilder>
        getMachineDetailsFieldBuilder() {
      if (machineDetailsBuilder_ == null) {
        if (!(frameDataCase_ == 1)) {
          frameData_ = com.google.cloud.migrationcenter.v1.MachineDetails.getDefaultInstance();
        }
        machineDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.MachineDetails,
                com.google.cloud.migrationcenter.v1.MachineDetails.Builder,
                com.google.cloud.migrationcenter.v1.MachineDetailsOrBuilder>(
                (com.google.cloud.migrationcenter.v1.MachineDetails) frameData_,
                getParentForChildren(),
                isClean());
        frameData_ = null;
      }
      frameDataCase_ = 1;
      onChanged();
      return machineDetailsBuilder_;
    }

    private com.google.protobuf.Timestamp reportTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        reportTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time the data was reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp report_time = 10;</code>
     *
     * @return Whether the reportTime field is set.
     */
    public boolean hasReportTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time the data was reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp report_time = 10;</code>
     *
     * @return The reportTime.
     */
    public com.google.protobuf.Timestamp getReportTime() {
      if (reportTimeBuilder_ == null) {
        return reportTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : reportTime_;
      } else {
        return reportTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time the data was reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp report_time = 10;</code>
     */
    public Builder setReportTime(com.google.protobuf.Timestamp value) {
      if (reportTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        reportTime_ = value;
      } else {
        reportTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the data was reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp report_time = 10;</code>
     */
    public Builder setReportTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (reportTimeBuilder_ == null) {
        reportTime_ = builderForValue.build();
      } else {
        reportTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the data was reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp report_time = 10;</code>
     */
    public Builder mergeReportTime(com.google.protobuf.Timestamp value) {
      if (reportTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && reportTime_ != null
            && reportTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getReportTimeBuilder().mergeFrom(value);
        } else {
          reportTime_ = value;
        }
      } else {
        reportTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the data was reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp report_time = 10;</code>
     */
    public Builder clearReportTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      reportTime_ = null;
      if (reportTimeBuilder_ != null) {
        reportTimeBuilder_.dispose();
        reportTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the data was reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp report_time = 10;</code>
     */
    public com.google.protobuf.Timestamp.Builder getReportTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getReportTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time the data was reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp report_time = 10;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getReportTimeOrBuilder() {
      if (reportTimeBuilder_ != null) {
        return reportTimeBuilder_.getMessageOrBuilder();
      } else {
        return reportTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : reportTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time the data was reported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp report_time = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getReportTimeFieldBuilder() {
      if (reportTimeBuilder_ == null) {
        reportTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getReportTime(), getParentForChildren(), isClean());
        reportTime_ = null;
      }
      return reportTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000004;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels as key value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> attributes_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAttributes() {
      if (attributes_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AttributesDefaultEntryHolder.defaultEntry);
      }
      return attributes_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAttributes() {
      if (attributes_ == null) {
        attributes_ =
            com.google.protobuf.MapField.newMapField(AttributesDefaultEntryHolder.defaultEntry);
      }
      if (!attributes_.isMutable()) {
        attributes_ = attributes_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return attributes_;
    }

    public int getAttributesCount() {
      return internalGetAttributes().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Generic asset attributes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 12;</code>
     */
    @java.lang.Override
    public boolean containsAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAttributes().getMap().containsKey(key);
    }
    /** Use {@link #getAttributesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAttributes() {
      return getAttributesMap();
    }
    /**
     *
     *
     * <pre>
     * Generic asset attributes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 12;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAttributesMap() {
      return internalGetAttributes().getMap();
    }
    /**
     *
     *
     * <pre>
     * Generic asset attributes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 12;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAttributesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAttributes().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Generic asset attributes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 12;</code>
     */
    @java.lang.Override
    public java.lang.String getAttributesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAttributes().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAttributes() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableAttributes().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generic asset attributes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 12;</code>
     */
    public Builder removeAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAttributes().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAttributes() {
      bitField0_ |= 0x00000008;
      return internalGetMutableAttributes().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Generic asset attributes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 12;</code>
     */
    public Builder putAttributes(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAttributes().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Generic asset attributes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; attributes = 12;</code>
     */
    public Builder putAllAttributes(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAttributes().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private java.util.List<com.google.cloud.migrationcenter.v1.PerformanceSample>
        performanceSamples_ = java.util.Collections.emptyList();

    private void ensurePerformanceSamplesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        performanceSamples_ =
            new java.util.ArrayList<com.google.cloud.migrationcenter.v1.PerformanceSample>(
                performanceSamples_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.PerformanceSample,
            com.google.cloud.migrationcenter.v1.PerformanceSample.Builder,
            com.google.cloud.migrationcenter.v1.PerformanceSampleOrBuilder>
        performanceSamplesBuilder_;

    /**
     *
     *
     * <pre>
     * Asset performance data samples.
     * Samples that are from more than 40 days ago or after tomorrow are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
     * </code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.PerformanceSample>
        getPerformanceSamplesList() {
      if (performanceSamplesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(performanceSamples_);
      } else {
        return performanceSamplesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Asset performance data samples.
     * Samples that are from more than 40 days ago or after tomorrow are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
     * </code>
     */
    public int getPerformanceSamplesCount() {
      if (performanceSamplesBuilder_ == null) {
        return performanceSamples_.size();
      } else {
        return performanceSamplesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Asset performance data samples.
     * Samples that are from more than 40 days ago or after tomorrow are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.PerformanceSample getPerformanceSamples(int index) {
      if (performanceSamplesBuilder_ == null) {
        return performanceSamples_.get(index);
      } else {
        return performanceSamplesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Asset performance data samples.
     * Samples that are from more than 40 days ago or after tomorrow are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
     * </code>
     */
    public Builder setPerformanceSamples(
        int index, com.google.cloud.migrationcenter.v1.PerformanceSample value) {
      if (performanceSamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePerformanceSamplesIsMutable();
        performanceSamples_.set(index, value);
        onChanged();
      } else {
        performanceSamplesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Asset performance data samples.
     * Samples that are from more than 40 days ago or after tomorrow are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
     * </code>
     */
    public Builder setPerformanceSamples(
        int index, com.google.cloud.migrationcenter.v1.PerformanceSample.Builder builderForValue) {
      if (performanceSamplesBuilder_ == null) {
        ensurePerformanceSamplesIsMutable();
        performanceSamples_.set(index, builderForValue.build());
        onChanged();
      } else {
        performanceSamplesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Asset performance data samples.
     * Samples that are from more than 40 days ago or after tomorrow are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
     * </code>
     */
    public Builder addPerformanceSamples(
        com.google.cloud.migrationcenter.v1.PerformanceSample value) {
      if (performanceSamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePerformanceSamplesIsMutable();
        performanceSamples_.add(value);
        onChanged();
      } else {
        performanceSamplesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Asset performance data samples.
     * Samples that are from more than 40 days ago or after tomorrow are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
     * </code>
     */
    public Builder addPerformanceSamples(
        int index, com.google.cloud.migrationcenter.v1.PerformanceSample value) {
      if (performanceSamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePerformanceSamplesIsMutable();
        performanceSamples_.add(index, value);
        onChanged();
      } else {
        performanceSamplesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Asset performance data samples.
     * Samples that are from more than 40 days ago or after tomorrow are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
     * </code>
     */
    public Builder addPerformanceSamples(
        com.google.cloud.migrationcenter.v1.PerformanceSample.Builder builderForValue) {
      if (performanceSamplesBuilder_ == null) {
        ensurePerformanceSamplesIsMutable();
        performanceSamples_.add(builderForValue.build());
        onChanged();
      } else {
        performanceSamplesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Asset performance data samples.
     * Samples that are from more than 40 days ago or after tomorrow are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
     * </code>
     */
    public Builder addPerformanceSamples(
        int index, com.google.cloud.migrationcenter.v1.PerformanceSample.Builder builderForValue) {
      if (performanceSamplesBuilder_ == null) {
        ensurePerformanceSamplesIsMutable();
        performanceSamples_.add(index, builderForValue.build());
        onChanged();
      } else {
        performanceSamplesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Asset performance data samples.
     * Samples that are from more than 40 days ago or after tomorrow are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
     * </code>
     */
    public Builder addAllPerformanceSamples(
        java.lang.Iterable<? extends com.google.cloud.migrationcenter.v1.PerformanceSample>
            values) {
      if (performanceSamplesBuilder_ == null) {
        ensurePerformanceSamplesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, performanceSamples_);
        onChanged();
      } else {
        performanceSamplesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Asset performance data samples.
     * Samples that are from more than 40 days ago or after tomorrow are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
     * </code>
     */
    public Builder clearPerformanceSamples() {
      if (performanceSamplesBuilder_ == null) {
        performanceSamples_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        performanceSamplesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Asset performance data samples.
     * Samples that are from more than 40 days ago or after tomorrow are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
     * </code>
     */
    public Builder removePerformanceSamples(int index) {
      if (performanceSamplesBuilder_ == null) {
        ensurePerformanceSamplesIsMutable();
        performanceSamples_.remove(index);
        onChanged();
      } else {
        performanceSamplesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Asset performance data samples.
     * Samples that are from more than 40 days ago or after tomorrow are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.PerformanceSample.Builder
        getPerformanceSamplesBuilder(int index) {
      return getPerformanceSamplesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Asset performance data samples.
     * Samples that are from more than 40 days ago or after tomorrow are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.PerformanceSampleOrBuilder
        getPerformanceSamplesOrBuilder(int index) {
      if (performanceSamplesBuilder_ == null) {
        return performanceSamples_.get(index);
      } else {
        return performanceSamplesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Asset performance data samples.
     * Samples that are from more than 40 days ago or after tomorrow are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.migrationcenter.v1.PerformanceSampleOrBuilder>
        getPerformanceSamplesOrBuilderList() {
      if (performanceSamplesBuilder_ != null) {
        return performanceSamplesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(performanceSamples_);
      }
    }
    /**
     *
     *
     * <pre>
     * Asset performance data samples.
     * Samples that are from more than 40 days ago or after tomorrow are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.PerformanceSample.Builder
        addPerformanceSamplesBuilder() {
      return getPerformanceSamplesFieldBuilder()
          .addBuilder(com.google.cloud.migrationcenter.v1.PerformanceSample.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Asset performance data samples.
     * Samples that are from more than 40 days ago or after tomorrow are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.PerformanceSample.Builder
        addPerformanceSamplesBuilder(int index) {
      return getPerformanceSamplesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.migrationcenter.v1.PerformanceSample.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Asset performance data samples.
     * Samples that are from more than 40 days ago or after tomorrow are ignored.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.PerformanceSample performance_samples = 13;
     * </code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.PerformanceSample.Builder>
        getPerformanceSamplesBuilderList() {
      return getPerformanceSamplesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.PerformanceSample,
            com.google.cloud.migrationcenter.v1.PerformanceSample.Builder,
            com.google.cloud.migrationcenter.v1.PerformanceSampleOrBuilder>
        getPerformanceSamplesFieldBuilder() {
      if (performanceSamplesBuilder_ == null) {
        performanceSamplesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.PerformanceSample,
                com.google.cloud.migrationcenter.v1.PerformanceSample.Builder,
                com.google.cloud.migrationcenter.v1.PerformanceSampleOrBuilder>(
                performanceSamples_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        performanceSamples_ = null;
      }
      return performanceSamplesBuilder_;
    }

    private java.lang.Object traceToken_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Trace token is optionally provided to assist with debugging and
     * traceability.
     * </pre>
     *
     * <code>string trace_token = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The traceToken.
     */
    public java.lang.String getTraceToken() {
      java.lang.Object ref = traceToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        traceToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Trace token is optionally provided to assist with debugging and
     * traceability.
     * </pre>
     *
     * <code>string trace_token = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for traceToken.
     */
    public com.google.protobuf.ByteString getTraceTokenBytes() {
      java.lang.Object ref = traceToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        traceToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Trace token is optionally provided to assist with debugging and
     * traceability.
     * </pre>
     *
     * <code>string trace_token = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The traceToken to set.
     * @return This builder for chaining.
     */
    public Builder setTraceToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      traceToken_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Trace token is optionally provided to assist with debugging and
     * traceability.
     * </pre>
     *
     * <code>string trace_token = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTraceToken() {
      traceToken_ = getDefaultInstance().getTraceToken();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Trace token is optionally provided to assist with debugging and
     * traceability.
     * </pre>
     *
     * <code>string trace_token = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for traceToken to set.
     * @return This builder for chaining.
     */
    public Builder setTraceTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      traceToken_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.AssetFrame)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.AssetFrame)
  private static final com.google.cloud.migrationcenter.v1.AssetFrame DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.AssetFrame();
  }

  public static com.google.cloud.migrationcenter.v1.AssetFrame getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AssetFrame> PARSER =
      new com.google.protobuf.AbstractParser<AssetFrame>() {
        @java.lang.Override
        public AssetFrame parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AssetFrame> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AssetFrame> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AssetFrame getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
