/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * Compute Engine target shape descriptor.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor}
 */
public final class ComputeEngineShapeDescriptor extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor)
    ComputeEngineShapeDescriptorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ComputeEngineShapeDescriptor.newBuilder() to construct.
  private ComputeEngineShapeDescriptor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ComputeEngineShapeDescriptor() {
    series_ = "";
    machineType_ = "";
    storage_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ComputeEngineShapeDescriptor();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_ComputeEngineShapeDescriptor_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_ComputeEngineShapeDescriptor_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor.class,
            com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor.Builder.class);
  }

  public static final int MEMORY_MB_FIELD_NUMBER = 1;
  private int memoryMb_ = 0;
  /**
   *
   *
   * <pre>
   * Memory in mebibytes.
   * </pre>
   *
   * <code>int32 memory_mb = 1;</code>
   *
   * @return The memoryMb.
   */
  @java.lang.Override
  public int getMemoryMb() {
    return memoryMb_;
  }

  public static final int PHYSICAL_CORE_COUNT_FIELD_NUMBER = 2;
  private int physicalCoreCount_ = 0;
  /**
   *
   *
   * <pre>
   * Number of physical cores.
   * </pre>
   *
   * <code>int32 physical_core_count = 2;</code>
   *
   * @return The physicalCoreCount.
   */
  @java.lang.Override
  public int getPhysicalCoreCount() {
    return physicalCoreCount_;
  }

  public static final int LOGICAL_CORE_COUNT_FIELD_NUMBER = 3;
  private int logicalCoreCount_ = 0;
  /**
   *
   *
   * <pre>
   * Number of logical cores.
   * </pre>
   *
   * <code>int32 logical_core_count = 3;</code>
   *
   * @return The logicalCoreCount.
   */
  @java.lang.Override
  public int getLogicalCoreCount() {
    return logicalCoreCount_;
  }

  public static final int SERIES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object series_ = "";
  /**
   *
   *
   * <pre>
   * Compute Engine machine series.
   * </pre>
   *
   * <code>string series = 4;</code>
   *
   * @return The series.
   */
  @java.lang.Override
  public java.lang.String getSeries() {
    java.lang.Object ref = series_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      series_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Compute Engine machine series.
   * </pre>
   *
   * <code>string series = 4;</code>
   *
   * @return The bytes for series.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSeriesBytes() {
    java.lang.Object ref = series_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      series_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MACHINE_TYPE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object machineType_ = "";
  /**
   *
   *
   * <pre>
   * Compute Engine machine type.
   * </pre>
   *
   * <code>string machine_type = 5;</code>
   *
   * @return The machineType.
   */
  @java.lang.Override
  public java.lang.String getMachineType() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      machineType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Compute Engine machine type.
   * </pre>
   *
   * <code>string machine_type = 5;</code>
   *
   * @return The bytes for machineType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMachineTypeBytes() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      machineType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STORAGE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor> storage_;
  /**
   *
   *
   * <pre>
   * Compute Engine storage. Never empty.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor>
      getStorageList() {
    return storage_;
  }
  /**
   *
   *
   * <pre>
   * Compute Engine storage. Never empty.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.migrationcenter.v1.ComputeStorageDescriptorOrBuilder>
      getStorageOrBuilderList() {
    return storage_;
  }
  /**
   *
   *
   * <pre>
   * Compute Engine storage. Never empty.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
   */
  @java.lang.Override
  public int getStorageCount() {
    return storage_.size();
  }
  /**
   *
   *
   * <pre>
   * Compute Engine storage. Never empty.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor getStorage(int index) {
    return storage_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Compute Engine storage. Never empty.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ComputeStorageDescriptorOrBuilder getStorageOrBuilder(
      int index) {
    return storage_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (memoryMb_ != 0) {
      output.writeInt32(1, memoryMb_);
    }
    if (physicalCoreCount_ != 0) {
      output.writeInt32(2, physicalCoreCount_);
    }
    if (logicalCoreCount_ != 0) {
      output.writeInt32(3, logicalCoreCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(series_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, series_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, machineType_);
    }
    for (int i = 0; i < storage_.size(); i++) {
      output.writeMessage(6, storage_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (memoryMb_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, memoryMb_);
    }
    if (physicalCoreCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, physicalCoreCount_);
    }
    if (logicalCoreCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, logicalCoreCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(series_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, series_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(machineType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, machineType_);
    }
    for (int i = 0; i < storage_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, storage_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor other =
        (com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor) obj;

    if (getMemoryMb() != other.getMemoryMb()) return false;
    if (getPhysicalCoreCount() != other.getPhysicalCoreCount()) return false;
    if (getLogicalCoreCount() != other.getLogicalCoreCount()) return false;
    if (!getSeries().equals(other.getSeries())) return false;
    if (!getMachineType().equals(other.getMachineType())) return false;
    if (!getStorageList().equals(other.getStorageList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MEMORY_MB_FIELD_NUMBER;
    hash = (53 * hash) + getMemoryMb();
    hash = (37 * hash) + PHYSICAL_CORE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getPhysicalCoreCount();
    hash = (37 * hash) + LOGICAL_CORE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getLogicalCoreCount();
    hash = (37 * hash) + SERIES_FIELD_NUMBER;
    hash = (53 * hash) + getSeries().hashCode();
    hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getMachineType().hashCode();
    if (getStorageCount() > 0) {
      hash = (37 * hash) + STORAGE_FIELD_NUMBER;
      hash = (53 * hash) + getStorageList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Compute Engine target shape descriptor.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor)
      com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ComputeEngineShapeDescriptor_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ComputeEngineShapeDescriptor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor.class,
              com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      memoryMb_ = 0;
      physicalCoreCount_ = 0;
      logicalCoreCount_ = 0;
      series_ = "";
      machineType_ = "";
      if (storageBuilder_ == null) {
        storage_ = java.util.Collections.emptyList();
      } else {
        storage_ = null;
        storageBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ComputeEngineShapeDescriptor_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor
        getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor build() {
      com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor buildPartial() {
      com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor result =
          new com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor result) {
      if (storageBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          storage_ = java.util.Collections.unmodifiableList(storage_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.storage_ = storage_;
      } else {
        result.storage_ = storageBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.memoryMb_ = memoryMb_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.physicalCoreCount_ = physicalCoreCount_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.logicalCoreCount_ = logicalCoreCount_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.series_ = series_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.machineType_ = machineType_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor other) {
      if (other
          == com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor.getDefaultInstance())
        return this;
      if (other.getMemoryMb() != 0) {
        setMemoryMb(other.getMemoryMb());
      }
      if (other.getPhysicalCoreCount() != 0) {
        setPhysicalCoreCount(other.getPhysicalCoreCount());
      }
      if (other.getLogicalCoreCount() != 0) {
        setLogicalCoreCount(other.getLogicalCoreCount());
      }
      if (!other.getSeries().isEmpty()) {
        series_ = other.series_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getMachineType().isEmpty()) {
        machineType_ = other.machineType_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (storageBuilder_ == null) {
        if (!other.storage_.isEmpty()) {
          if (storage_.isEmpty()) {
            storage_ = other.storage_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureStorageIsMutable();
            storage_.addAll(other.storage_);
          }
          onChanged();
        }
      } else {
        if (!other.storage_.isEmpty()) {
          if (storageBuilder_.isEmpty()) {
            storageBuilder_.dispose();
            storageBuilder_ = null;
            storage_ = other.storage_;
            bitField0_ = (bitField0_ & ~0x00000020);
            storageBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStorageFieldBuilder()
                    : null;
          } else {
            storageBuilder_.addAllMessages(other.storage_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                memoryMb_ = input.readInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                physicalCoreCount_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                logicalCoreCount_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                series_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                machineType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor m =
                    input.readMessage(
                        com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor.parser(),
                        extensionRegistry);
                if (storageBuilder_ == null) {
                  ensureStorageIsMutable();
                  storage_.add(m);
                } else {
                  storageBuilder_.addMessage(m);
                }
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int memoryMb_;
    /**
     *
     *
     * <pre>
     * Memory in mebibytes.
     * </pre>
     *
     * <code>int32 memory_mb = 1;</code>
     *
     * @return The memoryMb.
     */
    @java.lang.Override
    public int getMemoryMb() {
      return memoryMb_;
    }
    /**
     *
     *
     * <pre>
     * Memory in mebibytes.
     * </pre>
     *
     * <code>int32 memory_mb = 1;</code>
     *
     * @param value The memoryMb to set.
     * @return This builder for chaining.
     */
    public Builder setMemoryMb(int value) {

      memoryMb_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Memory in mebibytes.
     * </pre>
     *
     * <code>int32 memory_mb = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMemoryMb() {
      bitField0_ = (bitField0_ & ~0x00000001);
      memoryMb_ = 0;
      onChanged();
      return this;
    }

    private int physicalCoreCount_;
    /**
     *
     *
     * <pre>
     * Number of physical cores.
     * </pre>
     *
     * <code>int32 physical_core_count = 2;</code>
     *
     * @return The physicalCoreCount.
     */
    @java.lang.Override
    public int getPhysicalCoreCount() {
      return physicalCoreCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of physical cores.
     * </pre>
     *
     * <code>int32 physical_core_count = 2;</code>
     *
     * @param value The physicalCoreCount to set.
     * @return This builder for chaining.
     */
    public Builder setPhysicalCoreCount(int value) {

      physicalCoreCount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of physical cores.
     * </pre>
     *
     * <code>int32 physical_core_count = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPhysicalCoreCount() {
      bitField0_ = (bitField0_ & ~0x00000002);
      physicalCoreCount_ = 0;
      onChanged();
      return this;
    }

    private int logicalCoreCount_;
    /**
     *
     *
     * <pre>
     * Number of logical cores.
     * </pre>
     *
     * <code>int32 logical_core_count = 3;</code>
     *
     * @return The logicalCoreCount.
     */
    @java.lang.Override
    public int getLogicalCoreCount() {
      return logicalCoreCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of logical cores.
     * </pre>
     *
     * <code>int32 logical_core_count = 3;</code>
     *
     * @param value The logicalCoreCount to set.
     * @return This builder for chaining.
     */
    public Builder setLogicalCoreCount(int value) {

      logicalCoreCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of logical cores.
     * </pre>
     *
     * <code>int32 logical_core_count = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLogicalCoreCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      logicalCoreCount_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object series_ = "";
    /**
     *
     *
     * <pre>
     * Compute Engine machine series.
     * </pre>
     *
     * <code>string series = 4;</code>
     *
     * @return The series.
     */
    public java.lang.String getSeries() {
      java.lang.Object ref = series_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        series_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series.
     * </pre>
     *
     * <code>string series = 4;</code>
     *
     * @return The bytes for series.
     */
    public com.google.protobuf.ByteString getSeriesBytes() {
      java.lang.Object ref = series_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        series_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series.
     * </pre>
     *
     * <code>string series = 4;</code>
     *
     * @param value The series to set.
     * @return This builder for chaining.
     */
    public Builder setSeries(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      series_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series.
     * </pre>
     *
     * <code>string series = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSeries() {
      series_ = getDefaultInstance().getSeries();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine series.
     * </pre>
     *
     * <code>string series = 4;</code>
     *
     * @param value The bytes for series to set.
     * @return This builder for chaining.
     */
    public Builder setSeriesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      series_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object machineType_ = "";
    /**
     *
     *
     * <pre>
     * Compute Engine machine type.
     * </pre>
     *
     * <code>string machine_type = 5;</code>
     *
     * @return The machineType.
     */
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine type.
     * </pre>
     *
     * <code>string machine_type = 5;</code>
     *
     * @return The bytes for machineType.
     */
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine type.
     * </pre>
     *
     * <code>string machine_type = 5;</code>
     *
     * @param value The machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      machineType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine type.
     * </pre>
     *
     * <code>string machine_type = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMachineType() {
      machineType_ = getDefaultInstance().getMachineType();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine machine type.
     * </pre>
     *
     * <code>string machine_type = 5;</code>
     *
     * @param value The bytes for machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      machineType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor> storage_ =
        java.util.Collections.emptyList();

    private void ensureStorageIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        storage_ =
            new java.util.ArrayList<com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor>(
                storage_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor,
            com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor.Builder,
            com.google.cloud.migrationcenter.v1.ComputeStorageDescriptorOrBuilder>
        storageBuilder_;

    /**
     *
     *
     * <pre>
     * Compute Engine storage. Never empty.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor>
        getStorageList() {
      if (storageBuilder_ == null) {
        return java.util.Collections.unmodifiableList(storage_);
      } else {
        return storageBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Compute Engine storage. Never empty.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
     */
    public int getStorageCount() {
      if (storageBuilder_ == null) {
        return storage_.size();
      } else {
        return storageBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Compute Engine storage. Never empty.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
     */
    public com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor getStorage(int index) {
      if (storageBuilder_ == null) {
        return storage_.get(index);
      } else {
        return storageBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Compute Engine storage. Never empty.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
     */
    public Builder setStorage(
        int index, com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor value) {
      if (storageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStorageIsMutable();
        storage_.set(index, value);
        onChanged();
      } else {
        storageBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine storage. Never empty.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
     */
    public Builder setStorage(
        int index,
        com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor.Builder builderForValue) {
      if (storageBuilder_ == null) {
        ensureStorageIsMutable();
        storage_.set(index, builderForValue.build());
        onChanged();
      } else {
        storageBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine storage. Never empty.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
     */
    public Builder addStorage(com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor value) {
      if (storageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStorageIsMutable();
        storage_.add(value);
        onChanged();
      } else {
        storageBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine storage. Never empty.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
     */
    public Builder addStorage(
        int index, com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor value) {
      if (storageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStorageIsMutable();
        storage_.add(index, value);
        onChanged();
      } else {
        storageBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine storage. Never empty.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
     */
    public Builder addStorage(
        com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor.Builder builderForValue) {
      if (storageBuilder_ == null) {
        ensureStorageIsMutable();
        storage_.add(builderForValue.build());
        onChanged();
      } else {
        storageBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine storage. Never empty.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
     */
    public Builder addStorage(
        int index,
        com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor.Builder builderForValue) {
      if (storageBuilder_ == null) {
        ensureStorageIsMutable();
        storage_.add(index, builderForValue.build());
        onChanged();
      } else {
        storageBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine storage. Never empty.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
     */
    public Builder addAllStorage(
        java.lang.Iterable<? extends com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor>
            values) {
      if (storageBuilder_ == null) {
        ensureStorageIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, storage_);
        onChanged();
      } else {
        storageBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine storage. Never empty.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
     */
    public Builder clearStorage() {
      if (storageBuilder_ == null) {
        storage_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        storageBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine storage. Never empty.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
     */
    public Builder removeStorage(int index) {
      if (storageBuilder_ == null) {
        ensureStorageIsMutable();
        storage_.remove(index);
        onChanged();
      } else {
        storageBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Compute Engine storage. Never empty.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
     */
    public com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor.Builder getStorageBuilder(
        int index) {
      return getStorageFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Compute Engine storage. Never empty.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
     */
    public com.google.cloud.migrationcenter.v1.ComputeStorageDescriptorOrBuilder
        getStorageOrBuilder(int index) {
      if (storageBuilder_ == null) {
        return storage_.get(index);
      } else {
        return storageBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Compute Engine storage. Never empty.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.migrationcenter.v1.ComputeStorageDescriptorOrBuilder>
        getStorageOrBuilderList() {
      if (storageBuilder_ != null) {
        return storageBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(storage_);
      }
    }
    /**
     *
     *
     * <pre>
     * Compute Engine storage. Never empty.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
     */
    public com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor.Builder
        addStorageBuilder() {
      return getStorageFieldBuilder()
          .addBuilder(
              com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Compute Engine storage. Never empty.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
     */
    public com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor.Builder addStorageBuilder(
        int index) {
      return getStorageFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Compute Engine storage. Never empty.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ComputeStorageDescriptor storage = 6;</code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor.Builder>
        getStorageBuilderList() {
      return getStorageFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor,
            com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor.Builder,
            com.google.cloud.migrationcenter.v1.ComputeStorageDescriptorOrBuilder>
        getStorageFieldBuilder() {
      if (storageBuilder_ == null) {
        storageBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor,
                com.google.cloud.migrationcenter.v1.ComputeStorageDescriptor.Builder,
                com.google.cloud.migrationcenter.v1.ComputeStorageDescriptorOrBuilder>(
                storage_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        storage_ = null;
      }
      return storageBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor)
  private static final com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor();
  }

  public static com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ComputeEngineShapeDescriptor> PARSER =
      new com.google.protobuf.AbstractParser<ComputeEngineShapeDescriptor>() {
        @java.lang.Override
        public ComputeEngineShapeDescriptor parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ComputeEngineShapeDescriptor> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ComputeEngineShapeDescriptor> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ComputeEngineShapeDescriptor
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
