/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * A request to create a preference set.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.CreatePreferenceSetRequest}
 */
public final class CreatePreferenceSetRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.CreatePreferenceSetRequest)
    CreatePreferenceSetRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreatePreferenceSetRequest.newBuilder() to construct.
  private CreatePreferenceSetRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreatePreferenceSetRequest() {
    parent_ = "";
    preferenceSetId_ = "";
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreatePreferenceSetRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_CreatePreferenceSetRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_CreatePreferenceSetRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest.class,
            com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. Value for parent.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Value for parent.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREFERENCE_SET_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object preferenceSetId_ = "";
  /**
   *
   *
   * <pre>
   * Required. User specified ID for the preference set. It will become the last
   * component of the preference set name. The ID must be unique within the
   * project, must conform with RFC-1034, is restricted to lower-cased letters,
   * and has a maximum length of 63 characters. The ID must match the regular
   * expression
   * `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
   * </pre>
   *
   * <code>string preference_set_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The preferenceSetId.
   */
  @java.lang.Override
  public java.lang.String getPreferenceSetId() {
    java.lang.Object ref = preferenceSetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      preferenceSetId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. User specified ID for the preference set. It will become the last
   * component of the preference set name. The ID must be unique within the
   * project, must conform with RFC-1034, is restricted to lower-cased letters,
   * and has a maximum length of 63 characters. The ID must match the regular
   * expression
   * `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
   * </pre>
   *
   * <code>string preference_set_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for preferenceSetId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPreferenceSetIdBytes() {
    java.lang.Object ref = preferenceSetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      preferenceSetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PREFERENCE_SET_FIELD_NUMBER = 3;
  private com.google.cloud.migrationcenter.v1.PreferenceSet preferenceSet_;
  /**
   *
   *
   * <pre>
   * Required. The preference set resource being created.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.PreferenceSet preference_set = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the preferenceSet field is set.
   */
  @java.lang.Override
  public boolean hasPreferenceSet() {
    return preferenceSet_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The preference set resource being created.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.PreferenceSet preference_set = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The preferenceSet.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.PreferenceSet getPreferenceSet() {
    return preferenceSet_ == null
        ? com.google.cloud.migrationcenter.v1.PreferenceSet.getDefaultInstance()
        : preferenceSet_;
  }
  /**
   *
   *
   * <pre>
   * Required. The preference set resource being created.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.PreferenceSet preference_set = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.PreferenceSetOrBuilder getPreferenceSetOrBuilder() {
    return preferenceSet_ == null
        ? com.google.cloud.migrationcenter.v1.PreferenceSet.getDefaultInstance()
        : preferenceSet_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. An optional request ID to identify requests. Specify a unique
   * request ID so that if you must retry your request, the server will know to
   * ignore the request if it has already been completed. The server will
   * guarantee that for at least 60 minutes since the first request.
   *
   * For example, consider a situation where you make an initial request and
   * the request times out. If you make the request again with the same request
   * ID, the server can check if original operation with the same request ID
   * was received, and if so, will ignore the second request. This prevents
   * clients from accidentally creating duplicate commitments.
   *
   * The request ID must be a valid UUID with the exception that zero UUID is
   * not supported (00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. An optional request ID to identify requests. Specify a unique
   * request ID so that if you must retry your request, the server will know to
   * ignore the request if it has already been completed. The server will
   * guarantee that for at least 60 minutes since the first request.
   *
   * For example, consider a situation where you make an initial request and
   * the request times out. If you make the request again with the same request
   * ID, the server can check if original operation with the same request ID
   * was received, and if so, will ignore the second request. This prevents
   * clients from accidentally creating duplicate commitments.
   *
   * The request ID must be a valid UUID with the exception that zero UUID is
   * not supported (00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(preferenceSetId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, preferenceSetId_);
    }
    if (preferenceSet_ != null) {
      output.writeMessage(3, getPreferenceSet());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, requestId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(preferenceSetId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, preferenceSetId_);
    }
    if (preferenceSet_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getPreferenceSet());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, requestId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest other =
        (com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getPreferenceSetId().equals(other.getPreferenceSetId())) return false;
    if (hasPreferenceSet() != other.hasPreferenceSet()) return false;
    if (hasPreferenceSet()) {
      if (!getPreferenceSet().equals(other.getPreferenceSet())) return false;
    }
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + PREFERENCE_SET_ID_FIELD_NUMBER;
    hash = (53 * hash) + getPreferenceSetId().hashCode();
    if (hasPreferenceSet()) {
      hash = (37 * hash) + PREFERENCE_SET_FIELD_NUMBER;
      hash = (53 * hash) + getPreferenceSet().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request to create a preference set.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.CreatePreferenceSetRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.CreatePreferenceSetRequest)
      com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_CreatePreferenceSetRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_CreatePreferenceSetRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest.class,
              com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      preferenceSetId_ = "";
      preferenceSet_ = null;
      if (preferenceSetBuilder_ != null) {
        preferenceSetBuilder_.dispose();
        preferenceSetBuilder_ = null;
      }
      requestId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_CreatePreferenceSetRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest
        getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest build() {
      com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest buildPartial() {
      com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest result =
          new com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.preferenceSetId_ = preferenceSetId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.preferenceSet_ =
            preferenceSetBuilder_ == null ? preferenceSet_ : preferenceSetBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.requestId_ = requestId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest other) {
      if (other
          == com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getPreferenceSetId().isEmpty()) {
        preferenceSetId_ = other.preferenceSetId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasPreferenceSet()) {
        mergePreferenceSet(other.getPreferenceSet());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                preferenceSetId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getPreferenceSetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Value for parent.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Value for parent.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Value for parent.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Value for parent.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Value for parent.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object preferenceSetId_ = "";
    /**
     *
     *
     * <pre>
     * Required. User specified ID for the preference set. It will become the last
     * component of the preference set name. The ID must be unique within the
     * project, must conform with RFC-1034, is restricted to lower-cased letters,
     * and has a maximum length of 63 characters. The ID must match the regular
     * expression
     * `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
     * </pre>
     *
     * <code>string preference_set_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The preferenceSetId.
     */
    public java.lang.String getPreferenceSetId() {
      java.lang.Object ref = preferenceSetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        preferenceSetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. User specified ID for the preference set. It will become the last
     * component of the preference set name. The ID must be unique within the
     * project, must conform with RFC-1034, is restricted to lower-cased letters,
     * and has a maximum length of 63 characters. The ID must match the regular
     * expression
     * `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
     * </pre>
     *
     * <code>string preference_set_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for preferenceSetId.
     */
    public com.google.protobuf.ByteString getPreferenceSetIdBytes() {
      java.lang.Object ref = preferenceSetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        preferenceSetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. User specified ID for the preference set. It will become the last
     * component of the preference set name. The ID must be unique within the
     * project, must conform with RFC-1034, is restricted to lower-cased letters,
     * and has a maximum length of 63 characters. The ID must match the regular
     * expression
     * `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
     * </pre>
     *
     * <code>string preference_set_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The preferenceSetId to set.
     * @return This builder for chaining.
     */
    public Builder setPreferenceSetId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      preferenceSetId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. User specified ID for the preference set. It will become the last
     * component of the preference set name. The ID must be unique within the
     * project, must conform with RFC-1034, is restricted to lower-cased letters,
     * and has a maximum length of 63 characters. The ID must match the regular
     * expression
     * `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
     * </pre>
     *
     * <code>string preference_set_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPreferenceSetId() {
      preferenceSetId_ = getDefaultInstance().getPreferenceSetId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. User specified ID for the preference set. It will become the last
     * component of the preference set name. The ID must be unique within the
     * project, must conform with RFC-1034, is restricted to lower-cased letters,
     * and has a maximum length of 63 characters. The ID must match the regular
     * expression
     * `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
     * </pre>
     *
     * <code>string preference_set_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for preferenceSetId to set.
     * @return This builder for chaining.
     */
    public Builder setPreferenceSetIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      preferenceSetId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.migrationcenter.v1.PreferenceSet preferenceSet_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.PreferenceSet,
            com.google.cloud.migrationcenter.v1.PreferenceSet.Builder,
            com.google.cloud.migrationcenter.v1.PreferenceSetOrBuilder>
        preferenceSetBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The preference set resource being created.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.PreferenceSet preference_set = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the preferenceSet field is set.
     */
    public boolean hasPreferenceSet() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The preference set resource being created.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.PreferenceSet preference_set = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The preferenceSet.
     */
    public com.google.cloud.migrationcenter.v1.PreferenceSet getPreferenceSet() {
      if (preferenceSetBuilder_ == null) {
        return preferenceSet_ == null
            ? com.google.cloud.migrationcenter.v1.PreferenceSet.getDefaultInstance()
            : preferenceSet_;
      } else {
        return preferenceSetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The preference set resource being created.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.PreferenceSet preference_set = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPreferenceSet(com.google.cloud.migrationcenter.v1.PreferenceSet value) {
      if (preferenceSetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        preferenceSet_ = value;
      } else {
        preferenceSetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The preference set resource being created.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.PreferenceSet preference_set = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPreferenceSet(
        com.google.cloud.migrationcenter.v1.PreferenceSet.Builder builderForValue) {
      if (preferenceSetBuilder_ == null) {
        preferenceSet_ = builderForValue.build();
      } else {
        preferenceSetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The preference set resource being created.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.PreferenceSet preference_set = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergePreferenceSet(com.google.cloud.migrationcenter.v1.PreferenceSet value) {
      if (preferenceSetBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && preferenceSet_ != null
            && preferenceSet_
                != com.google.cloud.migrationcenter.v1.PreferenceSet.getDefaultInstance()) {
          getPreferenceSetBuilder().mergeFrom(value);
        } else {
          preferenceSet_ = value;
        }
      } else {
        preferenceSetBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The preference set resource being created.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.PreferenceSet preference_set = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearPreferenceSet() {
      bitField0_ = (bitField0_ & ~0x00000004);
      preferenceSet_ = null;
      if (preferenceSetBuilder_ != null) {
        preferenceSetBuilder_.dispose();
        preferenceSetBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The preference set resource being created.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.PreferenceSet preference_set = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.PreferenceSet.Builder getPreferenceSetBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getPreferenceSetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The preference set resource being created.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.PreferenceSet preference_set = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.PreferenceSetOrBuilder getPreferenceSetOrBuilder() {
      if (preferenceSetBuilder_ != null) {
        return preferenceSetBuilder_.getMessageOrBuilder();
      } else {
        return preferenceSet_ == null
            ? com.google.cloud.migrationcenter.v1.PreferenceSet.getDefaultInstance()
            : preferenceSet_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The preference set resource being created.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.PreferenceSet preference_set = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.PreferenceSet,
            com.google.cloud.migrationcenter.v1.PreferenceSet.Builder,
            com.google.cloud.migrationcenter.v1.PreferenceSetOrBuilder>
        getPreferenceSetFieldBuilder() {
      if (preferenceSetBuilder_ == null) {
        preferenceSetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.PreferenceSet,
                com.google.cloud.migrationcenter.v1.PreferenceSet.Builder,
                com.google.cloud.migrationcenter.v1.PreferenceSetOrBuilder>(
                getPreferenceSet(), getParentForChildren(), isClean());
        preferenceSet_ = null;
      }
      return preferenceSetBuilder_;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.CreatePreferenceSetRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.CreatePreferenceSetRequest)
  private static final com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest();
  }

  public static com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreatePreferenceSetRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreatePreferenceSetRequest>() {
        @java.lang.Override
        public CreatePreferenceSetRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreatePreferenceSetRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreatePreferenceSetRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.CreatePreferenceSetRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
