/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * Usage data aggregation for a single day.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.DailyResourceUsageAggregation}
 */
public final class DailyResourceUsageAggregation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation)
    DailyResourceUsageAggregationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DailyResourceUsageAggregation.newBuilder() to construct.
  private DailyResourceUsageAggregation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DailyResourceUsageAggregation() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DailyResourceUsageAggregation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.class,
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Builder.class);
  }

  public interface StatsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Average usage value.
     * </pre>
     *
     * <code>float average = 1;</code>
     *
     * @return The average.
     */
    float getAverage();

    /**
     *
     *
     * <pre>
     * Median usage value.
     * </pre>
     *
     * <code>float median = 2;</code>
     *
     * @return The median.
     */
    float getMedian();

    /**
     *
     *
     * <pre>
     * 95th percentile usage value.
     * </pre>
     *
     * <code>float nintey_fifth_percentile = 3;</code>
     *
     * @return The ninteyFifthPercentile.
     */
    float getNinteyFifthPercentile();

    /**
     *
     *
     * <pre>
     * Peak usage value.
     * </pre>
     *
     * <code>float peak = 4;</code>
     *
     * @return The peak.
     */
    float getPeak();
  }
  /**
   *
   *
   * <pre>
   * Statistical aggregation of samples for a single resource usage.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats}
   */
  public static final class Stats extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats)
      StatsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Stats.newBuilder() to construct.
    private Stats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Stats() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Stats();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Stats_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Stats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.class,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder
                  .class);
    }

    public static final int AVERAGE_FIELD_NUMBER = 1;
    private float average_ = 0F;
    /**
     *
     *
     * <pre>
     * Average usage value.
     * </pre>
     *
     * <code>float average = 1;</code>
     *
     * @return The average.
     */
    @java.lang.Override
    public float getAverage() {
      return average_;
    }

    public static final int MEDIAN_FIELD_NUMBER = 2;
    private float median_ = 0F;
    /**
     *
     *
     * <pre>
     * Median usage value.
     * </pre>
     *
     * <code>float median = 2;</code>
     *
     * @return The median.
     */
    @java.lang.Override
    public float getMedian() {
      return median_;
    }

    public static final int NINTEY_FIFTH_PERCENTILE_FIELD_NUMBER = 3;
    private float ninteyFifthPercentile_ = 0F;
    /**
     *
     *
     * <pre>
     * 95th percentile usage value.
     * </pre>
     *
     * <code>float nintey_fifth_percentile = 3;</code>
     *
     * @return The ninteyFifthPercentile.
     */
    @java.lang.Override
    public float getNinteyFifthPercentile() {
      return ninteyFifthPercentile_;
    }

    public static final int PEAK_FIELD_NUMBER = 4;
    private float peak_ = 0F;
    /**
     *
     *
     * <pre>
     * Peak usage value.
     * </pre>
     *
     * <code>float peak = 4;</code>
     *
     * @return The peak.
     */
    @java.lang.Override
    public float getPeak() {
      return peak_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Float.floatToRawIntBits(average_) != 0) {
        output.writeFloat(1, average_);
      }
      if (java.lang.Float.floatToRawIntBits(median_) != 0) {
        output.writeFloat(2, median_);
      }
      if (java.lang.Float.floatToRawIntBits(ninteyFifthPercentile_) != 0) {
        output.writeFloat(3, ninteyFifthPercentile_);
      }
      if (java.lang.Float.floatToRawIntBits(peak_) != 0) {
        output.writeFloat(4, peak_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Float.floatToRawIntBits(average_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, average_);
      }
      if (java.lang.Float.floatToRawIntBits(median_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, median_);
      }
      if (java.lang.Float.floatToRawIntBits(ninteyFifthPercentile_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, ninteyFifthPercentile_);
      }
      if (java.lang.Float.floatToRawIntBits(peak_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, peak_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats other =
          (com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats) obj;

      if (java.lang.Float.floatToIntBits(getAverage())
          != java.lang.Float.floatToIntBits(other.getAverage())) return false;
      if (java.lang.Float.floatToIntBits(getMedian())
          != java.lang.Float.floatToIntBits(other.getMedian())) return false;
      if (java.lang.Float.floatToIntBits(getNinteyFifthPercentile())
          != java.lang.Float.floatToIntBits(other.getNinteyFifthPercentile())) return false;
      if (java.lang.Float.floatToIntBits(getPeak())
          != java.lang.Float.floatToIntBits(other.getPeak())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + AVERAGE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getAverage());
      hash = (37 * hash) + MEDIAN_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getMedian());
      hash = (37 * hash) + NINTEY_FIFTH_PERCENTILE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getNinteyFifthPercentile());
      hash = (37 * hash) + PEAK_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getPeak());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Statistical aggregation of samples for a single resource usage.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats)
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Stats_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Stats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.class,
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        average_ = 0F;
        median_ = 0F;
        ninteyFifthPercentile_ = 0F;
        peak_ = 0F;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Stats_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats build() {
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
          buildPartial() {
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats result =
            new com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.average_ = average_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.median_ = median_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.ninteyFifthPercentile_ = ninteyFifthPercentile_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.peak_ = peak_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats) {
          return mergeFrom(
              (com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats other) {
        if (other
            == com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
                .getDefaultInstance()) return this;
        if (other.getAverage() != 0F) {
          setAverage(other.getAverage());
        }
        if (other.getMedian() != 0F) {
          setMedian(other.getMedian());
        }
        if (other.getNinteyFifthPercentile() != 0F) {
          setNinteyFifthPercentile(other.getNinteyFifthPercentile());
        }
        if (other.getPeak() != 0F) {
          setPeak(other.getPeak());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 13:
                {
                  average_ = input.readFloat();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 13
              case 21:
                {
                  median_ = input.readFloat();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 21
              case 29:
                {
                  ninteyFifthPercentile_ = input.readFloat();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 29
              case 37:
                {
                  peak_ = input.readFloat();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 37
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private float average_;
      /**
       *
       *
       * <pre>
       * Average usage value.
       * </pre>
       *
       * <code>float average = 1;</code>
       *
       * @return The average.
       */
      @java.lang.Override
      public float getAverage() {
        return average_;
      }
      /**
       *
       *
       * <pre>
       * Average usage value.
       * </pre>
       *
       * <code>float average = 1;</code>
       *
       * @param value The average to set.
       * @return This builder for chaining.
       */
      public Builder setAverage(float value) {

        average_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Average usage value.
       * </pre>
       *
       * <code>float average = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAverage() {
        bitField0_ = (bitField0_ & ~0x00000001);
        average_ = 0F;
        onChanged();
        return this;
      }

      private float median_;
      /**
       *
       *
       * <pre>
       * Median usage value.
       * </pre>
       *
       * <code>float median = 2;</code>
       *
       * @return The median.
       */
      @java.lang.Override
      public float getMedian() {
        return median_;
      }
      /**
       *
       *
       * <pre>
       * Median usage value.
       * </pre>
       *
       * <code>float median = 2;</code>
       *
       * @param value The median to set.
       * @return This builder for chaining.
       */
      public Builder setMedian(float value) {

        median_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Median usage value.
       * </pre>
       *
       * <code>float median = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMedian() {
        bitField0_ = (bitField0_ & ~0x00000002);
        median_ = 0F;
        onChanged();
        return this;
      }

      private float ninteyFifthPercentile_;
      /**
       *
       *
       * <pre>
       * 95th percentile usage value.
       * </pre>
       *
       * <code>float nintey_fifth_percentile = 3;</code>
       *
       * @return The ninteyFifthPercentile.
       */
      @java.lang.Override
      public float getNinteyFifthPercentile() {
        return ninteyFifthPercentile_;
      }
      /**
       *
       *
       * <pre>
       * 95th percentile usage value.
       * </pre>
       *
       * <code>float nintey_fifth_percentile = 3;</code>
       *
       * @param value The ninteyFifthPercentile to set.
       * @return This builder for chaining.
       */
      public Builder setNinteyFifthPercentile(float value) {

        ninteyFifthPercentile_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * 95th percentile usage value.
       * </pre>
       *
       * <code>float nintey_fifth_percentile = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNinteyFifthPercentile() {
        bitField0_ = (bitField0_ & ~0x00000004);
        ninteyFifthPercentile_ = 0F;
        onChanged();
        return this;
      }

      private float peak_;
      /**
       *
       *
       * <pre>
       * Peak usage value.
       * </pre>
       *
       * <code>float peak = 4;</code>
       *
       * @return The peak.
       */
      @java.lang.Override
      public float getPeak() {
        return peak_;
      }
      /**
       *
       *
       * <pre>
       * Peak usage value.
       * </pre>
       *
       * <code>float peak = 4;</code>
       *
       * @param value The peak to set.
       * @return This builder for chaining.
       */
      public Builder setPeak(float value) {

        peak_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Peak usage value.
       * </pre>
       *
       * <code>float peak = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPeak() {
        bitField0_ = (bitField0_ & ~0x00000008);
        peak_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats)
    private static final com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats();
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Stats> PARSER =
        new com.google.protobuf.AbstractParser<Stats>() {
          @java.lang.Override
          public Stats parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Stats> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Stats> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CPUOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * CPU utilization percentage.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
     * </code>
     *
     * @return Whether the utilizationPercentage field is set.
     */
    boolean hasUtilizationPercentage();
    /**
     *
     *
     * <pre>
     * CPU utilization percentage.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
     * </code>
     *
     * @return The utilizationPercentage.
     */
    com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
        getUtilizationPercentage();
    /**
     *
     *
     * <pre>
     * CPU utilization percentage.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder
        getUtilizationPercentageOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Statistical aggregation of CPU usage.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU}
   */
  public static final class CPU extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU)
      CPUOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CPU.newBuilder() to construct.
    private CPU(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CPU() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CPU();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_CPU_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_CPU_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU.class,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU.Builder.class);
    }

    public static final int UTILIZATION_PERCENTAGE_FIELD_NUMBER = 1;
    private com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
        utilizationPercentage_;
    /**
     *
     *
     * <pre>
     * CPU utilization percentage.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
     * </code>
     *
     * @return Whether the utilizationPercentage field is set.
     */
    @java.lang.Override
    public boolean hasUtilizationPercentage() {
      return utilizationPercentage_ != null;
    }
    /**
     *
     *
     * <pre>
     * CPU utilization percentage.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
     * </code>
     *
     * @return The utilizationPercentage.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
        getUtilizationPercentage() {
      return utilizationPercentage_ == null
          ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
              .getDefaultInstance()
          : utilizationPercentage_;
    }
    /**
     *
     *
     * <pre>
     * CPU utilization percentage.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder
        getUtilizationPercentageOrBuilder() {
      return utilizationPercentage_ == null
          ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
              .getDefaultInstance()
          : utilizationPercentage_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (utilizationPercentage_ != null) {
        output.writeMessage(1, getUtilizationPercentage());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (utilizationPercentage_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, getUtilizationPercentage());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU other =
          (com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU) obj;

      if (hasUtilizationPercentage() != other.hasUtilizationPercentage()) return false;
      if (hasUtilizationPercentage()) {
        if (!getUtilizationPercentage().equals(other.getUtilizationPercentage())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasUtilizationPercentage()) {
        hash = (37 * hash) + UTILIZATION_PERCENTAGE_FIELD_NUMBER;
        hash = (53 * hash) + getUtilizationPercentage().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Statistical aggregation of CPU usage.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU)
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPUOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_CPU_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_CPU_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU.class,
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU
                    .Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        utilizationPercentage_ = null;
        if (utilizationPercentageBuilder_ != null) {
          utilizationPercentageBuilder_.dispose();
          utilizationPercentageBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_CPU_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU build() {
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU buildPartial() {
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU result =
            new com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.utilizationPercentage_ =
              utilizationPercentageBuilder_ == null
                  ? utilizationPercentage_
                  : utilizationPercentageBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU) {
          return mergeFrom(
              (com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU other) {
        if (other
            == com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU
                .getDefaultInstance()) return this;
        if (other.hasUtilizationPercentage()) {
          mergeUtilizationPercentage(other.getUtilizationPercentage());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getUtilizationPercentageFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
          utilizationPercentage_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder>
          utilizationPercentageBuilder_;
      /**
       *
       *
       * <pre>
       * CPU utilization percentage.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
       * </code>
       *
       * @return Whether the utilizationPercentage field is set.
       */
      public boolean hasUtilizationPercentage() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * CPU utilization percentage.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
       * </code>
       *
       * @return The utilizationPercentage.
       */
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
          getUtilizationPercentage() {
        if (utilizationPercentageBuilder_ == null) {
          return utilizationPercentage_ == null
              ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
                  .getDefaultInstance()
              : utilizationPercentage_;
        } else {
          return utilizationPercentageBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * CPU utilization percentage.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
       * </code>
       */
      public Builder setUtilizationPercentage(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats value) {
        if (utilizationPercentageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          utilizationPercentage_ = value;
        } else {
          utilizationPercentageBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * CPU utilization percentage.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
       * </code>
       */
      public Builder setUtilizationPercentage(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder
              builderForValue) {
        if (utilizationPercentageBuilder_ == null) {
          utilizationPercentage_ = builderForValue.build();
        } else {
          utilizationPercentageBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * CPU utilization percentage.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
       * </code>
       */
      public Builder mergeUtilizationPercentage(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats value) {
        if (utilizationPercentageBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && utilizationPercentage_ != null
              && utilizationPercentage_
                  != com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
                      .getDefaultInstance()) {
            getUtilizationPercentageBuilder().mergeFrom(value);
          } else {
            utilizationPercentage_ = value;
          }
        } else {
          utilizationPercentageBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * CPU utilization percentage.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
       * </code>
       */
      public Builder clearUtilizationPercentage() {
        bitField0_ = (bitField0_ & ~0x00000001);
        utilizationPercentage_ = null;
        if (utilizationPercentageBuilder_ != null) {
          utilizationPercentageBuilder_.dispose();
          utilizationPercentageBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * CPU utilization percentage.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder
          getUtilizationPercentageBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getUtilizationPercentageFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * CPU utilization percentage.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder
          getUtilizationPercentageOrBuilder() {
        if (utilizationPercentageBuilder_ != null) {
          return utilizationPercentageBuilder_.getMessageOrBuilder();
        } else {
          return utilizationPercentage_ == null
              ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
                  .getDefaultInstance()
              : utilizationPercentage_;
        }
      }
      /**
       *
       *
       * <pre>
       * CPU utilization percentage.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder>
          getUtilizationPercentageFieldBuilder() {
        if (utilizationPercentageBuilder_ == null) {
          utilizationPercentageBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats,
                  com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder,
                  com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder>(
                  getUtilizationPercentage(), getParentForChildren(), isClean());
          utilizationPercentage_ = null;
        }
        return utilizationPercentageBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU)
    private static final com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU();
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CPU> PARSER =
        new com.google.protobuf.AbstractParser<CPU>() {
          @java.lang.Override
          public CPU parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CPU> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CPU> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MemoryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Memory utilization percentage.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
     * </code>
     *
     * @return Whether the utilizationPercentage field is set.
     */
    boolean hasUtilizationPercentage();
    /**
     *
     *
     * <pre>
     * Memory utilization percentage.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
     * </code>
     *
     * @return The utilizationPercentage.
     */
    com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
        getUtilizationPercentage();
    /**
     *
     *
     * <pre>
     * Memory utilization percentage.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder
        getUtilizationPercentageOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Statistical aggregation of memory usage.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory}
   */
  public static final class Memory extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory)
      MemoryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Memory.newBuilder() to construct.
    private Memory(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Memory() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Memory();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Memory_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Memory_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory.class,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory.Builder
                  .class);
    }

    public static final int UTILIZATION_PERCENTAGE_FIELD_NUMBER = 1;
    private com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
        utilizationPercentage_;
    /**
     *
     *
     * <pre>
     * Memory utilization percentage.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
     * </code>
     *
     * @return Whether the utilizationPercentage field is set.
     */
    @java.lang.Override
    public boolean hasUtilizationPercentage() {
      return utilizationPercentage_ != null;
    }
    /**
     *
     *
     * <pre>
     * Memory utilization percentage.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
     * </code>
     *
     * @return The utilizationPercentage.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
        getUtilizationPercentage() {
      return utilizationPercentage_ == null
          ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
              .getDefaultInstance()
          : utilizationPercentage_;
    }
    /**
     *
     *
     * <pre>
     * Memory utilization percentage.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder
        getUtilizationPercentageOrBuilder() {
      return utilizationPercentage_ == null
          ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
              .getDefaultInstance()
          : utilizationPercentage_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (utilizationPercentage_ != null) {
        output.writeMessage(1, getUtilizationPercentage());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (utilizationPercentage_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, getUtilizationPercentage());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory other =
          (com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory) obj;

      if (hasUtilizationPercentage() != other.hasUtilizationPercentage()) return false;
      if (hasUtilizationPercentage()) {
        if (!getUtilizationPercentage().equals(other.getUtilizationPercentage())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasUtilizationPercentage()) {
        hash = (37 * hash) + UTILIZATION_PERCENTAGE_FIELD_NUMBER;
        hash = (53 * hash) + getUtilizationPercentage().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Statistical aggregation of memory usage.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory)
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.MemoryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Memory_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Memory_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory.class,
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        utilizationPercentage_ = null;
        if (utilizationPercentageBuilder_ != null) {
          utilizationPercentageBuilder_.dispose();
          utilizationPercentageBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Memory_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory build() {
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
          buildPartial() {
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory result =
            new com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.utilizationPercentage_ =
              utilizationPercentageBuilder_ == null
                  ? utilizationPercentage_
                  : utilizationPercentageBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory) {
          return mergeFrom(
              (com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory other) {
        if (other
            == com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
                .getDefaultInstance()) return this;
        if (other.hasUtilizationPercentage()) {
          mergeUtilizationPercentage(other.getUtilizationPercentage());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getUtilizationPercentageFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
          utilizationPercentage_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder>
          utilizationPercentageBuilder_;
      /**
       *
       *
       * <pre>
       * Memory utilization percentage.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
       * </code>
       *
       * @return Whether the utilizationPercentage field is set.
       */
      public boolean hasUtilizationPercentage() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Memory utilization percentage.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
       * </code>
       *
       * @return The utilizationPercentage.
       */
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
          getUtilizationPercentage() {
        if (utilizationPercentageBuilder_ == null) {
          return utilizationPercentage_ == null
              ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
                  .getDefaultInstance()
              : utilizationPercentage_;
        } else {
          return utilizationPercentageBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Memory utilization percentage.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
       * </code>
       */
      public Builder setUtilizationPercentage(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats value) {
        if (utilizationPercentageBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          utilizationPercentage_ = value;
        } else {
          utilizationPercentageBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Memory utilization percentage.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
       * </code>
       */
      public Builder setUtilizationPercentage(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder
              builderForValue) {
        if (utilizationPercentageBuilder_ == null) {
          utilizationPercentage_ = builderForValue.build();
        } else {
          utilizationPercentageBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Memory utilization percentage.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
       * </code>
       */
      public Builder mergeUtilizationPercentage(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats value) {
        if (utilizationPercentageBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && utilizationPercentage_ != null
              && utilizationPercentage_
                  != com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
                      .getDefaultInstance()) {
            getUtilizationPercentageBuilder().mergeFrom(value);
          } else {
            utilizationPercentage_ = value;
          }
        } else {
          utilizationPercentageBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Memory utilization percentage.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
       * </code>
       */
      public Builder clearUtilizationPercentage() {
        bitField0_ = (bitField0_ & ~0x00000001);
        utilizationPercentage_ = null;
        if (utilizationPercentageBuilder_ != null) {
          utilizationPercentageBuilder_.dispose();
          utilizationPercentageBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Memory utilization percentage.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder
          getUtilizationPercentageBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getUtilizationPercentageFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Memory utilization percentage.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder
          getUtilizationPercentageOrBuilder() {
        if (utilizationPercentageBuilder_ != null) {
          return utilizationPercentageBuilder_.getMessageOrBuilder();
        } else {
          return utilizationPercentage_ == null
              ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
                  .getDefaultInstance()
              : utilizationPercentage_;
        }
      }
      /**
       *
       *
       * <pre>
       * Memory utilization percentage.
       * </pre>
       *
       * <code>
       * .google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats utilization_percentage = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder>
          getUtilizationPercentageFieldBuilder() {
        if (utilizationPercentageBuilder_ == null) {
          utilizationPercentageBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats,
                  com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder,
                  com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder>(
                  getUtilizationPercentage(), getParentForChildren(), isClean());
          utilizationPercentage_ = null;
        }
        return utilizationPercentageBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory)
    private static final com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory();
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Memory> PARSER =
        new com.google.protobuf.AbstractParser<Memory>() {
          @java.lang.Override
          public Memory parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Memory> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Memory> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NetworkOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Network ingress in B/s.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats ingress_bps = 1;
     * </code>
     *
     * @return Whether the ingressBps field is set.
     */
    boolean hasIngressBps();
    /**
     *
     *
     * <pre>
     * Network ingress in B/s.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats ingress_bps = 1;
     * </code>
     *
     * @return The ingressBps.
     */
    com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats getIngressBps();
    /**
     *
     *
     * <pre>
     * Network ingress in B/s.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats ingress_bps = 1;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder
        getIngressBpsOrBuilder();

    /**
     *
     *
     * <pre>
     * Network egress in B/s.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats egress_bps = 2;
     * </code>
     *
     * @return Whether the egressBps field is set.
     */
    boolean hasEgressBps();
    /**
     *
     *
     * <pre>
     * Network egress in B/s.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats egress_bps = 2;
     * </code>
     *
     * @return The egressBps.
     */
    com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats getEgressBps();
    /**
     *
     *
     * <pre>
     * Network egress in B/s.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats egress_bps = 2;
     * </code>
     */
    com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder
        getEgressBpsOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Statistical aggregation of network usage.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network}
   */
  public static final class Network extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network)
      NetworkOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Network.newBuilder() to construct.
    private Network(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Network() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Network();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Network_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Network_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network.class,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network.Builder
                  .class);
    }

    public static final int INGRESS_BPS_FIELD_NUMBER = 1;
    private com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats ingressBps_;
    /**
     *
     *
     * <pre>
     * Network ingress in B/s.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats ingress_bps = 1;
     * </code>
     *
     * @return Whether the ingressBps field is set.
     */
    @java.lang.Override
    public boolean hasIngressBps() {
      return ingressBps_ != null;
    }
    /**
     *
     *
     * <pre>
     * Network ingress in B/s.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats ingress_bps = 1;
     * </code>
     *
     * @return The ingressBps.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats getIngressBps() {
      return ingressBps_ == null
          ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
              .getDefaultInstance()
          : ingressBps_;
    }
    /**
     *
     *
     * <pre>
     * Network ingress in B/s.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats ingress_bps = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder
        getIngressBpsOrBuilder() {
      return ingressBps_ == null
          ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
              .getDefaultInstance()
          : ingressBps_;
    }

    public static final int EGRESS_BPS_FIELD_NUMBER = 2;
    private com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats egressBps_;
    /**
     *
     *
     * <pre>
     * Network egress in B/s.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats egress_bps = 2;
     * </code>
     *
     * @return Whether the egressBps field is set.
     */
    @java.lang.Override
    public boolean hasEgressBps() {
      return egressBps_ != null;
    }
    /**
     *
     *
     * <pre>
     * Network egress in B/s.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats egress_bps = 2;
     * </code>
     *
     * @return The egressBps.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats getEgressBps() {
      return egressBps_ == null
          ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
              .getDefaultInstance()
          : egressBps_;
    }
    /**
     *
     *
     * <pre>
     * Network egress in B/s.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats egress_bps = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder
        getEgressBpsOrBuilder() {
      return egressBps_ == null
          ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
              .getDefaultInstance()
          : egressBps_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (ingressBps_ != null) {
        output.writeMessage(1, getIngressBps());
      }
      if (egressBps_ != null) {
        output.writeMessage(2, getEgressBps());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (ingressBps_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getIngressBps());
      }
      if (egressBps_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEgressBps());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network other =
          (com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network) obj;

      if (hasIngressBps() != other.hasIngressBps()) return false;
      if (hasIngressBps()) {
        if (!getIngressBps().equals(other.getIngressBps())) return false;
      }
      if (hasEgressBps() != other.hasEgressBps()) return false;
      if (hasEgressBps()) {
        if (!getEgressBps().equals(other.getEgressBps())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasIngressBps()) {
        hash = (37 * hash) + INGRESS_BPS_FIELD_NUMBER;
        hash = (53 * hash) + getIngressBps().hashCode();
      }
      if (hasEgressBps()) {
        hash = (37 * hash) + EGRESS_BPS_FIELD_NUMBER;
        hash = (53 * hash) + getEgressBps().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Statistical aggregation of network usage.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network)
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.NetworkOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Network_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Network_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network.class,
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        ingressBps_ = null;
        if (ingressBpsBuilder_ != null) {
          ingressBpsBuilder_.dispose();
          ingressBpsBuilder_ = null;
        }
        egressBps_ = null;
        if (egressBpsBuilder_ != null) {
          egressBpsBuilder_.dispose();
          egressBpsBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Network_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network build() {
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
          buildPartial() {
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network result =
            new com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.ingressBps_ =
              ingressBpsBuilder_ == null ? ingressBps_ : ingressBpsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.egressBps_ = egressBpsBuilder_ == null ? egressBps_ : egressBpsBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network) {
          return mergeFrom(
              (com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network other) {
        if (other
            == com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
                .getDefaultInstance()) return this;
        if (other.hasIngressBps()) {
          mergeIngressBps(other.getIngressBps());
        }
        if (other.hasEgressBps()) {
          mergeEgressBps(other.getEgressBps());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getIngressBpsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getEgressBpsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats ingressBps_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder>
          ingressBpsBuilder_;
      /**
       *
       *
       * <pre>
       * Network ingress in B/s.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats ingress_bps = 1;
       * </code>
       *
       * @return Whether the ingressBps field is set.
       */
      public boolean hasIngressBps() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Network ingress in B/s.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats ingress_bps = 1;
       * </code>
       *
       * @return The ingressBps.
       */
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
          getIngressBps() {
        if (ingressBpsBuilder_ == null) {
          return ingressBps_ == null
              ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
                  .getDefaultInstance()
              : ingressBps_;
        } else {
          return ingressBpsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Network ingress in B/s.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats ingress_bps = 1;
       * </code>
       */
      public Builder setIngressBps(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats value) {
        if (ingressBpsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ingressBps_ = value;
        } else {
          ingressBpsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Network ingress in B/s.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats ingress_bps = 1;
       * </code>
       */
      public Builder setIngressBps(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder
              builderForValue) {
        if (ingressBpsBuilder_ == null) {
          ingressBps_ = builderForValue.build();
        } else {
          ingressBpsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Network ingress in B/s.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats ingress_bps = 1;
       * </code>
       */
      public Builder mergeIngressBps(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats value) {
        if (ingressBpsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && ingressBps_ != null
              && ingressBps_
                  != com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
                      .getDefaultInstance()) {
            getIngressBpsBuilder().mergeFrom(value);
          } else {
            ingressBps_ = value;
          }
        } else {
          ingressBpsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Network ingress in B/s.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats ingress_bps = 1;
       * </code>
       */
      public Builder clearIngressBps() {
        bitField0_ = (bitField0_ & ~0x00000001);
        ingressBps_ = null;
        if (ingressBpsBuilder_ != null) {
          ingressBpsBuilder_.dispose();
          ingressBpsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Network ingress in B/s.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats ingress_bps = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder
          getIngressBpsBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getIngressBpsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Network ingress in B/s.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats ingress_bps = 1;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder
          getIngressBpsOrBuilder() {
        if (ingressBpsBuilder_ != null) {
          return ingressBpsBuilder_.getMessageOrBuilder();
        } else {
          return ingressBps_ == null
              ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
                  .getDefaultInstance()
              : ingressBps_;
        }
      }
      /**
       *
       *
       * <pre>
       * Network ingress in B/s.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats ingress_bps = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder>
          getIngressBpsFieldBuilder() {
        if (ingressBpsBuilder_ == null) {
          ingressBpsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats,
                  com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder,
                  com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder>(
                  getIngressBps(), getParentForChildren(), isClean());
          ingressBps_ = null;
        }
        return ingressBpsBuilder_;
      }

      private com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats egressBps_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder>
          egressBpsBuilder_;
      /**
       *
       *
       * <pre>
       * Network egress in B/s.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats egress_bps = 2;
       * </code>
       *
       * @return Whether the egressBps field is set.
       */
      public boolean hasEgressBps() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Network egress in B/s.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats egress_bps = 2;
       * </code>
       *
       * @return The egressBps.
       */
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
          getEgressBps() {
        if (egressBpsBuilder_ == null) {
          return egressBps_ == null
              ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
                  .getDefaultInstance()
              : egressBps_;
        } else {
          return egressBpsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Network egress in B/s.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats egress_bps = 2;
       * </code>
       */
      public Builder setEgressBps(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats value) {
        if (egressBpsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          egressBps_ = value;
        } else {
          egressBpsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Network egress in B/s.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats egress_bps = 2;
       * </code>
       */
      public Builder setEgressBps(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder
              builderForValue) {
        if (egressBpsBuilder_ == null) {
          egressBps_ = builderForValue.build();
        } else {
          egressBpsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Network egress in B/s.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats egress_bps = 2;
       * </code>
       */
      public Builder mergeEgressBps(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats value) {
        if (egressBpsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && egressBps_ != null
              && egressBps_
                  != com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
                      .getDefaultInstance()) {
            getEgressBpsBuilder().mergeFrom(value);
          } else {
            egressBps_ = value;
          }
        } else {
          egressBpsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Network egress in B/s.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats egress_bps = 2;
       * </code>
       */
      public Builder clearEgressBps() {
        bitField0_ = (bitField0_ & ~0x00000002);
        egressBps_ = null;
        if (egressBpsBuilder_ != null) {
          egressBpsBuilder_.dispose();
          egressBpsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Network egress in B/s.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats egress_bps = 2;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder
          getEgressBpsBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getEgressBpsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Network egress in B/s.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats egress_bps = 2;
       * </code>
       */
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder
          getEgressBpsOrBuilder() {
        if (egressBpsBuilder_ != null) {
          return egressBpsBuilder_.getMessageOrBuilder();
        } else {
          return egressBps_ == null
              ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
                  .getDefaultInstance()
              : egressBps_;
        }
      }
      /**
       *
       *
       * <pre>
       * Network egress in B/s.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats egress_bps = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder>
          getEgressBpsFieldBuilder() {
        if (egressBpsBuilder_ == null) {
          egressBpsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats,
                  com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder,
                  com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder>(
                  getEgressBps(), getParentForChildren(), isClean());
          egressBps_ = null;
        }
        return egressBpsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network)
    private static final com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network();
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Network> PARSER =
        new com.google.protobuf.AbstractParser<Network>() {
          @java.lang.Override
          public Network parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Network> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Network> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DiskOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Disk I/O operations per second.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats iops = 1;</code>
     *
     * @return Whether the iops field is set.
     */
    boolean hasIops();
    /**
     *
     *
     * <pre>
     * Disk I/O operations per second.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats iops = 1;</code>
     *
     * @return The iops.
     */
    com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats getIops();
    /**
     *
     *
     * <pre>
     * Disk I/O operations per second.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats iops = 1;</code>
     */
    com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder
        getIopsOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Statistical aggregation of disk usage.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk}
   */
  public static final class Disk extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk)
      DiskOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Disk.newBuilder() to construct.
    private Disk(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Disk() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Disk();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Disk_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Disk_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk.class,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk.Builder.class);
    }

    public static final int IOPS_FIELD_NUMBER = 1;
    private com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats iops_;
    /**
     *
     *
     * <pre>
     * Disk I/O operations per second.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats iops = 1;</code>
     *
     * @return Whether the iops field is set.
     */
    @java.lang.Override
    public boolean hasIops() {
      return iops_ != null;
    }
    /**
     *
     *
     * <pre>
     * Disk I/O operations per second.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats iops = 1;</code>
     *
     * @return The iops.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats getIops() {
      return iops_ == null
          ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
              .getDefaultInstance()
          : iops_;
    }
    /**
     *
     *
     * <pre>
     * Disk I/O operations per second.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats iops = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder
        getIopsOrBuilder() {
      return iops_ == null
          ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
              .getDefaultInstance()
          : iops_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (iops_ != null) {
        output.writeMessage(1, getIops());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (iops_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getIops());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk)) {
        return super.equals(obj);
      }
      com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk other =
          (com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk) obj;

      if (hasIops() != other.hasIops()) return false;
      if (hasIops()) {
        if (!getIops().equals(other.getIops())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasIops()) {
        hash = (37 * hash) + IOPS_FIELD_NUMBER;
        hash = (53 * hash) + getIops().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Statistical aggregation of disk usage.
     * </pre>
     *
     * Protobuf type {@code google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk)
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.DiskOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Disk_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Disk_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk.class,
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        iops_ = null;
        if (iopsBuilder_ != null) {
          iopsBuilder_.dispose();
          iopsBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.migrationcenter.v1.MigrationCenterProto
            .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_Disk_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk
          getDefaultInstanceForType() {
        return com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk build() {
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk buildPartial() {
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk result =
            new com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.iops_ = iopsBuilder_ == null ? iops_ : iopsBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk) {
          return mergeFrom(
              (com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk other) {
        if (other
            == com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk
                .getDefaultInstance()) return this;
        if (other.hasIops()) {
          mergeIops(other.getIops());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getIopsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats iops_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder>
          iopsBuilder_;
      /**
       *
       *
       * <pre>
       * Disk I/O operations per second.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats iops = 1;</code>
       *
       * @return Whether the iops field is set.
       */
      public boolean hasIops() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Disk I/O operations per second.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats iops = 1;</code>
       *
       * @return The iops.
       */
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats getIops() {
        if (iopsBuilder_ == null) {
          return iops_ == null
              ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
                  .getDefaultInstance()
              : iops_;
        } else {
          return iopsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Disk I/O operations per second.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats iops = 1;</code>
       */
      public Builder setIops(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats value) {
        if (iopsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          iops_ = value;
        } else {
          iopsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Disk I/O operations per second.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats iops = 1;</code>
       */
      public Builder setIops(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder
              builderForValue) {
        if (iopsBuilder_ == null) {
          iops_ = builderForValue.build();
        } else {
          iopsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Disk I/O operations per second.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats iops = 1;</code>
       */
      public Builder mergeIops(
          com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats value) {
        if (iopsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && iops_ != null
              && iops_
                  != com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
                      .getDefaultInstance()) {
            getIopsBuilder().mergeFrom(value);
          } else {
            iops_ = value;
          }
        } else {
          iopsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Disk I/O operations per second.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats iops = 1;</code>
       */
      public Builder clearIops() {
        bitField0_ = (bitField0_ & ~0x00000001);
        iops_ = null;
        if (iopsBuilder_ != null) {
          iopsBuilder_.dispose();
          iopsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Disk I/O operations per second.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats iops = 1;</code>
       */
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder
          getIopsBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getIopsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Disk I/O operations per second.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats iops = 1;</code>
       */
      public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder
          getIopsOrBuilder() {
        if (iopsBuilder_ != null) {
          return iopsBuilder_.getMessageOrBuilder();
        } else {
          return iops_ == null
              ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats
                  .getDefaultInstance()
              : iops_;
        }
      }
      /**
       *
       *
       * <pre>
       * Disk I/O operations per second.
       * </pre>
       *
       * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats iops = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder>
          getIopsFieldBuilder() {
        if (iopsBuilder_ == null) {
          iopsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats,
                  com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Stats.Builder,
                  com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.StatsOrBuilder>(
                  getIops(), getParentForChildren(), isClean());
          iops_ = null;
        }
        return iopsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk)
    private static final com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk();
    }

    public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Disk> PARSER =
        new com.google.protobuf.AbstractParser<Disk>() {
          @java.lang.Override
          public Disk parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Disk> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Disk> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int DATE_FIELD_NUMBER = 1;
  private com.google.type.Date date_;
  /**
   *
   *
   * <pre>
   * Aggregation date. Day boundaries are at midnight UTC.
   * </pre>
   *
   * <code>.google.type.Date date = 1;</code>
   *
   * @return Whether the date field is set.
   */
  @java.lang.Override
  public boolean hasDate() {
    return date_ != null;
  }
  /**
   *
   *
   * <pre>
   * Aggregation date. Day boundaries are at midnight UTC.
   * </pre>
   *
   * <code>.google.type.Date date = 1;</code>
   *
   * @return The date.
   */
  @java.lang.Override
  public com.google.type.Date getDate() {
    return date_ == null ? com.google.type.Date.getDefaultInstance() : date_;
  }
  /**
   *
   *
   * <pre>
   * Aggregation date. Day boundaries are at midnight UTC.
   * </pre>
   *
   * <code>.google.type.Date date = 1;</code>
   */
  @java.lang.Override
  public com.google.type.DateOrBuilder getDateOrBuilder() {
    return date_ == null ? com.google.type.Date.getDefaultInstance() : date_;
  }

  public static final int CPU_FIELD_NUMBER = 2;
  private com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU cpu_;
  /**
   *
   *
   * <pre>
   * CPU usage.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU cpu = 2;</code>
   *
   * @return Whether the cpu field is set.
   */
  @java.lang.Override
  public boolean hasCpu() {
    return cpu_ != null;
  }
  /**
   *
   *
   * <pre>
   * CPU usage.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU cpu = 2;</code>
   *
   * @return The cpu.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU getCpu() {
    return cpu_ == null
        ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU.getDefaultInstance()
        : cpu_;
  }
  /**
   *
   *
   * <pre>
   * CPU usage.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU cpu = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPUOrBuilder
      getCpuOrBuilder() {
    return cpu_ == null
        ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU.getDefaultInstance()
        : cpu_;
  }

  public static final int MEMORY_FIELD_NUMBER = 3;
  private com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory memory_;
  /**
   *
   *
   * <pre>
   * Memory usage.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory memory = 3;</code>
   *
   * @return Whether the memory field is set.
   */
  @java.lang.Override
  public boolean hasMemory() {
    return memory_ != null;
  }
  /**
   *
   *
   * <pre>
   * Memory usage.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory memory = 3;</code>
   *
   * @return The memory.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory getMemory() {
    return memory_ == null
        ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
            .getDefaultInstance()
        : memory_;
  }
  /**
   *
   *
   * <pre>
   * Memory usage.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory memory = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.MemoryOrBuilder
      getMemoryOrBuilder() {
    return memory_ == null
        ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
            .getDefaultInstance()
        : memory_;
  }

  public static final int NETWORK_FIELD_NUMBER = 4;
  private com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network network_;
  /**
   *
   *
   * <pre>
   * Network usage.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network network = 4;
   * </code>
   *
   * @return Whether the network field is set.
   */
  @java.lang.Override
  public boolean hasNetwork() {
    return network_ != null;
  }
  /**
   *
   *
   * <pre>
   * Network usage.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network network = 4;
   * </code>
   *
   * @return The network.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network getNetwork() {
    return network_ == null
        ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
            .getDefaultInstance()
        : network_;
  }
  /**
   *
   *
   * <pre>
   * Network usage.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network network = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.NetworkOrBuilder
      getNetworkOrBuilder() {
    return network_ == null
        ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
            .getDefaultInstance()
        : network_;
  }

  public static final int DISK_FIELD_NUMBER = 5;
  private com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk disk_;
  /**
   *
   *
   * <pre>
   * Disk usage.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk disk = 5;</code>
   *
   * @return Whether the disk field is set.
   */
  @java.lang.Override
  public boolean hasDisk() {
    return disk_ != null;
  }
  /**
   *
   *
   * <pre>
   * Disk usage.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk disk = 5;</code>
   *
   * @return The disk.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk getDisk() {
    return disk_ == null
        ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk
            .getDefaultInstance()
        : disk_;
  }
  /**
   *
   *
   * <pre>
   * Disk usage.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk disk = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.DiskOrBuilder
      getDiskOrBuilder() {
    return disk_ == null
        ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk
            .getDefaultInstance()
        : disk_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (date_ != null) {
      output.writeMessage(1, getDate());
    }
    if (cpu_ != null) {
      output.writeMessage(2, getCpu());
    }
    if (memory_ != null) {
      output.writeMessage(3, getMemory());
    }
    if (network_ != null) {
      output.writeMessage(4, getNetwork());
    }
    if (disk_ != null) {
      output.writeMessage(5, getDisk());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (date_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDate());
    }
    if (cpu_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCpu());
    }
    if (memory_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMemory());
    }
    if (network_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getNetwork());
    }
    if (disk_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDisk());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation other =
        (com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation) obj;

    if (hasDate() != other.hasDate()) return false;
    if (hasDate()) {
      if (!getDate().equals(other.getDate())) return false;
    }
    if (hasCpu() != other.hasCpu()) return false;
    if (hasCpu()) {
      if (!getCpu().equals(other.getCpu())) return false;
    }
    if (hasMemory() != other.hasMemory()) return false;
    if (hasMemory()) {
      if (!getMemory().equals(other.getMemory())) return false;
    }
    if (hasNetwork() != other.hasNetwork()) return false;
    if (hasNetwork()) {
      if (!getNetwork().equals(other.getNetwork())) return false;
    }
    if (hasDisk() != other.hasDisk()) return false;
    if (hasDisk()) {
      if (!getDisk().equals(other.getDisk())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDate()) {
      hash = (37 * hash) + DATE_FIELD_NUMBER;
      hash = (53 * hash) + getDate().hashCode();
    }
    if (hasCpu()) {
      hash = (37 * hash) + CPU_FIELD_NUMBER;
      hash = (53 * hash) + getCpu().hashCode();
    }
    if (hasMemory()) {
      hash = (37 * hash) + MEMORY_FIELD_NUMBER;
      hash = (53 * hash) + getMemory().hashCode();
    }
    if (hasNetwork()) {
      hash = (37 * hash) + NETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getNetwork().hashCode();
    }
    if (hasDisk()) {
      hash = (37 * hash) + DISK_FIELD_NUMBER;
      hash = (53 * hash) + getDisk().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Usage data aggregation for a single day.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.DailyResourceUsageAggregation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation)
      com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.class,
              com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Builder.class);
    }

    // Construct using
    // com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      date_ = null;
      if (dateBuilder_ != null) {
        dateBuilder_.dispose();
        dateBuilder_ = null;
      }
      cpu_ = null;
      if (cpuBuilder_ != null) {
        cpuBuilder_.dispose();
        cpuBuilder_ = null;
      }
      memory_ = null;
      if (memoryBuilder_ != null) {
        memoryBuilder_.dispose();
        memoryBuilder_ = null;
      }
      network_ = null;
      if (networkBuilder_ != null) {
        networkBuilder_.dispose();
        networkBuilder_ = null;
      }
      disk_ = null;
      if (diskBuilder_ != null) {
        diskBuilder_.dispose();
        diskBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_DailyResourceUsageAggregation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation
        getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation build() {
      com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation buildPartial() {
      com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation result =
          new com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.date_ = dateBuilder_ == null ? date_ : dateBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.cpu_ = cpuBuilder_ == null ? cpu_ : cpuBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.memory_ = memoryBuilder_ == null ? memory_ : memoryBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.network_ = networkBuilder_ == null ? network_ : networkBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.disk_ = diskBuilder_ == null ? disk_ : diskBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation other) {
      if (other
          == com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.getDefaultInstance())
        return this;
      if (other.hasDate()) {
        mergeDate(other.getDate());
      }
      if (other.hasCpu()) {
        mergeCpu(other.getCpu());
      }
      if (other.hasMemory()) {
        mergeMemory(other.getMemory());
      }
      if (other.hasNetwork()) {
        mergeNetwork(other.getNetwork());
      }
      if (other.hasDisk()) {
        mergeDisk(other.getDisk());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getDateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCpuFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getMemoryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getNetworkFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getDiskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.type.Date date_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
        dateBuilder_;
    /**
     *
     *
     * <pre>
     * Aggregation date. Day boundaries are at midnight UTC.
     * </pre>
     *
     * <code>.google.type.Date date = 1;</code>
     *
     * @return Whether the date field is set.
     */
    public boolean hasDate() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Aggregation date. Day boundaries are at midnight UTC.
     * </pre>
     *
     * <code>.google.type.Date date = 1;</code>
     *
     * @return The date.
     */
    public com.google.type.Date getDate() {
      if (dateBuilder_ == null) {
        return date_ == null ? com.google.type.Date.getDefaultInstance() : date_;
      } else {
        return dateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Aggregation date. Day boundaries are at midnight UTC.
     * </pre>
     *
     * <code>.google.type.Date date = 1;</code>
     */
    public Builder setDate(com.google.type.Date value) {
      if (dateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        date_ = value;
      } else {
        dateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregation date. Day boundaries are at midnight UTC.
     * </pre>
     *
     * <code>.google.type.Date date = 1;</code>
     */
    public Builder setDate(com.google.type.Date.Builder builderForValue) {
      if (dateBuilder_ == null) {
        date_ = builderForValue.build();
      } else {
        dateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregation date. Day boundaries are at midnight UTC.
     * </pre>
     *
     * <code>.google.type.Date date = 1;</code>
     */
    public Builder mergeDate(com.google.type.Date value) {
      if (dateBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && date_ != null
            && date_ != com.google.type.Date.getDefaultInstance()) {
          getDateBuilder().mergeFrom(value);
        } else {
          date_ = value;
        }
      } else {
        dateBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregation date. Day boundaries are at midnight UTC.
     * </pre>
     *
     * <code>.google.type.Date date = 1;</code>
     */
    public Builder clearDate() {
      bitField0_ = (bitField0_ & ~0x00000001);
      date_ = null;
      if (dateBuilder_ != null) {
        dateBuilder_.dispose();
        dateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Aggregation date. Day boundaries are at midnight UTC.
     * </pre>
     *
     * <code>.google.type.Date date = 1;</code>
     */
    public com.google.type.Date.Builder getDateBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getDateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Aggregation date. Day boundaries are at midnight UTC.
     * </pre>
     *
     * <code>.google.type.Date date = 1;</code>
     */
    public com.google.type.DateOrBuilder getDateOrBuilder() {
      if (dateBuilder_ != null) {
        return dateBuilder_.getMessageOrBuilder();
      } else {
        return date_ == null ? com.google.type.Date.getDefaultInstance() : date_;
      }
    }
    /**
     *
     *
     * <pre>
     * Aggregation date. Day boundaries are at midnight UTC.
     * </pre>
     *
     * <code>.google.type.Date date = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>
        getDateFieldBuilder() {
      if (dateBuilder_ == null) {
        dateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Date, com.google.type.Date.Builder, com.google.type.DateOrBuilder>(
                getDate(), getParentForChildren(), isClean());
        date_ = null;
      }
      return dateBuilder_;
    }

    private com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU cpu_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU,
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU.Builder,
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPUOrBuilder>
        cpuBuilder_;
    /**
     *
     *
     * <pre>
     * CPU usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU cpu = 2;</code>
     *
     * @return Whether the cpu field is set.
     */
    public boolean hasCpu() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * CPU usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU cpu = 2;</code>
     *
     * @return The cpu.
     */
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU getCpu() {
      if (cpuBuilder_ == null) {
        return cpu_ == null
            ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU
                .getDefaultInstance()
            : cpu_;
      } else {
        return cpuBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * CPU usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU cpu = 2;</code>
     */
    public Builder setCpu(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU value) {
      if (cpuBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cpu_ = value;
      } else {
        cpuBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CPU usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU cpu = 2;</code>
     */
    public Builder setCpu(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU.Builder
            builderForValue) {
      if (cpuBuilder_ == null) {
        cpu_ = builderForValue.build();
      } else {
        cpuBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CPU usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU cpu = 2;</code>
     */
    public Builder mergeCpu(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU value) {
      if (cpuBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && cpu_ != null
            && cpu_
                != com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU
                    .getDefaultInstance()) {
          getCpuBuilder().mergeFrom(value);
        } else {
          cpu_ = value;
        }
      } else {
        cpuBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CPU usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU cpu = 2;</code>
     */
    public Builder clearCpu() {
      bitField0_ = (bitField0_ & ~0x00000002);
      cpu_ = null;
      if (cpuBuilder_ != null) {
        cpuBuilder_.dispose();
        cpuBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CPU usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU cpu = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU.Builder
        getCpuBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCpuFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * CPU usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU cpu = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPUOrBuilder
        getCpuOrBuilder() {
      if (cpuBuilder_ != null) {
        return cpuBuilder_.getMessageOrBuilder();
      } else {
        return cpu_ == null
            ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU
                .getDefaultInstance()
            : cpu_;
      }
    }
    /**
     *
     *
     * <pre>
     * CPU usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU cpu = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU,
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU.Builder,
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPUOrBuilder>
        getCpuFieldBuilder() {
      if (cpuBuilder_ == null) {
        cpuBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU,
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPU.Builder,
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.CPUOrBuilder>(
                getCpu(), getParentForChildren(), isClean());
        cpu_ = null;
      }
      return cpuBuilder_;
    }

    private com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory memory_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory,
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory.Builder,
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.MemoryOrBuilder>
        memoryBuilder_;
    /**
     *
     *
     * <pre>
     * Memory usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory memory = 3;
     * </code>
     *
     * @return Whether the memory field is set.
     */
    public boolean hasMemory() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Memory usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory memory = 3;
     * </code>
     *
     * @return The memory.
     */
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory getMemory() {
      if (memoryBuilder_ == null) {
        return memory_ == null
            ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
                .getDefaultInstance()
            : memory_;
      } else {
        return memoryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Memory usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory memory = 3;
     * </code>
     */
    public Builder setMemory(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory value) {
      if (memoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        memory_ = value;
      } else {
        memoryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Memory usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory memory = 3;
     * </code>
     */
    public Builder setMemory(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory.Builder
            builderForValue) {
      if (memoryBuilder_ == null) {
        memory_ = builderForValue.build();
      } else {
        memoryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Memory usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory memory = 3;
     * </code>
     */
    public Builder mergeMemory(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory value) {
      if (memoryBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && memory_ != null
            && memory_
                != com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
                    .getDefaultInstance()) {
          getMemoryBuilder().mergeFrom(value);
        } else {
          memory_ = value;
        }
      } else {
        memoryBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Memory usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory memory = 3;
     * </code>
     */
    public Builder clearMemory() {
      bitField0_ = (bitField0_ & ~0x00000004);
      memory_ = null;
      if (memoryBuilder_ != null) {
        memoryBuilder_.dispose();
        memoryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Memory usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory memory = 3;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory.Builder
        getMemoryBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getMemoryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Memory usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory memory = 3;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.MemoryOrBuilder
        getMemoryOrBuilder() {
      if (memoryBuilder_ != null) {
        return memoryBuilder_.getMessageOrBuilder();
      } else {
        return memory_ == null
            ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory
                .getDefaultInstance()
            : memory_;
      }
    }
    /**
     *
     *
     * <pre>
     * Memory usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory memory = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory,
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory.Builder,
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.MemoryOrBuilder>
        getMemoryFieldBuilder() {
      if (memoryBuilder_ == null) {
        memoryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory,
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Memory.Builder,
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.MemoryOrBuilder>(
                getMemory(), getParentForChildren(), isClean());
        memory_ = null;
      }
      return memoryBuilder_;
    }

    private com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network network_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network,
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network.Builder,
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.NetworkOrBuilder>
        networkBuilder_;
    /**
     *
     *
     * <pre>
     * Network usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network network = 4;
     * </code>
     *
     * @return Whether the network field is set.
     */
    public boolean hasNetwork() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Network usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network network = 4;
     * </code>
     *
     * @return The network.
     */
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network getNetwork() {
      if (networkBuilder_ == null) {
        return network_ == null
            ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
                .getDefaultInstance()
            : network_;
      } else {
        return networkBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Network usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network network = 4;
     * </code>
     */
    public Builder setNetwork(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network value) {
      if (networkBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        network_ = value;
      } else {
        networkBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network network = 4;
     * </code>
     */
    public Builder setNetwork(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network.Builder
            builderForValue) {
      if (networkBuilder_ == null) {
        network_ = builderForValue.build();
      } else {
        networkBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network network = 4;
     * </code>
     */
    public Builder mergeNetwork(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network value) {
      if (networkBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && network_ != null
            && network_
                != com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
                    .getDefaultInstance()) {
          getNetworkBuilder().mergeFrom(value);
        } else {
          network_ = value;
        }
      } else {
        networkBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network network = 4;
     * </code>
     */
    public Builder clearNetwork() {
      bitField0_ = (bitField0_ & ~0x00000008);
      network_ = null;
      if (networkBuilder_ != null) {
        networkBuilder_.dispose();
        networkBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Network usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network network = 4;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network.Builder
        getNetworkBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getNetworkFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Network usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network network = 4;
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.NetworkOrBuilder
        getNetworkOrBuilder() {
      if (networkBuilder_ != null) {
        return networkBuilder_.getMessageOrBuilder();
      } else {
        return network_ == null
            ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network
                .getDefaultInstance()
            : network_;
      }
    }
    /**
     *
     *
     * <pre>
     * Network usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network network = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network,
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network.Builder,
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.NetworkOrBuilder>
        getNetworkFieldBuilder() {
      if (networkBuilder_ == null) {
        networkBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network,
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Network.Builder,
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.NetworkOrBuilder>(
                getNetwork(), getParentForChildren(), isClean());
        network_ = null;
      }
      return networkBuilder_;
    }

    private com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk disk_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk,
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk.Builder,
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.DiskOrBuilder>
        diskBuilder_;
    /**
     *
     *
     * <pre>
     * Disk usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk disk = 5;</code>
     *
     * @return Whether the disk field is set.
     */
    public boolean hasDisk() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Disk usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk disk = 5;</code>
     *
     * @return The disk.
     */
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk getDisk() {
      if (diskBuilder_ == null) {
        return disk_ == null
            ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk
                .getDefaultInstance()
            : disk_;
      } else {
        return diskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Disk usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk disk = 5;</code>
     */
    public Builder setDisk(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk value) {
      if (diskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        disk_ = value;
      } else {
        diskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk disk = 5;</code>
     */
    public Builder setDisk(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk.Builder
            builderForValue) {
      if (diskBuilder_ == null) {
        disk_ = builderForValue.build();
      } else {
        diskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk disk = 5;</code>
     */
    public Builder mergeDisk(
        com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk value) {
      if (diskBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && disk_ != null
            && disk_
                != com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk
                    .getDefaultInstance()) {
          getDiskBuilder().mergeFrom(value);
        } else {
          disk_ = value;
        }
      } else {
        diskBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk disk = 5;</code>
     */
    public Builder clearDisk() {
      bitField0_ = (bitField0_ & ~0x00000010);
      disk_ = null;
      if (diskBuilder_ != null) {
        diskBuilder_.dispose();
        diskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk disk = 5;</code>
     */
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk.Builder
        getDiskBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getDiskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Disk usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk disk = 5;</code>
     */
    public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.DiskOrBuilder
        getDiskOrBuilder() {
      if (diskBuilder_ != null) {
        return diskBuilder_.getMessageOrBuilder();
      } else {
        return disk_ == null
            ? com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk
                .getDefaultInstance()
            : disk_;
      }
    }
    /**
     *
     *
     * <pre>
     * Disk usage.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk disk = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk,
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk.Builder,
            com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.DiskOrBuilder>
        getDiskFieldBuilder() {
      if (diskBuilder_ == null) {
        diskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk,
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.Disk.Builder,
                com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation.DiskOrBuilder>(
                getDisk(), getParentForChildren(), isClean());
        disk_ = null;
      }
      return diskBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.DailyResourceUsageAggregation)
  private static final com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation();
  }

  public static com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DailyResourceUsageAggregation> PARSER =
      new com.google.protobuf.AbstractParser<DailyResourceUsageAggregation>() {
        @java.lang.Override
        public DailyResourceUsageAggregation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DailyResourceUsageAggregation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DailyResourceUsageAggregation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.DailyResourceUsageAggregation
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
