/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * Single disk entry.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.DiskEntry}
 */
public final class DiskEntry extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.DiskEntry)
    DiskEntryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DiskEntry.newBuilder() to construct.
  private DiskEntry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DiskEntry() {
    diskLabel_ = "";
    diskLabelType_ = "";
    interfaceType_ = 0;
    hwAddress_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DiskEntry();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_DiskEntry_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_DiskEntry_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.DiskEntry.class,
            com.google.cloud.migrationcenter.v1.DiskEntry.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Disks interface type.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.migrationcenter.v1.DiskEntry.InterfaceType}
   */
  public enum InterfaceType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Interface type unknown or unspecified.
     * </pre>
     *
     * <code>INTERFACE_TYPE_UNSPECIFIED = 0;</code>
     */
    INTERFACE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * IDE interface type.
     * </pre>
     *
     * <code>IDE = 1;</code>
     */
    IDE(1),
    /**
     *
     *
     * <pre>
     * SATA interface type.
     * </pre>
     *
     * <code>SATA = 2;</code>
     */
    SATA(2),
    /**
     *
     *
     * <pre>
     * SAS interface type.
     * </pre>
     *
     * <code>SAS = 3;</code>
     */
    SAS(3),
    /**
     *
     *
     * <pre>
     * SCSI interface type.
     * </pre>
     *
     * <code>SCSI = 4;</code>
     */
    SCSI(4),
    /**
     *
     *
     * <pre>
     * NVME interface type.
     * </pre>
     *
     * <code>NVME = 5;</code>
     */
    NVME(5),
    /**
     *
     *
     * <pre>
     * FC interface type.
     * </pre>
     *
     * <code>FC = 6;</code>
     */
    FC(6),
    /**
     *
     *
     * <pre>
     * iSCSI interface type.
     * </pre>
     *
     * <code>ISCSI = 7;</code>
     */
    ISCSI(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Interface type unknown or unspecified.
     * </pre>
     *
     * <code>INTERFACE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int INTERFACE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * IDE interface type.
     * </pre>
     *
     * <code>IDE = 1;</code>
     */
    public static final int IDE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * SATA interface type.
     * </pre>
     *
     * <code>SATA = 2;</code>
     */
    public static final int SATA_VALUE = 2;
    /**
     *
     *
     * <pre>
     * SAS interface type.
     * </pre>
     *
     * <code>SAS = 3;</code>
     */
    public static final int SAS_VALUE = 3;
    /**
     *
     *
     * <pre>
     * SCSI interface type.
     * </pre>
     *
     * <code>SCSI = 4;</code>
     */
    public static final int SCSI_VALUE = 4;
    /**
     *
     *
     * <pre>
     * NVME interface type.
     * </pre>
     *
     * <code>NVME = 5;</code>
     */
    public static final int NVME_VALUE = 5;
    /**
     *
     *
     * <pre>
     * FC interface type.
     * </pre>
     *
     * <code>FC = 6;</code>
     */
    public static final int FC_VALUE = 6;
    /**
     *
     *
     * <pre>
     * iSCSI interface type.
     * </pre>
     *
     * <code>ISCSI = 7;</code>
     */
    public static final int ISCSI_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InterfaceType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static InterfaceType forNumber(int value) {
      switch (value) {
        case 0:
          return INTERFACE_TYPE_UNSPECIFIED;
        case 1:
          return IDE;
        case 2:
          return SATA;
        case 3:
          return SAS;
        case 4:
          return SCSI;
        case 5:
          return NVME;
        case 6:
          return FC;
        case 7:
          return ISCSI;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<InterfaceType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<InterfaceType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<InterfaceType>() {
          public InterfaceType findValueByNumber(int number) {
            return InterfaceType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.DiskEntry.getDescriptor().getEnumTypes().get(0);
    }

    private static final InterfaceType[] VALUES = values();

    public static InterfaceType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private InterfaceType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.migrationcenter.v1.DiskEntry.InterfaceType)
  }

  private int platformSpecificCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object platformSpecific_;

  public enum PlatformSpecificCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    VMWARE(20),
    PLATFORMSPECIFIC_NOT_SET(0);
    private final int value;

    private PlatformSpecificCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PlatformSpecificCase valueOf(int value) {
      return forNumber(value);
    }

    public static PlatformSpecificCase forNumber(int value) {
      switch (value) {
        case 20:
          return VMWARE;
        case 0:
          return PLATFORMSPECIFIC_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PlatformSpecificCase getPlatformSpecificCase() {
    return PlatformSpecificCase.forNumber(platformSpecificCase_);
  }

  public static final int CAPACITY_BYTES_FIELD_NUMBER = 1;
  private long capacityBytes_ = 0L;
  /**
   *
   *
   * <pre>
   * Disk capacity.
   * </pre>
   *
   * <code>int64 capacity_bytes = 1;</code>
   *
   * @return The capacityBytes.
   */
  @java.lang.Override
  public long getCapacityBytes() {
    return capacityBytes_;
  }

  public static final int FREE_BYTES_FIELD_NUMBER = 2;
  private long freeBytes_ = 0L;
  /**
   *
   *
   * <pre>
   * Disk free space.
   * </pre>
   *
   * <code>int64 free_bytes = 2;</code>
   *
   * @return The freeBytes.
   */
  @java.lang.Override
  public long getFreeBytes() {
    return freeBytes_;
  }

  public static final int DISK_LABEL_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object diskLabel_ = "";
  /**
   *
   *
   * <pre>
   * Disk label.
   * </pre>
   *
   * <code>string disk_label = 3;</code>
   *
   * @return The diskLabel.
   */
  @java.lang.Override
  public java.lang.String getDiskLabel() {
    java.lang.Object ref = diskLabel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      diskLabel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Disk label.
   * </pre>
   *
   * <code>string disk_label = 3;</code>
   *
   * @return The bytes for diskLabel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDiskLabelBytes() {
    java.lang.Object ref = diskLabel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      diskLabel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISK_LABEL_TYPE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object diskLabelType_ = "";
  /**
   *
   *
   * <pre>
   * Disk label type (e.g. BIOS/GPT)
   * </pre>
   *
   * <code>string disk_label_type = 4;</code>
   *
   * @return The diskLabelType.
   */
  @java.lang.Override
  public java.lang.String getDiskLabelType() {
    java.lang.Object ref = diskLabelType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      diskLabelType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Disk label type (e.g. BIOS/GPT)
   * </pre>
   *
   * <code>string disk_label_type = 4;</code>
   *
   * @return The bytes for diskLabelType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDiskLabelTypeBytes() {
    java.lang.Object ref = diskLabelType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      diskLabelType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INTERFACE_TYPE_FIELD_NUMBER = 5;
  private int interfaceType_ = 0;
  /**
   *
   *
   * <pre>
   * Disks interface type.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.DiskEntry.InterfaceType interface_type = 5;</code>
   *
   * @return The enum numeric value on the wire for interfaceType.
   */
  @java.lang.Override
  public int getInterfaceTypeValue() {
    return interfaceType_;
  }
  /**
   *
   *
   * <pre>
   * Disks interface type.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.DiskEntry.InterfaceType interface_type = 5;</code>
   *
   * @return The interfaceType.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.DiskEntry.InterfaceType getInterfaceType() {
    com.google.cloud.migrationcenter.v1.DiskEntry.InterfaceType result =
        com.google.cloud.migrationcenter.v1.DiskEntry.InterfaceType.forNumber(interfaceType_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.DiskEntry.InterfaceType.UNRECOGNIZED
        : result;
  }

  public static final int PARTITIONS_FIELD_NUMBER = 6;
  private com.google.cloud.migrationcenter.v1.DiskPartitionList partitions_;
  /**
   *
   *
   * <pre>
   * Partition layout.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.DiskPartitionList partitions = 6;</code>
   *
   * @return Whether the partitions field is set.
   */
  @java.lang.Override
  public boolean hasPartitions() {
    return partitions_ != null;
  }
  /**
   *
   *
   * <pre>
   * Partition layout.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.DiskPartitionList partitions = 6;</code>
   *
   * @return The partitions.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.DiskPartitionList getPartitions() {
    return partitions_ == null
        ? com.google.cloud.migrationcenter.v1.DiskPartitionList.getDefaultInstance()
        : partitions_;
  }
  /**
   *
   *
   * <pre>
   * Partition layout.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.DiskPartitionList partitions = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.DiskPartitionListOrBuilder getPartitionsOrBuilder() {
    return partitions_ == null
        ? com.google.cloud.migrationcenter.v1.DiskPartitionList.getDefaultInstance()
        : partitions_;
  }

  public static final int HW_ADDRESS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object hwAddress_ = "";
  /**
   *
   *
   * <pre>
   * Disk hardware address (e.g. 0:1 for SCSI).
   * </pre>
   *
   * <code>string hw_address = 7;</code>
   *
   * @return The hwAddress.
   */
  @java.lang.Override
  public java.lang.String getHwAddress() {
    java.lang.Object ref = hwAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      hwAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Disk hardware address (e.g. 0:1 for SCSI).
   * </pre>
   *
   * <code>string hw_address = 7;</code>
   *
   * @return The bytes for hwAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHwAddressBytes() {
    java.lang.Object ref = hwAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      hwAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VMWARE_FIELD_NUMBER = 20;
  /**
   *
   *
   * <pre>
   * VMware disk details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig vmware = 20;</code>
   *
   * @return Whether the vmware field is set.
   */
  @java.lang.Override
  public boolean hasVmware() {
    return platformSpecificCase_ == 20;
  }
  /**
   *
   *
   * <pre>
   * VMware disk details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig vmware = 20;</code>
   *
   * @return The vmware.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.VmwareDiskConfig getVmware() {
    if (platformSpecificCase_ == 20) {
      return (com.google.cloud.migrationcenter.v1.VmwareDiskConfig) platformSpecific_;
    }
    return com.google.cloud.migrationcenter.v1.VmwareDiskConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * VMware disk details.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig vmware = 20;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.VmwareDiskConfigOrBuilder getVmwareOrBuilder() {
    if (platformSpecificCase_ == 20) {
      return (com.google.cloud.migrationcenter.v1.VmwareDiskConfig) platformSpecific_;
    }
    return com.google.cloud.migrationcenter.v1.VmwareDiskConfig.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (capacityBytes_ != 0L) {
      output.writeInt64(1, capacityBytes_);
    }
    if (freeBytes_ != 0L) {
      output.writeInt64(2, freeBytes_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diskLabel_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, diskLabel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diskLabelType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, diskLabelType_);
    }
    if (interfaceType_
        != com.google.cloud.migrationcenter.v1.DiskEntry.InterfaceType.INTERFACE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, interfaceType_);
    }
    if (partitions_ != null) {
      output.writeMessage(6, getPartitions());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hwAddress_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, hwAddress_);
    }
    if (platformSpecificCase_ == 20) {
      output.writeMessage(
          20, (com.google.cloud.migrationcenter.v1.VmwareDiskConfig) platformSpecific_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (capacityBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, capacityBytes_);
    }
    if (freeBytes_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, freeBytes_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diskLabel_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, diskLabel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(diskLabelType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, diskLabelType_);
    }
    if (interfaceType_
        != com.google.cloud.migrationcenter.v1.DiskEntry.InterfaceType.INTERFACE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, interfaceType_);
    }
    if (partitions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getPartitions());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hwAddress_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, hwAddress_);
    }
    if (platformSpecificCase_ == 20) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              20, (com.google.cloud.migrationcenter.v1.VmwareDiskConfig) platformSpecific_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.DiskEntry)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.DiskEntry other =
        (com.google.cloud.migrationcenter.v1.DiskEntry) obj;

    if (getCapacityBytes() != other.getCapacityBytes()) return false;
    if (getFreeBytes() != other.getFreeBytes()) return false;
    if (!getDiskLabel().equals(other.getDiskLabel())) return false;
    if (!getDiskLabelType().equals(other.getDiskLabelType())) return false;
    if (interfaceType_ != other.interfaceType_) return false;
    if (hasPartitions() != other.hasPartitions()) return false;
    if (hasPartitions()) {
      if (!getPartitions().equals(other.getPartitions())) return false;
    }
    if (!getHwAddress().equals(other.getHwAddress())) return false;
    if (!getPlatformSpecificCase().equals(other.getPlatformSpecificCase())) return false;
    switch (platformSpecificCase_) {
      case 20:
        if (!getVmware().equals(other.getVmware())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CAPACITY_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCapacityBytes());
    hash = (37 * hash) + FREE_BYTES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getFreeBytes());
    hash = (37 * hash) + DISK_LABEL_FIELD_NUMBER;
    hash = (53 * hash) + getDiskLabel().hashCode();
    hash = (37 * hash) + DISK_LABEL_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getDiskLabelType().hashCode();
    hash = (37 * hash) + INTERFACE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + interfaceType_;
    if (hasPartitions()) {
      hash = (37 * hash) + PARTITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getPartitions().hashCode();
    }
    hash = (37 * hash) + HW_ADDRESS_FIELD_NUMBER;
    hash = (53 * hash) + getHwAddress().hashCode();
    switch (platformSpecificCase_) {
      case 20:
        hash = (37 * hash) + VMWARE_FIELD_NUMBER;
        hash = (53 * hash) + getVmware().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.DiskEntry parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.DiskEntry parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.DiskEntry parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.DiskEntry parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.DiskEntry parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.DiskEntry parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.DiskEntry parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.DiskEntry parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.DiskEntry parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.DiskEntry parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.DiskEntry parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.DiskEntry parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.migrationcenter.v1.DiskEntry prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Single disk entry.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.DiskEntry}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.DiskEntry)
      com.google.cloud.migrationcenter.v1.DiskEntryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_DiskEntry_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_DiskEntry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.DiskEntry.class,
              com.google.cloud.migrationcenter.v1.DiskEntry.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.DiskEntry.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      capacityBytes_ = 0L;
      freeBytes_ = 0L;
      diskLabel_ = "";
      diskLabelType_ = "";
      interfaceType_ = 0;
      partitions_ = null;
      if (partitionsBuilder_ != null) {
        partitionsBuilder_.dispose();
        partitionsBuilder_ = null;
      }
      hwAddress_ = "";
      if (vmwareBuilder_ != null) {
        vmwareBuilder_.clear();
      }
      platformSpecificCase_ = 0;
      platformSpecific_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_DiskEntry_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DiskEntry getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.DiskEntry.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DiskEntry build() {
      com.google.cloud.migrationcenter.v1.DiskEntry result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DiskEntry buildPartial() {
      com.google.cloud.migrationcenter.v1.DiskEntry result =
          new com.google.cloud.migrationcenter.v1.DiskEntry(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.DiskEntry result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.capacityBytes_ = capacityBytes_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.freeBytes_ = freeBytes_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.diskLabel_ = diskLabel_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.diskLabelType_ = diskLabelType_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.interfaceType_ = interfaceType_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.partitions_ = partitionsBuilder_ == null ? partitions_ : partitionsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.hwAddress_ = hwAddress_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.migrationcenter.v1.DiskEntry result) {
      result.platformSpecificCase_ = platformSpecificCase_;
      result.platformSpecific_ = this.platformSpecific_;
      if (platformSpecificCase_ == 20 && vmwareBuilder_ != null) {
        result.platformSpecific_ = vmwareBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.DiskEntry) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.DiskEntry) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.DiskEntry other) {
      if (other == com.google.cloud.migrationcenter.v1.DiskEntry.getDefaultInstance()) return this;
      if (other.getCapacityBytes() != 0L) {
        setCapacityBytes(other.getCapacityBytes());
      }
      if (other.getFreeBytes() != 0L) {
        setFreeBytes(other.getFreeBytes());
      }
      if (!other.getDiskLabel().isEmpty()) {
        diskLabel_ = other.diskLabel_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDiskLabelType().isEmpty()) {
        diskLabelType_ = other.diskLabelType_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.interfaceType_ != 0) {
        setInterfaceTypeValue(other.getInterfaceTypeValue());
      }
      if (other.hasPartitions()) {
        mergePartitions(other.getPartitions());
      }
      if (!other.getHwAddress().isEmpty()) {
        hwAddress_ = other.hwAddress_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      switch (other.getPlatformSpecificCase()) {
        case VMWARE:
          {
            mergeVmware(other.getVmware());
            break;
          }
        case PLATFORMSPECIFIC_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                capacityBytes_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                freeBytes_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                diskLabel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                diskLabelType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                interfaceType_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getPartitionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                hwAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 162:
              {
                input.readMessage(getVmwareFieldBuilder().getBuilder(), extensionRegistry);
                platformSpecificCase_ = 20;
                break;
              } // case 162
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int platformSpecificCase_ = 0;
    private java.lang.Object platformSpecific_;

    public PlatformSpecificCase getPlatformSpecificCase() {
      return PlatformSpecificCase.forNumber(platformSpecificCase_);
    }

    public Builder clearPlatformSpecific() {
      platformSpecificCase_ = 0;
      platformSpecific_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private long capacityBytes_;
    /**
     *
     *
     * <pre>
     * Disk capacity.
     * </pre>
     *
     * <code>int64 capacity_bytes = 1;</code>
     *
     * @return The capacityBytes.
     */
    @java.lang.Override
    public long getCapacityBytes() {
      return capacityBytes_;
    }
    /**
     *
     *
     * <pre>
     * Disk capacity.
     * </pre>
     *
     * <code>int64 capacity_bytes = 1;</code>
     *
     * @param value The capacityBytes to set.
     * @return This builder for chaining.
     */
    public Builder setCapacityBytes(long value) {

      capacityBytes_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk capacity.
     * </pre>
     *
     * <code>int64 capacity_bytes = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCapacityBytes() {
      bitField0_ = (bitField0_ & ~0x00000001);
      capacityBytes_ = 0L;
      onChanged();
      return this;
    }

    private long freeBytes_;
    /**
     *
     *
     * <pre>
     * Disk free space.
     * </pre>
     *
     * <code>int64 free_bytes = 2;</code>
     *
     * @return The freeBytes.
     */
    @java.lang.Override
    public long getFreeBytes() {
      return freeBytes_;
    }
    /**
     *
     *
     * <pre>
     * Disk free space.
     * </pre>
     *
     * <code>int64 free_bytes = 2;</code>
     *
     * @param value The freeBytes to set.
     * @return This builder for chaining.
     */
    public Builder setFreeBytes(long value) {

      freeBytes_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk free space.
     * </pre>
     *
     * <code>int64 free_bytes = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFreeBytes() {
      bitField0_ = (bitField0_ & ~0x00000002);
      freeBytes_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object diskLabel_ = "";
    /**
     *
     *
     * <pre>
     * Disk label.
     * </pre>
     *
     * <code>string disk_label = 3;</code>
     *
     * @return The diskLabel.
     */
    public java.lang.String getDiskLabel() {
      java.lang.Object ref = diskLabel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        diskLabel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Disk label.
     * </pre>
     *
     * <code>string disk_label = 3;</code>
     *
     * @return The bytes for diskLabel.
     */
    public com.google.protobuf.ByteString getDiskLabelBytes() {
      java.lang.Object ref = diskLabel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        diskLabel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Disk label.
     * </pre>
     *
     * <code>string disk_label = 3;</code>
     *
     * @param value The diskLabel to set.
     * @return This builder for chaining.
     */
    public Builder setDiskLabel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      diskLabel_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk label.
     * </pre>
     *
     * <code>string disk_label = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskLabel() {
      diskLabel_ = getDefaultInstance().getDiskLabel();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk label.
     * </pre>
     *
     * <code>string disk_label = 3;</code>
     *
     * @param value The bytes for diskLabel to set.
     * @return This builder for chaining.
     */
    public Builder setDiskLabelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      diskLabel_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object diskLabelType_ = "";
    /**
     *
     *
     * <pre>
     * Disk label type (e.g. BIOS/GPT)
     * </pre>
     *
     * <code>string disk_label_type = 4;</code>
     *
     * @return The diskLabelType.
     */
    public java.lang.String getDiskLabelType() {
      java.lang.Object ref = diskLabelType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        diskLabelType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Disk label type (e.g. BIOS/GPT)
     * </pre>
     *
     * <code>string disk_label_type = 4;</code>
     *
     * @return The bytes for diskLabelType.
     */
    public com.google.protobuf.ByteString getDiskLabelTypeBytes() {
      java.lang.Object ref = diskLabelType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        diskLabelType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Disk label type (e.g. BIOS/GPT)
     * </pre>
     *
     * <code>string disk_label_type = 4;</code>
     *
     * @param value The diskLabelType to set.
     * @return This builder for chaining.
     */
    public Builder setDiskLabelType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      diskLabelType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk label type (e.g. BIOS/GPT)
     * </pre>
     *
     * <code>string disk_label_type = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskLabelType() {
      diskLabelType_ = getDefaultInstance().getDiskLabelType();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk label type (e.g. BIOS/GPT)
     * </pre>
     *
     * <code>string disk_label_type = 4;</code>
     *
     * @param value The bytes for diskLabelType to set.
     * @return This builder for chaining.
     */
    public Builder setDiskLabelTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      diskLabelType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int interfaceType_ = 0;
    /**
     *
     *
     * <pre>
     * Disks interface type.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DiskEntry.InterfaceType interface_type = 5;</code>
     *
     * @return The enum numeric value on the wire for interfaceType.
     */
    @java.lang.Override
    public int getInterfaceTypeValue() {
      return interfaceType_;
    }
    /**
     *
     *
     * <pre>
     * Disks interface type.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DiskEntry.InterfaceType interface_type = 5;</code>
     *
     * @param value The enum numeric value on the wire for interfaceType to set.
     * @return This builder for chaining.
     */
    public Builder setInterfaceTypeValue(int value) {
      interfaceType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disks interface type.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DiskEntry.InterfaceType interface_type = 5;</code>
     *
     * @return The interfaceType.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.DiskEntry.InterfaceType getInterfaceType() {
      com.google.cloud.migrationcenter.v1.DiskEntry.InterfaceType result =
          com.google.cloud.migrationcenter.v1.DiskEntry.InterfaceType.forNumber(interfaceType_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.DiskEntry.InterfaceType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Disks interface type.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DiskEntry.InterfaceType interface_type = 5;</code>
     *
     * @param value The interfaceType to set.
     * @return This builder for chaining.
     */
    public Builder setInterfaceType(
        com.google.cloud.migrationcenter.v1.DiskEntry.InterfaceType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      interfaceType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disks interface type.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DiskEntry.InterfaceType interface_type = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInterfaceType() {
      bitField0_ = (bitField0_ & ~0x00000010);
      interfaceType_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.migrationcenter.v1.DiskPartitionList partitions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.DiskPartitionList,
            com.google.cloud.migrationcenter.v1.DiskPartitionList.Builder,
            com.google.cloud.migrationcenter.v1.DiskPartitionListOrBuilder>
        partitionsBuilder_;
    /**
     *
     *
     * <pre>
     * Partition layout.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DiskPartitionList partitions = 6;</code>
     *
     * @return Whether the partitions field is set.
     */
    public boolean hasPartitions() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Partition layout.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DiskPartitionList partitions = 6;</code>
     *
     * @return The partitions.
     */
    public com.google.cloud.migrationcenter.v1.DiskPartitionList getPartitions() {
      if (partitionsBuilder_ == null) {
        return partitions_ == null
            ? com.google.cloud.migrationcenter.v1.DiskPartitionList.getDefaultInstance()
            : partitions_;
      } else {
        return partitionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Partition layout.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DiskPartitionList partitions = 6;</code>
     */
    public Builder setPartitions(com.google.cloud.migrationcenter.v1.DiskPartitionList value) {
      if (partitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        partitions_ = value;
      } else {
        partitionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partition layout.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DiskPartitionList partitions = 6;</code>
     */
    public Builder setPartitions(
        com.google.cloud.migrationcenter.v1.DiskPartitionList.Builder builderForValue) {
      if (partitionsBuilder_ == null) {
        partitions_ = builderForValue.build();
      } else {
        partitionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partition layout.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DiskPartitionList partitions = 6;</code>
     */
    public Builder mergePartitions(com.google.cloud.migrationcenter.v1.DiskPartitionList value) {
      if (partitionsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && partitions_ != null
            && partitions_
                != com.google.cloud.migrationcenter.v1.DiskPartitionList.getDefaultInstance()) {
          getPartitionsBuilder().mergeFrom(value);
        } else {
          partitions_ = value;
        }
      } else {
        partitionsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partition layout.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DiskPartitionList partitions = 6;</code>
     */
    public Builder clearPartitions() {
      bitField0_ = (bitField0_ & ~0x00000020);
      partitions_ = null;
      if (partitionsBuilder_ != null) {
        partitionsBuilder_.dispose();
        partitionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partition layout.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DiskPartitionList partitions = 6;</code>
     */
    public com.google.cloud.migrationcenter.v1.DiskPartitionList.Builder getPartitionsBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getPartitionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Partition layout.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DiskPartitionList partitions = 6;</code>
     */
    public com.google.cloud.migrationcenter.v1.DiskPartitionListOrBuilder getPartitionsOrBuilder() {
      if (partitionsBuilder_ != null) {
        return partitionsBuilder_.getMessageOrBuilder();
      } else {
        return partitions_ == null
            ? com.google.cloud.migrationcenter.v1.DiskPartitionList.getDefaultInstance()
            : partitions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Partition layout.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.DiskPartitionList partitions = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.DiskPartitionList,
            com.google.cloud.migrationcenter.v1.DiskPartitionList.Builder,
            com.google.cloud.migrationcenter.v1.DiskPartitionListOrBuilder>
        getPartitionsFieldBuilder() {
      if (partitionsBuilder_ == null) {
        partitionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.DiskPartitionList,
                com.google.cloud.migrationcenter.v1.DiskPartitionList.Builder,
                com.google.cloud.migrationcenter.v1.DiskPartitionListOrBuilder>(
                getPartitions(), getParentForChildren(), isClean());
        partitions_ = null;
      }
      return partitionsBuilder_;
    }

    private java.lang.Object hwAddress_ = "";
    /**
     *
     *
     * <pre>
     * Disk hardware address (e.g. 0:1 for SCSI).
     * </pre>
     *
     * <code>string hw_address = 7;</code>
     *
     * @return The hwAddress.
     */
    public java.lang.String getHwAddress() {
      java.lang.Object ref = hwAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hwAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Disk hardware address (e.g. 0:1 for SCSI).
     * </pre>
     *
     * <code>string hw_address = 7;</code>
     *
     * @return The bytes for hwAddress.
     */
    public com.google.protobuf.ByteString getHwAddressBytes() {
      java.lang.Object ref = hwAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        hwAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Disk hardware address (e.g. 0:1 for SCSI).
     * </pre>
     *
     * <code>string hw_address = 7;</code>
     *
     * @param value The hwAddress to set.
     * @return This builder for chaining.
     */
    public Builder setHwAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      hwAddress_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk hardware address (e.g. 0:1 for SCSI).
     * </pre>
     *
     * <code>string hw_address = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHwAddress() {
      hwAddress_ = getDefaultInstance().getHwAddress();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Disk hardware address (e.g. 0:1 for SCSI).
     * </pre>
     *
     * <code>string hw_address = 7;</code>
     *
     * @param value The bytes for hwAddress to set.
     * @return This builder for chaining.
     */
    public Builder setHwAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      hwAddress_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.VmwareDiskConfig,
            com.google.cloud.migrationcenter.v1.VmwareDiskConfig.Builder,
            com.google.cloud.migrationcenter.v1.VmwareDiskConfigOrBuilder>
        vmwareBuilder_;
    /**
     *
     *
     * <pre>
     * VMware disk details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig vmware = 20;</code>
     *
     * @return Whether the vmware field is set.
     */
    @java.lang.Override
    public boolean hasVmware() {
      return platformSpecificCase_ == 20;
    }
    /**
     *
     *
     * <pre>
     * VMware disk details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig vmware = 20;</code>
     *
     * @return The vmware.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VmwareDiskConfig getVmware() {
      if (vmwareBuilder_ == null) {
        if (platformSpecificCase_ == 20) {
          return (com.google.cloud.migrationcenter.v1.VmwareDiskConfig) platformSpecific_;
        }
        return com.google.cloud.migrationcenter.v1.VmwareDiskConfig.getDefaultInstance();
      } else {
        if (platformSpecificCase_ == 20) {
          return vmwareBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.VmwareDiskConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * VMware disk details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig vmware = 20;</code>
     */
    public Builder setVmware(com.google.cloud.migrationcenter.v1.VmwareDiskConfig value) {
      if (vmwareBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        platformSpecific_ = value;
        onChanged();
      } else {
        vmwareBuilder_.setMessage(value);
      }
      platformSpecificCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * VMware disk details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig vmware = 20;</code>
     */
    public Builder setVmware(
        com.google.cloud.migrationcenter.v1.VmwareDiskConfig.Builder builderForValue) {
      if (vmwareBuilder_ == null) {
        platformSpecific_ = builderForValue.build();
        onChanged();
      } else {
        vmwareBuilder_.setMessage(builderForValue.build());
      }
      platformSpecificCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * VMware disk details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig vmware = 20;</code>
     */
    public Builder mergeVmware(com.google.cloud.migrationcenter.v1.VmwareDiskConfig value) {
      if (vmwareBuilder_ == null) {
        if (platformSpecificCase_ == 20
            && platformSpecific_
                != com.google.cloud.migrationcenter.v1.VmwareDiskConfig.getDefaultInstance()) {
          platformSpecific_ =
              com.google.cloud.migrationcenter.v1.VmwareDiskConfig.newBuilder(
                      (com.google.cloud.migrationcenter.v1.VmwareDiskConfig) platformSpecific_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          platformSpecific_ = value;
        }
        onChanged();
      } else {
        if (platformSpecificCase_ == 20) {
          vmwareBuilder_.mergeFrom(value);
        } else {
          vmwareBuilder_.setMessage(value);
        }
      }
      platformSpecificCase_ = 20;
      return this;
    }
    /**
     *
     *
     * <pre>
     * VMware disk details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig vmware = 20;</code>
     */
    public Builder clearVmware() {
      if (vmwareBuilder_ == null) {
        if (platformSpecificCase_ == 20) {
          platformSpecificCase_ = 0;
          platformSpecific_ = null;
          onChanged();
        }
      } else {
        if (platformSpecificCase_ == 20) {
          platformSpecificCase_ = 0;
          platformSpecific_ = null;
        }
        vmwareBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * VMware disk details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig vmware = 20;</code>
     */
    public com.google.cloud.migrationcenter.v1.VmwareDiskConfig.Builder getVmwareBuilder() {
      return getVmwareFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * VMware disk details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig vmware = 20;</code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.VmwareDiskConfigOrBuilder getVmwareOrBuilder() {
      if ((platformSpecificCase_ == 20) && (vmwareBuilder_ != null)) {
        return vmwareBuilder_.getMessageOrBuilder();
      } else {
        if (platformSpecificCase_ == 20) {
          return (com.google.cloud.migrationcenter.v1.VmwareDiskConfig) platformSpecific_;
        }
        return com.google.cloud.migrationcenter.v1.VmwareDiskConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * VMware disk details.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.VmwareDiskConfig vmware = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.VmwareDiskConfig,
            com.google.cloud.migrationcenter.v1.VmwareDiskConfig.Builder,
            com.google.cloud.migrationcenter.v1.VmwareDiskConfigOrBuilder>
        getVmwareFieldBuilder() {
      if (vmwareBuilder_ == null) {
        if (!(platformSpecificCase_ == 20)) {
          platformSpecific_ =
              com.google.cloud.migrationcenter.v1.VmwareDiskConfig.getDefaultInstance();
        }
        vmwareBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.VmwareDiskConfig,
                com.google.cloud.migrationcenter.v1.VmwareDiskConfig.Builder,
                com.google.cloud.migrationcenter.v1.VmwareDiskConfigOrBuilder>(
                (com.google.cloud.migrationcenter.v1.VmwareDiskConfig) platformSpecific_,
                getParentForChildren(),
                isClean());
        platformSpecific_ = null;
      }
      platformSpecificCase_ = 20;
      onChanged();
      return vmwareBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.DiskEntry)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.DiskEntry)
  private static final com.google.cloud.migrationcenter.v1.DiskEntry DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.DiskEntry();
  }

  public static com.google.cloud.migrationcenter.v1.DiskEntry getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DiskEntry> PARSER =
      new com.google.protobuf.AbstractParser<DiskEntry>() {
        @java.lang.Override
        public DiskEntry parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DiskEntry> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DiskEntry> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.DiskEntry getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
