/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * Message representing a frame which failed to be processed due to an error.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.ErrorFrame}
 */
public final class ErrorFrame extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ErrorFrame)
    ErrorFrameOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ErrorFrame.newBuilder() to construct.
  private ErrorFrame(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ErrorFrame() {
    name_ = "";
    violations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ErrorFrame();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_ErrorFrame_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_ErrorFrame_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.ErrorFrame.class,
            com.google.cloud.migrationcenter.v1.ErrorFrame.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The identifier of the ErrorFrame.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The identifier of the ErrorFrame.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VIOLATIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.migrationcenter.v1.FrameViolationEntry> violations_;
  /**
   *
   *
   * <pre>
   * Output only. All the violations that were detected for the frame.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.migrationcenter.v1.FrameViolationEntry>
      getViolationsList() {
    return violations_;
  }
  /**
   *
   *
   * <pre>
   * Output only. All the violations that were detected for the frame.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.migrationcenter.v1.FrameViolationEntryOrBuilder>
      getViolationsOrBuilderList() {
    return violations_;
  }
  /**
   *
   *
   * <pre>
   * Output only. All the violations that were detected for the frame.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getViolationsCount() {
    return violations_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. All the violations that were detected for the frame.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.FrameViolationEntry getViolations(int index) {
    return violations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. All the violations that were detected for the frame.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.FrameViolationEntryOrBuilder getViolationsOrBuilder(
      int index) {
    return violations_.get(index);
  }

  public static final int ORIGINAL_FRAME_FIELD_NUMBER = 3;
  private com.google.cloud.migrationcenter.v1.AssetFrame originalFrame_;
  /**
   *
   *
   * <pre>
   * Output only. The frame that was originally reported.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.AssetFrame original_frame = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the originalFrame field is set.
   */
  @java.lang.Override
  public boolean hasOriginalFrame() {
    return originalFrame_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The frame that was originally reported.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.AssetFrame original_frame = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The originalFrame.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AssetFrame getOriginalFrame() {
    return originalFrame_ == null
        ? com.google.cloud.migrationcenter.v1.AssetFrame.getDefaultInstance()
        : originalFrame_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The frame that was originally reported.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.AssetFrame original_frame = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.AssetFrameOrBuilder getOriginalFrameOrBuilder() {
    return originalFrame_ == null
        ? com.google.cloud.migrationcenter.v1.AssetFrame.getDefaultInstance()
        : originalFrame_;
  }

  public static final int INGESTION_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp ingestionTime_;
  /**
   *
   *
   * <pre>
   * Output only. Frame ingestion time.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp ingestion_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the ingestionTime field is set.
   */
  @java.lang.Override
  public boolean hasIngestionTime() {
    return ingestionTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Frame ingestion time.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp ingestion_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The ingestionTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getIngestionTime() {
    return ingestionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : ingestionTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Frame ingestion time.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp ingestion_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getIngestionTimeOrBuilder() {
    return ingestionTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : ingestionTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < violations_.size(); i++) {
      output.writeMessage(2, violations_.get(i));
    }
    if (originalFrame_ != null) {
      output.writeMessage(3, getOriginalFrame());
    }
    if (ingestionTime_ != null) {
      output.writeMessage(4, getIngestionTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (int i = 0; i < violations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, violations_.get(i));
    }
    if (originalFrame_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getOriginalFrame());
    }
    if (ingestionTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getIngestionTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.ErrorFrame)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.ErrorFrame other =
        (com.google.cloud.migrationcenter.v1.ErrorFrame) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getViolationsList().equals(other.getViolationsList())) return false;
    if (hasOriginalFrame() != other.hasOriginalFrame()) return false;
    if (hasOriginalFrame()) {
      if (!getOriginalFrame().equals(other.getOriginalFrame())) return false;
    }
    if (hasIngestionTime() != other.hasIngestionTime()) return false;
    if (hasIngestionTime()) {
      if (!getIngestionTime().equals(other.getIngestionTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getViolationsCount() > 0) {
      hash = (37 * hash) + VIOLATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getViolationsList().hashCode();
    }
    if (hasOriginalFrame()) {
      hash = (37 * hash) + ORIGINAL_FRAME_FIELD_NUMBER;
      hash = (53 * hash) + getOriginalFrame().hashCode();
    }
    if (hasIngestionTime()) {
      hash = (37 * hash) + INGESTION_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getIngestionTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.ErrorFrame parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ErrorFrame parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ErrorFrame parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ErrorFrame parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ErrorFrame parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ErrorFrame parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ErrorFrame parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ErrorFrame parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ErrorFrame parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ErrorFrame parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ErrorFrame parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ErrorFrame parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.migrationcenter.v1.ErrorFrame prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Message representing a frame which failed to be processed due to an error.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ErrorFrame}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ErrorFrame)
      com.google.cloud.migrationcenter.v1.ErrorFrameOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ErrorFrame_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ErrorFrame_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ErrorFrame.class,
              com.google.cloud.migrationcenter.v1.ErrorFrame.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.ErrorFrame.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (violationsBuilder_ == null) {
        violations_ = java.util.Collections.emptyList();
      } else {
        violations_ = null;
        violationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      originalFrame_ = null;
      if (originalFrameBuilder_ != null) {
        originalFrameBuilder_.dispose();
        originalFrameBuilder_ = null;
      }
      ingestionTime_ = null;
      if (ingestionTimeBuilder_ != null) {
        ingestionTimeBuilder_.dispose();
        ingestionTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ErrorFrame_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ErrorFrame getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.ErrorFrame.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ErrorFrame build() {
      com.google.cloud.migrationcenter.v1.ErrorFrame result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ErrorFrame buildPartial() {
      com.google.cloud.migrationcenter.v1.ErrorFrame result =
          new com.google.cloud.migrationcenter.v1.ErrorFrame(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.migrationcenter.v1.ErrorFrame result) {
      if (violationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          violations_ = java.util.Collections.unmodifiableList(violations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.violations_ = violations_;
      } else {
        result.violations_ = violationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.ErrorFrame result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.originalFrame_ =
            originalFrameBuilder_ == null ? originalFrame_ : originalFrameBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ingestionTime_ =
            ingestionTimeBuilder_ == null ? ingestionTime_ : ingestionTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.ErrorFrame) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.ErrorFrame) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.ErrorFrame other) {
      if (other == com.google.cloud.migrationcenter.v1.ErrorFrame.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (violationsBuilder_ == null) {
        if (!other.violations_.isEmpty()) {
          if (violations_.isEmpty()) {
            violations_ = other.violations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureViolationsIsMutable();
            violations_.addAll(other.violations_);
          }
          onChanged();
        }
      } else {
        if (!other.violations_.isEmpty()) {
          if (violationsBuilder_.isEmpty()) {
            violationsBuilder_.dispose();
            violationsBuilder_ = null;
            violations_ = other.violations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            violationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getViolationsFieldBuilder()
                    : null;
          } else {
            violationsBuilder_.addAllMessages(other.violations_);
          }
        }
      }
      if (other.hasOriginalFrame()) {
        mergeOriginalFrame(other.getOriginalFrame());
      }
      if (other.hasIngestionTime()) {
        mergeIngestionTime(other.getIngestionTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.migrationcenter.v1.FrameViolationEntry m =
                    input.readMessage(
                        com.google.cloud.migrationcenter.v1.FrameViolationEntry.parser(),
                        extensionRegistry);
                if (violationsBuilder_ == null) {
                  ensureViolationsIsMutable();
                  violations_.add(m);
                } else {
                  violationsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getOriginalFrameFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getIngestionTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The identifier of the ErrorFrame.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The identifier of the ErrorFrame.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The identifier of the ErrorFrame.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The identifier of the ErrorFrame.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The identifier of the ErrorFrame.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.migrationcenter.v1.FrameViolationEntry> violations_ =
        java.util.Collections.emptyList();

    private void ensureViolationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        violations_ =
            new java.util.ArrayList<com.google.cloud.migrationcenter.v1.FrameViolationEntry>(
                violations_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.FrameViolationEntry,
            com.google.cloud.migrationcenter.v1.FrameViolationEntry.Builder,
            com.google.cloud.migrationcenter.v1.FrameViolationEntryOrBuilder>
        violationsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. All the violations that were detected for the frame.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.FrameViolationEntry>
        getViolationsList() {
      if (violationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(violations_);
      } else {
        return violationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. All the violations that were detected for the frame.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getViolationsCount() {
      if (violationsBuilder_ == null) {
        return violations_.size();
      } else {
        return violationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. All the violations that were detected for the frame.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.FrameViolationEntry getViolations(int index) {
      if (violationsBuilder_ == null) {
        return violations_.get(index);
      } else {
        return violationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. All the violations that were detected for the frame.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setViolations(
        int index, com.google.cloud.migrationcenter.v1.FrameViolationEntry value) {
      if (violationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureViolationsIsMutable();
        violations_.set(index, value);
        onChanged();
      } else {
        violationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. All the violations that were detected for the frame.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setViolations(
        int index,
        com.google.cloud.migrationcenter.v1.FrameViolationEntry.Builder builderForValue) {
      if (violationsBuilder_ == null) {
        ensureViolationsIsMutable();
        violations_.set(index, builderForValue.build());
        onChanged();
      } else {
        violationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. All the violations that were detected for the frame.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addViolations(com.google.cloud.migrationcenter.v1.FrameViolationEntry value) {
      if (violationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureViolationsIsMutable();
        violations_.add(value);
        onChanged();
      } else {
        violationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. All the violations that were detected for the frame.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addViolations(
        int index, com.google.cloud.migrationcenter.v1.FrameViolationEntry value) {
      if (violationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureViolationsIsMutable();
        violations_.add(index, value);
        onChanged();
      } else {
        violationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. All the violations that were detected for the frame.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addViolations(
        com.google.cloud.migrationcenter.v1.FrameViolationEntry.Builder builderForValue) {
      if (violationsBuilder_ == null) {
        ensureViolationsIsMutable();
        violations_.add(builderForValue.build());
        onChanged();
      } else {
        violationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. All the violations that were detected for the frame.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addViolations(
        int index,
        com.google.cloud.migrationcenter.v1.FrameViolationEntry.Builder builderForValue) {
      if (violationsBuilder_ == null) {
        ensureViolationsIsMutable();
        violations_.add(index, builderForValue.build());
        onChanged();
      } else {
        violationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. All the violations that were detected for the frame.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllViolations(
        java.lang.Iterable<? extends com.google.cloud.migrationcenter.v1.FrameViolationEntry>
            values) {
      if (violationsBuilder_ == null) {
        ensureViolationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, violations_);
        onChanged();
      } else {
        violationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. All the violations that were detected for the frame.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearViolations() {
      if (violationsBuilder_ == null) {
        violations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        violationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. All the violations that were detected for the frame.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeViolations(int index) {
      if (violationsBuilder_ == null) {
        ensureViolationsIsMutable();
        violations_.remove(index);
        onChanged();
      } else {
        violationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. All the violations that were detected for the frame.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.FrameViolationEntry.Builder getViolationsBuilder(
        int index) {
      return getViolationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. All the violations that were detected for the frame.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.FrameViolationEntryOrBuilder getViolationsOrBuilder(
        int index) {
      if (violationsBuilder_ == null) {
        return violations_.get(index);
      } else {
        return violationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. All the violations that were detected for the frame.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.migrationcenter.v1.FrameViolationEntryOrBuilder>
        getViolationsOrBuilderList() {
      if (violationsBuilder_ != null) {
        return violationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(violations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. All the violations that were detected for the frame.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.FrameViolationEntry.Builder addViolationsBuilder() {
      return getViolationsFieldBuilder()
          .addBuilder(com.google.cloud.migrationcenter.v1.FrameViolationEntry.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. All the violations that were detected for the frame.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.FrameViolationEntry.Builder addViolationsBuilder(
        int index) {
      return getViolationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.migrationcenter.v1.FrameViolationEntry.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. All the violations that were detected for the frame.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.migrationcenter.v1.FrameViolationEntry violations = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.FrameViolationEntry.Builder>
        getViolationsBuilderList() {
      return getViolationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.FrameViolationEntry,
            com.google.cloud.migrationcenter.v1.FrameViolationEntry.Builder,
            com.google.cloud.migrationcenter.v1.FrameViolationEntryOrBuilder>
        getViolationsFieldBuilder() {
      if (violationsBuilder_ == null) {
        violationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.FrameViolationEntry,
                com.google.cloud.migrationcenter.v1.FrameViolationEntry.Builder,
                com.google.cloud.migrationcenter.v1.FrameViolationEntryOrBuilder>(
                violations_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        violations_ = null;
      }
      return violationsBuilder_;
    }

    private com.google.cloud.migrationcenter.v1.AssetFrame originalFrame_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.AssetFrame,
            com.google.cloud.migrationcenter.v1.AssetFrame.Builder,
            com.google.cloud.migrationcenter.v1.AssetFrameOrBuilder>
        originalFrameBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The frame that was originally reported.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetFrame original_frame = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the originalFrame field is set.
     */
    public boolean hasOriginalFrame() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The frame that was originally reported.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetFrame original_frame = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The originalFrame.
     */
    public com.google.cloud.migrationcenter.v1.AssetFrame getOriginalFrame() {
      if (originalFrameBuilder_ == null) {
        return originalFrame_ == null
            ? com.google.cloud.migrationcenter.v1.AssetFrame.getDefaultInstance()
            : originalFrame_;
      } else {
        return originalFrameBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The frame that was originally reported.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetFrame original_frame = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOriginalFrame(com.google.cloud.migrationcenter.v1.AssetFrame value) {
      if (originalFrameBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        originalFrame_ = value;
      } else {
        originalFrameBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The frame that was originally reported.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetFrame original_frame = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOriginalFrame(
        com.google.cloud.migrationcenter.v1.AssetFrame.Builder builderForValue) {
      if (originalFrameBuilder_ == null) {
        originalFrame_ = builderForValue.build();
      } else {
        originalFrameBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The frame that was originally reported.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetFrame original_frame = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeOriginalFrame(com.google.cloud.migrationcenter.v1.AssetFrame value) {
      if (originalFrameBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && originalFrame_ != null
            && originalFrame_
                != com.google.cloud.migrationcenter.v1.AssetFrame.getDefaultInstance()) {
          getOriginalFrameBuilder().mergeFrom(value);
        } else {
          originalFrame_ = value;
        }
      } else {
        originalFrameBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The frame that was originally reported.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetFrame original_frame = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearOriginalFrame() {
      bitField0_ = (bitField0_ & ~0x00000004);
      originalFrame_ = null;
      if (originalFrameBuilder_ != null) {
        originalFrameBuilder_.dispose();
        originalFrameBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The frame that was originally reported.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetFrame original_frame = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.AssetFrame.Builder getOriginalFrameBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getOriginalFrameFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The frame that was originally reported.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetFrame original_frame = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.migrationcenter.v1.AssetFrameOrBuilder getOriginalFrameOrBuilder() {
      if (originalFrameBuilder_ != null) {
        return originalFrameBuilder_.getMessageOrBuilder();
      } else {
        return originalFrame_ == null
            ? com.google.cloud.migrationcenter.v1.AssetFrame.getDefaultInstance()
            : originalFrame_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The frame that was originally reported.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.AssetFrame original_frame = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.AssetFrame,
            com.google.cloud.migrationcenter.v1.AssetFrame.Builder,
            com.google.cloud.migrationcenter.v1.AssetFrameOrBuilder>
        getOriginalFrameFieldBuilder() {
      if (originalFrameBuilder_ == null) {
        originalFrameBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.AssetFrame,
                com.google.cloud.migrationcenter.v1.AssetFrame.Builder,
                com.google.cloud.migrationcenter.v1.AssetFrameOrBuilder>(
                getOriginalFrame(), getParentForChildren(), isClean());
        originalFrame_ = null;
      }
      return originalFrameBuilder_;
    }

    private com.google.protobuf.Timestamp ingestionTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        ingestionTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Frame ingestion time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp ingestion_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the ingestionTime field is set.
     */
    public boolean hasIngestionTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Frame ingestion time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp ingestion_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The ingestionTime.
     */
    public com.google.protobuf.Timestamp getIngestionTime() {
      if (ingestionTimeBuilder_ == null) {
        return ingestionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : ingestionTime_;
      } else {
        return ingestionTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Frame ingestion time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp ingestion_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setIngestionTime(com.google.protobuf.Timestamp value) {
      if (ingestionTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ingestionTime_ = value;
      } else {
        ingestionTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Frame ingestion time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp ingestion_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setIngestionTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (ingestionTimeBuilder_ == null) {
        ingestionTime_ = builderForValue.build();
      } else {
        ingestionTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Frame ingestion time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp ingestion_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeIngestionTime(com.google.protobuf.Timestamp value) {
      if (ingestionTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && ingestionTime_ != null
            && ingestionTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getIngestionTimeBuilder().mergeFrom(value);
        } else {
          ingestionTime_ = value;
        }
      } else {
        ingestionTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Frame ingestion time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp ingestion_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearIngestionTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ingestionTime_ = null;
      if (ingestionTimeBuilder_ != null) {
        ingestionTimeBuilder_.dispose();
        ingestionTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Frame ingestion time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp ingestion_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getIngestionTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getIngestionTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Frame ingestion time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp ingestion_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getIngestionTimeOrBuilder() {
      if (ingestionTimeBuilder_ != null) {
        return ingestionTimeBuilder_.getMessageOrBuilder();
      } else {
        return ingestionTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : ingestionTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Frame ingestion time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp ingestion_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getIngestionTimeFieldBuilder() {
      if (ingestionTimeBuilder_ == null) {
        ingestionTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getIngestionTime(), getParentForChildren(), isClean());
        ingestionTime_ = null;
      }
      return ingestionTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ErrorFrame)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ErrorFrame)
  private static final com.google.cloud.migrationcenter.v1.ErrorFrame DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.ErrorFrame();
  }

  public static com.google.cloud.migrationcenter.v1.ErrorFrame getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ErrorFrame> PARSER =
      new com.google.protobuf.AbstractParser<ErrorFrame>() {
        @java.lang.Override
        public ErrorFrame parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ErrorFrame> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ErrorFrame> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ErrorFrame getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
