/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * A resource that aggregates the validation errors found in an import job file.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.FileValidationReport}
 */
public final class FileValidationReport extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.FileValidationReport)
    FileValidationReportOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FileValidationReport.newBuilder() to construct.
  private FileValidationReport(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FileValidationReport() {
    fileName_ = "";
    rowErrors_ = java.util.Collections.emptyList();
    fileErrors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FileValidationReport();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_FileValidationReport_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_FileValidationReport_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.FileValidationReport.class,
            com.google.cloud.migrationcenter.v1.FileValidationReport.Builder.class);
  }

  public static final int FILE_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fileName_ = "";
  /**
   *
   *
   * <pre>
   * The name of the file.
   * </pre>
   *
   * <code>string file_name = 1;</code>
   *
   * @return The fileName.
   */
  @java.lang.Override
  public java.lang.String getFileName() {
    java.lang.Object ref = fileName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fileName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the file.
   * </pre>
   *
   * <code>string file_name = 1;</code>
   *
   * @return The bytes for fileName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFileNameBytes() {
    java.lang.Object ref = fileName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fileName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROW_ERRORS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.migrationcenter.v1.ImportRowError> rowErrors_;
  /**
   *
   *
   * <pre>
   * Partial list of rows that encountered validation error.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.migrationcenter.v1.ImportRowError> getRowErrorsList() {
    return rowErrors_;
  }
  /**
   *
   *
   * <pre>
   * Partial list of rows that encountered validation error.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.migrationcenter.v1.ImportRowErrorOrBuilder>
      getRowErrorsOrBuilderList() {
    return rowErrors_;
  }
  /**
   *
   *
   * <pre>
   * Partial list of rows that encountered validation error.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
   */
  @java.lang.Override
  public int getRowErrorsCount() {
    return rowErrors_.size();
  }
  /**
   *
   *
   * <pre>
   * Partial list of rows that encountered validation error.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ImportRowError getRowErrors(int index) {
    return rowErrors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Partial list of rows that encountered validation error.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ImportRowErrorOrBuilder getRowErrorsOrBuilder(
      int index) {
    return rowErrors_.get(index);
  }

  public static final int PARTIAL_REPORT_FIELD_NUMBER = 3;
  private boolean partialReport_ = false;
  /**
   *
   *
   * <pre>
   * Flag indicating that processing was aborted due to maximum number of
   * errors.
   * </pre>
   *
   * <code>bool partial_report = 3;</code>
   *
   * @return The partialReport.
   */
  @java.lang.Override
  public boolean getPartialReport() {
    return partialReport_;
  }

  public static final int FILE_ERRORS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.migrationcenter.v1.ImportError> fileErrors_;
  /**
   *
   *
   * <pre>
   * List of file level errors.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.migrationcenter.v1.ImportError> getFileErrorsList() {
    return fileErrors_;
  }
  /**
   *
   *
   * <pre>
   * List of file level errors.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder>
      getFileErrorsOrBuilderList() {
    return fileErrors_;
  }
  /**
   *
   *
   * <pre>
   * List of file level errors.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
   */
  @java.lang.Override
  public int getFileErrorsCount() {
    return fileErrors_.size();
  }
  /**
   *
   *
   * <pre>
   * List of file level errors.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ImportError getFileErrors(int index) {
    return fileErrors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of file level errors.
   * </pre>
   *
   * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder getFileErrorsOrBuilder(
      int index) {
    return fileErrors_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fileName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fileName_);
    }
    for (int i = 0; i < rowErrors_.size(); i++) {
      output.writeMessage(2, rowErrors_.get(i));
    }
    if (partialReport_ != false) {
      output.writeBool(3, partialReport_);
    }
    for (int i = 0; i < fileErrors_.size(); i++) {
      output.writeMessage(4, fileErrors_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fileName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, fileName_);
    }
    for (int i = 0; i < rowErrors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, rowErrors_.get(i));
    }
    if (partialReport_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, partialReport_);
    }
    for (int i = 0; i < fileErrors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, fileErrors_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.FileValidationReport)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.FileValidationReport other =
        (com.google.cloud.migrationcenter.v1.FileValidationReport) obj;

    if (!getFileName().equals(other.getFileName())) return false;
    if (!getRowErrorsList().equals(other.getRowErrorsList())) return false;
    if (getPartialReport() != other.getPartialReport()) return false;
    if (!getFileErrorsList().equals(other.getFileErrorsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FILE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getFileName().hashCode();
    if (getRowErrorsCount() > 0) {
      hash = (37 * hash) + ROW_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getRowErrorsList().hashCode();
    }
    hash = (37 * hash) + PARTIAL_REPORT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPartialReport());
    if (getFileErrorsCount() > 0) {
      hash = (37 * hash) + FILE_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getFileErrorsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.FileValidationReport parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.FileValidationReport parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.FileValidationReport parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.FileValidationReport parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.FileValidationReport parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.FileValidationReport parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.FileValidationReport parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.FileValidationReport parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.FileValidationReport parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.FileValidationReport parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.FileValidationReport parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.FileValidationReport parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.migrationcenter.v1.FileValidationReport prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A resource that aggregates the validation errors found in an import job file.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.FileValidationReport}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.FileValidationReport)
      com.google.cloud.migrationcenter.v1.FileValidationReportOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_FileValidationReport_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_FileValidationReport_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.FileValidationReport.class,
              com.google.cloud.migrationcenter.v1.FileValidationReport.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.FileValidationReport.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      fileName_ = "";
      if (rowErrorsBuilder_ == null) {
        rowErrors_ = java.util.Collections.emptyList();
      } else {
        rowErrors_ = null;
        rowErrorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      partialReport_ = false;
      if (fileErrorsBuilder_ == null) {
        fileErrors_ = java.util.Collections.emptyList();
      } else {
        fileErrors_ = null;
        fileErrorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_FileValidationReport_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.FileValidationReport getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.FileValidationReport.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.FileValidationReport build() {
      com.google.cloud.migrationcenter.v1.FileValidationReport result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.FileValidationReport buildPartial() {
      com.google.cloud.migrationcenter.v1.FileValidationReport result =
          new com.google.cloud.migrationcenter.v1.FileValidationReport(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.migrationcenter.v1.FileValidationReport result) {
      if (rowErrorsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          rowErrors_ = java.util.Collections.unmodifiableList(rowErrors_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.rowErrors_ = rowErrors_;
      } else {
        result.rowErrors_ = rowErrorsBuilder_.build();
      }
      if (fileErrorsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          fileErrors_ = java.util.Collections.unmodifiableList(fileErrors_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.fileErrors_ = fileErrors_;
      } else {
        result.fileErrors_ = fileErrorsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.FileValidationReport result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.fileName_ = fileName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.partialReport_ = partialReport_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.FileValidationReport) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.FileValidationReport) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.FileValidationReport other) {
      if (other == com.google.cloud.migrationcenter.v1.FileValidationReport.getDefaultInstance())
        return this;
      if (!other.getFileName().isEmpty()) {
        fileName_ = other.fileName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (rowErrorsBuilder_ == null) {
        if (!other.rowErrors_.isEmpty()) {
          if (rowErrors_.isEmpty()) {
            rowErrors_ = other.rowErrors_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureRowErrorsIsMutable();
            rowErrors_.addAll(other.rowErrors_);
          }
          onChanged();
        }
      } else {
        if (!other.rowErrors_.isEmpty()) {
          if (rowErrorsBuilder_.isEmpty()) {
            rowErrorsBuilder_.dispose();
            rowErrorsBuilder_ = null;
            rowErrors_ = other.rowErrors_;
            bitField0_ = (bitField0_ & ~0x00000002);
            rowErrorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRowErrorsFieldBuilder()
                    : null;
          } else {
            rowErrorsBuilder_.addAllMessages(other.rowErrors_);
          }
        }
      }
      if (other.getPartialReport() != false) {
        setPartialReport(other.getPartialReport());
      }
      if (fileErrorsBuilder_ == null) {
        if (!other.fileErrors_.isEmpty()) {
          if (fileErrors_.isEmpty()) {
            fileErrors_ = other.fileErrors_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureFileErrorsIsMutable();
            fileErrors_.addAll(other.fileErrors_);
          }
          onChanged();
        }
      } else {
        if (!other.fileErrors_.isEmpty()) {
          if (fileErrorsBuilder_.isEmpty()) {
            fileErrorsBuilder_.dispose();
            fileErrorsBuilder_ = null;
            fileErrors_ = other.fileErrors_;
            bitField0_ = (bitField0_ & ~0x00000008);
            fileErrorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFileErrorsFieldBuilder()
                    : null;
          } else {
            fileErrorsBuilder_.addAllMessages(other.fileErrors_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                fileName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.migrationcenter.v1.ImportRowError m =
                    input.readMessage(
                        com.google.cloud.migrationcenter.v1.ImportRowError.parser(),
                        extensionRegistry);
                if (rowErrorsBuilder_ == null) {
                  ensureRowErrorsIsMutable();
                  rowErrors_.add(m);
                } else {
                  rowErrorsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                partialReport_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.cloud.migrationcenter.v1.ImportError m =
                    input.readMessage(
                        com.google.cloud.migrationcenter.v1.ImportError.parser(),
                        extensionRegistry);
                if (fileErrorsBuilder_ == null) {
                  ensureFileErrorsIsMutable();
                  fileErrors_.add(m);
                } else {
                  fileErrorsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object fileName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the file.
     * </pre>
     *
     * <code>string file_name = 1;</code>
     *
     * @return The fileName.
     */
    public java.lang.String getFileName() {
      java.lang.Object ref = fileName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fileName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the file.
     * </pre>
     *
     * <code>string file_name = 1;</code>
     *
     * @return The bytes for fileName.
     */
    public com.google.protobuf.ByteString getFileNameBytes() {
      java.lang.Object ref = fileName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fileName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the file.
     * </pre>
     *
     * <code>string file_name = 1;</code>
     *
     * @param value The fileName to set.
     * @return This builder for chaining.
     */
    public Builder setFileName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fileName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the file.
     * </pre>
     *
     * <code>string file_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFileName() {
      fileName_ = getDefaultInstance().getFileName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the file.
     * </pre>
     *
     * <code>string file_name = 1;</code>
     *
     * @param value The bytes for fileName to set.
     * @return This builder for chaining.
     */
    public Builder setFileNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fileName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.migrationcenter.v1.ImportRowError> rowErrors_ =
        java.util.Collections.emptyList();

    private void ensureRowErrorsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        rowErrors_ =
            new java.util.ArrayList<com.google.cloud.migrationcenter.v1.ImportRowError>(rowErrors_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ImportRowError,
            com.google.cloud.migrationcenter.v1.ImportRowError.Builder,
            com.google.cloud.migrationcenter.v1.ImportRowErrorOrBuilder>
        rowErrorsBuilder_;

    /**
     *
     *
     * <pre>
     * Partial list of rows that encountered validation error.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.ImportRowError> getRowErrorsList() {
      if (rowErrorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rowErrors_);
      } else {
        return rowErrorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Partial list of rows that encountered validation error.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
     */
    public int getRowErrorsCount() {
      if (rowErrorsBuilder_ == null) {
        return rowErrors_.size();
      } else {
        return rowErrorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Partial list of rows that encountered validation error.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportRowError getRowErrors(int index) {
      if (rowErrorsBuilder_ == null) {
        return rowErrors_.get(index);
      } else {
        return rowErrorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Partial list of rows that encountered validation error.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
     */
    public Builder setRowErrors(
        int index, com.google.cloud.migrationcenter.v1.ImportRowError value) {
      if (rowErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowErrorsIsMutable();
        rowErrors_.set(index, value);
        onChanged();
      } else {
        rowErrorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial list of rows that encountered validation error.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
     */
    public Builder setRowErrors(
        int index, com.google.cloud.migrationcenter.v1.ImportRowError.Builder builderForValue) {
      if (rowErrorsBuilder_ == null) {
        ensureRowErrorsIsMutable();
        rowErrors_.set(index, builderForValue.build());
        onChanged();
      } else {
        rowErrorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial list of rows that encountered validation error.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
     */
    public Builder addRowErrors(com.google.cloud.migrationcenter.v1.ImportRowError value) {
      if (rowErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowErrorsIsMutable();
        rowErrors_.add(value);
        onChanged();
      } else {
        rowErrorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial list of rows that encountered validation error.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
     */
    public Builder addRowErrors(
        int index, com.google.cloud.migrationcenter.v1.ImportRowError value) {
      if (rowErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowErrorsIsMutable();
        rowErrors_.add(index, value);
        onChanged();
      } else {
        rowErrorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial list of rows that encountered validation error.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
     */
    public Builder addRowErrors(
        com.google.cloud.migrationcenter.v1.ImportRowError.Builder builderForValue) {
      if (rowErrorsBuilder_ == null) {
        ensureRowErrorsIsMutable();
        rowErrors_.add(builderForValue.build());
        onChanged();
      } else {
        rowErrorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial list of rows that encountered validation error.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
     */
    public Builder addRowErrors(
        int index, com.google.cloud.migrationcenter.v1.ImportRowError.Builder builderForValue) {
      if (rowErrorsBuilder_ == null) {
        ensureRowErrorsIsMutable();
        rowErrors_.add(index, builderForValue.build());
        onChanged();
      } else {
        rowErrorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial list of rows that encountered validation error.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
     */
    public Builder addAllRowErrors(
        java.lang.Iterable<? extends com.google.cloud.migrationcenter.v1.ImportRowError> values) {
      if (rowErrorsBuilder_ == null) {
        ensureRowErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rowErrors_);
        onChanged();
      } else {
        rowErrorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial list of rows that encountered validation error.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
     */
    public Builder clearRowErrors() {
      if (rowErrorsBuilder_ == null) {
        rowErrors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        rowErrorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial list of rows that encountered validation error.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
     */
    public Builder removeRowErrors(int index) {
      if (rowErrorsBuilder_ == null) {
        ensureRowErrorsIsMutable();
        rowErrors_.remove(index);
        onChanged();
      } else {
        rowErrorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial list of rows that encountered validation error.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportRowError.Builder getRowErrorsBuilder(
        int index) {
      return getRowErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Partial list of rows that encountered validation error.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportRowErrorOrBuilder getRowErrorsOrBuilder(
        int index) {
      if (rowErrorsBuilder_ == null) {
        return rowErrors_.get(index);
      } else {
        return rowErrorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Partial list of rows that encountered validation error.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.migrationcenter.v1.ImportRowErrorOrBuilder>
        getRowErrorsOrBuilderList() {
      if (rowErrorsBuilder_ != null) {
        return rowErrorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rowErrors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Partial list of rows that encountered validation error.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportRowError.Builder addRowErrorsBuilder() {
      return getRowErrorsFieldBuilder()
          .addBuilder(com.google.cloud.migrationcenter.v1.ImportRowError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Partial list of rows that encountered validation error.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportRowError.Builder addRowErrorsBuilder(
        int index) {
      return getRowErrorsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.migrationcenter.v1.ImportRowError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Partial list of rows that encountered validation error.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportRowError row_errors = 2;</code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.ImportRowError.Builder>
        getRowErrorsBuilderList() {
      return getRowErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ImportRowError,
            com.google.cloud.migrationcenter.v1.ImportRowError.Builder,
            com.google.cloud.migrationcenter.v1.ImportRowErrorOrBuilder>
        getRowErrorsFieldBuilder() {
      if (rowErrorsBuilder_ == null) {
        rowErrorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.ImportRowError,
                com.google.cloud.migrationcenter.v1.ImportRowError.Builder,
                com.google.cloud.migrationcenter.v1.ImportRowErrorOrBuilder>(
                rowErrors_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        rowErrors_ = null;
      }
      return rowErrorsBuilder_;
    }

    private boolean partialReport_;
    /**
     *
     *
     * <pre>
     * Flag indicating that processing was aborted due to maximum number of
     * errors.
     * </pre>
     *
     * <code>bool partial_report = 3;</code>
     *
     * @return The partialReport.
     */
    @java.lang.Override
    public boolean getPartialReport() {
      return partialReport_;
    }
    /**
     *
     *
     * <pre>
     * Flag indicating that processing was aborted due to maximum number of
     * errors.
     * </pre>
     *
     * <code>bool partial_report = 3;</code>
     *
     * @param value The partialReport to set.
     * @return This builder for chaining.
     */
    public Builder setPartialReport(boolean value) {

      partialReport_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Flag indicating that processing was aborted due to maximum number of
     * errors.
     * </pre>
     *
     * <code>bool partial_report = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPartialReport() {
      bitField0_ = (bitField0_ & ~0x00000004);
      partialReport_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.migrationcenter.v1.ImportError> fileErrors_ =
        java.util.Collections.emptyList();

    private void ensureFileErrorsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        fileErrors_ =
            new java.util.ArrayList<com.google.cloud.migrationcenter.v1.ImportError>(fileErrors_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ImportError,
            com.google.cloud.migrationcenter.v1.ImportError.Builder,
            com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder>
        fileErrorsBuilder_;

    /**
     *
     *
     * <pre>
     * List of file level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.ImportError> getFileErrorsList() {
      if (fileErrorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fileErrors_);
      } else {
        return fileErrorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of file level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
     */
    public int getFileErrorsCount() {
      if (fileErrorsBuilder_ == null) {
        return fileErrors_.size();
      } else {
        return fileErrorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of file level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportError getFileErrors(int index) {
      if (fileErrorsBuilder_ == null) {
        return fileErrors_.get(index);
      } else {
        return fileErrorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of file level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
     */
    public Builder setFileErrors(int index, com.google.cloud.migrationcenter.v1.ImportError value) {
      if (fileErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFileErrorsIsMutable();
        fileErrors_.set(index, value);
        onChanged();
      } else {
        fileErrorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of file level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
     */
    public Builder setFileErrors(
        int index, com.google.cloud.migrationcenter.v1.ImportError.Builder builderForValue) {
      if (fileErrorsBuilder_ == null) {
        ensureFileErrorsIsMutable();
        fileErrors_.set(index, builderForValue.build());
        onChanged();
      } else {
        fileErrorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of file level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
     */
    public Builder addFileErrors(com.google.cloud.migrationcenter.v1.ImportError value) {
      if (fileErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFileErrorsIsMutable();
        fileErrors_.add(value);
        onChanged();
      } else {
        fileErrorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of file level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
     */
    public Builder addFileErrors(int index, com.google.cloud.migrationcenter.v1.ImportError value) {
      if (fileErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFileErrorsIsMutable();
        fileErrors_.add(index, value);
        onChanged();
      } else {
        fileErrorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of file level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
     */
    public Builder addFileErrors(
        com.google.cloud.migrationcenter.v1.ImportError.Builder builderForValue) {
      if (fileErrorsBuilder_ == null) {
        ensureFileErrorsIsMutable();
        fileErrors_.add(builderForValue.build());
        onChanged();
      } else {
        fileErrorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of file level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
     */
    public Builder addFileErrors(
        int index, com.google.cloud.migrationcenter.v1.ImportError.Builder builderForValue) {
      if (fileErrorsBuilder_ == null) {
        ensureFileErrorsIsMutable();
        fileErrors_.add(index, builderForValue.build());
        onChanged();
      } else {
        fileErrorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of file level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
     */
    public Builder addAllFileErrors(
        java.lang.Iterable<? extends com.google.cloud.migrationcenter.v1.ImportError> values) {
      if (fileErrorsBuilder_ == null) {
        ensureFileErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fileErrors_);
        onChanged();
      } else {
        fileErrorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of file level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
     */
    public Builder clearFileErrors() {
      if (fileErrorsBuilder_ == null) {
        fileErrors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        fileErrorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of file level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
     */
    public Builder removeFileErrors(int index) {
      if (fileErrorsBuilder_ == null) {
        ensureFileErrorsIsMutable();
        fileErrors_.remove(index);
        onChanged();
      } else {
        fileErrorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of file level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportError.Builder getFileErrorsBuilder(int index) {
      return getFileErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of file level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder getFileErrorsOrBuilder(
        int index) {
      if (fileErrorsBuilder_ == null) {
        return fileErrors_.get(index);
      } else {
        return fileErrorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of file level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder>
        getFileErrorsOrBuilderList() {
      if (fileErrorsBuilder_ != null) {
        return fileErrorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fileErrors_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of file level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportError.Builder addFileErrorsBuilder() {
      return getFileErrorsFieldBuilder()
          .addBuilder(com.google.cloud.migrationcenter.v1.ImportError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of file level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.ImportError.Builder addFileErrorsBuilder(int index) {
      return getFileErrorsFieldBuilder()
          .addBuilder(index, com.google.cloud.migrationcenter.v1.ImportError.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of file level errors.
     * </pre>
     *
     * <code>repeated .google.cloud.migrationcenter.v1.ImportError file_errors = 4;</code>
     */
    public java.util.List<com.google.cloud.migrationcenter.v1.ImportError.Builder>
        getFileErrorsBuilderList() {
      return getFileErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.ImportError,
            com.google.cloud.migrationcenter.v1.ImportError.Builder,
            com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder>
        getFileErrorsFieldBuilder() {
      if (fileErrorsBuilder_ == null) {
        fileErrorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.ImportError,
                com.google.cloud.migrationcenter.v1.ImportError.Builder,
                com.google.cloud.migrationcenter.v1.ImportErrorOrBuilder>(
                fileErrors_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        fileErrors_ = null;
      }
      return fileErrorsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.FileValidationReport)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.FileValidationReport)
  private static final com.google.cloud.migrationcenter.v1.FileValidationReport DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.FileValidationReport();
  }

  public static com.google.cloud.migrationcenter.v1.FileValidationReport getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FileValidationReport> PARSER =
      new com.google.protobuf.AbstractParser<FileValidationReport>() {
        @java.lang.Override
        public FileValidationReport parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FileValidationReport> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FileValidationReport> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.FileValidationReport getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
