/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * Guest OS config information.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.GuestConfigDetails}
 */
public final class GuestConfigDetails extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.GuestConfigDetails)
    GuestConfigDetailsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GuestConfigDetails.newBuilder() to construct.
  private GuestConfigDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GuestConfigDetails() {
    issue_ = "";
    selinuxMode_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GuestConfigDetails();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_GuestConfigDetails_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_GuestConfigDetails_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.GuestConfigDetails.class,
            com.google.cloud.migrationcenter.v1.GuestConfigDetails.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Security-Enhanced Linux (SELinux) mode.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode}
   */
  public enum SeLinuxMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * SELinux mode unknown or unspecified.
     * </pre>
     *
     * <code>SE_LINUX_MODE_UNSPECIFIED = 0;</code>
     */
    SE_LINUX_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * SELinux is disabled.
     * </pre>
     *
     * <code>SE_LINUX_MODE_DISABLED = 1;</code>
     */
    SE_LINUX_MODE_DISABLED(1),
    /**
     *
     *
     * <pre>
     * SELinux permissive mode.
     * </pre>
     *
     * <code>SE_LINUX_MODE_PERMISSIVE = 2;</code>
     */
    SE_LINUX_MODE_PERMISSIVE(2),
    /**
     *
     *
     * <pre>
     * SELinux enforcing mode.
     * </pre>
     *
     * <code>SE_LINUX_MODE_ENFORCING = 3;</code>
     */
    SE_LINUX_MODE_ENFORCING(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * SELinux mode unknown or unspecified.
     * </pre>
     *
     * <code>SE_LINUX_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int SE_LINUX_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * SELinux is disabled.
     * </pre>
     *
     * <code>SE_LINUX_MODE_DISABLED = 1;</code>
     */
    public static final int SE_LINUX_MODE_DISABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * SELinux permissive mode.
     * </pre>
     *
     * <code>SE_LINUX_MODE_PERMISSIVE = 2;</code>
     */
    public static final int SE_LINUX_MODE_PERMISSIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * SELinux enforcing mode.
     * </pre>
     *
     * <code>SE_LINUX_MODE_ENFORCING = 3;</code>
     */
    public static final int SE_LINUX_MODE_ENFORCING_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SeLinuxMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SeLinuxMode forNumber(int value) {
      switch (value) {
        case 0:
          return SE_LINUX_MODE_UNSPECIFIED;
        case 1:
          return SE_LINUX_MODE_DISABLED;
        case 2:
          return SE_LINUX_MODE_PERMISSIVE;
        case 3:
          return SE_LINUX_MODE_ENFORCING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SeLinuxMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SeLinuxMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SeLinuxMode>() {
          public SeLinuxMode findValueByNumber(int number) {
            return SeLinuxMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.GuestConfigDetails.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final SeLinuxMode[] VALUES = values();

    public static SeLinuxMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SeLinuxMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode)
  }

  public static final int ISSUE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object issue_ = "";
  /**
   *
   *
   * <pre>
   * OS issue (typically /etc/issue in Linux).
   * </pre>
   *
   * <code>string issue = 1;</code>
   *
   * @return The issue.
   */
  @java.lang.Override
  public java.lang.String getIssue() {
    java.lang.Object ref = issue_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      issue_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * OS issue (typically /etc/issue in Linux).
   * </pre>
   *
   * <code>string issue = 1;</code>
   *
   * @return The bytes for issue.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIssueBytes() {
    java.lang.Object ref = issue_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      issue_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FSTAB_FIELD_NUMBER = 2;
  private com.google.cloud.migrationcenter.v1.FstabEntryList fstab_;
  /**
   *
   *
   * <pre>
   * Mount list (Linux fstab).
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.FstabEntryList fstab = 2;</code>
   *
   * @return Whether the fstab field is set.
   */
  @java.lang.Override
  public boolean hasFstab() {
    return fstab_ != null;
  }
  /**
   *
   *
   * <pre>
   * Mount list (Linux fstab).
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.FstabEntryList fstab = 2;</code>
   *
   * @return The fstab.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.FstabEntryList getFstab() {
    return fstab_ == null
        ? com.google.cloud.migrationcenter.v1.FstabEntryList.getDefaultInstance()
        : fstab_;
  }
  /**
   *
   *
   * <pre>
   * Mount list (Linux fstab).
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.FstabEntryList fstab = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.FstabEntryListOrBuilder getFstabOrBuilder() {
    return fstab_ == null
        ? com.google.cloud.migrationcenter.v1.FstabEntryList.getDefaultInstance()
        : fstab_;
  }

  public static final int HOSTS_FIELD_NUMBER = 3;
  private com.google.cloud.migrationcenter.v1.HostsEntryList hosts_;
  /**
   *
   *
   * <pre>
   * Hosts file (/etc/hosts).
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.HostsEntryList hosts = 3;</code>
   *
   * @return Whether the hosts field is set.
   */
  @java.lang.Override
  public boolean hasHosts() {
    return hosts_ != null;
  }
  /**
   *
   *
   * <pre>
   * Hosts file (/etc/hosts).
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.HostsEntryList hosts = 3;</code>
   *
   * @return The hosts.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.HostsEntryList getHosts() {
    return hosts_ == null
        ? com.google.cloud.migrationcenter.v1.HostsEntryList.getDefaultInstance()
        : hosts_;
  }
  /**
   *
   *
   * <pre>
   * Hosts file (/etc/hosts).
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.HostsEntryList hosts = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.HostsEntryListOrBuilder getHostsOrBuilder() {
    return hosts_ == null
        ? com.google.cloud.migrationcenter.v1.HostsEntryList.getDefaultInstance()
        : hosts_;
  }

  public static final int NFS_EXPORTS_FIELD_NUMBER = 4;
  private com.google.cloud.migrationcenter.v1.NfsExportList nfsExports_;
  /**
   *
   *
   * <pre>
   * NFS exports.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.NfsExportList nfs_exports = 4;</code>
   *
   * @return Whether the nfsExports field is set.
   */
  @java.lang.Override
  public boolean hasNfsExports() {
    return nfsExports_ != null;
  }
  /**
   *
   *
   * <pre>
   * NFS exports.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.NfsExportList nfs_exports = 4;</code>
   *
   * @return The nfsExports.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.NfsExportList getNfsExports() {
    return nfsExports_ == null
        ? com.google.cloud.migrationcenter.v1.NfsExportList.getDefaultInstance()
        : nfsExports_;
  }
  /**
   *
   *
   * <pre>
   * NFS exports.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.NfsExportList nfs_exports = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.NfsExportListOrBuilder getNfsExportsOrBuilder() {
    return nfsExports_ == null
        ? com.google.cloud.migrationcenter.v1.NfsExportList.getDefaultInstance()
        : nfsExports_;
  }

  public static final int SELINUX_MODE_FIELD_NUMBER = 5;
  private int selinuxMode_ = 0;
  /**
   *
   *
   * <pre>
   * Security-Enhanced Linux (SELinux) mode.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode selinux_mode = 5;</code>
   *
   * @return The enum numeric value on the wire for selinuxMode.
   */
  @java.lang.Override
  public int getSelinuxModeValue() {
    return selinuxMode_;
  }
  /**
   *
   *
   * <pre>
   * Security-Enhanced Linux (SELinux) mode.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode selinux_mode = 5;</code>
   *
   * @return The selinuxMode.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode getSelinuxMode() {
    com.google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode result =
        com.google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode.forNumber(selinuxMode_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issue_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, issue_);
    }
    if (fstab_ != null) {
      output.writeMessage(2, getFstab());
    }
    if (hosts_ != null) {
      output.writeMessage(3, getHosts());
    }
    if (nfsExports_ != null) {
      output.writeMessage(4, getNfsExports());
    }
    if (selinuxMode_
        != com.google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode
            .SE_LINUX_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, selinuxMode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issue_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, issue_);
    }
    if (fstab_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getFstab());
    }
    if (hosts_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getHosts());
    }
    if (nfsExports_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getNfsExports());
    }
    if (selinuxMode_
        != com.google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode
            .SE_LINUX_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, selinuxMode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.GuestConfigDetails)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.GuestConfigDetails other =
        (com.google.cloud.migrationcenter.v1.GuestConfigDetails) obj;

    if (!getIssue().equals(other.getIssue())) return false;
    if (hasFstab() != other.hasFstab()) return false;
    if (hasFstab()) {
      if (!getFstab().equals(other.getFstab())) return false;
    }
    if (hasHosts() != other.hasHosts()) return false;
    if (hasHosts()) {
      if (!getHosts().equals(other.getHosts())) return false;
    }
    if (hasNfsExports() != other.hasNfsExports()) return false;
    if (hasNfsExports()) {
      if (!getNfsExports().equals(other.getNfsExports())) return false;
    }
    if (selinuxMode_ != other.selinuxMode_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ISSUE_FIELD_NUMBER;
    hash = (53 * hash) + getIssue().hashCode();
    if (hasFstab()) {
      hash = (37 * hash) + FSTAB_FIELD_NUMBER;
      hash = (53 * hash) + getFstab().hashCode();
    }
    if (hasHosts()) {
      hash = (37 * hash) + HOSTS_FIELD_NUMBER;
      hash = (53 * hash) + getHosts().hashCode();
    }
    if (hasNfsExports()) {
      hash = (37 * hash) + NFS_EXPORTS_FIELD_NUMBER;
      hash = (53 * hash) + getNfsExports().hashCode();
    }
    hash = (37 * hash) + SELINUX_MODE_FIELD_NUMBER;
    hash = (53 * hash) + selinuxMode_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.GuestConfigDetails parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.GuestConfigDetails parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.GuestConfigDetails parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.GuestConfigDetails parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.GuestConfigDetails parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.GuestConfigDetails parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.GuestConfigDetails parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.GuestConfigDetails parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.GuestConfigDetails parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.GuestConfigDetails parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.GuestConfigDetails parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.GuestConfigDetails parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.migrationcenter.v1.GuestConfigDetails prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Guest OS config information.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.GuestConfigDetails}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.GuestConfigDetails)
      com.google.cloud.migrationcenter.v1.GuestConfigDetailsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_GuestConfigDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_GuestConfigDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.GuestConfigDetails.class,
              com.google.cloud.migrationcenter.v1.GuestConfigDetails.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.GuestConfigDetails.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      issue_ = "";
      fstab_ = null;
      if (fstabBuilder_ != null) {
        fstabBuilder_.dispose();
        fstabBuilder_ = null;
      }
      hosts_ = null;
      if (hostsBuilder_ != null) {
        hostsBuilder_.dispose();
        hostsBuilder_ = null;
      }
      nfsExports_ = null;
      if (nfsExportsBuilder_ != null) {
        nfsExportsBuilder_.dispose();
        nfsExportsBuilder_ = null;
      }
      selinuxMode_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_GuestConfigDetails_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.GuestConfigDetails getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.GuestConfigDetails.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.GuestConfigDetails build() {
      com.google.cloud.migrationcenter.v1.GuestConfigDetails result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.GuestConfigDetails buildPartial() {
      com.google.cloud.migrationcenter.v1.GuestConfigDetails result =
          new com.google.cloud.migrationcenter.v1.GuestConfigDetails(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.GuestConfigDetails result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.issue_ = issue_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.fstab_ = fstabBuilder_ == null ? fstab_ : fstabBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.hosts_ = hostsBuilder_ == null ? hosts_ : hostsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.nfsExports_ = nfsExportsBuilder_ == null ? nfsExports_ : nfsExportsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.selinuxMode_ = selinuxMode_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.GuestConfigDetails) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.GuestConfigDetails) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.GuestConfigDetails other) {
      if (other == com.google.cloud.migrationcenter.v1.GuestConfigDetails.getDefaultInstance())
        return this;
      if (!other.getIssue().isEmpty()) {
        issue_ = other.issue_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasFstab()) {
        mergeFstab(other.getFstab());
      }
      if (other.hasHosts()) {
        mergeHosts(other.getHosts());
      }
      if (other.hasNfsExports()) {
        mergeNfsExports(other.getNfsExports());
      }
      if (other.selinuxMode_ != 0) {
        setSelinuxModeValue(other.getSelinuxModeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                issue_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getFstabFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getHostsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getNfsExportsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                selinuxMode_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object issue_ = "";
    /**
     *
     *
     * <pre>
     * OS issue (typically /etc/issue in Linux).
     * </pre>
     *
     * <code>string issue = 1;</code>
     *
     * @return The issue.
     */
    public java.lang.String getIssue() {
      java.lang.Object ref = issue_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        issue_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * OS issue (typically /etc/issue in Linux).
     * </pre>
     *
     * <code>string issue = 1;</code>
     *
     * @return The bytes for issue.
     */
    public com.google.protobuf.ByteString getIssueBytes() {
      java.lang.Object ref = issue_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        issue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * OS issue (typically /etc/issue in Linux).
     * </pre>
     *
     * <code>string issue = 1;</code>
     *
     * @param value The issue to set.
     * @return This builder for chaining.
     */
    public Builder setIssue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      issue_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OS issue (typically /etc/issue in Linux).
     * </pre>
     *
     * <code>string issue = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIssue() {
      issue_ = getDefaultInstance().getIssue();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OS issue (typically /etc/issue in Linux).
     * </pre>
     *
     * <code>string issue = 1;</code>
     *
     * @param value The bytes for issue to set.
     * @return This builder for chaining.
     */
    public Builder setIssueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      issue_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.migrationcenter.v1.FstabEntryList fstab_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.FstabEntryList,
            com.google.cloud.migrationcenter.v1.FstabEntryList.Builder,
            com.google.cloud.migrationcenter.v1.FstabEntryListOrBuilder>
        fstabBuilder_;
    /**
     *
     *
     * <pre>
     * Mount list (Linux fstab).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.FstabEntryList fstab = 2;</code>
     *
     * @return Whether the fstab field is set.
     */
    public boolean hasFstab() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Mount list (Linux fstab).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.FstabEntryList fstab = 2;</code>
     *
     * @return The fstab.
     */
    public com.google.cloud.migrationcenter.v1.FstabEntryList getFstab() {
      if (fstabBuilder_ == null) {
        return fstab_ == null
            ? com.google.cloud.migrationcenter.v1.FstabEntryList.getDefaultInstance()
            : fstab_;
      } else {
        return fstabBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Mount list (Linux fstab).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.FstabEntryList fstab = 2;</code>
     */
    public Builder setFstab(com.google.cloud.migrationcenter.v1.FstabEntryList value) {
      if (fstabBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fstab_ = value;
      } else {
        fstabBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mount list (Linux fstab).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.FstabEntryList fstab = 2;</code>
     */
    public Builder setFstab(
        com.google.cloud.migrationcenter.v1.FstabEntryList.Builder builderForValue) {
      if (fstabBuilder_ == null) {
        fstab_ = builderForValue.build();
      } else {
        fstabBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mount list (Linux fstab).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.FstabEntryList fstab = 2;</code>
     */
    public Builder mergeFstab(com.google.cloud.migrationcenter.v1.FstabEntryList value) {
      if (fstabBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && fstab_ != null
            && fstab_ != com.google.cloud.migrationcenter.v1.FstabEntryList.getDefaultInstance()) {
          getFstabBuilder().mergeFrom(value);
        } else {
          fstab_ = value;
        }
      } else {
        fstabBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mount list (Linux fstab).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.FstabEntryList fstab = 2;</code>
     */
    public Builder clearFstab() {
      bitField0_ = (bitField0_ & ~0x00000002);
      fstab_ = null;
      if (fstabBuilder_ != null) {
        fstabBuilder_.dispose();
        fstabBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mount list (Linux fstab).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.FstabEntryList fstab = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.FstabEntryList.Builder getFstabBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getFstabFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Mount list (Linux fstab).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.FstabEntryList fstab = 2;</code>
     */
    public com.google.cloud.migrationcenter.v1.FstabEntryListOrBuilder getFstabOrBuilder() {
      if (fstabBuilder_ != null) {
        return fstabBuilder_.getMessageOrBuilder();
      } else {
        return fstab_ == null
            ? com.google.cloud.migrationcenter.v1.FstabEntryList.getDefaultInstance()
            : fstab_;
      }
    }
    /**
     *
     *
     * <pre>
     * Mount list (Linux fstab).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.FstabEntryList fstab = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.FstabEntryList,
            com.google.cloud.migrationcenter.v1.FstabEntryList.Builder,
            com.google.cloud.migrationcenter.v1.FstabEntryListOrBuilder>
        getFstabFieldBuilder() {
      if (fstabBuilder_ == null) {
        fstabBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.FstabEntryList,
                com.google.cloud.migrationcenter.v1.FstabEntryList.Builder,
                com.google.cloud.migrationcenter.v1.FstabEntryListOrBuilder>(
                getFstab(), getParentForChildren(), isClean());
        fstab_ = null;
      }
      return fstabBuilder_;
    }

    private com.google.cloud.migrationcenter.v1.HostsEntryList hosts_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.HostsEntryList,
            com.google.cloud.migrationcenter.v1.HostsEntryList.Builder,
            com.google.cloud.migrationcenter.v1.HostsEntryListOrBuilder>
        hostsBuilder_;
    /**
     *
     *
     * <pre>
     * Hosts file (/etc/hosts).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.HostsEntryList hosts = 3;</code>
     *
     * @return Whether the hosts field is set.
     */
    public boolean hasHosts() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Hosts file (/etc/hosts).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.HostsEntryList hosts = 3;</code>
     *
     * @return The hosts.
     */
    public com.google.cloud.migrationcenter.v1.HostsEntryList getHosts() {
      if (hostsBuilder_ == null) {
        return hosts_ == null
            ? com.google.cloud.migrationcenter.v1.HostsEntryList.getDefaultInstance()
            : hosts_;
      } else {
        return hostsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Hosts file (/etc/hosts).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.HostsEntryList hosts = 3;</code>
     */
    public Builder setHosts(com.google.cloud.migrationcenter.v1.HostsEntryList value) {
      if (hostsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        hosts_ = value;
      } else {
        hostsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hosts file (/etc/hosts).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.HostsEntryList hosts = 3;</code>
     */
    public Builder setHosts(
        com.google.cloud.migrationcenter.v1.HostsEntryList.Builder builderForValue) {
      if (hostsBuilder_ == null) {
        hosts_ = builderForValue.build();
      } else {
        hostsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hosts file (/etc/hosts).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.HostsEntryList hosts = 3;</code>
     */
    public Builder mergeHosts(com.google.cloud.migrationcenter.v1.HostsEntryList value) {
      if (hostsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && hosts_ != null
            && hosts_ != com.google.cloud.migrationcenter.v1.HostsEntryList.getDefaultInstance()) {
          getHostsBuilder().mergeFrom(value);
        } else {
          hosts_ = value;
        }
      } else {
        hostsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hosts file (/etc/hosts).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.HostsEntryList hosts = 3;</code>
     */
    public Builder clearHosts() {
      bitField0_ = (bitField0_ & ~0x00000004);
      hosts_ = null;
      if (hostsBuilder_ != null) {
        hostsBuilder_.dispose();
        hostsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Hosts file (/etc/hosts).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.HostsEntryList hosts = 3;</code>
     */
    public com.google.cloud.migrationcenter.v1.HostsEntryList.Builder getHostsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getHostsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Hosts file (/etc/hosts).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.HostsEntryList hosts = 3;</code>
     */
    public com.google.cloud.migrationcenter.v1.HostsEntryListOrBuilder getHostsOrBuilder() {
      if (hostsBuilder_ != null) {
        return hostsBuilder_.getMessageOrBuilder();
      } else {
        return hosts_ == null
            ? com.google.cloud.migrationcenter.v1.HostsEntryList.getDefaultInstance()
            : hosts_;
      }
    }
    /**
     *
     *
     * <pre>
     * Hosts file (/etc/hosts).
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.HostsEntryList hosts = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.HostsEntryList,
            com.google.cloud.migrationcenter.v1.HostsEntryList.Builder,
            com.google.cloud.migrationcenter.v1.HostsEntryListOrBuilder>
        getHostsFieldBuilder() {
      if (hostsBuilder_ == null) {
        hostsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.HostsEntryList,
                com.google.cloud.migrationcenter.v1.HostsEntryList.Builder,
                com.google.cloud.migrationcenter.v1.HostsEntryListOrBuilder>(
                getHosts(), getParentForChildren(), isClean());
        hosts_ = null;
      }
      return hostsBuilder_;
    }

    private com.google.cloud.migrationcenter.v1.NfsExportList nfsExports_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.NfsExportList,
            com.google.cloud.migrationcenter.v1.NfsExportList.Builder,
            com.google.cloud.migrationcenter.v1.NfsExportListOrBuilder>
        nfsExportsBuilder_;
    /**
     *
     *
     * <pre>
     * NFS exports.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NfsExportList nfs_exports = 4;</code>
     *
     * @return Whether the nfsExports field is set.
     */
    public boolean hasNfsExports() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * NFS exports.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NfsExportList nfs_exports = 4;</code>
     *
     * @return The nfsExports.
     */
    public com.google.cloud.migrationcenter.v1.NfsExportList getNfsExports() {
      if (nfsExportsBuilder_ == null) {
        return nfsExports_ == null
            ? com.google.cloud.migrationcenter.v1.NfsExportList.getDefaultInstance()
            : nfsExports_;
      } else {
        return nfsExportsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * NFS exports.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NfsExportList nfs_exports = 4;</code>
     */
    public Builder setNfsExports(com.google.cloud.migrationcenter.v1.NfsExportList value) {
      if (nfsExportsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nfsExports_ = value;
      } else {
        nfsExportsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * NFS exports.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NfsExportList nfs_exports = 4;</code>
     */
    public Builder setNfsExports(
        com.google.cloud.migrationcenter.v1.NfsExportList.Builder builderForValue) {
      if (nfsExportsBuilder_ == null) {
        nfsExports_ = builderForValue.build();
      } else {
        nfsExportsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * NFS exports.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NfsExportList nfs_exports = 4;</code>
     */
    public Builder mergeNfsExports(com.google.cloud.migrationcenter.v1.NfsExportList value) {
      if (nfsExportsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && nfsExports_ != null
            && nfsExports_
                != com.google.cloud.migrationcenter.v1.NfsExportList.getDefaultInstance()) {
          getNfsExportsBuilder().mergeFrom(value);
        } else {
          nfsExports_ = value;
        }
      } else {
        nfsExportsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * NFS exports.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NfsExportList nfs_exports = 4;</code>
     */
    public Builder clearNfsExports() {
      bitField0_ = (bitField0_ & ~0x00000008);
      nfsExports_ = null;
      if (nfsExportsBuilder_ != null) {
        nfsExportsBuilder_.dispose();
        nfsExportsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * NFS exports.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NfsExportList nfs_exports = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.NfsExportList.Builder getNfsExportsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getNfsExportsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * NFS exports.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NfsExportList nfs_exports = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.NfsExportListOrBuilder getNfsExportsOrBuilder() {
      if (nfsExportsBuilder_ != null) {
        return nfsExportsBuilder_.getMessageOrBuilder();
      } else {
        return nfsExports_ == null
            ? com.google.cloud.migrationcenter.v1.NfsExportList.getDefaultInstance()
            : nfsExports_;
      }
    }
    /**
     *
     *
     * <pre>
     * NFS exports.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.NfsExportList nfs_exports = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.NfsExportList,
            com.google.cloud.migrationcenter.v1.NfsExportList.Builder,
            com.google.cloud.migrationcenter.v1.NfsExportListOrBuilder>
        getNfsExportsFieldBuilder() {
      if (nfsExportsBuilder_ == null) {
        nfsExportsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.NfsExportList,
                com.google.cloud.migrationcenter.v1.NfsExportList.Builder,
                com.google.cloud.migrationcenter.v1.NfsExportListOrBuilder>(
                getNfsExports(), getParentForChildren(), isClean());
        nfsExports_ = null;
      }
      return nfsExportsBuilder_;
    }

    private int selinuxMode_ = 0;
    /**
     *
     *
     * <pre>
     * Security-Enhanced Linux (SELinux) mode.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode selinux_mode = 5;
     * </code>
     *
     * @return The enum numeric value on the wire for selinuxMode.
     */
    @java.lang.Override
    public int getSelinuxModeValue() {
      return selinuxMode_;
    }
    /**
     *
     *
     * <pre>
     * Security-Enhanced Linux (SELinux) mode.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode selinux_mode = 5;
     * </code>
     *
     * @param value The enum numeric value on the wire for selinuxMode to set.
     * @return This builder for chaining.
     */
    public Builder setSelinuxModeValue(int value) {
      selinuxMode_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Security-Enhanced Linux (SELinux) mode.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode selinux_mode = 5;
     * </code>
     *
     * @return The selinuxMode.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode getSelinuxMode() {
      com.google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode result =
          com.google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode.forNumber(
              selinuxMode_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Security-Enhanced Linux (SELinux) mode.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode selinux_mode = 5;
     * </code>
     *
     * @param value The selinuxMode to set.
     * @return This builder for chaining.
     */
    public Builder setSelinuxMode(
        com.google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      selinuxMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Security-Enhanced Linux (SELinux) mode.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails.SeLinuxMode selinux_mode = 5;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelinuxMode() {
      bitField0_ = (bitField0_ & ~0x00000010);
      selinuxMode_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.GuestConfigDetails)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.GuestConfigDetails)
  private static final com.google.cloud.migrationcenter.v1.GuestConfigDetails DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.GuestConfigDetails();
  }

  public static com.google.cloud.migrationcenter.v1.GuestConfigDetails getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GuestConfigDetails> PARSER =
      new com.google.protobuf.AbstractParser<GuestConfigDetails>() {
        @java.lang.Override
        public GuestConfigDetails parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GuestConfigDetails> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GuestConfigDetails> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.GuestConfigDetails getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
