/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * Information from Guest-level collections.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.GuestOsDetails}
 */
public final class GuestOsDetails extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.GuestOsDetails)
    GuestOsDetailsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GuestOsDetails.newBuilder() to construct.
  private GuestOsDetails(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GuestOsDetails() {
    osName_ = "";
    family_ = 0;
    version_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GuestOsDetails();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_GuestOsDetails_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_GuestOsDetails_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.GuestOsDetails.class,
            com.google.cloud.migrationcenter.v1.GuestOsDetails.Builder.class);
  }

  public static final int OS_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object osName_ = "";
  /**
   *
   *
   * <pre>
   * The name of the operating system.
   * </pre>
   *
   * <code>string os_name = 1;</code>
   *
   * @return The osName.
   */
  @java.lang.Override
  public java.lang.String getOsName() {
    java.lang.Object ref = osName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      osName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the operating system.
   * </pre>
   *
   * <code>string os_name = 1;</code>
   *
   * @return The bytes for osName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOsNameBytes() {
    java.lang.Object ref = osName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      osName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FAMILY_FIELD_NUMBER = 2;
  private int family_ = 0;
  /**
   *
   *
   * <pre>
   * What family the OS belong to, if known.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.OperatingSystemFamily family = 2;</code>
   *
   * @return The enum numeric value on the wire for family.
   */
  @java.lang.Override
  public int getFamilyValue() {
    return family_;
  }
  /**
   *
   *
   * <pre>
   * What family the OS belong to, if known.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.OperatingSystemFamily family = 2;</code>
   *
   * @return The family.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.OperatingSystemFamily getFamily() {
    com.google.cloud.migrationcenter.v1.OperatingSystemFamily result =
        com.google.cloud.migrationcenter.v1.OperatingSystemFamily.forNumber(family_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.OperatingSystemFamily.UNRECOGNIZED
        : result;
  }

  public static final int VERSION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object version_ = "";
  /**
   *
   *
   * <pre>
   * The version of the operating system.
   * </pre>
   *
   * <code>string version = 3;</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public java.lang.String getVersion() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      version_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The version of the operating system.
   * </pre>
   *
   * <code>string version = 3;</code>
   *
   * @return The bytes for version.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionBytes() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      version_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.migrationcenter.v1.GuestConfigDetails config_;
  /**
   *
   *
   * <pre>
   * OS and app configuration.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails config = 4;</code>
   *
   * @return Whether the config field is set.
   */
  @java.lang.Override
  public boolean hasConfig() {
    return config_ != null;
  }
  /**
   *
   *
   * <pre>
   * OS and app configuration.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails config = 4;</code>
   *
   * @return The config.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.GuestConfigDetails getConfig() {
    return config_ == null
        ? com.google.cloud.migrationcenter.v1.GuestConfigDetails.getDefaultInstance()
        : config_;
  }
  /**
   *
   *
   * <pre>
   * OS and app configuration.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails config = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.GuestConfigDetailsOrBuilder getConfigOrBuilder() {
    return config_ == null
        ? com.google.cloud.migrationcenter.v1.GuestConfigDetails.getDefaultInstance()
        : config_;
  }

  public static final int RUNTIME_FIELD_NUMBER = 5;
  private com.google.cloud.migrationcenter.v1.GuestRuntimeDetails runtime_;
  /**
   *
   *
   * <pre>
   * Runtime information.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.GuestRuntimeDetails runtime = 5;</code>
   *
   * @return Whether the runtime field is set.
   */
  @java.lang.Override
  public boolean hasRuntime() {
    return runtime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Runtime information.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.GuestRuntimeDetails runtime = 5;</code>
   *
   * @return The runtime.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.GuestRuntimeDetails getRuntime() {
    return runtime_ == null
        ? com.google.cloud.migrationcenter.v1.GuestRuntimeDetails.getDefaultInstance()
        : runtime_;
  }
  /**
   *
   *
   * <pre>
   * Runtime information.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.GuestRuntimeDetails runtime = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.GuestRuntimeDetailsOrBuilder getRuntimeOrBuilder() {
    return runtime_ == null
        ? com.google.cloud.migrationcenter.v1.GuestRuntimeDetails.getDefaultInstance()
        : runtime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, osName_);
    }
    if (family_
        != com.google.cloud.migrationcenter.v1.OperatingSystemFamily.OS_FAMILY_UNKNOWN
            .getNumber()) {
      output.writeEnum(2, family_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, version_);
    }
    if (config_ != null) {
      output.writeMessage(4, getConfig());
    }
    if (runtime_ != null) {
      output.writeMessage(5, getRuntime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(osName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, osName_);
    }
    if (family_
        != com.google.cloud.migrationcenter.v1.OperatingSystemFamily.OS_FAMILY_UNKNOWN
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, family_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, version_);
    }
    if (config_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getConfig());
    }
    if (runtime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getRuntime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.GuestOsDetails)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.GuestOsDetails other =
        (com.google.cloud.migrationcenter.v1.GuestOsDetails) obj;

    if (!getOsName().equals(other.getOsName())) return false;
    if (family_ != other.family_) return false;
    if (!getVersion().equals(other.getVersion())) return false;
    if (hasConfig() != other.hasConfig()) return false;
    if (hasConfig()) {
      if (!getConfig().equals(other.getConfig())) return false;
    }
    if (hasRuntime() != other.hasRuntime()) return false;
    if (hasRuntime()) {
      if (!getRuntime().equals(other.getRuntime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + OS_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getOsName().hashCode();
    hash = (37 * hash) + FAMILY_FIELD_NUMBER;
    hash = (53 * hash) + family_;
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion().hashCode();
    if (hasConfig()) {
      hash = (37 * hash) + CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfig().hashCode();
    }
    if (hasRuntime()) {
      hash = (37 * hash) + RUNTIME_FIELD_NUMBER;
      hash = (53 * hash) + getRuntime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.GuestOsDetails parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.GuestOsDetails parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.GuestOsDetails parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.GuestOsDetails parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.GuestOsDetails parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.GuestOsDetails parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.GuestOsDetails parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.GuestOsDetails parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.GuestOsDetails parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.GuestOsDetails parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.GuestOsDetails parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.GuestOsDetails parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.migrationcenter.v1.GuestOsDetails prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Information from Guest-level collections.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.GuestOsDetails}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.GuestOsDetails)
      com.google.cloud.migrationcenter.v1.GuestOsDetailsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_GuestOsDetails_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_GuestOsDetails_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.GuestOsDetails.class,
              com.google.cloud.migrationcenter.v1.GuestOsDetails.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.GuestOsDetails.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      osName_ = "";
      family_ = 0;
      version_ = "";
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      runtime_ = null;
      if (runtimeBuilder_ != null) {
        runtimeBuilder_.dispose();
        runtimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_GuestOsDetails_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.GuestOsDetails getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.GuestOsDetails.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.GuestOsDetails build() {
      com.google.cloud.migrationcenter.v1.GuestOsDetails result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.GuestOsDetails buildPartial() {
      com.google.cloud.migrationcenter.v1.GuestOsDetails result =
          new com.google.cloud.migrationcenter.v1.GuestOsDetails(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.GuestOsDetails result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.osName_ = osName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.family_ = family_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.version_ = version_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.config_ = configBuilder_ == null ? config_ : configBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.runtime_ = runtimeBuilder_ == null ? runtime_ : runtimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.GuestOsDetails) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.GuestOsDetails) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.GuestOsDetails other) {
      if (other == com.google.cloud.migrationcenter.v1.GuestOsDetails.getDefaultInstance())
        return this;
      if (!other.getOsName().isEmpty()) {
        osName_ = other.osName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.family_ != 0) {
        setFamilyValue(other.getFamilyValue());
      }
      if (!other.getVersion().isEmpty()) {
        version_ = other.version_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasConfig()) {
        mergeConfig(other.getConfig());
      }
      if (other.hasRuntime()) {
        mergeRuntime(other.getRuntime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                osName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                family_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                version_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getRuntimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object osName_ = "";
    /**
     *
     *
     * <pre>
     * The name of the operating system.
     * </pre>
     *
     * <code>string os_name = 1;</code>
     *
     * @return The osName.
     */
    public java.lang.String getOsName() {
      java.lang.Object ref = osName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        osName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the operating system.
     * </pre>
     *
     * <code>string os_name = 1;</code>
     *
     * @return The bytes for osName.
     */
    public com.google.protobuf.ByteString getOsNameBytes() {
      java.lang.Object ref = osName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        osName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the operating system.
     * </pre>
     *
     * <code>string os_name = 1;</code>
     *
     * @param value The osName to set.
     * @return This builder for chaining.
     */
    public Builder setOsName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      osName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the operating system.
     * </pre>
     *
     * <code>string os_name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOsName() {
      osName_ = getDefaultInstance().getOsName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the operating system.
     * </pre>
     *
     * <code>string os_name = 1;</code>
     *
     * @param value The bytes for osName to set.
     * @return This builder for chaining.
     */
    public Builder setOsNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      osName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int family_ = 0;
    /**
     *
     *
     * <pre>
     * What family the OS belong to, if known.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.OperatingSystemFamily family = 2;</code>
     *
     * @return The enum numeric value on the wire for family.
     */
    @java.lang.Override
    public int getFamilyValue() {
      return family_;
    }
    /**
     *
     *
     * <pre>
     * What family the OS belong to, if known.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.OperatingSystemFamily family = 2;</code>
     *
     * @param value The enum numeric value on the wire for family to set.
     * @return This builder for chaining.
     */
    public Builder setFamilyValue(int value) {
      family_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * What family the OS belong to, if known.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.OperatingSystemFamily family = 2;</code>
     *
     * @return The family.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.OperatingSystemFamily getFamily() {
      com.google.cloud.migrationcenter.v1.OperatingSystemFamily result =
          com.google.cloud.migrationcenter.v1.OperatingSystemFamily.forNumber(family_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.OperatingSystemFamily.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * What family the OS belong to, if known.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.OperatingSystemFamily family = 2;</code>
     *
     * @param value The family to set.
     * @return This builder for chaining.
     */
    public Builder setFamily(com.google.cloud.migrationcenter.v1.OperatingSystemFamily value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      family_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * What family the OS belong to, if known.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.OperatingSystemFamily family = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFamily() {
      bitField0_ = (bitField0_ & ~0x00000002);
      family_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * The version of the operating system.
     * </pre>
     *
     * <code>string version = 3;</code>
     *
     * @return The version.
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The version of the operating system.
     * </pre>
     *
     * <code>string version = 3;</code>
     *
     * @return The bytes for version.
     */
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The version of the operating system.
     * </pre>
     *
     * <code>string version = 3;</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      version_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The version of the operating system.
     * </pre>
     *
     * <code>string version = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      version_ = getDefaultInstance().getVersion();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The version of the operating system.
     * </pre>
     *
     * <code>string version = 3;</code>
     *
     * @param value The bytes for version to set.
     * @return This builder for chaining.
     */
    public Builder setVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      version_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.migrationcenter.v1.GuestConfigDetails config_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.GuestConfigDetails,
            com.google.cloud.migrationcenter.v1.GuestConfigDetails.Builder,
            com.google.cloud.migrationcenter.v1.GuestConfigDetailsOrBuilder>
        configBuilder_;
    /**
     *
     *
     * <pre>
     * OS and app configuration.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails config = 4;</code>
     *
     * @return Whether the config field is set.
     */
    public boolean hasConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * OS and app configuration.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails config = 4;</code>
     *
     * @return The config.
     */
    public com.google.cloud.migrationcenter.v1.GuestConfigDetails getConfig() {
      if (configBuilder_ == null) {
        return config_ == null
            ? com.google.cloud.migrationcenter.v1.GuestConfigDetails.getDefaultInstance()
            : config_;
      } else {
        return configBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * OS and app configuration.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails config = 4;</code>
     */
    public Builder setConfig(com.google.cloud.migrationcenter.v1.GuestConfigDetails value) {
      if (configBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
      } else {
        configBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OS and app configuration.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails config = 4;</code>
     */
    public Builder setConfig(
        com.google.cloud.migrationcenter.v1.GuestConfigDetails.Builder builderForValue) {
      if (configBuilder_ == null) {
        config_ = builderForValue.build();
      } else {
        configBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OS and app configuration.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails config = 4;</code>
     */
    public Builder mergeConfig(com.google.cloud.migrationcenter.v1.GuestConfigDetails value) {
      if (configBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && config_ != null
            && config_
                != com.google.cloud.migrationcenter.v1.GuestConfigDetails.getDefaultInstance()) {
          getConfigBuilder().mergeFrom(value);
        } else {
          config_ = value;
        }
      } else {
        configBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OS and app configuration.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails config = 4;</code>
     */
    public Builder clearConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * OS and app configuration.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails config = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.GuestConfigDetails.Builder getConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * OS and app configuration.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails config = 4;</code>
     */
    public com.google.cloud.migrationcenter.v1.GuestConfigDetailsOrBuilder getConfigOrBuilder() {
      if (configBuilder_ != null) {
        return configBuilder_.getMessageOrBuilder();
      } else {
        return config_ == null
            ? com.google.cloud.migrationcenter.v1.GuestConfigDetails.getDefaultInstance()
            : config_;
      }
    }
    /**
     *
     *
     * <pre>
     * OS and app configuration.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestConfigDetails config = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.GuestConfigDetails,
            com.google.cloud.migrationcenter.v1.GuestConfigDetails.Builder,
            com.google.cloud.migrationcenter.v1.GuestConfigDetailsOrBuilder>
        getConfigFieldBuilder() {
      if (configBuilder_ == null) {
        configBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.GuestConfigDetails,
                com.google.cloud.migrationcenter.v1.GuestConfigDetails.Builder,
                com.google.cloud.migrationcenter.v1.GuestConfigDetailsOrBuilder>(
                getConfig(), getParentForChildren(), isClean());
        config_ = null;
      }
      return configBuilder_;
    }

    private com.google.cloud.migrationcenter.v1.GuestRuntimeDetails runtime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.GuestRuntimeDetails,
            com.google.cloud.migrationcenter.v1.GuestRuntimeDetails.Builder,
            com.google.cloud.migrationcenter.v1.GuestRuntimeDetailsOrBuilder>
        runtimeBuilder_;
    /**
     *
     *
     * <pre>
     * Runtime information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestRuntimeDetails runtime = 5;</code>
     *
     * @return Whether the runtime field is set.
     */
    public boolean hasRuntime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Runtime information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestRuntimeDetails runtime = 5;</code>
     *
     * @return The runtime.
     */
    public com.google.cloud.migrationcenter.v1.GuestRuntimeDetails getRuntime() {
      if (runtimeBuilder_ == null) {
        return runtime_ == null
            ? com.google.cloud.migrationcenter.v1.GuestRuntimeDetails.getDefaultInstance()
            : runtime_;
      } else {
        return runtimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Runtime information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestRuntimeDetails runtime = 5;</code>
     */
    public Builder setRuntime(com.google.cloud.migrationcenter.v1.GuestRuntimeDetails value) {
      if (runtimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runtime_ = value;
      } else {
        runtimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Runtime information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestRuntimeDetails runtime = 5;</code>
     */
    public Builder setRuntime(
        com.google.cloud.migrationcenter.v1.GuestRuntimeDetails.Builder builderForValue) {
      if (runtimeBuilder_ == null) {
        runtime_ = builderForValue.build();
      } else {
        runtimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Runtime information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestRuntimeDetails runtime = 5;</code>
     */
    public Builder mergeRuntime(com.google.cloud.migrationcenter.v1.GuestRuntimeDetails value) {
      if (runtimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && runtime_ != null
            && runtime_
                != com.google.cloud.migrationcenter.v1.GuestRuntimeDetails.getDefaultInstance()) {
          getRuntimeBuilder().mergeFrom(value);
        } else {
          runtime_ = value;
        }
      } else {
        runtimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Runtime information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestRuntimeDetails runtime = 5;</code>
     */
    public Builder clearRuntime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      runtime_ = null;
      if (runtimeBuilder_ != null) {
        runtimeBuilder_.dispose();
        runtimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Runtime information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestRuntimeDetails runtime = 5;</code>
     */
    public com.google.cloud.migrationcenter.v1.GuestRuntimeDetails.Builder getRuntimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getRuntimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Runtime information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestRuntimeDetails runtime = 5;</code>
     */
    public com.google.cloud.migrationcenter.v1.GuestRuntimeDetailsOrBuilder getRuntimeOrBuilder() {
      if (runtimeBuilder_ != null) {
        return runtimeBuilder_.getMessageOrBuilder();
      } else {
        return runtime_ == null
            ? com.google.cloud.migrationcenter.v1.GuestRuntimeDetails.getDefaultInstance()
            : runtime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Runtime information.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.GuestRuntimeDetails runtime = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.GuestRuntimeDetails,
            com.google.cloud.migrationcenter.v1.GuestRuntimeDetails.Builder,
            com.google.cloud.migrationcenter.v1.GuestRuntimeDetailsOrBuilder>
        getRuntimeFieldBuilder() {
      if (runtimeBuilder_ == null) {
        runtimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.GuestRuntimeDetails,
                com.google.cloud.migrationcenter.v1.GuestRuntimeDetails.Builder,
                com.google.cloud.migrationcenter.v1.GuestRuntimeDetailsOrBuilder>(
                getRuntime(), getParentForChildren(), isClean());
        runtime_ = null;
      }
      return runtimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.GuestOsDetails)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.GuestOsDetails)
  private static final com.google.cloud.migrationcenter.v1.GuestOsDetails DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.GuestOsDetails();
  }

  public static com.google.cloud.migrationcenter.v1.GuestOsDetails getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GuestOsDetails> PARSER =
      new com.google.protobuf.AbstractParser<GuestOsDetails>() {
        @java.lang.Override
        public GuestOsDetails parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GuestOsDetails> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GuestOsDetails> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.GuestOsDetails getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
