/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

package com.google.cloud.migrationcenter.v1;

/**
 *
 *
 * <pre>
 * A resource that represents a payload file in an import job.
 * </pre>
 *
 * Protobuf type {@code google.cloud.migrationcenter.v1.ImportDataFile}
 */
public final class ImportDataFile extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.migrationcenter.v1.ImportDataFile)
    ImportDataFileOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportDataFile.newBuilder() to construct.
  private ImportDataFile(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportDataFile() {
    name_ = "";
    displayName_ = "";
    format_ = 0;
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportDataFile();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_ImportDataFile_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.migrationcenter.v1.MigrationCenterProto
        .internal_static_google_cloud_migrationcenter_v1_ImportDataFile_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.migrationcenter.v1.ImportDataFile.class,
            com.google.cloud.migrationcenter.v1.ImportDataFile.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Enumerates possible states of an import data file.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.migrationcenter.v1.ImportDataFile.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The data file is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The data file completed initialization.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    ACTIVE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The data file is being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The data file completed initialization.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    public static final int ACTIVE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return ACTIVE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.ImportDataFile.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.migrationcenter.v1.ImportDataFile.State)
  }

  private int fileInfoCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object fileInfo_;

  public enum FileInfoCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    UPLOAD_FILE_INFO(5),
    FILEINFO_NOT_SET(0);
    private final int value;

    private FileInfoCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FileInfoCase valueOf(int value) {
      return forNumber(value);
    }

    public static FileInfoCase forNumber(int value) {
      switch (value) {
        case 5:
          return UPLOAD_FILE_INFO;
        case 0:
          return FILEINFO_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FileInfoCase getFileInfoCase() {
    return FileInfoCase.forNumber(fileInfoCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of the file.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the file.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * User-friendly display name. Maximum length is 63 characters.
   * </pre>
   *
   * <code>string display_name = 6;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User-friendly display name. Maximum length is 63 characters.
   * </pre>
   *
   * <code>string display_name = 6;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FORMAT_FIELD_NUMBER = 2;
  private int format_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The payload format.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.ImportJobFormat format = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for format.
   */
  @java.lang.Override
  public int getFormatValue() {
    return format_;
  }
  /**
   *
   *
   * <pre>
   * Required. The payload format.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.ImportJobFormat format = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The format.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ImportJobFormat getFormat() {
    com.google.cloud.migrationcenter.v1.ImportJobFormat result =
        com.google.cloud.migrationcenter.v1.ImportJobFormat.forNumber(format_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.ImportJobFormat.UNRECOGNIZED
        : result;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the file was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the file was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when the file was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of the import data file.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.ImportDataFile.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of the import data file.
   * </pre>
   *
   * <code>
   * .google.cloud.migrationcenter.v1.ImportDataFile.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ImportDataFile.State getState() {
    com.google.cloud.migrationcenter.v1.ImportDataFile.State result =
        com.google.cloud.migrationcenter.v1.ImportDataFile.State.forNumber(state_);
    return result == null
        ? com.google.cloud.migrationcenter.v1.ImportDataFile.State.UNRECOGNIZED
        : result;
  }

  public static final int UPLOAD_FILE_INFO_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Information about a file that is uploaded to a storage service.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.UploadFileInfo upload_file_info = 5;</code>
   *
   * @return Whether the uploadFileInfo field is set.
   */
  @java.lang.Override
  public boolean hasUploadFileInfo() {
    return fileInfoCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Information about a file that is uploaded to a storage service.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.UploadFileInfo upload_file_info = 5;</code>
   *
   * @return The uploadFileInfo.
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.UploadFileInfo getUploadFileInfo() {
    if (fileInfoCase_ == 5) {
      return (com.google.cloud.migrationcenter.v1.UploadFileInfo) fileInfo_;
    }
    return com.google.cloud.migrationcenter.v1.UploadFileInfo.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Information about a file that is uploaded to a storage service.
   * </pre>
   *
   * <code>.google.cloud.migrationcenter.v1.UploadFileInfo upload_file_info = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.UploadFileInfoOrBuilder getUploadFileInfoOrBuilder() {
    if (fileInfoCase_ == 5) {
      return (com.google.cloud.migrationcenter.v1.UploadFileInfo) fileInfo_;
    }
    return com.google.cloud.migrationcenter.v1.UploadFileInfo.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (format_
        != com.google.cloud.migrationcenter.v1.ImportJobFormat.IMPORT_JOB_FORMAT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, format_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (state_
        != com.google.cloud.migrationcenter.v1.ImportDataFile.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, state_);
    }
    if (fileInfoCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.migrationcenter.v1.UploadFileInfo) fileInfo_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, displayName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (format_
        != com.google.cloud.migrationcenter.v1.ImportJobFormat.IMPORT_JOB_FORMAT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, format_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (state_
        != com.google.cloud.migrationcenter.v1.ImportDataFile.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (fileInfoCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.migrationcenter.v1.UploadFileInfo) fileInfo_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, displayName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.migrationcenter.v1.ImportDataFile)) {
      return super.equals(obj);
    }
    com.google.cloud.migrationcenter.v1.ImportDataFile other =
        (com.google.cloud.migrationcenter.v1.ImportDataFile) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (format_ != other.format_) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getFileInfoCase().equals(other.getFileInfoCase())) return false;
    switch (fileInfoCase_) {
      case 5:
        if (!getUploadFileInfo().equals(other.getUploadFileInfo())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + format_;
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    switch (fileInfoCase_) {
      case 5:
        hash = (37 * hash) + UPLOAD_FILE_INFO_FIELD_NUMBER;
        hash = (53 * hash) + getUploadFileInfo().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.migrationcenter.v1.ImportDataFile parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ImportDataFile parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ImportDataFile parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ImportDataFile parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ImportDataFile parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.migrationcenter.v1.ImportDataFile parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ImportDataFile parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ImportDataFile parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ImportDataFile parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ImportDataFile parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.migrationcenter.v1.ImportDataFile parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.migrationcenter.v1.ImportDataFile parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.migrationcenter.v1.ImportDataFile prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A resource that represents a payload file in an import job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.migrationcenter.v1.ImportDataFile}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.migrationcenter.v1.ImportDataFile)
      com.google.cloud.migrationcenter.v1.ImportDataFileOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ImportDataFile_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ImportDataFile_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.migrationcenter.v1.ImportDataFile.class,
              com.google.cloud.migrationcenter.v1.ImportDataFile.Builder.class);
    }

    // Construct using com.google.cloud.migrationcenter.v1.ImportDataFile.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      format_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      state_ = 0;
      if (uploadFileInfoBuilder_ != null) {
        uploadFileInfoBuilder_.clear();
      }
      fileInfoCase_ = 0;
      fileInfo_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.migrationcenter.v1.MigrationCenterProto
          .internal_static_google_cloud_migrationcenter_v1_ImportDataFile_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ImportDataFile getDefaultInstanceForType() {
      return com.google.cloud.migrationcenter.v1.ImportDataFile.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ImportDataFile build() {
      com.google.cloud.migrationcenter.v1.ImportDataFile result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ImportDataFile buildPartial() {
      com.google.cloud.migrationcenter.v1.ImportDataFile result =
          new com.google.cloud.migrationcenter.v1.ImportDataFile(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.migrationcenter.v1.ImportDataFile result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.format_ = format_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.state_ = state_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.migrationcenter.v1.ImportDataFile result) {
      result.fileInfoCase_ = fileInfoCase_;
      result.fileInfo_ = this.fileInfo_;
      if (fileInfoCase_ == 5 && uploadFileInfoBuilder_ != null) {
        result.fileInfo_ = uploadFileInfoBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.migrationcenter.v1.ImportDataFile) {
        return mergeFrom((com.google.cloud.migrationcenter.v1.ImportDataFile) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.migrationcenter.v1.ImportDataFile other) {
      if (other == com.google.cloud.migrationcenter.v1.ImportDataFile.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.format_ != 0) {
        setFormatValue(other.getFormatValue());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      switch (other.getFileInfoCase()) {
        case UPLOAD_FILE_INFO:
          {
            mergeUploadFileInfo(other.getUploadFileInfo());
            break;
          }
        case FILEINFO_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                format_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 32:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getUploadFileInfoFieldBuilder().getBuilder(), extensionRegistry);
                fileInfoCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int fileInfoCase_ = 0;
    private java.lang.Object fileInfo_;

    public FileInfoCase getFileInfoCase() {
      return FileInfoCase.forNumber(fileInfoCase_);
    }

    public Builder clearFileInfo() {
      fileInfoCase_ = 0;
      fileInfo_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the file.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the file.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the file.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the file.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the file.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * User-friendly display name. Maximum length is 63 characters.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-friendly display name. Maximum length is 63 characters.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-friendly display name. Maximum length is 63 characters.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-friendly display name. Maximum length is 63 characters.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-friendly display name. Maximum length is 63 characters.
     * </pre>
     *
     * <code>string display_name = 6;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int format_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The payload format.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ImportJobFormat format = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for format.
     */
    @java.lang.Override
    public int getFormatValue() {
      return format_;
    }
    /**
     *
     *
     * <pre>
     * Required. The payload format.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ImportJobFormat format = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for format to set.
     * @return This builder for chaining.
     */
    public Builder setFormatValue(int value) {
      format_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The payload format.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ImportJobFormat format = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The format.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ImportJobFormat getFormat() {
      com.google.cloud.migrationcenter.v1.ImportJobFormat result =
          com.google.cloud.migrationcenter.v1.ImportJobFormat.forNumber(format_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.ImportJobFormat.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The payload format.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ImportJobFormat format = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The format to set.
     * @return This builder for chaining.
     */
    public Builder setFormat(com.google.cloud.migrationcenter.v1.ImportJobFormat value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      format_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The payload format.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ImportJobFormat format = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFormat() {
      bitField0_ = (bitField0_ & ~0x00000004);
      format_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the file was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the file was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the file was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the file was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the file was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the file was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the file was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the file was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when the file was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of the import data file.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ImportDataFile.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the import data file.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ImportDataFile.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the import data file.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ImportDataFile.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.ImportDataFile.State getState() {
      com.google.cloud.migrationcenter.v1.ImportDataFile.State result =
          com.google.cloud.migrationcenter.v1.ImportDataFile.State.forNumber(state_);
      return result == null
          ? com.google.cloud.migrationcenter.v1.ImportDataFile.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the import data file.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ImportDataFile.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.migrationcenter.v1.ImportDataFile.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the import data file.
     * </pre>
     *
     * <code>
     * .google.cloud.migrationcenter.v1.ImportDataFile.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.UploadFileInfo,
            com.google.cloud.migrationcenter.v1.UploadFileInfo.Builder,
            com.google.cloud.migrationcenter.v1.UploadFileInfoOrBuilder>
        uploadFileInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Information about a file that is uploaded to a storage service.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.UploadFileInfo upload_file_info = 5;</code>
     *
     * @return Whether the uploadFileInfo field is set.
     */
    @java.lang.Override
    public boolean hasUploadFileInfo() {
      return fileInfoCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Information about a file that is uploaded to a storage service.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.UploadFileInfo upload_file_info = 5;</code>
     *
     * @return The uploadFileInfo.
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.UploadFileInfo getUploadFileInfo() {
      if (uploadFileInfoBuilder_ == null) {
        if (fileInfoCase_ == 5) {
          return (com.google.cloud.migrationcenter.v1.UploadFileInfo) fileInfo_;
        }
        return com.google.cloud.migrationcenter.v1.UploadFileInfo.getDefaultInstance();
      } else {
        if (fileInfoCase_ == 5) {
          return uploadFileInfoBuilder_.getMessage();
        }
        return com.google.cloud.migrationcenter.v1.UploadFileInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about a file that is uploaded to a storage service.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.UploadFileInfo upload_file_info = 5;</code>
     */
    public Builder setUploadFileInfo(com.google.cloud.migrationcenter.v1.UploadFileInfo value) {
      if (uploadFileInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fileInfo_ = value;
        onChanged();
      } else {
        uploadFileInfoBuilder_.setMessage(value);
      }
      fileInfoCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about a file that is uploaded to a storage service.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.UploadFileInfo upload_file_info = 5;</code>
     */
    public Builder setUploadFileInfo(
        com.google.cloud.migrationcenter.v1.UploadFileInfo.Builder builderForValue) {
      if (uploadFileInfoBuilder_ == null) {
        fileInfo_ = builderForValue.build();
        onChanged();
      } else {
        uploadFileInfoBuilder_.setMessage(builderForValue.build());
      }
      fileInfoCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about a file that is uploaded to a storage service.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.UploadFileInfo upload_file_info = 5;</code>
     */
    public Builder mergeUploadFileInfo(com.google.cloud.migrationcenter.v1.UploadFileInfo value) {
      if (uploadFileInfoBuilder_ == null) {
        if (fileInfoCase_ == 5
            && fileInfo_
                != com.google.cloud.migrationcenter.v1.UploadFileInfo.getDefaultInstance()) {
          fileInfo_ =
              com.google.cloud.migrationcenter.v1.UploadFileInfo.newBuilder(
                      (com.google.cloud.migrationcenter.v1.UploadFileInfo) fileInfo_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          fileInfo_ = value;
        }
        onChanged();
      } else {
        if (fileInfoCase_ == 5) {
          uploadFileInfoBuilder_.mergeFrom(value);
        } else {
          uploadFileInfoBuilder_.setMessage(value);
        }
      }
      fileInfoCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about a file that is uploaded to a storage service.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.UploadFileInfo upload_file_info = 5;</code>
     */
    public Builder clearUploadFileInfo() {
      if (uploadFileInfoBuilder_ == null) {
        if (fileInfoCase_ == 5) {
          fileInfoCase_ = 0;
          fileInfo_ = null;
          onChanged();
        }
      } else {
        if (fileInfoCase_ == 5) {
          fileInfoCase_ = 0;
          fileInfo_ = null;
        }
        uploadFileInfoBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Information about a file that is uploaded to a storage service.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.UploadFileInfo upload_file_info = 5;</code>
     */
    public com.google.cloud.migrationcenter.v1.UploadFileInfo.Builder getUploadFileInfoBuilder() {
      return getUploadFileInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Information about a file that is uploaded to a storage service.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.UploadFileInfo upload_file_info = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.migrationcenter.v1.UploadFileInfoOrBuilder
        getUploadFileInfoOrBuilder() {
      if ((fileInfoCase_ == 5) && (uploadFileInfoBuilder_ != null)) {
        return uploadFileInfoBuilder_.getMessageOrBuilder();
      } else {
        if (fileInfoCase_ == 5) {
          return (com.google.cloud.migrationcenter.v1.UploadFileInfo) fileInfo_;
        }
        return com.google.cloud.migrationcenter.v1.UploadFileInfo.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Information about a file that is uploaded to a storage service.
     * </pre>
     *
     * <code>.google.cloud.migrationcenter.v1.UploadFileInfo upload_file_info = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.migrationcenter.v1.UploadFileInfo,
            com.google.cloud.migrationcenter.v1.UploadFileInfo.Builder,
            com.google.cloud.migrationcenter.v1.UploadFileInfoOrBuilder>
        getUploadFileInfoFieldBuilder() {
      if (uploadFileInfoBuilder_ == null) {
        if (!(fileInfoCase_ == 5)) {
          fileInfo_ = com.google.cloud.migrationcenter.v1.UploadFileInfo.getDefaultInstance();
        }
        uploadFileInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.migrationcenter.v1.UploadFileInfo,
                com.google.cloud.migrationcenter.v1.UploadFileInfo.Builder,
                com.google.cloud.migrationcenter.v1.UploadFileInfoOrBuilder>(
                (com.google.cloud.migrationcenter.v1.UploadFileInfo) fileInfo_,
                getParentForChildren(),
                isClean());
        fileInfo_ = null;
      }
      fileInfoCase_ = 5;
      onChanged();
      return uploadFileInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.migrationcenter.v1.ImportDataFile)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.migrationcenter.v1.ImportDataFile)
  private static final com.google.cloud.migrationcenter.v1.ImportDataFile DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.migrationcenter.v1.ImportDataFile();
  }

  public static com.google.cloud.migrationcenter.v1.ImportDataFile getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportDataFile> PARSER =
      new com.google.protobuf.AbstractParser<ImportDataFile>() {
        @java.lang.Override
        public ImportDataFile parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportDataFile> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportDataFile> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.migrationcenter.v1.ImportDataFile getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
